/*
MySQL Data Transfer
Source Host: localhost
Source Database: sampledb
Target Host: localhost
Target Database: sampledb
Date: 16.11.2010 10:42:14
*/

SET FOREIGN_KEY_CHECKS=0;
-- ----------------------------
-- Table structure for actions_table
-- ----------------------------
CREATE TABLE `actions_table` (
  `id` int(11) NOT NULL auto_increment,
  `dataId` int(11) NOT NULL,
  `type` varchar(255) NOT NULL,
  `user` varchar(255) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Table structure for countries
-- ----------------------------
CREATE TABLE `countries` (
  `item_id` int(10) unsigned NOT NULL auto_increment,
  `item_nm` varchar(200) default NULL,
  `item_cd` varchar(15) default NULL,
  `item_ch` int(11) NOT NULL,
  PRIMARY KEY  (`item_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Table structure for country_data
-- ----------------------------
CREATE TABLE `country_data` (
  `country_id` int(11) NOT NULL auto_increment,
  `name` varchar(255) NOT NULL,
  `full_name` varchar(255) NOT NULL,
  `type` varchar(255) NOT NULL,
  `subtype` varchar(255) NOT NULL,
  `sovereignty` varchar(255) NOT NULL,
  `capital` varchar(255) NOT NULL,
  `currency_code` char(3) NOT NULL,
  `currency_name` varchar(20) NOT NULL,
  `phone_code` char(8) NOT NULL,
  `letter_code` char(3) NOT NULL,
  `letter_code_alt` char(3) NOT NULL,
  `iso_number` char(3) NOT NULL,
  `code` varchar(4) NOT NULL,
  PRIMARY KEY  (`country_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Table structure for developers2
-- ----------------------------
CREATE TABLE `developers2` (
  `developer_id` int(11) NOT NULL auto_increment,
  `developer_name` varchar(255) NOT NULL,
  `developer_team` int(11) NOT NULL,
  `developer_email` varchar(255) NOT NULL,
  PRIMARY KEY  (`developer_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for events
-- ----------------------------
CREATE TABLE `events` (
  `event_id` int(11) NOT NULL auto_increment,
  `event_name` varchar(127) NOT NULL,
  `start_date` datetime NOT NULL,
  `end_date` datetime NOT NULL,
  `details` text NOT NULL,
  PRIMARY KEY  (`event_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Table structure for events_rec
-- ----------------------------
CREATE TABLE `events_rec` (
  `event_id` int(11) NOT NULL auto_increment,
  `start_date` datetime NOT NULL,
  `end_date` datetime NOT NULL,
  `text` varchar(255) NOT NULL,
  `rec_type` varchar(64) NOT NULL,
  `event_pid` int(11) NOT NULL,
  `event_length` int(11) NOT NULL,
  PRIMARY KEY  (`event_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Table structure for events_shared
-- ----------------------------
CREATE TABLE `events_shared` (
  `event_id` int(11) NOT NULL auto_increment,
  `start_date` datetime NOT NULL,
  `end_date` datetime NOT NULL,
  `text` varchar(255) character set utf8 collate utf8_bin NOT NULL,
  `event_type` int(11) NOT NULL default '0',
  `userId` int(11) NOT NULL,
  PRIMARY KEY  (`event_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Table structure for grid50
-- ----------------------------
CREATE TABLE `grid50` (
  `item_id` int(10) unsigned NOT NULL auto_increment,
  `item_nm` varchar(200) default NULL,
  `item_cd` varchar(15) default NULL,
  PRIMARY KEY  (`item_id`),
  KEY `XPKGRID50NM` (`item_nm`),
  KEY `XPKGRID50CD` (`item_cd`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Table structure for grid50000
-- ----------------------------
CREATE TABLE `grid50000` (
  `item_id` int(11) NOT NULL auto_increment,
  `item_nm` varchar(255) NOT NULL,
  `item_cd` varchar(255) NOT NULL,
  PRIMARY KEY  (`item_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Table structure for packages_plain
-- ----------------------------
CREATE TABLE `packages_plain` (
  `Id` int(11) NOT NULL auto_increment,
  `Package` varchar(250) collate utf8_bin NOT NULL,
  `Priority` varchar(250) collate utf8_bin NOT NULL,
  `Section` varchar(250) collate utf8_bin NOT NULL,
  `Installed-Size` varchar(250) collate utf8_bin NOT NULL,
  `Maintainer` varchar(250) collate utf8_bin NOT NULL,
  `Architecture` varchar(250) collate utf8_bin NOT NULL,
  `Source` varchar(250) collate utf8_bin NOT NULL,
  `Version` varchar(250) collate utf8_bin NOT NULL,
  `Filename` varchar(250) collate utf8_bin NOT NULL,
  `Size` varchar(250) collate utf8_bin NOT NULL,
  `Description` varchar(250) collate utf8_bin NOT NULL,
  `Homepage` varchar(250) collate utf8_bin NOT NULL,
  PRIMARY KEY  (`Id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Table structure for packages_small
-- ----------------------------
CREATE TABLE `packages_small` (
  `Id` int(11) NOT NULL auto_increment,
  `Package` varchar(250) collate utf8_bin default NULL,
  `Priority` varchar(250) collate utf8_bin default NULL,
  `Section` varchar(250) collate utf8_bin default NULL,
  `Installed-Size` varchar(250) collate utf8_bin default NULL,
  `Maintainer` varchar(250) collate utf8_bin default NULL,
  `Architecture` varchar(250) collate utf8_bin default NULL,
  `Source` varchar(250) collate utf8_bin default NULL,
  `Version` varchar(250) collate utf8_bin default NULL,
  `Filename` varchar(250) collate utf8_bin default NULL,
  `Size` varchar(250) collate utf8_bin default NULL,
  `Description` varchar(250) collate utf8_bin default NULL,
  `Homepage` varchar(250) collate utf8_bin default NULL,
  PRIMARY KEY  (`Id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Table structure for phones2
-- ----------------------------
CREATE TABLE `phones2` (
  `phone_id` int(11) NOT NULL auto_increment,
  `phone` varchar(255) NOT NULL,
  `phone_developer` int(11) NOT NULL,
  `phone_type` varchar(255) NOT NULL,
  PRIMARY KEY  (`phone_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for products2
-- ----------------------------
CREATE TABLE `products2` (
  `id` int(11) NOT NULL auto_increment,
  `product_name` varchar(255) NOT NULL,
  `category` varchar(255) NOT NULL,
  `scales` int(11) NOT NULL,
  `colour` varchar(255) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for project_team2
-- ----------------------------
CREATE TABLE `project_team2` (
  `id` int(11) NOT NULL auto_increment,
  `project_id` int(11) NOT NULL,
  `team_id` int(11) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Table structure for projects2
-- ----------------------------
CREATE TABLE `projects2` (
  `project_id` int(11) NOT NULL auto_increment,
  `project_name` varchar(255) NOT NULL,
  `project_dsc` text NOT NULL,
  PRIMARY KEY  (`project_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for tasks
-- ----------------------------
CREATE TABLE `tasks` (
  `taskId` int(11) NOT NULL auto_increment,
  `parentId` int(11) default '0',
  `taskName` varchar(250) default NULL,
  `duration` float(9,1) default '0.0',
  `work` float(9,1) default '0.0',
  `start` date default NULL,
  `finish` date default NULL,
  `complete` int(11) default '0',
  `predecessors` varchar(100) default NULL,
  `resource` varchar(100) default NULL,
  PRIMARY KEY  (`taskId`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Table structure for teams2
-- ----------------------------
CREATE TABLE `teams2` (
  `team_id` int(11) NOT NULL auto_increment,
  `team_name` varchar(255) NOT NULL,
  PRIMARY KEY  (`team_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for tevents
-- ----------------------------
CREATE TABLE `tevents` (
  `event_id` int(11) NOT NULL auto_increment,
  `event_name` varchar(127) NOT NULL,
  `start_date` datetime NOT NULL,
  `end_date` datetime NOT NULL,
  `type` int(11) NOT NULL,
  PRIMARY KEY  (`event_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Table structure for types
-- ----------------------------
CREATE TABLE `types` (
  `typeid` int(11) NOT NULL auto_increment,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY  (`typeid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Table structure for without_key
-- ----------------------------
CREATE TABLE `without_key` (
  `uid` varchar(255) default NULL,
  `name` varchar(255) default NULL,
  `value` int(11) default NULL,
  `id` int(11) NOT NULL auto_increment,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records 
-- ----------------------------
INSERT INTO `actions_table` VALUES ('27', '8415', 'updated', '');
INSERT INTO `actions_table` VALUES ('28', '8415', 'updated', '');
INSERT INTO `actions_table` VALUES ('29', '8415', 'updated', '1284734136106');
INSERT INTO `actions_table` VALUES ('30', '8415', 'updated', '1284734124634');
INSERT INTO `actions_table` VALUES ('31', '8419', 'inserted', '1284734136106');
INSERT INTO `actions_table` VALUES ('32', '8419', 'updated', '1284734124634');
INSERT INTO `actions_table` VALUES ('33', '8419', 'deleted', '1284734136106');
INSERT INTO `actions_table` VALUES ('34', '8415', 'deleted', '1284734124634');
INSERT INTO `actions_table` VALUES ('35', '8418', 'deleted', '1284738578782');
INSERT INTO `actions_table` VALUES ('36', '1000', 'updated', '1284971098347');
INSERT INTO `actions_table` VALUES ('37', '1000', 'updated', '1284971250648');
INSERT INTO `actions_table` VALUES ('38', '8412', 'inserted', '1284971250648');
INSERT INTO `actions_table` VALUES ('39', '1000', 'updated', '1284971250648');
INSERT INTO `actions_table` VALUES ('40', '1000', 'deleted', '1284971340272');
INSERT INTO `actions_table` VALUES ('41', '1001', 'deleted', '1284971340272');
INSERT INTO `actions_table` VALUES ('42', '1002', 'updated', '1284971340272');
INSERT INTO `actions_table` VALUES ('43', '1002', 'updated', '1284980601198');
INSERT INTO `actions_table` VALUES ('44', '1002', 'updated', '1284980690922');
INSERT INTO `actions_table` VALUES ('45', '1002', 'deleted', '1284980690922');
INSERT INTO `actions_table` VALUES ('46', '85', 'updated', '1285085975830');
INSERT INTO `actions_table` VALUES ('47', '88', 'inserted', '1285085975830');
INSERT INTO `actions_table` VALUES ('48', '88', 'deleted', '1285085975830');
INSERT INTO `actions_table` VALUES ('49', '2', 'updated', '1285160759724');
INSERT INTO `actions_table` VALUES ('50', '2', 'updated', '1285160751914');
INSERT INTO `actions_table` VALUES ('51', '61', 'inserted', '1285160759724');
INSERT INTO `actions_table` VALUES ('52', '61', 'updated', '1285160759724');
INSERT INTO `actions_table` VALUES ('53', '61', 'updated', '1285160759724');
INSERT INTO `actions_table` VALUES ('54', '61', 'deleted', '1285160759724');
INSERT INTO `countries` VALUES ('1', 'Afghanistan ', '293141', '1');
INSERT INTO `countries` VALUES ('2', 'Albania ', '553524', '0');
INSERT INTO `countries` VALUES ('3', 'Algeria ', '727298', '0');
INSERT INTO `countries` VALUES ('4', 'Andorra ', '804756', '0');
INSERT INTO `countries` VALUES ('5', 'Angola ', '376164', '0');
INSERT INTO `countries` VALUES ('6', 'Antigua and Barbuda ', '366907', '0');
INSERT INTO `countries` VALUES ('7', 'Argentina ', '316613', '0');
INSERT INTO `countries` VALUES ('8', 'Armenia ', '816466', '0');
INSERT INTO `countries` VALUES ('9', 'Australia ', '410238', '0');
INSERT INTO `countries` VALUES ('10', 'Austria ', '894267', '0');
INSERT INTO `countries` VALUES ('11', 'Azerbaijan ', '815701', '0');
INSERT INTO `countries` VALUES ('12', 'Bahamas ', '610438', '0');
INSERT INTO `countries` VALUES ('13', 'Bahrain ', '908482', '0');
INSERT INTO `countries` VALUES ('14', 'Bangladesh ', '164149', '0');
INSERT INTO `countries` VALUES ('15', 'Barbados ', '793231', '0');
INSERT INTO `countries` VALUES ('16', 'Belarus ', '591765', '0');
INSERT INTO `countries` VALUES ('17', 'Belgium ', '223516', '0');
INSERT INTO `countries` VALUES ('18', 'Belize ', '958196', '0');
INSERT INTO `countries` VALUES ('19', 'Benin ', '978371', '0');
INSERT INTO `countries` VALUES ('20', 'Bhutan ', '733443', '0');
INSERT INTO `countries` VALUES ('21', 'Bolivia ', '596856', '0');
INSERT INTO `countries` VALUES ('22', 'Bosnia and Herzegovina ', '440752', '0');
INSERT INTO `countries` VALUES ('23', 'Botswana ', '803991', '0');
INSERT INTO `countries` VALUES ('24', 'Brazil ', '576364', '0');
INSERT INTO `countries` VALUES ('25', 'Brunei ', '381122', '0');
INSERT INTO `countries` VALUES ('26', 'Bulgaria ', '529261', '0');
INSERT INTO `countries` VALUES ('27', 'Burkina Faso ', '135060', '0');
INSERT INTO `countries` VALUES ('28', 'Burundi ', '957721', '0');
INSERT INTO `countries` VALUES ('29', 'Cambodia ', '953633', '0');
INSERT INTO `countries` VALUES ('30', 'Cameroon ', '980666', '0');
INSERT INTO `countries` VALUES ('31', 'Canada ', '132844', '0');
INSERT INTO `countries` VALUES ('32', 'Cape Verde ', '554210', '0');
INSERT INTO `countries` VALUES ('33', 'Central African Republic ', '667008', '0');
INSERT INTO `countries` VALUES ('34', 'Chad ', '255612', '0');
INSERT INTO `countries` VALUES ('35', 'Chile ', '662314', '0');
INSERT INTO `countries` VALUES ('36', 'China ', '203024', '0');
INSERT INTO `countries` VALUES ('37', 'Colombia ', '898566', '0');
INSERT INTO `countries` VALUES ('38', 'Comoros ', '703641', '0');
INSERT INTO `countries` VALUES ('39', 'Congo (Brazzaville) ', '292139', '0');
INSERT INTO `countries` VALUES ('40', 'Congo, Democratic Republic of the ', '309255', '0');
INSERT INTO `countries` VALUES ('41', 'Costa Rica ', '865124', '0');
INSERT INTO `countries` VALUES ('42', 'Croatia ', '615686', '0');
INSERT INTO `countries` VALUES ('43', 'Cuba ', '845898', '0');
INSERT INTO `countries` VALUES ('44', 'Cyprus ', '215604', '0');
INSERT INTO `countries` VALUES ('45', 'Czech Republic ', '257827', '0');
INSERT INTO `countries` VALUES ('46', 'Denmark ', '201626', '0');
INSERT INTO `countries` VALUES ('47', 'Djibouti ', '489648', '0');
INSERT INTO `countries` VALUES ('48', 'Dominica ', '759420', '0');
INSERT INTO `countries` VALUES ('49', 'Dominican Republic ', '174171', '0');
INSERT INTO `countries` VALUES ('50', 'East Timor (Timor Timur) ', '643325', '0');
INSERT INTO `countries` VALUES ('51', 'Ecuador ', '941897', '0');
INSERT INTO `countries` VALUES ('52', 'Egypt ', '417095', '0');
INSERT INTO `countries` VALUES ('53', 'El Salvador ', '291374', '0');
INSERT INTO `countries` VALUES ('54', 'Equatorial Guinea ', '509455', '0');
INSERT INTO `countries` VALUES ('55', 'Eritrea ', '879340', '0');
INSERT INTO `countries` VALUES ('56', 'Estonia ', '133847', '0');
INSERT INTO `countries` VALUES ('57', 'Ethiopia ', '798479', '0');
INSERT INTO `countries` VALUES ('58', 'Fiji ', '529182', '0');
INSERT INTO `countries` VALUES ('59', 'Finland ', '274970', '0');
INSERT INTO `countries` VALUES ('60', 'France ', '422792', '0');
INSERT INTO `countries` VALUES ('61', 'Gabon ', '588231', '0');
INSERT INTO `countries` VALUES ('62', 'Gambia, The ', '135376', '0');
INSERT INTO `countries` VALUES ('63', 'Georgia ', '398080', '0');
INSERT INTO `countries` VALUES ('64', 'Germany ', '500751', '0');
INSERT INTO `countries` VALUES ('65', 'Ghana ', '713874', '0');
INSERT INTO `countries` VALUES ('66', 'Greece ', '921405', '0');
INSERT INTO `countries` VALUES ('67', 'Grenada ', '357465', '0');
INSERT INTO `countries` VALUES ('68', 'Guatemala ', '880843', '0');
INSERT INTO `countries` VALUES ('69', 'Guinea ', '932350', '0');
INSERT INTO `countries` VALUES ('70', 'Guinea-Bissau ', '591739', '0');
INSERT INTO `countries` VALUES ('71', 'Guyana ', '558219', '0');
INSERT INTO `countries` VALUES ('72', 'Haiti ', '779886', '0');
INSERT INTO `countries` VALUES ('73', 'Honduras ', '568504', '0');
INSERT INTO `countries` VALUES ('74', 'Hungary ', '739746', '0');
INSERT INTO `countries` VALUES ('75', 'Iceland ', '973334', '0');
INSERT INTO `countries` VALUES ('76', 'India ', '710999', '0');
INSERT INTO `countries` VALUES ('77', 'Indonesia ', '243480', '0');
INSERT INTO `countries` VALUES ('78', 'Iran ', '798294', '0');
INSERT INTO `countries` VALUES ('79', 'Iraq ', '279506', '0');
INSERT INTO `countries` VALUES ('80', 'Ireland ', '755201', '0');
INSERT INTO `countries` VALUES ('81', 'Israel ', '146321', '0');
INSERT INTO `countries` VALUES ('82', 'Italy ', '632354', '0');
INSERT INTO `countries` VALUES ('83', 'Jamaica ', '178127', '0');
INSERT INTO `countries` VALUES ('84', 'Japan ', '561410', '0');
INSERT INTO `countries` VALUES ('85', 'Jordan ', '898170', '0');
INSERT INTO `countries` VALUES ('86', 'Kazakhstan ', '538993', '0');
INSERT INTO `countries` VALUES ('87', 'Kenya ', '210092', '0');
INSERT INTO `countries` VALUES ('88', 'Kiribati ', '210645', '0');
INSERT INTO `countries` VALUES ('89', 'Korea, North ', '959672', '0');
INSERT INTO `countries` VALUES ('90', 'Korea, South ', '383179', '0');
INSERT INTO `countries` VALUES ('91', 'Kuwait ', '348393', '0');
INSERT INTO `countries` VALUES ('92', 'Kyrgyzstan ', '216026', '0');
INSERT INTO `countries` VALUES ('93', 'Laos ', '951971', '0');
INSERT INTO `countries` VALUES ('94', 'Latvia ', '461983', '0');
INSERT INTO `countries` VALUES ('95', 'Lebanon ', '133926', '0');
INSERT INTO `countries` VALUES ('96', 'Lesotho ', '658569', '0');
INSERT INTO `countries` VALUES ('97', 'Liberia ', '199912', '0');
INSERT INTO `countries` VALUES ('98', 'Libya ', '640371', '0');
INSERT INTO `countries` VALUES ('99', 'Liechtenstein ', '403882', '0');
INSERT INTO `countries` VALUES ('100', 'Lithuania ', '322996', '0');
INSERT INTO `countries` VALUES ('101', 'Luxembourg ', '188835', '0');
INSERT INTO `countries` VALUES ('102', 'Macedonia', '351215', '0');
INSERT INTO `countries` VALUES ('103', 'Madagascar ', '699157', '0');
INSERT INTO `countries` VALUES ('104', 'Malawi ', '154523', '0');
INSERT INTO `countries` VALUES ('105', 'Malaysia ', '243586', '0');
INSERT INTO `countries` VALUES ('106', 'Maldives ', '323681', '0');
INSERT INTO `countries` VALUES ('107', 'Mali ', '128546', '0');
INSERT INTO `countries` VALUES ('108', 'Malta ', '666270', '0');
INSERT INTO `countries` VALUES ('109', 'Marshall Islands ', '985307', '0');
INSERT INTO `countries` VALUES ('110', 'Mauritania ', '854839', '0');
INSERT INTO `countries` VALUES ('111', 'Mauritius ', '825538', '0');
INSERT INTO `countries` VALUES ('112', 'Mexico ', '210856', '0');
INSERT INTO `countries` VALUES ('113', 'Micronesia, Federated States of ', '874645', '0');
INSERT INTO `countries` VALUES ('114', 'Moldova ', '945457', '0');
INSERT INTO `countries` VALUES ('115', 'Monaco ', '170532', '0');
INSERT INTO `countries` VALUES ('116', 'Mongolia ', '165600', '0');
INSERT INTO `countries` VALUES ('117', 'Montenegro ', '532742', '0');
INSERT INTO `countries` VALUES ('118', 'Morocco ', '892605', '0');
INSERT INTO `countries` VALUES ('119', 'Mozambique ', '297018', '0');
INSERT INTO `countries` VALUES ('120', 'Myanmar (Burma) ', '611519', '1');
INSERT INTO `countries` VALUES ('121', 'Namibia ', '148642', '0');
INSERT INTO `countries` VALUES ('122', 'Nauru ', '561252', '0');
INSERT INTO `countries` VALUES ('123', 'Nepal ', '313791', '0');
INSERT INTO `countries` VALUES ('124', 'Netherlands ', '333334', '0');
INSERT INTO `countries` VALUES ('125', 'New Zealand ', '343488', '0');
INSERT INTO `countries` VALUES ('126', 'Nicaragua ', '248465', '0');
INSERT INTO `countries` VALUES ('127', 'Niger ', '625945', '0');
INSERT INTO `countries` VALUES ('128', 'Nigeria ', '276262', '0');
INSERT INTO `countries` VALUES ('129', 'Norway ', '442124', '0');
INSERT INTO `countries` VALUES ('130', 'Oman ', '683413', '0');
INSERT INTO `countries` VALUES ('131', 'Pakistan ', '342274', '0');
INSERT INTO `countries` VALUES ('132', 'Palau ', '953422', '0');
INSERT INTO `countries` VALUES ('133', 'Panama ', '201494', '0');
INSERT INTO `countries` VALUES ('134', 'Papua New Guinea ', '434765', '0');
INSERT INTO `countries` VALUES ('135', 'Paraguay ', '732071', '0');
INSERT INTO `countries` VALUES ('136', 'Peru ', '717434', '0');
INSERT INTO `countries` VALUES ('137', 'Philippines ', '674841', '0');
INSERT INTO `countries` VALUES ('138', 'Poland ', '231691', '0');
INSERT INTO `countries` VALUES ('139', 'Portugal ', '904130', '0');
INSERT INTO `countries` VALUES ('140', 'Qatar ', '945616', '0');
INSERT INTO `countries` VALUES ('141', 'Romania ', '754910', '0');
INSERT INTO `countries` VALUES ('142', 'Russia ', '371259', '0');
INSERT INTO `countries` VALUES ('143', 'Rwanda ', '399346', '0');
INSERT INTO `countries` VALUES ('144', 'Saint Kitts and Nevis ', '854786', '0');
INSERT INTO `countries` VALUES ('145', 'Saint Lucia ', '630745', '0');
INSERT INTO `countries` VALUES ('146', 'Saint Vincent and The Grenadines ', '718436', '0');
INSERT INTO `countries` VALUES ('147', 'Samoa ', '919110', '0');
INSERT INTO `countries` VALUES ('148', 'San Marino ', '958064', '0');
INSERT INTO `countries` VALUES ('149', 'Sao Tome and Principe ', '923488', '0');
INSERT INTO `countries` VALUES ('150', 'Saudi Arabia ', '706094', '0');
INSERT INTO `countries` VALUES ('151', 'Senegal ', '275919', '0');
INSERT INTO `countries` VALUES ('152', 'Serbia ', '472268', '0');
INSERT INTO `countries` VALUES ('153', 'Seychelles ', '957985', '0');
INSERT INTO `countries` VALUES ('154', 'Sierra Leone ', '199200', '0');
INSERT INTO `countries` VALUES ('155', 'Singapore ', '171165', '0');
INSERT INTO `countries` VALUES ('156', 'Slovakia ', '774717', '0');
INSERT INTO `countries` VALUES ('157', 'Slovenia ', '491178', '0');
INSERT INTO `countries` VALUES ('158', 'Solomon Islands ', '359021', '0');
INSERT INTO `countries` VALUES ('159', 'Somalia ', '145741', '0');
INSERT INTO `countries` VALUES ('160', 'South Africa ', '218030', '0');
INSERT INTO `countries` VALUES ('161', 'Spain ', '576311', '0');
INSERT INTO `countries` VALUES ('162', 'Sri Lanka ', '186329', '0');
INSERT INTO `countries` VALUES ('163', 'Sudan ', '172642', '0');
INSERT INTO `countries` VALUES ('164', 'Suriname ', '179525', '0');
INSERT INTO `countries` VALUES ('165', 'Swaziland ', '970327', '0');
INSERT INTO `countries` VALUES ('166', 'Sweden ', '842391', '0');
INSERT INTO `countries` VALUES ('167', 'Switzerland ', '656960', '0');
INSERT INTO `countries` VALUES ('168', 'Syria ', '740221', '0');
INSERT INTO `countries` VALUES ('169', 'Taiwan ', '133873', '0');
INSERT INTO `countries` VALUES ('170', 'Tajikistan ', '463776', '0');
INSERT INTO `countries` VALUES ('171', 'Tanzania ', '707491', '0');
INSERT INTO `countries` VALUES ('172', 'Thailand ', '684837', '0');
INSERT INTO `countries` VALUES ('173', 'Togo ', '416489', '0');
INSERT INTO `countries` VALUES ('174', 'Tonga ', '211753', '0');
INSERT INTO `countries` VALUES ('175', 'Trinidad and Tobago ', '729328', '0');
INSERT INTO `countries` VALUES ('176', 'Tunisia ', '958591', '0');
INSERT INTO `countries` VALUES ('177', 'Turkey ', '278820', '0');
INSERT INTO `countries` VALUES ('178', 'Turkmenistan ', '815490', '0');
INSERT INTO `countries` VALUES ('179', 'Tuvalu ', '695465', '0');
INSERT INTO `countries` VALUES ('180', 'Uganda ', '346204', '0');
INSERT INTO `countries` VALUES ('181', 'Ukraine ', '342011', '0');
INSERT INTO `countries` VALUES ('182', 'United Arab Emirates ', '843656', '0');
INSERT INTO `countries` VALUES ('183', 'United Kingdom ', '146796', '0');
INSERT INTO `countries` VALUES ('184', 'United States ', '657092', '0');
INSERT INTO `countries` VALUES ('185', 'Uruguay ', '795103', '0');
INSERT INTO `countries` VALUES ('186', 'Uzbekistan ', '161222', '0');
INSERT INTO `countries` VALUES ('187', 'Vanuatu ', '784712', '0');
INSERT INTO `countries` VALUES ('188', 'Vatican City ', '675975', '0');
INSERT INTO `countries` VALUES ('189', 'Venezuela ', '530843', '0');
INSERT INTO `countries` VALUES ('190', 'Vietnam ', '793653', '0');
INSERT INTO `countries` VALUES ('191', 'Western Sahara ', '421711', '0');
INSERT INTO `countries` VALUES ('192', 'Yemen ', '483872', '0');
INSERT INTO `countries` VALUES ('193', 'Zambia ', '602473', '0');
INSERT INTO `countries` VALUES ('194', 'Zimbabwe ', '877520', '0');
INSERT INTO `countries` VALUES ('195', '', '759183', '0');
INSERT INTO `country_data` VALUES ('1', 'Afghanistan', 'Islamic State of Afghanistan', 'Independent State', '', '', 'Kabul', 'AFN', 'Afghani', '+93', 'AF', 'AFG', '004', '.af');
INSERT INTO `country_data` VALUES ('2', 'Albania', 'Republic of Albania', 'Independent State', '', '', 'Tirana', 'ALL', 'Lek', '+355', 'AL', 'ALB', '008', '.al');
INSERT INTO `country_data` VALUES ('3', 'Algeria', 'People\'s Democratic Republic of Algeria', 'Independent State', '', '', 'Algiers', 'DZD', 'Dinar', '+213', 'DZ', 'DZA', '012', '.dz');
INSERT INTO `country_data` VALUES ('4', 'Andorra', 'Principality of Andorra', 'Independent State', '', '', 'Andorra la Vella', 'EUR', 'Euro', '+376', 'AD', 'AND', '020', '.ad');
INSERT INTO `country_data` VALUES ('5', 'Angola', 'Republic of Angola', 'Independent State', '', '', 'Luanda', 'AOA', 'Kwanza', '+244', 'AO', 'AGO', '024', '.ao');
INSERT INTO `country_data` VALUES ('6', 'Antigua and Barbuda', '', 'Independent State', '', '', 'Saint John\'s', 'XCD', 'Dollar', '+1-268', 'AG', 'ATG', '028', '.ag');
INSERT INTO `country_data` VALUES ('7', 'Argentina', 'Argentine Republic', 'Independent State', '', '', 'Buenos Aires', 'ARS', 'Peso', '+54', 'AR', 'ARG', '032', '.ar');
INSERT INTO `country_data` VALUES ('8', 'Armenia', 'Republic of Armenia', 'Independent State', '', '', 'Yerevan', 'AMD', 'Dram', '+374', 'AM', 'ARM', '051', '.am');
INSERT INTO `country_data` VALUES ('9', 'Australia', 'Commonwealth of Australia', 'Independent State', '', '', 'Canberra', 'AUD', 'Dollar', '+61', 'AU', 'AUS', '036', '.au');
INSERT INTO `country_data` VALUES ('10', 'Austria', 'Republic of Austria', 'Independent State', '', '', 'Vienna', 'EUR', 'Euro', '+43', 'AT', 'AUT', '040', '.at');
INSERT INTO `country_data` VALUES ('11', 'Azerbaijan', 'Republic of Azerbaijan', 'Independent State', '', '', 'Baku', 'AZN', 'Manat', '+994', 'AZ', 'AZE', '031', '.az');
INSERT INTO `country_data` VALUES ('12', 'Bahamas, The', 'Commonwealth of The Bahamas', 'Independent State', '', '', 'Nassau', 'BSD', 'Dollar', '+1-242', 'BS', 'BHS', '044', '.bs');
INSERT INTO `country_data` VALUES ('13', 'Bahrain', 'Kingdom of Bahrain', 'Independent State', '', '', 'Manama', 'BHD', 'Dinar', '+973', 'BH', 'BHR', '048', '.bh');
INSERT INTO `country_data` VALUES ('14', 'Bangladesh', 'People\'s Republic of Bangladesh', 'Independent State', '', '', 'Dhaka', 'BDT', 'Taka', '+880', 'BD', 'BGD', '050', '.bd');
INSERT INTO `country_data` VALUES ('15', 'Barbados', '', 'Independent State', '', '', 'Bridgetown', 'BBD', 'Dollar', '+1-246', 'BB', 'BRB', '052', '.bb');
INSERT INTO `country_data` VALUES ('16', 'Belarus', 'Republic of Belarus', 'Independent State', '', '', 'Minsk', 'BYR', 'Ruble', '+375', 'BY', 'BLR', '112', '.by');
INSERT INTO `country_data` VALUES ('17', 'Belgium', 'Kingdom of Belgium', 'Independent State', '', '', 'Brussels', 'EUR', 'Euro', '+32', 'BE', 'BEL', '056', '.be');
INSERT INTO `country_data` VALUES ('18', 'Belize', '', 'Independent State', '', '', 'Belmopan', 'BZD', 'Dollar', '+501', 'BZ', 'BLZ', '084', '.bz');
INSERT INTO `country_data` VALUES ('19', 'Benin', 'Republic of Benin', 'Independent State', '', '', 'Porto-Novo', 'XOF', 'Franc', '+229', 'BJ', 'BEN', '204', '.bj');
INSERT INTO `country_data` VALUES ('20', 'Bhutan', 'Kingdom of Bhutan', 'Independent State', '', '', 'Thimphu', 'BTN', 'Ngultrum', '+975', 'BT', 'BTN', '064', '.bt');
INSERT INTO `country_data` VALUES ('21', 'Bolivia', 'Republic of Bolivia', 'Independent State', '', '', 'La Paz (administrative/legislative) and Sucre (judical)', 'BOB', 'Boliviano', '+591', 'BO', 'BOL', '068', '.bo');
INSERT INTO `country_data` VALUES ('22', 'Bosnia and Herzegovina', '', 'Independent State', '', '', 'Sarajevo', 'BAM', 'Marka', '+387', 'BA', 'BIH', '070', '.ba');
INSERT INTO `country_data` VALUES ('23', 'Botswana', 'Republic of Botswana', 'Independent State', '', '', 'Gaborone', 'BWP', 'Pula', '+267', 'BW', 'BWA', '072', '.bw');
INSERT INTO `country_data` VALUES ('24', 'Brazil', 'Federative Republic of Brazil', 'Independent State', '', '', 'Brasilia', 'BRL', 'Real', '+55', 'BR', 'BRA', '076', '.br');
INSERT INTO `country_data` VALUES ('25', 'Brunei', 'Negara Brunei Darussalam', 'Independent State', '', '', 'Bandar Seri Begawan', 'BND', 'Dollar', '+673', 'BN', 'BRN', '096', '.bn');
INSERT INTO `country_data` VALUES ('26', 'Bulgaria', 'Republic of Bulgaria', 'Independent State', '', '', 'Sofia', 'BGN', 'Lev', '+359', 'BG', 'BGR', '100', '.bg');
INSERT INTO `country_data` VALUES ('27', 'Burkina Faso', '', 'Independent State', '', '', 'Ouagadougou', 'XOF', 'Franc', '+226', 'BF', 'BFA', '854', '.bf');
INSERT INTO `country_data` VALUES ('28', 'Burundi', 'Republic of Burundi', 'Independent State', '', '', 'Bujumbura', 'BIF', 'Franc', '+257', 'BI', 'BDI', '108', '.bi');
INSERT INTO `country_data` VALUES ('29', 'Cambodia', 'Kingdom of Cambodia', 'Independent State', '', '', 'Phnom Penh', 'KHR', 'Riels', '+855', 'KH', 'KHM', '116', '.kh');
INSERT INTO `country_data` VALUES ('30', 'Cameroon', 'Republic of Cameroon', 'Independent State', '', '', 'Yaounde', 'XAF', 'Franc', '+237', 'CM', 'CMR', '120', '.cm');
INSERT INTO `country_data` VALUES ('31', 'Canada', '', 'Independent State', '', '', 'Ottawa', 'CAD', 'Dollar', '+1', 'CA', 'CAN', '124', '.ca');
INSERT INTO `country_data` VALUES ('32', 'Cape Verde', 'Republic of Cape Verde', 'Independent State', '', '', 'Praia', 'CVE', 'Escudo', '+238', 'CV', 'CPV', '132', '.cv');
INSERT INTO `country_data` VALUES ('33', 'Central African Republic', '', 'Independent State', '', '', 'Bangui', 'XAF', 'Franc', '+236', 'CF', 'CAF', '140', '.cf');
INSERT INTO `country_data` VALUES ('34', 'Chad', 'Republic of Chad', 'Independent State', '', '', 'N\'Djamena', 'XAF', 'Franc', '+235', 'TD', 'TCD', '148', '.td');
INSERT INTO `country_data` VALUES ('35', 'Chile', 'Republic of Chile', 'Independent State', '', '', 'Santiago (administrative/judical) and Valparaiso (legislative)', 'CLP', 'Peso', '+56', 'CL', 'CHL', '152', '.cl');
INSERT INTO `country_data` VALUES ('36', 'China, People\'s Republic of', 'People\'s Republic of China', 'Independent State', '', '', 'Beijing', 'CNY', 'Yuan Renminbi', '+86', 'CN', 'CHN', '156', '.cn');
INSERT INTO `country_data` VALUES ('37', 'Colombia', 'Republic of Colombia', 'Independent State', '', '', 'Bogota', 'COP', 'Peso', '+57', 'CO', 'COL', '170', '.co');
INSERT INTO `country_data` VALUES ('38', 'Comoros', 'Union of Comoros', 'Independent State', '', '', 'Moroni', 'KMF', 'Franc', '+269', 'KM', 'COM', '174', '.km');
INSERT INTO `country_data` VALUES ('39', 'Congo, Democratic Republic of the (Congo ? Kinshasa)', 'Democratic Republic of the Congo', 'Independent State', '', '', 'Kinshasa', 'CDF', 'Franc', '+243', 'CD', 'COD', '180', '.cd');
INSERT INTO `country_data` VALUES ('40', 'Congo, Republic of the (Congo ? Brazzaville)', 'Republic of the Congo', 'Independent State', '', '', 'Brazzaville', 'XAF', 'Franc', '+242', 'CG', 'COG', '178', '.cg');
INSERT INTO `country_data` VALUES ('41', 'Costa Rica', 'Republic of Costa Rica', 'Independent State', '', '', 'San Jose', 'CRC', 'Colon', '+506', 'CR', 'CRI', '188', '.cr');
INSERT INTO `country_data` VALUES ('42', 'Cote d\'Ivoire (Ivory Coast)', 'Republic of Cote d\'Ivoire', 'Independent State', '', '', 'Yamoussoukro', 'XOF', 'Franc', '+225', 'CI', 'CIV', '384', '.ci');
INSERT INTO `country_data` VALUES ('43', 'Croatia', 'Republic of Croatia', 'Independent State', '', '', 'Zagreb', 'HRK', 'Kuna', '+385', 'HR', 'HRV', '191', '.hr');
INSERT INTO `country_data` VALUES ('44', 'Cuba', 'Republic of Cuba', 'Independent State', '', '', 'Havana', 'CUP', 'Peso', '+53', 'CU', 'CUB', '192', '.cu');
INSERT INTO `country_data` VALUES ('45', 'Cyprus', 'Republic of Cyprus', 'Independent State', '', '', 'Nicosia', 'CYP', 'Pound', '+357', 'CY', 'CYP', '196', '.cy');
INSERT INTO `country_data` VALUES ('46', 'Czech Republic', '', 'Independent State', '', '', 'Prague', 'CZK', 'Koruna', '+420', 'CZ', 'CZE', '203', '.cz');
INSERT INTO `country_data` VALUES ('47', 'Denmark', 'Kingdom of Denmark', 'Independent State', '', '', 'Copenhagen', 'DKK', 'Krone', '+45', 'DK', 'DNK', '208', '.dk');
INSERT INTO `country_data` VALUES ('48', 'Djibouti', 'Republic of Djibouti', 'Independent State', '', '', 'Djibouti', 'DJF', 'Franc', '+253', 'DJ', 'DJI', '262', '.dj');
INSERT INTO `country_data` VALUES ('49', 'Dominica', 'Commonwealth of Dominica', 'Independent State', '', '', 'Roseau', 'XCD', 'Dollar', '+1-767', 'DM', 'DMA', '212', '.dm');
INSERT INTO `country_data` VALUES ('50', 'Dominican Republic', '', 'Independent State', '', '', 'Santo Domingo', 'DOP', 'Peso', '+1-809 a', 'DO', 'DOM', '214', '.do');
INSERT INTO `country_data` VALUES ('51', 'Ecuador', 'Republic of Ecuador', 'Independent State', '', '', 'Quito', 'USD', 'Dollar', '+593', 'EC', 'ECU', '218', '.ec');
INSERT INTO `country_data` VALUES ('52', 'Egypt', 'Arab Republic of Egypt', 'Independent State', '', '', 'Cairo', 'EGP', 'Pound', '+20', 'EG', 'EGY', '818', '.eg');
INSERT INTO `country_data` VALUES ('53', 'El Salvador', 'Republic of El Salvador', 'Independent State', '', '', 'San Salvador', 'USD', 'Dollar', '+503', 'SV', 'SLV', '222', '.sv');
INSERT INTO `country_data` VALUES ('54', 'Equatorial Guinea', 'Republic of Equatorial Guinea', 'Independent State', '', '', 'Malabo', 'XAF', 'Franc', '+240', 'GQ', 'GNQ', '226', '.gq');
INSERT INTO `country_data` VALUES ('55', 'Eritrea', 'State of Eritrea', 'Independent State', '', '', 'Asmara', 'ERN', 'Nakfa', '+291', 'ER', 'ERI', '232', '.er');
INSERT INTO `country_data` VALUES ('56', 'Estonia', 'Republic of Estonia', 'Independent State', '', '', 'Tallinn', 'EEK', 'Kroon', '+372', 'EE', 'EST', '233', '.ee');
INSERT INTO `country_data` VALUES ('57', 'Ethiopia', 'Federal Democratic Republic of Ethiopia', 'Independent State', '', '', 'Addis Ababa', 'ETB', 'Birr', '+251', 'ET', 'ETH', '231', '.et');
INSERT INTO `country_data` VALUES ('58', 'Fiji', 'Republic of the Fiji Islands', 'Independent State', '', '', 'Suva', 'FJD', 'Dollar', '+679', 'FJ', 'FJI', '242', '.fj');
INSERT INTO `country_data` VALUES ('59', 'Finland', 'Republic of Finland', 'Independent State', '', '', 'Helsinki', 'EUR', 'Euro', '+358', 'FI', 'FIN', '246', '.fi');
INSERT INTO `country_data` VALUES ('60', 'France', 'French Republic', 'Independent State', '', '', 'Paris', 'EUR', 'Euro', '+33', 'FR', 'FRA', '250', '.fr');
INSERT INTO `country_data` VALUES ('61', 'Gabon', 'Gabonese Republic', 'Independent State', '', '', 'Libreville', 'XAF', 'Franc', '+241', 'GA', 'GAB', '266', '.ga');
INSERT INTO `country_data` VALUES ('62', 'Gambia, The', 'Republic of The Gambia', 'Independent State', '', '', 'Banjul', 'GMD', 'Dalasi', '+220', 'GM', 'GMB', '270', '.gm');
INSERT INTO `country_data` VALUES ('63', 'Georgia', 'Republic of Georgia', 'Independent State', '', '', 'Tbilisi', 'GEL', 'Lari', '+995', 'GE', 'GEO', '268', '.ge');
INSERT INTO `country_data` VALUES ('64', 'Germany', 'Federal Republic of Germany', 'Independent State', '', '', 'Berlin', 'EUR', 'Euro', '+49', 'DE', 'DEU', '276', '.de');
INSERT INTO `country_data` VALUES ('65', 'Ghana', 'Republic of Ghana', 'Independent State', '', '', 'Accra', 'GHS', 'Cedi', '+233', 'GH', 'GHA', '288', '.gh');
INSERT INTO `country_data` VALUES ('66', 'Greece', 'Hellenic Republic', 'Independent State', '', '', 'Athens', 'EUR', 'Euro', '+30', 'GR', 'GRC', '300', '.gr');
INSERT INTO `country_data` VALUES ('67', 'Grenada', '', 'Independent State', '', '', 'Saint George\'s', 'XCD', 'Dollar', '+1-473', 'GD', 'GRD', '308', '.gd');
INSERT INTO `country_data` VALUES ('68', 'Guatemala', 'Republic of Guatemala', 'Independent State', '', '', 'Guatemala', 'GTQ', 'Quetzal', '+502', 'GT', 'GTM', '320', '.gt');
INSERT INTO `country_data` VALUES ('69', 'Guinea', 'Republic of Guinea', 'Independent State', '', '', 'Conakry', 'GNF', 'Franc', '+224', 'GN', 'GIN', '324', '.gn');
INSERT INTO `country_data` VALUES ('70', 'Guinea-Bissau', 'Republic of Guinea-Bissau', 'Independent State', '', '', 'Bissau', 'XOF', 'Franc', '+245', 'GW', 'GNB', '624', '.gw');
INSERT INTO `country_data` VALUES ('71', 'Guyana', 'Co-operative Republic of Guyana', 'Independent State', '', '', 'Georgetown', 'GYD', 'Dollar', '+592', 'GY', 'GUY', '328', '.gy');
INSERT INTO `country_data` VALUES ('72', 'Haiti', 'Republic of Haiti', 'Independent State', '', '', 'Port-au-Prince', 'HTG', 'Gourde', '+509', 'HT', 'HTI', '332', '.ht');
INSERT INTO `country_data` VALUES ('73', 'Honduras', 'Republic of Honduras', 'Independent State', '', '', 'Tegucigalpa', 'HNL', 'Lempira', '+504', 'HN', 'HND', '340', '.hn');
INSERT INTO `country_data` VALUES ('74', 'Hungary', 'Republic of Hungary', 'Independent State', '', '', 'Budapest', 'HUF', 'Forint', '+36', 'HU', 'HUN', '348', '.hu');
INSERT INTO `country_data` VALUES ('75', 'Iceland', 'Republic of Iceland', 'Independent State', '', '', 'Reykjavik', 'ISK', 'Krona', '+354', 'IS', 'ISL', '352', '.is');
INSERT INTO `country_data` VALUES ('76', 'India', 'Republic of India', 'Independent State', '', '', 'New Delhi', 'INR', 'Rupee', '+91', 'IN', 'IND', '356', '.in');
INSERT INTO `country_data` VALUES ('77', 'Indonesia', 'Republic of Indonesia', 'Independent State', '', '', 'Jakarta', 'IDR', 'Rupiah', '+62', 'ID', 'IDN', '360', '.id');
INSERT INTO `country_data` VALUES ('78', 'Iran', 'Islamic Republic of Iran', 'Independent State', '', '', 'Tehran', 'IRR', 'Rial', '+98', 'IR', 'IRN', '364', '.ir');
INSERT INTO `country_data` VALUES ('79', 'Iraq', 'Republic of Iraq', 'Independent State', '', '', 'Baghdad', 'IQD', 'Dinar', '+964', 'IQ', 'IRQ', '368', '.iq');
INSERT INTO `country_data` VALUES ('80', 'Ireland', '', 'Independent State', '', '', 'Dublin', 'EUR', 'Euro', '+353', 'IE', 'IRL', '372', '.ie');
INSERT INTO `country_data` VALUES ('81', 'Israel', 'State of Israel', 'Independent State', '', '', 'Jerusalem', 'ILS', 'Shekel', '+972', 'IL', 'ISR', '376', '.il');
INSERT INTO `country_data` VALUES ('82', 'Italy', 'Italian Republic', 'Independent State', '', '', 'Rome', 'EUR', 'Euro', '+39', 'IT', 'ITA', '380', '.it');
INSERT INTO `country_data` VALUES ('83', 'Jamaica', '', 'Independent State', '', '', 'Kingston', 'JMD', 'Dollar', '+1-876', 'JM', 'JAM', '388', '.jm');
INSERT INTO `country_data` VALUES ('84', 'Japan', '', 'Independent State', '', '', 'Tokyo', 'JPY', 'Yen', '+81', 'JP', 'JPN', '392', '.jp');
INSERT INTO `country_data` VALUES ('85', 'Jordan', 'Hashemite Kingdom of Jordan', 'Independent State', '', '', 'Amman', 'JOD', 'Dinar', '+962', 'JO', 'JOR', '400', '.jo');
INSERT INTO `country_data` VALUES ('86', 'Kazakhstan', 'Republic of Kazakhstan', 'Independent State', '', '', 'Astana', 'KZT', 'Tenge', '+7', 'KZ', 'KAZ', '398', '.kz');
INSERT INTO `country_data` VALUES ('87', 'Kenya', 'Republic of Kenya', 'Independent State', '', '', 'Nairobi', 'KES', 'Shilling', '+254', 'KE', 'KEN', '404', '.ke');
INSERT INTO `country_data` VALUES ('88', 'Kiribati', 'Republic of Kiribati', 'Independent State', '', '', 'Tarawa', 'AUD', 'Dollar', '+686', 'KI', 'KIR', '296', '.ki');
INSERT INTO `country_data` VALUES ('89', 'Korea, Democratic People\'s Republic of (North Korea)', 'Democratic People\'s Republic of Korea', 'Independent State', '', '', 'Pyongyang', 'KPW', 'Won', '+850', 'KP', 'PRK', '408', '.kp');
INSERT INTO `country_data` VALUES ('90', 'Korea, Republic of  (South Korea)', 'Republic of Korea', 'Independent State', '', '', 'Seoul', 'KRW', 'Won', '+82', 'KR', 'KOR', '410', '.kr');
INSERT INTO `country_data` VALUES ('91', 'Kuwait', 'State of Kuwait', 'Independent State', '', '', 'Kuwait', 'KWD', 'Dinar', '+965', 'KW', 'KWT', '414', '.kw');
INSERT INTO `country_data` VALUES ('92', 'Kyrgyzstan', 'Kyrgyz Republic', 'Independent State', '', '', 'Bishkek', 'KGS', 'Som', '+996', 'KG', 'KGZ', '417', '.kg');
INSERT INTO `country_data` VALUES ('93', 'Laos', 'Lao People\'s Democratic Republic', 'Independent State', '', '', 'Vientiane', 'LAK', 'Kip', '+856', 'LA', 'LAO', '418', '.la');
INSERT INTO `country_data` VALUES ('94', 'Latvia', 'Republic of Latvia', 'Independent State', '', '', 'Riga', 'LVL', 'Lat', '+371', 'LV', 'LVA', '428', '.lv');
INSERT INTO `country_data` VALUES ('95', 'Lebanon', 'Lebanese Republic', 'Independent State', '', '', 'Beirut', 'LBP', 'Pound', '+961', 'LB', 'LBN', '422', '.lb');
INSERT INTO `country_data` VALUES ('96', 'Lesotho', 'Kingdom of Lesotho', 'Independent State', '', '', 'Maseru', 'LSL', 'Loti', '+266', 'LS', 'LSO', '426', '.ls');
INSERT INTO `country_data` VALUES ('97', 'Liberia', 'Republic of Liberia', 'Independent State', '', '', 'Monrovia', 'LRD', 'Dollar', '+231', 'LR', 'LBR', '430', '.lr');
INSERT INTO `country_data` VALUES ('98', 'Libya', 'Great Socialist People\'s Libyan Arab Jamahiriya', 'Independent State', '', '', 'Tripoli', 'LYD', 'Dinar', '+218', 'LY', 'LBY', '434', '.ly');
INSERT INTO `country_data` VALUES ('99', 'Liechtenstein', 'Principality of Liechtenstein', 'Independent State', '', '', 'Vaduz', 'CHF', 'Franc', '+423', 'LI', 'LIE', '438', '.li');
INSERT INTO `country_data` VALUES ('100', 'Lithuania', 'Republic of Lithuania', 'Independent State', '', '', 'Vilnius', 'LTL', 'Litas', '+370', 'LT', 'LTU', '440', '.lt');
INSERT INTO `country_data` VALUES ('101', 'Luxembourg', 'Grand Duchy of Luxembourg', 'Independent State', '', '', 'Luxembourg', 'EUR', 'Euro', '+352', 'LU', 'LUX', '442', '.lu');
INSERT INTO `country_data` VALUES ('102', 'Macedonia', 'Republic of Macedonia', 'Independent State', '', '', 'Skopje', 'MKD', 'Denar', '+389', 'MK', 'MKD', '807', '.mk');
INSERT INTO `country_data` VALUES ('103', 'Madagascar', 'Republic of Madagascar', 'Independent State', '', '', 'Antananarivo', 'MGA', 'Ariary', '+261', 'MG', 'MDG', '450', '.mg');
INSERT INTO `country_data` VALUES ('104', 'Malawi', 'Republic of Malawi', 'Independent State', '', '', 'Lilongwe', 'MWK', 'Kwacha', '+265', 'MW', 'MWI', '454', '.mw');
INSERT INTO `country_data` VALUES ('105', 'Malaysia', '', 'Independent State', '', '', 'Kuala Lumpur (legislative/judical) and Putrajaya (administrative)', 'MYR', 'Ringgit', '+60', 'MY', 'MYS', '458', '.my');
INSERT INTO `country_data` VALUES ('106', 'Maldives', 'Republic of Maldives', 'Independent State', '', '', 'Male', 'MVR', 'Rufiyaa', '+960', 'MV', 'MDV', '462', '.mv');
INSERT INTO `country_data` VALUES ('107', 'Mali', 'Republic of Mali', 'Independent State', '', '', 'Bamako', 'XOF', 'Franc', '+223', 'ML', 'MLI', '466', '.ml');
INSERT INTO `country_data` VALUES ('108', 'Malta', 'Republic of Malta', 'Independent State', '', '', 'Valletta', 'MTL', 'Lira', '+356', 'MT', 'MLT', '470', '.mt');
INSERT INTO `country_data` VALUES ('109', 'Marshall Islands', 'Republic of the Marshall Islands', 'Independent State', '', '', 'Majuro', 'USD', 'Dollar', '+692', 'MH', 'MHL', '584', '.mh');
INSERT INTO `country_data` VALUES ('110', 'Mauritania', 'Islamic Republic of Mauritania', 'Independent State', '', '', 'Nouakchott', 'MRO', 'Ouguiya', '+222', 'MR', 'MRT', '478', '.mr');
INSERT INTO `country_data` VALUES ('111', 'Mauritius', 'Republic of Mauritius', 'Independent State', '', '', 'Port Louis', 'MUR', 'Rupee', '+230', 'MU', 'MUS', '480', '.mu');
INSERT INTO `country_data` VALUES ('112', 'Mexico', 'United Mexican States', 'Independent State', '', '', 'Mexico', 'MXN', 'Peso', '+52', 'MX', 'MEX', '484', '.mx');
INSERT INTO `country_data` VALUES ('113', 'Micronesia', 'Federated States of Micronesia', 'Independent State', '', '', 'Palikir', 'USD', 'Dollar', '+691', 'FM', 'FSM', '583', '.fm');
INSERT INTO `country_data` VALUES ('114', 'Moldova', 'Republic of Moldova', 'Independent State', '', '', 'Chisinau', 'MDL', 'Leu', '+373', 'MD', 'MDA', '498', '.md');
INSERT INTO `country_data` VALUES ('115', 'Monaco', 'Principality of Monaco', 'Independent State', '', '', 'Monaco', 'EUR', 'Euro', '+377', 'MC', 'MCO', '492', '.mc');
INSERT INTO `country_data` VALUES ('116', 'Mongolia', '', 'Independent State', '', '', 'Ulaanbaatar', 'MNT', 'Tugrik', '+976', 'MN', 'MNG', '496', '.mn');
INSERT INTO `country_data` VALUES ('117', 'Montenegro', 'Republic of Montenegro', 'Independent State', '', '', 'Podgorica', 'EUR', 'Euro', '+382', 'ME', 'MNE', '499', '.me ');
INSERT INTO `country_data` VALUES ('118', 'Morocco', 'Kingdom of Morocco', 'Independent State', '', '', 'Rabat', 'MAD', 'Dirham', '+212', 'MA', 'MAR', '504', '.ma');
INSERT INTO `country_data` VALUES ('119', 'Mozambique', 'Republic of Mozambique', 'Independent State', '', '', 'Maputo', 'MZM', 'Meticail', '+258', 'MZ', 'MOZ', '508', '.mz');
INSERT INTO `country_data` VALUES ('120', 'Myanmar (Burma)', 'Union of Myanmar', 'Independent State', '', '', 'Naypyidaw', 'MMK', 'Kyat', '+95', 'MM', 'MMR', '104', '.mm');
INSERT INTO `country_data` VALUES ('121', 'Namibia', 'Republic of Namibia', 'Independent State', '', '', 'Windhoek', 'NAD', 'Dollar', '+264', 'NA', 'NAM', '516', '.na');
INSERT INTO `country_data` VALUES ('122', 'Nauru', 'Republic of Nauru', 'Independent State', '', '', 'Yaren', 'AUD', 'Dollar', '+674', 'NR', 'NRU', '520', '.nr');
INSERT INTO `country_data` VALUES ('123', 'Nepal', '', 'Independent State', '', '', 'Kathmandu', 'NPR', 'Rupee', '+977', 'NP', 'NPL', '524', '.np');
INSERT INTO `country_data` VALUES ('124', 'Netherlands', 'Kingdom of the Netherlands', 'Independent State', '', '', 'Amsterdam (administrative) and The Hague (legislative/judical)', 'EUR', 'Euro', '+31', 'NL', 'NLD', '528', '.nl');
INSERT INTO `country_data` VALUES ('125', 'New Zealand', '', 'Independent State', '', '', 'Wellington', 'NZD', 'Dollar', '+64', 'NZ', 'NZL', '554', '.nz');
INSERT INTO `country_data` VALUES ('126', 'Nicaragua', 'Republic of Nicaragua', 'Independent State', '', '', 'Managua', 'NIO', 'Cordoba', '+505', 'NI', 'NIC', '558', '.ni');
INSERT INTO `country_data` VALUES ('127', 'Niger', 'Republic of Niger', 'Independent State', '', '', 'Niamey', 'XOF', 'Franc', '+227', 'NE', 'NER', '562', '.ne');
INSERT INTO `country_data` VALUES ('128', 'Nigeria', 'Federal Republic of Nigeria', 'Independent State', '', '', 'Abuja', 'NGN', 'Naira', '+234', 'NG', 'NGA', '566', '.ng');
INSERT INTO `country_data` VALUES ('129', 'Norway', 'Kingdom of Norway', 'Independent State', '', '', 'Oslo', 'NOK', 'Krone', '+47', 'NO', 'NOR', '578', '.no');
INSERT INTO `country_data` VALUES ('130', 'Oman', 'Sultanate of Oman', 'Independent State', '', '', 'Muscat', 'OMR', 'Rial', '+968', 'OM', 'OMN', '512', '.om');
INSERT INTO `country_data` VALUES ('131', 'Pakistan', 'Islamic Republic of Pakistan', 'Independent State', '', '', 'Islamabad', 'PKR', 'Rupee', '+92', 'PK', 'PAK', '586', '.pk');
INSERT INTO `country_data` VALUES ('132', 'Palau', 'Republic of Palau', 'Independent State', '', '', 'Melekeok', 'USD', 'Dollar', '+680', 'PW', 'PLW', '585', '.pw');
INSERT INTO `country_data` VALUES ('133', 'Panama', 'Republic of Panama', 'Independent State', '', '', 'Panama', 'PAB', 'Balboa', '+507', 'PA', 'PAN', '591', '.pa');
INSERT INTO `country_data` VALUES ('134', 'Papua New Guinea', 'Independent State of Papua New Guinea', 'Independent State', '', '', 'Port Moresby', 'PGK', 'Kina', '+675', 'PG', 'PNG', '598', '.pg');
INSERT INTO `country_data` VALUES ('135', 'Paraguay', 'Republic of Paraguay', 'Independent State', '', '', 'Asuncion', 'PYG', 'Guarani', '+595', 'PY', 'PRY', '600', '.py');
INSERT INTO `country_data` VALUES ('136', 'Peru', 'Republic of Peru', 'Independent State', '', '', 'Lima', 'PEN', 'Sol', '+51', 'PE', 'PER', '604', '.pe');
INSERT INTO `country_data` VALUES ('137', 'Philippines', 'Republic of the Philippines', 'Independent State', '', '', 'Manila', 'PHP', 'Peso', '+63', 'PH', 'PHL', '608', '.ph');
INSERT INTO `country_data` VALUES ('138', 'Poland', 'Republic of Poland', 'Independent State', '', '', 'Warsaw', 'PLN', 'Zloty', '+48', 'PL', 'POL', '616', '.pl');
INSERT INTO `country_data` VALUES ('139', 'Portugal', 'Portuguese Republic', 'Independent State', '', '', 'Lisbon', 'EUR', 'Euro', '+351', 'PT', 'PRT', '620', '.pt');
INSERT INTO `country_data` VALUES ('140', 'Qatar', 'State of Qatar', 'Independent State', '', '', 'Doha', 'QAR', 'Rial', '+974', 'QA', 'QAT', '634', '.qa');
INSERT INTO `country_data` VALUES ('141', 'Romania', '', 'Independent State', '', '', 'Bucharest', 'RON', 'Leu', '+40', 'RO', 'ROU', '642', '.ro');
INSERT INTO `country_data` VALUES ('142', 'Russia', 'Russian Federation', 'Independent State', '', '', 'Moscow', 'RUB', 'Ruble', '+7', 'RU', 'RUS', '643', '.ru ');
INSERT INTO `country_data` VALUES ('143', 'Rwanda', 'Republic of Rwanda', 'Independent State', '', '', 'Kigali', 'RWF', 'Franc', '+250', 'RW', 'RWA', '646', '.rw');
INSERT INTO `country_data` VALUES ('144', 'Saint Kitts and Nevis', 'Federation of Saint Kitts and Nevis', 'Independent State', '', '', 'Basseterre', 'XCD', 'Dollar', '+1-869', 'KN', 'KNA', '659', '.kn');
INSERT INTO `country_data` VALUES ('145', 'Saint Lucia', '', 'Independent State', '', '', 'Castries', 'XCD', 'Dollar', '+1-758', 'LC', 'LCA', '662', '.lc');
INSERT INTO `country_data` VALUES ('146', 'Saint Vincent and the Grenadines', '', 'Independent State', '', '', 'Kingstown', 'XCD', 'Dollar', '+1-784', 'VC', 'VCT', '670', '.vc');
INSERT INTO `country_data` VALUES ('147', 'Samoa', 'Independent State of Samoa', 'Independent State', '', '', 'Apia', 'WST', 'Tala', '+685', 'WS', 'WSM', '882', '.ws');
INSERT INTO `country_data` VALUES ('148', 'San Marino', 'Republic of San Marino', 'Independent State', '', '', 'San Marino', 'EUR', 'Euro', '+378', 'SM', 'SMR', '674', '.sm');
INSERT INTO `country_data` VALUES ('149', 'Sao Tome and Principe', 'Democratic Republic of Sao Tome and Principe', 'Independent State', '', '', 'Sao Tome', 'STD', 'Dobra', '+239', 'ST', 'STP', '678', '.st');
INSERT INTO `country_data` VALUES ('150', 'Saudi Arabia', 'Kingdom of Saudi Arabia', 'Independent State', '', '', 'Riyadh', 'SAR', 'Rial', '+966', 'SA', 'SAU', '682', '.sa');
INSERT INTO `country_data` VALUES ('151', 'Senegal', 'Republic of Senegal', 'Independent State', '', '', 'Dakar', 'XOF', 'Franc', '+221', 'SN', 'SEN', '686', '.sn');
INSERT INTO `country_data` VALUES ('152', 'Serbia', 'Republic of Serbia', 'Independent State', '', '', 'Belgrade', 'RSD', 'Dinar', '+381', 'RS', 'SRB', '688', '.rs ');
INSERT INTO `country_data` VALUES ('153', 'Seychelles', 'Republic of Seychelles', 'Independent State', '', '', 'Victoria', 'SCR', 'Rupee', '+248', 'SC', 'SYC', '690', '.sc');
INSERT INTO `country_data` VALUES ('154', 'Sierra Leone', 'Republic of Sierra Leone', 'Independent State', '', '', 'Freetown', 'SLL', 'Leone', '+232', 'SL', 'SLE', '694', '.sl');
INSERT INTO `country_data` VALUES ('155', 'Singapore', 'Republic of Singapore', 'Independent State', '', '', 'Singapore', 'SGD', 'Dollar', '+65', 'SG', 'SGP', '702', '.sg');
INSERT INTO `country_data` VALUES ('156', 'Slovakia', 'Slovak Republic', 'Independent State', '', '', 'Bratislava', 'SKK', 'Koruna', '+421', 'SK', 'SVK', '703', '.sk');
INSERT INTO `country_data` VALUES ('157', 'Slovenia', 'Republic of Slovenia', 'Independent State', '', '', 'Ljubljana', 'EUR', 'Euro', '+386', 'SI', 'SVN', '705', '.si');
INSERT INTO `country_data` VALUES ('158', 'Solomon Islands', '', 'Independent State', '', '', 'Honiara', 'SBD', 'Dollar', '+677', 'SB', 'SLB', '090', '.sb');
INSERT INTO `country_data` VALUES ('159', 'Somalia', '', 'Independent State', '', '', 'Mogadishu', 'SOS', 'Shilling', '+252', 'SO', 'SOM', '706', '.so');
INSERT INTO `country_data` VALUES ('160', 'South Africa', 'Republic of South Africa', 'Independent State', '', '', 'Pretoria (administrative), Cape Town (legislative), and Bloemfontein (judical)', 'ZAR', 'Rand', '+27', 'ZA', 'ZAF', '710', '.za');
INSERT INTO `country_data` VALUES ('161', 'Spain', 'Kingdom of Spain', 'Independent State', '', '', 'Madrid', 'EUR', 'Euro', '+34', 'ES', 'ESP', '724', '.es');
INSERT INTO `country_data` VALUES ('162', 'Sri Lanka', 'Democratic Socialist Republic of Sri Lanka', 'Independent State', '', '', 'Colombo (administrative/judical) and Sri Jayewardenepura Kotte (legislative)', 'LKR', 'Rupee', '+94', 'LK', 'LKA', '144', '.lk');
INSERT INTO `country_data` VALUES ('163', 'Sudan', 'Republic of the Sudan', 'Independent State', '', '', 'Khartoum', 'SDG', 'Pound', '+249', 'SD', 'SDN', '736', '.sd');
INSERT INTO `country_data` VALUES ('164', 'Suriname', 'Republic of Suriname', 'Independent State', '', '', 'Paramaribo', 'SRD', 'Dollar', '+597', 'SR', 'SUR', '740', '.sr');
INSERT INTO `country_data` VALUES ('165', 'Swaziland', 'Kingdom of Swaziland', 'Independent State', '', '', 'Mbabane (administrative) and Lobamba (legislative)', 'SZL', 'Lilangeni', '+268', 'SZ', 'SWZ', '748', '.sz');
INSERT INTO `country_data` VALUES ('166', 'Sweden', 'Kingdom of Sweden', 'Independent State', '', '', 'Stockholm', 'SEK', 'Kronoa', '+46', 'SE', 'SWE', '752', '.se');
INSERT INTO `country_data` VALUES ('167', 'Switzerland', 'Swiss Confederation', 'Independent State', '', '', 'Bern', 'CHF', 'Franc', '+41', 'CH', 'CHE', '756', '.ch');
INSERT INTO `country_data` VALUES ('168', 'Syria', 'Syrian Arab Republic', 'Independent State', '', '', 'Damascus', 'SYP', 'Pound', '+963', 'SY', 'SYR', '760', '.sy');
INSERT INTO `country_data` VALUES ('169', 'Tajikistan', 'Republic of Tajikistan', 'Independent State', '', '', 'Dushanbe', 'TJS', 'Somoni', '+992', 'TJ', 'TJK', '762', '.tj');
INSERT INTO `country_data` VALUES ('170', 'Tanzania', 'United Republic of Tanzania', 'Independent State', '', '', 'Dar es Salaam (administrative/judical) and Dodoma (legislative)', 'TZS', 'Shilling', '+255', 'TZ', 'TZA', '834', '.tz');
INSERT INTO `country_data` VALUES ('171', 'Thailand', 'Kingdom of Thailand', 'Independent State', '', '', 'Bangkok', 'THB', 'Baht', '+66', 'TH', 'THA', '764', '.th');
INSERT INTO `country_data` VALUES ('172', 'Timor-Leste (East Timor)', 'Democratic Republic of Timor-Leste', 'Independent State', '', '', 'Dili', 'USD', 'Dollar', '+670', 'TL', 'TLS', '626', '.tp ');
INSERT INTO `country_data` VALUES ('173', 'Togo', 'Togolese Republic', 'Independent State', '', '', 'Lome', 'XOF', 'Franc', '+228', 'TG', 'TGO', '768', '.tg');
INSERT INTO `country_data` VALUES ('174', 'Tonga', 'Kingdom of Tonga', 'Independent State', '', '', 'Nuku\'alofa', 'TOP', 'Pa\'anga', '+676', 'TO', 'TON', '776', '.to');
INSERT INTO `country_data` VALUES ('175', 'Trinidad and Tobago', 'Republic of Trinidad and Tobago', 'Independent State', '', '', 'Port-of-Spain', 'TTD', 'Dollar', '+1-868', 'TT', 'TTO', '780', '.tt');
INSERT INTO `country_data` VALUES ('176', 'Tunisia', 'Tunisian Republic', 'Independent State', '', '', 'Tunis', 'TND', 'Dinar', '+216', 'TN', 'TUN', '788', '.tn');
INSERT INTO `country_data` VALUES ('177', 'Turkey', 'Republic of Turkey', 'Independent State', '', '', 'Ankara', 'TRY', 'Lira', '+90', 'TR', 'TUR', '792', '.tr');
INSERT INTO `country_data` VALUES ('178', 'Turkmenistan', '', 'Independent State', '', '', 'Ashgabat', 'TMM', 'Manat', '+993', 'TM', 'TKM', '795', '.tm');
INSERT INTO `country_data` VALUES ('179', 'Tuvalu', '', 'Independent State', '', '', 'Funafuti', 'AUD', 'Dollar', '+688', 'TV', 'TUV', '798', '.tv');
INSERT INTO `country_data` VALUES ('180', 'Uganda', 'Republic of Uganda', 'Independent State', '', '', 'Kampala', 'UGX', 'Shilling', '+256', 'UG', 'UGA', '800', '.ug');
INSERT INTO `country_data` VALUES ('181', 'Ukraine', '', 'Independent State', '', '', 'Kiev', 'UAH', 'Hryvnia', '+380', 'UA', 'UKR', '804', '.ua');
INSERT INTO `country_data` VALUES ('182', 'United Arab Emirates', 'United Arab Emirates', 'Independent State', '', '', 'Abu Dhabi', 'AED', 'Dirham', '+971', 'AE', 'ARE', '784', '.ae');
INSERT INTO `country_data` VALUES ('183', 'United Kingdom', 'United Kingdom of Great Britain and Northern Ireland', 'Independent State', '', '', 'London', 'GBP', 'Pound', '+44', 'GB', 'GBR', '826', '.uk');
INSERT INTO `country_data` VALUES ('184', 'United States', 'United States of America', 'Independent State', '', '', 'Washington', 'USD', 'Dollar', '+1', 'US', 'USA', '840', '.us');
INSERT INTO `country_data` VALUES ('185', 'Uruguay', 'Oriental Republic of Uruguay', 'Independent State', '', '', 'Montevideo', 'UYU', 'Peso', '+598', 'UY', 'URY', '858', '.uy');
INSERT INTO `country_data` VALUES ('186', 'Uzbekistan', 'Republic of Uzbekistan', 'Independent State', '', '', 'Tashkent', 'UZS', 'Som', '+998', 'UZ', 'UZB', '860', '.uz');
INSERT INTO `country_data` VALUES ('187', 'Vanuatu', 'Republic of Vanuatu', 'Independent State', '', '', 'Port-Vila', 'VUV', 'Vatu', '+678', 'VU', 'VUT', '548', '.vu');
INSERT INTO `country_data` VALUES ('188', 'Vatican City', 'State of the Vatican City', 'Independent State', '', '', 'Vatican City', 'EUR', 'Euro', '+379', 'VA', 'VAT', '336', '.va');
INSERT INTO `country_data` VALUES ('189', 'Venezuela', 'Bolivarian Republic of Venezuela', 'Independent State', '', '', 'Caracas', 'VEB', 'Bolivar', '+58', 'VE', 'VEN', '862', '.ve');
INSERT INTO `country_data` VALUES ('190', 'Vietnam', 'Socialist Republic of Vietnam', 'Independent State', '', '', 'Hanoi', 'VND', 'Dong', '+84', 'VN', 'VNM', '704', '.vn');
INSERT INTO `country_data` VALUES ('191', 'Yemen', 'Republic of Yemen', 'Independent State', '', '', 'Sanaa', 'YER', 'Rial', '+967', 'YE', 'YEM', '887', '.ye');
INSERT INTO `country_data` VALUES ('192', 'Zambia', 'Republic of Zambia', 'Independent State', '', '', 'Lusaka', 'ZMK', 'Kwacha', '+260', 'ZM', 'ZMB', '894', '.zm');
INSERT INTO `country_data` VALUES ('193', 'Zimbabwe', 'Republic of Zimbabwe', 'Independent State', '', '', 'Harare', 'ZWD', 'Dollar', '+263', 'ZW', 'ZWE', '716', '.zw');
INSERT INTO `country_data` VALUES ('194', 'Abkhazia', 'Republic of Abkhazia', 'Proto Independent State', '', '', 'Sokhumi', 'RUB', 'Ruble', '+995', 'GE', 'GEO', '268', '.ge');
INSERT INTO `country_data` VALUES ('195', 'China, Republic of (Taiwan)', 'Republic of China', 'Proto Independent State', '', '', 'Taipei', 'TWD', 'Dollar', '+886', 'TW', 'TWN', '158', '.tw');
INSERT INTO `country_data` VALUES ('196', 'Nagorno-Karabakh', 'Nagorno-Karabakh Republic', 'Proto Independent State', '', '', 'Stepanakert', 'AMD', 'Dram', '+374-97', 'AZ', 'AZE', '031', '.az');
INSERT INTO `country_data` VALUES ('197', 'Northern Cyprus', 'Turkish Republic of Northern Cyprus', 'Proto Independent State', '', '', 'Nicosia', 'TRY', 'Lira', '+90-392', 'CY', 'CYP', '196', '.nc.');
INSERT INTO `country_data` VALUES ('198', 'Pridnestrovie (Transnistria)', 'Pridnestrovian Moldavian Republic', 'Proto Independent State', '', '', 'Tiraspol', '', 'Ruple', '+373-533', 'MD', 'MDA', '498', '.md');
INSERT INTO `country_data` VALUES ('199', 'Somaliland', 'Republic of Somaliland', 'Proto Independent State', '', '', 'Hargeisa', '', 'Shilling', '+252', 'SO', 'SOM', '706', '.so');
INSERT INTO `country_data` VALUES ('200', 'South Ossetia', 'Republic of South Ossetia', 'Proto Independent State', '', '', 'Tskhinvali', 'RUB', 'Ruble and Lari', '+995', 'GE', 'GEO', '268', '.ge');
INSERT INTO `country_data` VALUES ('201', 'Ashmore and Cartier Islands', 'Territory of Ashmore and Cartier Islands', 'Dependency', 'External Territory', 'Australia', '', '', '', '', 'AU', 'AUS', '036', '.au');
INSERT INTO `country_data` VALUES ('202', 'Christmas Island', 'Territory of Christmas Island', 'Dependency', 'External Territory', 'Australia', 'The Settlement (Flying Fish Cove)', 'AUD', 'Dollar', '+61', 'CX', 'CXR', '162', '.cx');
INSERT INTO `country_data` VALUES ('203', 'Cocos (Keeling) Islands', 'Territory of Cocos (Keeling) Islands', 'Dependency', 'External Territory', 'Australia', 'West Island', 'AUD', 'Dollar', '+61', 'CC', 'CCK', '166', '.cc');
INSERT INTO `country_data` VALUES ('204', 'Coral Sea Islands', 'Coral Sea Islands Territory', 'Dependency', 'External Territory', 'Australia', '', '', '', '', 'AU', 'AUS', '036', '.au');
INSERT INTO `country_data` VALUES ('205', 'Heard Island and McDonald Islands', 'Territory of Heard Island and McDonald Islands', 'Dependency', 'External Territory', 'Australia', '', '', '', '', 'HM', 'HMD', '334', '.hm');
INSERT INTO `country_data` VALUES ('206', 'Norfolk Island', 'Territory of Norfolk Island', 'Dependency', 'External Territory', 'Australia', 'Kingston', 'AUD', 'Dollar', '+672', 'NF', 'NFK', '574', '.nf');
INSERT INTO `country_data` VALUES ('207', 'New Caledonia', '', 'Dependency', 'Sui generis Collectivity', 'France', 'Noumea', 'XPF', 'Franc', '+687', 'NC', 'NCL', '540', '.nc');
INSERT INTO `country_data` VALUES ('208', 'French Polynesia', 'Overseas Country of French Polynesia', 'Dependency', 'Overseas Collectivity', 'France', 'Papeete', 'XPF', 'Franc', '+689', 'PF', 'PYF', '258', '.pf');
INSERT INTO `country_data` VALUES ('209', 'Mayotte', 'Departmental Collectivity of Mayotte', 'Dependency', 'Overseas Collectivity', 'France', 'Mamoudzou', 'EUR', 'Euro', '+262', 'YT', 'MYT', '175', '.yt');
INSERT INTO `country_data` VALUES ('210', 'Saint Barthelemy', 'Collectivity of Saint Barthelemy', 'Dependency', 'Overseas Collectivity', 'France', 'Gustavia', 'EUR', 'Euro', '+590', 'GP', 'GLP', '312', '.gp');
INSERT INTO `country_data` VALUES ('211', 'Saint Martin', 'Collectivity of Saint Martin', 'Dependency', 'Overseas Collectivity', 'France', 'Marigot', 'EUR', 'Euro', '+590', 'GP', 'GLP', '312', '.gp');
INSERT INTO `country_data` VALUES ('212', 'Saint Pierre and Miquelon', 'Territorial Collectivity of Saint Pierre and Miquelon', 'Dependency', 'Overseas Collectivity', 'France', 'Saint-Pierre', 'EUR', 'Euro', '+508', 'PM', 'SPM', '666', '.pm');
INSERT INTO `country_data` VALUES ('213', 'Wallis and Futuna', 'Collectivity of the Wallis and Futuna Islands', 'Dependency', 'Overseas Collectivity', 'France', 'Mata\'utu', 'XPF', 'Franc', '+681', 'WF', 'WLF', '876', '.wf');
INSERT INTO `country_data` VALUES ('214', 'French Southern and Antarctic Lands', 'Territory of the French Southern and Antarctic Lands', 'Dependency', 'Overseas Territory', 'France', 'Martin-de-Vivi', '', '', '', 'TF', 'ATF', '260', '.tf');
INSERT INTO `country_data` VALUES ('215', 'Clipperton Island', '', 'Dependency', 'Possession', 'France', '', '', '', '', 'PF', 'PYF', '258', '.pf');
INSERT INTO `country_data` VALUES ('216', 'Bouvet Island', '', 'Dependency', 'Territory', 'Norway', '', '', '', '', 'BV', 'BVT', '074', '.bv');
INSERT INTO `country_data` VALUES ('217', 'Cook Islands', '', 'Dependency', 'Self-Governing in Free Association', 'New Zealand', 'Avarua', 'NZD', 'Dollar', '+682', 'CK', 'COK', '184', '.ck');
INSERT INTO `country_data` VALUES ('218', 'Niue', '', 'Dependency', 'Self-Governing in Free Association', 'New Zealand', 'Alofi', 'NZD', 'Dollar', '+683', 'NU', 'NIU', '570', '.nu');
INSERT INTO `country_data` VALUES ('219', 'Tokelau', '', 'Dependency', 'Territory', 'New Zealand', '', 'NZD', 'Dollar', '+690', 'TK', 'TKL', '772', '.tk');
INSERT INTO `country_data` VALUES ('220', 'Guernsey', 'Bailiwick of Guernsey', 'Dependency', 'Crown Dependency', 'United Kingdom', 'Saint Peter Port', 'GGP', 'Pound', '+44', 'GG', 'GGY', '831', '.gg');
INSERT INTO `country_data` VALUES ('221', 'Isle of Man', '', 'Dependency', 'Crown Dependency', 'United Kingdom', 'Douglas', 'IMP', 'Pound', '+44', 'IM', 'IMN', '833', '.im');
INSERT INTO `country_data` VALUES ('222', 'Jersey', 'Bailiwick of Jersey', 'Dependency', 'Crown Dependency', 'United Kingdom', 'Saint Helier', 'JEP', 'Pound', '+44', 'JE', 'JEY', '832', '.je');
INSERT INTO `country_data` VALUES ('223', 'Anguilla', '', 'Dependency', 'Overseas Territory', 'United Kingdom', 'The Valley', 'XCD', 'Dollar', '+1-264', 'AI', 'AIA', '660', '.ai');
INSERT INTO `country_data` VALUES ('224', 'Bermuda', '', 'Dependency', 'Overseas Territory', 'United Kingdom', 'Hamilton', 'BMD', 'Dollar', '+1-441', 'BM', 'BMU', '060', '.bm');
INSERT INTO `country_data` VALUES ('225', 'British Indian Ocean Territory', '', 'Dependency', 'Overseas Territory', 'United Kingdom', '', '', '', '+246', 'IO', 'IOT', '086', '.io');
INSERT INTO `country_data` VALUES ('226', 'British Sovereign Base Areas', '', 'Dependency', 'Overseas Territory', 'United Kingdom', 'Episkopi', 'CYP', 'Pound', '+357', '', '', '', '');
INSERT INTO `country_data` VALUES ('227', 'British Virgin Islands', '', 'Dependency', 'Overseas Territory', 'United Kingdom', 'Road Town', 'USD', 'Dollar', '+1-284', 'VG', 'VGB', '092', '.vg');
INSERT INTO `country_data` VALUES ('228', 'Cayman Islands', '', 'Dependency', 'Overseas Territory', 'United Kingdom', 'George Town', 'KYD', 'Dollar', '+1-345', 'KY', 'CYM', '136', '.ky');
INSERT INTO `country_data` VALUES ('229', 'Falkland Islands (Islas Malvinas)', '', 'Dependency', 'Overseas Territory', 'United Kingdom', 'Stanley', 'FKP', 'Pound', '+500', 'FK', 'FLK', '238', '.fk');
INSERT INTO `country_data` VALUES ('230', 'Gibraltar', '', 'Dependency', 'Overseas Territory', 'United Kingdom', 'Gibraltar', 'GIP', 'Pound', '+350', 'GI', 'GIB', '292', '.gi');
INSERT INTO `country_data` VALUES ('231', 'Montserrat', '', 'Dependency', 'Overseas Territory', 'United Kingdom', 'Plymouth', 'XCD', 'Dollar', '+1-664', 'MS', 'MSR', '500', '.ms');
INSERT INTO `country_data` VALUES ('232', 'Pitcairn Islands', '', 'Dependency', 'Overseas Territory', 'United Kingdom', 'Adamstown', 'NZD', 'Dollar', '', 'PN', 'PCN', '612', '.pn');
INSERT INTO `country_data` VALUES ('233', 'Saint Helena', '', 'Dependency', 'Overseas Territory', 'United Kingdom', 'Jamestown', 'SHP', 'Pound', '+290', 'SH', 'SHN', '654', '.sh');
INSERT INTO `country_data` VALUES ('234', 'South Georgia and the South Sandwich Islands', '', 'Dependency', 'Overseas Territory', 'United Kingdom', '', '', '', '', 'GS', 'SGS', '239', '.gs');
INSERT INTO `country_data` VALUES ('235', 'Turks and Caicos Islands', '', 'Dependency', 'Overseas Territory', 'United Kingdom', 'Grand Turk', 'USD', 'Dollar', '+1-649', 'TC', 'TCA', '796', '.tc');
INSERT INTO `country_data` VALUES ('236', 'Northern Mariana Islands', 'Commonwealth of The Northern Mariana Islands', 'Dependency', 'Commonwealth', 'United States', 'Saipan', 'USD', 'Dollar', '+1-670', 'MP', 'MNP', '580', '.mp');
INSERT INTO `country_data` VALUES ('237', 'Puerto Rico', 'Commonwealth of Puerto Rico', 'Dependency', 'Commonwealth', 'United States', 'San Juan', 'USD', 'Dollar', '+1-787 a', 'PR', 'PRI', '630', '.pr');
INSERT INTO `country_data` VALUES ('238', 'American Samoa', 'Territory of American Samoa', 'Dependency', 'Territory', 'United States', 'Pago Pago', 'USD', 'Dollar', '+1-684', 'AS', 'ASM', '016', '.as');
INSERT INTO `country_data` VALUES ('239', 'Baker Island', '', 'Dependency', 'Territory', 'United States', '', '', '', '', 'UM', 'UMI', '581', '');
INSERT INTO `country_data` VALUES ('240', 'Guam', 'Territory of Guam', 'Dependency', 'Territory', 'United States', 'Hagatna', 'USD', 'Dollar', '+1-671', 'GU', 'GUM', '316', '.gu');
INSERT INTO `country_data` VALUES ('241', 'Howland Island', '', 'Dependency', 'Territory', 'United States', '', '', '', '', 'UM', 'UMI', '581', '');
INSERT INTO `country_data` VALUES ('242', 'Jarvis Island', '', 'Dependency', 'Territory', 'United States', '', '', '', '', 'UM', 'UMI', '581', '');
INSERT INTO `country_data` VALUES ('243', 'Johnston Atoll', '', 'Dependency', 'Territory', 'United States', '', '', '', '', 'UM', 'UMI', '581', '');
INSERT INTO `country_data` VALUES ('244', 'Kingman Reef', '', 'Dependency', 'Territory', 'United States', '', '', '', '', 'UM', 'UMI', '581', '');
INSERT INTO `country_data` VALUES ('245', 'Midway Islands', '', 'Dependency', 'Territory', 'United States', '', '', '', '', 'UM', 'UMI', '581', '');
INSERT INTO `country_data` VALUES ('246', 'Navassa Island', '', 'Dependency', 'Territory', 'United States', '', '', '', '', 'UM', 'UMI', '581', '');
INSERT INTO `country_data` VALUES ('247', 'Palmyra Atoll', '', 'Dependency', 'Territory', 'United States', '', '', '', '', 'UM', 'UMI', '581', '');
INSERT INTO `country_data` VALUES ('248', 'U.S. Virgin Islands', 'United States Virgin Islands', 'Dependency', 'Territory', 'United States', 'Charlotte Amalie', 'USD', 'Dollar', '+1-340', 'VI', 'VIR', '850', '.vi');
INSERT INTO `country_data` VALUES ('249', 'Wake Island', '', 'Dependency', 'Territory', 'United States', '', '', '', '', 'UM', 'UMI', '850', '');
INSERT INTO `country_data` VALUES ('250', 'Hong Kong', 'Hong Kong Special Administrative Region', 'Proto Dependency', 'Special Administrative Region', 'China', '', 'HKD', 'Dollar', '+852', 'HK', 'HKG', '344', '.hk');
INSERT INTO `country_data` VALUES ('251', 'Macau', 'Macau Special Administrative Region', 'Proto Dependency', 'Special Administrative Region', 'China', 'Macau', 'MOP', 'Pataca', '+853', 'MO', 'MAC', '446', '.mo');
INSERT INTO `country_data` VALUES ('252', 'Faroe Islands', '', 'Proto Dependency', '', 'Denmark', 'Torshavn', 'DKK', 'Krone', '+298', 'FO', 'FRO', '234', '.fo');
INSERT INTO `country_data` VALUES ('253', 'Greenland', '', 'Proto Dependency', '', 'Denmark', 'Nuuk (Godthab)', 'DKK', 'Krone', '+299', 'GL', 'GRL', '304', '.gl');
INSERT INTO `country_data` VALUES ('254', 'French Guiana', 'Overseas Region of Guiana', 'Proto Dependency', 'Overseas Region', 'France', 'Cayenne', 'EUR', 'Euro', '+594', 'GF', 'GUF', '254', '.gf');
INSERT INTO `country_data` VALUES ('255', 'Guadeloupe', 'Overseas Region of Guadeloupe', 'Proto Dependency', 'Overseas Region', 'France', 'Basse-Terre', 'EUR', 'Euro', '+590', 'GP', 'GLP', '312', '.gp');
INSERT INTO `country_data` VALUES ('256', 'Martinique', 'Overseas Region of Martinique', 'Proto Dependency', 'Overseas Region', 'France', 'Fort-de-France', 'EUR', 'Euro', '+596', 'MQ', 'MTQ', '474', '.mq');
INSERT INTO `country_data` VALUES ('257', 'Reunion', 'Overseas Region of Reunion', 'Proto Dependency', 'Overseas Region', 'France', 'Saint-Denis', 'EUR', 'Euro', '+262', 'RE', 'REU', '638', '.re');
INSERT INTO `country_data` VALUES ('258', 'Aland', '', 'Proto Dependency', '', 'Finland', 'Mariehamn', 'EUR', 'Euro', '+358-18', 'AX', 'ALA', '248', '.ax');
INSERT INTO `country_data` VALUES ('259', 'Aruba', '', 'Proto Dependency', '', 'Netherlands', 'Oranjestad', 'AWG', 'Guilder', '+297', 'AW', 'ABW', '533', '.aw');
INSERT INTO `country_data` VALUES ('260', 'Netherlands Antilles', '', 'Proto Dependency', '', 'Netherlands', 'Willemstad', 'ANG', 'Guilder', '+599', 'AN', 'ANT', '530', '.an');
INSERT INTO `country_data` VALUES ('261', 'Svalbard', '', 'Proto Dependency', '', 'Norway', 'Longyearbyen', 'NOK', 'Krone', '+47', 'SJ', 'SJM', '744', '.sj');
INSERT INTO `country_data` VALUES ('262', 'Ascension', '', 'Proto Dependency', 'Dependency of Saint Helena', 'United Kingdom', 'Georgetown', 'SHP', 'Pound', '+247', 'AC', 'ASC', '', '.ac');
INSERT INTO `country_data` VALUES ('263', 'Tristan da Cunha', '', 'Proto Dependency', 'Dependency of Saint Helena', 'United Kingdom', 'Edinburgh', 'SHP', 'Pound', '+290', 'TA', 'TAA', '', '');
INSERT INTO `country_data` VALUES ('264', 'Antarctica', '', 'Disputed Territory', '', 'Undetermined', '', '', '', '', 'AQ', 'ATA', '010', '.aq');
INSERT INTO `country_data` VALUES ('265', 'Kosovo', '', 'Disputed Territory', '', 'Administrated by the UN', 'Pristina', 'CSD', 'Dinar and Euro', '+381', 'CS', 'SCG', '891', '.cs ');
INSERT INTO `country_data` VALUES ('266', 'Palestinian Territories (Gaza Strip and West Bank)', '', 'Disputed Territory', '', 'Administrated by Israel', 'Gaza City (Gaza Strip) and Ramallah (West Bank)', 'ILS', 'Shekel', '+970', 'PS', 'PSE', '275', '.ps');
INSERT INTO `country_data` VALUES ('267', 'Western Sahara', '', 'Disputed Territory', '', 'Administrated by Morocco', 'El-Aaiun', 'MAD', 'Dirham', '+212', 'EH', 'ESH', '732', '.eh');
INSERT INTO `country_data` VALUES ('268', 'Australian Antarctic Territory', '', 'Antarctic Territory', 'External Territory', 'Australia', '', '', '', '', 'AQ', 'ATA', '010', '.aq');
INSERT INTO `country_data` VALUES ('269', 'Ross Dependency', '', 'Antarctic Territory', 'Territory', 'New Zealand', '', '', '', '', 'AQ', 'ATA', '010', '.aq');
INSERT INTO `country_data` VALUES ('270', 'Peter I Island', '', 'Antarctic Territory', 'Territory', 'Norway', '', '', '', '', 'AQ', 'ATA', '010', '.aq');
INSERT INTO `country_data` VALUES ('271', 'Queen Maud Land', '', 'Antarctic Territory', 'Territory', 'Norway', '', '', '', '', 'AQ', 'ATA', '010', '.aq');
INSERT INTO `country_data` VALUES ('272', 'British Antarctic Territory', '', 'Antarctic Territory', 'Overseas Territory', 'United Kingdom', '', '', '', '', 'AQ', 'ATA', '010', '.aq');
INSERT INTO `developers2` VALUES ('1', 'Developer 1', '1', 'developer1@mail.com');
INSERT INTO `developers2` VALUES ('2', 'Developer 2', '1', 'developer2@mail.com');
INSERT INTO `developers2` VALUES ('3', 'Developer 3', '1', 'developer3@mail.com');
INSERT INTO `developers2` VALUES ('4', 'Developer 4', '2', 'developer4@mail.com');
INSERT INTO `developers2` VALUES ('5', 'Developer 5', '2', 'developer5@mail.com');
INSERT INTO `developers2` VALUES ('6', 'Developer 6', '2', 'developer6@mail.com');
INSERT INTO `developers2` VALUES ('7', 'Developer 7', '3', 'developer7@mail.com');
INSERT INTO `developers2` VALUES ('8', 'Developer 8', '3', 'developer8@mail.com');
INSERT INTO `developers2` VALUES ('9', 'Developer 9', '3', 'developer9@mail.com');
INSERT INTO `developers2` VALUES ('10', 'Developer 10', '4', 'developer10@mail.com');
INSERT INTO `developers2` VALUES ('11', 'Developer 11', '4', 'developer11@mail.com');
INSERT INTO `developers2` VALUES ('12', 'Developer 12', '4', 'developer12@mail.com');
INSERT INTO `developers2` VALUES ('13', 'Developer 13', '5', 'developer13@mail.com');
INSERT INTO `developers2` VALUES ('14', 'Developer 14', '5', 'developer14@mail.com');
INSERT INTO `developers2` VALUES ('15', 'Developer 15', '5', 'developer15@mail.com');
INSERT INTO `developers2` VALUES ('16', 'Developer 16', '6', 'developer16@mail.com');
INSERT INTO `developers2` VALUES ('17', 'Developer 17', '6', 'developer17@mail.com');
INSERT INTO `developers2` VALUES ('18', 'Developer 18', '6', 'developer18@mail.com');
INSERT INTO `developers2` VALUES ('19', 'Developer 19', '7', 'developer19@mail.com');
INSERT INTO `developers2` VALUES ('20', 'Developer 20', '7', 'developer20@mail.com');
INSERT INTO `developers2` VALUES ('21', 'Developer 21', '7', 'developer21@mail.com');
INSERT INTO `developers2` VALUES ('22', 'Developer 22', '8', 'developer2@mail.com');
INSERT INTO `developers2` VALUES ('23', 'Developer 23', '8', 'developer23@mail.com');
INSERT INTO `developers2` VALUES ('24', 'Developer 24', '8', 'developer24@mail.com');
INSERT INTO `developers2` VALUES ('25', 'Developer 25', '9', 'developer25@mail.com');
INSERT INTO `developers2` VALUES ('26', 'Developer 26', '9', 'developer26@mail.com');
INSERT INTO `developers2` VALUES ('27', 'Developer 27', '9', 'developer27@mail.com');
INSERT INTO `developers2` VALUES ('28', 'Developer 28', '10', 'developer28@mail.com');
INSERT INTO `developers2` VALUES ('29', 'Developer 29', '10', 'developer29@mail.com');
INSERT INTO `developers2` VALUES ('30', 'Developer 30', '10', 'developer30@mail.com');
INSERT INTO `events` VALUES ('2', 'French Open', '2009-05-24 00:00:00', '2009-06-08 00:00:00', 'Philippe-Chatrier Court, Paris, FRA');
INSERT INTO `events` VALUES ('3', 'Aegon Championship', '2009-06-10 00:00:00', '2009-06-13 00:00:00', 'The Queens Club ,London, ENG');
INSERT INTO `events` VALUES ('4', 'Wimbledon', '2009-06-21 00:00:00', '2009-07-05 00:00:00', 'Wimbledon\nJune 21, 2009 - July 5, 2009');
INSERT INTO `events` VALUES ('5', 'Indianapolis Tennis Championships', '2009-07-18 00:00:00', '2009-07-27 00:00:00', 'Indianapolis Tennis Center \nIndianapolis, IN');
INSERT INTO `events` VALUES ('8', 'Countrywide Classic Tennis', '2009-07-27 00:00:00', '2009-08-02 00:00:00', 'Los Angeles Tennis Center. Los Angeles, CA  ');
INSERT INTO `events` VALUES ('7', 'ATP Master Tennis', '2009-05-11 00:00:00', '2009-05-18 00:00:00', 'La Caja Magica.\nMadrid, Spain');
INSERT INTO `events` VALUES ('9', 'Legg Mason Tennis Classic', '2009-08-01 00:00:00', '2009-08-11 00:00:00', 'Fitzgerald Tennis Center\nWashington D.C.');
INSERT INTO `events` VALUES ('10', 'Western & Southern Financial Group Women\\\'s Open', '2009-08-07 00:00:00', '2009-08-17 00:00:00', 'Lindner Family Tennis Center\nMason, OH');
INSERT INTO `events` VALUES ('11', 'Rogers Cup Women\\\'s Tennis', '2009-08-15 00:00:00', '2009-08-24 00:00:00', 'Rexall Centre\nToronto, ON');
INSERT INTO `events` VALUES ('12', 'US Open Tennis Championship', '2009-08-29 00:00:00', '2009-09-14 00:00:00', 'Arthur Ashe Stadium\nFlushing, NY');
INSERT INTO `events` VALUES ('13', 'Barclays ATP World Tour Finals', '2009-11-22 00:00:00', '2009-11-28 00:00:00', 'O2 Dome\nLondon, ENG\n');
INSERT INTO `events` VALUES ('14', 'Western & Southern Financial Group Masters Tennis', '2009-08-17 00:00:00', '2009-08-24 00:00:00', 'Lindner Family Tennis Center\nMason, OH');
INSERT INTO `events` VALUES ('15', ' Parc Izvor ', '2009-05-16 15:00:00', '2009-05-16 18:00:00', ' Bucharest, Romania ');
INSERT INTO `events` VALUES ('16', ' Arena Zagreb ', '2009-05-21 14:00:00', '2009-05-21 17:00:00', ' Zagreb, Croatia ');
INSERT INTO `events` VALUES ('17', ' Gwardia Stadium ', '2009-05-23 11:00:00', '2009-05-23 14:00:00', ' Warsaw, Poland ');
INSERT INTO `events` VALUES ('18', ' Skonto Stadium - Riga ', '2009-05-25 19:00:00', '2009-05-25 22:00:00', ' Riga, Latvia ');
INSERT INTO `events` VALUES ('19', ' Zalgirio Stadionas ', '2009-05-27 15:00:00', '2009-05-27 18:00:00', ' Vilnius, Lithuania ');
INSERT INTO `events` VALUES ('20', ' O2 Dome ', '2009-05-30 17:00:00', '2009-05-30 20:00:00', ' London, ENG ');
INSERT INTO `events` VALUES ('21', ' Evenemententerrein Megaland ', '2009-05-31 16:00:00', '2009-05-31 19:00:00', ' Landgraaf, NL ');
INSERT INTO `events` VALUES ('22', ' HSH Nordbank Arena (formerly AOL Arena) ', '2009-06-02 10:00:00', '2009-06-02 13:00:00', ' Hamburg, GER ');
INSERT INTO `events` VALUES ('23', ' LTU Arena ', '2009-06-04 11:00:00', '2009-06-04 14:00:00', ' Dusseldorf, GER ');
INSERT INTO `events` VALUES ('24', ' LTU Arena ', '2009-06-05 12:00:00', '2009-06-05 15:00:00', ' Dusseldorf, GER ');
INSERT INTO `events` VALUES ('25', ' Zentralstadion - Leipzig ', '2009-06-07 20:00:00', '2009-06-07 23:00:00', ' Leipzig, GER ');
INSERT INTO `events` VALUES ('26', ' Zentralstadion - Leipzig ', '2009-06-08 17:00:00', '2009-06-08 20:00:00', ' Leipzig, GER ');
INSERT INTO `events` VALUES ('27', ' Olympiastadion - Berlin ', '2009-06-10 14:00:00', '2009-06-10 17:00:00', ' Berlin, GER ');
INSERT INTO `events` VALUES ('28', ' Commerz Bank Arena ', '2009-06-12 14:00:00', '2009-06-12 17:00:00', ' Frankfurt, GER ');
INSERT INTO `events` VALUES ('29', ' Olympic Stadium - Munich ', '2009-06-13 11:00:00', '2009-06-13 14:00:00', ' Munich, GER ');
INSERT INTO `events` VALUES ('30', ' Stadio Olimpico ', '2009-06-16 19:00:00', '2009-06-16 22:00:00', ' Rome, Italy ');
INSERT INTO `events` VALUES ('31', ' Comunale Giuseppe Meazza - San Siro ', '2009-06-18 20:00:00', '2009-06-18 23:00:00', ' Milan, Italy ');
INSERT INTO `events` VALUES ('32', ' Inter Stadion Slovakia ', '2009-06-22 19:00:00', '2009-06-22 22:00:00', ' Bratislava, Slovakia ');
INSERT INTO `events` VALUES ('33', ' Puskas Ferenc Stadium ', '2009-06-23 14:00:00', '2009-06-23 17:00:00', ' Budapest, Hungary ');
INSERT INTO `events` VALUES ('34', ' Slavia Stadion ', '2009-06-25 10:00:00', '2009-06-25 13:00:00', ' Prague, Czech Republic ');
INSERT INTO `events` VALUES ('35', ' Stade de France - Paris ', '2009-06-27 19:00:00', '2009-06-27 22:00:00', ' Paris, FRA ');
INSERT INTO `events` VALUES ('36', ' Parken Stadium ', '2009-06-30 18:00:00', '2009-06-30 21:00:00', ' Copenhagen, DK ');
INSERT INTO `events` VALUES ('37', ' Koengen ', '2009-07-02 18:00:00', '2009-07-02 21:00:00', ' Bergen, Norway ');
INSERT INTO `events` VALUES ('38', ' Folkets Park ', '2009-07-03 11:00:00', '2009-07-03 14:00:00', ' Malmo, SE ');
INSERT INTO `events` VALUES ('39', ' Estadio Jose Zorila ', '2009-07-08 18:00:00', '2009-07-08 21:00:00', ' Valladolid, Spain ');
INSERT INTO `events` VALUES ('40', ' Bessa Stadium ', '2009-07-11 10:00:00', '2009-07-11 13:00:00', ' Porto, Portugal ');
INSERT INTO `events` VALUES ('41', ' Estadio Olimpico - Seville ', '2009-07-12 14:00:00', '2009-07-12 17:00:00', ' Seville, Spain ');
INSERT INTO `events` VALUES ('42', ' Molson Amphitheatre ', '2009-07-24 16:00:00', '2009-07-24 19:00:00', ' Toronto, ON ');
INSERT INTO `events` VALUES ('43', ' Bell Centre ', '2009-07-25 18:00:00', '2009-07-25 21:00:00', ' Montreal, QC ');
INSERT INTO `events` VALUES ('44', ' Nissan Pavilion ', '2009-07-28 17:00:00', '2009-07-28 20:00:00', ' Bristow, VA ');
INSERT INTO `events` VALUES ('45', ' Comcast Center - MA (formerly Tweeter Center) ', '2009-07-31 12:00:00', '2009-07-31 15:00:00', ' Mansfield, MA ');
INSERT INTO `events` VALUES ('46', ' Borgata Hotel Casino & Spa ', '2009-08-01 15:00:00', '2009-08-01 18:00:00', ' Atlantic City, NJ ');
INSERT INTO `events` VALUES ('47', ' Madison Square Garden ', '2009-08-03 14:00:00', '2009-08-03 17:00:00', ' New York, NY ');
INSERT INTO `events` VALUES ('48', ' Madison Square Garden ', '2009-08-04 15:00:00', '2009-08-04 18:00:00', ' New York, NY ');
INSERT INTO `events` VALUES ('49', ' Key Arena ', '2009-08-10 16:00:00', '2009-08-10 19:00:00', ' Seattle, WA ');
INSERT INTO `events` VALUES ('50', ' Shoreline Amphitheatre ', '2009-08-12 11:00:00', '2009-08-12 14:00:00', ' Mountain View, CA ');
INSERT INTO `events` VALUES ('51', ' Cricket Wireless Amphitheatre ', '2009-08-14 19:00:00', '2009-08-14 22:00:00', ' Chula Vista, CA ');
INSERT INTO `events` VALUES ('52', ' Hollywood Bowl ', '2009-08-16 17:00:00', '2009-08-16 20:00:00', ' Los Angeles, CA ');
INSERT INTO `events` VALUES ('53', ' Hollywood Bowl ', '2009-08-17 13:00:00', '2009-08-17 16:00:00', ' Los Angeles, CA ');
INSERT INTO `events` VALUES ('54', ' Honda Center ', '2009-08-19 17:00:00', '2009-08-19 20:00:00', ' Anaheim, CA ');
INSERT INTO `events` VALUES ('55', ' Santa Barbara Bowl ', '2009-08-20 16:00:00', '2009-08-20 19:00:00', ' Santa Barbara, CA ');
INSERT INTO `events` VALUES ('56', ' Palms Casino-the Pearl ', '2009-08-22 10:00:00', '2009-08-22 13:00:00', ' Las Vegas, NV ');
INSERT INTO `events` VALUES ('57', ' US Airways Center ', '2009-08-23 18:00:00', '2009-08-23 21:00:00', ' Phoenix, AZ ');
INSERT INTO `events` VALUES ('58', ' E Center ', '2009-08-25 15:00:00', '2009-08-25 18:00:00', ' West Valley City, UT ');
INSERT INTO `events` VALUES ('59', ' Red Rocks Amphitheatre ', '2009-08-27 18:00:00', '2009-08-27 21:00:00', ' Morrison, CO ');
INSERT INTO `events` VALUES ('60', ' Superpages.com Center ', '2009-08-29 17:00:00', '2009-08-29 20:00:00', ' Dallas, TX ');
INSERT INTO `events` VALUES ('61', ' Cynthia Woods Mitchell Pavilion ', '2009-08-30 18:00:00', '2009-08-30 21:00:00', ' Houston, TX ');
INSERT INTO `events` VALUES ('62', ' Lakewood Amphitheatre ', '2009-09-01 15:00:00', '2009-09-01 18:00:00', ' Atlanta, GA ');
INSERT INTO `events` VALUES ('63', ' Ford Amphitheatre at the Florida State Fairgrounds ', '2009-09-04 10:00:00', '2009-09-04 13:00:00', ' Tampa Bay, FL ');
INSERT INTO `events` VALUES ('64', ' BankAtlantic Center ', '2009-09-05 13:00:00', '2009-09-05 16:00:00', ' Sunrise, FL ');
INSERT INTO `events` VALUES ('65', ' Konig Pilsener Arena ', '2009-10-31 17:00:00', '2009-10-31 20:00:00', ' Oberhausen, GER ');
INSERT INTO `events` VALUES ('66', ' Awd Dome ', '2009-11-01 13:00:00', '2009-11-01 16:00:00', ' Bremen, GER ');
INSERT INTO `events` VALUES ('67', ' TUI Arena (formerly Preussag Arena) ', '2009-11-03 14:00:00', '2009-11-03 17:00:00', ' Hanover, GER ');
INSERT INTO `events` VALUES ('68', ' SAP Arena ', '2009-11-07 13:00:00', '2009-11-07 16:00:00', ' Mannheim, GER ');
INSERT INTO `events` VALUES ('69', ' Schleyerhalle ', '2009-11-08 12:00:00', '2009-11-08 15:00:00', ' Stuttgart, GER ');
INSERT INTO `events` VALUES ('70', ' Stade De Geneve ', '2009-11-10 17:00:00', '2009-11-10 20:00:00', ' Geneva, CH ');
INSERT INTO `events` VALUES ('71', ' Recinto Ferial - Valencia ', '2009-11-12 15:00:00', '2009-11-12 18:00:00', ' Valencia, Spain ');
INSERT INTO `events` VALUES ('72', ' Palau Sant Jordi ', '2009-11-20 12:00:00', '2009-11-20 15:00:00', ' Barcelona, Spain ');
INSERT INTO `events` VALUES ('73', ' Halle Tony Garnier ', '2009-11-23 20:00:00', '2009-11-23 23:00:00', ' Lyon, FRA ');
INSERT INTO `events` VALUES ('74', ' Arena Nurnberg ', '2009-12-01 13:00:00', '2009-12-01 16:00:00', ' Nuremberg, GER ');
INSERT INTO `events` VALUES ('75', ' Stadthalle ', '2009-12-03 14:00:00', '2009-12-03 17:00:00', ' Vienna, Austria ');
INSERT INTO `events` VALUES ('76', ' Stadthalle Graz ', '2009-12-04 13:00:00', '2009-12-04 16:00:00', ' Graz, AT ');
INSERT INTO `events` VALUES ('77', ' Hallenstadion ', '2009-12-06 16:00:00', '2009-12-06 19:00:00', ' Zurich, CH ');
INSERT INTO `events` VALUES ('78', ' Hallenstadion ', '2009-12-07 10:00:00', '2009-12-07 13:00:00', ' Zurich, CH ');
INSERT INTO `events` VALUES ('79', ' The O2 - Dublin ', '2009-12-10 17:00:00', '2009-12-10 20:00:00', ' Dublin, IE ');
INSERT INTO `events` VALUES ('80', ' Scottish Exhibition & Conference Center ', '2009-12-12 14:00:00', '2009-12-12 17:00:00', ' Glasgow, Scotland ');
INSERT INTO `events` VALUES ('81', ' LG Arena ', '2009-12-13 15:00:00', '2009-12-13 18:00:00', ' Birmingham, ENG ');
INSERT INTO `events` VALUES ('82', ' O2 Dome ', '2009-12-15 13:00:00', '2009-12-15 16:00:00', ' London, ENG ');
INSERT INTO `events` VALUES ('83', ' O2 Dome ', '2009-12-16 15:00:00', '2009-12-16 18:00:00', ' London, ENG ');
INSERT INTO `events` VALUES ('84', ' MEN Arena Manchester ', '2009-12-18 16:00:00', '2009-12-18 19:00:00', ' Manchester, ENG ');
INSERT INTO `events` VALUES ('85', 'test', '2010-08-31 00:00:00', '2010-09-03 00:00:00', '');
INSERT INTO `events` VALUES ('86', 'asasasasa', '2010-08-31 04:00:00', '2010-08-31 04:05:00', '');
INSERT INTO `events` VALUES ('87', 'sdsds', '2010-09-21 04:20:00', '2010-09-21 09:40:00', '');
INSERT INTO `events_rec` VALUES ('1', '2009-06-01 00:00:00', '9999-02-01 00:00:00', 'Second Friday', 'month_1_5_2_#no', '0', '86400');
INSERT INTO `events_rec` VALUES ('2', '2009-06-29 10:00:00', '9999-02-01 00:00:00', 'Test build', 'week_1___1,3,5#no', '0', '3600');
INSERT INTO `events_rec` VALUES ('3', '2009-07-22 10:00:00', '2009-07-22 11:00:00', '', 'none', '2', '1248246000');
INSERT INTO `events_rec` VALUES ('4', '2009-07-21 00:00:00', '2009-08-30 00:00:00', 'Each 8 days, 5 times', 'day_8___#5', '0', '172800');
INSERT INTO `events_rec` VALUES ('5', '2009-07-16 10:00:00', '2009-07-16 11:00:00', 'Test build', '', '2', '1247814000');
INSERT INTO `events_rec` VALUES ('6', '2009-06-29 10:00:00', '2009-06-29 11:00:00', '', 'none', '2', '1246258800');
INSERT INTO `events_rec` VALUES ('15', '2009-07-06 00:00:00', '2009-07-19 23:59:00', '2 Wed', 'week_1___0#2', '0', '300');
INSERT INTO `events_rec` VALUES ('17', '2009-07-01 00:00:00', '2009-08-04 23:59:00', 'New event', 'month_1_2_2_#2', '0', '300');
INSERT INTO `events_rec` VALUES ('19', '2009-07-01 00:00:00', '9999-02-01 00:00:00', '2nd monday', 'month_1_2_1_#no', '0', '300');
INSERT INTO `events_rec` VALUES ('20', '2009-01-01 00:00:00', '9999-02-01 00:00:00', 'New event', 'year_1_1_2_#no', '0', '300');
INSERT INTO `events_rec` VALUES ('21', '2010-01-31 00:00:00', '9999-02-01 00:00:00', 'New event', 'month_1___#no', '0', '86400');
INSERT INTO `events_rec` VALUES ('22', '2010-09-01 00:00:00', '2010-09-01 00:05:00', 'New event', '', '0', '0');
INSERT INTO `events_shared` VALUES ('4', '2009-06-17 09:05:00', '2009-06-17 16:55:00', 'New event', '1', '1');
INSERT INTO `events_shared` VALUES ('2', '2009-06-03 00:00:00', '2009-06-06 00:00:00', 'New event', '0', '1');
INSERT INTO `events_shared` VALUES ('3', '2009-06-09 00:00:00', '2009-06-12 00:00:00', 'New event', '0', '1');
INSERT INTO `events_shared` VALUES ('5', '2009-06-03 00:00:00', '2009-06-05 00:00:00', 'USer 2 event', '1', '2');
INSERT INTO `events_shared` VALUES ('6', '2009-06-02 00:00:00', '2009-06-06 00:00:00', 'user 2', '1', '2');
INSERT INTO `events_shared` VALUES ('7', '2009-06-03 00:00:00', '2009-06-06 00:00:00', 'New event', '1', '2');
INSERT INTO `events_shared` VALUES ('8', '2009-06-10 00:00:00', '2009-06-12 00:00:00', '234', '0', '2');
INSERT INTO `events_shared` VALUES ('9', '2009-06-18 21:15:00', '2009-06-18 22:55:00', 'Some event', '1', '2');
INSERT INTO `events_shared` VALUES ('10', '2009-06-05 00:00:00', '2009-06-07 00:00:00', 'asd adf', '1', '1');
INSERT INTO `events_shared` VALUES ('11', '2009-06-09 00:00:00', '2009-06-10 16:55:00', 'Some event', '0', '1');
INSERT INTO `grid50` VALUES ('2', 'aaasa', '752aasasa');
INSERT INTO `grid50` VALUES ('3', 'apocryphal', '75');
INSERT INTO `grid50` VALUES ('4', 'viperish', '220852');
INSERT INTO `grid50` VALUES ('5', '2', '674076');
INSERT INTO `grid50` VALUES ('6', 'chiffonnier', '938389');
INSERT INTO `grid50` VALUES ('7', '1', '918346');
INSERT INTO `grid50` VALUES ('8', '193', '294064');
INSERT INTO `grid50` VALUES ('9', 'darkener', '937704');
INSERT INTO `grid50` VALUES ('10', '174', '918741');
INSERT INTO `grid50` VALUES ('11', 'pinkens', '91');
INSERT INTO `grid50` VALUES ('12', 'Cointreaus', '75');
INSERT INTO `grid50` VALUES ('13', 'irreducibility', '153152');
INSERT INTO `grid50` VALUES ('14', 'shatterbrained', '364164');
INSERT INTO `grid50` VALUES ('15', 'fillipeen', '557770');
INSERT INTO `grid50` VALUES ('16', '192', '420445');
INSERT INTO `grid50` VALUES ('17', 'redcoats', '129838');
INSERT INTO `grid50` VALUES ('18', 'dearie', '685602');
INSERT INTO `grid50` VALUES ('19', 'yarphas', '216289');
INSERT INTO `grid50` VALUES ('20', 'isogonals', '197538');
INSERT INTO `grid50` VALUES ('21', 'toiseach', '516681');
INSERT INTO `grid50` VALUES ('22', 'oftest', '775798');
INSERT INTO `grid50` VALUES ('23', 'brogging', '595537');
INSERT INTO `grid50` VALUES ('24', 'reblooming', '7561243343434');
INSERT INTO `grid50` VALUES ('25', 'incitative', '530500');
INSERT INTO `grid50` VALUES ('26', 'diegeses', '823797');
INSERT INTO `grid50` VALUES ('27', 'sadly', '696283');
INSERT INTO `grid50` VALUES ('28', 'capablest', '340798');
INSERT INTO `grid50` VALUES ('29', 'wolves', '684415');
INSERT INTO `grid50` VALUES ('30', 'precriticize', '586544');
INSERT INTO `grid50` VALUES ('31', 'Fanfani', '815595');
INSERT INTO `grid50` VALUES ('32', 'dichrooscopic', '220852');
INSERT INTO `grid50` VALUES ('33', 'impressionably', '195244');
INSERT INTO `grid50` VALUES ('34', 'disinfectant', '253080');
INSERT INTO `grid50` VALUES ('35', 'batteries', '818444');
INSERT INTO `grid50` VALUES ('36', 'festiveness', '369281');
INSERT INTO `grid50` VALUES ('37', 'crosstie', '440304');
INSERT INTO `grid50` VALUES ('38', 'squirarchal', '444550');
INSERT INTO `grid50` VALUES ('39', 'Ganges', '137697');
INSERT INTO `grid50` VALUES ('40', 'ecus', '326978');
INSERT INTO `grid50` VALUES ('41', 'falsifies', '636415');
INSERT INTO `grid50` VALUES ('42', 'utopiasts', '485798');
INSERT INTO `grid50` VALUES ('43', 'pursership', '366722');
INSERT INTO `grid50` VALUES ('44', 'petulancy', '931137');
INSERT INTO `grid50` VALUES ('45', 'resp', '432497');
INSERT INTO `grid50` VALUES ('46', 'gizzards', '133767');
INSERT INTO `grid50` VALUES ('47', 'scroungers', '938389');
INSERT INTO `grid50` VALUES ('48', 'outdoer', '858452');
INSERT INTO `grid50` VALUES ('49', 'dipyridamoles', '773767');
INSERT INTO `grid50` VALUES ('50', 'presale', '441702');
INSERT INTO `grid50000` VALUES ('782', 'deleted', '1asasa');
INSERT INTO `grid50000` VALUES ('783', 'deleted', '12s65465465');
INSERT INTO `grid50000` VALUES ('784', 'seemedasas', '18381184test3');
INSERT INTO `grid50000` VALUES ('785', 'surprised', '1283811843test');
INSERT INTO `grid50000` VALUES ('786', 'at', '83811843343');
INSERT INTO `grid50000` VALUES ('787', 'all', '83811843');
INSERT INTO `grid50000` VALUES ('788', 'at', '83811843Ñ‡');
INSERT INTO `grid50000` VALUES ('789', 'this', '83811843');
INSERT INTO `grid50000` VALUES ('790', '', '83811843');
INSERT INTO `grid50000` VALUES ('791', 'neither', '83811843');
INSERT INTO `grid50000` VALUES ('792', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('793', 'humans', '83811843s');
INSERT INTO `grid50000` VALUES ('794', 'nor', '83811843');
INSERT INTO `grid50000` VALUES ('795', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('796', 'horse', '83811843');
INSERT INTO `grid50000` VALUES ('797', 'nor', '83811843');
INSERT INTO `grid50000` VALUES ('798', 'even', '83811843');
INSERT INTO `grid50000` VALUES ('799', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('800', 'man', '83811843');
INSERT INTO `grid50000` VALUES ('801', 'himself', '83811843');
INSERT INTO `grid50000` VALUES ('802', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('803', 'Przemysl', '83811843');
INSERT INTO `grid50000` VALUES ('804', 'Ploughman', '83811843');
INSERT INTO `grid50000` VALUES ('805', 'Premysl', '83811843');
INSERT INTO `grid50000` VALUES ('806', 'Orac', '83811843');
INSERT INTO `grid50000` VALUES ('807', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('808', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('809', 'came', '83811843');
INSERT INTO `grid50000` VALUES ('810', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('811', 'Vysehrad', '83811843');
INSERT INTO `grid50000` VALUES ('812', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('813', 'married', '83811843');
INSERT INTO `grid50000` VALUES ('814', 'Libuse', '83811843');
INSERT INTO `grid50000` VALUES ('815', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('816', 'took', '83811843');
INSERT INTO `grid50000` VALUES ('817', 'over', '83811843');
INSERT INTO `grid50000` VALUES ('818', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('819', 'job', '83811843');
INSERT INTO `grid50000` VALUES ('820', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('821', 'ruling', '83811843');
INSERT INTO `grid50000` VALUES ('822', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('823', 'unruly', '83811843');
INSERT INTO `grid50000` VALUES ('824', 'Czechs', '83811843');
INSERT INTO `grid50000` VALUES ('825', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('826', 'he', '83811843');
INSERT INTO `grid50000` VALUES ('827', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('828', 'Libuse', '83811843');
INSERT INTO `grid50000` VALUES ('829', 'together', '83811843');
INSERT INTO `grid50000` VALUES ('830', 'started', '83811843');
INSERT INTO `grid50000` VALUES ('831', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('832', 'Przemyslid', '83811843');
INSERT INTO `grid50000` VALUES ('833', 'Dynasty', '83811843');
INSERT INTO `grid50000` VALUES ('834', 'which', '83811843');
INSERT INTO `grid50000` VALUES ('835', 'ruled', '83811843');
INSERT INTO `grid50000` VALUES ('836', 'over', '83811843');
INSERT INTO `grid50000` VALUES ('837', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('838', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('839', 'lands', '83811843');
INSERT INTO `grid50000` VALUES ('840', 'till', '83811843');
INSERT INTO `grid50000` VALUES ('841', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('842', 'th', '83811843');
INSERT INTO `grid50000` VALUES ('843', 'century', '83811843');
INSERT INTO `grid50000` VALUES ('844', '', '83811843');
INSERT INTO `grid50000` VALUES ('845', '\r\nOne', '83811843');
INSERT INTO `grid50000` VALUES ('846', 'day', '83811843');
INSERT INTO `grid50000` VALUES ('847', 'not', '83811843');
INSERT INTO `grid50000` VALUES ('848', 'long', '83811843');
INSERT INTO `grid50000` VALUES ('849', 'after', '83811843');
INSERT INTO `grid50000` VALUES ('850', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('851', 'wedding', '83811843');
INSERT INTO `grid50000` VALUES ('852', 'Libuse', '83811843');
INSERT INTO `grid50000` VALUES ('853', 'had', '83811843');
INSERT INTO `grid50000` VALUES ('854', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('855', 'vision', '83811843');
INSERT INTO `grid50000` VALUES ('856', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('857', 'which', '83811843');
INSERT INTO `grid50000` VALUES ('858', 'she', '83811843');
INSERT INTO `grid50000` VALUES ('859', 'foretold', '83811843');
INSERT INTO `grid50000` VALUES ('860', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('861', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('862', 'glory', '83811843');
INSERT INTO `grid50000` VALUES ('863', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('864', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('865', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('866', 'capital', '83811843');
INSERT INTO `grid50000` VALUES ('867', 'Standing', '83811843');
INSERT INTO `grid50000` VALUES ('868', 'atop', '83811843');
INSERT INTO `grid50000` VALUES ('869', 'Vysehrad', '83811843');
INSERT INTO `grid50000` VALUES ('870', 'hill', '83811843');
INSERT INTO `grid50000` VALUES ('871', 'she', '83811843');
INSERT INTO `grid50000` VALUES ('872', 'went', '83811843');
INSERT INTO `grid50000` VALUES ('873', 'into', '83811843');
INSERT INTO `grid50000` VALUES ('874', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('875', 'trance', '83811843');
INSERT INTO `grid50000` VALUES ('876', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('877', 'told', '83811843');
INSERT INTO `grid50000` VALUES ('878', 'her', '83811843');
INSERT INTO `grid50000` VALUES ('879', 'vision', '83811843');
INSERT INTO `grid50000` VALUES ('880', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('881', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('882', 'people', '83811843');
INSERT INTO `grid50000` VALUES ('883', 'even', '83811843');
INSERT INTO `grid50000` VALUES ('884', 'as', '83811843');
INSERT INTO `grid50000` VALUES ('885', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('886', 'gods', '83811843');
INSERT INTO `grid50000` VALUES ('887', 'sent', '83811843');
INSERT INTO `grid50000` VALUES ('888', 'it', '83811843');
INSERT INTO `grid50000` VALUES ('889', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('890', 'her', '83811843');
INSERT INTO `grid50000` VALUES ('891', 'She', '83811843');
INSERT INTO `grid50000` VALUES ('892', 'said', '83811843');
INSERT INTO `grid50000` VALUES ('893', 'that', '83811843');
INSERT INTO `grid50000` VALUES ('894', 'on', '83811843');
INSERT INTO `grid50000` VALUES ('895', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('896', 'seven', '83811843');
INSERT INTO `grid50000` VALUES ('897', 'hills', '83811843');
INSERT INTO `grid50000` VALUES ('898', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('899', 'Prague', '83811843');
INSERT INTO `grid50000` VALUES ('900', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('901', 'fair', '83811843');
INSERT INTO `grid50000` VALUES ('902', 'city', '83811843');
INSERT INTO `grid50000` VALUES ('903', 'would', '83811843');
INSERT INTO `grid50000` VALUES ('904', 'grow', '83811843');
INSERT INTO `grid50000` VALUES ('905', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('906', 'fame', '83811843');
INSERT INTO `grid50000` VALUES ('907', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('921', 'all', '83811843');
INSERT INTO `grid50000` VALUES ('922', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('923', 'which', '83811843');
INSERT INTO `grid50000` VALUES ('924', 'she', '83811843');
INSERT INTO `grid50000` VALUES ('925', 'foretold', '83811843');
INSERT INTO `grid50000` VALUES ('926', 'really', '83811843');
INSERT INTO `grid50000` VALUES ('927', 'came', '83811843');
INSERT INTO `grid50000` VALUES ('928', 'true', '83811843');
INSERT INTO `grid50000` VALUES ('929', 'Of', '83811843');
INSERT INTO `grid50000` VALUES ('930', 'course!', '83811843');
INSERT INTO `grid50000` VALUES ('931', '\r\nNo', '83811843');
INSERT INTO `grid50000` VALUES ('932', 'while', '83811843');
INSERT INTO `grid50000` VALUES ('933', 'Cech', '83811843');
INSERT INTO `grid50000` VALUES ('934', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('935', 'Libuse', '83811843');
INSERT INTO `grid50000` VALUES ('936', 'are', '83811843');
INSERT INTO `grid50000` VALUES ('937', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('938', 'stuff', '83811843');
INSERT INTO `grid50000` VALUES ('939', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('940', 'imaginative', '83811843');
INSERT INTO `grid50000` VALUES ('941', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('942', 'legend', '83811843');
INSERT INTO `grid50000` VALUES ('943', 'it', '83811843');
INSERT INTO `grid50000` VALUES ('944', 'is', '83811843');
INSERT INTO `grid50000` VALUES ('945', 'believed', '83811843');
INSERT INTO `grid50000` VALUES ('946', 'that', '83811843');
INSERT INTO `grid50000` VALUES ('947', 'Samo', '83811843');
INSERT INTO `grid50000` VALUES ('948', '', '83811843');
INSERT INTO `grid50000` VALUES ('949', 'who', '83811843');
INSERT INTO `grid50000` VALUES ('950', 'may', '83811843');
INSERT INTO `grid50000` VALUES ('951', 'or', '83811843');
INSERT INTO `grid50000` VALUES ('952', 'may', '83811843');
INSERT INTO `grid50000` VALUES ('953', 'not', '83811843');
INSERT INTO `grid50000` VALUES ('954', 'have', '83811843');
INSERT INTO `grid50000` VALUES ('955', 'ruled', '83811843');
INSERT INTO `grid50000` VALUES ('956', 'this', '83811843');
INSERT INTO `grid50000` VALUES ('957', 'part', '83811843');
INSERT INTO `grid50000` VALUES ('958', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('959', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('960', 'world', '83811843');
INSERT INTO `grid50000` VALUES ('961', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('962', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('963', 'first', '83811843');
INSERT INTO `grid50000` VALUES ('964', 'half', '83811843');
INSERT INTO `grid50000` VALUES ('965', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('1761', 'inhabitants', '83811843');
INSERT INTO `grid50000` VALUES ('1762', 'Adalbert', '83811843');
INSERT INTO `grid50000` VALUES ('1763', 'or', '83811843');
INSERT INTO `grid50000` VALUES ('1764', 'Vojtech', '83811843');
INSERT INTO `grid50000` VALUES ('1765', 'as', '83811843');
INSERT INTO `grid50000` VALUES ('1766', 'he', '83811843');
INSERT INTO `grid50000` VALUES ('1767', 'is', '83811843');
INSERT INTO `grid50000` VALUES ('1768', 'known', '83811843');
INSERT INTO `grid50000` VALUES ('1769', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('1770', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('1771', 'is', '83811843');
INSERT INTO `grid50000` VALUES ('1772', 'another', '83811843');
INSERT INTO `grid50000` VALUES ('1773', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('1774', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('1775', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('1776', 'nations', '83811843');
INSERT INTO `grid50000` VALUES ('1777', 'patron', '83811843');
INSERT INTO `grid50000` VALUES ('1778', 'saints', '83811843');
INSERT INTO `grid50000` VALUES ('1779', 'today', '83811843');
INSERT INTO `grid50000` VALUES ('1780', '\r\n', '83811843');
INSERT INTO `grid50000` VALUES ('1781', '\r\n\r\nBut', '83811843');
INSERT INTO `grid50000` VALUES ('1782', 'Vojtech', '83811843');
INSERT INTO `grid50000` VALUES ('1783', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('1784', 'not', '83811843');
INSERT INTO `grid50000` VALUES ('1785', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('1786', 'only', '83811843');
INSERT INTO `grid50000` VALUES ('1787', 'early', '83811843');
INSERT INTO `grid50000` VALUES ('1788', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('1789', 'guy', '83811843');
INSERT INTO `grid50000` VALUES ('1790', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('1791', 'be', '83811843');
INSERT INTO `grid50000` VALUES ('1792', 'made', '83811843');
INSERT INTO `grid50000` VALUES ('1793', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('1794', 'saint', '83811843');
INSERT INTO `grid50000` VALUES ('1795', 'thanks', '83811843');
INSERT INTO `grid50000` VALUES ('1796', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('1797', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('1798', 'Przemyslids', '83811843');
INSERT INTO `grid50000` VALUES ('1799', 'bloodthirstiness', '83811843');
INSERT INTO `grid50000` VALUES ('1800', 'On', '83811843');
INSERT INTO `grid50000` VALUES ('1801', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('1802', 'contrary', '83811843');
INSERT INTO `grid50000` VALUES ('1803', '', '83811843');
INSERT INTO `grid50000` VALUES ('1804', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('1805', 'Przemyslid', '83811843');
INSERT INTO `grid50000` VALUES ('1806', 'rulers', '83811843');
INSERT INTO `grid50000` VALUES ('1807', 'were', '83811843');
INSERT INTO `grid50000` VALUES ('1808', 'rather', '83811843');
INSERT INTO `grid50000` VALUES ('1809', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('1810', 'mixed', '83811843');
INSERT INTO `grid50000` VALUES ('1811', 'bag', '83811843');
INSERT INTO `grid50000` VALUES ('1812', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('1813', 'when', '83811843');
INSERT INTO `grid50000` VALUES ('1814', 'they', '83811843');
INSERT INTO `grid50000` VALUES ('1815', 'ran', '83811843');
INSERT INTO `grid50000` VALUES ('1816', 'out', '83811843');
INSERT INTO `grid50000` VALUES ('1817', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('1818', 'rival', '83811843');
INSERT INTO `grid50000` VALUES ('1819', 'clans', '83811843');
INSERT INTO `grid50000` VALUES ('1820', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('1821', 'murder', '83811843');
INSERT INTO `grid50000` VALUES ('1822', 'they', '83811843');
INSERT INTO `grid50000` VALUES ('1823', 'started', '83811843');
INSERT INTO `grid50000` VALUES ('1824', 'murdering', '83811843');
INSERT INTO `grid50000` VALUES ('1825', 'each', '83811843');
INSERT INTO `grid50000` VALUES ('1826', 'other', '83811843');
INSERT INTO `grid50000` VALUES ('1827', '', '83811843');
INSERT INTO `grid50000` VALUES ('1828', 'resulting', '83811843');
INSERT INTO `grid50000` VALUES ('1829', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('1830', 'some', '83811843');
INSERT INTO `grid50000` VALUES ('1831', 'more', '83811843');
INSERT INTO `grid50000` VALUES ('1832', 'early', '83811843');
INSERT INTO `grid50000` VALUES ('1833', 'saints', '83811843');
INSERT INTO `grid50000` VALUES ('1834', 'for', '83811843');
INSERT INTO `grid50000` VALUES ('1835', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('1836', 'Czechs', '83811843');
INSERT INTO `grid50000` VALUES ('1837', '\r\n\r\nWenceslas', '83811843');
INSERT INTO `grid50000` VALUES ('1838', 'I', '83811843');
INSERT INTO `grid50000` VALUES ('1839', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('1840', 'fourth', '83811843');
INSERT INTO `grid50000` VALUES ('1841', 'Przemyslid', '83811843');
INSERT INTO `grid50000` VALUES ('1842', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('1843', 'ruler', '83811843');
INSERT INTO `grid50000` VALUES ('1844', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('1845', 'made', '83811843');
INSERT INTO `grid50000` VALUES ('1846', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('1847', 'saint', '83811843');
INSERT INTO `grid50000` VALUES ('1848', 'soon', '83811843');
INSERT INTO `grid50000` VALUES ('1849', 'after', '83811843');
INSERT INTO `grid50000` VALUES ('1850', 'his', '83811843');
INSERT INTO `grid50000` VALUES ('1851', 'murder', '83811843');
INSERT INTO `grid50000` VALUES ('1852', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('1853', '929', '83811843');
INSERT INTO `grid50000` VALUES ('1854', 'or', '83811843');
INSERT INTO `grid50000` VALUES ('1855', '935', '83811843');
INSERT INTO `grid50000` VALUES ('1856', 'This', '83811843');
INSERT INTO `grid50000` VALUES ('1857', 'Wenceslas', '83811843');
INSERT INTO `grid50000` VALUES ('1858', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('1859', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('1860', 'Vaclav', '83811843');
INSERT INTO `grid50000` VALUES ('1861', 'is', '83811843');
INSERT INTO `grid50000` VALUES ('1862', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('1863', 'Good', '83811843');
INSERT INTO `grid50000` VALUES ('1864', 'King', '83811843');
INSERT INTO `grid50000` VALUES ('1865', 'Wenceslas', '83811843');
INSERT INTO `grid50000` VALUES ('1866', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('1867', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('1868', 'Christmas', '83811843');
INSERT INTO `grid50000` VALUES ('1869', 'carol', '83811843');
INSERT INTO `grid50000` VALUES ('1870', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('1872', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('1873', 'during', '83811843');
INSERT INTO `grid50000` VALUES ('1874', 'his', '83811843');
INSERT INTO `grid50000` VALUES ('1875', 'reign', '83811843');
INSERT INTO `grid50000` VALUES ('1876', 'that', '83811843');
INSERT INTO `grid50000` VALUES ('1877', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('1878', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('1879', 'lands', '83811843');
INSERT INTO `grid50000` VALUES ('1880', 'entered', '83811843');
INSERT INTO `grid50000` VALUES ('1881', 'into', '83811843');
INSERT INTO `grid50000` VALUES ('1882', 'an', '83811843');
INSERT INTO `grid50000` VALUES ('1883', 'alliance', '83811843');
INSERT INTO `grid50000` VALUES ('1884', 'with', '83811843');
INSERT INTO `grid50000` VALUES ('1885', 'Saxony', '83811843');
INSERT INTO `grid50000` VALUES ('1886', 'thereby', '83811843');
INSERT INTO `grid50000` VALUES ('1887', 'laying', '83811843');
INSERT INTO `grid50000` VALUES ('1888', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('1889', 'foundations', '83811843');
INSERT INTO `grid50000` VALUES ('1890', 'for', '83811843');
INSERT INTO `grid50000` VALUES ('1891', 'closer', '83811843');
INSERT INTO `grid50000` VALUES ('1892', 'relations', '83811843');
INSERT INTO `grid50000` VALUES ('1893', 'with', '83811843');
INSERT INTO `grid50000` VALUES ('1894', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('1895', 'restored', '83811843');
INSERT INTO `grid50000` VALUES ('1896', 'Roman', '83811843');
INSERT INTO `grid50000` VALUES ('1897', 'Empire', '83811843');
INSERT INTO `grid50000` VALUES ('1898', '\r\n\r\nThis', '83811843');
INSERT INTO `grid50000` VALUES ('1899', 'mischievous', '83811843');
INSERT INTO `grid50000` VALUES ('1900', 'affability', '83811843');
INSERT INTO `grid50000` VALUES ('1901', 'on', '83811843');
INSERT INTO `grid50000` VALUES ('1902', 'Wenceslas', '83811843');
INSERT INTO `grid50000` VALUES ('1903', 'part', '83811843');
INSERT INTO `grid50000` VALUES ('1904', 'towards', '83811843');
INSERT INTO `grid50000` VALUES ('1905', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('1906', 'Czechs', '83811843');
INSERT INTO `grid50000` VALUES ('1907', 'western', '83811843');
INSERT INTO `grid50000` VALUES ('1908', 'neighbors', '83811843');
INSERT INTO `grid50000` VALUES ('1909', 'is', '83811843');
INSERT INTO `grid50000` VALUES ('1910', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('1911', 'main', '83811843');
INSERT INTO `grid50000` VALUES ('1912', 'reason', '83811843');
INSERT INTO `grid50000` VALUES ('1913', 'that', '83811843');
INSERT INTO `grid50000` VALUES ('1914', 'he', '83811843');
INSERT INTO `grid50000` VALUES ('1915', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('1916', 'killed', '83811843');
INSERT INTO `grid50000` VALUES ('1917', 'by', '83811843');
INSERT INTO `grid50000` VALUES ('1918', 'his', '83811843');
INSERT INTO `grid50000` VALUES ('1919', 'brother', '83811843');
INSERT INTO `grid50000` VALUES ('1920', 'who', '83811843');
INSERT INTO `grid50000` VALUES ('1921', 'wasnt', '83811843');
INSERT INTO `grid50000` VALUES ('1922', 'very', '83811843');
INSERT INTO `grid50000` VALUES ('1923', 'good', '83811843');
INSERT INTO `grid50000` VALUES ('1924', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('1925', 'fact', '83811843');
INSERT INTO `grid50000` VALUES ('1926', 'he', '83811843');
INSERT INTO `grid50000` VALUES ('1927', 'is', '83811843');
INSERT INTO `grid50000` VALUES ('1928', 'known', '83811843');
INSERT INTO `grid50000` VALUES ('1929', 'as', '83811843');
INSERT INTO `grid50000` VALUES ('1930', 'Boleslav', '83811843');
INSERT INTO `grid50000` VALUES ('1931', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('1932', 'Cruel', '83811843');
INSERT INTO `grid50000` VALUES ('1933', 'Another', '83811843');
INSERT INTO `grid50000` VALUES ('1934', 'reason', '83811843');
INSERT INTO `grid50000` VALUES ('1935', 'might', '83811843');
INSERT INTO `grid50000` VALUES ('1936', 'be', '83811843');
INSERT INTO `grid50000` VALUES ('1937', 'that', '83811843');
INSERT INTO `grid50000` VALUES ('1938', 'Boleslav', '83811843');
INSERT INTO `grid50000` VALUES ('1939', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('1940', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('1941', 'pagan', '83811843');
INSERT INTO `grid50000` VALUES ('1942', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('1943', 'he', '83811843');
INSERT INTO `grid50000` VALUES ('1944', 'felt', '83811843');
INSERT INTO `grid50000` VALUES ('1945', 'that', '83811843');
INSERT INTO `grid50000` VALUES ('1946', 'Wenceslas', '83811843');
INSERT INTO `grid50000` VALUES ('1947', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('1948', 'frittering', '83811843');
INSERT INTO `grid50000` VALUES ('1949', 'away', '83811843');
INSERT INTO `grid50000` VALUES ('1950', 'too', '83811843');
INSERT INTO `grid50000` VALUES ('1951', 'much', '83811843');
INSERT INTO `grid50000` VALUES ('1952', 'time', '83811843');
INSERT INTO `grid50000` VALUES ('1953', 'with', '83811843');
INSERT INTO `grid50000` VALUES ('1954', 'this', '83811843');
INSERT INTO `grid50000` VALUES ('1955', 'new', '83811843');
INSERT INTO `grid50000` VALUES ('1956', 'Christian', '83811843');
INSERT INTO `grid50000` VALUES ('1957', 'fashion', '83811843');
INSERT INTO `grid50000` VALUES ('1958', 'hed', '83811843');
INSERT INTO `grid50000` VALUES ('1959', 'picked', '83811843');
INSERT INTO `grid50000` VALUES ('1960', 'up', '83811843');
INSERT INTO `grid50000` VALUES ('1961', '', '83811843');
INSERT INTO `grid50000` VALUES ('1962', 'though', '83811843');
INSERT INTO `grid50000` VALUES ('1963', 'lust', '83811843');
INSERT INTO `grid50000` VALUES ('1964', 'for', '83811843');
INSERT INTO `grid50000` VALUES ('1965', 'power', '83811843');
INSERT INTO `grid50000` VALUES ('1966', 'probably', '83811843');
INSERT INTO `grid50000` VALUES ('1967', 'also', '83811843');
INSERT INTO `grid50000` VALUES ('1968', 'played', '83811843');
INSERT INTO `grid50000` VALUES ('1969', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('1970', 'role', '83811843');
INSERT INTO `grid50000` VALUES ('1971', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('1972', 'Boleslavs', '83811843');
INSERT INTO `grid50000` VALUES ('1973', 'motive', '83811843');
INSERT INTO `grid50000` VALUES ('1974', 'for', '83811843');
INSERT INTO `grid50000` VALUES ('1975', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('1976', 'murder', '83811843');
INSERT INTO `grid50000` VALUES ('1977', 'which', '83811843');
INSERT INTO `grid50000` VALUES ('1978', 'took', '83811843');
INSERT INTO `grid50000` VALUES ('1979', 'place', '83811843');
INSERT INTO `grid50000` VALUES ('1980', 'at', '83811843');
INSERT INTO `grid50000` VALUES ('1981', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('1982', 'very', '83811843');
INSERT INTO `grid50000` VALUES ('1983', 'door', '83811843');
INSERT INTO `grid50000` VALUES ('1984', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('1985', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('1986', 'church', '83811843');
INSERT INTO `grid50000` VALUES ('1987', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('1988', 'Stara', '83811843');
INSERT INTO `grid50000` VALUES ('1989', 'Boleslav', '83811843');
INSERT INTO `grid50000` VALUES ('1990', 'where', '83811843');
INSERT INTO `grid50000` VALUES ('1991', 'Wenceslas', '83811843');
INSERT INTO `grid50000` VALUES ('1992', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('1993', 'trying', '83811843');
INSERT INTO `grid50000` VALUES ('1994', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('1995', 'seek', '83811843');
INSERT INTO `grid50000` VALUES ('1996', 'refuge', '83811843');
INSERT INTO `grid50000` VALUES ('1997', '\r\n\r\nIncidentally', '83811843');
INSERT INTO `grid50000` VALUES ('1998', 'Boleslav', '83811843');
INSERT INTO `grid50000` VALUES ('1999', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('2000', 'Wenceslas', '83811843');
INSERT INTO `grid50000` VALUES ('2001', 'Grandmother', '83811843');
INSERT INTO `grid50000` VALUES ('2002', 'on', '83811843');
INSERT INTO `grid50000` VALUES ('2003', 'their', '83811843');
INSERT INTO `grid50000` VALUES ('2004', 'fathers', '83811843');
INSERT INTO `grid50000` VALUES ('2005', 'side', '83811843');
INSERT INTO `grid50000` VALUES ('2006', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('2007', 'also', '83811843');
INSERT INTO `grid50000` VALUES ('2008', 'murdered', '83811843');
INSERT INTO `grid50000` VALUES ('2009', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('2010', 'also', '83811843');
INSERT INTO `grid50000` VALUES ('2011', 'made', '83811843');
INSERT INTO `grid50000` VALUES ('2012', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('2013', 'saint', '83811843');
INSERT INTO `grid50000` VALUES ('2014', 'It', '83811843');
INSERT INTO `grid50000` VALUES ('2015', 'is', '83811843');
INSERT INTO `grid50000` VALUES ('2016', 'said', '83811843');
INSERT INTO `grid50000` VALUES ('2017', 'that', '83811843');
INSERT INTO `grid50000` VALUES ('2018', 'she', '83811843');
INSERT INTO `grid50000` VALUES ('2019', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('2020', 'either', '83811843');
INSERT INTO `grid50000` VALUES ('2021', 'smothered', '83811843');
INSERT INTO `grid50000` VALUES ('2022', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('2023', 'death', '83811843');
INSERT INTO `grid50000` VALUES ('2024', 'with', '83811843');
INSERT INTO `grid50000` VALUES ('2025', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('2026', 'pillow', '83811843');
INSERT INTO `grid50000` VALUES ('2027', 'or', '83811843');
INSERT INTO `grid50000` VALUES ('2028', 'choked', '83811843');
INSERT INTO `grid50000` VALUES ('2029', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('2030', 'death', '83811843');
INSERT INTO `grid50000` VALUES ('2031', '', '83811843');
INSERT INTO `grid50000` VALUES ('2032', 'this', '83811843');
INSERT INTO `grid50000` VALUES ('2033', 'time', '83811843');
INSERT INTO `grid50000` VALUES ('2034', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2035', 'killer', '83811843');
INSERT INTO `grid50000` VALUES ('2036', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('2037', 'her', '83811843');
INSERT INTO `grid50000` VALUES ('2038', 'daughterinlaw', '83811843');
INSERT INTO `grid50000` VALUES ('2039', 'Boleslav', '83811843');
INSERT INTO `grid50000` VALUES ('2040', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('2041', 'Wenceslas', '83811843');
INSERT INTO `grid50000` VALUES ('2042', 'mother', '83811843');
INSERT INTO `grid50000` VALUES ('2043', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('2044', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2045', 'motive', '83811843');
INSERT INTO `grid50000` VALUES ('2046', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('2047', 'again', '83811843');
INSERT INTO `grid50000` VALUES ('2048', 'power', '83811843');
INSERT INTO `grid50000` VALUES ('2049', 'Drahomira', '83811843');
INSERT INTO `grid50000` VALUES ('2050', 'wanted', '83811843');
INSERT INTO `grid50000` VALUES ('2051', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('2052', 'place', '83811843');
INSERT INTO `grid50000` VALUES ('2053', 'Wenceslas', '83811843');
INSERT INTO `grid50000` VALUES ('2054', 'on', '83811843');
INSERT INTO `grid50000` VALUES ('2055', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2056', 'throne', '83811843');
INSERT INTO `grid50000` VALUES ('2057', '\r\n\r\nThings', '83811843');
INSERT INTO `grid50000` VALUES ('2058', 'didnt', '83811843');
INSERT INTO `grid50000` VALUES ('2059', 'get', '83811843');
INSERT INTO `grid50000` VALUES ('2060', 'much', '83811843');
INSERT INTO `grid50000` VALUES ('2061', 'better', '83811843');
INSERT INTO `grid50000` VALUES ('2062', 'within', '83811843');
INSERT INTO `grid50000` VALUES ('2063', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2064', 'Przemyslid', '83811843');
INSERT INTO `grid50000` VALUES ('2065', 'family', '83811843');
INSERT INTO `grid50000` VALUES ('2066', 'it', '83811843');
INSERT INTO `grid50000` VALUES ('2067', 'is', '83811843');
INSERT INTO `grid50000` VALUES ('2068', 'suspected', '83811843');
INSERT INTO `grid50000` VALUES ('2069', 'that', '83811843');
INSERT INTO `grid50000` VALUES ('2070', '', '83811843');
INSERT INTO `grid50000` VALUES ('2071', 'Interestingly', '83811843');
INSERT INTO `grid50000` VALUES ('2072', 'enough', '83811843');
INSERT INTO `grid50000` VALUES ('2073', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2074', 'Przemyslids', '83811843');
INSERT INTO `grid50000` VALUES ('2075', 'are', '83811843');
INSERT INTO `grid50000` VALUES ('2076', 'remembered', '83811843');
INSERT INTO `grid50000` VALUES ('2077', 'rather', '83811843');
INSERT INTO `grid50000` VALUES ('2078', 'fondly', '83811843');
INSERT INTO `grid50000` VALUES ('2079', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('2080', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2081', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('2082', 'Republic', '83811843');
INSERT INTO `grid50000` VALUES ('2083', 'today', '83811843');
INSERT INTO `grid50000` VALUES ('2084', 'as', '83811843');
INSERT INTO `grid50000` VALUES ('2085', 'it', '83811843');
INSERT INTO `grid50000` VALUES ('2086', 'seems', '83811843');
INSERT INTO `grid50000` VALUES ('2087', 'that', '83811843');
INSERT INTO `grid50000` VALUES ('2088', 'most', '83811843');
INSERT INTO `grid50000` VALUES ('2089', 'people', '83811843');
INSERT INTO `grid50000` VALUES ('2090', 'are', '83811843');
INSERT INTO `grid50000` VALUES ('2091', 'blissfully', '83811843');
INSERT INTO `grid50000` VALUES ('2092', 'unaware', '83811843');
INSERT INTO `grid50000` VALUES ('2093', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('2094', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2095', 'familys', '83811843');
INSERT INTO `grid50000` VALUES ('2096', 'murderous', '83811843');
INSERT INTO `grid50000` VALUES ('2097', 'streak', '83811843');
INSERT INTO `grid50000` VALUES ('2098', '\r\n\r\nMaybe', '83811843');
INSERT INTO `grid50000` VALUES ('2099', 'that', '83811843');
INSERT INTO `grid50000` VALUES ('2100', 'is', '83811843');
INSERT INTO `grid50000` VALUES ('2101', 'because', '83811843');
INSERT INTO `grid50000` VALUES ('2102', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2103', 'Przemyslids', '83811843');
INSERT INTO `grid50000` VALUES ('2104', 'occasionally', '83811843');
INSERT INTO `grid50000` VALUES ('2105', 'took', '83811843');
INSERT INTO `grid50000` VALUES ('2106', 'time', '83811843');
INSERT INTO `grid50000` VALUES ('2107', 'off', '83811843');
INSERT INTO `grid50000` VALUES ('2108', 'from', '83811843');
INSERT INTO `grid50000` VALUES ('2109', 'their', '83811843');
INSERT INTO `grid50000` VALUES ('2110', 'favorite', '83811843');
INSERT INTO `grid50000` VALUES ('2111', 'sport', '83811843');
INSERT INTO `grid50000` VALUES ('2112', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('2113', 'increase', '83811843');
INSERT INTO `grid50000` VALUES ('2114', 'Bohemias', '83811843');
INSERT INTO `grid50000` VALUES ('2115', 'power', '83811843');
INSERT INTO `grid50000` VALUES ('2116', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('2117', 'prestige', '83811843');
INSERT INTO `grid50000` VALUES ('2118', 'In', '83811843');
INSERT INTO `grid50000` VALUES ('2119', 'typical', '83811843');
INSERT INTO `grid50000` VALUES ('2120', 'early', '83811843');
INSERT INTO `grid50000` VALUES ('2121', 'feudal', '83811843');
INSERT INTO `grid50000` VALUES ('2122', 'fashion', '83811843');
INSERT INTO `grid50000` VALUES ('2123', 'this', '83811843');
INSERT INTO `grid50000` VALUES ('2124', 'meant', '83811843');
INSERT INTO `grid50000` VALUES ('2125', 'that', '83811843');
INSERT INTO `grid50000` VALUES ('2126', 'they', '83811843');
INSERT INTO `grid50000` VALUES ('2127', 'went', '83811843');
INSERT INTO `grid50000` VALUES ('2128', 'out', '83811843');
INSERT INTO `grid50000` VALUES ('2129', 'killing', '83811843');
INSERT INTO `grid50000` VALUES ('2130', 'people', '83811843');
INSERT INTO `grid50000` VALUES ('2131', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('2132', 'other', '83811843');
INSERT INTO `grid50000` VALUES ('2133', 'countries', '83811843');
INSERT INTO `grid50000` VALUES ('2134', 'instead', '83811843');
INSERT INTO `grid50000` VALUES ('2135', 'expanding', '83811843');
INSERT INTO `grid50000` VALUES ('2136', 'their', '83811843');
INSERT INTO `grid50000` VALUES ('2137', 'empire', '83811843');
INSERT INTO `grid50000` VALUES ('2138', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('2139', 'Moravia', '83811843');
INSERT INTO `grid50000` VALUES ('2140', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('2141', 'Silesia', '83811843');
INSERT INTO `grid50000` VALUES ('2142', 'as', '83811843');
INSERT INTO `grid50000` VALUES ('2143', 'well', '83811843');
INSERT INTO `grid50000` VALUES ('2144', 'as', '83811843');
INSERT INTO `grid50000` VALUES ('2145', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2146', 'upper', '83811843');
INSERT INTO `grid50000` VALUES ('2147', 'reaches', '83811843');
INSERT INTO `grid50000` VALUES ('2148', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('2149', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2150', 'river', '83811843');
INSERT INTO `grid50000` VALUES ('2151', 'Vistula', '83811843');
INSERT INTO `grid50000` VALUES ('2152', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('2153', 'parts', '83811843');
INSERT INTO `grid50000` VALUES ('2154', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('2155', 'western', '83811843');
INSERT INTO `grid50000` VALUES ('2156', 'Slovakia', '83811843');
INSERT INTO `grid50000` VALUES ('2157', 'In', '83811843');
INSERT INTO `grid50000` VALUES ('2158', 'Moravia', '83811843');
INSERT INTO `grid50000` VALUES ('2159', 'they', '83811843');
INSERT INTO `grid50000` VALUES ('2160', 'set', '83811843');
INSERT INTO `grid50000` VALUES ('2161', 'up', '83811843');
INSERT INTO `grid50000` VALUES ('2162', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('2163', 'system', '83811843');
INSERT INTO `grid50000` VALUES ('2164', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('2165', 'dukedoms', '83811843');
INSERT INTO `grid50000` VALUES ('2166', 'with', '83811843');
INSERT INTO `grid50000` VALUES ('2167', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2168', 'office', '83811843');
INSERT INTO `grid50000` VALUES ('2169', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('2170', 'Margrave', '83811843');
INSERT INTO `grid50000` VALUES ('2171', 'ruler', '83811843');
INSERT INTO `grid50000` VALUES ('2172', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('2173', 'Moravia', '83811843');
INSERT INTO `grid50000` VALUES ('2174', 'sometimes', '83811843');
INSERT INTO `grid50000` VALUES ('2175', 'being', '83811843');
INSERT INTO `grid50000` VALUES ('2176', 'held', '83811843');
INSERT INTO `grid50000` VALUES ('2177', 'by', '83811843');
INSERT INTO `grid50000` VALUES ('2178', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2179', 'Bohemian', '83811843');
INSERT INTO `grid50000` VALUES ('2180', 'Dauphin', '83811843');
INSERT INTO `grid50000` VALUES ('2181', 'sometimes', '83811843');
INSERT INTO `grid50000` VALUES ('2182', 'by', '83811843');
INSERT INTO `grid50000` VALUES ('2183', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('2184', 'rival', '83811843');
INSERT INTO `grid50000` VALUES ('2185', 'for', '83811843');
INSERT INTO `grid50000` VALUES ('2186', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2187', 'Bohemian', '83811843');
INSERT INTO `grid50000` VALUES ('2188', 'throne', '83811843');
INSERT INTO `grid50000` VALUES ('2189', 'In', '83811843');
INSERT INTO `grid50000` VALUES ('2190', 'this', '83811843');
INSERT INTO `grid50000` VALUES ('2191', 'way', '83811843');
INSERT INTO `grid50000` VALUES ('2192', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2193', 'Przemyslide', '83811843');
INSERT INTO `grid50000` VALUES ('2194', 'dynastic', '83811843');
INSERT INTO `grid50000` VALUES ('2195', 'killings', '83811843');
INSERT INTO `grid50000` VALUES ('2196', 'were', '83811843');
INSERT INTO `grid50000` VALUES ('2197', 'stayed', '83811843');
INSERT INTO `grid50000` VALUES ('2198', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('2199', 'both', '83811843');
INSERT INTO `grid50000` VALUES ('2200', 'Bohemia', '83811843');
INSERT INTO `grid50000` VALUES ('2201', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('2202', 'Moravia', '83811843');
INSERT INTO `grid50000` VALUES ('2203', 'came', '83811843');
INSERT INTO `grid50000` VALUES ('2204', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('2205', 'be', '83811843');
INSERT INTO `grid50000` VALUES ('2206', 'regarded', '83811843');
INSERT INTO `grid50000` VALUES ('2207', 'as', '83811843');
INSERT INTO `grid50000` VALUES ('2208', 'hereditary', '83811843');
INSERT INTO `grid50000` VALUES ('2209', 'lands', '83811843');
INSERT INTO `grid50000` VALUES ('2210', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('2211', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2212', 'Przemyslid', '83811843');
INSERT INTO `grid50000` VALUES ('2213', 'dynasty', '83811843');
INSERT INTO `grid50000` VALUES ('2214', 'All', '83811843');
INSERT INTO `grid50000` VALUES ('2215', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2216', 'while', '83811843');
INSERT INTO `grid50000` VALUES ('2217', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2218', 'expansion', '83811843');
INSERT INTO `grid50000` VALUES ('2219', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('2220', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2221', 'Przemyslid', '83811843');
INSERT INTO `grid50000` VALUES ('2222', 'Dynastys', '83811843');
INSERT INTO `grid50000` VALUES ('2223', 'power', '83811843');
INSERT INTO `grid50000` VALUES ('2224', 'went', '83811843');
INSERT INTO `grid50000` VALUES ('2225', 'hand', '83811843');
INSERT INTO `grid50000` VALUES ('2226', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('2227', 'hand', '83811843');
INSERT INTO `grid50000` VALUES ('2228', 'with', '83811843');
INSERT INTO `grid50000` VALUES ('2229', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2230', 'spread', '83811843');
INSERT INTO `grid50000` VALUES ('2231', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('2232', 'Christianity', '83811843');
INSERT INTO `grid50000` VALUES ('2233', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('2234', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2235', 'region', '83811843');
INSERT INTO `grid50000` VALUES ('2236', '\r\n\r\n', '83811843');
INSERT INTO `grid50000` VALUES ('2237', 'This', '83811843');
INSERT INTO `grid50000` VALUES ('2238', 'growing', '83811843');
INSERT INTO `grid50000` VALUES ('2239', 'Przemyslide', '83811843');
INSERT INTO `grid50000` VALUES ('2240', 'state', '83811843');
INSERT INTO `grid50000` VALUES ('2241', 'maintained', '83811843');
INSERT INTO `grid50000` VALUES ('2242', 'its', '83811843');
INSERT INTO `grid50000` VALUES ('2243', 'sovereignty', '83811843');
INSERT INTO `grid50000` VALUES ('2244', 'though', '83811843');
INSERT INTO `grid50000` VALUES ('2245', 'it', '83811843');
INSERT INTO `grid50000` VALUES ('2246', 'formally', '83811843');
INSERT INTO `grid50000` VALUES ('2247', 'recognized', '83811843');
INSERT INTO `grid50000` VALUES ('2248', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2249', 'feudal', '83811843');
INSERT INTO `grid50000` VALUES ('2250', 'supremacy', '83811843');
INSERT INTO `grid50000` VALUES ('2251', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('2252', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2253', 'RomanGerman', '83811843');
INSERT INTO `grid50000` VALUES ('2254', 'Empire', '83811843');
INSERT INTO `grid50000` VALUES ('2255', 'The', '83811843');
INSERT INTO `grid50000` VALUES ('2256', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('2257', 'lands', '83811843');
INSERT INTO `grid50000` VALUES ('2258', 'ranked', '83811843');
INSERT INTO `grid50000` VALUES ('2259', 'among', '83811843');
INSERT INTO `grid50000` VALUES ('2260', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2261', 'most', '83811843');
INSERT INTO `grid50000` VALUES ('2262', 'advanced', '83811843');
INSERT INTO `grid50000` VALUES ('2263', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('2264', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2265', 'European', '83811843');
INSERT INTO `grid50000` VALUES ('2266', 'feudal', '83811843');
INSERT INTO `grid50000` VALUES ('2267', 'states', '83811843');
INSERT INTO `grid50000` VALUES ('2268', 'being', '83811843');
INSERT INTO `grid50000` VALUES ('2269', 'at', '83811843');
INSERT INTO `grid50000` VALUES ('2270', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2271', 'forefront', '83811843');
INSERT INTO `grid50000` VALUES ('2272', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('2273', 'economic', '83811843');
INSERT INTO `grid50000` VALUES ('2274', 'power', '83811843');
INSERT INTO `grid50000` VALUES ('2275', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('2276', 'cultural', '83811843');
INSERT INTO `grid50000` VALUES ('2277', 'achievement', '83811843');
INSERT INTO `grid50000` VALUES ('2278', 'at', '83811843');
INSERT INTO `grid50000` VALUES ('2279', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2280', 'time', '83811843');
INSERT INTO `grid50000` VALUES ('2281', 'In', '83811843');
INSERT INTO `grid50000` VALUES ('2282', 'keeping', '83811843');
INSERT INTO `grid50000` VALUES ('2283', 'with', '83811843');
INSERT INTO `grid50000` VALUES ('2284', 'this', '83811843');
INSERT INTO `grid50000` VALUES ('2285', 'growing', '83811843');
INSERT INTO `grid50000` VALUES ('2286', 'importance', '83811843');
INSERT INTO `grid50000` VALUES ('2287', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2288', 'territory', '83811843');
INSERT INTO `grid50000` VALUES ('2289', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('2290', 'officially', '83811843');
INSERT INTO `grid50000` VALUES ('2291', 'recognized', '83811843');
INSERT INTO `grid50000` VALUES ('2292', 'through', '83811843');
INSERT INTO `grid50000` VALUES ('2293', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2294', 'granting', '83811843');
INSERT INTO `grid50000` VALUES ('2295', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('2296', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('2297', 'royal', '83811843');
INSERT INTO `grid50000` VALUES ('2298', 'crown', '83811843');
INSERT INTO `grid50000` VALUES ('2299', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('2300', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2301', 'Przemyslid', '83811843');
INSERT INTO `grid50000` VALUES ('2302', 'Dynasty', '83811843');
INSERT INTO `grid50000` VALUES ('2303', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('2304', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2305', 'eleventh', '83811843');
INSERT INTO `grid50000` VALUES ('2306', 'century', '83811843');
INSERT INTO `grid50000` VALUES ('2307', 'it', '83811843');
INSERT INTO `grid50000` VALUES ('2308', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('2309', 'made', '83811843');
INSERT INTO `grid50000` VALUES ('2310', 'hereditary', '83811843');
INSERT INTO `grid50000` VALUES ('2311', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('2312', '1212', '83811843');
INSERT INTO `grid50000` VALUES ('2313', 'by', '83811843');
INSERT INTO `grid50000` VALUES ('2314', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2315', 'Golden', '83811843');
INSERT INTO `grid50000` VALUES ('2316', 'Sicilian', '83811843');
INSERT INTO `grid50000` VALUES ('2317', 'Bull', '83811843');
INSERT INTO `grid50000` VALUES ('2318', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('2319', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2320', 'granting', '83811843');
INSERT INTO `grid50000` VALUES ('2321', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('2322', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2323', 'title', '83811843');
INSERT INTO `grid50000` VALUES ('2324', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('2325', 'emperor', '83811843');
INSERT INTO `grid50000` VALUES ('2326', 'for', '83811843');
INSERT INTO `grid50000` VALUES ('2327', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('2328', 'rulers', '83811843');
INSERT INTO `grid50000` VALUES ('2329', '\r\n\r\nThe', '83811843');
INSERT INTO `grid50000` VALUES ('2330', '1100s', '83811843');
INSERT INTO `grid50000` VALUES ('2331', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('2332', '1200s', '83811843');
INSERT INTO `grid50000` VALUES ('2333', 'were', '83811843');
INSERT INTO `grid50000` VALUES ('2334', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('2335', 'very', '83811843');
INSERT INTO `grid50000` VALUES ('2336', 'busy', '83811843');
INSERT INTO `grid50000` VALUES ('2337', 'time', '83811843');
INSERT INTO `grid50000` VALUES ('2338', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('2339', 'this', '83811843');
INSERT INTO `grid50000` VALUES ('2340', 'part', '83811843');
INSERT INTO `grid50000` VALUES ('2341', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('2342', 'Europe', '83811843');
INSERT INTO `grid50000` VALUES ('2343', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('2344', 'colonization', '83811843');
INSERT INTO `grid50000` VALUES ('2345', 'trade', '83811843');
INSERT INTO `grid50000` VALUES ('2346', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('2347', 'cultural', '83811843');
INSERT INTO `grid50000` VALUES ('2348', 'activity', '83811843');
INSERT INTO `grid50000` VALUES ('2349', 'were', '83811843');
INSERT INTO `grid50000` VALUES ('2350', 'steadily', '83811843');
INSERT INTO `grid50000` VALUES ('2351', 'on', '83811843');
INSERT INTO `grid50000` VALUES ('2352', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2353', 'increase', '83811843');
INSERT INTO `grid50000` VALUES ('2354', 'Prague', '83811843');
INSERT INTO `grid50000` VALUES ('2355', 'which', '83811843');
INSERT INTO `grid50000` VALUES ('2356', 'lay', '83811843');
INSERT INTO `grid50000` VALUES ('2357', 'smack', '83811843');
INSERT INTO `grid50000` VALUES ('2358', 'dab', '83811843');
INSERT INTO `grid50000` VALUES ('2359', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('2360', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2361', 'middle', '83811843');
INSERT INTO `grid50000` VALUES ('2362', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('2363', 'several', '83811843');
INSERT INTO `grid50000` VALUES ('2364', 'continental', '83811843');
INSERT INTO `grid50000` VALUES ('2365', 'trade', '83811843');
INSERT INTO `grid50000` VALUES ('2366', 'routes', '83811843');
INSERT INTO `grid50000` VALUES ('2367', 'flourished', '83811843');
INSERT INTO `grid50000` VALUES ('2368', 'Pragues', '83811843');
INSERT INTO `grid50000` VALUES ('2369', 'Old', '83811843');
INSERT INTO `grid50000` VALUES ('2370', 'Town', '83811843');
INSERT INTO `grid50000` VALUES ('2371', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('2372', 'founded', '83811843');
INSERT INTO `grid50000` VALUES ('2373', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('2374', '1234', '83811843');
INSERT INTO `grid50000` VALUES ('2375', 'as', '83811843');
INSERT INTO `grid50000` VALUES ('2376', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2377', 'first', '83811843');
INSERT INTO `grid50000` VALUES ('2378', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('2379', 'Pragues', '83811843');
INSERT INTO `grid50000` VALUES ('2380', 'five', '83811843');
INSERT INTO `grid50000` VALUES ('2381', 'towns', '83811843');
INSERT INTO `grid50000` VALUES ('2382', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('2383', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2384', 'Lesser', '83811843');
INSERT INTO `grid50000` VALUES ('2385', 'Quarter', '83811843');
INSERT INTO `grid50000` VALUES ('2386', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('2387', 'founded', '83811843');
INSERT INTO `grid50000` VALUES ('2388', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('2389', '1257', '83811843');
INSERT INTO `grid50000` VALUES ('2390', 'Border', '83811843');
INSERT INTO `grid50000` VALUES ('2391', 'forests', '83811843');
INSERT INTO `grid50000` VALUES ('2392', 'were', '83811843');
INSERT INTO `grid50000` VALUES ('2393', 'settled', '83811843');
INSERT INTO `grid50000` VALUES ('2394', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('2395', 'towns', '83811843');
INSERT INTO `grid50000` VALUES ('2396', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('2397', 'fortresses', '83811843');
INSERT INTO `grid50000` VALUES ('2398', 'were', '83811843');
INSERT INTO `grid50000` VALUES ('2399', 'founded', '83811843');
INSERT INTO `grid50000` VALUES ('2400', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('2401', 'fortified', '83811843');
INSERT INTO `grid50000` VALUES ('2402', 'These', '83811843');
INSERT INTO `grid50000` VALUES ('2403', 'sweeping', '83811843');
INSERT INTO `grid50000` VALUES ('2404', 'changes', '83811843');
INSERT INTO `grid50000` VALUES ('2405', 'literally', '83811843');
INSERT INTO `grid50000` VALUES ('2406', 'transformed', '83811843');
INSERT INTO `grid50000` VALUES ('2407', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2408', 'country', '83811843');
INSERT INTO `grid50000` VALUES ('2409', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('2410', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('2411', 'keeping', '83811843');
INSERT INTO `grid50000` VALUES ('2412', 'with', '83811843');
INSERT INTO `grid50000` VALUES ('2413', 'these', '83811843');
INSERT INTO `grid50000` VALUES ('2414', 'physical', '83811843');
INSERT INTO `grid50000` VALUES ('2415', 'changes', '83811843');
INSERT INTO `grid50000` VALUES ('2416', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2417', 'social', '83811843');
INSERT INTO `grid50000` VALUES ('2418', 'structure', '83811843');
INSERT INTO `grid50000` VALUES ('2419', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('2420', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2421', 'territory', '83811843');
INSERT INTO `grid50000` VALUES ('2422', 'also', '83811843');
INSERT INTO `grid50000` VALUES ('2423', 'evolved', '83811843');
INSERT INTO `grid50000` VALUES ('2424', 'From', '83811843');
INSERT INTO `grid50000` VALUES ('2426', 'this', '83811843');
INSERT INTO `grid50000` VALUES ('2427', 'time', '83811843');
INSERT INTO `grid50000` VALUES ('2428', 'aristocrats', '83811843');
INSERT INTO `grid50000` VALUES ('2429', 'burghers', '83811843');
INSERT INTO `grid50000` VALUES ('2430', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('2431', 'serfs', '83811843');
INSERT INTO `grid50000` VALUES ('2432', 'were', '83811843');
INSERT INTO `grid50000` VALUES ('2433', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('2434', 'be', '83811843');
INSERT INTO `grid50000` VALUES ('2435', 'spotted', '83811843');
INSERT INTO `grid50000` VALUES ('2436', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('2437', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2438', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('2439', 'lands', '83811843');
INSERT INTO `grid50000` VALUES ('2440', '', '83811843');
INSERT INTO `grid50000` VALUES ('2441', 'as', '83811843');
INSERT INTO `grid50000` VALUES ('2442', 'were', '83811843');
INSERT INTO `grid50000` VALUES ('2443', 'German', '83811843');
INSERT INTO `grid50000` VALUES ('2444', 'settlers', '83811843');
INSERT INTO `grid50000` VALUES ('2445', 'who', '83811843');
INSERT INTO `grid50000` VALUES ('2446', 'were', '83811843');
INSERT INTO `grid50000` VALUES ('2447', 'invited', '83811843');
INSERT INTO `grid50000` VALUES ('2448', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('2449', 'colonize', '83811843');
INSERT INTO `grid50000` VALUES ('2450', 'previously', '83811843');
INSERT INTO `grid50000` VALUES ('2451', 'uninhabited', '83811843');
INSERT INTO `grid50000` VALUES ('2452', 'mostly', '83811843');
INSERT INTO `grid50000` VALUES ('2453', 'border', '83811843');
INSERT INTO `grid50000` VALUES ('2454', 'regions', '83811843');
INSERT INTO `grid50000` VALUES ('2455', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('2456', 'Bohemia', '83811843');
INSERT INTO `grid50000` VALUES ('2457', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('2458', 'Moravia', '83811843');
INSERT INTO `grid50000` VALUES ('2459', 'The', '83811843');
INSERT INTO `grid50000` VALUES ('2460', 'German', '83811843');
INSERT INTO `grid50000` VALUES ('2461', 'settlers', '83811843');
INSERT INTO `grid50000` VALUES ('2462', 'whether', '83811843');
INSERT INTO `grid50000` VALUES ('2463', 'burghers', '83811843');
INSERT INTO `grid50000` VALUES ('2464', 'or', '83811843');
INSERT INTO `grid50000` VALUES ('2465', 'peasants', '83811843');
INSERT INTO `grid50000` VALUES ('2466', 'did', '83811843');
INSERT INTO `grid50000` VALUES ('2467', 'not', '83811843');
INSERT INTO `grid50000` VALUES ('2468', 'form', '83811843');
INSERT INTO `grid50000` VALUES ('2469', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('2470', 'homogeneous', '83811843');
INSERT INTO `grid50000` VALUES ('2471', 'or', '83811843');
INSERT INTO `grid50000` VALUES ('2472', 'politically', '83811843');
INSERT INTO `grid50000` VALUES ('2473', 'separate', '83811843');
INSERT INTO `grid50000` VALUES ('2474', 'group', '83811843');
INSERT INTO `grid50000` VALUES ('2475', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('2476', 'they', '83811843');
INSERT INTO `grid50000` VALUES ('2477', 'soon', '83811843');
INSERT INTO `grid50000` VALUES ('2478', 'became', '83811843');
INSERT INTO `grid50000` VALUES ('2479', 'part', '83811843');
INSERT INTO `grid50000` VALUES ('2480', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('2481', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2482', 'local', '83811843');
INSERT INTO `grid50000` VALUES ('2483', 'community', '83811843');
INSERT INTO `grid50000` VALUES ('2484', 'identifying', '83811843');
INSERT INTO `grid50000` VALUES ('2485', 'with', '83811843');
INSERT INTO `grid50000` VALUES ('2486', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('2487', 'statehood', '83811843');
INSERT INTO `grid50000` VALUES ('2488', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('2489', 'sharing', '83811843');
INSERT INTO `grid50000` VALUES ('2490', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('2491', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2492', 'development', '83811843');
INSERT INTO `grid50000` VALUES ('2493', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('2494', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2495', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('2496', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('2497', 'Moravian', '83811843');
INSERT INTO `grid50000` VALUES ('2498', 'lands', '83811843');
INSERT INTO `grid50000` VALUES ('2499', 'as', '83811843');
INSERT INTO `grid50000` VALUES ('2500', 'fully', '83811843');
INSERT INTO `grid50000` VALUES ('2501', 'enfranchised', '83811843');
INSERT INTO `grid50000` VALUES ('2502', 'members', '83811843');
INSERT INTO `grid50000` VALUES ('2503', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('2504', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2505', 'population', '83811843');
INSERT INTO `grid50000` VALUES ('2506', 'but', '83811843');
INSERT INTO `grid50000` VALUES ('2507', 'mostly', '83811843');
INSERT INTO `grid50000` VALUES ('2508', 'but', '83811843');
INSERT INTO `grid50000` VALUES ('2509', 'keeping', '83811843');
INSERT INTO `grid50000` VALUES ('2510', 'their', '83811843');
INSERT INTO `grid50000` VALUES ('2511', 'native', '83811843');
INSERT INTO `grid50000` VALUES ('2512', 'language', '83811843');
INSERT INTO `grid50000` VALUES ('2513', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('2514', 'addition', '83811843');
INSERT INTO `grid50000` VALUES ('2515', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('2516', 'learning', '83811843');
INSERT INTO `grid50000` VALUES ('2517', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('2518', 'Many', '83811843');
INSERT INTO `grid50000` VALUES ('2519', 'many', '83811843');
INSERT INTO `grid50000` VALUES ('2520', 'many', '83811843');
INSERT INTO `grid50000` VALUES ('2521', 'many', '83811843');
INSERT INTO `grid50000` VALUES ('2522', 'centuries', '83811843');
INSERT INTO `grid50000` VALUES ('2523', 'later', '83811843');
INSERT INTO `grid50000` VALUES ('2524', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2525', 'places', '83811843');
INSERT INTO `grid50000` VALUES ('2526', 'that', '83811843');
INSERT INTO `grid50000` VALUES ('2527', 'they', '83811843');
INSERT INTO `grid50000` VALUES ('2528', 'settled', '83811843');
INSERT INTO `grid50000` VALUES ('2529', 'would', '83811843');
INSERT INTO `grid50000` VALUES ('2530', 'come', '83811843');
INSERT INTO `grid50000` VALUES ('2531', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('2532', 'be', '83811843');
INSERT INTO `grid50000` VALUES ('2533', 'known', '83811843');
INSERT INTO `grid50000` VALUES ('2534', 'as', '83811843');
INSERT INTO `grid50000` VALUES ('2535', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2536', 'Sudetenland', '83811843');
INSERT INTO `grid50000` VALUES ('2537', '\r\n\r\nFrom', '83811843');
INSERT INTO `grid50000` VALUES ('2538', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2539', 'thirteenth', '83811843');
INSERT INTO `grid50000` VALUES ('2540', 'century', '83811843');
INSERT INTO `grid50000` VALUES ('2541', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2542', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('2543', 'kingdom', '83811843');
INSERT INTO `grid50000` VALUES ('2544', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('2545', 'one', '83811843');
INSERT INTO `grid50000` VALUES ('2546', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('2547', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2548', 'most', '83811843');
INSERT INTO `grid50000` VALUES ('2549', 'robust', '83811843');
INSERT INTO `grid50000` VALUES ('2550', 'states', '83811843');
INSERT INTO `grid50000` VALUES ('2551', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('2552', 'all', '83811843');
INSERT INTO `grid50000` VALUES ('2553', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('2554', 'Europe', '83811843');
INSERT INTO `grid50000` VALUES ('2555', 'with', '83811843');
INSERT INTO `grid50000` VALUES ('2556', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('2557', 'growing', '83811843');
INSERT INTO `grid50000` VALUES ('2558', 'population', '83811843');
INSERT INTO `grid50000` VALUES ('2559', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('2560', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('2561', 'vigorous', '83811843');
INSERT INTO `grid50000` VALUES ('2562', 'economy', '83811843');
INSERT INTO `grid50000` VALUES ('2563', 'This', '83811843');
INSERT INTO `grid50000` VALUES ('2564', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('2565', 'turn', '83811843');
INSERT INTO `grid50000` VALUES ('2566', 'made', '83811843');
INSERT INTO `grid50000` VALUES ('2567', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2568', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('2569', 'nobility', '83811843');
INSERT INTO `grid50000` VALUES ('2570', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('2571', 'rulers', '83811843');
INSERT INTO `grid50000` VALUES ('2572', 'all', '83811843');
INSERT INTO `grid50000` VALUES ('2573', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2574', 'more', '83811843');
INSERT INTO `grid50000` VALUES ('2575', 'rich', '83811843');
INSERT INTO `grid50000` VALUES ('2576', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('2577', 'powerful', '83811843');
INSERT INTO `grid50000` VALUES ('2578', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('2579', 'enabled', '83811843');
INSERT INTO `grid50000` VALUES ('2580', 'king', '83811843');
INSERT INTO `grid50000` VALUES ('2581', 'Przemysl', '83811843');
INSERT INTO `grid50000` VALUES ('2582', 'Otakar', '83811843');
INSERT INTO `grid50000` VALUES ('2583', 'II', '83811843');
INSERT INTO `grid50000` VALUES ('2584', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('2585', 'expand', '83811843');
INSERT INTO `grid50000` VALUES ('2586', 'his', '83811843');
INSERT INTO `grid50000` VALUES ('2587', 'territory', '83811843');
INSERT INTO `grid50000` VALUES ('2588', 'rather', '83811843');
INSERT INTO `grid50000` VALUES ('2589', 'extensively', '83811843');
INSERT INTO `grid50000` VALUES ('2590', 'if', '83811843');
INSERT INTO `grid50000` VALUES ('2591', 'briefly', '83811843');
INSERT INTO `grid50000` VALUES ('2592', 'Otakar', '83811843');
INSERT INTO `grid50000` VALUES ('2593', 'II', '83811843');
INSERT INTO `grid50000` VALUES ('2594', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('2595', 'quite', '83811843');
INSERT INTO `grid50000` VALUES ('2596', 'wellknown', '83811843');
INSERT INTO `grid50000` VALUES ('2597', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('2598', 'his', '83811843');
INSERT INTO `grid50000` VALUES ('2599', 'time', '83811843');
INSERT INTO `grid50000` VALUES ('2600', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('2601', 'he', '83811843');
INSERT INTO `grid50000` VALUES ('2602', 'even', '83811843');
INSERT INTO `grid50000` VALUES ('2603', 'makes', '83811843');
INSERT INTO `grid50000` VALUES ('2604', 'an', '83811843');
INSERT INTO `grid50000` VALUES ('2605', 'appearance', '83811843');
INSERT INTO `grid50000` VALUES ('2606', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('2607', 'Dantes', '83811843');
INSERT INTO `grid50000` VALUES ('2608', 'Divine', '83811843');
INSERT INTO `grid50000` VALUES ('2609', 'Comedy', '83811843');
INSERT INTO `grid50000` VALUES ('2610', 'Otokar', '83811843');
INSERT INTO `grid50000` VALUES ('2611', 'II', '83811843');
INSERT INTO `grid50000` VALUES ('2612', 'also', '83811843');
INSERT INTO `grid50000` VALUES ('2613', 'known', '83811843');
INSERT INTO `grid50000` VALUES ('2614', 'as', '83811843');
INSERT INTO `grid50000` VALUES ('2615', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2616', 'King', '83811843');
INSERT INTO `grid50000` VALUES ('2617', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('2618', 'Gold', '83811843');
INSERT INTO `grid50000` VALUES ('2619', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('2620', 'Iron', '83811843');
INSERT INTO `grid50000` VALUES ('2621', 'because', '83811843');
INSERT INTO `grid50000` VALUES ('2622', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('2623', 'his', '83811843');
INSERT INTO `grid50000` VALUES ('2624', 'considerable', '83811843');
INSERT INTO `grid50000` VALUES ('2625', 'wealth', '83811843');
INSERT INTO `grid50000` VALUES ('2626', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('2627', 'his', '83811843');
INSERT INTO `grid50000` VALUES ('2628', 'considerable', '83811843');
INSERT INTO `grid50000` VALUES ('2629', 'military', '83811843');
INSERT INTO `grid50000` VALUES ('2630', 'might', '83811843');
INSERT INTO `grid50000` VALUES ('2631', 'defeated', '83811843');
INSERT INTO `grid50000` VALUES ('2632', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2633', 'armies', '83811843');
INSERT INTO `grid50000` VALUES ('2634', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('2635', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2636', 'Hungarian', '83811843');
INSERT INTO `grid50000` VALUES ('2637', 'king', '83811843');
INSERT INTO `grid50000` VALUES ('2638', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('2639', '1256', '83811843');
INSERT INTO `grid50000` VALUES ('2640', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('2641', 'again', '83811843');
INSERT INTO `grid50000` VALUES ('2642', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('2643', '1260', '83811843');
INSERT INTO `grid50000` VALUES ('2644', 'This', '83811843');
INSERT INTO `grid50000` VALUES ('2645', 'military', '83811843');
INSERT INTO `grid50000` VALUES ('2646', 'victory', '83811843');
INSERT INTO `grid50000` VALUES ('2647', 'allowed', '83811843');
INSERT INTO `grid50000` VALUES ('2648', 'him', '83811843');
INSERT INTO `grid50000` VALUES ('2649', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('2650', 'annex', '83811843');
INSERT INTO `grid50000` VALUES ('2651', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2652', 'Alpine', '83811843');
INSERT INTO `grid50000` VALUES ('2653', 'countries', '83811843');
INSERT INTO `grid50000` VALUES ('2654', 'todays', '83811843');
INSERT INTO `grid50000` VALUES ('2655', 'Austria', '83811843');
INSERT INTO `grid50000` VALUES ('2656', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('2657', 'beyond', '83811843');
INSERT INTO `grid50000` VALUES ('2658', '', '83811843');
INSERT INTO `grid50000` VALUES ('2659', 'extending', '83811843');
INSERT INTO `grid50000` VALUES ('2660', 'his', '83811843');
INSERT INTO `grid50000` VALUES ('2661', 'territories', '83811843');
INSERT INTO `grid50000` VALUES ('2662', 'all', '83811843');
INSERT INTO `grid50000` VALUES ('2663', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2664', 'way', '83811843');
INSERT INTO `grid50000` VALUES ('2665', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('2666', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2667', 'Adriatic', '83811843');
INSERT INTO `grid50000` VALUES ('2668', 'Sea', '83811843');
INSERT INTO `grid50000` VALUES ('2669', 'Some', '83811843');
INSERT INTO `grid50000` VALUES ('2670', 'people', '83811843');
INSERT INTO `grid50000` VALUES ('2671', 'claim', '83811843');
INSERT INTO `grid50000` VALUES ('2672', 'that', '83811843');
INSERT INTO `grid50000` VALUES ('2673', 'this', '83811843');
INSERT INTO `grid50000` VALUES ('2674', 'brief', '83811843');
INSERT INTO `grid50000` VALUES ('2675', 'period', '83811843');
INSERT INTO `grid50000` VALUES ('2676', '', '83811843');
INSERT INTO `grid50000` VALUES ('2677', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('2678', 'which', '83811843');
INSERT INTO `grid50000` VALUES ('2679', 'Bohemia', '83811843');
INSERT INTO `grid50000` VALUES ('2680', 'controlled', '83811843');
INSERT INTO `grid50000` VALUES ('2681', 'territory', '83811843');
INSERT INTO `grid50000` VALUES ('2682', 'bordering', '83811843');
INSERT INTO `grid50000` VALUES ('2683', 'on', '83811843');
INSERT INTO `grid50000` VALUES ('2684', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2685', 'sea', '83811843');
INSERT INTO `grid50000` VALUES ('2686', '', '83811843');
INSERT INTO `grid50000` VALUES ('2687', 'is', '83811843');
INSERT INTO `grid50000` VALUES ('2688', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2689', 'basis', '83811843');
INSERT INTO `grid50000` VALUES ('2690', 'for', '83811843');
INSERT INTO `grid50000` VALUES ('2691', 'Shakespeares', '83811843');
INSERT INTO `grid50000` VALUES ('2692', 'infamous', '83811843');
INSERT INTO `grid50000` VALUES ('2693', 'Bohemian', '83811843');
INSERT INTO `grid50000` VALUES ('2694', 'seacoast', '83811843');
INSERT INTO `grid50000` VALUES ('2695', 'from', '83811843');
INSERT INTO `grid50000` VALUES ('2696', 'his', '83811843');
INSERT INTO `grid50000` VALUES ('2697', 'play', '83811843');
INSERT INTO `grid50000` VALUES ('2698', 'The', '83811843');
INSERT INTO `grid50000` VALUES ('2699', 'Tempest', '83811843');
INSERT INTO `grid50000` VALUES ('2700', '\r\n\r\nWell', '83811843');
INSERT INTO `grid50000` VALUES ('2701', 'while', '83811843');
INSERT INTO `grid50000` VALUES ('2702', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2703', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('2704', 'lands', '83811843');
INSERT INTO `grid50000` VALUES ('2705', 'were', '83811843');
INSERT INTO `grid50000` VALUES ('2706', 'gaining', '83811843');
INSERT INTO `grid50000` VALUES ('2707', 'power', '83811843');
INSERT INTO `grid50000` VALUES ('2708', 'prestige', '83811843');
INSERT INTO `grid50000` VALUES ('2709', 'oceanfront', '83811843');
INSERT INTO `grid50000` VALUES ('2710', 'property', '83811843');
INSERT INTO `grid50000` VALUES ('2711', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('2712', 'other', '83811843');
INSERT INTO `grid50000` VALUES ('2713', 'things', '83811843');
INSERT INTO `grid50000` VALUES ('2714', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('2715', 'powerful', '83811843');
INSERT INTO `grid50000` VALUES ('2716', 'rival', '83811843');
INSERT INTO `grid50000` VALUES ('2717', 'appeared', '83811843');
INSERT INTO `grid50000` VALUES ('2718', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('2719', 'Germany', '83811843');
INSERT INTO `grid50000` VALUES ('2720', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('2721', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2722', 'person', '83811843');
INSERT INTO `grid50000` VALUES ('2723', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('2724', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2725', 'newlyelected', '83811843');
INSERT INTO `grid50000` VALUES ('2726', 'ruler', '83811843');
INSERT INTO `grid50000` VALUES ('2727', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('2728', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2729', 'Holy', '83811843');
INSERT INTO `grid50000` VALUES ('2730', 'Roman', '83811843');
INSERT INTO `grid50000` VALUES ('2731', 'Empire', '83811843');
INSERT INTO `grid50000` VALUES ('2732', 'Rudolf', '83811843');
INSERT INTO `grid50000` VALUES ('2733', 'Habsburg', '83811843');
INSERT INTO `grid50000` VALUES ('2734', '', '83811843');
INSERT INTO `grid50000` VALUES ('2735', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('2736', 'member', '83811843');
INSERT INTO `grid50000` VALUES ('2737', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('2738', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('2739', 'previously', '83811843');
INSERT INTO `grid50000` VALUES ('2740', 'unimportant', '83811843');
INSERT INTO `grid50000` VALUES ('2741', 'family', '83811843');
INSERT INTO `grid50000` VALUES ('2742', 'from', '83811843');
INSERT INTO `grid50000` VALUES ('2743', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2744', 'Rhineland', '83811843');
INSERT INTO `grid50000` VALUES ('2745', 'This', '83811843');
INSERT INTO `grid50000` VALUES ('2746', 'Rudolf', '83811843');
INSERT INTO `grid50000` VALUES ('2747', 'formed', '83811843');
INSERT INTO `grid50000` VALUES ('2748', 'an', '83811843');
INSERT INTO `grid50000` VALUES ('2749', 'alliance', '83811843');
INSERT INTO `grid50000` VALUES ('2750', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('2751', 'German', '83811843');
INSERT INTO `grid50000` VALUES ('2752', 'princes', '83811843');
INSERT INTO `grid50000` VALUES ('2753', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('2754', '', '83811843');
INSERT INTO `grid50000` VALUES ('2755', 'after', '83811843');
INSERT INTO `grid50000` VALUES ('2756', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2757', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('2758', 'King', '83811843');
INSERT INTO `grid50000` VALUES ('2759', 'Przemysl', '83811843');
INSERT INTO `grid50000` VALUES ('2760', 'Otakar', '83811843');
INSERT INTO `grid50000` VALUES ('2761', 'II', '83811843');
INSERT INTO `grid50000` VALUES ('2762', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('2763', 'killed', '83811843');
INSERT INTO `grid50000` VALUES ('2764', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('2765', 'battle', '83811843');
INSERT INTO `grid50000` VALUES ('2766', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('2767', 'Moravia', '83811843');
INSERT INTO `grid50000` VALUES ('2768', 'against', '83811843');
INSERT INTO `grid50000` VALUES ('2769', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2770', 'combined', '83811843');
INSERT INTO `grid50000` VALUES ('2771', 'Roman', '83811843');
INSERT INTO `grid50000` VALUES ('2772', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('2773', 'Hungarian', '83811843');
INSERT INTO `grid50000` VALUES ('2774', 'forces', '83811843');
INSERT INTO `grid50000` VALUES ('2775', 'on', '83811843');
INSERT INTO `grid50000` VALUES ('2776', 'August', '83811843');
INSERT INTO `grid50000` VALUES ('2777', '26', '83811843');
INSERT INTO `grid50000` VALUES ('2778', '1278', '83811843');
INSERT INTO `grid50000` VALUES ('2779', '', '83811843');
INSERT INTO `grid50000` VALUES ('2780', 'Rudolf', '83811843');
INSERT INTO `grid50000` VALUES ('2781', 'took', '83811843');
INSERT INTO `grid50000` VALUES ('2782', 'possession', '83811843');
INSERT INTO `grid50000` VALUES ('2783', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('2784', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2785', 'abovementioned', '83811843');
INSERT INTO `grid50000` VALUES ('2786', 'Alpine', '83811843');
INSERT INTO `grid50000` VALUES ('2787', 'lands', '83811843');
INSERT INTO `grid50000` VALUES ('2788', 'which', '83811843');
INSERT INTO `grid50000` VALUES ('2789', 'later', '83811843');
INSERT INTO `grid50000` VALUES ('2790', 'became', '83811843');
INSERT INTO `grid50000` VALUES ('2791', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2792', 'basis', '83811843');
INSERT INTO `grid50000` VALUES ('2793', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('2794', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2795', 'Habsburgs', '83811843');
INSERT INTO `grid50000` VALUES ('2796', 'power', '83811843');
INSERT INTO `grid50000` VALUES ('2797', '', '83811843');
INSERT INTO `grid50000` VALUES ('2798', 'ie', '83811843');
INSERT INTO `grid50000` VALUES ('2799', 'Austria', '83811843');
INSERT INTO `grid50000` VALUES ('2800', '\r\n\r\nThe', '83811843');
INSERT INTO `grid50000` VALUES ('2801', 'late', '83811843');
INSERT INTO `grid50000` VALUES ('2802', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('2803', 'King', '83811843');
INSERT INTO `grid50000` VALUES ('2804', 'Przemysl', '83811843');
INSERT INTO `grid50000` VALUES ('2805', 'Otakar', '83811843');
INSERT INTO `grid50000` VALUES ('2806', 'II', '83811843');
INSERT INTO `grid50000` VALUES ('2807', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('2808', 'succeeded', '83811843');
INSERT INTO `grid50000` VALUES ('2809', 'by', '83811843');
INSERT INTO `grid50000` VALUES ('2810', 'his', '83811843');
INSERT INTO `grid50000` VALUES ('2811', 'son', '83811843');
INSERT INTO `grid50000` VALUES ('2812', 'Wenceslas', '83811843');
INSERT INTO `grid50000` VALUES ('2813', 'II', '83811843');
INSERT INTO `grid50000` VALUES ('2814', '12781305', '83811843');
INSERT INTO `grid50000` VALUES ('2815', 'Under', '83811843');
INSERT INTO `grid50000` VALUES ('2816', 'his', '83811843');
INSERT INTO `grid50000` VALUES ('2817', 'reign', '83811843');
INSERT INTO `grid50000` VALUES ('2818', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2819', 'mining', '83811843');
INSERT INTO `grid50000` VALUES ('2820', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('2821', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('2822', 'silver', '83811843');
INSERT INTO `grid50000` VALUES ('2823', 'at', '83811843');
INSERT INTO `grid50000` VALUES ('2824', 'Kutna', '83811843');
INSERT INTO `grid50000` VALUES ('2825', 'Hora', '83811843');
INSERT INTO `grid50000` VALUES ('2826', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('2827', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2828', 'minting', '83811843');
INSERT INTO `grid50000` VALUES ('2829', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('2830', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2831', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('2832', 'silver', '83811843');
INSERT INTO `grid50000` VALUES ('2833', 'groschen', '83811843');
INSERT INTO `grid50000` VALUES ('2834', '', '83811843');
INSERT INTO `grid50000` VALUES ('2835', 'one', '83811843');
INSERT INTO `grid50000` VALUES ('2836', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('2837', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2838', 'hardest', '83811843');
INSERT INTO `grid50000` VALUES ('2839', 'European', '83811843');
INSERT INTO `grid50000` VALUES ('2840', 'currencies', '83811843');
INSERT INTO `grid50000` VALUES ('2841', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('2842', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2843', 'time', '83811843');
INSERT INTO `grid50000` VALUES ('2844', '', '83811843');
INSERT INTO `grid50000` VALUES ('2845', 'flourished', '83811843');
INSERT INTO `grid50000` VALUES ('2846', 'Wenceslas', '83811843');
INSERT INTO `grid50000` VALUES ('2847', 'II', '83811843');
INSERT INTO `grid50000` VALUES ('2848', 'also', '83811843');
INSERT INTO `grid50000` VALUES ('2849', 'created', '83811843');
INSERT INTO `grid50000` VALUES ('2850', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('2851', 'confederation', '83811843');
INSERT INTO `grid50000` VALUES ('2852', 'between', '83811843');
INSERT INTO `grid50000` VALUES ('2853', 'Bohemia', '83811843');
INSERT INTO `grid50000` VALUES ('2854', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('2855', 'Poland', '83811843');
INSERT INTO `grid50000` VALUES ('2856', 'For', '83811843');
INSERT INTO `grid50000` VALUES ('2857', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('2858', 'short', '83811843');
INSERT INTO `grid50000` VALUES ('2859', 'time', '83811843');
INSERT INTO `grid50000` VALUES ('2860', 'Hungary', '83811843');
INSERT INTO `grid50000` VALUES ('2861', '', '83811843');
INSERT INTO `grid50000` VALUES ('2862', 'under', '83811843');
INSERT INTO `grid50000` VALUES ('2863', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2864', 'rule', '83811843');
INSERT INTO `grid50000` VALUES ('2865', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('2866', 'Matthias', '83811843');
INSERT INTO `grid50000` VALUES ('2867', 'Czak', '83811843');
INSERT INTO `grid50000` VALUES ('2868', 'Trenciansky', '83811843');
INSERT INTO `grid50000` VALUES ('2869', 'who', '83811843');
INSERT INTO `grid50000` VALUES ('2870', 'held', '83811843');
INSERT INTO `grid50000` VALUES ('2871', 'absolute', '83811843');
INSERT INTO `grid50000` VALUES ('2872', 'rule', '83811843');
INSERT INTO `grid50000` VALUES ('2873', 'over', '83811843');
INSERT INTO `grid50000` VALUES ('2874', 'most', '83811843');
INSERT INTO `grid50000` VALUES ('2875', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('2876', 'Slovakia', '83811843');
INSERT INTO `grid50000` VALUES ('2877', 'as', '83811843');
INSERT INTO `grid50000` VALUES ('2878', 'well', '83811843');
INSERT INTO `grid50000` VALUES ('2879', '', '83811843');
INSERT INTO `grid50000` VALUES ('2880', 'also', '83811843');
INSERT INTO `grid50000` VALUES ('2881', 'joined', '83811843');
INSERT INTO `grid50000` VALUES ('2882', 'this', '83811843');
INSERT INTO `grid50000` VALUES ('2883', 'confederation', '83811843');
INSERT INTO `grid50000` VALUES ('2884', '\r\n\r\nThe', '83811843');
INSERT INTO `grid50000` VALUES ('2885', 'PolishCzech', '83811843');
INSERT INTO `grid50000` VALUES ('2886', 'union', '83811843');
INSERT INTO `grid50000` VALUES ('2887', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('2888', 'strengthened', '83811843');
INSERT INTO `grid50000` VALUES ('2889', 'under', '83811843');
INSERT INTO `grid50000` VALUES ('2890', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2891', 'brief', '83811843');
INSERT INTO `grid50000` VALUES ('2892', 'rule', '83811843');
INSERT INTO `grid50000` VALUES ('2893', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('2894', 'Wenceslas', '83811843');
INSERT INTO `grid50000` VALUES ('2895', 'III', '83811843');
INSERT INTO `grid50000` VALUES ('2896', 'Had', '83811843');
INSERT INTO `grid50000` VALUES ('2897', 'it', '83811843');
INSERT INTO `grid50000` VALUES ('2898', 'survived', '83811843');
INSERT INTO `grid50000` VALUES ('2899', 'it', '83811843');
INSERT INTO `grid50000` VALUES ('2900', 'might', '83811843');
INSERT INTO `grid50000` VALUES ('2901', 'have', '83811843');
INSERT INTO `grid50000` VALUES ('2902', 'contributed', '83811843');
INSERT INTO `grid50000` VALUES ('2903', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('2904', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2905', 'creation', '83811843');
INSERT INTO `grid50000` VALUES ('2906', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('2907', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('2908', 'more', '83811843');
INSERT INTO `grid50000` VALUES ('2909', 'advanced', '83811843');
INSERT INTO `grid50000` VALUES ('2910', 'region', '83811843');
INSERT INTO `grid50000` VALUES ('2911', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('2912', 'Europe', '83811843');
INSERT INTO `grid50000` VALUES ('2913', 'as', '83811843');
INSERT INTO `grid50000` VALUES ('2914', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2915', 'earlier', '83811843');
INSERT INTO `grid50000` VALUES ('2916', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('2917', 'Austrian', '83811843');
INSERT INTO `grid50000` VALUES ('2918', 'union', '83811843');
INSERT INTO `grid50000` VALUES ('2919', 'had', '83811843');
INSERT INTO `grid50000` VALUES ('2920', 'However', '83811843');
INSERT INTO `grid50000` VALUES ('2921', 'this', '83811843');
INSERT INTO `grid50000` VALUES ('2922', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('2923', 'precluded', '83811843');
INSERT INTO `grid50000` VALUES ('2924', 'by', '83811843');
INSERT INTO `grid50000` VALUES ('2925', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2926', 'death', '83811843');
INSERT INTO `grid50000` VALUES ('2927', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('2928', 'young', '83811843');
INSERT INTO `grid50000` VALUES ('2929', 'Wenceslas', '83811843');
INSERT INTO `grid50000` VALUES ('2930', 'III', '83811843');
INSERT INTO `grid50000` VALUES ('2931', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('2932', '1306', '83811843');
INSERT INTO `grid50000` VALUES ('2933', 'when', '83811843');
INSERT INTO `grid50000` VALUES ('2934', 'he', '83811843');
INSERT INTO `grid50000` VALUES ('2935', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('2936', 'just', '83811843');
INSERT INTO `grid50000` VALUES ('2937', '17', '83811843');
INSERT INTO `grid50000` VALUES ('2938', 'years', '83811843');
INSERT INTO `grid50000` VALUES ('2939', 'old', '83811843');
INSERT INTO `grid50000` VALUES ('2940', 'Wenceslas', '83811843');
INSERT INTO `grid50000` VALUES ('2941', 'III', '83811843');
INSERT INTO `grid50000` VALUES ('2942', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('2943', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2944', 'last', '83811843');
INSERT INTO `grid50000` VALUES ('2945', 'male', '83811843');
INSERT INTO `grid50000` VALUES ('2946', 'member', '83811843');
INSERT INTO `grid50000` VALUES ('2947', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('2948', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2949', 'Przemyslids', '83811843');
INSERT INTO `grid50000` VALUES ('2950', 'line', '83811843');
INSERT INTO `grid50000` VALUES ('2951', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('2952', 'after', '83811843');
INSERT INTO `grid50000` VALUES ('2953', 'his', '83811843');
INSERT INTO `grid50000` VALUES ('2954', 'death', '83811843');
INSERT INTO `grid50000` VALUES ('2955', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2956', 'CzechPolish', '83811843');
INSERT INTO `grid50000` VALUES ('2957', 'union', '83811843');
INSERT INTO `grid50000` VALUES ('2958', 'fell', '83811843');
INSERT INTO `grid50000` VALUES ('2959', 'apart\r\n\r\n\r\nWith', '83811843');
INSERT INTO `grid50000` VALUES ('2960', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2961', 'demise', '83811843');
INSERT INTO `grid50000` VALUES ('2962', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('2963', 'Wenceslas', '83811843');
INSERT INTO `grid50000` VALUES ('2964', 'III', '83811843');
INSERT INTO `grid50000` VALUES ('2965', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2966', 'last', '83811843');
INSERT INTO `grid50000` VALUES ('2967', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('2968', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2969', 'Przemyslid', '83811843');
INSERT INTO `grid50000` VALUES ('2970', 'rulers', '83811843');
INSERT INTO `grid50000` VALUES ('2971', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('2972', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2973', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('2974', 'lands', '83811843');
INSERT INTO `grid50000` VALUES ('2975', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2976', 'difficult', '83811843');
INSERT INTO `grid50000` VALUES ('2977', 'question', '83811843');
INSERT INTO `grid50000` VALUES ('2978', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('2979', 'who', '83811843');
INSERT INTO `grid50000` VALUES ('2980', 'should', '83811843');
INSERT INTO `grid50000` VALUES ('2981', 'rule', '83811843');
INSERT INTO `grid50000` VALUES ('2982', 'next', '83811843');
INSERT INTO `grid50000` VALUES ('2983', 'had', '83811843');
INSERT INTO `grid50000` VALUES ('2984', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('2985', 'be', '83811843');
INSERT INTO `grid50000` VALUES ('2986', 'answered', '83811843');
INSERT INTO `grid50000` VALUES ('2987', 'And', '83811843');
INSERT INTO `grid50000` VALUES ('2988', 'answered', '83811843');
INSERT INTO `grid50000` VALUES ('2989', 'it', '83811843');
INSERT INTO `grid50000` VALUES ('2990', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('2991', '', '83811843');
INSERT INTO `grid50000` VALUES ('2992', 'by', '83811843');
INSERT INTO `grid50000` VALUES ('2993', '14yearold', '83811843');
INSERT INTO `grid50000` VALUES ('2994', 'John', '83811843');
INSERT INTO `grid50000` VALUES ('2995', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('2996', 'Luxembourg', '83811843');
INSERT INTO `grid50000` VALUES ('2997', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('2998', 'first', '83811843');
INSERT INTO `grid50000` VALUES ('2999', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('3000', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('3001', 'Luxembourgs', '83811843');
INSERT INTO `grid50000` VALUES ('3002', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('3003', 'occupy', '83811843');
INSERT INTO `grid50000` VALUES ('3004', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('3005', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('3006', 'throne', '83811843');
INSERT INTO `grid50000` VALUES ('3007', '13101437', '83811843');
INSERT INTO `grid50000` VALUES ('3008', 'John', '83811843');
INSERT INTO `grid50000` VALUES ('3009', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('3010', 'Luxembourg', '83811843');
INSERT INTO `grid50000` VALUES ('3011', 'gained', '83811843');
INSERT INTO `grid50000` VALUES ('3012', 'this', '83811843');
INSERT INTO `grid50000` VALUES ('3013', 'position', '83811843');
INSERT INTO `grid50000` VALUES ('3014', 'with', '83811843');
INSERT INTO `grid50000` VALUES ('3015', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('3016', 'support', '83811843');
INSERT INTO `grid50000` VALUES ('3017', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('3018', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('3019', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('3020', 'nobility', '83811843');
INSERT INTO `grid50000` VALUES ('3021', 'by', '83811843');
INSERT INTO `grid50000` VALUES ('3022', 'marrying', '83811843');
INSERT INTO `grid50000` VALUES ('3023', '18yearold', '83811843');
INSERT INTO `grid50000` VALUES ('3024', 'Eliska', '83811843');
INSERT INTO `grid50000` VALUES ('3025', 'Przemyslova', '83811843');
INSERT INTO `grid50000` VALUES ('3026', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('3027', 'sister', '83811843');
INSERT INTO `grid50000` VALUES ('3028', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('3029', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('3030', 'late', '83811843');
INSERT INTO `grid50000` VALUES ('3031', 'Wenceslas', '83811843');
INSERT INTO `grid50000` VALUES ('3032', 'III', '83811843');
INSERT INTO `grid50000` VALUES ('3033', '\r\n\r\nUnder', '83811843');
INSERT INTO `grid50000` VALUES ('3034', 'John', '83811843');
INSERT INTO `grid50000` VALUES ('3035', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('3036', 'Luxembourgs', '83811843');
INSERT INTO `grid50000` VALUES ('3037', 'rule', '83811843');
INSERT INTO `grid50000` VALUES ('3038', 'more', '83811843');
INSERT INTO `grid50000` VALUES ('3039', 'territories', '83811843');
INSERT INTO `grid50000` VALUES ('3040', '', '83811843');
INSERT INTO `grid50000` VALUES ('3041', 'including', '83811843');
INSERT INTO `grid50000` VALUES ('3042', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('3043', 'regions', '83811843');
INSERT INTO `grid50000` VALUES ('3044', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('3045', 'Cheb', '83811843');
INSERT INTO `grid50000` VALUES ('3046', 'Lusatia', '83811843');
INSERT INTO `grid50000` VALUES ('3047', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('3048', 'Silesia', '83811843');
INSERT INTO `grid50000` VALUES ('3049', '', '83811843');
INSERT INTO `grid50000` VALUES ('3050', 'were', '83811843');
INSERT INTO `grid50000` VALUES ('3051', 'joined', '83811843');
INSERT INTO `grid50000` VALUES ('3052', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('3053', 'Bohemia', '83811843');
INSERT INTO `grid50000` VALUES ('3054', 'All', '83811843');
INSERT INTO `grid50000` VALUES ('3055', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('3056', 'these', '83811843');
INSERT INTO `grid50000` VALUES ('3057', 'regions', '83811843');
INSERT INTO `grid50000` VALUES ('3058', 'together', '83811843');
INSERT INTO `grid50000` VALUES ('3059', 'under', '83811843');
INSERT INTO `grid50000` VALUES ('3060', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('3061', 'rule', '83811843');
INSERT INTO `grid50000` VALUES ('3062', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('3063', 'John', '83811843');
INSERT INTO `grid50000` VALUES ('3064', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('3065', 'Luxembourg', '83811843');
INSERT INTO `grid50000` VALUES ('3066', 'came', '83811843');
INSERT INTO `grid50000` VALUES ('3067', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('3068', 'be', '83811843');
INSERT INTO `grid50000` VALUES ('3069', 'known', '83811843');
INSERT INTO `grid50000` VALUES ('3070', 'as', '83811843');
INSERT INTO `grid50000` VALUES ('3071', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('3072', 'Lands', '83811843');
INSERT INTO `grid50000` VALUES ('3073', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('3074', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('3075', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('3076', 'Crown', '83811843');
INSERT INTO `grid50000` VALUES ('3077', 'So', '83811843');
INSERT INTO `grid50000` VALUES ('3078', 'you', '83811843');
INSERT INTO `grid50000` VALUES ('3079', 'see', '83811843');
INSERT INTO `grid50000` VALUES ('3080', 'there', '83811843');
INSERT INTO `grid50000` VALUES ('3081', 'never', '83811843');
INSERT INTO `grid50000` VALUES ('3082', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('3083', 'an', '83811843');
INSERT INTO `grid50000` VALUES ('3084', 'easy', '83811843');
INSERT INTO `grid50000` VALUES ('3085', 'oneword', '83811843');
INSERT INTO `grid50000` VALUES ('3086', 'way', '83811843');
INSERT INTO `grid50000` VALUES ('3087', 'like', '83811843');
INSERT INTO `grid50000` VALUES ('3088', 'Czechia', '83811843');
INSERT INTO `grid50000` VALUES ('3089', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('3090', 'describe', '83811843');
INSERT INTO `grid50000` VALUES ('3091', 'this', '83811843');
INSERT INTO `grid50000` VALUES ('3092', 'part', '83811843');
INSERT INTO `grid50000` VALUES ('3093', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('3094', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('3095', 'world', '83811843');
INSERT INTO `grid50000` VALUES ('3096', 'not', '83811843');
INSERT INTO `grid50000` VALUES ('3097', 'even', '83811843');
INSERT INTO `grid50000` VALUES ('3098', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('3099', 'way', '83811843');
INSERT INTO `grid50000` VALUES ('3100', 'back', '83811843');
INSERT INTO `grid50000` VALUES ('3101', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('3102', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('3103', '14th', '83811843');
INSERT INTO `grid50000` VALUES ('3104', 'century', '83811843');
INSERT INTO `grid50000` VALUES ('3105', '\r\n\r\nJohn', '83811843');
INSERT INTO `grid50000` VALUES ('3106', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('3107', 'Luxembourg', '83811843');
INSERT INTO `grid50000` VALUES ('3108', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('3109', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('3110', 'good', '83811843');
INSERT INTO `grid50000` VALUES ('3111', 'king', '83811843');
INSERT INTO `grid50000` VALUES ('3112', 'but', '83811843');
INSERT INTO `grid50000` VALUES ('3113', 'he', '83811843');
INSERT INTO `grid50000` VALUES ('3114', 'had', '83811843');
INSERT INTO `grid50000` VALUES ('3115', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('3116', 'fatal', '83811843');
INSERT INTO `grid50000` VALUES ('3117', 'weakness', '83811843');
INSERT INTO `grid50000` VALUES ('3119', 'chivalry', '83811843');
INSERT INTO `grid50000` VALUES ('3120', 'knighthood', '83811843');
INSERT INTO `grid50000` VALUES ('3121', 'honour', '83811843');
INSERT INTO `grid50000` VALUES ('3122', '', '83811843');
INSERT INTO `grid50000` VALUES ('3123', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('3124', 'especially', '83811843');
INSERT INTO `grid50000` VALUES ('3125', 'for', '83811843');
INSERT INTO `grid50000` VALUES ('3126', 'battles', '83811843');
INSERT INTO `grid50000` VALUES ('3127', 'He', '83811843');
INSERT INTO `grid50000` VALUES ('3128', 'loved', '83811843');
INSERT INTO `grid50000` VALUES ('3129', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('3130', 'fight', '83811843');
INSERT INTO `grid50000` VALUES ('3131', 'When', '83811843');
INSERT INTO `grid50000` VALUES ('3132', 'there', '83811843');
INSERT INTO `grid50000` VALUES ('3133', 'werent', '83811843');
INSERT INTO `grid50000` VALUES ('3134', 'any', '83811843');
INSERT INTO `grid50000` VALUES ('3135', 'battles', '83811843');
INSERT INTO `grid50000` VALUES ('3136', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('3137', 'his', '83811843');
INSERT INTO `grid50000` VALUES ('3138', 'immediate', '83811843');
INSERT INTO `grid50000` VALUES ('3139', 'neighborhood', '83811843');
INSERT INTO `grid50000` VALUES ('3140', 'he', '83811843');
INSERT INTO `grid50000` VALUES ('3141', 'went', '83811843');
INSERT INTO `grid50000` VALUES ('3142', 'abroad', '83811843');
INSERT INTO `grid50000` VALUES ('3143', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('3144', 'help', '83811843');
INSERT INTO `grid50000` VALUES ('3145', 'his', '83811843');
INSERT INTO `grid50000` VALUES ('3146', 'friends', '83811843');
INSERT INTO `grid50000` VALUES ('3147', 'fight', '83811843');
INSERT INTO `grid50000` VALUES ('3148', 'their', '83811843');
INSERT INTO `grid50000` VALUES ('3149', 'battles', '83811843');
INSERT INTO `grid50000` VALUES ('3150', 'And', '83811843');
INSERT INTO `grid50000` VALUES ('3151', 'so', '83811843');
INSERT INTO `grid50000` VALUES ('3152', 'it', '83811843');
INSERT INTO `grid50000` VALUES ('3153', 'happened', '83811843');
INSERT INTO `grid50000` VALUES ('3154', 'that', '83811843');
INSERT INTO `grid50000` VALUES ('3155', 'he', '83811843');
INSERT INTO `grid50000` VALUES ('3156', 'fell', '83811843');
INSERT INTO `grid50000` VALUES ('3157', 'at', '83811843');
INSERT INTO `grid50000` VALUES ('3158', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('3159', 'battle', '83811843');
INSERT INTO `grid50000` VALUES ('3160', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('3161', 'Crecy', '83811843');
INSERT INTO `grid50000` VALUES ('3162', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('3163', '1346', '83811843');
INSERT INTO `grid50000` VALUES ('3164', 'fighting', '83811843');
INSERT INTO `grid50000` VALUES ('3165', 'on', '83811843');
INSERT INTO `grid50000` VALUES ('3166', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('3167', 'side', '83811843');
INSERT INTO `grid50000` VALUES ('3168', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('3169', 'his', '83811843');
INSERT INTO `grid50000` VALUES ('3170', 'French', '83811843');
INSERT INTO `grid50000` VALUES ('3171', 'friend', '83811843');
INSERT INTO `grid50000` VALUES ('3172', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('3173', 'distant', '83811843');
INSERT INTO `grid50000` VALUES ('3174', 'relative', '83811843');
INSERT INTO `grid50000` VALUES ('3175', 'Charles', '83811843');
INSERT INTO `grid50000` VALUES ('3176', 'against', '83811843');
INSERT INTO `grid50000` VALUES ('3177', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('3178', 'Black', '83811843');
INSERT INTO `grid50000` VALUES ('3179', 'Prince', '83811843');
INSERT INTO `grid50000` VALUES ('3180', 'And', '83811843');
INSERT INTO `grid50000` VALUES ('3181', 'so', '83811843');
INSERT INTO `grid50000` VALUES ('3182', 'he', '83811843');
INSERT INTO `grid50000` VALUES ('3183', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('3184', 'succeeded', '83811843');
INSERT INTO `grid50000` VALUES ('3185', 'by', '83811843');
INSERT INTO `grid50000` VALUES ('3186', 'his', '83811843');
INSERT INTO `grid50000` VALUES ('3187', 'young', '83811843');
INSERT INTO `grid50000` VALUES ('3188', 'son', '83811843');
INSERT INTO `grid50000` VALUES ('3189', 'Charles', '83811843');
INSERT INTO `grid50000` VALUES ('3190', 'IV', '83811843');
INSERT INTO `grid50000` VALUES ('3191', '\r\n\r\n', '83811843');
INSERT INTO `grid50000` VALUES ('3192', 'Charles', '83811843');
INSERT INTO `grid50000` VALUES ('3193', 'IV', '83811843');
INSERT INTO `grid50000` VALUES ('3194', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('3195', 'just', '83811843');
INSERT INTO `grid50000` VALUES ('3196', 'as', '83811843');
INSERT INTO `grid50000` VALUES ('3197', 'noble', '83811843');
INSERT INTO `grid50000` VALUES ('3198', '', '83811843');
INSERT INTO `grid50000` VALUES ('3199', 'but', '83811843');
INSERT INTO `grid50000` VALUES ('3200', 'much', '83811843');
INSERT INTO `grid50000` VALUES ('3201', 'more', '83811843');
INSERT INTO `grid50000` VALUES ('3202', 'practical', '83811843');
INSERT INTO `grid50000` VALUES ('3203', 'than', '83811843');
INSERT INTO `grid50000` VALUES ('3204', 'his', '83811843');
INSERT INTO `grid50000` VALUES ('3205', 'caravanting', '83811843');
INSERT INTO `grid50000` VALUES ('3206', 'father', '83811843');
INSERT INTO `grid50000` VALUES ('3207', 'had', '83811843');
INSERT INTO `grid50000` VALUES ('3208', 'been', '83811843');
INSERT INTO `grid50000` VALUES ('3209', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('3210', 'he', '83811843');
INSERT INTO `grid50000` VALUES ('3211', 'took', '83811843');
INSERT INTO `grid50000` VALUES ('3212', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('3213', 'keen', '83811843');
INSERT INTO `grid50000` VALUES ('3214', 'interest', '83811843');
INSERT INTO `grid50000` VALUES ('3215', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('3216', 'all', '83811843');
INSERT INTO `grid50000` VALUES ('3217', 'aspects', '83811843');
INSERT INTO `grid50000` VALUES ('3218', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('3219', 'rule', '83811843');
INSERT INTO `grid50000` VALUES ('3220', 'over', '83811843');
INSERT INTO `grid50000` VALUES ('3221', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('3222', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('3223', 'lands', '83811843');
INSERT INTO `grid50000` VALUES ('3224', 'Charles', '83811843');
INSERT INTO `grid50000` VALUES ('3225', 'IV', '83811843');
INSERT INTO `grid50000` VALUES ('3226', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('3227', 'not', '83811843');
INSERT INTO `grid50000` VALUES ('3228', 'really', '83811843');
INSERT INTO `grid50000` VALUES ('3229', 'named', '83811843');
INSERT INTO `grid50000` VALUES ('3230', 'Charles', '83811843');
INSERT INTO `grid50000` VALUES ('3231', 'He', '83811843');
INSERT INTO `grid50000` VALUES ('3232', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('3233', 'named', '83811843');
INSERT INTO `grid50000` VALUES ('3234', 'Wenceslas', '83811843');
INSERT INTO `grid50000` VALUES ('3235', 'IV', '83811843');
INSERT INTO `grid50000` VALUES ('3236', '', '83811843');
INSERT INTO `grid50000` VALUES ('3237', 'but', '83811843');
INSERT INTO `grid50000` VALUES ('3238', 'he', '83811843');
INSERT INTO `grid50000` VALUES ('3239', 'had', '83811843');
INSERT INTO `grid50000` VALUES ('3240', 'been', '83811843');
INSERT INTO `grid50000` VALUES ('3241', 'reared', '83811843');
INSERT INTO `grid50000` VALUES ('3242', 'at', '83811843');
INSERT INTO `grid50000` VALUES ('3243', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('3244', 'French', '83811843');
INSERT INTO `grid50000` VALUES ('3245', 'court', '83811843');
INSERT INTO `grid50000` VALUES ('3246', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('3247', 'everyone', '83811843');
INSERT INTO `grid50000` VALUES ('3248', 'there', '83811843');
INSERT INTO `grid50000` VALUES ('3249', 'called', '83811843');
INSERT INTO `grid50000` VALUES ('3250', 'him', '83811843');
INSERT INTO `grid50000` VALUES ('3251', 'Charles', '83811843');
INSERT INTO `grid50000` VALUES ('3252', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('3253', 'so', '83811843');
INSERT INTO `grid50000` VALUES ('3254', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('3255', 'name', '83811843');
INSERT INTO `grid50000` VALUES ('3256', 'stuck', '83811843');
INSERT INTO `grid50000` VALUES ('3257', 'His', '83811843');
INSERT INTO `grid50000` VALUES ('3258', 'son', '83811843');
INSERT INTO `grid50000` VALUES ('3259', 'who', '83811843');
INSERT INTO `grid50000` VALUES ('3260', 'succeeded', '83811843');
INSERT INTO `grid50000` VALUES ('3261', 'him', '83811843');
INSERT INTO `grid50000` VALUES ('3262', 'on', '83811843');
INSERT INTO `grid50000` VALUES ('3263', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('3264', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('3265', 'throne', '83811843');
INSERT INTO `grid50000` VALUES ('3266', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('3267', 'also', '83811843');
INSERT INTO `grid50000` VALUES ('3268', 'named', '83811843');
INSERT INTO `grid50000` VALUES ('3269', 'Wenceslas', '83811843');
INSERT INTO `grid50000` VALUES ('3270', 'IV', '83811843');
INSERT INTO `grid50000` VALUES ('3271', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('3272', 'this', '83811843');
INSERT INTO `grid50000` VALUES ('3273', 'sometimes', '83811843');
INSERT INTO `grid50000` VALUES ('3274', 'leads', '83811843');
INSERT INTO `grid50000` VALUES ('3275', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('3276', 'some', '83811843');
INSERT INTO `grid50000` VALUES ('3277', 'confusion', '83811843');
INSERT INTO `grid50000` VALUES ('3278', 'When', '83811843');
INSERT INTO `grid50000` VALUES ('3279', 'Charles', '83811843');
INSERT INTO `grid50000` VALUES ('3280', 'IV', '83811843');
INSERT INTO `grid50000` VALUES ('3281', 'came', '83811843');
INSERT INTO `grid50000` VALUES ('3282', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('3283', 'power', '83811843');
INSERT INTO `grid50000` VALUES ('3284', 'he', '83811843');
INSERT INTO `grid50000` VALUES ('3285', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('3286', 'still', '83811843');
INSERT INTO `grid50000` VALUES ('3287', 'very', '83811843');
INSERT INTO `grid50000` VALUES ('3288', 'young', '83811843');
INSERT INTO `grid50000` VALUES ('3289', 'Since', '83811843');
INSERT INTO `grid50000` VALUES ('3290', 'hed', '83811843');
INSERT INTO `grid50000` VALUES ('3291', 'been', '83811843');
INSERT INTO `grid50000` VALUES ('3292', 'raised', '83811843');
INSERT INTO `grid50000` VALUES ('3293', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('3294', 'France', '83811843');
INSERT INTO `grid50000` VALUES ('3295', 'he', '83811843');
INSERT INTO `grid50000` VALUES ('3296', 'didnt', '83811843');
INSERT INTO `grid50000` VALUES ('3297', 'speak', '83811843');
INSERT INTO `grid50000` VALUES ('3298', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('3299', 'Wicked', '83811843');
INSERT INTO `grid50000` VALUES ('3300', 'advisors', '83811843');
INSERT INTO `grid50000` VALUES ('3301', 'surrounded', '83811843');
INSERT INTO `grid50000` VALUES ('3302', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('3303', 'young', '83811843');
INSERT INTO `grid50000` VALUES ('3304', 'king', '83811843');
INSERT INTO `grid50000` VALUES ('3305', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('3306', 'attempted', '83811843');
INSERT INTO `grid50000` VALUES ('3307', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('3308', 'usurp', '83811843');
INSERT INTO `grid50000` VALUES ('3309', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('3310', 'real', '83811843');
INSERT INTO `grid50000` VALUES ('3311', 'rule', '83811843');
INSERT INTO `grid50000` VALUES ('3312', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('3313', 'Bohemia', '83811843');
INSERT INTO `grid50000` VALUES ('3314', 'while', '83811843');
INSERT INTO `grid50000` VALUES ('3315', 'leaving', '83811843');
INSERT INTO `grid50000` VALUES ('3316', 'young', '83811843');
INSERT INTO `grid50000` VALUES ('3317', 'Charles', '83811843');
INSERT INTO `grid50000` VALUES ('3318', 'IV', '83811843');
INSERT INTO `grid50000` VALUES ('3319', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('3320', 'place', '83811843');
INSERT INTO `grid50000` VALUES ('3321', 'as', '83811843');
INSERT INTO `grid50000` VALUES ('3322', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('3323', 'figurehead', '83811843');
INSERT INTO `grid50000` VALUES ('3324', '\r\n\r\nCharles', '83811843');
INSERT INTO `grid50000` VALUES ('3325', 'IV', '83811843');
INSERT INTO `grid50000` VALUES ('3326', '', '83811843');
INSERT INTO `grid50000` VALUES ('3327', 'may', '83811843');
INSERT INTO `grid50000` VALUES ('3328', 'have', '83811843');
INSERT INTO `grid50000` VALUES ('3329', 'been', '83811843');
INSERT INTO `grid50000` VALUES ('3330', 'young', '83811843');
INSERT INTO `grid50000` VALUES ('3331', 'but', '83811843');
INSERT INTO `grid50000` VALUES ('3332', 'he', '83811843');
INSERT INTO `grid50000` VALUES ('3333', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('3334', 'no', '83811843');
INSERT INTO `grid50000` VALUES ('3335', 'dummy', '83811843');
INSERT INTO `grid50000` VALUES ('3336', 'He', '83811843');
INSERT INTO `grid50000` VALUES ('3337', 'spoke', '83811843');
INSERT INTO `grid50000` VALUES ('3338', '5', '83811843');
INSERT INTO `grid50000` VALUES ('3339', 'languages', '83811843');
INSERT INTO `grid50000` VALUES ('3340', 'fluently', '83811843');
INSERT INTO `grid50000` VALUES ('3341', 'at', '83811843');
INSERT INTO `grid50000` VALUES ('3342', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('3343', 'time', '83811843');
INSERT INTO `grid50000` VALUES ('3344', 'when', '83811843');
INSERT INTO `grid50000` VALUES ('3345', 'many', '83811843');
INSERT INTO `grid50000` VALUES ('3346', 'crowned', '83811843');
INSERT INTO `grid50000` VALUES ('3347', 'heads', '83811843');
INSERT INTO `grid50000` VALUES ('3348', 'could', '83811843');
INSERT INTO `grid50000` VALUES ('3349', 'not', '83811843');
INSERT INTO `grid50000` VALUES ('3350', 'even', '83811843');
INSERT INTO `grid50000` VALUES ('3351', 'read', '83811843');
INSERT INTO `grid50000` VALUES ('3352', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('3353', 'write', '83811843');
INSERT INTO `grid50000` VALUES ('3354', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('3355', 'he', '83811843');
INSERT INTO `grid50000` VALUES ('3356', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('3357', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('3358', 'masterful', '83811843');
INSERT INTO `grid50000` VALUES ('3359', 'diplomat', '83811843');
INSERT INTO `grid50000` VALUES ('3360', 'He', '83811843');
INSERT INTO `grid50000` VALUES ('3361', 'also', '83811843');
INSERT INTO `grid50000` VALUES ('3362', 'had', '83811843');
INSERT INTO `grid50000` VALUES ('3363', 'friends', '83811843');
INSERT INTO `grid50000` VALUES ('3364', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('3365', 'high', '83811843');
INSERT INTO `grid50000` VALUES ('3366', 'places', '83811843');
INSERT INTO `grid50000` VALUES ('3367', '', '83811843');
INSERT INTO `grid50000` VALUES ('3368', 'Pope', '83811843');
INSERT INTO `grid50000` VALUES ('3369', 'Klement', '83811843');
INSERT INTO `grid50000` VALUES ('3370', 'who', '83811843');
INSERT INTO `grid50000` VALUES ('3371', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('3372', 'elected', '83811843');
INSERT INTO `grid50000` VALUES ('3373', 'during', '83811843');
INSERT INTO `grid50000` VALUES ('3374', 'Charles', '83811843');
INSERT INTO `grid50000` VALUES ('3375', 'IVs', '83811843');
INSERT INTO `grid50000` VALUES ('3376', 'reign', '83811843');
INSERT INTO `grid50000` VALUES ('3377', 'had', '83811843');
INSERT INTO `grid50000` VALUES ('3378', 'been', '83811843');
INSERT INTO `grid50000` VALUES ('3379', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('3380', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('3381', 'sovereigns', '83811843');
INSERT INTO `grid50000` VALUES ('3382', 'tutor', '83811843');
INSERT INTO `grid50000` VALUES ('3383', 'at', '83811843');
INSERT INTO `grid50000` VALUES ('3384', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('3385', 'court', '83811843');
INSERT INTO `grid50000` VALUES ('3386', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('3387', 'Paris', '83811843');
INSERT INTO `grid50000` VALUES ('3388', '\r\n\r\nYoung', '83811843');
INSERT INTO `grid50000` VALUES ('3389', 'Charles', '83811843');
INSERT INTO `grid50000` VALUES ('3390', 'IV', '83811843');
INSERT INTO `grid50000` VALUES ('3391', 'saw', '83811843');
INSERT INTO `grid50000` VALUES ('3392', 'through', '83811843');
INSERT INTO `grid50000` VALUES ('3393', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('3394', 'transparent', '83811843');
INSERT INTO `grid50000` VALUES ('3395', 'plans', '83811843');
INSERT INTO `grid50000` VALUES ('3396', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('3397', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('3398', 'wicked', '83811843');
INSERT INTO `grid50000` VALUES ('3399', 'advisors', '83811843');
INSERT INTO `grid50000` VALUES ('3400', 'who', '83811843');
INSERT INTO `grid50000` VALUES ('3401', 'surrounded', '83811843');
INSERT INTO `grid50000` VALUES ('3402', 'him', '83811843');
INSERT INTO `grid50000` VALUES ('3403', 'He', '83811843');
INSERT INTO `grid50000` VALUES ('3404', 'quickly', '83811843');
INSERT INTO `grid50000` VALUES ('3405', 'learned', '83811843');
INSERT INTO `grid50000` VALUES ('3406', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('3407', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('3408', 'took', '83811843');
INSERT INTO `grid50000` VALUES ('3409', 'over', '83811843');
INSERT INTO `grid50000` VALUES ('3410', 'rule', '83811843');
INSERT INTO `grid50000` VALUES ('3411', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('3412', 'his', '83811843');
INSERT INTO `grid50000` VALUES ('3413', 'own', '83811843');
INSERT INTO `grid50000` VALUES ('3414', 'land', '83811843');
INSERT INTO `grid50000` VALUES ('3415', 'himself', '83811843');
INSERT INTO `grid50000` VALUES ('3416', '\r\n\r\nCharles', '83811843');
INSERT INTO `grid50000` VALUES ('3417', 'IV', '83811843');
INSERT INTO `grid50000` VALUES ('3418', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('3419', 'very', '83811843');
INSERT INTO `grid50000` VALUES ('3420', 'clever', '83811843');
INSERT INTO `grid50000` VALUES ('3421', 'very', '83811843');
INSERT INTO `grid50000` VALUES ('3422', 'devout', '83811843');
INSERT INTO `grid50000` VALUES ('3423', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('3424', 'very', '83811843');
INSERT INTO `grid50000` VALUES ('3425', 'savvy', '83811843');
INSERT INTO `grid50000` VALUES ('3426', 'He', '83811843');
INSERT INTO `grid50000` VALUES ('3427', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('3428', 'also', '83811843');
INSERT INTO `grid50000` VALUES ('3429', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('3430', 'lover', '83811843');
INSERT INTO `grid50000` VALUES ('3431', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('3432', 'art', '83811843');
INSERT INTO `grid50000` VALUES ('3433', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('3434', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('3435', 'collector', '83811843');
INSERT INTO `grid50000` VALUES ('3436', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('3437', 'holy', '83811843');
INSERT INTO `grid50000` VALUES ('3438', 'relics', '83811843');
INSERT INTO `grid50000` VALUES ('3439', 'which', '83811843');
INSERT INTO `grid50000` VALUES ('3440', 'he', '83811843');
INSERT INTO `grid50000` VALUES ('3441', 'kept', '83811843');
INSERT INTO `grid50000` VALUES ('3442', 'under', '83811843');
INSERT INTO `grid50000` VALUES ('3443', 'lock', '83811843');
INSERT INTO `grid50000` VALUES ('3444', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('3445', 'key', '83811843');
INSERT INTO `grid50000` VALUES ('3446', 'all', '83811843');
INSERT INTO `grid50000` VALUES ('3447', 'year', '83811843');
INSERT INTO `grid50000` VALUES ('3448', 'long', '83811843');
INSERT INTO `grid50000` VALUES ('3449', 'except', '83811843');
INSERT INTO `grid50000` VALUES ('3450', 'for', '83811843');
INSERT INTO `grid50000` VALUES ('3451', 'Easter', '83811843');
INSERT INTO `grid50000` VALUES ('3452', 'when', '83811843');
INSERT INTO `grid50000` VALUES ('3453', 'he', '83811843');
INSERT INTO `grid50000` VALUES ('3454', 'paraded', '83811843');
INSERT INTO `grid50000` VALUES ('3455', 'them', '83811843');
INSERT INTO `grid50000` VALUES ('3456', 'through', '83811843');
INSERT INTO `grid50000` VALUES ('3457', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('3458', 'country', '83811843');
INSERT INTO `grid50000` VALUES ('3459', 'like', '83811843');
INSERT INTO `grid50000` VALUES ('3460', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('3461', 'travelling', '83811843');
INSERT INTO `grid50000` VALUES ('3462', 'circus', '83811843');
INSERT INTO `grid50000` VALUES ('3463', '\r\n\r\nThe', '83811843');
INSERT INTO `grid50000` VALUES ('3464', 'medieval', '83811843');
INSERT INTO `grid50000` VALUES ('3465', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('3466', 'state', '83811843');
INSERT INTO `grid50000` VALUES ('3467', 'reached', '83811843');
INSERT INTO `grid50000` VALUES ('3468', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('3469', 'zenith', '83811843');
INSERT INTO `grid50000` VALUES ('3470', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('3471', 'its', '83811843');
INSERT INTO `grid50000` VALUES ('3472', 'power', '83811843');
INSERT INTO `grid50000` VALUES ('3473', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('3474', 'importance', '83811843');
INSERT INTO `grid50000` VALUES ('3475', 'Charles', '83811843');
INSERT INTO `grid50000` VALUES ('3476', 'IV', '83811843');
INSERT INTO `grid50000` VALUES ('3477', 'He', '83811843');
INSERT INTO `grid50000` VALUES ('3478', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('3479', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('3480', 'King', '83811843');
INSERT INTO `grid50000` VALUES ('3481', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('3482', 'Bohemia', '83811843');
INSERT INTO `grid50000` VALUES ('3483', 'later', '83811843');
INSERT INTO `grid50000` VALUES ('3484', 'also', '83811843');
INSERT INTO `grid50000` VALUES ('3485', 'Holy', '83811843');
INSERT INTO `grid50000` VALUES ('3486', 'Roman', '83811843');
INSERT INTO `grid50000` VALUES ('3487', 'Emperor', '83811843');
INSERT INTO `grid50000` VALUES ('3488', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('3489', 'today', '83811843');
INSERT INTO `grid50000` VALUES ('3490', 'he', '83811843');
INSERT INTO `grid50000` VALUES ('3491', 'is', '83811843');
INSERT INTO `grid50000` VALUES ('3492', 'known', '83811843');
INSERT INTO `grid50000` VALUES ('3493', 'as', '83811843');
INSERT INTO `grid50000` VALUES ('3494', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('3495', 'Father', '83811843');
INSERT INTO `grid50000` VALUES ('3496', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('3497', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('3498', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('3499', 'Nation', '83811843');
INSERT INTO `grid50000` VALUES ('3500', '\r\n\r\n', '83811843');
INSERT INTO `grid50000` VALUES ('3501', 'Charles', '83811843');
INSERT INTO `grid50000` VALUES ('3502', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('3503', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('3504', 'very', '83811843');
INSERT INTO `grid50000` VALUES ('3505', 'good', '83811843');
INSERT INTO `grid50000` VALUES ('3506', 'king', '83811843');
INSERT INTO `grid50000` VALUES ('3507', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('3508', 'he', '83811843');
INSERT INTO `grid50000` VALUES ('3509', 'paid', '83811843');
INSERT INTO `grid50000` VALUES ('3510', 'attention', '83811843');
INSERT INTO `grid50000` VALUES ('3511', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('3512', 'detail', '83811843');
INSERT INTO `grid50000` VALUES ('3513', 'It', '83811843');
INSERT INTO `grid50000` VALUES ('3514', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('3515', 'he', '83811843');
INSERT INTO `grid50000` VALUES ('3516', 'who', '83811843');
INSERT INTO `grid50000` VALUES ('3517', 'made', '83811843');
INSERT INTO `grid50000` VALUES ('3518', 'sure', '83811843');
INSERT INTO `grid50000` VALUES ('3519', 'that', '83811843');
INSERT INTO `grid50000` VALUES ('3520', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('3521', 'status', '83811843');
INSERT INTO `grid50000` VALUES ('3522', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('3523', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('3524', 'Lands', '83811843');
INSERT INTO `grid50000` VALUES ('3525', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('3526', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('3527', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('3528', 'Crown', '83811843');
INSERT INTO `grid50000` VALUES ('3529', '', '83811843');
INSERT INTO `grid50000` VALUES ('3530', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('3531', 'territories', '83811843');
INSERT INTO `grid50000` VALUES ('3532', 'his', '83811843');
INSERT INTO `grid50000` VALUES ('3533', 'father', '83811843');
INSERT INTO `grid50000` VALUES ('3534', 'had', '83811843');
INSERT INTO `grid50000` VALUES ('3535', 'gathered', '83811843');
INSERT INTO `grid50000` VALUES ('3536', 'together', '83811843');
INSERT INTO `grid50000` VALUES ('3537', 'under', '83811843');
INSERT INTO `grid50000` VALUES ('3538', 'his', '83811843');
INSERT INTO `grid50000` VALUES ('3539', 'rule', '83811843');
INSERT INTO `grid50000` VALUES ('3540', '', '83811843');
INSERT INTO `grid50000` VALUES ('3541', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('3542', 'legally', '83811843');
INSERT INTO `grid50000` VALUES ('3543', 'fixed', '83811843');
INSERT INTO `grid50000` VALUES ('3544', 'this', '83811843');
INSERT INTO `grid50000` VALUES ('3545', 'task', '83811843');
INSERT INTO `grid50000` VALUES ('3546', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('3547', 'made', '83811843');
INSERT INTO `grid50000` VALUES ('3548', 'all', '83811843');
INSERT INTO `grid50000` VALUES ('3549', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('3550', 'easier', '83811843');
INSERT INTO `grid50000` VALUES ('3551', 'since', '83811843');
INSERT INTO `grid50000` VALUES ('3552', 'he', '83811843');
INSERT INTO `grid50000` VALUES ('3553', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('3554', 'Holy', '83811843');
INSERT INTO `grid50000` VALUES ('3555', 'Roman', '83811843');
INSERT INTO `grid50000` VALUES ('3556', 'Emperor', '83811843');
INSERT INTO `grid50000` VALUES ('3557', 'He', '83811843');
INSERT INTO `grid50000` VALUES ('3558', 'initiated', '83811843');
INSERT INTO `grid50000` VALUES ('3559', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('3560', 'number', '83811843');
INSERT INTO `grid50000` VALUES ('3561', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('3562', 'building', '83811843');
INSERT INTO `grid50000` VALUES ('3563', 'projects', '83811843');
INSERT INTO `grid50000` VALUES ('3564', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('3565', 'his', '83811843');
INSERT INTO `grid50000` VALUES ('3566', 'reign', '83811843');
INSERT INTO `grid50000` VALUES ('3567', 'especially', '83811843');
INSERT INTO `grid50000` VALUES ('3568', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('3569', 'Prague', '83811843');
INSERT INTO `grid50000` VALUES ('3570', 'It', '83811843');
INSERT INTO `grid50000` VALUES ('3571', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('3572', 'at', '83811843');
INSERT INTO `grid50000` VALUES ('3573', 'his', '83811843');
INSERT INTO `grid50000` VALUES ('3574', 'behest', '83811843');
INSERT INTO `grid50000` VALUES ('3575', 'that', '83811843');
INSERT INTO `grid50000` VALUES ('3576', 'Charles', '83811843');
INSERT INTO `grid50000` VALUES ('3577', 'Bridge', '83811843');
INSERT INTO `grid50000` VALUES ('3578', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('3579', 'St', '83811843');
INSERT INTO `grid50000` VALUES ('3580', 'Vitus', '83811843');
INSERT INTO `grid50000` VALUES ('3581', 'Cathedral', '83811843');
INSERT INTO `grid50000` VALUES ('3582', 'were', '83811843');
INSERT INTO `grid50000` VALUES ('3583', 'built', '83811843');
INSERT INTO `grid50000` VALUES ('3584', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('3585', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('3586', 'Hunger', '83811843');
INSERT INTO `grid50000` VALUES ('3587', 'Wall', '83811843');
INSERT INTO `grid50000` VALUES ('3588', 'that', '83811843');
INSERT INTO `grid50000` VALUES ('3589', 'he', '83811843');
INSERT INTO `grid50000` VALUES ('3590', 'commissioned', '83811843');
INSERT INTO `grid50000` VALUES ('3591', 'remnants', '83811843');
INSERT INTO `grid50000` VALUES ('3592', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('3593', 'which', '83811843');
INSERT INTO `grid50000` VALUES ('3594', 'still', '83811843');
INSERT INTO `grid50000` VALUES ('3595', 'stand', '83811843');
INSERT INTO `grid50000` VALUES ('3596', 'today', '83811843');
INSERT INTO `grid50000` VALUES ('3597', 'on', '83811843');
INSERT INTO `grid50000` VALUES ('3598', 'Petrin', '83811843');
INSERT INTO `grid50000` VALUES ('3599', 'Hill', '83811843');
INSERT INTO `grid50000` VALUES ('3600', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('3601', 'Prague', '83811843');
INSERT INTO `grid50000` VALUES ('3602', 'is', '83811843');
INSERT INTO `grid50000` VALUES ('3603', 'thought', '83811843');
INSERT INTO `grid50000` VALUES ('3604', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('3605', 'be', '83811843');
INSERT INTO `grid50000` VALUES ('3606', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('3607', 'first', '83811843');
INSERT INTO `grid50000` VALUES ('3608', 'worksproject', '83811843');
INSERT INTO `grid50000` VALUES ('3609', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('3610', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('3611', 'world', '83811843');
INSERT INTO `grid50000` VALUES ('3612', 'as', '83811843');
INSERT INTO `grid50000` VALUES ('3613', 'he', '83811843');
INSERT INTO `grid50000` VALUES ('3614', 'had', '83811843');
INSERT INTO `grid50000` VALUES ('3615', 'it', '83811843');
INSERT INTO `grid50000` VALUES ('3616', 'built', '83811843');
INSERT INTO `grid50000` VALUES ('3617', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('3618', 'create', '83811843');
INSERT INTO `grid50000` VALUES ('3619', 'employment', '83811843');
INSERT INTO `grid50000` VALUES ('3620', 'for', '83811843');
INSERT INTO `grid50000` VALUES ('3621', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('3622', 'poor', '83811843');
INSERT INTO `grid50000` VALUES ('3623', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('3624', 'hungry', '83811843');
INSERT INTO `grid50000` VALUES ('3625', 'masses', '83811843');
INSERT INTO `grid50000` VALUES ('3626', 'hence', '83811843');
INSERT INTO `grid50000` VALUES ('3627', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('3628', 'name', '83811843');
INSERT INTO `grid50000` VALUES ('3629', '', '83811843');
INSERT INTO `grid50000` VALUES ('3630', 'Charles', '83811843');
INSERT INTO `grid50000` VALUES ('3631', 'IV', '83811843');
INSERT INTO `grid50000` VALUES ('3632', 'personally', '83811843');
INSERT INTO `grid50000` VALUES ('3633', 'planned', '83811843');
INSERT INTO `grid50000` VALUES ('3634', 'Pragues', '83811843');
INSERT INTO `grid50000` VALUES ('3635', 'New', '83811843');
INSERT INTO `grid50000` VALUES ('3636', 'Town', '83811843');
INSERT INTO `grid50000` VALUES ('3637', 'district', '83811843');
INSERT INTO `grid50000` VALUES ('3638', 'where', '83811843');
INSERT INTO `grid50000` VALUES ('3639', 'Charles', '83811843');
INSERT INTO `grid50000` VALUES ('3640', 'Square', '83811843');
INSERT INTO `grid50000` VALUES ('3641', '', '83811843');
INSERT INTO `grid50000` VALUES ('3642', 'which', '83811843');
INSERT INTO `grid50000` VALUES ('3643', 'is', '83811843');
INSERT INTO `grid50000` VALUES ('3644', 'also', '83811843');
INSERT INTO `grid50000` VALUES ('3645', 'named', '83811843');
INSERT INTO `grid50000` VALUES ('3646', 'for', '83811843');
INSERT INTO `grid50000` VALUES ('3647', 'him', '83811843');
INSERT INTO `grid50000` VALUES ('3648', '', '83811843');
INSERT INTO `grid50000` VALUES ('3649', 'lies', '83811843');
INSERT INTO `grid50000` VALUES ('3650', 'Karlstejn', '83811843');
INSERT INTO `grid50000` VALUES ('3651', 'Castle', '83811843');
INSERT INTO `grid50000` VALUES ('3652', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('3653', 'Karlovy', '83811843');
INSERT INTO `grid50000` VALUES ('3654', 'Vary', '83811843');
INSERT INTO `grid50000` VALUES ('3655', 'Carlsbad', '83811843');
INSERT INTO `grid50000` VALUES ('3656', 'are', '83811843');
INSERT INTO `grid50000` VALUES ('3657', 'also', '83811843');
INSERT INTO `grid50000` VALUES ('3658', 'named', '83811843');
INSERT INTO `grid50000` VALUES ('3659', 'for', '83811843');
INSERT INTO `grid50000` VALUES ('3660', 'Charles', '83811843');
INSERT INTO `grid50000` VALUES ('3661', 'IV', '83811843');
INSERT INTO `grid50000` VALUES ('3662', '\r\n\r\nMany', '83811843');
INSERT INTO `grid50000` VALUES ('3663', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('3664', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('3665', 'building', '83811843');
INSERT INTO `grid50000` VALUES ('3666', 'projects', '83811843');
INSERT INTO `grid50000` VALUES ('3667', 'initiated', '83811843');
INSERT INTO `grid50000` VALUES ('3668', 'by', '83811843');
INSERT INTO `grid50000` VALUES ('3669', 'Charles', '83811843');
INSERT INTO `grid50000` VALUES ('3670', 'IV', '83811843');
INSERT INTO `grid50000` VALUES ('3671', 'still', '83811843');
INSERT INTO `grid50000` VALUES ('3672', 'stand', '83811843');
INSERT INTO `grid50000` VALUES ('3673', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('3674', 'most', '83811843');
INSERT INTO `grid50000` VALUES ('3675', 'are', '83811843');
INSERT INTO `grid50000` VALUES ('3676', 'perfect', '83811843');
INSERT INTO `grid50000` VALUES ('3677', 'examples', '83811843');
INSERT INTO `grid50000` VALUES ('3678', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('3679', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('3680', 'Gothic', '83811843');
INSERT INTO `grid50000` VALUES ('3681', 'style', '83811843');
INSERT INTO `grid50000` VALUES ('3682', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('3683', 'architecture', '83811843');
INSERT INTO `grid50000` VALUES ('3684', 'which', '83811843');
INSERT INTO `grid50000` VALUES ('3685', 'is', '83811843');
INSERT INTO `grid50000` VALUES ('3686', 'characterized', '83811843');
INSERT INTO `grid50000` VALUES ('3687', 'by', '83811843');
INSERT INTO `grid50000` VALUES ('3688', 'clean', '83811843');
INSERT INTO `grid50000` VALUES ('3689', 'simple', '83811843');
INSERT INTO `grid50000` VALUES ('3690', 'lines', '83811843');
INSERT INTO `grid50000` VALUES ('3691', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('3692', 'solid', '83811843');
INSERT INTO `grid50000` VALUES ('3693', 'structure', '83811843');
INSERT INTO `grid50000` VALUES ('3694', '', '83811843');
INSERT INTO `grid50000` VALUES ('3695', 'like', '83811843');
INSERT INTO `grid50000` VALUES ('3696', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('3697', 'Charles', '83811843');
INSERT INTO `grid50000` VALUES ('3698', 'Bridge', '83811843');
INSERT INTO `grid50000` VALUES ('3699', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('3700', 'its', '83811843');
INSERT INTO `grid50000` VALUES ('3701', 'towers', '83811843');
INSERT INTO `grid50000` VALUES ('3702', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('3703', 'Carolinum', '83811843');
INSERT INTO `grid50000` VALUES ('3704', 'or', '83811843');
INSERT INTO `grid50000` VALUES ('3705', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('3706', 'OldNew', '83811843');
INSERT INTO `grid50000` VALUES ('3707', 'Synagogue', '83811843');
INSERT INTO `grid50000` VALUES ('3708', '\r\n\r\n', '83811843');
INSERT INTO `grid50000` VALUES ('3709', 'Charles', '83811843');
INSERT INTO `grid50000` VALUES ('3710', 'IV', '83811843');
INSERT INTO `grid50000` VALUES ('3711', 'also', '83811843');
INSERT INTO `grid50000` VALUES ('3712', 'founded', '83811843');
INSERT INTO `grid50000` VALUES ('3713', 'Charles', '83811843');
INSERT INTO `grid50000` VALUES ('3714', 'University', '83811843');
INSERT INTO `grid50000` VALUES ('3715', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('3716', 'first', '83811843');
INSERT INTO `grid50000` VALUES ('3717', 'center', '83811843');
INSERT INTO `grid50000` VALUES ('3718', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('3719', 'higher', '83811843');
INSERT INTO `grid50000` VALUES ('3720', 'education', '83811843');
INSERT INTO `grid50000` VALUES ('3721', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('3722', 'all', '83811843');
INSERT INTO `grid50000` VALUES ('3723', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('3724', 'Central', '83811843');
INSERT INTO `grid50000` VALUES ('3725', 'Europe', '83811843');
INSERT INTO `grid50000` VALUES ('3726', 'During', '83811843');
INSERT INTO `grid50000` VALUES ('3727', 'his', '83811843');
INSERT INTO `grid50000` VALUES ('3728', 'reign', '83811843');
INSERT INTO `grid50000` VALUES ('3729', 'Prague', '83811843');
INSERT INTO `grid50000` VALUES ('3730', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('3731', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('3732', 'capital', '83811843');
INSERT INTO `grid50000` VALUES ('3733', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('3734', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('3735', 'Holy', '83811843');
INSERT INTO `grid50000` VALUES ('3736', 'Roman', '83811843');
INSERT INTO `grid50000` VALUES ('3737', 'Empire', '83811843');
INSERT INTO `grid50000` VALUES ('3738', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('3739', 'gilded', '83811843');
INSERT INTO `grid50000` VALUES ('3740', 'sign', '83811843');
INSERT INTO `grid50000` VALUES ('3741', 'on', '83811843');
INSERT INTO `grid50000` VALUES ('3742', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('3743', 'Old', '83811843');
INSERT INTO `grid50000` VALUES ('3744', 'Town', '83811843');
INSERT INTO `grid50000` VALUES ('3745', 'Hall', '83811843');
INSERT INTO `grid50000` VALUES ('3746', 'still', '83811843');
INSERT INTO `grid50000` VALUES ('3747', 'proclaims', '83811843');
INSERT INTO `grid50000` VALUES ('3748', 'Praga', '83811843');
INSERT INTO `grid50000` VALUES ('3749', 'Caput', '83811843');
INSERT INTO `grid50000` VALUES ('3750', 'Regni', '83811843');
INSERT INTO `grid50000` VALUES ('3751', 'today', '83811843');
INSERT INTO `grid50000` VALUES ('3752', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('3753', 'he', '83811843');
INSERT INTO `grid50000` VALUES ('3754', 'successfully', '83811843');
INSERT INTO `grid50000` VALUES ('3755', 'lobbied', '83811843');
INSERT INTO `grid50000` VALUES ('3756', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('3757', 'have', '83811843');
INSERT INTO `grid50000` VALUES ('3758', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('3759', 'Prague', '83811843');
INSERT INTO `grid50000` VALUES ('3760', 'bishopric', '83811843');
INSERT INTO `grid50000` VALUES ('3761', 'made', '83811843');
INSERT INTO `grid50000` VALUES ('3762', 'an', '83811843');
INSERT INTO `grid50000` VALUES ('3763', 'archbishopric', '83811843');
INSERT INTO `grid50000` VALUES ('3764', 'this', '83811843');
INSERT INTO `grid50000` VALUES ('3765', 'task', '83811843');
INSERT INTO `grid50000` VALUES ('3766', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('3767', 'actually', '83811843');
INSERT INTO `grid50000` VALUES ('3768', 'quite', '83811843');
INSERT INTO `grid50000` VALUES ('3769', 'easy', '83811843');
INSERT INTO `grid50000` VALUES ('3770', 'as', '83811843');
INSERT INTO `grid50000` VALUES ('3771', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('3772', 'privelege', '83811843');
INSERT INTO `grid50000` VALUES ('3773', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('3774', 'granted', '83811843');
INSERT INTO `grid50000` VALUES ('3775', 'him', '83811843');
INSERT INTO `grid50000` VALUES ('3776', 'by', '83811843');
INSERT INTO `grid50000` VALUES ('3777', 'his', '83811843');
INSERT INTO `grid50000` VALUES ('3778', 'former', '83811843');
INSERT INTO `grid50000` VALUES ('3779', 'tutor', '83811843');
INSERT INTO `grid50000` VALUES ('3780', 'now', '83811843');
INSERT INTO `grid50000` VALUES ('3781', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('3782', 'Pope', '83811843');
INSERT INTO `grid50000` VALUES ('3783', '\r\n\r\nIt', '83811843');
INSERT INTO `grid50000` VALUES ('3784', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('3785', 'Charles', '83811843');
INSERT INTO `grid50000` VALUES ('3786', 'IV', '83811843');
INSERT INTO `grid50000` VALUES ('3787', 'too', '83811843');
INSERT INTO `grid50000` VALUES ('3788', 'who', '83811843');
INSERT INTO `grid50000` VALUES ('3789', 'brought', '83811843');
INSERT INTO `grid50000` VALUES ('3790', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('3791', 'cultivation', '83811843');
INSERT INTO `grid50000` VALUES ('3792', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('3793', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('3794', 'grape', '83811843');
INSERT INTO `grid50000` VALUES ('3795', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('3796', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('3797', 'wine', '83811843');
INSERT INTO `grid50000` VALUES ('3798', 'industry', '83811843');
INSERT INTO `grid50000` VALUES ('3799', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('3800', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('3801', 'beerdrinking', '83811843');
INSERT INTO `grid50000` VALUES ('3802', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('3803', 'lands', '83811843');
INSERT INTO `grid50000` VALUES ('3804', 'That', '83811843');
INSERT INTO `grid50000` VALUES ('3805', 'isnt', '83811843');
INSERT INTO `grid50000` VALUES ('3806', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('3807', 'say', '83811843');
INSERT INTO `grid50000` VALUES ('3808', 'that', '83811843');
INSERT INTO `grid50000` VALUES ('3809', 'he', '83811843');
INSERT INTO `grid50000` VALUES ('3810', 'neglected', '83811843');
INSERT INTO `grid50000` VALUES ('3811', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('3812', 'beer', '83811843');
INSERT INTO `grid50000` VALUES ('3813', 'industry', '83811843');
INSERT INTO `grid50000` VALUES ('3814', '', '83811843');
INSERT INTO `grid50000` VALUES ('3815', 'under', '83811843');
INSERT INTO `grid50000` VALUES ('3816', 'his', '83811843');
INSERT INTO `grid50000` VALUES ('3817', 'reign', '83811843');
INSERT INTO `grid50000` VALUES ('3818', 'stiff', '83811843');
INSERT INTO `grid50000` VALUES ('3819', 'prison', '83811843');
INSERT INTO `grid50000` VALUES ('3820', 'sentences', '83811843');
INSERT INTO `grid50000` VALUES ('3821', 'were', '83811843');
INSERT INTO `grid50000` VALUES ('3822', 'meted', '83811843');
INSERT INTO `grid50000` VALUES ('3823', 'out', '83811843');
INSERT INTO `grid50000` VALUES ('3824', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('3825', 'those', '83811843');
INSERT INTO `grid50000` VALUES ('3826', 'caught', '83811843');
INSERT INTO `grid50000` VALUES ('3827', 'exporting', '83811843');
INSERT INTO `grid50000` VALUES ('3828', 'cuttings', '83811843');
INSERT INTO `grid50000` VALUES ('3829', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('3830', 'prize', '83811843');
INSERT INTO `grid50000` VALUES ('3831', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('3832', 'hops', '83811843');
INSERT INTO `grid50000` VALUES ('3833', '', '83811843');
INSERT INTO `grid50000` VALUES ('3834', 'essential', '83811843');
INSERT INTO `grid50000` VALUES ('3835', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('3836', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('3837', 'brewing', '83811843');
INSERT INTO `grid50000` VALUES ('3838', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('3839', 'great', '83811843');
INSERT INTO `grid50000` VALUES ('3840', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('3841', 'beer', '83811843');
INSERT INTO `grid50000` VALUES ('3842', '', '83811843');
INSERT INTO `grid50000` VALUES ('3843', 'abroad', '83811843');
INSERT INTO `grid50000` VALUES ('3844', '\r\n\r\nCharles', '83811843');
INSERT INTO `grid50000` VALUES ('3845', 'IV', '83811843');
INSERT INTO `grid50000` VALUES ('3846', 'had', '83811843');
INSERT INTO `grid50000` VALUES ('3847', 'no', '83811843');
INSERT INTO `grid50000` VALUES ('3848', 'fewer', '83811843');
INSERT INTO `grid50000` VALUES ('3849', 'than', '83811843');
INSERT INTO `grid50000` VALUES ('3850', 'four', '83811843');
INSERT INTO `grid50000` VALUES ('3851', 'wives', '83811843');
INSERT INTO `grid50000` VALUES ('3852', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('3853', 'any', '83811843');
INSERT INTO `grid50000` VALUES ('3854', 'number', '83811843');
INSERT INTO `grid50000` VALUES ('3855', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('3856', 'progeny', '83811843');
INSERT INTO `grid50000` VALUES ('3857', 'both', '83811843');
INSERT INTO `grid50000` VALUES ('3858', 'legitimate', '83811843');
INSERT INTO `grid50000` VALUES ('3859', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('3860', 'il', '83811843');
INSERT INTO `grid50000` VALUES ('3861', 'Of', '83811843');
INSERT INTO `grid50000` VALUES ('3862', 'these', '83811843');
INSERT INTO `grid50000` VALUES ('3863', 'his', '83811843');
INSERT INTO `grid50000` VALUES ('3864', 'oldest', '83811843');
INSERT INTO `grid50000` VALUES ('3865', 'legitimate', '83811843');
INSERT INTO `grid50000` VALUES ('3866', 'son', '83811843');
INSERT INTO `grid50000` VALUES ('3867', 'Vaclav', '83811843');
INSERT INTO `grid50000` VALUES ('3868', 'IV', '83811843');
INSERT INTO `grid50000` VALUES ('3869', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('3870', 'naturally', '83811843');
INSERT INTO `grid50000` VALUES ('3871', 'chosen', '83811843');
INSERT INTO `grid50000` VALUES ('3872', 'as', '83811843');
INSERT INTO `grid50000` VALUES ('3873', 'his', '83811843');
INSERT INTO `grid50000` VALUES ('3874', 'successor', '83811843');
INSERT INTO `grid50000` VALUES ('3875', '\r\n\r\nWenceslas', '83811843');
INSERT INTO `grid50000` VALUES ('3876', 'IV', '83811843');
INSERT INTO `grid50000` VALUES ('3877', '13781419', '83811843');
INSERT INTO `grid50000` VALUES ('3878', 'son', '83811843');
INSERT INTO `grid50000` VALUES ('3879', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('3880', 'Charles', '83811843');
INSERT INTO `grid50000` VALUES ('3881', 'IV', '83811843');
INSERT INTO `grid50000` VALUES ('3882', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('3883', 'heir', '83811843');
INSERT INTO `grid50000` VALUES ('3884', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('3885', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('3886', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('3887', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('3888', 'Roman', '83811843');
INSERT INTO `grid50000` VALUES ('3889', 'crowns', '83811843');
INSERT INTO `grid50000` VALUES ('3890', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('3891', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('3892', 'weak', '83811843');
INSERT INTO `grid50000` VALUES ('3893', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('3894', 'ineffective', '83811843');
INSERT INTO `grid50000` VALUES ('3895', 'ruler', '83811843');
INSERT INTO `grid50000` VALUES ('3896', 'He', '83811843');
INSERT INTO `grid50000` VALUES ('3897', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('3898', 'also', '83811843');
INSERT INTO `grid50000` VALUES ('3899', 'mean', '83811843');
INSERT INTO `grid50000` VALUES ('3900', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('3901', 'drunk', '83811843');
INSERT INTO `grid50000` VALUES ('3902', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('3903', 'wildly', '83811843');
INSERT INTO `grid50000` VALUES ('3904', 'unpopular', '83811843');
INSERT INTO `grid50000` VALUES ('3905', 'He', '83811843');
INSERT INTO `grid50000` VALUES ('3906', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('3907', 'imprisoned', '83811843');
INSERT INTO `grid50000` VALUES ('3908', 'twice', '83811843');
INSERT INTO `grid50000` VALUES ('3909', 'during', '83811843');
INSERT INTO `grid50000` VALUES ('3910', 'his', '83811843');
INSERT INTO `grid50000` VALUES ('3911', 'reign', '83811843');
INSERT INTO `grid50000` VALUES ('3912', 'Had', '83811843');
INSERT INTO `grid50000` VALUES ('3913', 'times', '83811843');
INSERT INTO `grid50000` VALUES ('3914', 'been', '83811843');
INSERT INTO `grid50000` VALUES ('3915', 'different', '83811843');
INSERT INTO `grid50000` VALUES ('3916', 'this', '83811843');
INSERT INTO `grid50000` VALUES ('3917', 'may', '83811843');
INSERT INTO `grid50000` VALUES ('3918', 'not', '83811843');
INSERT INTO `grid50000` VALUES ('3919', 'have', '83811843');
INSERT INTO `grid50000` VALUES ('3920', 'mattered', '83811843');
INSERT INTO `grid50000` VALUES ('3921', 'much', '83811843');
INSERT INTO `grid50000` VALUES ('3922', 'As', '83811843');
INSERT INTO `grid50000` VALUES ('3923', 'luck', '83811843');
INSERT INTO `grid50000` VALUES ('3924', 'would', '83811843');
INSERT INTO `grid50000` VALUES ('3925', 'have', '83811843');
INSERT INTO `grid50000` VALUES ('3926', 'it', '83811843');
INSERT INTO `grid50000` VALUES ('3927', 'however', '83811843');
INSERT INTO `grid50000` VALUES ('3928', 'he', '83811843');
INSERT INTO `grid50000` VALUES ('3929', 'became', '83811843');
INSERT INTO `grid50000` VALUES ('3930', 'king', '83811843');
INSERT INTO `grid50000` VALUES ('3931', 'during', '83811843');
INSERT INTO `grid50000` VALUES ('3932', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('3933', 'particularly', '83811843');
INSERT INTO `grid50000` VALUES ('3934', 'turbulent', '83811843');
INSERT INTO `grid50000` VALUES ('3935', 'time', '83811843');
INSERT INTO `grid50000` VALUES ('3936', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('3937', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('3938', 'history', '83811843');
INSERT INTO `grid50000` VALUES ('3939', '\r\n\r\n', '83811843');
INSERT INTO `grid50000` VALUES ('3940', 'Unfortunately', '83811843');
INSERT INTO `grid50000` VALUES ('3941', 'Wenceslas', '83811843');
INSERT INTO `grid50000` VALUES ('3942', 'IV', '83811843');
INSERT INTO `grid50000` VALUES ('3943', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('3944', 'much', '83811843');
INSERT INTO `grid50000` VALUES ('3945', 'more', '83811843');
INSERT INTO `grid50000` VALUES ('3946', 'interested', '83811843');
INSERT INTO `grid50000` VALUES ('3947', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('3948', 'drinking', '83811843');
INSERT INTO `grid50000` VALUES ('3949', 'than', '83811843');
INSERT INTO `grid50000` VALUES ('3950', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('3951', 'ruling', '83811843');
INSERT INTO `grid50000` VALUES ('3952', 'He', '83811843');
INSERT INTO `grid50000` VALUES ('3953', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('3954', 'terribly', '83811843');
INSERT INTO `grid50000` VALUES ('3955', 'spoiled', '83811843');
INSERT INTO `grid50000` VALUES ('3956', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('3957', 'even', '83811843');
INSERT INTO `grid50000` VALUES ('3958', 'as', '83811843');
INSERT INTO `grid50000` VALUES ('3959', 'an', '83811843');
INSERT INTO `grid50000` VALUES ('3960', 'adult', '83811843');
INSERT INTO `grid50000` VALUES ('3961', 'he', '83811843');
INSERT INTO `grid50000` VALUES ('3962', 'would', '83811843');
INSERT INTO `grid50000` VALUES ('3963', 'throw', '83811843');
INSERT INTO `grid50000` VALUES ('3964', 'fits', '83811843');
INSERT INTO `grid50000` VALUES ('3965', 'when', '83811843');
INSERT INTO `grid50000` VALUES ('3966', 'people', '83811843');
INSERT INTO `grid50000` VALUES ('3967', 'didnt', '83811843');
INSERT INTO `grid50000` VALUES ('3968', 'do', '83811843');
INSERT INTO `grid50000` VALUES ('3969', 'exactly', '83811843');
INSERT INTO `grid50000` VALUES ('3970', 'as', '83811843');
INSERT INTO `grid50000` VALUES ('3971', 'he', '83811843');
INSERT INTO `grid50000` VALUES ('3972', 'wished', '83811843');
INSERT INTO `grid50000` VALUES ('3973', 'them', '83811843');
INSERT INTO `grid50000` VALUES ('3974', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('3975', 'He', '83811843');
INSERT INTO `grid50000` VALUES ('3976', 'is', '83811843');
INSERT INTO `grid50000` VALUES ('3977', 'remembered', '83811843');
INSERT INTO `grid50000` VALUES ('3978', 'by', '83811843');
INSERT INTO `grid50000` VALUES ('3979', 'history', '83811843');
INSERT INTO `grid50000` VALUES ('3980', 'today', '83811843');
INSERT INTO `grid50000` VALUES ('3981', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('3982', 'two', '83811843');
INSERT INTO `grid50000` VALUES ('3983', 'ways:', '83811843');
INSERT INTO `grid50000` VALUES ('3984', 'sometimes', '83811843');
INSERT INTO `grid50000` VALUES ('3985', 'as', '83811843');
INSERT INTO `grid50000` VALUES ('3986', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('3987', 'wishy', '83811843');
INSERT INTO `grid50000` VALUES ('3988', 'washy', '83811843');
INSERT INTO `grid50000` VALUES ('3989', 'goodfornothing', '83811843');
INSERT INTO `grid50000` VALUES ('3990', 'drunkard', '83811843');
INSERT INTO `grid50000` VALUES ('3991', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('3992', 'sometimes', '83811843');
INSERT INTO `grid50000` VALUES ('3993', 'as', '83811843');
INSERT INTO `grid50000` VALUES ('3994', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('3995', 'benefactor', '83811843');
INSERT INTO `grid50000` VALUES ('3996', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('3997', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('3998', 'common', '83811843');
INSERT INTO `grid50000` VALUES ('3999', 'man', '83811843');
INSERT INTO `grid50000` VALUES ('4000', 'The', '83811843');
INSERT INTO `grid50000` VALUES ('4001', 'way', '83811843');
INSERT INTO `grid50000` VALUES ('4002', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('4003', 'which', '83811843');
INSERT INTO `grid50000` VALUES ('4004', 'this', '83811843');
INSERT INTO `grid50000` VALUES ('4005', 'latter', '83811843');
INSERT INTO `grid50000` VALUES ('4006', 'reputation', '83811843');
INSERT INTO `grid50000` VALUES ('4007', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('4008', 'earned', '83811843');
INSERT INTO `grid50000` VALUES ('4009', 'is', '83811843');
INSERT INTO `grid50000` VALUES ('4010', 'usually', '83811843');
INSERT INTO `grid50000` VALUES ('4011', 'explained', '83811843');
INSERT INTO `grid50000` VALUES ('4012', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('4013', 'this', '83811843');
INSERT INTO `grid50000` VALUES ('4014', 'way:', '83811843');
INSERT INTO `grid50000` VALUES ('4015', 'Wenceslas', '83811843');
INSERT INTO `grid50000` VALUES ('4016', 'IV', '83811843');
INSERT INTO `grid50000` VALUES ('4017', 'used', '83811843');
INSERT INTO `grid50000` VALUES ('4018', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('4019', 'go', '83811843');
INSERT INTO `grid50000` VALUES ('4020', 'around', '83811843');
INSERT INTO `grid50000` VALUES ('4021', 'Prague', '83811843');
INSERT INTO `grid50000` VALUES ('4022', 'dressed', '83811843');
INSERT INTO `grid50000` VALUES ('4023', 'as', '83811843');
INSERT INTO `grid50000` VALUES ('4024', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('4025', 'commoner', '83811843');
INSERT INTO `grid50000` VALUES ('4026', 'He', '83811843');
INSERT INTO `grid50000` VALUES ('4027', 'would', '83811843');
INSERT INTO `grid50000` VALUES ('4028', 'go', '83811843');
INSERT INTO `grid50000` VALUES ('4029', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('4030', 'pubs', '83811843');
INSERT INTO `grid50000` VALUES ('4031', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('4032', 'shops', '83811843');
INSERT INTO `grid50000` VALUES ('4033', 'this', '83811843');
INSERT INTO `grid50000` VALUES ('4034', 'way', '83811843');
INSERT INTO `grid50000` VALUES ('4035', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('4036', 'whenever', '83811843');
INSERT INTO `grid50000` VALUES ('4037', 'he', '83811843');
INSERT INTO `grid50000` VALUES ('4038', 'found', '83811843');
INSERT INTO `grid50000` VALUES ('4039', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('4040', 'merchant', '83811843');
INSERT INTO `grid50000` VALUES ('4041', 'giving', '83811843');
INSERT INTO `grid50000` VALUES ('4042', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4043', 'public', '83811843');
INSERT INTO `grid50000` VALUES ('4044', 'short', '83811843');
INSERT INTO `grid50000` VALUES ('4045', 'measures', '83811843');
INSERT INTO `grid50000` VALUES ('4046', 'he', '83811843');
INSERT INTO `grid50000` VALUES ('4047', 'would', '83811843');
INSERT INTO `grid50000` VALUES ('4048', 'punish', '83811843');
INSERT INTO `grid50000` VALUES ('4049', 'them', '83811843');
INSERT INTO `grid50000` VALUES ('4050', 'by', '83811843');
INSERT INTO `grid50000` VALUES ('4051', 'having', '83811843');
INSERT INTO `grid50000` VALUES ('4052', 'them', '83811843');
INSERT INTO `grid50000` VALUES ('4053', 'thrown', '83811843');
INSERT INTO `grid50000` VALUES ('4054', 'off', '83811843');
INSERT INTO `grid50000` VALUES ('4055', 'Charles', '83811843');
INSERT INTO `grid50000` VALUES ('4056', 'Bridge', '83811843');
INSERT INTO `grid50000` VALUES ('4057', 'into', '83811843');
INSERT INTO `grid50000` VALUES ('4058', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4059', 'river', '83811843');
INSERT INTO `grid50000` VALUES ('4060', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('4061', 'drown', '83811843');
INSERT INTO `grid50000` VALUES ('4062', 'If', '83811843');
INSERT INTO `grid50000` VALUES ('4063', 'this', '83811843');
INSERT INTO `grid50000` VALUES ('4064', 'legend', '83811843');
INSERT INTO `grid50000` VALUES ('4065', 'is', '83811843');
INSERT INTO `grid50000` VALUES ('4066', 'based', '83811843');
INSERT INTO `grid50000` VALUES ('4067', 'on', '83811843');
INSERT INTO `grid50000` VALUES ('4068', 'fact', '83811843');
INSERT INTO `grid50000` VALUES ('4069', 'then', '83811843');
INSERT INTO `grid50000` VALUES ('4070', 'it', '83811843');
INSERT INTO `grid50000` VALUES ('4071', 'is', '83811843');
INSERT INTO `grid50000` VALUES ('4072', 'probably', '83811843');
INSERT INTO `grid50000` VALUES ('4073', 'likely', '83811843');
INSERT INTO `grid50000` VALUES ('4074', 'that', '83811843');
INSERT INTO `grid50000` VALUES ('4075', 'Wenceslas', '83811843');
INSERT INTO `grid50000` VALUES ('4076', 'IV', '83811843');
INSERT INTO `grid50000` VALUES ('4077', 'pursued', '83811843');
INSERT INTO `grid50000` VALUES ('4078', 'this', '83811843');
INSERT INTO `grid50000` VALUES ('4079', 'hobby', '83811843');
INSERT INTO `grid50000` VALUES ('4080', 'not', '83811843');
INSERT INTO `grid50000` VALUES ('4081', 'so', '83811843');
INSERT INTO `grid50000` VALUES ('4082', 'much', '83811843');
INSERT INTO `grid50000` VALUES ('4083', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('4084', 'help', '83811843');
INSERT INTO `grid50000` VALUES ('4085', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4086', 'common', '83811843');
INSERT INTO `grid50000` VALUES ('4087', 'man', '83811843');
INSERT INTO `grid50000` VALUES ('4088', 'but', '83811843');
INSERT INTO `grid50000` VALUES ('4089', 'rather', '83811843');
INSERT INTO `grid50000` VALUES ('4090', 'from', '83811843');
INSERT INTO `grid50000` VALUES ('4091', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4092', 'pleasure', '83811843');
INSERT INTO `grid50000` VALUES ('4093', 'he', '83811843');
INSERT INTO `grid50000` VALUES ('4094', 'derived', '83811843');
INSERT INTO `grid50000` VALUES ('4095', 'from', '83811843');
INSERT INTO `grid50000` VALUES ('4096', 'having', '83811843');
INSERT INTO `grid50000` VALUES ('4097', 'people', '83811843');
INSERT INTO `grid50000` VALUES ('4098', 'thrown', '83811843');
INSERT INTO `grid50000` VALUES ('4099', 'into', '83811843');
INSERT INTO `grid50000` VALUES ('4100', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4101', 'river', '83811843');
INSERT INTO `grid50000` VALUES ('4102', '\r\n\r\n', '83811843');
INSERT INTO `grid50000` VALUES ('4103', '\r\n\r\nProbably', '83811843');
INSERT INTO `grid50000` VALUES ('4104', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4105', 'most', '83811843');
INSERT INTO `grid50000` VALUES ('4106', 'famous', '83811843');
INSERT INTO `grid50000` VALUES ('4107', 'person', '83811843');
INSERT INTO `grid50000` VALUES ('4108', 'Wenceslas', '83811843');
INSERT INTO `grid50000` VALUES ('4109', 'IV', '83811843');
INSERT INTO `grid50000` VALUES ('4110', 'had', '83811843');
INSERT INTO `grid50000` VALUES ('4111', 'thrown', '83811843');
INSERT INTO `grid50000` VALUES ('4112', 'into', '83811843');
INSERT INTO `grid50000` VALUES ('4113', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4114', 'river', '83811843');
INSERT INTO `grid50000` VALUES ('4115', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('4116', 'an', '83811843');
INSERT INTO `grid50000` VALUES ('4117', 'insignificant', '83811843');
INSERT INTO `grid50000` VALUES ('4118', 'court', '83811843');
INSERT INTO `grid50000` VALUES ('4119', 'clerk', '83811843');
INSERT INTO `grid50000` VALUES ('4120', 'by', '83811843');
INSERT INTO `grid50000` VALUES ('4121', 'name', '83811843');
INSERT INTO `grid50000` VALUES ('4122', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('4123', 'John', '83811843');
INSERT INTO `grid50000` VALUES ('4124', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('4125', 'Pomuk', '83811843');
INSERT INTO `grid50000` VALUES ('4126', 'During', '83811843');
INSERT INTO `grid50000` VALUES ('4127', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4128', 'CounterReformation', '83811843');
INSERT INTO `grid50000` VALUES ('4129', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4130', 'Catholic', '83811843');
INSERT INTO `grid50000` VALUES ('4131', 'Church', '83811843');
INSERT INTO `grid50000` VALUES ('4132', 'recovered', '83811843');
INSERT INTO `grid50000` VALUES ('4133', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4134', 'story', '83811843');
INSERT INTO `grid50000` VALUES ('4135', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('4136', 'John', '83811843');
INSERT INTO `grid50000` VALUES ('4137', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('4138', 'Pomuks', '83811843');
INSERT INTO `grid50000` VALUES ('4139', 'death', '83811843');
INSERT INTO `grid50000` VALUES ('4140', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('4141', 'entirely', '83811843');
INSERT INTO `grid50000` VALUES ('4142', 'overhauled', '83811843');
INSERT INTO `grid50000` VALUES ('4143', 'it', '83811843');
INSERT INTO `grid50000` VALUES ('4144', '', '83811843');
INSERT INTO `grid50000` VALUES ('4145', 'making', '83811843');
INSERT INTO `grid50000` VALUES ('4146', 'Johns', '83811843');
INSERT INTO `grid50000` VALUES ('4147', 'name', '83811843');
INSERT INTO `grid50000` VALUES ('4148', 'John', '83811843');
INSERT INTO `grid50000` VALUES ('4149', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('4150', 'Nepomuk', '83811843');
INSERT INTO `grid50000` VALUES ('4151', 'making', '83811843');
INSERT INTO `grid50000` VALUES ('4152', 'his', '83811843');
INSERT INTO `grid50000` VALUES ('4153', 'job', '83811843');
INSERT INTO `grid50000` VALUES ('4154', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4155', 'confessor', '83811843');
INSERT INTO `grid50000` VALUES ('4156', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('4157', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4158', 'Queen', '83811843');
INSERT INTO `grid50000` VALUES ('4159', 'instead', '83811843');
INSERT INTO `grid50000` VALUES ('4160', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('4161', 'an', '83811843');
INSERT INTO `grid50000` VALUES ('4162', 'office', '83811843');
INSERT INTO `grid50000` VALUES ('4163', 'clerk', '83811843');
INSERT INTO `grid50000` VALUES ('4164', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('4165', 'making', '83811843');
INSERT INTO `grid50000` VALUES ('4166', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4167', 'reason', '83811843');
INSERT INTO `grid50000` VALUES ('4168', 'for', '83811843');
INSERT INTO `grid50000` VALUES ('4169', 'his', '83811843');
INSERT INTO `grid50000` VALUES ('4170', 'execution', '83811843');
INSERT INTO `grid50000` VALUES ('4171', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4172', 'fact', '83811843');
INSERT INTO `grid50000` VALUES ('4173', 'that', '83811843');
INSERT INTO `grid50000` VALUES ('4174', 'John', '83811843');
INSERT INTO `grid50000` VALUES ('4175', 'refused', '83811843');
INSERT INTO `grid50000` VALUES ('4176', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('4177', 'divulge', '83811843');
INSERT INTO `grid50000` VALUES ('4178', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4179', 'Queens', '83811843');
INSERT INTO `grid50000` VALUES ('4180', 'secrets', '83811843');
INSERT INTO `grid50000` VALUES ('4181', '', '83811843');
INSERT INTO `grid50000` VALUES ('4182', 'told', '83811843');
INSERT INTO `grid50000` VALUES ('4183', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('4184', 'Confession', '83811843');
INSERT INTO `grid50000` VALUES ('4185', '', '83811843');
INSERT INTO `grid50000` VALUES ('4186', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('4187', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4188', 'king', '83811843');
INSERT INTO `grid50000` VALUES ('4189', 'John', '83811843');
INSERT INTO `grid50000` VALUES ('4190', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('4191', 'Nepumuk', '83811843');
INSERT INTO `grid50000` VALUES ('4192', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('4193', 'eventually', '83811843');
INSERT INTO `grid50000` VALUES ('4194', 'made', '83811843');
INSERT INTO `grid50000` VALUES ('4195', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('4196', 'saint', '83811843');
INSERT INTO `grid50000` VALUES ('4197', 'on', '83811843');
INSERT INTO `grid50000` VALUES ('4198', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4199', 'basis', '83811843');
INSERT INTO `grid50000` VALUES ('4200', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('4201', 'this', '83811843');
INSERT INTO `grid50000` VALUES ('4202', 'story', '83811843');
INSERT INTO `grid50000` VALUES ('4203', 'but', '83811843');
INSERT INTO `grid50000` VALUES ('4204', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4205', 'Vatican', '83811843');
INSERT INTO `grid50000` VALUES ('4206', 'rescinded', '83811843');
INSERT INTO `grid50000` VALUES ('4207', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4208', 'decision', '83811843');
INSERT INTO `grid50000` VALUES ('4209', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('4210', '1961', '83811843');
INSERT INTO `grid50000` VALUES ('4211', 'explaining', '83811843');
INSERT INTO `grid50000` VALUES ('4212', 'that', '83811843');
INSERT INTO `grid50000` VALUES ('4213', 'testimony', '83811843');
INSERT INTO `grid50000` VALUES ('4214', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('4215', 'his', '83811843');
INSERT INTO `grid50000` VALUES ('4216', 'miracles', '83811843');
INSERT INTO `grid50000` VALUES ('4217', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('4218', 'other', '83811843');
INSERT INTO `grid50000` VALUES ('4219', 'evidence', '83811843');
INSERT INTO `grid50000` VALUES ('4220', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('4221', 'his', '83811843');
INSERT INTO `grid50000` VALUES ('4222', 'deeds', '83811843');
INSERT INTO `grid50000` VALUES ('4223', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('4224', 'fishy', '83811843');
INSERT INTO `grid50000` VALUES ('4225', '', '83811843');
INSERT INTO `grid50000` VALUES ('4226', '\r\n\r\nIts', '83811843');
INSERT INTO `grid50000` VALUES ('4227', 'hard', '83811843');
INSERT INTO `grid50000` VALUES ('4228', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('4229', 'say', '83811843');
INSERT INTO `grid50000` VALUES ('4230', 'what', '83811843');
INSERT INTO `grid50000` VALUES ('4231', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4232', 'common', '83811843');
INSERT INTO `grid50000` VALUES ('4233', 'people', '83811843');
INSERT INTO `grid50000` VALUES ('4234', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('4235', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4236', 'time', '83811843');
INSERT INTO `grid50000` VALUES ('4237', 'really', '83811843');
INSERT INTO `grid50000` VALUES ('4238', 'thought', '83811843');
INSERT INTO `grid50000` VALUES ('4239', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('4240', 'Wenceslas', '83811843');
INSERT INTO `grid50000` VALUES ('4241', 'IV', '83811843');
INSERT INTO `grid50000` VALUES ('4242', 'as', '83811843');
INSERT INTO `grid50000` VALUES ('4243', 'common', '83811843');
INSERT INTO `grid50000` VALUES ('4244', 'people', '83811843');
INSERT INTO `grid50000` VALUES ('4245', 'dont', '83811843');
INSERT INTO `grid50000` VALUES ('4246', 'usually', '83811843');
INSERT INTO `grid50000` VALUES ('4247', 'have', '83811843');
INSERT INTO `grid50000` VALUES ('4248', 'much', '83811843');
INSERT INTO `grid50000` VALUES ('4249', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('4250', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('4251', 'say', '83811843');
INSERT INTO `grid50000` VALUES ('4252', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('4253', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4254', 'writing', '83811843');
INSERT INTO `grid50000` VALUES ('4255', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('4256', 'history', '83811843');
INSERT INTO `grid50000` VALUES ('4257', 'It', '83811843');
INSERT INTO `grid50000` VALUES ('4258', 'is', '83811843');
INSERT INTO `grid50000` VALUES ('4259', 'known', '83811843');
INSERT INTO `grid50000` VALUES ('4260', 'that', '83811843');
INSERT INTO `grid50000` VALUES ('4261', 'he', '83811843');
INSERT INTO `grid50000` VALUES ('4262', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('4263', 'wildly', '83811843');
INSERT INTO `grid50000` VALUES ('4264', 'unpopular', '83811843');
INSERT INTO `grid50000` VALUES ('4265', 'with', '83811843');
INSERT INTO `grid50000` VALUES ('4266', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4267', 'nobility', '83811843');
INSERT INTO `grid50000` VALUES ('4268', 'who', '83811843');
INSERT INTO `grid50000` VALUES ('4269', 'had', '83811843');
INSERT INTO `grid50000` VALUES ('4270', 'him', '83811843');
INSERT INTO `grid50000` VALUES ('4271', 'imprisoned', '83811843');
INSERT INTO `grid50000` VALUES ('4272', 'not', '83811843');
INSERT INTO `grid50000` VALUES ('4273', 'once', '83811843');
INSERT INTO `grid50000` VALUES ('4274', 'but', '83811843');
INSERT INTO `grid50000` VALUES ('4275', 'several', '83811843');
INSERT INTO `grid50000` VALUES ('4276', 'times', '83811843');
INSERT INTO `grid50000` VALUES ('4277', 'during', '83811843');
INSERT INTO `grid50000` VALUES ('4278', 'his', '83811843');
INSERT INTO `grid50000` VALUES ('4279', 'reign', '83811843');
INSERT INTO `grid50000` VALUES ('4280', '\r\n\r\nHe', '83811843');
INSERT INTO `grid50000` VALUES ('4281', 'wasnt', '83811843');
INSERT INTO `grid50000` VALUES ('4282', 'exactly', '83811843');
INSERT INTO `grid50000` VALUES ('4283', 'revered', '83811843');
INSERT INTO `grid50000` VALUES ('4284', 'by', '83811843');
INSERT INTO `grid50000` VALUES ('4285', 'his', '83811843');
INSERT INTO `grid50000` VALUES ('4286', 'brother', '83811843');
INSERT INTO `grid50000` VALUES ('4287', 'Sigismund', '83811843');
INSERT INTO `grid50000` VALUES ('4288', 'either', '83811843');
INSERT INTO `grid50000` VALUES ('4289', 'Even', '83811843');
INSERT INTO `grid50000` VALUES ('4290', 'as', '83811843');
INSERT INTO `grid50000` VALUES ('4291', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4292', 'careless', '83811843');
INSERT INTO `grid50000` VALUES ('4293', 'blood', '83811843');
INSERT INTO `grid50000` VALUES ('4294', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('4295', 'his', '83811843');
INSERT INTO `grid50000` VALUES ('4296', 'grandfather', '83811843');
INSERT INTO `grid50000` VALUES ('4297', 'John', '83811843');
INSERT INTO `grid50000` VALUES ('4298', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('4299', 'Luxembourg', '83811843');
INSERT INTO `grid50000` VALUES ('4300', 'coursed', '83811843');
INSERT INTO `grid50000` VALUES ('4301', 'through', '83811843');
INSERT INTO `grid50000` VALUES ('4302', 'Vaclav', '83811843');
INSERT INTO `grid50000` VALUES ('4303', 'IVs', '83811843');
INSERT INTO `grid50000` VALUES ('4304', 'veins', '83811843');
INSERT INTO `grid50000` VALUES ('4305', '', '83811843');
INSERT INTO `grid50000` VALUES ('4306', 'so', '83811843');
INSERT INTO `grid50000` VALUES ('4307', 'did', '83811843');
INSERT INTO `grid50000` VALUES ('4308', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4309', 'powerhungry', '83811843');
INSERT INTO `grid50000` VALUES ('4310', 'blood', '83811843');
INSERT INTO `grid50000` VALUES ('4311', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('4312', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4313', 'early', '83811843');
INSERT INTO `grid50000` VALUES ('4314', 'Przemyslide', '83811843');
INSERT INTO `grid50000` VALUES ('4315', 'rulers', '83811843');
INSERT INTO `grid50000` VALUES ('4316', 'flow', '83811843');
INSERT INTO `grid50000` VALUES ('4317', 'freely', '83811843');
INSERT INTO `grid50000` VALUES ('4318', 'through', '83811843');
INSERT INTO `grid50000` VALUES ('4319', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4320', 'arteries', '83811843');
INSERT INTO `grid50000` VALUES ('4321', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('4322', 'Sigismund', '83811843');
INSERT INTO `grid50000` VALUES ('4323', 'In', '83811843');
INSERT INTO `grid50000` VALUES ('4324', 'short', '83811843');
INSERT INTO `grid50000` VALUES ('4325', 'he', '83811843');
INSERT INTO `grid50000` VALUES ('4326', 'wanted', '83811843');
INSERT INTO `grid50000` VALUES ('4327', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('4328', 'be', '83811843');
INSERT INTO `grid50000` VALUES ('4329', 'king', '83811843');
INSERT INTO `grid50000` VALUES ('4330', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('4331', 'it', '83811843');
INSERT INTO `grid50000` VALUES ('4332', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('4333', 'he', '83811843');
INSERT INTO `grid50000` VALUES ('4334', 'who', '83811843');
INSERT INTO `grid50000` VALUES ('4335', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('4336', 'behind', '83811843');
INSERT INTO `grid50000` VALUES ('4337', 'at', '83811843');
INSERT INTO `grid50000` VALUES ('4338', 'least', '83811843');
INSERT INTO `grid50000` VALUES ('4339', 'one', '83811843');
INSERT INTO `grid50000` VALUES ('4340', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('4341', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4342', 'conspiracies', '83811843');
INSERT INTO `grid50000` VALUES ('4343', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('4344', 'imprison', '83811843');
INSERT INTO `grid50000` VALUES ('4345', 'King', '83811843');
INSERT INTO `grid50000` VALUES ('4346', 'Vaclav', '83811843');
INSERT INTO `grid50000` VALUES ('4347', 'IV', '83811843');
INSERT INTO `grid50000` VALUES ('4348', '', '83811843');
INSERT INTO `grid50000` VALUES ('4349', '\r\n\r\nWhile', '83811843');
INSERT INTO `grid50000` VALUES ('4350', 'this', '83811843');
INSERT INTO `grid50000` VALUES ('4351', 'court', '83811843');
INSERT INTO `grid50000` VALUES ('4352', 'intrigue', '83811843');
INSERT INTO `grid50000` VALUES ('4353', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('4354', 'going', '83811843');
INSERT INTO `grid50000` VALUES ('4355', 'on', '83811843');
INSERT INTO `grid50000` VALUES ('4356', 'things', '83811843');
INSERT INTO `grid50000` VALUES ('4357', 'couldnt', '83811843');
INSERT INTO `grid50000` VALUES ('4358', 'really', '83811843');
INSERT INTO `grid50000` VALUES ('4359', 'have', '83811843');
INSERT INTO `grid50000` VALUES ('4360', 'been', '83811843');
INSERT INTO `grid50000` VALUES ('4361', 'all', '83811843');
INSERT INTO `grid50000` VALUES ('4362', 'that', '83811843');
INSERT INTO `grid50000` VALUES ('4363', 'good', '83811843');
INSERT INTO `grid50000` VALUES ('4364', 'for', '83811843');
INSERT INTO `grid50000` VALUES ('4365', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4366', 'common', '83811843');
INSERT INTO `grid50000` VALUES ('4367', 'man', '83811843');
INSERT INTO `grid50000` VALUES ('4368', 'else', '83811843');
INSERT INTO `grid50000` VALUES ('4369', 'hed', '83811843');
INSERT INTO `grid50000` VALUES ('4370', 'not', '83811843');
INSERT INTO `grid50000` VALUES ('4371', 'have', '83811843');
INSERT INTO `grid50000` VALUES ('4372', 'been', '83811843');
INSERT INTO `grid50000` VALUES ('4373', 'spending', '83811843');
INSERT INTO `grid50000` VALUES ('4374', 'much', '83811843');
INSERT INTO `grid50000` VALUES ('4375', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('4376', 'his', '83811843');
INSERT INTO `grid50000` VALUES ('4377', 'leisure', '83811843');
INSERT INTO `grid50000` VALUES ('4378', 'time', '83811843');
INSERT INTO `grid50000` VALUES ('4379', 'listening', '83811843');
INSERT INTO `grid50000` VALUES ('4380', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('4381', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4382', 'rabblerousing', '83811843');
INSERT INTO `grid50000` VALUES ('4383', 'preachers', '83811843');
INSERT INTO `grid50000` VALUES ('4384', 'who', '83811843');
INSERT INTO `grid50000` VALUES ('4385', 'started', '83811843');
INSERT INTO `grid50000` VALUES ('4386', 'travelling', '83811843');
INSERT INTO `grid50000` VALUES ('4387', 'around', '83811843');
INSERT INTO `grid50000` VALUES ('4388', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4389', 'country', '83811843');
INSERT INTO `grid50000` VALUES ('4390', 'at', '83811843');
INSERT INTO `grid50000` VALUES ('4391', 'this', '83811843');
INSERT INTO `grid50000` VALUES ('4392', 'time', '83811843');
INSERT INTO `grid50000` VALUES ('4393', 'full', '83811843');
INSERT INTO `grid50000` VALUES ('4394', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('4395', 'criticism', '83811843');
INSERT INTO `grid50000` VALUES ('4396', 'for', '83811843');
INSERT INTO `grid50000` VALUES ('4397', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4398', 'excesses', '83811843');
INSERT INTO `grid50000` VALUES ('4399', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('4400', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4401', 'Catholic', '83811843');
INSERT INTO `grid50000` VALUES ('4402', 'Church', '83811843');
INSERT INTO `grid50000` VALUES ('4403', '\r\n\r\nOne', '83811843');
INSERT INTO `grid50000` VALUES ('4404', 'such', '83811843');
INSERT INTO `grid50000` VALUES ('4405', 'religious', '83811843');
INSERT INTO `grid50000` VALUES ('4406', 'reformer', '83811843');
INSERT INTO `grid50000` VALUES ('4407', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('4408', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('4409', 'play', '83811843');
INSERT INTO `grid50000` VALUES ('4410', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('4411', 'pivotal', '83811843');
INSERT INTO `grid50000` VALUES ('4412', 'though', '83811843');
INSERT INTO `grid50000` VALUES ('4413', 'posthumous', '83811843');
INSERT INTO `grid50000` VALUES ('4414', 'role', '83811843');
INSERT INTO `grid50000` VALUES ('4415', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('4416', 'deciding', '83811843');
INSERT INTO `grid50000` VALUES ('4417', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4418', 'countrys', '83811843');
INSERT INTO `grid50000` VALUES ('4419', 'fate', '83811843');
INSERT INTO `grid50000` VALUES ('4420', 'for', '83811843');
INSERT INTO `grid50000` VALUES ('4421', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4422', 'next', '83811843');
INSERT INTO `grid50000` VALUES ('4423', 'several', '83811843');
INSERT INTO `grid50000` VALUES ('4424', 'hundred', '83811843');
INSERT INTO `grid50000` VALUES ('4425', 'years', '83811843');
INSERT INTO `grid50000` VALUES ('4426', '\r\n\r\nJan', '83811843');
INSERT INTO `grid50000` VALUES ('4427', 'Hus', '83811843');
INSERT INTO `grid50000` VALUES ('4428', 'had', '83811843');
INSERT INTO `grid50000` VALUES ('4429', 'been', '83811843');
INSERT INTO `grid50000` VALUES ('4430', 'greatly', '83811843');
INSERT INTO `grid50000` VALUES ('4431', 'influenced', '83811843');
INSERT INTO `grid50000` VALUES ('4432', 'by', '83811843');
INSERT INTO `grid50000` VALUES ('4433', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4434', 'writings', '83811843');
INSERT INTO `grid50000` VALUES ('4435', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('4436', 'John', '83811843');
INSERT INTO `grid50000` VALUES ('4437', 'Wycliffe', '83811843');
INSERT INTO `grid50000` VALUES ('4438', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('4439', 'he', '83811843');
INSERT INTO `grid50000` VALUES ('4440', 'began', '83811843');
INSERT INTO `grid50000` VALUES ('4441', 'conducting', '83811843');
INSERT INTO `grid50000` VALUES ('4442', 'his', '83811843');
INSERT INTO `grid50000` VALUES ('4443', 'sermons', '83811843');
INSERT INTO `grid50000` VALUES ('4444', 'at', '83811843');
INSERT INTO `grid50000` VALUES ('4445', 'Bethlehem', '83811843');
INSERT INTO `grid50000` VALUES ('4446', 'Chapel', '83811843');
INSERT INTO `grid50000` VALUES ('4447', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('4448', 'Prague', '83811843');
INSERT INTO `grid50000` VALUES ('4449', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('4450', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('4451', 'rather', '83811843');
INSERT INTO `grid50000` VALUES ('4452', 'than', '83811843');
INSERT INTO `grid50000` VALUES ('4453', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('4454', 'Latin', '83811843');
INSERT INTO `grid50000` VALUES ('4455', 'so', '83811843');
INSERT INTO `grid50000` VALUES ('4456', 'that', '83811843');
INSERT INTO `grid50000` VALUES ('4457', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4458', 'common', '83811843');
INSERT INTO `grid50000` VALUES ('4459', 'man', '83811843');
INSERT INTO `grid50000` VALUES ('4460', 'could', '83811843');
INSERT INTO `grid50000` VALUES ('4461', 'understand', '83811843');
INSERT INTO `grid50000` VALUES ('4462', 'them', '83811843');
INSERT INTO `grid50000` VALUES ('4463', 'He', '83811843');
INSERT INTO `grid50000` VALUES ('4464', 'also', '83811843');
INSERT INTO `grid50000` VALUES ('4465', 'advocated', '83811843');
INSERT INTO `grid50000` VALUES ('4466', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4467', 'giving', '83811843');
INSERT INTO `grid50000` VALUES ('4468', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('4469', 'communion', '83811843');
INSERT INTO `grid50000` VALUES ('4470', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('4471', 'both', '83811843');
INSERT INTO `grid50000` VALUES ('4472', 'species', '83811843');
INSERT INTO `grid50000` VALUES ('4473', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('4474', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('4475', 'critical', '83811843');
INSERT INTO `grid50000` VALUES ('4476', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('4477', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4478', 'church', '83811843');
INSERT INTO `grid50000` VALUES ('4479', 'for', '83811843');
INSERT INTO `grid50000` VALUES ('4480', 'its', '83811843');
INSERT INTO `grid50000` VALUES ('4481', 'excessive', '83811843');
INSERT INTO `grid50000` VALUES ('4482', 'policies', '83811843');
INSERT INTO `grid50000` VALUES ('4483', '', '83811843');
INSERT INTO `grid50000` VALUES ('4484', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('4485', 'amassing', '83811843');
INSERT INTO `grid50000` VALUES ('4486', 'wealth', '83811843');
INSERT INTO `grid50000` VALUES ('4487', 'selling', '83811843');
INSERT INTO `grid50000` VALUES ('4488', 'indulgences', '83811843');
INSERT INTO `grid50000` VALUES ('4489', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('4490', 'allowing', '83811843');
INSERT INTO `grid50000` VALUES ('4491', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4492', 'rich', '83811843');
INSERT INTO `grid50000` VALUES ('4493', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('4494', 'tithe', '83811843');
INSERT INTO `grid50000` VALUES ('4495', 'their', '83811843');
INSERT INTO `grid50000` VALUES ('4496', 'way', '83811843');
INSERT INTO `grid50000` VALUES ('4497', 'out', '83811843');
INSERT INTO `grid50000` VALUES ('4498', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('4499', 'even', '83811843');
INSERT INTO `grid50000` VALUES ('4500', 'mortal', '83811843');
INSERT INTO `grid50000` VALUES ('4501', 'sins', '83811843');
INSERT INTO `grid50000` VALUES ('4502', '\r\n\r\nEven', '83811843');
INSERT INTO `grid50000` VALUES ('4503', 'as', '83811843');
INSERT INTO `grid50000` VALUES ('4504', 'these', '83811843');
INSERT INTO `grid50000` VALUES ('4505', 'ideas', '83811843');
INSERT INTO `grid50000` VALUES ('4506', 'were', '83811843');
INSERT INTO `grid50000` VALUES ('4507', 'gaining', '83811843');
INSERT INTO `grid50000` VALUES ('4508', 'popularity', '83811843');
INSERT INTO `grid50000` VALUES ('4509', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('4510', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4511', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('4512', 'lands', '83811843');
INSERT INTO `grid50000` VALUES ('4513', 'they', '83811843');
INSERT INTO `grid50000` VALUES ('4514', 'were', '83811843');
INSERT INTO `grid50000` VALUES ('4515', 'becoming', '83811843');
INSERT INTO `grid50000` VALUES ('4516', 'most', '83811843');
INSERT INTO `grid50000` VALUES ('4517', 'wildly', '83811843');
INSERT INTO `grid50000` VALUES ('4518', 'unpopular', '83811843');
INSERT INTO `grid50000` VALUES ('4519', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('4520', 'other', '83811843');
INSERT INTO `grid50000` VALUES ('4521', 'areas', '83811843');
INSERT INTO `grid50000` VALUES ('4522', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('4523', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4524', 'Holy', '83811843');
INSERT INTO `grid50000` VALUES ('4525', 'Roman', '83811843');
INSERT INTO `grid50000` VALUES ('4526', 'Empire', '83811843');
INSERT INTO `grid50000` VALUES ('4527', 'especially', '83811843');
INSERT INTO `grid50000` VALUES ('4528', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4529', 'Vatican', '83811843');
INSERT INTO `grid50000` VALUES ('4530', 'This', '83811843');
INSERT INTO `grid50000` VALUES ('4531', 'led', '83811843');
INSERT INTO `grid50000` VALUES ('4532', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('4533', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4534', 'burning', '83811843');
INSERT INTO `grid50000` VALUES ('4535', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('4536', 'Master', '83811843');
INSERT INTO `grid50000` VALUES ('4537', 'Jan', '83811843');
INSERT INTO `grid50000` VALUES ('4538', 'Hus', '83811843');
INSERT INTO `grid50000` VALUES ('4539', 'at', '83811843');
INSERT INTO `grid50000` VALUES ('4540', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4541', 'stake', '83811843');
INSERT INTO `grid50000` VALUES ('4542', 'at', '83811843');
INSERT INTO `grid50000` VALUES ('4543', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4544', 'Council', '83811843');
INSERT INTO `grid50000` VALUES ('4545', 'at', '83811843');
INSERT INTO `grid50000` VALUES ('4546', 'Constance', '83811843');
INSERT INTO `grid50000` VALUES ('4547', 'on', '83811843');
INSERT INTO `grid50000` VALUES ('4548', 'July', '83811843');
INSERT INTO `grid50000` VALUES ('4549', '6', '83811843');
INSERT INTO `grid50000` VALUES ('4550', '1415', '83811843');
INSERT INTO `grid50000` VALUES ('4551', 'when', '83811843');
INSERT INTO `grid50000` VALUES ('4552', 'he', '83811843');
INSERT INTO `grid50000` VALUES ('4553', 'refused', '83811843');
INSERT INTO `grid50000` VALUES ('4554', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('4555', 'recant', '83811843');
INSERT INTO `grid50000` VALUES ('4556', 'his', '83811843');
INSERT INTO `grid50000` VALUES ('4557', 'words', '83811843');
INSERT INTO `grid50000` VALUES ('4558', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('4559', 'despite', '83811843');
INSERT INTO `grid50000` VALUES ('4560', 'that', '83811843');
INSERT INTO `grid50000` VALUES ('4561', 'he', '83811843');
INSERT INTO `grid50000` VALUES ('4562', 'had', '83811843');
INSERT INTO `grid50000` VALUES ('4563', 'letter', '83811843');
INSERT INTO `grid50000` VALUES ('4564', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('4565', 'safe', '83811843');
INSERT INTO `grid50000` VALUES ('4566', 'conduct', '83811843');
INSERT INTO `grid50000` VALUES ('4567', 'from', '83811843');
INSERT INTO `grid50000` VALUES ('4568', 'Wenceslas', '83811843');
INSERT INTO `grid50000` VALUES ('4569', 'IVs', '83811843');
INSERT INTO `grid50000` VALUES ('4570', 'brother', '83811843');
INSERT INTO `grid50000` VALUES ('4571', 'Sigismund', '83811843');
INSERT INTO `grid50000` VALUES ('4572', '\r\n\r\nThe', '83811843');
INSERT INTO `grid50000` VALUES ('4573', 'brutal', '83811843');
INSERT INTO `grid50000` VALUES ('4574', 'killing', '83811843');
INSERT INTO `grid50000` VALUES ('4575', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('4576', 'Jan', '83811843');
INSERT INTO `grid50000` VALUES ('4577', 'Hus', '83811843');
INSERT INTO `grid50000` VALUES ('4578', 'only', '83811843');
INSERT INTO `grid50000` VALUES ('4579', 'served', '83811843');
INSERT INTO `grid50000` VALUES ('4580', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('4581', 'incense', '83811843');
INSERT INTO `grid50000` VALUES ('4582', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('4583', 'unite', '83811843');
INSERT INTO `grid50000` VALUES ('4584', 'his', '83811843');
INSERT INTO `grid50000` VALUES ('4585', 'followers', '83811843');
INSERT INTO `grid50000` VALUES ('4586', 'who', '83811843');
INSERT INTO `grid50000` VALUES ('4587', 'came', '83811843');
INSERT INTO `grid50000` VALUES ('4588', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('4589', 'be', '83811843');
INSERT INTO `grid50000` VALUES ('4590', 'known', '83811843');
INSERT INTO `grid50000` VALUES ('4591', 'as', '83811843');
INSERT INTO `grid50000` VALUES ('4592', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4593', 'Hussites', '83811843');
INSERT INTO `grid50000` VALUES ('4594', '\r\n\r\n', '83811843');
INSERT INTO `grid50000` VALUES ('4595', 'The', '83811843');
INSERT INTO `grid50000` VALUES ('4596', 'Hussites', '83811843');
INSERT INTO `grid50000` VALUES ('4597', 'were', '83811843');
INSERT INTO `grid50000` VALUES ('4598', 'highly', '83811843');
INSERT INTO `grid50000` VALUES ('4599', 'critical', '83811843');
INSERT INTO `grid50000` VALUES ('4600', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('4601', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4602', 'abuses', '83811843');
INSERT INTO `grid50000` VALUES ('4603', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('4604', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4605', 'Roman', '83811843');
INSERT INTO `grid50000` VALUES ('4606', 'Catholic', '83811843');
INSERT INTO `grid50000` VALUES ('4607', 'Church', '83811843');
INSERT INTO `grid50000` VALUES ('4608', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('4609', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('4610', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4611', 'Four', '83811843');
INSERT INTO `grid50000` VALUES ('4612', 'Articles', '83811843');
INSERT INTO `grid50000` VALUES ('4613', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('4614', 'Prague', '83811843');
INSERT INTO `grid50000` VALUES ('4615', 'they', '83811843');
INSERT INTO `grid50000` VALUES ('4616', 'demanded', '83811843');
INSERT INTO `grid50000` VALUES ('4617', 'that', '83811843');
INSERT INTO `grid50000` VALUES ('4618', '1', '83811843');
INSERT INTO `grid50000` VALUES ('4619', 'all', '83811843');
INSERT INTO `grid50000` VALUES ('4620', 'believers', '83811843');
INSERT INTO `grid50000` VALUES ('4621', 'be', '83811843');
INSERT INTO `grid50000` VALUES ('4622', 'permitted', '83811843');
INSERT INTO `grid50000` VALUES ('4623', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('4624', 'receive', '83811843');
INSERT INTO `grid50000` VALUES ('4625', 'Communion', '83811843');
INSERT INTO `grid50000` VALUES ('4626', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('4627', 'both', '83811843');
INSERT INTO `grid50000` VALUES ('4628', 'species;', '83811843');
INSERT INTO `grid50000` VALUES ('4629', '2', '83811843');
INSERT INTO `grid50000` VALUES ('4630', 'all', '83811843');
INSERT INTO `grid50000` VALUES ('4631', 'mortal', '83811843');
INSERT INTO `grid50000` VALUES ('4632', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('4633', 'public', '83811843');
INSERT INTO `grid50000` VALUES ('4634', 'sins', '83811843');
INSERT INTO `grid50000` VALUES ('4635', 'be', '83811843');
INSERT INTO `grid50000` VALUES ('4636', 'punished', '83811843');
INSERT INTO `grid50000` VALUES ('4637', 'equally', '83811843');
INSERT INTO `grid50000` VALUES ('4638', 'regardless', '83811843');
INSERT INTO `grid50000` VALUES ('4639', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('4640', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4641', 'sinners', '83811843');
INSERT INTO `grid50000` VALUES ('4642', 'status', '83811843');
INSERT INTO `grid50000` VALUES ('4643', '3', '83811843');
INSERT INTO `grid50000` VALUES ('4644', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4645', 'Word', '83811843');
INSERT INTO `grid50000` VALUES ('4646', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('4647', 'God', '83811843');
INSERT INTO `grid50000` VALUES ('4648', 'be', '83811843');
INSERT INTO `grid50000` VALUES ('4649', 'freely', '83811843');
INSERT INTO `grid50000` VALUES ('4650', 'preached;', '83811843');
INSERT INTO `grid50000` VALUES ('4651', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('4652', '4', '83811843');
INSERT INTO `grid50000` VALUES ('4653', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4654', 'clergy', '83811843');
INSERT INTO `grid50000` VALUES ('4655', 'give', '83811843');
INSERT INTO `grid50000` VALUES ('4656', 'up', '83811843');
INSERT INTO `grid50000` VALUES ('4657', 'their', '83811843');
INSERT INTO `grid50000` VALUES ('4658', 'worldly', '83811843');
INSERT INTO `grid50000` VALUES ('4659', 'wealth', '83811843');
INSERT INTO `grid50000` VALUES ('4660', '\r\n\r\nThis', '83811843');
INSERT INTO `grid50000` VALUES ('4661', 'situation', '83811843');
INSERT INTO `grid50000` VALUES ('4662', 'culminated', '83811843');
INSERT INTO `grid50000` VALUES ('4663', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('4664', '1419', '83811843');
INSERT INTO `grid50000` VALUES ('4665', 'with', '83811843');
INSERT INTO `grid50000` VALUES ('4666', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4667', 'First', '83811843');
INSERT INTO `grid50000` VALUES ('4668', 'Defenestration', '83811843');
INSERT INTO `grid50000` VALUES ('4669', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('4670', 'Prague', '83811843');
INSERT INTO `grid50000` VALUES ('4671', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('4672', 'which', '83811843');
INSERT INTO `grid50000` VALUES ('4673', 'Hussites', '83811843');
INSERT INTO `grid50000` VALUES ('4674', 'threw', '83811843');
INSERT INTO `grid50000` VALUES ('4675', '7', '83811843');
INSERT INTO `grid50000` VALUES ('4676', 'members', '83811843');
INSERT INTO `grid50000` VALUES ('4677', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('4678', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4679', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('4680', 'Town', '83811843');
INSERT INTO `grid50000` VALUES ('4681', 'Council', '83811843');
INSERT INTO `grid50000` VALUES ('4682', 'out', '83811843');
INSERT INTO `grid50000` VALUES ('4683', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('4684', 'Pragues', '83811843');
INSERT INTO `grid50000` VALUES ('4685', 'New', '83811843');
INSERT INTO `grid50000` VALUES ('4686', 'Town', '83811843');
INSERT INTO `grid50000` VALUES ('4687', 'Hall', '83811843');
INSERT INTO `grid50000` VALUES ('4688', 'window', '83811843');
INSERT INTO `grid50000` VALUES ('4689', '', '83811843');
INSERT INTO `grid50000` VALUES ('4690', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('4691', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('4692', 'their', '83811843');
INSERT INTO `grid50000` VALUES ('4693', 'deaths', '83811843');
INSERT INTO `grid50000` VALUES ('4694', 'on', '83811843');
INSERT INTO `grid50000` VALUES ('4695', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4696', 'points', '83811843');
INSERT INTO `grid50000` VALUES ('4697', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('4698', 'Hussiteweilded', '83811843');
INSERT INTO `grid50000` VALUES ('4699', 'pikes', '83811843');
INSERT INTO `grid50000` VALUES ('4700', 'below', '83811843');
INSERT INTO `grid50000` VALUES ('4701', '', '83811843');
INSERT INTO `grid50000` VALUES ('4702', 'To', '83811843');
INSERT INTO `grid50000` VALUES ('4703', 'make', '83811843');
INSERT INTO `grid50000` VALUES ('4704', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4705', 'situation', '83811843');
INSERT INTO `grid50000` VALUES ('4706', 'more', '83811843');
INSERT INTO `grid50000` VALUES ('4707', 'interesting', '83811843');
INSERT INTO `grid50000` VALUES ('4708', 'King', '83811843');
INSERT INTO `grid50000` VALUES ('4709', 'Wenceslas', '83811843');
INSERT INTO `grid50000` VALUES ('4710', 'IV', '83811843');
INSERT INTO `grid50000` VALUES ('4711', 'had', '83811843');
INSERT INTO `grid50000` VALUES ('4713', 'apopleptic', '83811843');
INSERT INTO `grid50000` VALUES ('4714', 'fit', '83811843');
INSERT INTO `grid50000` VALUES ('4715', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('4716', 'died', '83811843');
INSERT INTO `grid50000` VALUES ('4717', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('4718', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('4719', 'heart', '83811843');
INSERT INTO `grid50000` VALUES ('4720', 'attack', '83811843');
INSERT INTO `grid50000` VALUES ('4721', 'upon', '83811843');
INSERT INTO `grid50000` VALUES ('4722', 'learning', '83811843');
INSERT INTO `grid50000` VALUES ('4723', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('4724', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4725', 'defenestration', '83811843');
INSERT INTO `grid50000` VALUES ('4726', '\r\n\r\nBut', '83811843');
INSERT INTO `grid50000` VALUES ('4727', 'even', '83811843');
INSERT INTO `grid50000` VALUES ('4728', 'after', '83811843');
INSERT INTO `grid50000` VALUES ('4729', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4730', 'death', '83811843');
INSERT INTO `grid50000` VALUES ('4731', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('4732', 'his', '83811843');
INSERT INTO `grid50000` VALUES ('4733', 'brother', '83811843');
INSERT INTO `grid50000` VALUES ('4734', 'Wenceslas', '83811843');
INSERT INTO `grid50000` VALUES ('4735', 'IV', '83811843');
INSERT INTO `grid50000` VALUES ('4736', 'King', '83811843');
INSERT INTO `grid50000` VALUES ('4737', 'Sigismund', '83811843');
INSERT INTO `grid50000` VALUES ('4738', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('4739', 'Luxembourg', '83811843');
INSERT INTO `grid50000` VALUES ('4740', 'who', '83811843');
INSERT INTO `grid50000` VALUES ('4741', 'also', '83811843');
INSERT INTO `grid50000` VALUES ('4742', 'inherited', '83811843');
INSERT INTO `grid50000` VALUES ('4743', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4744', 'title', '83811843');
INSERT INTO `grid50000` VALUES ('4745', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('4746', 'Holy', '83811843');
INSERT INTO `grid50000` VALUES ('4747', 'Roman', '83811843');
INSERT INTO `grid50000` VALUES ('4748', 'Emperor', '83811843');
INSERT INTO `grid50000` VALUES ('4749', 'never', '83811843');
INSERT INTO `grid50000` VALUES ('4750', 'really', '83811843');
INSERT INTO `grid50000` VALUES ('4751', 'got', '83811843');
INSERT INTO `grid50000` VALUES ('4752', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('4753', 'be', '83811843');
INSERT INTO `grid50000` VALUES ('4754', 'king', '83811843');
INSERT INTO `grid50000` VALUES ('4755', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('4756', 'Bohemia', '83811843');
INSERT INTO `grid50000` VALUES ('4757', 'The', '83811843');
INSERT INTO `grid50000` VALUES ('4758', 'situation', '83811843');
INSERT INTO `grid50000` VALUES ('4759', 'with', '83811843');
INSERT INTO `grid50000` VALUES ('4760', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4761', 'Hussites', '83811843');
INSERT INTO `grid50000` VALUES ('4762', 'had', '83811843');
INSERT INTO `grid50000` VALUES ('4763', 'gone', '83811843');
INSERT INTO `grid50000` VALUES ('4764', 'too', '83811843');
INSERT INTO `grid50000` VALUES ('4765', 'far', '83811843');
INSERT INTO `grid50000` VALUES ('4766', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('4767', 'he', '83811843');
INSERT INTO `grid50000` VALUES ('4768', 'spent', '83811843');
INSERT INTO `grid50000` VALUES ('4769', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4770', 'rest', '83811843');
INSERT INTO `grid50000` VALUES ('4771', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('4772', 'his', '83811843');
INSERT INTO `grid50000` VALUES ('4773', 'life', '83811843');
INSERT INTO `grid50000` VALUES ('4774', 'fighting', '83811843');
INSERT INTO `grid50000` VALUES ('4775', 'them', '83811843');
INSERT INTO `grid50000` VALUES ('4776', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('4777', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4778', 'hopes', '83811843');
INSERT INTO `grid50000` VALUES ('4779', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('4780', 'taking', '83811843');
INSERT INTO `grid50000` VALUES ('4781', 'control', '83811843');
INSERT INTO `grid50000` VALUES ('4782', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('4783', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4784', 'throne', '83811843');
INSERT INTO `grid50000` VALUES ('4785', 'hed', '83811843');
INSERT INTO `grid50000` VALUES ('4786', 'inherited', '83811843');
INSERT INTO `grid50000` VALUES ('4787', 'from', '83811843');
INSERT INTO `grid50000` VALUES ('4788', 'his', '83811843');
INSERT INTO `grid50000` VALUES ('4789', 'brother', '83811843');
INSERT INTO `grid50000` VALUES ('4790', 'When', '83811843');
INSERT INTO `grid50000` VALUES ('4791', 'his', '83811843');
INSERT INTO `grid50000` VALUES ('4792', 'initial', '83811843');
INSERT INTO `grid50000` VALUES ('4793', 'attempts', '83811843');
INSERT INTO `grid50000` VALUES ('4794', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('4795', 'do', '83811843');
INSERT INTO `grid50000` VALUES ('4796', 'this', '83811843');
INSERT INTO `grid50000` VALUES ('4797', 'met', '83811843');
INSERT INTO `grid50000` VALUES ('4798', 'with', '83811843');
INSERT INTO `grid50000` VALUES ('4799', 'failure', '83811843');
INSERT INTO `grid50000` VALUES ('4800', 'he', '83811843');
INSERT INTO `grid50000` VALUES ('4801', 'beseeched', '83811843');
INSERT INTO `grid50000` VALUES ('4802', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4803', 'Pope', '83811843');
INSERT INTO `grid50000` VALUES ('4804', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('4805', 'send', '83811843');
INSERT INTO `grid50000` VALUES ('4806', 'help', '83811843');
INSERT INTO `grid50000` VALUES ('4807', '\r\n\r\nThe', '83811843');
INSERT INTO `grid50000` VALUES ('4808', 'mighty', '83811843');
INSERT INTO `grid50000` VALUES ('4809', 'Hussites', '83811843');
INSERT INTO `grid50000` VALUES ('4810', 'led', '83811843');
INSERT INTO `grid50000` VALUES ('4811', 'by', '83811843');
INSERT INTO `grid50000` VALUES ('4812', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4813', 'oneeyed', '83811843');
INSERT INTO `grid50000` VALUES ('4814', 'military', '83811843');
INSERT INTO `grid50000` VALUES ('4815', 'genius', '83811843');
INSERT INTO `grid50000` VALUES ('4816', 'Jan', '83811843');
INSERT INTO `grid50000` VALUES ('4817', 'Zizka', '83811843');
INSERT INTO `grid50000` VALUES ('4818', 'defeated', '83811843');
INSERT INTO `grid50000` VALUES ('4819', 'five', '83811843');
INSERT INTO `grid50000` VALUES ('4820', 'waves', '83811843');
INSERT INTO `grid50000` VALUES ('4821', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('4822', 'crusaders', '83811843');
INSERT INTO `grid50000` VALUES ('4823', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('4824', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('4825', 'row:', '83811843');
INSERT INTO `grid50000` VALUES ('4826', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('4827', '1420', '83811843');
INSERT INTO `grid50000` VALUES ('4828', '1421', '83811843');
INSERT INTO `grid50000` VALUES ('4829', '1422', '83811843');
INSERT INTO `grid50000` VALUES ('4830', '1427', '83811843');
INSERT INTO `grid50000` VALUES ('4831', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('4832', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('4833', '1437', '83811843');
INSERT INTO `grid50000` VALUES ('4834', '', '83811843');
INSERT INTO `grid50000` VALUES ('4835', '\r\n\r\nActually', '83811843');
INSERT INTO `grid50000` VALUES ('4836', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4837', 'fifth', '83811843');
INSERT INTO `grid50000` VALUES ('4838', 'army', '83811843');
INSERT INTO `grid50000` VALUES ('4839', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('4840', 'crusaders', '83811843');
INSERT INTO `grid50000` VALUES ('4841', 'sent', '83811843');
INSERT INTO `grid50000` VALUES ('4842', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('4843', 'battle', '83811843');
INSERT INTO `grid50000` VALUES ('4844', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4845', 'Hussites', '83811843');
INSERT INTO `grid50000` VALUES ('4846', 'turned', '83811843');
INSERT INTO `grid50000` VALUES ('4847', 'tail', '83811843');
INSERT INTO `grid50000` VALUES ('4848', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('4849', 'fled', '83811843');
INSERT INTO `grid50000` VALUES ('4850', 'before', '83811843');
INSERT INTO `grid50000` VALUES ('4851', 'even', '83811843');
INSERT INTO `grid50000` VALUES ('4852', 'catching', '83811843');
INSERT INTO `grid50000` VALUES ('4853', 'sight', '83811843');
INSERT INTO `grid50000` VALUES ('4854', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('4855', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4856', 'famed', '83811843');
INSERT INTO `grid50000` VALUES ('4857', 'warriors', '83811843');
INSERT INTO `grid50000` VALUES ('4858', '', '83811843');
INSERT INTO `grid50000` VALUES ('4859', 'because', '83811843');
INSERT INTO `grid50000` VALUES ('4860', 'they', '83811843');
INSERT INTO `grid50000` VALUES ('4861', 'were', '83811843');
INSERT INTO `grid50000` VALUES ('4862', 'so', '83811843');
INSERT INTO `grid50000` VALUES ('4863', 'terrified', '83811843');
INSERT INTO `grid50000` VALUES ('4864', 'at', '83811843');
INSERT INTO `grid50000` VALUES ('4865', 'hearing', '83811843');
INSERT INTO `grid50000` VALUES ('4866', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4867', 'refrain', '83811843');
INSERT INTO `grid50000` VALUES ('4868', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('4869', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4870', 'terrible', '83811843');
INSERT INTO `grid50000` VALUES ('4871', 'Hussite', '83811843');
INSERT INTO `grid50000` VALUES ('4872', 'battle', '83811843');
INSERT INTO `grid50000` VALUES ('4873', 'song', '83811843');
INSERT INTO `grid50000` VALUES ('4874', 'Ye', '83811843');
INSERT INTO `grid50000` VALUES ('4875', 'Warriors', '83811843');
INSERT INTO `grid50000` VALUES ('4876', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('4877', 'God', '83811843');
INSERT INTO `grid50000` VALUES ('4878', 'It', '83811843');
INSERT INTO `grid50000` VALUES ('4879', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('4880', 'either', '83811843');
INSERT INTO `grid50000` VALUES ('4881', 'that', '83811843');
INSERT INTO `grid50000` VALUES ('4882', 'or', '83811843');
INSERT INTO `grid50000` VALUES ('4883', 'maybe', '83811843');
INSERT INTO `grid50000` VALUES ('4884', 'just', '83811843');
INSERT INTO `grid50000` VALUES ('4885', 'that', '83811843');
INSERT INTO `grid50000` VALUES ('4886', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4887', 'warriors', '83811843');
INSERT INTO `grid50000` VALUES ('4888', 'didnt', '83811843');
INSERT INTO `grid50000` VALUES ('4889', 'sing', '83811843');
INSERT INTO `grid50000` VALUES ('4890', 'very', '83811843');
INSERT INTO `grid50000` VALUES ('4891', 'well', '83811843');
INSERT INTO `grid50000` VALUES ('4892', '\r\n\r\nWell', '83811843');
INSERT INTO `grid50000` VALUES ('4893', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('4894', 'addition', '83811843');
INSERT INTO `grid50000` VALUES ('4895', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('4896', 'fearinspiring', '83811843');
INSERT INTO `grid50000` VALUES ('4897', 'songs', '83811843');
INSERT INTO `grid50000` VALUES ('4898', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('4899', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4900', 'other', '83811843');
INSERT INTO `grid50000` VALUES ('4901', 'tricks', '83811843');
INSERT INTO `grid50000` VALUES ('4902', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4903', 'Hussites', '83811843');
INSERT INTO `grid50000` VALUES ('4904', 'had', '83811843');
INSERT INTO `grid50000` VALUES ('4905', 'up', '83811843');
INSERT INTO `grid50000` VALUES ('4906', 'their', '83811843');
INSERT INTO `grid50000` VALUES ('4907', 'sleeves', '83811843');
INSERT INTO `grid50000` VALUES ('4908', 'they', '83811843');
INSERT INTO `grid50000` VALUES ('4909', 'also', '83811843');
INSERT INTO `grid50000` VALUES ('4910', 'had', '83811843');
INSERT INTO `grid50000` VALUES ('4911', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4912', 'thing', '83811843');
INSERT INTO `grid50000` VALUES ('4913', 'that', '83811843');
INSERT INTO `grid50000` VALUES ('4914', 'matters', '83811843');
INSERT INTO `grid50000` VALUES ('4915', 'most', '83811843');
INSERT INTO `grid50000` VALUES ('4916', '', '83811843');
INSERT INTO `grid50000` VALUES ('4917', 'conviction', '83811843');
INSERT INTO `grid50000` VALUES ('4918', 'that', '83811843');
INSERT INTO `grid50000` VALUES ('4919', 'their', '83811843');
INSERT INTO `grid50000` VALUES ('4920', 'cause', '83811843');
INSERT INTO `grid50000` VALUES ('4921', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('4922', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4923', 'Just', '83811843');
INSERT INTO `grid50000` VALUES ('4924', 'one', '83811843');
INSERT INTO `grid50000` VALUES ('4925', 'Their', '83811843');
INSERT INTO `grid50000` VALUES ('4926', 'symbol', '83811843');
INSERT INTO `grid50000` VALUES ('4927', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('4928', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4929', 'chalice', '83811843');
INSERT INTO `grid50000` VALUES ('4930', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('4931', 'their', '83811843');
INSERT INTO `grid50000` VALUES ('4932', 'motto', '83811843');
INSERT INTO `grid50000` VALUES ('4933', 'Truth', '83811843');
INSERT INTO `grid50000` VALUES ('4934', 'Prevails', '83811843');
INSERT INTO `grid50000` VALUES ('4935', 'this', '83811843');
INSERT INTO `grid50000` VALUES ('4936', 'motto', '83811843');
INSERT INTO `grid50000` VALUES ('4937', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('4938', 'later', '83811843');
INSERT INTO `grid50000` VALUES ('4939', 'used', '83811843');
INSERT INTO `grid50000` VALUES ('4940', 'by', '83811843');
INSERT INTO `grid50000` VALUES ('4941', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4942', 'first', '83811843');
INSERT INTO `grid50000` VALUES ('4943', 'President', '83811843');
INSERT INTO `grid50000` VALUES ('4944', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('4945', 'Czechoslovakia', '83811843');
INSERT INTO `grid50000` VALUES ('4946', 'Tomas', '83811843');
INSERT INTO `grid50000` VALUES ('4947', 'Garrigue', '83811843');
INSERT INTO `grid50000` VALUES ('4948', 'Masaryk', '83811843');
INSERT INTO `grid50000` VALUES ('4949', 'as', '83811843');
INSERT INTO `grid50000` VALUES ('4950', 'well', '83811843');
INSERT INTO `grid50000` VALUES ('4951', 'as', '83811843');
INSERT INTO `grid50000` VALUES ('4952', 'by', '83811843');
INSERT INTO `grid50000` VALUES ('4953', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('4954', 'later', '83811843');
INSERT INTO `grid50000` VALUES ('4955', 'President', '83811843');
INSERT INTO `grid50000` VALUES ('4956', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('4957', 'Czechoslovakia', '83811843');
INSERT INTO `grid50000` VALUES ('4958', 'Vaclav', '83811843');
INSERT INTO `grid50000` VALUES ('4959', 'Havel', '83811843');
INSERT INTO `grid50000` VALUES ('4960', '', '83811843');
INSERT INTO `grid50000` VALUES ('4961', 'during', '83811843');
INSERT INTO `grid50000` VALUES ('4962', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4963', 'Velvet', '83811843');
INSERT INTO `grid50000` VALUES ('4964', 'Revolution', '83811843');
INSERT INTO `grid50000` VALUES ('4965', '\r\n\r\nWell', '83811843');
INSERT INTO `grid50000` VALUES ('4966', 'despite', '83811843');
INSERT INTO `grid50000` VALUES ('4967', 'this', '83811843');
INSERT INTO `grid50000` VALUES ('4968', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('4969', 'despite', '83811843');
INSERT INTO `grid50000` VALUES ('4970', 'their', '83811843');
INSERT INTO `grid50000` VALUES ('4971', 'brilliant', '83811843');
INSERT INTO `grid50000` VALUES ('4972', 'military', '83811843');
INSERT INTO `grid50000` VALUES ('4973', 'successes', '83811843');
INSERT INTO `grid50000` VALUES ('4974', 'all', '83811843');
INSERT INTO `grid50000` VALUES ('4975', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('4976', 'not', '83811843');
INSERT INTO `grid50000` VALUES ('4977', 'well', '83811843');
INSERT INTO `grid50000` VALUES ('4978', 'within', '83811843');
INSERT INTO `grid50000` VALUES ('4979', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4980', 'Hussite', '83811843');
INSERT INTO `grid50000` VALUES ('4981', 'movement', '83811843');
INSERT INTO `grid50000` VALUES ('4982', 'itself', '83811843');
INSERT INTO `grid50000` VALUES ('4983', 'From', '83811843');
INSERT INTO `grid50000` VALUES ('4984', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4985', 'very', '83811843');
INSERT INTO `grid50000` VALUES ('4986', 'start', '83811843');
INSERT INTO `grid50000` VALUES ('4987', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4988', 'Hussite', '83811843');
INSERT INTO `grid50000` VALUES ('4989', 'movement', '83811843');
INSERT INTO `grid50000` VALUES ('4990', 'had', '83811843');
INSERT INTO `grid50000` VALUES ('4991', 'been', '83811843');
INSERT INTO `grid50000` VALUES ('4992', 'divided', '83811843');
INSERT INTO `grid50000` VALUES ('4993', 'into', '83811843');
INSERT INTO `grid50000` VALUES ('4994', 'factions', '83811843');
INSERT INTO `grid50000` VALUES ('4995', '', '83811843');
INSERT INTO `grid50000` VALUES ('4996', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('4997', 'most', '83811843');
INSERT INTO `grid50000` VALUES ('4998', 'prominent', '83811843');
INSERT INTO `grid50000` VALUES ('4999', 'division', '83811843');
INSERT INTO `grid50000` VALUES ('5000', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('5001', 'along', '83811843');
INSERT INTO `grid50000` VALUES ('5002', 'economic', '83811843');
INSERT INTO `grid50000` VALUES ('5003', 'lines', '83811843');
INSERT INTO `grid50000` VALUES ('5004', '\r\n\r\nA', '83811843');
INSERT INTO `grid50000` VALUES ('5005', 'number', '83811843');
INSERT INTO `grid50000` VALUES ('5006', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('5007', 'peasant', '83811843');
INSERT INTO `grid50000` VALUES ('5008', 'Hussites', '83811843');
INSERT INTO `grid50000` VALUES ('5009', 'were', '83811843');
INSERT INTO `grid50000` VALUES ('5010', 'nothing', '83811843');
INSERT INTO `grid50000` VALUES ('5011', 'more', '83811843');
INSERT INTO `grid50000` VALUES ('5012', 'than', '83811843');
INSERT INTO `grid50000` VALUES ('5013', 'hooligans', '83811843');
INSERT INTO `grid50000` VALUES ('5014', 'at', '83811843');
INSERT INTO `grid50000` VALUES ('5015', 'best', '83811843');
INSERT INTO `grid50000` VALUES ('5016', '', '83811843');
INSERT INTO `grid50000` VALUES ('5017', 'terrorists', '83811843');
INSERT INTO `grid50000` VALUES ('5018', 'at', '83811843');
INSERT INTO `grid50000` VALUES ('5019', 'worst', '83811843');
INSERT INTO `grid50000` VALUES ('5020', '', '83811843');
INSERT INTO `grid50000` VALUES ('5021', 'who', '83811843');
INSERT INTO `grid50000` VALUES ('5022', 'joined', '83811843');
INSERT INTO `grid50000` VALUES ('5023', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5024', 'cause', '83811843');
INSERT INTO `grid50000` VALUES ('5025', 'only', '83811843');
INSERT INTO `grid50000` VALUES ('5026', 'so', '83811843');
INSERT INTO `grid50000` VALUES ('5027', 'that', '83811843');
INSERT INTO `grid50000` VALUES ('5028', 'they', '83811843');
INSERT INTO `grid50000` VALUES ('5029', 'could', '83811843');
INSERT INTO `grid50000` VALUES ('5030', 'have', '83811843');
INSERT INTO `grid50000` VALUES ('5031', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('5032', 'good', '83811843');
INSERT INTO `grid50000` VALUES ('5033', 'excuse', '83811843');
INSERT INTO `grid50000` VALUES ('5034', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('5035', 'go', '83811843');
INSERT INTO `grid50000` VALUES ('5036', 'around', '83811843');
INSERT INTO `grid50000` VALUES ('5037', 'robbing', '83811843');
INSERT INTO `grid50000` VALUES ('5038', 'churches', '83811843');
INSERT INTO `grid50000` VALUES ('5039', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('5040', 'setting', '83811843');
INSERT INTO `grid50000` VALUES ('5041', 'them', '83811843');
INSERT INTO `grid50000` VALUES ('5042', 'aflame', '83811843');
INSERT INTO `grid50000` VALUES ('5043', 'with', '83811843');
INSERT INTO `grid50000` VALUES ('5044', 'Catholics', '83811843');
INSERT INTO `grid50000` VALUES ('5045', 'inside', '83811843');
INSERT INTO `grid50000` VALUES ('5046', 'These', '83811843');
INSERT INTO `grid50000` VALUES ('5047', 'practices', '83811843');
INSERT INTO `grid50000` VALUES ('5048', 'were', '83811843');
INSERT INTO `grid50000` VALUES ('5049', 'considered', '83811843');
INSERT INTO `grid50000` VALUES ('5050', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('5051', 'be', '83811843');
INSERT INTO `grid50000` VALUES ('5052', 'rather', '83811843');
INSERT INTO `grid50000` VALUES ('5053', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('5054', 'poor', '83811843');
INSERT INTO `grid50000` VALUES ('5055', 'taste', '83811843');
INSERT INTO `grid50000` VALUES ('5056', 'by', '83811843');
INSERT INTO `grid50000` VALUES ('5057', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5058', 'aristocratic', '83811843');
INSERT INTO `grid50000` VALUES ('5059', 'Hussites', '83811843');
INSERT INTO `grid50000` VALUES ('5060', 'Over', '83811843');
INSERT INTO `grid50000` VALUES ('5061', 'time', '83811843');
INSERT INTO `grid50000` VALUES ('5062', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5063', 'movement', '83811843');
INSERT INTO `grid50000` VALUES ('5064', 'splintered', '83811843');
INSERT INTO `grid50000` VALUES ('5065', 'even', '83811843');
INSERT INTO `grid50000` VALUES ('5066', 'more', '83811843');
INSERT INTO `grid50000` VALUES ('5067', '', '83811843');
INSERT INTO `grid50000` VALUES ('5068', 'even', '83811843');
INSERT INTO `grid50000` VALUES ('5069', 'spawning', '83811843');
INSERT INTO `grid50000` VALUES ('5070', 'an', '83811843');
INSERT INTO `grid50000` VALUES ('5071', 'early', '83811843');
INSERT INTO `grid50000` VALUES ('5072', 'nudist', '83811843');
INSERT INTO `grid50000` VALUES ('5073', 'sect', '83811843');
INSERT INTO `grid50000` VALUES ('5074', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5075', 'Adamites', '83811843');
INSERT INTO `grid50000` VALUES ('5076', 'The', '83811843');
INSERT INTO `grid50000` VALUES ('5077', 'history', '83811843');
INSERT INTO `grid50000` VALUES ('5078', 'books', '83811843');
INSERT INTO `grid50000` VALUES ('5079', 'usually', '83811843');
INSERT INTO `grid50000` VALUES ('5080', 'divide', '83811843');
INSERT INTO `grid50000` VALUES ('5081', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5082', 'Hussites', '83811843');
INSERT INTO `grid50000` VALUES ('5083', 'into', '83811843');
INSERT INTO `grid50000` VALUES ('5084', 'radical', '83811843');
INSERT INTO `grid50000` VALUES ('5085', 'Taborites', '83811843');
INSERT INTO `grid50000` VALUES ('5086', '', '83811843');
INSERT INTO `grid50000` VALUES ('5087', 'named', '83811843');
INSERT INTO `grid50000` VALUES ('5088', 'for', '83811843');
INSERT INTO `grid50000` VALUES ('5089', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5090', 'town', '83811843');
INSERT INTO `grid50000` VALUES ('5091', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('5092', 'Tabor', '83811843');
INSERT INTO `grid50000` VALUES ('5093', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('5094', 'city', '83811843');
INSERT INTO `grid50000` VALUES ('5095', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5096', 'Hussites', '83811843');
INSERT INTO `grid50000` VALUES ('5097', 'founded', '83811843');
INSERT INTO `grid50000` VALUES ('5098', 'for', '83811843');
INSERT INTO `grid50000` VALUES ('5099', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5100', 'occasion', '83811843');
INSERT INTO `grid50000` VALUES ('5101', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('5102', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5103', 'Second', '83811843');
INSERT INTO `grid50000` VALUES ('5104', 'Coming', '83811843');
INSERT INTO `grid50000` VALUES ('5105', 'which', '83811843');
INSERT INTO `grid50000` VALUES ('5106', 'many', '83811843');
INSERT INTO `grid50000` VALUES ('5107', 'considered', '83811843');
INSERT INTO `grid50000` VALUES ('5108', 'imminent', '83811843');
INSERT INTO `grid50000` VALUES ('5109', '', '83811843');
INSERT INTO `grid50000` VALUES ('5110', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('5111', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5112', 'moderate', '83811843');
INSERT INTO `grid50000` VALUES ('5113', 'Utraquists', '83811843');
INSERT INTO `grid50000` VALUES ('5114', '', '83811843');
INSERT INTO `grid50000` VALUES ('5115', 'derived', '83811843');
INSERT INTO `grid50000` VALUES ('5116', 'from', '83811843');
INSERT INTO `grid50000` VALUES ('5117', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5118', 'Latin', '83811843');
INSERT INTO `grid50000` VALUES ('5119', 'sub', '83811843');
INSERT INTO `grid50000` VALUES ('5120', 'utraque', '83811843');
INSERT INTO `grid50000` VALUES ('5121', 'specie', '83811843');
INSERT INTO `grid50000` VALUES ('5122', 'for', '83811843');
INSERT INTO `grid50000` VALUES ('5123', 'their', '83811843');
INSERT INTO `grid50000` VALUES ('5124', 'belief', '83811843');
INSERT INTO `grid50000` VALUES ('5125', 'that', '83811843');
INSERT INTO `grid50000` VALUES ('5126', 'communion', '83811843');
INSERT INTO `grid50000` VALUES ('5127', 'should', '83811843');
INSERT INTO `grid50000` VALUES ('5128', 'be', '83811843');
INSERT INTO `grid50000` VALUES ('5129', 'given', '83811843');
INSERT INTO `grid50000` VALUES ('5130', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('5131', 'both', '83811843');
INSERT INTO `grid50000` VALUES ('5132', 'kinds', '83811843');
INSERT INTO `grid50000` VALUES ('5133', '', '83811843');
INSERT INTO `grid50000` VALUES ('5134', 'made', '83811843');
INSERT INTO `grid50000` VALUES ('5135', 'up', '83811843');
INSERT INTO `grid50000` VALUES ('5136', 'mostly', '83811843');
INSERT INTO `grid50000` VALUES ('5137', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('5138', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5139', 'nobility', '83811843');
INSERT INTO `grid50000` VALUES ('5140', 'In', '83811843');
INSERT INTO `grid50000` VALUES ('5141', 'reality', '83811843');
INSERT INTO `grid50000` VALUES ('5142', 'though', '83811843');
INSERT INTO `grid50000` VALUES ('5143', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5144', 'situation', '83811843');
INSERT INTO `grid50000` VALUES ('5145', 'on', '83811843');
INSERT INTO `grid50000` VALUES ('5146', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5147', 'ground', '83811843');
INSERT INTO `grid50000` VALUES ('5148', 'just', '83811843');
INSERT INTO `grid50000` VALUES ('5149', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('5150', 'not', '83811843');
INSERT INTO `grid50000` VALUES ('5151', 'that', '83811843');
INSERT INTO `grid50000` VALUES ('5152', 'simple', '83811843');
INSERT INTO `grid50000` VALUES ('5153', '\r\n\r\nThis', '83811843');
INSERT INTO `grid50000` VALUES ('5154', 'infighting', '83811843');
INSERT INTO `grid50000` VALUES ('5155', 'came', '83811843');
INSERT INTO `grid50000` VALUES ('5156', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('5157', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('5158', 'head', '83811843');
INSERT INTO `grid50000` VALUES ('5159', 'at', '83811843');
INSERT INTO `grid50000` VALUES ('5160', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5161', 'Battle', '83811843');
INSERT INTO `grid50000` VALUES ('5162', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('5163', 'Lipany', '83811843');
INSERT INTO `grid50000` VALUES ('5164', 'on', '83811843');
INSERT INTO `grid50000` VALUES ('5165', 'May', '83811843');
INSERT INTO `grid50000` VALUES ('5166', '30', '83811843');
INSERT INTO `grid50000` VALUES ('5167', '1434', '83811843');
INSERT INTO `grid50000` VALUES ('5168', 'at', '83811843');
INSERT INTO `grid50000` VALUES ('5169', 'which', '83811843');
INSERT INTO `grid50000` VALUES ('5170', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5171', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('5172', 'Hussite', '83811843');
INSERT INTO `grid50000` VALUES ('5173', 'factions', '83811843');
INSERT INTO `grid50000` VALUES ('5174', 'fought', '83811843');
INSERT INTO `grid50000` VALUES ('5175', 'among', '83811843');
INSERT INTO `grid50000` VALUES ('5176', 'themselves', '83811843');
INSERT INTO `grid50000` VALUES ('5177', 'This', '83811843');
INSERT INTO `grid50000` VALUES ('5178', 'battle', '83811843');
INSERT INTO `grid50000` VALUES ('5179', 'is', '83811843');
INSERT INTO `grid50000` VALUES ('5180', 'considered', '83811843');
INSERT INTO `grid50000` VALUES ('5181', 'by', '83811843');
INSERT INTO `grid50000` VALUES ('5182', 'some', '83811843');
INSERT INTO `grid50000` VALUES ('5183', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('5184', 'be', '83811843');
INSERT INTO `grid50000` VALUES ('5185', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5186', 'single', '83811843');
INSERT INTO `grid50000` VALUES ('5187', 'most', '83811843');
INSERT INTO `grid50000` VALUES ('5188', 'tragic', '83811843');
INSERT INTO `grid50000` VALUES ('5189', 'event', '83811843');
INSERT INTO `grid50000` VALUES ('5190', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('5191', 'all', '83811843');
INSERT INTO `grid50000` VALUES ('5192', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('5193', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('5194', 'history', '83811843');
INSERT INTO `grid50000` VALUES ('5195', '\r\n\r\nWell', '83811843');
INSERT INTO `grid50000` VALUES ('5196', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5197', 'victory', '83811843');
INSERT INTO `grid50000` VALUES ('5198', 'at', '83811843');
INSERT INTO `grid50000` VALUES ('5199', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5200', 'Battle', '83811843');
INSERT INTO `grid50000` VALUES ('5201', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('5202', 'Lipany', '83811843');
INSERT INTO `grid50000` VALUES ('5203', 'went', '83811843');
INSERT INTO `grid50000` VALUES ('5204', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('5205', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5206', 'moderates', '83811843');
INSERT INTO `grid50000` VALUES ('5207', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('5208', 'this', '83811843');
INSERT INTO `grid50000` VALUES ('5209', 'paved', '83811843');
INSERT INTO `grid50000` VALUES ('5210', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5211', 'way', '83811843');
INSERT INTO `grid50000` VALUES ('5212', 'for', '83811843');
INSERT INTO `grid50000` VALUES ('5213', 'an', '83811843');
INSERT INTO `grid50000` VALUES ('5214', 'agreement', '83811843');
INSERT INTO `grid50000` VALUES ('5215', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('5216', 'be', '83811843');
INSERT INTO `grid50000` VALUES ('5217', 'reached', '83811843');
INSERT INTO `grid50000` VALUES ('5218', 'between', '83811843');
INSERT INTO `grid50000` VALUES ('5219', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5220', 'Utraquist', '83811843');
INSERT INTO `grid50000` VALUES ('5221', 'Hussites', '83811843');
INSERT INTO `grid50000` VALUES ('5222', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('5223', 'Bohemia', '83811843');
INSERT INTO `grid50000` VALUES ('5224', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('5225', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5226', 'Roman', '83811843');
INSERT INTO `grid50000` VALUES ('5227', 'Catholic', '83811843');
INSERT INTO `grid50000` VALUES ('5228', 'Church', '83811843');
INSERT INTO `grid50000` VALUES ('5229', '\r\n\r\nThe', '83811843');
INSERT INTO `grid50000` VALUES ('5230', 'Basel', '83811843');
INSERT INTO `grid50000` VALUES ('5231', 'Compact', '83811843');
INSERT INTO `grid50000` VALUES ('5232', 'ceremoniously', '83811843');
INSERT INTO `grid50000` VALUES ('5233', 'announced', '83811843');
INSERT INTO `grid50000` VALUES ('5234', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('5235', '1436', '83811843');
INSERT INTO `grid50000` VALUES ('5236', 'permitted', '83811843');
INSERT INTO `grid50000` VALUES ('5237', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5238', 'Utraquist', '83811843');
INSERT INTO `grid50000` VALUES ('5239', 'Hussites', '83811843');
INSERT INTO `grid50000` VALUES ('5240', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('5241', 'take', '83811843');
INSERT INTO `grid50000` VALUES ('5242', 'Communion', '83811843');
INSERT INTO `grid50000` VALUES ('5243', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('5244', 'both', '83811843');
INSERT INTO `grid50000` VALUES ('5245', 'kinds', '83811843');
INSERT INTO `grid50000` VALUES ('5246', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('5247', 'have', '83811843');
INSERT INTO `grid50000` VALUES ('5248', 'their', '83811843');
INSERT INTO `grid50000` VALUES ('5249', 'church', '83811843');
INSERT INTO `grid50000` VALUES ('5250', 'services', '83811843');
INSERT INTO `grid50000` VALUES ('5251', 'conducted', '83811843');
INSERT INTO `grid50000` VALUES ('5252', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('5253', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5254', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('5255', 'language', '83811843');
INSERT INTO `grid50000` VALUES ('5256', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('5257', 'absolved', '83811843');
INSERT INTO `grid50000` VALUES ('5258', 'them', '83811843');
INSERT INTO `grid50000` VALUES ('5259', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('5260', 'having', '83811843');
INSERT INTO `grid50000` VALUES ('5261', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('5262', 'pay', '83811843');
INSERT INTO `grid50000` VALUES ('5263', 'dues', '83811843');
INSERT INTO `grid50000` VALUES ('5264', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('5265', 'Rome', '83811843');
INSERT INTO `grid50000` VALUES ('5266', 'The', '83811843');
INSERT INTO `grid50000` VALUES ('5267', 'Pope', '83811843');
INSERT INTO `grid50000` VALUES ('5268', 'later', '83811843');
INSERT INTO `grid50000` VALUES ('5269', 'refused', '83811843');
INSERT INTO `grid50000` VALUES ('5270', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('5271', 'recognize', '83811843');
INSERT INTO `grid50000` VALUES ('5272', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5273', 'agreement', '83811843');
INSERT INTO `grid50000` VALUES ('5274', 'but', '83811843');
INSERT INTO `grid50000` VALUES ('5275', 'not', '83811843');
INSERT INTO `grid50000` VALUES ('5276', 'before', '83811843');
INSERT INTO `grid50000` VALUES ('5277', 'it', '83811843');
INSERT INTO `grid50000` VALUES ('5278', 'had', '83811843');
INSERT INTO `grid50000` VALUES ('5279', 'served', '83811843');
INSERT INTO `grid50000` VALUES ('5280', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('5281', 'bring', '83811843');
INSERT INTO `grid50000` VALUES ('5282', 'an', '83811843');
INSERT INTO `grid50000` VALUES ('5283', 'end', '83811843');
INSERT INTO `grid50000` VALUES ('5284', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('5285', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5286', 'costly', '83811843');
INSERT INTO `grid50000` VALUES ('5287', 'Hussite', '83811843');
INSERT INTO `grid50000` VALUES ('5288', 'wars', '83811843');
INSERT INTO `grid50000` VALUES ('5289', '\r\n\r\nThe', '83811843');
INSERT INTO `grid50000` VALUES ('5290', 'extremist', '83811843');
INSERT INTO `grid50000` VALUES ('5291', 'Taborite', '83811843');
INSERT INTO `grid50000` VALUES ('5292', 'Hussites', '83811843');
INSERT INTO `grid50000` VALUES ('5293', 'were', '83811843');
INSERT INTO `grid50000` VALUES ('5294', 'not', '83811843');
INSERT INTO `grid50000` VALUES ('5295', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('5296', 'party', '83811843');
INSERT INTO `grid50000` VALUES ('5297', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('5298', 'this', '83811843');
INSERT INTO `grid50000` VALUES ('5299', 'agreement', '83811843');
INSERT INTO `grid50000` VALUES ('5300', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('5301', 'refused', '83811843');
INSERT INTO `grid50000` VALUES ('5302', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('5303', 'accept', '83811843');
INSERT INTO `grid50000` VALUES ('5304', 'it', '83811843');
INSERT INTO `grid50000` VALUES ('5305', 'While', '83811843');
INSERT INTO `grid50000` VALUES ('5306', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5307', 'moderates', '83811843');
INSERT INTO `grid50000` VALUES ('5308', 'stayed', '83811843');
INSERT INTO `grid50000` VALUES ('5309', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('5310', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5311', 'Catholic', '83811843');
INSERT INTO `grid50000` VALUES ('5312', 'Church', '83811843');
INSERT INTO `grid50000` VALUES ('5313', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5314', 'extremists', '83811843');
INSERT INTO `grid50000` VALUES ('5315', 'went', '83811843');
INSERT INTO `grid50000` VALUES ('5316', 'underground', '83811843');
INSERT INTO `grid50000` VALUES ('5317', 'forming', '83811843');
INSERT INTO `grid50000` VALUES ('5318', 'their', '83811843');
INSERT INTO `grid50000` VALUES ('5319', 'own', '83811843');
INSERT INTO `grid50000` VALUES ('5320', 'church', '83811843');
INSERT INTO `grid50000` VALUES ('5321', 'ordaining', '83811843');
INSERT INTO `grid50000` VALUES ('5322', 'their', '83811843');
INSERT INTO `grid50000` VALUES ('5323', 'own', '83811843');
INSERT INTO `grid50000` VALUES ('5324', 'bishops', '83811843');
INSERT INTO `grid50000` VALUES ('5325', 'pioneering', '83811843');
INSERT INTO `grid50000` VALUES ('5326', 'public', '83811843');
INSERT INTO `grid50000` VALUES ('5327', 'education', '83811843');
INSERT INTO `grid50000` VALUES ('5328', 'sending', '83811843');
INSERT INTO `grid50000` VALUES ('5329', 'out', '83811843');
INSERT INTO `grid50000` VALUES ('5330', 'missionaries', '83811843');
INSERT INTO `grid50000` VALUES ('5331', 'even', '83811843');
INSERT INTO `grid50000` VALUES ('5332', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('5333', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5334', '13', '83811843');
INSERT INTO `grid50000` VALUES ('5335', 'original', '83811843');
INSERT INTO `grid50000` VALUES ('5336', 'American', '83811843');
INSERT INTO `grid50000` VALUES ('5337', 'colonies', '83811843');
INSERT INTO `grid50000` VALUES ('5338', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('5339', 'secretly', '83811843');
INSERT INTO `grid50000` VALUES ('5340', 'printing', '83811843');
INSERT INTO `grid50000` VALUES ('5341', 'Czechlanguage', '83811843');
INSERT INTO `grid50000` VALUES ('5342', 'copies', '83811843');
INSERT INTO `grid50000` VALUES ('5343', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('5344', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5345', 'Kralice', '83811843');
INSERT INTO `grid50000` VALUES ('5346', 'Bible', '83811843');
INSERT INTO `grid50000` VALUES ('5347', '', '83811843');
INSERT INTO `grid50000` VALUES ('5348', 'named', '83811843');
INSERT INTO `grid50000` VALUES ('5349', 'for', '83811843');
INSERT INTO `grid50000` VALUES ('5350', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5351', 'town', '83811843');
INSERT INTO `grid50000` VALUES ('5352', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('5353', 'Kralice', '83811843');
INSERT INTO `grid50000` VALUES ('5354', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('5355', 'which', '83811843');
INSERT INTO `grid50000` VALUES ('5356', 'it', '83811843');
INSERT INTO `grid50000` VALUES ('5357', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('5358', 'printed', '83811843');
INSERT INTO `grid50000` VALUES ('5359', 'This', '83811843');
INSERT INTO `grid50000` VALUES ('5360', 'translation', '83811843');
INSERT INTO `grid50000` VALUES ('5361', 'is', '83811843');
INSERT INTO `grid50000` VALUES ('5362', 'still', '83811843');
INSERT INTO `grid50000` VALUES ('5363', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('5364', 'use', '83811843');
INSERT INTO `grid50000` VALUES ('5365', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('5366', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5367', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('5368', 'lands', '83811843');
INSERT INTO `grid50000` VALUES ('5369', 'today', '83811843');
INSERT INTO `grid50000` VALUES ('5370', 'despite', '83811843');
INSERT INTO `grid50000` VALUES ('5371', 'that', '83811843');
INSERT INTO `grid50000` VALUES ('5372', 'it', '83811843');
INSERT INTO `grid50000` VALUES ('5373', 'is', '83811843');
INSERT INTO `grid50000` VALUES ('5374', 'often', '83811843');
INSERT INTO `grid50000` VALUES ('5375', 'hard', '83811843');
INSERT INTO `grid50000` VALUES ('5376', 'for', '83811843');
INSERT INTO `grid50000` VALUES ('5377', 'modern', '83811843');
INSERT INTO `grid50000` VALUES ('5378', 'speakers', '83811843');
INSERT INTO `grid50000` VALUES ('5379', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('5380', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5381', 'language', '83811843');
INSERT INTO `grid50000` VALUES ('5382', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('5383', 'understand', '83811843');
INSERT INTO `grid50000` VALUES ('5384', '\r\n\r\nSlovakia', '83811843');
INSERT INTO `grid50000` VALUES ('5385', 'all', '83811843');
INSERT INTO `grid50000` VALUES ('5386', 'this', '83811843');
INSERT INTO `grid50000` VALUES ('5387', 'while', '83811843');
INSERT INTO `grid50000` VALUES ('5388', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('5389', 'known', '83811843');
INSERT INTO `grid50000` VALUES ('5390', 'simply', '83811843');
INSERT INTO `grid50000` VALUES ('5391', 'as', '83811843');
INSERT INTO `grid50000` VALUES ('5392', 'Upper', '83811843');
INSERT INTO `grid50000` VALUES ('5393', 'Hungary', '83811843');
INSERT INTO `grid50000` VALUES ('5394', 'Though', '83811843');
INSERT INTO `grid50000` VALUES ('5395', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5396', 'Czechs', '83811843');
INSERT INTO `grid50000` VALUES ('5397', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('5398', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5399', 'Slovaks', '83811843');
INSERT INTO `grid50000` VALUES ('5400', 'had', '83811843');
INSERT INTO `grid50000` VALUES ('5401', 'been', '83811843');
INSERT INTO `grid50000` VALUES ('5402', 'nextdoor', '83811843');
INSERT INTO `grid50000` VALUES ('5403', 'neighbors', '83811843');
INSERT INTO `grid50000` VALUES ('5404', 'since', '83811843');
INSERT INTO `grid50000` VALUES ('5405', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5406', 'time', '83811843');
INSERT INTO `grid50000` VALUES ('5407', 'that', '83811843');
INSERT INTO `grid50000` VALUES ('5408', 'Ancestor', '83811843');
INSERT INTO `grid50000` VALUES ('5409', 'Cech', '83811843');
INSERT INTO `grid50000` VALUES ('5410', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('5411', 'his', '83811843');
INSERT INTO `grid50000` VALUES ('5412', 'brothers', '83811843');
INSERT INTO `grid50000` VALUES ('5413', 'had', '83811843');
INSERT INTO `grid50000` VALUES ('5414', 'come', '83811843');
INSERT INTO `grid50000` VALUES ('5415', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('5416', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5417', 'area', '83811843');
INSERT INTO `grid50000` VALUES ('5418', 'they', '83811843');
INSERT INTO `grid50000` VALUES ('5419', 'have', '83811843');
INSERT INTO `grid50000` VALUES ('5420', 'historically', '83811843');
INSERT INTO `grid50000` VALUES ('5421', 'had', '83811843');
INSERT INTO `grid50000` VALUES ('5422', 'very', '83811843');
INSERT INTO `grid50000` VALUES ('5423', 'little', '83811843');
INSERT INTO `grid50000` VALUES ('5424', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('5425', 'common', '83811843');
INSERT INTO `grid50000` VALUES ('5426', 'until', '83811843');
INSERT INTO `grid50000` VALUES ('5427', '1918', '83811843');
INSERT INTO `grid50000` VALUES ('5428', 'Similarly', '83811843');
INSERT INTO `grid50000` VALUES ('5429', 'neither', '83811843');
INSERT INTO `grid50000` VALUES ('5430', 'country', '83811843');
INSERT INTO `grid50000` VALUES ('5431', 'has', '83811843');
INSERT INTO `grid50000` VALUES ('5432', 'historically', '83811843');
INSERT INTO `grid50000` VALUES ('5433', 'ever', '83811843');
INSERT INTO `grid50000` VALUES ('5434', 'had', '83811843');
INSERT INTO `grid50000` VALUES ('5435', 'much', '83811843');
INSERT INTO `grid50000` VALUES ('5436', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('5437', 'do', '83811843');
INSERT INTO `grid50000` VALUES ('5438', 'with', '83811843');
INSERT INTO `grid50000` VALUES ('5439', 'Poland', '83811843');
INSERT INTO `grid50000` VALUES ('5440', 'which', '83811843');
INSERT INTO `grid50000` VALUES ('5441', 'borders', '83811843');
INSERT INTO `grid50000` VALUES ('5442', 'both', '83811843');
INSERT INTO `grid50000` VALUES ('5443', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('5444', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5445', 'north', '83811843');
INSERT INTO `grid50000` VALUES ('5446', 'It', '83811843');
INSERT INTO `grid50000` VALUES ('5447', 'is', '83811843');
INSERT INTO `grid50000` VALUES ('5448', 'at', '83811843');
INSERT INTO `grid50000` VALUES ('5449', 'this', '83811843');
INSERT INTO `grid50000` VALUES ('5450', 'point', '83811843');
INSERT INTO `grid50000` VALUES ('5451', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('5452', 'history', '83811843');
INSERT INTO `grid50000` VALUES ('5453', '', '83811843');
INSERT INTO `grid50000` VALUES ('5454', 'beginning', '83811843');
INSERT INTO `grid50000` VALUES ('5455', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('5456', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5457', '14th', '83811843');
INSERT INTO `grid50000` VALUES ('5458', 'century', '83811843');
INSERT INTO `grid50000` VALUES ('5459', 'however', '83811843');
INSERT INTO `grid50000` VALUES ('5460', 'closer', '83811843');
INSERT INTO `grid50000` VALUES ('5461', 'cultural', '83811843');
INSERT INTO `grid50000` VALUES ('5462', 'contacts', '83811843');
INSERT INTO `grid50000` VALUES ('5463', 'between', '83811843');
INSERT INTO `grid50000` VALUES ('5464', 'Slovakia', '83811843');
INSERT INTO `grid50000` VALUES ('5465', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('5466', 'Bohemia', '83811843');
INSERT INTO `grid50000` VALUES ('5467', 'were', '83811843');
INSERT INTO `grid50000` VALUES ('5468', 'formed', '83811843');
INSERT INTO `grid50000` VALUES ('5469', 'Especially', '83811843');
INSERT INTO `grid50000` VALUES ('5470', 'during', '83811843');
INSERT INTO `grid50000` VALUES ('5471', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5472', 'turbulent', '83811843');
INSERT INTO `grid50000` VALUES ('5473', 'Hussite', '83811843');
INSERT INTO `grid50000` VALUES ('5474', 'period', '83811843');
INSERT INTO `grid50000` VALUES ('5475', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('5476', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5477', '15th', '83811843');
INSERT INTO `grid50000` VALUES ('5478', 'century', '83811843');
INSERT INTO `grid50000` VALUES ('5479', 'many', '83811843');
INSERT INTO `grid50000` VALUES ('5480', 'Hussite', '83811843');
INSERT INTO `grid50000` VALUES ('5481', 'followers', '83811843');
INSERT INTO `grid50000` VALUES ('5482', 'found', '83811843');
INSERT INTO `grid50000` VALUES ('5483', 'refuge', '83811843');
INSERT INTO `grid50000` VALUES ('5484', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('5485', 'support', '83811843');
INSERT INTO `grid50000` VALUES ('5486', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('5487', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5488', 'Slovak', '83811843');
INSERT INTO `grid50000` VALUES ('5489', 'lands', '83811843');
INSERT INTO `grid50000` VALUES ('5490', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('5491', 'some', '83811843');
INSERT INTO `grid50000` VALUES ('5492', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('5493', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5494', 'Slovak', '83811843');
INSERT INTO `grid50000` VALUES ('5495', 'nobility', '83811843');
INSERT INTO `grid50000` VALUES ('5496', 'fought', '83811843');
INSERT INTO `grid50000` VALUES ('5497', 'on', '83811843');
INSERT INTO `grid50000` VALUES ('5498', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5500', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('5501', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5502', 'Hussites', '83811843');
INSERT INTO `grid50000` VALUES ('5503', '\r\n', '83811843');
INSERT INTO `grid50000` VALUES ('5504', '\r\n\r\nAfter', '83811843');
INSERT INTO `grid50000` VALUES ('5505', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5506', 'Compact', '83811843');
INSERT INTO `grid50000` VALUES ('5507', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('5508', 'Basel', '83811843');
INSERT INTO `grid50000` VALUES ('5509', 'forced', '83811843');
INSERT INTO `grid50000` VALUES ('5510', 'King', '83811843');
INSERT INTO `grid50000` VALUES ('5511', 'Sigismund', '83811843');
INSERT INTO `grid50000` VALUES ('5512', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('5513', 'Luxembourg', '83811843');
INSERT INTO `grid50000` VALUES ('5514', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('5515', 'concede', '83811843');
INSERT INTO `grid50000` VALUES ('5516', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('5517', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5518', 'Hussites', '83811843');
INSERT INTO `grid50000` VALUES ('5519', 'demands', '83811843');
INSERT INTO `grid50000` VALUES ('5520', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5521', 'position', '83811843');
INSERT INTO `grid50000` VALUES ('5522', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('5523', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5524', 'regional', '83811843');
INSERT INTO `grid50000` VALUES ('5525', 'nobility', '83811843');
INSERT INTO `grid50000` VALUES ('5526', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('5527', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('5528', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5529', 'towns', '83811843');
INSERT INTO `grid50000` VALUES ('5530', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('5531', 'grouping', '83811843');
INSERT INTO `grid50000` VALUES ('5532', 'known', '83811843');
INSERT INTO `grid50000` VALUES ('5533', 'as', '83811843');
INSERT INTO `grid50000` VALUES ('5534', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5535', 'Estates', '83811843');
INSERT INTO `grid50000` VALUES ('5536', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('5537', 'strengthened', '83811843');
INSERT INTO `grid50000` VALUES ('5538', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('5539', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5540', 'detriment', '83811843');
INSERT INTO `grid50000` VALUES ('5541', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('5542', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5543', 'centralized', '83811843');
INSERT INTO `grid50000` VALUES ('5544', 'royal', '83811843');
INSERT INTO `grid50000` VALUES ('5545', 'authority', '83811843');
INSERT INTO `grid50000` VALUES ('5546', 'For', '83811843');
INSERT INTO `grid50000` VALUES ('5547', 'some', '83811843');
INSERT INTO `grid50000` VALUES ('5548', 'time', '83811843');
INSERT INTO `grid50000` VALUES ('5549', 'after', '83811843');
INSERT INTO `grid50000` VALUES ('5550', 'Sigismunds', '83811843');
INSERT INTO `grid50000` VALUES ('5551', 'death', '83811843');
INSERT INTO `grid50000` VALUES ('5552', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('5553', '1437', '83811843');
INSERT INTO `grid50000` VALUES ('5554', 'anarchy', '83811843');
INSERT INTO `grid50000` VALUES ('5555', 'reigned', '83811843');
INSERT INTO `grid50000` VALUES ('5556', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('5557', 'Bohemia', '83811843');
INSERT INTO `grid50000` VALUES ('5558', '\r\n\r\nThen', '83811843');
INSERT INTO `grid50000` VALUES ('5559', 'after', '83811843');
INSERT INTO `grid50000` VALUES ('5560', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5561', 'very', '83811843');
INSERT INTO `grid50000` VALUES ('5562', 'brief', '83811843');
INSERT INTO `grid50000` VALUES ('5563', 'rule', '83811843');
INSERT INTO `grid50000` VALUES ('5564', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('5565', 'Ladislav', '83811843');
INSERT INTO `grid50000` VALUES ('5566', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5567', 'Posthumous', '83811843');
INSERT INTO `grid50000` VALUES ('5568', '14537', '83811843');
INSERT INTO `grid50000` VALUES ('5569', '', '83811843');
INSERT INTO `grid50000` VALUES ('5570', 'so', '83811843');
INSERT INTO `grid50000` VALUES ('5571', 'named', '83811843');
INSERT INTO `grid50000` VALUES ('5572', 'because', '83811843');
INSERT INTO `grid50000` VALUES ('5573', 'he', '83811843');
INSERT INTO `grid50000` VALUES ('5574', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('5575', 'born', '83811843');
INSERT INTO `grid50000` VALUES ('5576', 'after', '83811843');
INSERT INTO `grid50000` VALUES ('5577', 'his', '83811843');
INSERT INTO `grid50000` VALUES ('5578', 'father', '83811843');
INSERT INTO `grid50000` VALUES ('5579', 'had', '83811843');
INSERT INTO `grid50000` VALUES ('5580', 'died', '83811843');
INSERT INTO `grid50000` VALUES ('5581', '', '83811843');
INSERT INTO `grid50000` VALUES ('5582', '', '83811843');
INSERT INTO `grid50000` VALUES ('5583', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5584', 'Bohemian', '83811843');
INSERT INTO `grid50000` VALUES ('5585', 'throne', '83811843');
INSERT INTO `grid50000` VALUES ('5586', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('5587', 'occupied', '83811843');
INSERT INTO `grid50000` VALUES ('5588', 'by', '83811843');
INSERT INTO `grid50000` VALUES ('5589', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5590', 'heretic', '83811843');
INSERT INTO `grid50000` VALUES ('5591', 'King', '83811843');
INSERT INTO `grid50000` VALUES ('5592', 'George', '83811843');
INSERT INTO `grid50000` VALUES ('5593', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('5594', 'Podebrady', '83811843');
INSERT INTO `grid50000` VALUES ('5595', '145871', '83811843');
INSERT INTO `grid50000` VALUES ('5596', 'George', '83811843');
INSERT INTO `grid50000` VALUES ('5597', 'also', '83811843');
INSERT INTO `grid50000` VALUES ('5598', 'known', '83811843');
INSERT INTO `grid50000` VALUES ('5599', 'as', '83811843');
INSERT INTO `grid50000` VALUES ('5600', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5601', 'Hussite', '83811843');
INSERT INTO `grid50000` VALUES ('5602', 'King', '83811843');
INSERT INTO `grid50000` VALUES ('5603', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('5604', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5605', 'first', '83811843');
INSERT INTO `grid50000` VALUES ('5606', 'freelyelected', '83811843');
INSERT INTO `grid50000` VALUES ('5607', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('5608', 'ruler', '83811843');
INSERT INTO `grid50000` VALUES ('5609', 'He', '83811843');
INSERT INTO `grid50000` VALUES ('5610', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('5611', 'chosen', '83811843');
INSERT INTO `grid50000` VALUES ('5612', 'as', '83811843');
INSERT INTO `grid50000` VALUES ('5613', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('5614', 'King', '83811843');
INSERT INTO `grid50000` VALUES ('5615', 'from', '83811843');
INSERT INTO `grid50000` VALUES ('5616', 'among', '83811843');
INSERT INTO `grid50000` VALUES ('5617', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5618', 'countrys', '83811843');
INSERT INTO `grid50000` VALUES ('5619', 'nobility', '83811843');
INSERT INTO `grid50000` VALUES ('5620', 'without', '83811843');
INSERT INTO `grid50000` VALUES ('5621', 'regard', '83811843');
INSERT INTO `grid50000` VALUES ('5622', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('5623', 'any', '83811843');
INSERT INTO `grid50000` VALUES ('5624', 'previous', '83811843');
INSERT INTO `grid50000` VALUES ('5625', 'agreements', '83811843');
INSERT INTO `grid50000` VALUES ('5626', 'hereditary', '83811843');
INSERT INTO `grid50000` VALUES ('5627', 'claim', '83811843');
INSERT INTO `grid50000` VALUES ('5628', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('5629', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5630', 'throne', '83811843');
INSERT INTO `grid50000` VALUES ('5631', 'family', '83811843');
INSERT INTO `grid50000` VALUES ('5632', 'connections', '83811843');
INSERT INTO `grid50000` VALUES ('5633', 'or', '83811843');
INSERT INTO `grid50000` VALUES ('5634', 'dynastic', '83811843');
INSERT INTO `grid50000` VALUES ('5635', 'origin', '83811843');
INSERT INTO `grid50000` VALUES ('5636', 'George', '83811843');
INSERT INTO `grid50000` VALUES ('5637', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('5638', 'Podebrady', '83811843');
INSERT INTO `grid50000` VALUES ('5639', 'won', '83811843');
INSERT INTO `grid50000` VALUES ('5640', 'recognition', '83811843');
INSERT INTO `grid50000` VALUES ('5641', 'throughout', '83811843');
INSERT INTO `grid50000` VALUES ('5642', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5643', 'Lands', '83811843');
INSERT INTO `grid50000` VALUES ('5644', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('5645', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5646', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('5647', 'Crown', '83811843');
INSERT INTO `grid50000` VALUES ('5648', 'through', '83811843');
INSERT INTO `grid50000` VALUES ('5649', 'his', '83811843');
INSERT INTO `grid50000` VALUES ('5650', 'skillful', '83811843');
INSERT INTO `grid50000` VALUES ('5651', 'diplomacy', '83811843');
INSERT INTO `grid50000` VALUES ('5652', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('5653', 'gained', '83811843');
INSERT INTO `grid50000` VALUES ('5654', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5655', 'respect', '83811843');
INSERT INTO `grid50000` VALUES ('5656', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('5657', 'all', '83811843');
INSERT INTO `grid50000` VALUES ('5658', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('5659', 'Central', '83811843');
INSERT INTO `grid50000` VALUES ('5660', 'Europe', '83811843');
INSERT INTO `grid50000` VALUES ('5661', 'He', '83811843');
INSERT INTO `grid50000` VALUES ('5662', 'also', '83811843');
INSERT INTO `grid50000` VALUES ('5663', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('5664', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5665', '15th', '83811843');
INSERT INTO `grid50000` VALUES ('5666', 'century', '83811843');
INSERT INTO `grid50000` VALUES ('5667', 'authored', '83811843');
INSERT INTO `grid50000` VALUES ('5668', 'an', '83811843');
INSERT INTO `grid50000` VALUES ('5669', 'ambitious', '83811843');
INSERT INTO `grid50000` VALUES ('5670', 'Peace', '83811843');
INSERT INTO `grid50000` VALUES ('5671', 'Plan', '83811843');
INSERT INTO `grid50000` VALUES ('5672', 'for', '83811843');
INSERT INTO `grid50000` VALUES ('5673', 'all', '83811843');
INSERT INTO `grid50000` VALUES ('5674', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('5675', 'Europe', '83811843');
INSERT INTO `grid50000` VALUES ('5676', 'sort', '83811843');
INSERT INTO `grid50000` VALUES ('5677', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('5678', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('5679', 'medeival', '83811843');
INSERT INTO `grid50000` VALUES ('5680', 'equivalent', '83811843');
INSERT INTO `grid50000` VALUES ('5681', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('5682', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('5683', 'NATOlike', '83811843');
INSERT INTO `grid50000` VALUES ('5684', 'organization', '83811843');
INSERT INTO `grid50000` VALUES ('5685', '\r\n\r\nBut', '83811843');
INSERT INTO `grid50000` VALUES ('5686', 'few', '83811843');
INSERT INTO `grid50000` VALUES ('5687', 'people', '83811843');
INSERT INTO `grid50000` VALUES ('5688', 'then', '83811843');
INSERT INTO `grid50000` VALUES ('5689', 'as', '83811843');
INSERT INTO `grid50000` VALUES ('5690', 'now', '83811843');
INSERT INTO `grid50000` VALUES ('5691', 'were', '83811843');
INSERT INTO `grid50000` VALUES ('5692', 'interested', '83811843');
INSERT INTO `grid50000` VALUES ('5693', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('5694', 'peace', '83811843');
INSERT INTO `grid50000` VALUES ('5695', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('5696', 'nobody', '83811843');
INSERT INTO `grid50000` VALUES ('5697', 'subscribed', '83811843');
INSERT INTO `grid50000` VALUES ('5698', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('5699', 'his', '83811843');
INSERT INTO `grid50000` VALUES ('5700', 'plan', '83811843');
INSERT INTO `grid50000` VALUES ('5701', 'On', '83811843');
INSERT INTO `grid50000` VALUES ('5702', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5703', 'contrary', '83811843');
INSERT INTO `grid50000` VALUES ('5704', '', '83811843');
INSERT INTO `grid50000` VALUES ('5705', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5706', 'Hungarian', '83811843');
INSERT INTO `grid50000` VALUES ('5707', 'monarch', '83811843');
INSERT INTO `grid50000` VALUES ('5708', 'at', '83811843');
INSERT INTO `grid50000` VALUES ('5709', 'this', '83811843');
INSERT INTO `grid50000` VALUES ('5710', 'time', '83811843');
INSERT INTO `grid50000` VALUES ('5711', 'Matthias', '83811843');
INSERT INTO `grid50000` VALUES ('5712', 'Corvinus', '83811843');
INSERT INTO `grid50000` VALUES ('5713', '', '83811843');
INSERT INTO `grid50000` VALUES ('5714', 'with', '83811843');
INSERT INTO `grid50000` VALUES ('5715', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5716', 'support', '83811843');
INSERT INTO `grid50000` VALUES ('5717', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('5718', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5719', 'disgruntled', '83811843');
INSERT INTO `grid50000` VALUES ('5720', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('5721', 'Catholic', '83811843');
INSERT INTO `grid50000` VALUES ('5722', 'opposition', '83811843');
INSERT INTO `grid50000` VALUES ('5723', 'who', '83811843');
INSERT INTO `grid50000` VALUES ('5724', 'didnt', '83811843');
INSERT INTO `grid50000` VALUES ('5725', 'like', '83811843');
INSERT INTO `grid50000` VALUES ('5726', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5727', 'idea', '83811843');
INSERT INTO `grid50000` VALUES ('5728', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('5729', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('5730', 'Protestant', '83811843');
INSERT INTO `grid50000` VALUES ('5731', 'on', '83811843');
INSERT INTO `grid50000` VALUES ('5732', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5733', 'throne', '83811843');
INSERT INTO `grid50000` VALUES ('5734', '', '83811843');
INSERT INTO `grid50000` VALUES ('5735', 'declared', '83811843');
INSERT INTO `grid50000` VALUES ('5736', 'war', '83811843');
INSERT INTO `grid50000` VALUES ('5737', 'against', '83811843');
INSERT INTO `grid50000` VALUES ('5738', 'George', '83811843');
INSERT INTO `grid50000` VALUES ('5739', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('5740', 'Podebrady', '83811843');
INSERT INTO `grid50000` VALUES ('5741', 'who', '83811843');
INSERT INTO `grid50000` VALUES ('5742', 'happened', '83811843');
INSERT INTO `grid50000` VALUES ('5743', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('5744', 'be', '83811843');
INSERT INTO `grid50000` VALUES ('5745', 'Matthias', '83811843');
INSERT INTO `grid50000` VALUES ('5746', 'fatherinlaw', '83811843');
INSERT INTO `grid50000` VALUES ('5747', 'The', '83811843');
INSERT INTO `grid50000` VALUES ('5748', 'Hungarian', '83811843');
INSERT INTO `grid50000` VALUES ('5749', 'campaigns', '83811843');
INSERT INTO `grid50000` VALUES ('5750', 'against', '83811843');
INSERT INTO `grid50000` VALUES ('5751', 'Bohemia', '83811843');
INSERT INTO `grid50000` VALUES ('5752', 'ceased', '83811843');
INSERT INTO `grid50000` VALUES ('5753', 'only', '83811843');
INSERT INTO `grid50000` VALUES ('5754', 'after', '83811843');
INSERT INTO `grid50000` VALUES ('5755', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5756', 'death', '83811843');
INSERT INTO `grid50000` VALUES ('5757', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('5758', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5759', 'beloved', '83811843');
INSERT INTO `grid50000` VALUES ('5760', 'Hussite', '83811843');
INSERT INTO `grid50000` VALUES ('5761', 'King', '83811843');
INSERT INTO `grid50000` VALUES ('5762', 'George', '83811843');
INSERT INTO `grid50000` VALUES ('5763', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('5764', 'Podebrady', '83811843');
INSERT INTO `grid50000` VALUES ('5765', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('5766', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5767', 'ascent', '83811843');
INSERT INTO `grid50000` VALUES ('5768', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('5769', 'Vladislav', '83811843');
INSERT INTO `grid50000` VALUES ('5770', 'Jagellon', '83811843');
INSERT INTO `grid50000` VALUES ('5771', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('5772', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5773', 'throne', '83811843');
INSERT INTO `grid50000` VALUES ('5774', '\r\n\r\nCzechSlovak', '83811843');
INSERT INTO `grid50000` VALUES ('5775', 'relations', '83811843');
INSERT INTO `grid50000` VALUES ('5776', 'were', '83811843');
INSERT INTO `grid50000` VALUES ('5777', 'strengthened', '83811843');
INSERT INTO `grid50000` VALUES ('5778', 'at', '83811843');
INSERT INTO `grid50000` VALUES ('5779', 'this', '83811843');
INSERT INTO `grid50000` VALUES ('5780', 'time', '83811843');
INSERT INTO `grid50000` VALUES ('5781', 'with', '83811843');
INSERT INTO `grid50000` VALUES ('5782', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5783', 'forming', '83811843');
INSERT INTO `grid50000` VALUES ('5784', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('5785', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5786', 'CzechHungarian', '83811843');
INSERT INTO `grid50000` VALUES ('5787', 'union', '83811843');
INSERT INTO `grid50000` VALUES ('5788', 'under', '83811843');
INSERT INTO `grid50000` VALUES ('5789', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5790', 'Jagellons', '83811843');
INSERT INTO `grid50000` VALUES ('5791', 'after', '83811843');
INSERT INTO `grid50000` VALUES ('5792', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5793', 'death', '83811843');
INSERT INTO `grid50000` VALUES ('5794', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('5795', 'Matthias', '83811843');
INSERT INTO `grid50000` VALUES ('5796', 'Corvinus', '83811843');
INSERT INTO `grid50000` VALUES ('5797', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('5798', '1490;', '83811843');
INSERT INTO `grid50000` VALUES ('5799', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('5800', 'after', '83811843');
INSERT INTO `grid50000` VALUES ('5801', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5802', 'Kralice', '83811843');
INSERT INTO `grid50000` VALUES ('5803', 'Bible', '83811843');
INSERT INTO `grid50000` VALUES ('5804', 'began', '83811843');
INSERT INTO `grid50000` VALUES ('5805', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('5806', 'be', '83811843');
INSERT INTO `grid50000` VALUES ('5807', 'used', '83811843');
INSERT INTO `grid50000` VALUES ('5808', 'by', '83811843');
INSERT INTO `grid50000` VALUES ('5809', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5810', 'Slovak', '83811843');
INSERT INTO `grid50000` VALUES ('5811', 'Evangelical', '83811843');
INSERT INTO `grid50000` VALUES ('5812', 'Church', '83811843');
INSERT INTO `grid50000` VALUES ('5813', '\r\n\r\nIn', '83811843');
INSERT INTO `grid50000` VALUES ('5814', 'spite', '83811843');
INSERT INTO `grid50000` VALUES ('5815', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('5816', 'conflicts', '83811843');
INSERT INTO `grid50000` VALUES ('5817', 'both', '83811843');
INSERT INTO `grid50000` VALUES ('5818', 'foreign', '83811843');
INSERT INTO `grid50000` VALUES ('5819', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('5820', 'domestic', '83811843');
INSERT INTO `grid50000` VALUES ('5821', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('5822', 'even', '83811843');
INSERT INTO `grid50000` VALUES ('5823', 'under', '83811843');
INSERT INTO `grid50000` VALUES ('5824', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5825', 'rule', '83811843');
INSERT INTO `grid50000` VALUES ('5826', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('5827', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5828', 'Jagellon', '83811843');
INSERT INTO `grid50000` VALUES ('5829', 'dynastys', '83811843');
INSERT INTO `grid50000` VALUES ('5830', 'two', '83811843');
INSERT INTO `grid50000` VALUES ('5831', 'Catholic', '83811843');
INSERT INTO `grid50000` VALUES ('5832', 'kings', '83811843');
INSERT INTO `grid50000` VALUES ('5833', 'Vladislav', '83811843');
INSERT INTO `grid50000` VALUES ('5834', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('5835', 'Ludwig', '83811843');
INSERT INTO `grid50000` VALUES ('5836', 'religious', '83811843');
INSERT INTO `grid50000` VALUES ('5837', 'pluralism', '83811843');
INSERT INTO `grid50000` VALUES ('5838', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('5839', 'freedom', '83811843');
INSERT INTO `grid50000` VALUES ('5840', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('5841', 'religion', '83811843');
INSERT INTO `grid50000` VALUES ('5842', 'were', '83811843');
INSERT INTO `grid50000` VALUES ('5843', 'maintained', '83811843');
INSERT INTO `grid50000` VALUES ('5844', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('5845', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5846', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('5847', 'lands', '83811843');
INSERT INTO `grid50000` VALUES ('5848', 'with', '83811843');
INSERT INTO `grid50000` VALUES ('5849', 'Protestants', '83811843');
INSERT INTO `grid50000` VALUES ('5850', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('5851', 'Catholics', '83811843');
INSERT INTO `grid50000` VALUES ('5852', 'living', '83811843');
INSERT INTO `grid50000` VALUES ('5853', 'together', '83811843');
INSERT INTO `grid50000` VALUES ('5854', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('5855', 'harmony', '83811843');
INSERT INTO `grid50000` VALUES ('5856', 'All', '83811843');
INSERT INTO `grid50000` VALUES ('5857', 'during', '83811843');
INSERT INTO `grid50000` VALUES ('5858', 'this', '83811843');
INSERT INTO `grid50000` VALUES ('5859', 'time', '83811843');
INSERT INTO `grid50000` VALUES ('5860', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('5861', 'weak', '83811843');
INSERT INTO `grid50000` VALUES ('5862', 'royal', '83811843');
INSERT INTO `grid50000` VALUES ('5863', 'leadership', '83811843');
INSERT INTO `grid50000` VALUES ('5864', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5865', 'power', '83811843');
INSERT INTO `grid50000` VALUES ('5866', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('5867', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5868', 'nobility', '83811843');
INSERT INTO `grid50000` VALUES ('5869', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('5870', 'towns', '83811843');
INSERT INTO `grid50000` VALUES ('5871', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5872', 'Estates', '83811843');
INSERT INTO `grid50000` VALUES ('5873', 'continued', '83811843');
INSERT INTO `grid50000` VALUES ('5874', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('5875', 'increase', '83811843');
INSERT INTO `grid50000` VALUES ('5876', '', '83811843');
INSERT INTO `grid50000` VALUES ('5877', 'even', '83811843');
INSERT INTO `grid50000` VALUES ('5878', 'as', '83811843');
INSERT INTO `grid50000` VALUES ('5879', 'central', '83811843');
INSERT INTO `grid50000` VALUES ('5880', 'authority', '83811843');
INSERT INTO `grid50000` VALUES ('5881', 'diminished', '83811843');
INSERT INTO `grid50000` VALUES ('5882', '\r\n\r\nWith', '83811843');
INSERT INTO `grid50000` VALUES ('5883', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5884', 'death', '83811843');
INSERT INTO `grid50000` VALUES ('5885', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('5886', 'Ludwig', '83811843');
INSERT INTO `grid50000` VALUES ('5887', 'Jagellon', '83811843');
INSERT INTO `grid50000` VALUES ('5888', 'he', '83811843');
INSERT INTO `grid50000` VALUES ('5889', 'drowned', '83811843');
INSERT INTO `grid50000` VALUES ('5890', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('5891', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('5892', 'swamp', '83811843');
INSERT INTO `grid50000` VALUES ('5893', 'running', '83811843');
INSERT INTO `grid50000` VALUES ('5894', 'away', '83811843');
INSERT INTO `grid50000` VALUES ('5895', 'from', '83811843');
INSERT INTO `grid50000` VALUES ('5896', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5897', 'Turks', '83811843');
INSERT INTO `grid50000` VALUES ('5898', 'at', '83811843');
INSERT INTO `grid50000` VALUES ('5899', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5900', 'Battle', '83811843');
INSERT INTO `grid50000` VALUES ('5901', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('5902', 'Mohacs', '83811843');
INSERT INTO `grid50000` VALUES ('5903', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('5904', '1526', '83811843');
INSERT INTO `grid50000` VALUES ('5905', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5906', 'shortlived', '83811843');
INSERT INTO `grid50000` VALUES ('5907', 'CzechHungarian', '83811843');
INSERT INTO `grid50000` VALUES ('5908', 'Union', '83811843');
INSERT INTO `grid50000` VALUES ('5909', 'fell', '83811843');
INSERT INTO `grid50000` VALUES ('5910', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('5911', 'pieces', '83811843');
INSERT INTO `grid50000` VALUES ('5912', 'leaving', '83811843');
INSERT INTO `grid50000` VALUES ('5913', 'both', '83811843');
INSERT INTO `grid50000` VALUES ('5914', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5915', 'Bohemian', '83811843');
INSERT INTO `grid50000` VALUES ('5916', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('5917', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5918', 'Hungarian', '83811843');
INSERT INTO `grid50000` VALUES ('5919', 'thrones', '83811843');
INSERT INTO `grid50000` VALUES ('5920', 'unoccupied', '83811843');
INSERT INTO `grid50000` VALUES ('5921', '\r\n\r\nWhat', '83811843');
INSERT INTO `grid50000` VALUES ('5922', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('5923', 'window', '83811843');
INSERT INTO `grid50000` VALUES ('5924', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('5925', 'opportunity', '83811843');
INSERT INTO `grid50000` VALUES ('5926', 'for', '83811843');
INSERT INTO `grid50000` VALUES ('5927', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5928', 'Austrian', '83811843');
INSERT INTO `grid50000` VALUES ('5929', 'Habsburgs!', '83811843');
INSERT INTO `grid50000` VALUES ('5930', 'That', '83811843');
INSERT INTO `grid50000` VALUES ('5931', 'Ferdinand', '83811843');
INSERT INTO `grid50000` VALUES ('5932', 'I', '83811843');
INSERT INTO `grid50000` VALUES ('5933', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('5934', 'Habsburg', '83811843');
INSERT INTO `grid50000` VALUES ('5935', 'also', '83811843');
INSERT INTO `grid50000` VALUES ('5936', 'happened', '83811843');
INSERT INTO `grid50000` VALUES ('5937', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('5938', 'be', '83811843');
INSERT INTO `grid50000` VALUES ('5939', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5940', 'late', '83811843');
INSERT INTO `grid50000` VALUES ('5941', 'Ludwig', '83811843');
INSERT INTO `grid50000` VALUES ('5942', 'Jagellons', '83811843');
INSERT INTO `grid50000` VALUES ('5943', 'brotherinlaw', '83811843');
INSERT INTO `grid50000` VALUES ('5944', 'helped', '83811843');
INSERT INTO `grid50000` VALUES ('5945', 'his', '83811843');
INSERT INTO `grid50000` VALUES ('5946', 'claim', '83811843');
INSERT INTO `grid50000` VALUES ('5947', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('5948', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5949', 'Bohemain', '83811843');
INSERT INTO `grid50000` VALUES ('5950', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('5951', 'Hungarian', '83811843');
INSERT INTO `grid50000` VALUES ('5952', 'thrones', '83811843');
INSERT INTO `grid50000` VALUES ('5953', 'In', '83811843');
INSERT INTO `grid50000` VALUES ('5954', 'Bohemia', '83811843');
INSERT INTO `grid50000` VALUES ('5955', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5956', 'weakened', '83811843');
INSERT INTO `grid50000` VALUES ('5957', 'central', '83811843');
INSERT INTO `grid50000` VALUES ('5958', 'authority', '83811843');
INSERT INTO `grid50000` VALUES ('5959', 'did', '83811843');
INSERT INTO `grid50000` VALUES ('5960', 'too', '83811843');
INSERT INTO `grid50000` VALUES ('5961', 'At', '83811843');
INSERT INTO `grid50000` VALUES ('5962', 'first', '83811843');
INSERT INTO `grid50000` VALUES ('5963', 'Ferdinand', '83811843');
INSERT INTO `grid50000` VALUES ('5964', 'made', '83811843');
INSERT INTO `grid50000` VALUES ('5965', 'concessions', '83811843');
INSERT INTO `grid50000` VALUES ('5966', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('5967', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5968', 'everpowerful', '83811843');
INSERT INTO `grid50000` VALUES ('5969', 'Estates', '83811843');
INSERT INTO `grid50000` VALUES ('5970', 'Soon', '83811843');
INSERT INTO `grid50000` VALUES ('5971', 'however', '83811843');
INSERT INTO `grid50000` VALUES ('5972', 'he', '83811843');
INSERT INTO `grid50000` VALUES ('5973', 'began', '83811843');
INSERT INTO `grid50000` VALUES ('5974', 'systematically', '83811843');
INSERT INTO `grid50000` VALUES ('5975', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('5976', 'weaken', '83811843');
INSERT INTO `grid50000` VALUES ('5977', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5978', 'authority', '83811843');
INSERT INTO `grid50000` VALUES ('5979', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('5980', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5981', 'regional', '83811843');
INSERT INTO `grid50000` VALUES ('5982', 'nobility', '83811843');
INSERT INTO `grid50000` VALUES ('5983', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('5984', 'towns', '83811843');
INSERT INTO `grid50000` VALUES ('5985', 'His', '83811843');
INSERT INTO `grid50000` VALUES ('5986', 'attempts', '83811843');
INSERT INTO `grid50000` VALUES ('5987', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('5988', 'increase', '83811843');
INSERT INTO `grid50000` VALUES ('5989', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5990', 'central', '83811843');
INSERT INTO `grid50000` VALUES ('5991', 'power', '83811843');
INSERT INTO `grid50000` VALUES ('5992', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('5993', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5994', 'Crown', '83811843');
INSERT INTO `grid50000` VALUES ('5995', 'naturally', '83811843');
INSERT INTO `grid50000` VALUES ('5996', 'met', '83811843');
INSERT INTO `grid50000` VALUES ('5997', 'with', '83811843');
INSERT INTO `grid50000` VALUES ('5998', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('5999', 'opposition', '83811843');
INSERT INTO `grid50000` VALUES ('6000', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('6001', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6002', 'Estates', '83811843');
INSERT INTO `grid50000` VALUES ('6003', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('6004', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6005', 'whole', '83811843');
INSERT INTO `grid50000` VALUES ('6006', 'situation', '83811843');
INSERT INTO `grid50000` VALUES ('6007', 'culminated', '83811843');
INSERT INTO `grid50000` VALUES ('6008', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('6009', 'an', '83811843');
INSERT INTO `grid50000` VALUES ('6010', 'unsuccesful', '83811843');
INSERT INTO `grid50000` VALUES ('6011', 'rebellion', '83811843');
INSERT INTO `grid50000` VALUES ('6012', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('6013', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6014', 'Estates', '83811843');
INSERT INTO `grid50000` VALUES ('6015', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('6016', '1547', '83811843');
INSERT INTO `grid50000` VALUES ('6017', '\r\n\r\nThe', '83811843');
INSERT INTO `grid50000` VALUES ('6018', 'Estates', '83811843');
INSERT INTO `grid50000` VALUES ('6019', 'failure', '83811843');
INSERT INTO `grid50000` VALUES ('6020', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('6021', 'Ferdinands', '83811843');
INSERT INTO `grid50000` VALUES ('6022', 'gain', '83811843');
INSERT INTO `grid50000` VALUES ('6023', 'He', '83811843');
INSERT INTO `grid50000` VALUES ('6024', 'used', '83811843');
INSERT INTO `grid50000` VALUES ('6025', 'this', '83811843');
INSERT INTO `grid50000` VALUES ('6026', 'victory', '83811843');
INSERT INTO `grid50000` VALUES ('6027', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('6028', 'increase', '83811843');
INSERT INTO `grid50000` VALUES ('6029', 'royal', '83811843');
INSERT INTO `grid50000` VALUES ('6030', 'authority', '83811843');
INSERT INTO `grid50000` VALUES ('6031', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('6032', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('6033', 'weaken', '83811843');
INSERT INTO `grid50000` VALUES ('6034', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6035', 'position', '83811843');
INSERT INTO `grid50000` VALUES ('6036', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('6037', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6038', 'Estates', '83811843');
INSERT INTO `grid50000` VALUES ('6039', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('6040', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6041', 'towns', '83811843');
INSERT INTO `grid50000` VALUES ('6042', 'even', '83811843');
INSERT INTO `grid50000` VALUES ('6043', 'more', '83811843');
INSERT INTO `grid50000` VALUES ('6044', 'He', '83811843');
INSERT INTO `grid50000` VALUES ('6045', 'also', '83811843');
INSERT INTO `grid50000` VALUES ('6046', 'invited', '83811843');
INSERT INTO `grid50000` VALUES ('6047', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6048', 'Jesuits', '83811843');
INSERT INTO `grid50000` VALUES ('6049', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('6050', 'come', '83811843');
INSERT INTO `grid50000` VALUES ('6051', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('6052', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6053', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('6054', 'lands', '83811843');
INSERT INTO `grid50000` VALUES ('6055', 'though', '83811843');
INSERT INTO `grid50000` VALUES ('6056', 'they', '83811843');
INSERT INTO `grid50000` VALUES ('6057', 'never', '83811843');
INSERT INTO `grid50000` VALUES ('6058', 'held', '83811843');
INSERT INTO `grid50000` VALUES ('6059', 'any', '83811843');
INSERT INTO `grid50000` VALUES ('6060', 'inquisitions', '83811843');
INSERT INTO `grid50000` VALUES ('6061', 'here', '83811843');
INSERT INTO `grid50000` VALUES ('6062', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('6063', 'generally', '83811843');
INSERT INTO `grid50000` VALUES ('6064', 'did', '83811843');
INSERT INTO `grid50000` VALUES ('6065', 'not', '83811843');
INSERT INTO `grid50000` VALUES ('6066', 'meddle', '83811843');
INSERT INTO `grid50000` VALUES ('6067', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('6068', 'public', '83811843');
INSERT INTO `grid50000` VALUES ('6069', 'affairs', '83811843');
INSERT INTO `grid50000` VALUES ('6070', 'Ostensibly', '83811843');
INSERT INTO `grid50000` VALUES ('6071', 'fighting', '83811843');
INSERT INTO `grid50000` VALUES ('6072', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('6073', 'maintain', '83811843');
INSERT INTO `grid50000` VALUES ('6074', 'freedom', '83811843');
INSERT INTO `grid50000` VALUES ('6075', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('6076', 'religion', '83811843');
INSERT INTO `grid50000` VALUES ('6077', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('6078', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6079', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('6080', 'lands', '83811843');
INSERT INTO `grid50000` VALUES ('6081', 'against', '83811843');
INSERT INTO `grid50000` VALUES ('6082', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6083', 'resolutely', '83811843');
INSERT INTO `grid50000` VALUES ('6084', 'Catholic', '83811843');
INSERT INTO `grid50000` VALUES ('6085', 'policies', '83811843');
INSERT INTO `grid50000` VALUES ('6086', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('6087', 'Ferdinand', '83811843');
INSERT INTO `grid50000` VALUES ('6088', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6089', 'Estates', '83811843');
INSERT INTO `grid50000` VALUES ('6090', 'struggled', '83811843');
INSERT INTO `grid50000` VALUES ('6091', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('6092', 'regain', '83811843');
INSERT INTO `grid50000` VALUES ('6093', 'their', '83811843');
INSERT INTO `grid50000` VALUES ('6094', 'former', '83811843');
INSERT INTO `grid50000` VALUES ('6095', 'power', '83811843');
INSERT INTO `grid50000` VALUES ('6096', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('6097', 'influence', '83811843');
INSERT INTO `grid50000` VALUES ('6098', '\r\n\r\nThese', '83811843');
INSERT INTO `grid50000` VALUES ('6099', 'conflicts', '83811843');
INSERT INTO `grid50000` VALUES ('6100', 'simmered', '83811843');
INSERT INTO `grid50000` VALUES ('6101', 'under', '83811843');
INSERT INTO `grid50000` VALUES ('6102', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6103', 'surface', '83811843');
INSERT INTO `grid50000` VALUES ('6104', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('6105', 'things', '83811843');
INSERT INTO `grid50000` VALUES ('6106', 'as', '83811843');
INSERT INTO `grid50000` VALUES ('6107', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6108', 'Renaissance', '83811843');
INSERT INTO `grid50000` VALUES ('6109', 'swept', '83811843');
INSERT INTO `grid50000` VALUES ('6110', 'through', '83811843');
INSERT INTO `grid50000` VALUES ('6111', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6112', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('6113', 'lands', '83811843');
INSERT INTO `grid50000` VALUES ('6114', '\r\n\r\n', '83811843');
INSERT INTO `grid50000` VALUES ('6115', 'Ferdinand', '83811843');
INSERT INTO `grid50000` VALUES ('6116', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('6117', 'succeeded', '83811843');
INSERT INTO `grid50000` VALUES ('6118', 'by', '83811843');
INSERT INTO `grid50000` VALUES ('6119', 'Maxmilian', '83811843');
INSERT INTO `grid50000` VALUES ('6120', 'II', '83811843');
INSERT INTO `grid50000` VALUES ('6121', 'who', '83811843');
INSERT INTO `grid50000` VALUES ('6122', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('6123', 'succeeded', '83811843');
INSERT INTO `grid50000` VALUES ('6124', 'by', '83811843');
INSERT INTO `grid50000` VALUES ('6125', 'Rudolf', '83811843');
INSERT INTO `grid50000` VALUES ('6126', 'II', '83811843');
INSERT INTO `grid50000` VALUES ('6127', 'After', '83811843');
INSERT INTO `grid50000` VALUES ('6128', 'assuming', '83811843');
INSERT INTO `grid50000` VALUES ('6129', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6130', 'Austrian', '83811843');
INSERT INTO `grid50000` VALUES ('6131', 'throne', '83811843');
INSERT INTO `grid50000` VALUES ('6132', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6133', 'Habsburg', '83811843');
INSERT INTO `grid50000` VALUES ('6134', 'ruler', '83811843');
INSERT INTO `grid50000` VALUES ('6135', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('6136', 'patron', '83811843');
INSERT INTO `grid50000` VALUES ('6137', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('6138', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6139', 'arts', '83811843');
INSERT INTO `grid50000` VALUES ('6140', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('6141', 'sciences', '83811843');
INSERT INTO `grid50000` VALUES ('6142', 'Rudolf', '83811843');
INSERT INTO `grid50000` VALUES ('6143', 'II', '83811843');
INSERT INTO `grid50000` VALUES ('6144', '15761611', '83811843');
INSERT INTO `grid50000` VALUES ('6145', '', '83811843');
INSERT INTO `grid50000` VALUES ('6146', 'moved', '83811843');
INSERT INTO `grid50000` VALUES ('6147', 'his', '83811843');
INSERT INTO `grid50000` VALUES ('6148', 'court', '83811843');
INSERT INTO `grid50000` VALUES ('6149', 'from', '83811843');
INSERT INTO `grid50000` VALUES ('6150', 'Vienna', '83811843');
INSERT INTO `grid50000` VALUES ('6151', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('6152', 'Prague', '83811843');
INSERT INTO `grid50000` VALUES ('6153', '', '83811843');
INSERT INTO `grid50000` VALUES ('6154', 'making', '83811843');
INSERT INTO `grid50000` VALUES ('6155', 'him', '83811843');
INSERT INTO `grid50000` VALUES ('6156', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6157', 'last', '83811843');
INSERT INTO `grid50000` VALUES ('6158', 'crowned', '83811843');
INSERT INTO `grid50000` VALUES ('6159', 'King', '83811843');
INSERT INTO `grid50000` VALUES ('6160', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('6161', 'Bohemia', '83811843');
INSERT INTO `grid50000` VALUES ('6162', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('6163', 'live', '83811843');
INSERT INTO `grid50000` VALUES ('6164', 'at', '83811843');
INSERT INTO `grid50000` VALUES ('6165', 'Prague', '83811843');
INSERT INTO `grid50000` VALUES ('6166', 'Castle', '83811843');
INSERT INTO `grid50000` VALUES ('6167', 'Rudolf', '83811843');
INSERT INTO `grid50000` VALUES ('6168', 'II', '83811843');
INSERT INTO `grid50000` VALUES ('6169', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('6170', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('6171', 'real', '83811843');
INSERT INTO `grid50000` VALUES ('6172', 'character', '83811843');
INSERT INTO `grid50000` VALUES ('6173', 'He', '83811843');
INSERT INTO `grid50000` VALUES ('6174', 'had', '83811843');
INSERT INTO `grid50000` VALUES ('6175', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('6176', 'pet', '83811843');
INSERT INTO `grid50000` VALUES ('6177', 'lion', '83811843');
INSERT INTO `grid50000` VALUES ('6178', 'he', '83811843');
INSERT INTO `grid50000` VALUES ('6179', 'collected', '83811843');
INSERT INTO `grid50000` VALUES ('6180', 'great', '83811843');
INSERT INTO `grid50000` VALUES ('6181', 'art', '83811843');
INSERT INTO `grid50000` VALUES ('6182', '', '83811843');
INSERT INTO `grid50000` VALUES ('6183', 'including', '83811843');
INSERT INTO `grid50000` VALUES ('6184', 'works', '83811843');
INSERT INTO `grid50000` VALUES ('6185', 'by', '83811843');
INSERT INTO `grid50000` VALUES ('6186', 'Da', '83811843');
INSERT INTO `grid50000` VALUES ('6187', 'Vinci', '83811843');
INSERT INTO `grid50000` VALUES ('6188', 'Michaelangelo', '83811843');
INSERT INTO `grid50000` VALUES ('6189', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('6190', 'Rafael', '83811843');
INSERT INTO `grid50000` VALUES ('6191', '', '83811843');
INSERT INTO `grid50000` VALUES ('6192', 'he', '83811843');
INSERT INTO `grid50000` VALUES ('6193', 'supported', '83811843');
INSERT INTO `grid50000` VALUES ('6194', 'scientists', '83811843');
INSERT INTO `grid50000` VALUES ('6195', 'such', '83811843');
INSERT INTO `grid50000` VALUES ('6196', 'as', '83811843');
INSERT INTO `grid50000` VALUES ('6197', 'Tycho', '83811843');
INSERT INTO `grid50000` VALUES ('6198', 'de', '83811843');
INSERT INTO `grid50000` VALUES ('6199', 'Brahe', '83811843');
INSERT INTO `grid50000` VALUES ('6200', 'Johannes', '83811843');
INSERT INTO `grid50000` VALUES ('6201', 'Kepler', '83811843');
INSERT INTO `grid50000` VALUES ('6202', '', '83811843');
INSERT INTO `grid50000` VALUES ('6203', 'as', '83811843');
INSERT INTO `grid50000` VALUES ('6204', 'well', '83811843');
INSERT INTO `grid50000` VALUES ('6205', 'as', '83811843');
INSERT INTO `grid50000` VALUES ('6206', 'artists', '83811843');
INSERT INTO `grid50000` VALUES ('6207', 'like', '83811843');
INSERT INTO `grid50000` VALUES ('6208', 'Spranger', '83811843');
INSERT INTO `grid50000` VALUES ('6209', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('6210', 'Von', '83811843');
INSERT INTO `grid50000` VALUES ('6211', 'Aachen', '83811843');
INSERT INTO `grid50000` VALUES ('6212', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('6213', 'he', '83811843');
INSERT INTO `grid50000` VALUES ('6214', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('6215', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('6216', 'personal', '83811843');
INSERT INTO `grid50000` VALUES ('6217', 'friend', '83811843');
INSERT INTO `grid50000` VALUES ('6218', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('6219', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6220', 'legendary', '83811843');
INSERT INTO `grid50000` VALUES ('6221', 'Prague', '83811843');
INSERT INTO `grid50000` VALUES ('6222', 'Jewish', '83811843');
INSERT INTO `grid50000` VALUES ('6223', 'leader', '83811843');
INSERT INTO `grid50000` VALUES ('6224', 'Rabbi', '83811843');
INSERT INTO `grid50000` VALUES ('6225', 'Loew', '83811843');
INSERT INTO `grid50000` VALUES ('6226', 'It', '83811843');
INSERT INTO `grid50000` VALUES ('6227', 'is', '83811843');
INSERT INTO `grid50000` VALUES ('6228', 'said', '83811843');
INSERT INTO `grid50000` VALUES ('6229', 'that', '83811843');
INSERT INTO `grid50000` VALUES ('6230', 'he', '83811843');
INSERT INTO `grid50000` VALUES ('6231', 'also', '83811843');
INSERT INTO `grid50000` VALUES ('6232', 'financed', '83811843');
INSERT INTO `grid50000` VALUES ('6233', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6234', 'work', '83811843');
INSERT INTO `grid50000` VALUES ('6235', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('6236', 'any', '83811843');
INSERT INTO `grid50000` VALUES ('6237', 'number', '83811843');
INSERT INTO `grid50000` VALUES ('6238', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('6239', 'quack', '83811843');
INSERT INTO `grid50000` VALUES ('6240', 'alchemists', '83811843');
INSERT INTO `grid50000` VALUES ('6241', 'on', '83811843');
INSERT INTO `grid50000` VALUES ('6242', 'his', '83811843');
INSERT INTO `grid50000` VALUES ('6243', 'invitation', '83811843');
INSERT INTO `grid50000` VALUES ('6244', 'John', '83811843');
INSERT INTO `grid50000` VALUES ('6245', 'Dee', '83811843');
INSERT INTO `grid50000` VALUES ('6246', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('6247', 'Edward', '83811843');
INSERT INTO `grid50000` VALUES ('6248', 'Kelley', '83811843');
INSERT INTO `grid50000` VALUES ('6249', 'spent', '83811843');
INSERT INTO `grid50000` VALUES ('6250', 'time', '83811843');
INSERT INTO `grid50000` VALUES ('6251', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('6252', 'Prague', '83811843');
INSERT INTO `grid50000` VALUES ('6253', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('6254', 'that', '83811843');
INSERT INTO `grid50000` VALUES ('6255', 'he', '83811843');
INSERT INTO `grid50000` VALUES ('6256', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('6257', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('6258', 'little', '83811843');
INSERT INTO `grid50000` VALUES ('6259', 'soft', '83811843');
INSERT INTO `grid50000` VALUES ('6260', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('6261', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6262', 'head', '83811843');
INSERT INTO `grid50000` VALUES ('6263', 'Its', '83811843');
INSERT INTO `grid50000` VALUES ('6264', 'possible', '83811843');
INSERT INTO `grid50000` VALUES ('6265', 'that', '83811843');
INSERT INTO `grid50000` VALUES ('6266', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6267', 'Legend', '83811843');
INSERT INTO `grid50000` VALUES ('6268', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('6269', 'Faust', '83811843');
INSERT INTO `grid50000` VALUES ('6270', 'who', '83811843');
INSERT INTO `grid50000` VALUES ('6271', 'lived', '83811843');
INSERT INTO `grid50000` VALUES ('6272', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('6273', 'Prague', '83811843');
INSERT INTO `grid50000` VALUES ('6274', 'originated', '83811843');
INSERT INTO `grid50000` VALUES ('6275', 'at', '83811843');
INSERT INTO `grid50000` VALUES ('6276', 'this', '83811843');
INSERT INTO `grid50000` VALUES ('6277', 'time', '83811843');
INSERT INTO `grid50000` VALUES ('6278', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('6279', 'scientific', '83811843');
INSERT INTO `grid50000` VALUES ('6280', 'exploration', '83811843');
INSERT INTO `grid50000` VALUES ('6281', '\r\n\r\n', '83811843');
INSERT INTO `grid50000` VALUES ('6282', 'The', '83811843');
INSERT INTO `grid50000` VALUES ('6283', 'architectural', '83811843');
INSERT INTO `grid50000` VALUES ('6284', 'style', '83811843');
INSERT INTO `grid50000` VALUES ('6285', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('6286', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6287', 'time', '83811843');
INSERT INTO `grid50000` VALUES ('6288', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('6289', 'Baroque', '83811843');
INSERT INTO `grid50000` VALUES ('6290', 'which', '83811843');
INSERT INTO `grid50000` VALUES ('6291', '', '83811843');
INSERT INTO `grid50000` VALUES ('6292', 'like', '83811843');
INSERT INTO `grid50000` VALUES ('6293', 'Rudolf', '83811843');
INSERT INTO `grid50000` VALUES ('6294', 'II', '83811843');
INSERT INTO `grid50000` VALUES ('6295', 'himself', '83811843');
INSERT INTO `grid50000` VALUES ('6296', '', '83811843');
INSERT INTO `grid50000` VALUES ('6297', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('6298', 'round', '83811843');
INSERT INTO `grid50000` VALUES ('6299', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('6300', 'robust', '83811843');
INSERT INTO `grid50000` VALUES ('6301', 'flamboyant', '83811843');
INSERT INTO `grid50000` VALUES ('6302', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('6303', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('6304', 'little', '83811843');
INSERT INTO `grid50000` VALUES ('6305', 'gaudy', '83811843');
INSERT INTO `grid50000` VALUES ('6306', 'Baroque', '83811843');
INSERT INTO `grid50000` VALUES ('6307', 'buildings', '83811843');
INSERT INTO `grid50000` VALUES ('6308', 'like', '83811843');
INSERT INTO `grid50000` VALUES ('6309', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6310', 'Loreto', '83811843');
INSERT INTO `grid50000` VALUES ('6311', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('6312', 'St', '83811843');
INSERT INTO `grid50000` VALUES ('6313', 'Nicholas', '83811843');
INSERT INTO `grid50000` VALUES ('6314', 'Church', '83811843');
INSERT INTO `grid50000` VALUES ('6315', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('6316', 'Lesser', '83811843');
INSERT INTO `grid50000` VALUES ('6317', 'Town', '83811843');
INSERT INTO `grid50000` VALUES ('6318', 'Square', '83811843');
INSERT INTO `grid50000` VALUES ('6319', 'are', '83811843');
INSERT INTO `grid50000` VALUES ('6320', 'massive', '83811843');
INSERT INTO `grid50000` VALUES ('6321', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('6322', 'grand', '83811843');
INSERT INTO `grid50000` VALUES ('6323', 'The', '83811843');
INSERT INTO `grid50000` VALUES ('6324', 'statues', '83811843');
INSERT INTO `grid50000` VALUES ('6325', 'that', '83811843');
INSERT INTO `grid50000` VALUES ('6326', 'top', '83811843');
INSERT INTO `grid50000` VALUES ('6327', 'them', '83811843');
INSERT INTO `grid50000` VALUES ('6328', 'appear', '83811843');
INSERT INTO `grid50000` VALUES ('6329', 'so', '83811843');
INSERT INTO `grid50000` VALUES ('6330', 'heavy', '83811843');
INSERT INTO `grid50000` VALUES ('6331', 'that', '83811843');
INSERT INTO `grid50000` VALUES ('6332', 'they', '83811843');
INSERT INTO `grid50000` VALUES ('6333', 'seem', '83811843');
INSERT INTO `grid50000` VALUES ('6334', 'likely', '83811843');
INSERT INTO `grid50000` VALUES ('6335', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('6336', 'fall', '83811843');
INSERT INTO `grid50000` VALUES ('6337', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('6338', 'crush', '83811843');
INSERT INTO `grid50000` VALUES ('6339', 'innocent', '83811843');
INSERT INTO `grid50000` VALUES ('6340', 'passersby', '83811843');
INSERT INTO `grid50000` VALUES ('6341', '\r\n\r\n', '83811843');
INSERT INTO `grid50000` VALUES ('6342', 'Rudolf', '83811843');
INSERT INTO `grid50000` VALUES ('6343', 'II', '83811843');
INSERT INTO `grid50000` VALUES ('6344', 'who', '83811843');
INSERT INTO `grid50000` VALUES ('6345', 'suffered', '83811843');
INSERT INTO `grid50000` VALUES ('6346', 'periods', '83811843');
INSERT INTO `grid50000` VALUES ('6347', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('6348', 'dementia', '83811843');
INSERT INTO `grid50000` VALUES ('6349', 'because', '83811843');
INSERT INTO `grid50000` VALUES ('6350', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('6351', 'his', '83811843');
INSERT INTO `grid50000` VALUES ('6352', 'acute', '83811843');
INSERT INTO `grid50000` VALUES ('6353', 'case', '83811843');
INSERT INTO `grid50000` VALUES ('6354', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('6355', 'syphilis', '83811843');
INSERT INTO `grid50000` VALUES ('6356', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('6357', 'forced', '83811843');
INSERT INTO `grid50000` VALUES ('6358', 'by', '83811843');
INSERT INTO `grid50000` VALUES ('6359', 'his', '83811843');
INSERT INTO `grid50000` VALUES ('6360', 'family', '83811843');
INSERT INTO `grid50000` VALUES ('6361', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('6362', 'resign', '83811843');
INSERT INTO `grid50000` VALUES ('6363', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('6364', '1611', '83811843');
INSERT INTO `grid50000` VALUES ('6365', 'He', '83811843');
INSERT INTO `grid50000` VALUES ('6366', 'had', '83811843');
INSERT INTO `grid50000` VALUES ('6367', 'been', '83811843');
INSERT INTO `grid50000` VALUES ('6368', 'forced', '83811843');
INSERT INTO `grid50000` VALUES ('6369', 'during', '83811843');
INSERT INTO `grid50000` VALUES ('6370', 'his', '83811843');
INSERT INTO `grid50000` VALUES ('6371', 'reign', '83811843');
INSERT INTO `grid50000` VALUES ('6372', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('6373', 'concede', '83811843');
INSERT INTO `grid50000` VALUES ('6374', 'religious', '83811843');
INSERT INTO `grid50000` VALUES ('6375', 'freedom', '83811843');
INSERT INTO `grid50000` VALUES ('6376', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('6377', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6378', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('6379', 'Protestants', '83811843');
INSERT INTO `grid50000` VALUES ('6380', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('6381', 'when', '83811843');
INSERT INTO `grid50000` VALUES ('6382', 'his', '83811843');
INSERT INTO `grid50000` VALUES ('6383', 'brother', '83811843');
INSERT INTO `grid50000` VALUES ('6384', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('6385', 'successor', '83811843');
INSERT INTO `grid50000` VALUES ('6386', 'Matthias', '83811843');
INSERT INTO `grid50000` VALUES ('6387', 'tried', '83811843');
INSERT INTO `grid50000` VALUES ('6388', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('6389', 'rescind', '83811843');
INSERT INTO `grid50000` VALUES ('6390', 'them', '83811843');
INSERT INTO `grid50000` VALUES ('6391', 'mounting', '83811843');
INSERT INTO `grid50000` VALUES ('6392', 'political', '83811843');
INSERT INTO `grid50000` VALUES ('6393', 'tensions', '83811843');
INSERT INTO `grid50000` VALUES ('6394', 'led', '83811843');
INSERT INTO `grid50000` VALUES ('6395', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6396', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('6397', 'Estates', '83811843');
INSERT INTO `grid50000` VALUES ('6398', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('6399', 'rebel', '83811843');
INSERT INTO `grid50000` VALUES ('6400', 'against', '83811843');
INSERT INTO `grid50000` VALUES ('6401', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6402', 'Habsburgs', '83811843');
INSERT INTO `grid50000` VALUES ('6403', 'once', '83811843');
INSERT INTO `grid50000` VALUES ('6404', 'again', '83811843');
INSERT INTO `grid50000` VALUES ('6405', '\r\n\r\nThey', '83811843');
INSERT INTO `grid50000` VALUES ('6406', 'began', '83811843');
INSERT INTO `grid50000` VALUES ('6407', 'their', '83811843');
INSERT INTO `grid50000` VALUES ('6408', 'rebellion', '83811843');
INSERT INTO `grid50000` VALUES ('6409', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('6410', 'grand', '83811843');
INSERT INTO `grid50000` VALUES ('6411', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('6412', 'style', '83811843');
INSERT INTO `grid50000` VALUES ('6413', 'with', '83811843');
INSERT INTO `grid50000` VALUES ('6414', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6415', 'Second', '83811843');
INSERT INTO `grid50000` VALUES ('6416', 'Defenestration', '83811843');
INSERT INTO `grid50000` VALUES ('6417', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('6418', 'Prague', '83811843');
INSERT INTO `grid50000` VALUES ('6419', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('6420', '1618', '83811843');
INSERT INTO `grid50000` VALUES ('6421', 'In', '83811843');
INSERT INTO `grid50000` VALUES ('6422', 'this', '83811843');
INSERT INTO `grid50000` VALUES ('6423', 'second', '83811843');
INSERT INTO `grid50000` VALUES ('6424', 'defenestration', '83811843');
INSERT INTO `grid50000` VALUES ('6425', 'two', '83811843');
INSERT INTO `grid50000` VALUES ('6426', 'vice', '83811843');
INSERT INTO `grid50000` VALUES ('6427', 'regents', '83811843');
INSERT INTO `grid50000` VALUES ('6428', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('6429', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6430', 'Austrian', '83811843');
INSERT INTO `grid50000` VALUES ('6431', 'monarch', '83811843');
INSERT INTO `grid50000` VALUES ('6432', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('6433', 'some', '83811843');
INSERT INTO `grid50000` VALUES ('6434', 'governors', '83811843');
INSERT INTO `grid50000` VALUES ('6435', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('6436', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6437', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('6438', 'lands', '83811843');
INSERT INTO `grid50000` VALUES ('6439', 'were', '83811843');
INSERT INTO `grid50000` VALUES ('6440', 'thrown', '83811843');
INSERT INTO `grid50000` VALUES ('6441', 'out', '83811843');
INSERT INTO `grid50000` VALUES ('6442', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('6443', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('6444', 'tower', '83811843');
INSERT INTO `grid50000` VALUES ('6445', 'window', '83811843');
INSERT INTO `grid50000` VALUES ('6446', 'at', '83811843');
INSERT INTO `grid50000` VALUES ('6447', 'Prague', '83811843');
INSERT INTO `grid50000` VALUES ('6448', 'Castle', '83811843');
INSERT INTO `grid50000` VALUES ('6449', 'They', '83811843');
INSERT INTO `grid50000` VALUES ('6450', 'were', '83811843');
INSERT INTO `grid50000` VALUES ('6451', 'not', '83811843');
INSERT INTO `grid50000` VALUES ('6452', 'killed', '83811843');
INSERT INTO `grid50000` VALUES ('6453', 'however', '83811843');
INSERT INTO `grid50000` VALUES ('6454', 'as', '83811843');
INSERT INTO `grid50000` VALUES ('6455', 'they', '83811843');
INSERT INTO `grid50000` VALUES ('6456', 'fell', '83811843');
INSERT INTO `grid50000` VALUES ('6457', 'onto', '83811843');
INSERT INTO `grid50000` VALUES ('6458', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('6459', 'pile', '83811843');
INSERT INTO `grid50000` VALUES ('6460', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('6461', 'garbage', '83811843');
INSERT INTO `grid50000` VALUES ('6462', 'mostly', '83811843');
INSERT INTO `grid50000` VALUES ('6463', 'straw', '83811843');
INSERT INTO `grid50000` VALUES ('6464', 'which', '83811843');
INSERT INTO `grid50000` VALUES ('6465', 'had', '83811843');
INSERT INTO `grid50000` VALUES ('6466', 'accumulated', '83811843');
INSERT INTO `grid50000` VALUES ('6467', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('6468', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6469', 'castle', '83811843');
INSERT INTO `grid50000` VALUES ('6470', 'moat', '83811843');
INSERT INTO `grid50000` VALUES ('6471', 'So', '83811843');
INSERT INTO `grid50000` VALUES ('6472', 'it', '83811843');
INSERT INTO `grid50000` VALUES ('6473', 'can', '83811843');
INSERT INTO `grid50000` VALUES ('6474', 'be', '83811843');
INSERT INTO `grid50000` VALUES ('6475', 'said', '83811843');
INSERT INTO `grid50000` VALUES ('6476', 'that', '83811843');
INSERT INTO `grid50000` VALUES ('6477', 'they', '83811843');
INSERT INTO `grid50000` VALUES ('6478', 'at', '83811843');
INSERT INTO `grid50000` VALUES ('6479', 'least', '83811843');
INSERT INTO `grid50000` VALUES ('6480', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6481', 'nonAustrian', '83811843');
INSERT INTO `grid50000` VALUES ('6482', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('6483', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6484', 'throwees', '83811843');
INSERT INTO `grid50000` VALUES ('6485', 'were', '83811843');
INSERT INTO `grid50000` VALUES ('6486', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6487', 'worlds', '83811843');
INSERT INTO `grid50000` VALUES ('6488', 'first', '83811843');
INSERT INTO `grid50000` VALUES ('6489', 'bouncing', '83811843');
INSERT INTO `grid50000` VALUES ('6490', 'Czechs', '83811843');
INSERT INTO `grid50000` VALUES ('6491', 'To', '83811843');
INSERT INTO `grid50000` VALUES ('6492', 'add', '83811843');
INSERT INTO `grid50000` VALUES ('6493', 'insult', '83811843');
INSERT INTO `grid50000` VALUES ('6494', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('6495', 'injury', '83811843');
INSERT INTO `grid50000` VALUES ('6496', 'or', '83811843');
INSERT INTO `grid50000` VALUES ('6497', 'perhaps', '83811843');
INSERT INTO `grid50000` VALUES ('6498', 'insult', '83811843');
INSERT INTO `grid50000` VALUES ('6499', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('6500', 'insult?', '83811843');
INSERT INTO `grid50000` VALUES ('6501', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6502', 'Bohemian', '83811843');
INSERT INTO `grid50000` VALUES ('6503', 'diet', '83811843');
INSERT INTO `grid50000` VALUES ('6504', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('6505', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6506', 'Estates', '83811843');
INSERT INTO `grid50000` VALUES ('6507', 'then', '83811843');
INSERT INTO `grid50000` VALUES ('6508', 'elected', '83811843');
INSERT INTO `grid50000` VALUES ('6509', 'Frederick', '83811843');
INSERT INTO `grid50000` VALUES ('6510', 'V', '83811843');
INSERT INTO `grid50000` VALUES ('6511', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('6512', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6513', 'Palatinate', '83811843');
INSERT INTO `grid50000` VALUES ('6514', 'also', '83811843');
INSERT INTO `grid50000` VALUES ('6515', 'known', '83811843');
INSERT INTO `grid50000` VALUES ('6516', 'as', '83811843');
INSERT INTO `grid50000` VALUES ('6517', 'Frederick', '83811843');
INSERT INTO `grid50000` VALUES ('6518', 'Faltz', '83811843');
INSERT INTO `grid50000` VALUES ('6519', 'or', '83811843');
INSERT INTO `grid50000` VALUES ('6520', 'as', '83811843');
INSERT INTO `grid50000` VALUES ('6521', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6522', 'Winter', '83811843');
INSERT INTO `grid50000` VALUES ('6523', 'King', '83811843');
INSERT INTO `grid50000` VALUES ('6524', 'as', '83811843');
INSERT INTO `grid50000` VALUES ('6525', 'their', '83811843');
INSERT INTO `grid50000` VALUES ('6526', 'ruler', '83811843');
INSERT INTO `grid50000` VALUES ('6527', 'thinking', '83811843');
INSERT INTO `grid50000` VALUES ('6528', 'that', '83811843');
INSERT INTO `grid50000` VALUES ('6529', 'his', '83811843');
INSERT INTO `grid50000` VALUES ('6530', 'fatherinlaw', '83811843');
INSERT INTO `grid50000` VALUES ('6531', '', '83811843');
INSERT INTO `grid50000` VALUES ('6532', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6533', 'English', '83811843');
INSERT INTO `grid50000` VALUES ('6534', 'King', '83811843');
INSERT INTO `grid50000` VALUES ('6535', 'James', '83811843');
INSERT INTO `grid50000` VALUES ('6536', 'I', '83811843');
INSERT INTO `grid50000` VALUES ('6537', '', '83811843');
INSERT INTO `grid50000` VALUES ('6538', 'would', '83811843');
INSERT INTO `grid50000` VALUES ('6539', 'come', '83811843');
INSERT INTO `grid50000` VALUES ('6540', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('6541', 'their', '83811843');
INSERT INTO `grid50000` VALUES ('6542', 'aid', '83811843');
INSERT INTO `grid50000` VALUES ('6543', 'They', '83811843');
INSERT INTO `grid50000` VALUES ('6544', 'could', '83811843');
INSERT INTO `grid50000` VALUES ('6545', 'not', '83811843');
INSERT INTO `grid50000` VALUES ('6546', 'have', '83811843');
INSERT INTO `grid50000` VALUES ('6547', 'been', '83811843');
INSERT INTO `grid50000` VALUES ('6548', 'more', '83811843');
INSERT INTO `grid50000` VALUES ('6549', 'wrong', '83811843');
INSERT INTO `grid50000` VALUES ('6550', '\r\n\r\n', '83811843');
INSERT INTO `grid50000` VALUES ('6551', 'This', '83811843');
INSERT INTO `grid50000` VALUES ('6552', 'rebellion', '83811843');
INSERT INTO `grid50000` VALUES ('6553', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('6554', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6555', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('6556', 'Estates', '83811843');
INSERT INTO `grid50000` VALUES ('6557', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('6558', 'particularly', '83811843');
INSERT INTO `grid50000` VALUES ('6559', 'unsuccessful', '83811843');
INSERT INTO `grid50000` VALUES ('6560', 'It', '83811843');
INSERT INTO `grid50000` VALUES ('6561', 'culminated', '83811843');
INSERT INTO `grid50000` VALUES ('6562', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('6563', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6564', 'Battle', '83811843');
INSERT INTO `grid50000` VALUES ('6565', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('6566', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6567', 'White', '83811843');
INSERT INTO `grid50000` VALUES ('6568', 'Mountain', '83811843');
INSERT INTO `grid50000` VALUES ('6569', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('6570', '1620', '83811843');
INSERT INTO `grid50000` VALUES ('6571', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('6572', 'which', '83811843');
INSERT INTO `grid50000` VALUES ('6573', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6574', 'Estates', '83811843');
INSERT INTO `grid50000` VALUES ('6575', 'were', '83811843');
INSERT INTO `grid50000` VALUES ('6576', 'incontrovertibly', '83811843');
INSERT INTO `grid50000` VALUES ('6577', 'defeated', '83811843');
INSERT INTO `grid50000` VALUES ('6578', 'by', '83811843');
INSERT INTO `grid50000` VALUES ('6579', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6580', 'Habsburgs', '83811843');
INSERT INTO `grid50000` VALUES ('6581', 'They', '83811843');
INSERT INTO `grid50000` VALUES ('6582', 'had', '83811843');
INSERT INTO `grid50000` VALUES ('6583', 'been', '83811843');
INSERT INTO `grid50000` VALUES ('6584', 'successful', '83811843');
INSERT INTO `grid50000` VALUES ('6585', 'only', '83811843');
INSERT INTO `grid50000` VALUES ('6586', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('6587', 'sparking', '83811843');
INSERT INTO `grid50000` VALUES ('6588', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6589', 'Thirty', '83811843');
INSERT INTO `grid50000` VALUES ('6590', 'Years', '83811843');
INSERT INTO `grid50000` VALUES ('6591', 'War', '83811843');
INSERT INTO `grid50000` VALUES ('6592', 'which', '83811843');
INSERT INTO `grid50000` VALUES ('6593', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('6594', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('6595', 'devastate', '83811843');
INSERT INTO `grid50000` VALUES ('6596', 'much', '83811843');
INSERT INTO `grid50000` VALUES ('6597', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('6598', 'Europe', '83811843');
INSERT INTO `grid50000` VALUES ('6599', 'Incidentally', '83811843');
INSERT INTO `grid50000` VALUES ('6600', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6601', 'thenmercenary', '83811843');
INSERT INTO `grid50000` VALUES ('6602', 'laterphilosopher', '83811843');
INSERT INTO `grid50000` VALUES ('6603', 'Rene', '83811843');
INSERT INTO `grid50000` VALUES ('6604', 'Descartes', '83811843');
INSERT INTO `grid50000` VALUES ('6605', 'fought', '83811843');
INSERT INTO `grid50000` VALUES ('6606', 'at', '83811843');
INSERT INTO `grid50000` VALUES ('6607', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6608', 'Battle', '83811843');
INSERT INTO `grid50000` VALUES ('6609', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('6610', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6611', 'White', '83811843');
INSERT INTO `grid50000` VALUES ('6612', 'Mountain', '83811843');
INSERT INTO `grid50000` VALUES ('6613', 'on', '83811843');
INSERT INTO `grid50000` VALUES ('6614', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6615', 'side', '83811843');
INSERT INTO `grid50000` VALUES ('6616', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('6617', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6618', 'Habsburgs', '83811843');
INSERT INTO `grid50000` VALUES ('6619', '\r\n\r\nWell', '83811843');
INSERT INTO `grid50000` VALUES ('6620', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6621', 'Habsburgs', '83811843');
INSERT INTO `grid50000` VALUES ('6622', 'quite', '83811843');
INSERT INTO `grid50000` VALUES ('6623', 'understandably', '83811843');
INSERT INTO `grid50000` VALUES ('6624', 'did', '83811843');
INSERT INTO `grid50000` VALUES ('6625', 'not', '83811843');
INSERT INTO `grid50000` VALUES ('6626', 'appreciate', '83811843');
INSERT INTO `grid50000` VALUES ('6627', 'these', '83811843');
INSERT INTO `grid50000` VALUES ('6628', 'disturbances', '83811843');
INSERT INTO `grid50000` VALUES ('6629', 'which', '83811843');
INSERT INTO `grid50000` VALUES ('6630', 'were', '83811843');
INSERT INTO `grid50000` VALUES ('6631', 'emanating', '83811843');
INSERT INTO `grid50000` VALUES ('6632', 'from', '83811843');
INSERT INTO `grid50000` VALUES ('6633', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6634', 'northern', '83811843');
INSERT INTO `grid50000` VALUES ('6635', 'reaches', '83811843');
INSERT INTO `grid50000` VALUES ('6636', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('6637', 'their', '83811843');
INSERT INTO `grid50000` VALUES ('6638', 'empire', '83811843');
INSERT INTO `grid50000` VALUES ('6639', 'But', '83811843');
INSERT INTO `grid50000` VALUES ('6640', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6641', 'methods', '83811843');
INSERT INTO `grid50000` VALUES ('6642', 'that', '83811843');
INSERT INTO `grid50000` VALUES ('6643', 'they', '83811843');
INSERT INTO `grid50000` VALUES ('6644', 'used', '83811843');
INSERT INTO `grid50000` VALUES ('6645', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('6646', 'subdue', '83811843');
INSERT INTO `grid50000` VALUES ('6647', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6648', 'protestant', '83811843');
INSERT INTO `grid50000` VALUES ('6649', 'Estates', '83811843');
INSERT INTO `grid50000` VALUES ('6650', 'after', '83811843');
INSERT INTO `grid50000` VALUES ('6651', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6652', 'Battle', '83811843');
INSERT INTO `grid50000` VALUES ('6653', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('6654', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6655', 'White', '83811843');
INSERT INTO `grid50000` VALUES ('6656', 'Mountain', '83811843');
INSERT INTO `grid50000` VALUES ('6657', 'were', '83811843');
INSERT INTO `grid50000` VALUES ('6658', 'extraordinarily', '83811843');
INSERT INTO `grid50000` VALUES ('6659', 'harsh', '83811843');
INSERT INTO `grid50000` VALUES ('6660', '\r\n\r\nFirst', '83811843');
INSERT INTO `grid50000` VALUES ('6661', 'they', '83811843');
INSERT INTO `grid50000` VALUES ('6662', 'executed', '83811843');
INSERT INTO `grid50000` VALUES ('6663', '27', '83811843');
INSERT INTO `grid50000` VALUES ('6664', 'nobles', '83811843');
INSERT INTO `grid50000` VALUES ('6665', '', '83811843');
INSERT INTO `grid50000` VALUES ('6666', 'leaders', '83811843');
INSERT INTO `grid50000` VALUES ('6667', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('6668', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6669', 'Estates', '83811843');
INSERT INTO `grid50000` VALUES ('6670', 'who', '83811843');
INSERT INTO `grid50000` VALUES ('6671', 'had', '83811843');
INSERT INTO `grid50000` VALUES ('6672', 'fought', '83811843');
INSERT INTO `grid50000` VALUES ('6673', 'on', '83811843');
INSERT INTO `grid50000` VALUES ('6674', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6675', 'losing', '83811843');
INSERT INTO `grid50000` VALUES ('6676', 'side', '83811843');
INSERT INTO `grid50000` VALUES ('6677', 'against', '83811843');
INSERT INTO `grid50000` VALUES ('6678', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6679', 'Habsburgs', '83811843');
INSERT INTO `grid50000` VALUES ('6680', 'at', '83811843');
INSERT INTO `grid50000` VALUES ('6681', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6682', 'Battle', '83811843');
INSERT INTO `grid50000` VALUES ('6683', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('6684', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6685', 'White', '83811843');
INSERT INTO `grid50000` VALUES ('6686', 'Mountain', '83811843');
INSERT INTO `grid50000` VALUES ('6687', '', '83811843');
INSERT INTO `grid50000` VALUES ('6688', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('6689', 'Pragues', '83811843');
INSERT INTO `grid50000` VALUES ('6690', 'Old', '83811843');
INSERT INTO `grid50000` VALUES ('6691', 'Town', '83811843');
INSERT INTO `grid50000` VALUES ('6692', 'Square', '83811843');
INSERT INTO `grid50000` VALUES ('6693', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('6694', 'May', '83811843');
INSERT INTO `grid50000` VALUES ('6695', '1621', '83811843');
INSERT INTO `grid50000` VALUES ('6696', 'Some', '83811843');
INSERT INTO `grid50000` VALUES ('6697', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('6698', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6699', 'heads', '83811843');
INSERT INTO `grid50000` VALUES ('6700', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('6701', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6702', 'decapitated', '83811843');
INSERT INTO `grid50000` VALUES ('6703', 'leaders', '83811843');
INSERT INTO `grid50000` VALUES ('6704', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('6705', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6706', 'rebellion', '83811843');
INSERT INTO `grid50000` VALUES ('6707', 'were', '83811843');
INSERT INTO `grid50000` VALUES ('6708', 'then', '83811843');
INSERT INTO `grid50000` VALUES ('6709', 'hung', '83811843');
INSERT INTO `grid50000` VALUES ('6710', 'strategically', '83811843');
INSERT INTO `grid50000` VALUES ('6711', 'around', '83811843');
INSERT INTO `grid50000` VALUES ('6712', 'Prague', '83811843');
INSERT INTO `grid50000` VALUES ('6713', '', '83811843');
INSERT INTO `grid50000` VALUES ('6714', 'for', '83811843');
INSERT INTO `grid50000` VALUES ('6715', 'instance', '83811843');
INSERT INTO `grid50000` VALUES ('6716', 'on', '83811843');
INSERT INTO `grid50000` VALUES ('6717', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6718', 'Old', '83811843');
INSERT INTO `grid50000` VALUES ('6719', 'Town', '83811843');
INSERT INTO `grid50000` VALUES ('6720', 'bridge', '83811843');
INSERT INTO `grid50000` VALUES ('6721', 'tower', '83811843');
INSERT INTO `grid50000` VALUES ('6722', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('6723', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6724', 'Charles', '83811843');
INSERT INTO `grid50000` VALUES ('6725', 'Bridge', '83811843');
INSERT INTO `grid50000` VALUES ('6726', '', '83811843');
INSERT INTO `grid50000` VALUES ('6727', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('6728', 'serve', '83811843');
INSERT INTO `grid50000` VALUES ('6729', 'as', '83811843');
INSERT INTO `grid50000` VALUES ('6730', 'an', '83811843');
INSERT INTO `grid50000` VALUES ('6731', 'ominous', '83811843');
INSERT INTO `grid50000` VALUES ('6732', 'reminder', '83811843');
INSERT INTO `grid50000` VALUES ('6733', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('6734', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6735', 'people', '83811843');
INSERT INTO `grid50000` VALUES ('6736', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('6737', 'Who', '83811843');
INSERT INTO `grid50000` VALUES ('6738', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('6739', 'Boss', '83811843');
INSERT INTO `grid50000` VALUES ('6740', 'It', '83811843');
INSERT INTO `grid50000` VALUES ('6741', 'is', '83811843');
INSERT INTO `grid50000` VALUES ('6742', 'said', '83811843');
INSERT INTO `grid50000` VALUES ('6743', 'that', '83811843');
INSERT INTO `grid50000` VALUES ('6744', 'every', '83811843');
INSERT INTO `grid50000` VALUES ('6745', 'year', '83811843');
INSERT INTO `grid50000` VALUES ('6746', 'at', '83811843');
INSERT INTO `grid50000` VALUES ('6747', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6748', 'exact', '83811843');
INSERT INTO `grid50000` VALUES ('6749', 'hour', '83811843');
INSERT INTO `grid50000` VALUES ('6750', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('6751', 'on', '83811843');
INSERT INTO `grid50000` VALUES ('6752', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6753', 'exact', '83811843');
INSERT INTO `grid50000` VALUES ('6754', 'day', '83811843');
INSERT INTO `grid50000` VALUES ('6755', 'that', '83811843');
INSERT INTO `grid50000` VALUES ('6756', 'they', '83811843');
INSERT INTO `grid50000` VALUES ('6757', 'were', '83811843');
INSERT INTO `grid50000` VALUES ('6758', 'killed', '83811843');
INSERT INTO `grid50000` VALUES ('6759', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6760', 'ghosts', '83811843');
INSERT INTO `grid50000` VALUES ('6761', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('6762', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6763', '27', '83811843');
INSERT INTO `grid50000` VALUES ('6764', 'wronglyexecuted', '83811843');
INSERT INTO `grid50000` VALUES ('6765', 'nobles', '83811843');
INSERT INTO `grid50000` VALUES ('6766', 'can', '83811843');
INSERT INTO `grid50000` VALUES ('6767', 'be', '83811843');
INSERT INTO `grid50000` VALUES ('6768', 'seen', '83811843');
INSERT INTO `grid50000` VALUES ('6769', 'haunting', '83811843');
INSERT INTO `grid50000` VALUES ('6770', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6771', 'spot', '83811843');
INSERT INTO `grid50000` VALUES ('6772', 'where', '83811843');
INSERT INTO `grid50000` VALUES ('6773', 'they', '83811843');
INSERT INTO `grid50000` VALUES ('6774', 'lost', '83811843');
INSERT INTO `grid50000` VALUES ('6775', 'their', '83811843');
INSERT INTO `grid50000` VALUES ('6776', 'heads', '83811843');
INSERT INTO `grid50000` VALUES ('6777', 'The', '83811843');
INSERT INTO `grid50000` VALUES ('6778', 'place', '83811843');
INSERT INTO `grid50000` VALUES ('6779', 'today', '83811843');
INSERT INTO `grid50000` VALUES ('6780', 'is', '83811843');
INSERT INTO `grid50000` VALUES ('6781', 'marked', '83811843');
INSERT INTO `grid50000` VALUES ('6782', 'by', '83811843');
INSERT INTO `grid50000` VALUES ('6783', '27', '83811843');
INSERT INTO `grid50000` VALUES ('6784', 'crosses', '83811843');
INSERT INTO `grid50000` VALUES ('6785', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('6786', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6787', 'cobblestones', '83811843');
INSERT INTO `grid50000` VALUES ('6788', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('6789', 'Old', '83811843');
INSERT INTO `grid50000` VALUES ('6790', 'Town', '83811843');
INSERT INTO `grid50000` VALUES ('6791', 'Square', '83811843');
INSERT INTO `grid50000` VALUES ('6792', 'next', '83811843');
INSERT INTO `grid50000` VALUES ('6793', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('6794', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6795', 'Astronomical', '83811843');
INSERT INTO `grid50000` VALUES ('6796', 'Clock', '83811843');
INSERT INTO `grid50000` VALUES ('6797', 'The', '83811843');
INSERT INTO `grid50000` VALUES ('6798', 'heads', '83811843');
INSERT INTO `grid50000` VALUES ('6799', 'hung', '83811843');
INSERT INTO `grid50000` VALUES ('6800', 'there', '83811843');
INSERT INTO `grid50000` VALUES ('6801', 'for', '83811843');
INSERT INTO `grid50000` VALUES ('6802', '11', '83811843');
INSERT INTO `grid50000` VALUES ('6803', 'long', '83811843');
INSERT INTO `grid50000` VALUES ('6804', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('6805', 'lonely', '83811843');
INSERT INTO `grid50000` VALUES ('6806', 'years', '83811843');
INSERT INTO `grid50000` VALUES ('6807', 'before', '83811843');
INSERT INTO `grid50000` VALUES ('6808', 'finally', '83811843');
INSERT INTO `grid50000` VALUES ('6809', 'being', '83811843');
INSERT INTO `grid50000` VALUES ('6810', 'taken', '83811843');
INSERT INTO `grid50000` VALUES ('6811', 'down', '83811843');
INSERT INTO `grid50000` VALUES ('6812', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('6813', 'given', '83811843');
INSERT INTO `grid50000` VALUES ('6814', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('6815', 'proper', '83811843');
INSERT INTO `grid50000` VALUES ('6816', 'burial', '83811843');
INSERT INTO `grid50000` VALUES ('6817', 'by', '83811843');
INSERT INTO `grid50000` VALUES ('6818', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6819', 'Saxons', '83811843');
INSERT INTO `grid50000` VALUES ('6820', 'who', '83811843');
INSERT INTO `grid50000` VALUES ('6821', 'occupied', '83811843');
INSERT INTO `grid50000` VALUES ('6822', 'Prague', '83811843');
INSERT INTO `grid50000` VALUES ('6823', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('6824', '1632', '83811843');
INSERT INTO `grid50000` VALUES ('6825', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('6826', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6827', 'course', '83811843');
INSERT INTO `grid50000` VALUES ('6828', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('6829', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6830', 'Thirty', '83811843');
INSERT INTO `grid50000` VALUES ('6831', 'Years', '83811843');
INSERT INTO `grid50000` VALUES ('6832', 'War', '83811843');
INSERT INTO `grid50000` VALUES ('6833', '\r\n\r\nThe', '83811843');
INSERT INTO `grid50000` VALUES ('6834', 'Thirty', '83811843');
INSERT INTO `grid50000` VALUES ('6835', 'Years', '83811843');
INSERT INTO `grid50000` VALUES ('6836', 'War', '83811843');
INSERT INTO `grid50000` VALUES ('6837', 'which', '83811843');
INSERT INTO `grid50000` VALUES ('6838', 'had', '83811843');
INSERT INTO `grid50000` VALUES ('6839', 'begun', '83811843');
INSERT INTO `grid50000` VALUES ('6840', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('6841', 'Prague', '83811843');
INSERT INTO `grid50000` VALUES ('6842', 'ended', '83811843');
INSERT INTO `grid50000` VALUES ('6843', 'there', '83811843');
INSERT INTO `grid50000` VALUES ('6844', 'too', '83811843');
INSERT INTO `grid50000` VALUES ('6845', 'In', '83811843');
INSERT INTO `grid50000` VALUES ('6846', '1648', '83811843');
INSERT INTO `grid50000` VALUES ('6847', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6848', 'Swedes', '83811843');
INSERT INTO `grid50000` VALUES ('6849', 'had', '83811843');
INSERT INTO `grid50000` VALUES ('6850', 'succeeded', '83811843');
INSERT INTO `grid50000` VALUES ('6851', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('6852', 'capturing', '83811843');
INSERT INTO `grid50000` VALUES ('6853', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6854', 'Lesser', '83811843');
INSERT INTO `grid50000` VALUES ('6855', 'Quarter', '83811843');
INSERT INTO `grid50000` VALUES ('6856', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('6857', 'plundering', '83811843');
INSERT INTO `grid50000` VALUES ('6858', 'it', '83811843');
INSERT INTO `grid50000` VALUES ('6859', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('6860', 'Prague', '83811843');
INSERT INTO `grid50000` VALUES ('6861', 'Castle', '83811843');
INSERT INTO `grid50000` VALUES ('6862', 'carrying', '83811843');
INSERT INTO `grid50000` VALUES ('6863', 'off', '83811843');
INSERT INTO `grid50000` VALUES ('6864', 'many', '83811843');
INSERT INTO `grid50000` VALUES ('6865', 'valuable', '83811843');
INSERT INTO `grid50000` VALUES ('6866', 'artworks', '83811843');
INSERT INTO `grid50000` VALUES ('6867', 'which', '83811843');
INSERT INTO `grid50000` VALUES ('6868', 'decorate', '83811843');
INSERT INTO `grid50000` VALUES ('6869', 'Swedish', '83811843');
INSERT INTO `grid50000` VALUES ('6870', 'castles', '83811843');
INSERT INTO `grid50000` VALUES ('6871', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('6872', 'palaces', '83811843');
INSERT INTO `grid50000` VALUES ('6873', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('6874', 'this', '83811843');
INSERT INTO `grid50000` VALUES ('6875', 'day', '83811843');
INSERT INTO `grid50000` VALUES ('6876', 'They', '83811843');
INSERT INTO `grid50000` VALUES ('6877', 'were', '83811843');
INSERT INTO `grid50000` VALUES ('6878', 'defeated', '83811843');
INSERT INTO `grid50000` VALUES ('6879', 'by', '83811843');
INSERT INTO `grid50000` VALUES ('6880', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('6881', 'ragtag', '83811843');
INSERT INTO `grid50000` VALUES ('6882', 'force', '83811843');
INSERT INTO `grid50000` VALUES ('6883', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('6884', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('6885', 'university', '83811843');
INSERT INTO `grid50000` VALUES ('6886', 'students', '83811843');
INSERT INTO `grid50000` VALUES ('6887', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('6888', 'residents', '83811843');
INSERT INTO `grid50000` VALUES ('6889', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('6890', 'Pragues', '83811843');
INSERT INTO `grid50000` VALUES ('6891', 'Jewish', '83811843');
INSERT INTO `grid50000` VALUES ('6892', 'town', '83811843');
INSERT INTO `grid50000` VALUES ('6893', 'on', '83811843');
INSERT INTO `grid50000` VALUES ('6894', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6895', 'Charles', '83811843');
INSERT INTO `grid50000` VALUES ('6896', 'Bridge', '83811843');
INSERT INTO `grid50000` VALUES ('6897', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('6898', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6899', 'last', '83811843');
INSERT INTO `grid50000` VALUES ('6900', 'battle', '83811843');
INSERT INTO `grid50000` VALUES ('6901', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('6902', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6903', 'Thirty', '83811843');
INSERT INTO `grid50000` VALUES ('6904', 'Years', '83811843');
INSERT INTO `grid50000` VALUES ('6905', 'War', '83811843');
INSERT INTO `grid50000` VALUES ('6906', 'It', '83811843');
INSERT INTO `grid50000` VALUES ('6907', 'is', '83811843');
INSERT INTO `grid50000` VALUES ('6908', 'said', '83811843');
INSERT INTO `grid50000` VALUES ('6909', 'that', '83811843');
INSERT INTO `grid50000` VALUES ('6910', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6911', 'Swedes', '83811843');
INSERT INTO `grid50000` VALUES ('6912', 'were', '83811843');
INSERT INTO `grid50000` VALUES ('6913', 'beseeched', '83811843');
INSERT INTO `grid50000` VALUES ('6914', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('6915', 'come', '83811843');
INSERT INTO `grid50000` VALUES ('6916', 'by', '83811843');
INSERT INTO `grid50000` VALUES ('6917', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6918', 'exiled', '83811843');
INSERT INTO `grid50000` VALUES ('6919', 'Protestant', '83811843');
INSERT INTO `grid50000` VALUES ('6920', 'leader', '83811843');
INSERT INTO `grid50000` VALUES ('6921', 'Comenius', '83811843');
INSERT INTO `grid50000` VALUES ('6922', 'Jan', '83811843');
INSERT INTO `grid50000` VALUES ('6923', 'Amos', '83811843');
INSERT INTO `grid50000` VALUES ('6924', 'Komensky', '83811843');
INSERT INTO `grid50000` VALUES ('6925', '', '83811843');
INSERT INTO `grid50000` VALUES ('6926', 'he', '83811843');
INSERT INTO `grid50000` VALUES ('6927', 'had', '83811843');
INSERT INTO `grid50000` VALUES ('6928', 'wanted', '83811843');
INSERT INTO `grid50000` VALUES ('6929', 'them', '83811843');
INSERT INTO `grid50000` VALUES ('6930', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('6931', 'come', '83811843');
INSERT INTO `grid50000` VALUES ('6932', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('6933', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6934', 'aid', '83811843');
INSERT INTO `grid50000` VALUES ('6935', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('6936', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6937', 'bynow', '83811843');
INSERT INTO `grid50000` VALUES ('6938', 'utterly', '83811843');
INSERT INTO `grid50000` VALUES ('6939', 'defeated', '83811843');
INSERT INTO `grid50000` VALUES ('6940', 'Protestant', '83811843');
INSERT INTO `grid50000` VALUES ('6941', 'forces', '83811843');
INSERT INTO `grid50000` VALUES ('6942', 'but', '83811843');
INSERT INTO `grid50000` VALUES ('6943', 'by', '83811843');
INSERT INTO `grid50000` VALUES ('6944', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6945', 'end', '83811843');
INSERT INTO `grid50000` VALUES ('6946', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('6947', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6948', 'war', '83811843');
INSERT INTO `grid50000` VALUES ('6949', 'it', '83811843');
INSERT INTO `grid50000` VALUES ('6950', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('6951', 'already', '83811843');
INSERT INTO `grid50000` VALUES ('6952', 'too', '83811843');
INSERT INTO `grid50000` VALUES ('6953', 'late', '83811843');
INSERT INTO `grid50000` VALUES ('6954', '\r\n\r\nAs', '83811843');
INSERT INTO `grid50000` VALUES ('6955', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('6956', 'result', '83811843');
INSERT INTO `grid50000` VALUES ('6957', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('6958', 'all', '83811843');
INSERT INTO `grid50000` VALUES ('6959', 'this', '83811843');
INSERT INTO `grid50000` VALUES ('6960', 'tumult', '83811843');
INSERT INTO `grid50000` VALUES ('6961', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6962', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('6963', 'lands', '83811843');
INSERT INTO `grid50000` VALUES ('6964', 'lost', '83811843');
INSERT INTO `grid50000` VALUES ('6965', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6966', 'power', '83811843');
INSERT INTO `grid50000` VALUES ('6967', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('6968', 'elect', '83811843');
INSERT INTO `grid50000` VALUES ('6969', 'their', '83811843');
INSERT INTO `grid50000` VALUES ('6970', 'own', '83811843');
INSERT INTO `grid50000` VALUES ('6971', 'rulers', '83811843');
INSERT INTO `grid50000` VALUES ('6972', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('6973', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6974', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('6975', 'crown', '83811843');
INSERT INTO `grid50000` VALUES ('6976', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('6977', 'made', '83811843');
INSERT INTO `grid50000` VALUES ('6978', 'hereditary', '83811843');
INSERT INTO `grid50000` VALUES ('6979', 'for', '83811843');
INSERT INTO `grid50000` VALUES ('6980', 'Habsburg', '83811843');
INSERT INTO `grid50000` VALUES ('6981', 'rulers', '83811843');
INSERT INTO `grid50000` VALUES ('6982', 'The', '83811843');
INSERT INTO `grid50000` VALUES ('6983', 'Habsburgs', '83811843');
INSERT INTO `grid50000` VALUES ('6984', 'banned', '83811843');
INSERT INTO `grid50000` VALUES ('6985', 'all', '83811843');
INSERT INTO `grid50000` VALUES ('6986', 'religions', '83811843');
INSERT INTO `grid50000` VALUES ('6987', 'other', '83811843');
INSERT INTO `grid50000` VALUES ('6988', 'than', '83811843');
INSERT INTO `grid50000` VALUES ('6989', 'Catholicism', '83811843');
INSERT INTO `grid50000` VALUES ('6990', 'The', '83811843');
INSERT INTO `grid50000` VALUES ('6991', 'property', '83811843');
INSERT INTO `grid50000` VALUES ('6992', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('6993', 'Protestant', '83811843');
INSERT INTO `grid50000` VALUES ('6994', 'members', '83811843');
INSERT INTO `grid50000` VALUES ('6995', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('6996', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('6997', 'nobility', '83811843');
INSERT INTO `grid50000` VALUES ('6998', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('6999', 'confiscated', '83811843');
INSERT INTO `grid50000` VALUES ('7000', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('7001', 'handed', '83811843');
INSERT INTO `grid50000` VALUES ('7002', 'out', '83811843');
INSERT INTO `grid50000` VALUES ('7003', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('7004', 'loyal', '83811843');
INSERT INTO `grid50000` VALUES ('7005', 'Catholics', '83811843');
INSERT INTO `grid50000` VALUES ('7006', '\r\n\r\nThose', '83811843');
INSERT INTO `grid50000` VALUES ('7007', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('7008', 'Protestants', '83811843');
INSERT INTO `grid50000` VALUES ('7009', 'who', '83811843');
INSERT INTO `grid50000` VALUES ('7010', 'werent', '83811843');
INSERT INTO `grid50000` VALUES ('7011', 'already', '83811843');
INSERT INTO `grid50000` VALUES ('7012', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('7013', 'exile', '83811843');
INSERT INTO `grid50000` VALUES ('7014', 'were', '83811843');
INSERT INTO `grid50000` VALUES ('7015', 'forced', '83811843');
INSERT INTO `grid50000` VALUES ('7016', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('7017', 'convert', '83811843');
INSERT INTO `grid50000` VALUES ('7018', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('7019', 'Catholocism', '83811843');
INSERT INTO `grid50000` VALUES ('7020', 'Only', '83811843');
INSERT INTO `grid50000` VALUES ('7021', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('7022', 'very', '83811843');
INSERT INTO `grid50000` VALUES ('7023', 'few', '83811843');
INSERT INTO `grid50000` VALUES ('7024', 'had', '83811843');
INSERT INTO `grid50000` VALUES ('7025', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7026', 'courage', '83811843');
INSERT INTO `grid50000` VALUES ('7027', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('7028', 'continue', '83811843');
INSERT INTO `grid50000` VALUES ('7029', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('7030', 'practice', '83811843');
INSERT INTO `grid50000` VALUES ('7031', 'their', '83811843');
INSERT INTO `grid50000` VALUES ('7032', 'religion', '83811843');
INSERT INTO `grid50000` VALUES ('7033', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('7034', 'secret', '83811843');
INSERT INTO `grid50000` VALUES ('7035', '\r\n\r\n\r\n\r\nThe', '83811843');
INSERT INTO `grid50000` VALUES ('7036', 'population', '83811843');
INSERT INTO `grid50000` VALUES ('7037', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('7038', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7039', 'country', '83811843');
INSERT INTO `grid50000` VALUES ('7040', 'had', '83811843');
INSERT INTO `grid50000` VALUES ('7041', 'been', '83811843');
INSERT INTO `grid50000` VALUES ('7042', 'halved', '83811843');
INSERT INTO `grid50000` VALUES ('7043', 'by', '83811843');
INSERT INTO `grid50000` VALUES ('7044', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7045', 'sundry', '83811843');
INSERT INTO `grid50000` VALUES ('7046', 'aftermath', '83811843');
INSERT INTO `grid50000` VALUES ('7047', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('7048', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7049', 'Battle', '83811843');
INSERT INTO `grid50000` VALUES ('7050', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('7051', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7052', 'White', '83811843');
INSERT INTO `grid50000` VALUES ('7053', 'Mountain', '83811843');
INSERT INTO `grid50000` VALUES ('7054', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('7055', 'as', '83811843');
INSERT INTO `grid50000` VALUES ('7056', 'fewer', '83811843');
INSERT INTO `grid50000` VALUES ('7057', 'people', '83811843');
INSERT INTO `grid50000` VALUES ('7058', 'also', '83811843');
INSERT INTO `grid50000` VALUES ('7059', 'means', '83811843');
INSERT INTO `grid50000` VALUES ('7060', 'fewer', '83811843');
INSERT INTO `grid50000` VALUES ('7061', 'people', '83811843');
INSERT INTO `grid50000` VALUES ('7062', 'paying', '83811843');
INSERT INTO `grid50000` VALUES ('7063', 'tax', '83811843');
INSERT INTO `grid50000` VALUES ('7064', 'taxes', '83811843');
INSERT INTO `grid50000` VALUES ('7065', 'were', '83811843');
INSERT INTO `grid50000` VALUES ('7066', 'raised', '83811843');
INSERT INTO `grid50000` VALUES ('7067', '\r\n\r\n', '83811843');
INSERT INTO `grid50000` VALUES ('7068', 'Things', '83811843');
INSERT INTO `grid50000` VALUES ('7069', 'were', '83811843');
INSERT INTO `grid50000` VALUES ('7070', 'pretty', '83811843');
INSERT INTO `grid50000` VALUES ('7071', 'bad', '83811843');
INSERT INTO `grid50000` VALUES ('7072', 'all', '83811843');
INSERT INTO `grid50000` VALUES ('7073', 'around', '83811843');
INSERT INTO `grid50000` VALUES ('7074', 'The', '83811843');
INSERT INTO `grid50000` VALUES ('7075', 'rich', '83811843');
INSERT INTO `grid50000` VALUES ('7076', 'got', '83811843');
INSERT INTO `grid50000` VALUES ('7077', 'richer', '83811843');
INSERT INTO `grid50000` VALUES ('7078', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7079', 'poor', '83811843');
INSERT INTO `grid50000` VALUES ('7080', 'got', '83811843');
INSERT INTO `grid50000` VALUES ('7081', 'poorer', '83811843');
INSERT INTO `grid50000` VALUES ('7082', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('7083', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7084', 'economy', '83811843');
INSERT INTO `grid50000` VALUES ('7085', 'went', '83811843');
INSERT INTO `grid50000` VALUES ('7086', 'into', '83811843');
INSERT INTO `grid50000` VALUES ('7087', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('7088', 'deep', '83811843');
INSERT INTO `grid50000` VALUES ('7089', 'recession', '83811843');
INSERT INTO `grid50000` VALUES ('7090', 'Luckily', '83811843');
INSERT INTO `grid50000` VALUES ('7091', 'it', '83811843');
INSERT INTO `grid50000` VALUES ('7092', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('7093', 'high', '83811843');
INSERT INTO `grid50000` VALUES ('7094', 'time', '83811843');
INSERT INTO `grid50000` VALUES ('7095', 'for', '83811843');
INSERT INTO `grid50000` VALUES ('7096', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7097', 'Enlightenment', '83811843');
INSERT INTO `grid50000` VALUES ('7098', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('7099', 'make', '83811843');
INSERT INTO `grid50000` VALUES ('7100', 'an', '83811843');
INSERT INTO `grid50000` VALUES ('7101', 'entrance', '83811843');
INSERT INTO `grid50000` VALUES ('7102', 'The', '83811843');
INSERT INTO `grid50000` VALUES ('7103', 'administrative', '83811843');
INSERT INTO `grid50000` VALUES ('7104', 'reforms', '83811843');
INSERT INTO `grid50000` VALUES ('7105', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('7106', 'Maria', '83811843');
INSERT INTO `grid50000` VALUES ('7107', 'Theresa', '83811843');
INSERT INTO `grid50000` VALUES ('7108', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('7109', 'her', '83811843');
INSERT INTO `grid50000` VALUES ('7110', 'son', '83811843');
INSERT INTO `grid50000` VALUES ('7111', 'Joseph', '83811843');
INSERT INTO `grid50000` VALUES ('7112', 'II', '83811843');
INSERT INTO `grid50000` VALUES ('7113', 'did', '83811843');
INSERT INTO `grid50000` VALUES ('7114', 'much', '83811843');
INSERT INTO `grid50000` VALUES ('7115', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('7116', 'alleviate', '83811843');
INSERT INTO `grid50000` VALUES ('7117', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7118', 'situation', '83811843');
INSERT INTO `grid50000` VALUES ('7119', '\r\n\r\nThese', '83811843');
INSERT INTO `grid50000` VALUES ('7120', 'two', '83811843');
INSERT INTO `grid50000` VALUES ('7121', 'rulers', '83811843');
INSERT INTO `grid50000` VALUES ('7122', 'reduced', '83811843');
INSERT INTO `grid50000` VALUES ('7123', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7124', 'privileges', '83811843');
INSERT INTO `grid50000` VALUES ('7125', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('7126', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7127', 'now', '83811843');
INSERT INTO `grid50000` VALUES ('7128', 'allCatholic', '83811843');
INSERT INTO `grid50000` VALUES ('7129', 'nobility', '83811843');
INSERT INTO `grid50000` VALUES ('7130', 'who', '83811843');
INSERT INTO `grid50000` VALUES ('7131', 'are', '83811843');
INSERT INTO `grid50000` VALUES ('7132', 'also', '83811843');
INSERT INTO `grid50000` VALUES ('7133', '', '83811843');
INSERT INTO `grid50000` VALUES ('7134', 'perhaps', '83811843');
INSERT INTO `grid50000` VALUES ('7135', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('7136', 'confuse', '83811843');
INSERT INTO `grid50000` VALUES ('7137', 'us', '83811843');
INSERT INTO `grid50000` VALUES ('7138', 'all', '83811843');
INSERT INTO `grid50000` VALUES ('7139', '', '83811843');
INSERT INTO `grid50000` VALUES ('7140', 'known', '83811843');
INSERT INTO `grid50000` VALUES ('7141', 'as', '83811843');
INSERT INTO `grid50000` VALUES ('7142', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7143', 'Estates', '83811843');
INSERT INTO `grid50000` VALUES ('7144', 'as', '83811843');
INSERT INTO `grid50000` VALUES ('7145', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7146', 'formerly', '83811843');
INSERT INTO `grid50000` VALUES ('7147', 'Protestant', '83811843');
INSERT INTO `grid50000` VALUES ('7148', 'nobility', '83811843');
INSERT INTO `grid50000` VALUES ('7149', 'had', '83811843');
INSERT INTO `grid50000` VALUES ('7150', 'also', '83811843');
INSERT INTO `grid50000` VALUES ('7151', 'been', '83811843');
INSERT INTO `grid50000` VALUES ('7152', 'called', '83811843');
INSERT INTO `grid50000` VALUES ('7153', 'They', '83811843');
INSERT INTO `grid50000` VALUES ('7154', 'expelled', '83811843');
INSERT INTO `grid50000` VALUES ('7155', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7156', 'Jesuits', '83811843');
INSERT INTO `grid50000` VALUES ('7157', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('7158', '1773', '83811843');
INSERT INTO `grid50000` VALUES ('7159', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('7160', 'they', '83811843');
INSERT INTO `grid50000` VALUES ('7161', 'attempted', '83811843');
INSERT INTO `grid50000` VALUES ('7162', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('7163', 'end', '83811843');
INSERT INTO `grid50000` VALUES ('7164', 'social', '83811843');
INSERT INTO `grid50000` VALUES ('7166', 'by', '83811843');
INSERT INTO `grid50000` VALUES ('7167', 'abolishing', '83811843');
INSERT INTO `grid50000` VALUES ('7168', 'serfdom', '83811843');
INSERT INTO `grid50000` VALUES ('7169', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('7170', '1781', '83811843');
INSERT INTO `grid50000` VALUES ('7171', 'In', '83811843');
INSERT INTO `grid50000` VALUES ('7172', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7173', 'same', '83811843');
INSERT INTO `grid50000` VALUES ('7174', 'year', '83811843');
INSERT INTO `grid50000` VALUES ('7175', 'they', '83811843');
INSERT INTO `grid50000` VALUES ('7176', 'issued', '83811843');
INSERT INTO `grid50000` VALUES ('7177', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7178', 'Edict', '83811843');
INSERT INTO `grid50000` VALUES ('7179', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('7180', 'Tolerance', '83811843');
INSERT INTO `grid50000` VALUES ('7181', 'which', '83811843');
INSERT INTO `grid50000` VALUES ('7182', 'permitted', '83811843');
INSERT INTO `grid50000` VALUES ('7183', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7184', 'free', '83811843');
INSERT INTO `grid50000` VALUES ('7185', 'exercise', '83811843');
INSERT INTO `grid50000` VALUES ('7186', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('7187', 'religion', '83811843');
INSERT INTO `grid50000` VALUES ('7188', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('7189', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7190', 'secularization', '83811843');
INSERT INTO `grid50000` VALUES ('7191', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('7192', 'education', '83811843');
INSERT INTO `grid50000` VALUES ('7193', 'science', '83811843');
INSERT INTO `grid50000` VALUES ('7194', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('7195', 'art', '83811843');
INSERT INTO `grid50000` VALUES ('7196', 'Pragues', '83811843');
INSERT INTO `grid50000` VALUES ('7197', 'Jewish', '83811843');
INSERT INTO `grid50000` VALUES ('7198', 'town', '83811843');
INSERT INTO `grid50000` VALUES ('7199', 'is', '83811843');
INSERT INTO `grid50000` VALUES ('7200', 'called', '83811843');
INSERT INTO `grid50000` VALUES ('7201', 'Josefov', '83811843');
INSERT INTO `grid50000` VALUES ('7202', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('7203', 'this', '83811843');
INSERT INTO `grid50000` VALUES ('7204', 'day', '83811843');
INSERT INTO `grid50000` VALUES ('7205', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('7206', 'honor', '83811843');
INSERT INTO `grid50000` VALUES ('7207', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('7208', 'Josef', '83811843');
INSERT INTO `grid50000` VALUES ('7209', 'II', '83811843');
INSERT INTO `grid50000` VALUES ('7210', '\r\n\r\nThe', '83811843');
INSERT INTO `grid50000` VALUES ('7211', 'Industrial', '83811843');
INSERT INTO `grid50000` VALUES ('7212', 'Revolution', '83811843');
INSERT INTO `grid50000` VALUES ('7213', 'as', '83811843');
INSERT INTO `grid50000` VALUES ('7214', 'most', '83811843');
INSERT INTO `grid50000` VALUES ('7215', 'revolutions', '83811843');
INSERT INTO `grid50000` VALUES ('7216', 'do', '83811843');
INSERT INTO `grid50000` VALUES ('7217', 'started', '83811843');
INSERT INTO `grid50000` VALUES ('7218', 'off', '83811843');
INSERT INTO `grid50000` VALUES ('7219', 'small', '83811843');
INSERT INTO `grid50000` VALUES ('7220', 'at', '83811843');
INSERT INTO `grid50000` VALUES ('7221', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7222', 'end', '83811843');
INSERT INTO `grid50000` VALUES ('7223', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('7224', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7225', '18th', '83811843');
INSERT INTO `grid50000` VALUES ('7226', 'century', '83811843');
INSERT INTO `grid50000` VALUES ('7227', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('7228', 'then', '83811843');
INSERT INTO `grid50000` VALUES ('7229', 'really', '83811843');
INSERT INTO `grid50000` VALUES ('7230', 'picked', '83811843');
INSERT INTO `grid50000` VALUES ('7231', 'up', '83811843');
INSERT INTO `grid50000` VALUES ('7232', 'steam', '83811843');
INSERT INTO `grid50000` VALUES ('7233', '', '83811843');
INSERT INTO `grid50000` VALUES ('7234', 'so', '83811843');
INSERT INTO `grid50000` VALUES ('7235', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('7236', 'speak', '83811843');
INSERT INTO `grid50000` VALUES ('7237', '', '83811843');
INSERT INTO `grid50000` VALUES ('7238', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('7239', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7240', '19th', '83811843');
INSERT INTO `grid50000` VALUES ('7241', 'century', '83811843');
INSERT INTO `grid50000` VALUES ('7242', 'It', '83811843');
INSERT INTO `grid50000` VALUES ('7243', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('7244', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('7245', 'have', '83811843');
INSERT INTO `grid50000` VALUES ('7246', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('7247', 'monumental', '83811843');
INSERT INTO `grid50000` VALUES ('7248', 'impact', '83811843');
INSERT INTO `grid50000` VALUES ('7249', 'on', '83811843');
INSERT INTO `grid50000` VALUES ('7250', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7251', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('7252', 'lands', '83811843');
INSERT INTO `grid50000` VALUES ('7253', '\r\n\r\nThe', '83811843');
INSERT INTO `grid50000` VALUES ('7254', 'first', '83811843');
INSERT INTO `grid50000` VALUES ('7255', 'factories', '83811843');
INSERT INTO `grid50000` VALUES ('7256', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('7257', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7258', 'Austrian', '83811843');
INSERT INTO `grid50000` VALUES ('7259', 'Empire', '83811843');
INSERT INTO `grid50000` VALUES ('7260', 'were', '83811843');
INSERT INTO `grid50000` VALUES ('7261', 'built', '83811843');
INSERT INTO `grid50000` VALUES ('7262', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('7263', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7264', 'mountainous', '83811843');
INSERT INTO `grid50000` VALUES ('7265', 'border', '83811843');
INSERT INTO `grid50000` VALUES ('7266', 'regions', '83811843');
INSERT INTO `grid50000` VALUES ('7267', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('7268', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7269', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('7270', 'lands', '83811843');
INSERT INTO `grid50000` VALUES ('7271', 'where', '83811843');
INSERT INTO `grid50000` VALUES ('7272', 'there', '83811843');
INSERT INTO `grid50000` VALUES ('7273', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('7274', 'no', '83811843');
INSERT INTO `grid50000` VALUES ('7275', 'shortage', '83811843');
INSERT INTO `grid50000` VALUES ('7276', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('7277', 'water', '83811843');
INSERT INTO `grid50000` VALUES ('7278', 'power', '83811843');
INSERT INTO `grid50000` VALUES ('7279', 'from', '83811843');
INSERT INTO `grid50000` VALUES ('7280', 'rushing', '83811843');
INSERT INTO `grid50000` VALUES ('7281', 'streams', '83811843');
INSERT INTO `grid50000` VALUES ('7282', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('7283', 'rivers', '83811843');
INSERT INTO `grid50000` VALUES ('7284', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('7285', 'run', '83811843');
INSERT INTO `grid50000` VALUES ('7286', 'them', '83811843');
INSERT INTO `grid50000` VALUES ('7287', 'While', '83811843');
INSERT INTO `grid50000` VALUES ('7288', 'it', '83811843');
INSERT INTO `grid50000` VALUES ('7289', 'did', '83811843');
INSERT INTO `grid50000` VALUES ('7290', 'not', '83811843');
INSERT INTO `grid50000` VALUES ('7291', 'take', '83811843');
INSERT INTO `grid50000` VALUES ('7292', 'long', '83811843');
INSERT INTO `grid50000` VALUES ('7293', 'for', '83811843');
INSERT INTO `grid50000` VALUES ('7294', 'steam', '83811843');
INSERT INTO `grid50000` VALUES ('7295', 'power', '83811843');
INSERT INTO `grid50000` VALUES ('7296', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('7297', 'be', '83811843');
INSERT INTO `grid50000` VALUES ('7298', 'harnessed', '83811843');
INSERT INTO `grid50000` VALUES ('7299', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7300', 'industrial', '83811843');
INSERT INTO `grid50000` VALUES ('7301', 'boundaries', '83811843');
INSERT INTO `grid50000` VALUES ('7302', 'had', '83811843');
INSERT INTO `grid50000` VALUES ('7303', 'been', '83811843');
INSERT INTO `grid50000` VALUES ('7304', 'drawn', '83811843');
INSERT INTO `grid50000` VALUES ('7305', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('7306', 'these', '83811843');
INSERT INTO `grid50000` VALUES ('7307', 'regions', '83811843');
INSERT INTO `grid50000` VALUES ('7308', 'remain', '83811843');
INSERT INTO `grid50000` VALUES ('7309', 'predominantly', '83811843');
INSERT INTO `grid50000` VALUES ('7310', 'industrial', '83811843');
INSERT INTO `grid50000` VALUES ('7311', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('7312', 'this', '83811843');
INSERT INTO `grid50000` VALUES ('7313', 'day', '83811843');
INSERT INTO `grid50000` VALUES ('7314', '\r\n\r\nRailway', '83811843');
INSERT INTO `grid50000` VALUES ('7315', 'lines', '83811843');
INSERT INTO `grid50000` VALUES ('7316', 'were', '83811843');
INSERT INTO `grid50000` VALUES ('7317', 'laid', '83811843');
INSERT INTO `grid50000` VALUES ('7318', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('7319', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7320', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('7321', 'lands', '83811843');
INSERT INTO `grid50000` VALUES ('7322', 'by', '83811843');
INSERT INTO `grid50000` VALUES ('7323', 'Jan', '83811843');
INSERT INTO `grid50000` VALUES ('7324', 'Perner', '83811843');
INSERT INTO `grid50000` VALUES ('7325', '', '83811843');
INSERT INTO `grid50000` VALUES ('7326', 'who', '83811843');
INSERT INTO `grid50000` VALUES ('7327', 'met', '83811843');
INSERT INTO `grid50000` VALUES ('7328', 'his', '83811843');
INSERT INTO `grid50000` VALUES ('7329', 'death', '83811843');
INSERT INTO `grid50000` VALUES ('7330', 'when', '83811843');
INSERT INTO `grid50000` VALUES ('7331', 'he', '83811843');
INSERT INTO `grid50000` VALUES ('7332', 'hit', '83811843');
INSERT INTO `grid50000` VALUES ('7333', 'his', '83811843');
INSERT INTO `grid50000` VALUES ('7334', 'head', '83811843');
INSERT INTO `grid50000` VALUES ('7335', 'against', '83811843');
INSERT INTO `grid50000` VALUES ('7336', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('7337', 'pole', '83811843');
INSERT INTO `grid50000` VALUES ('7338', 'while', '83811843');
INSERT INTO `grid50000` VALUES ('7339', 'leaning', '83811843');
INSERT INTO `grid50000` VALUES ('7340', 'out', '83811843');
INSERT INTO `grid50000` VALUES ('7341', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('7342', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7343', 'window', '83811843');
INSERT INTO `grid50000` VALUES ('7344', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('7345', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('7346', 'moving', '83811843');
INSERT INTO `grid50000` VALUES ('7347', 'train', '83811843');
INSERT INTO `grid50000` VALUES ('7348', '', '83811843');
INSERT INTO `grid50000` VALUES ('7349', 'an', '83811843');
INSERT INTO `grid50000` VALUES ('7350', 'activity', '83811843');
INSERT INTO `grid50000` VALUES ('7351', 'which', '83811843');
INSERT INTO `grid50000` VALUES ('7352', 'has', '83811843');
INSERT INTO `grid50000` VALUES ('7353', 'been', '83811843');
INSERT INTO `grid50000` VALUES ('7354', 'forbidden', '83811843');
INSERT INTO `grid50000` VALUES ('7355', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('7356', 'this', '83811843');
INSERT INTO `grid50000` VALUES ('7357', 'country', '83811843');
INSERT INTO `grid50000` VALUES ('7358', 'since', '83811843');
INSERT INTO `grid50000` VALUES ('7359', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7360', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('7361', 'railway', '83811843');
INSERT INTO `grid50000` VALUES ('7362', 'pioneers', '83811843');
INSERT INTO `grid50000` VALUES ('7363', 'tragic', '83811843');
INSERT INTO `grid50000` VALUES ('7364', 'accident', '83811843');
INSERT INTO `grid50000` VALUES ('7365', '', '83811843');
INSERT INTO `grid50000` VALUES ('7366', 'Trams', '83811843');
INSERT INTO `grid50000` VALUES ('7367', 'mostly', '83811843');
INSERT INTO `grid50000` VALUES ('7368', 'constructed', '83811843');
INSERT INTO `grid50000` VALUES ('7369', 'by', '83811843');
INSERT INTO `grid50000` VALUES ('7370', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7371', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('7372', 'Thomas', '83811843');
INSERT INTO `grid50000` VALUES ('7373', 'Edison', '83811843');
INSERT INTO `grid50000` VALUES ('7374', 'Frantisek', '83811843');
INSERT INTO `grid50000` VALUES ('7375', 'Krizik', '83811843');
INSERT INTO `grid50000` VALUES ('7376', 'began', '83811843');
INSERT INTO `grid50000` VALUES ('7377', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('7378', 'carry', '83811843');
INSERT INTO `grid50000` VALUES ('7379', 'people', '83811843');
INSERT INTO `grid50000` VALUES ('7380', 'around', '83811843');
INSERT INTO `grid50000` VALUES ('7381', 'on', '83811843');
INSERT INTO `grid50000` VALUES ('7382', 'their', '83811843');
INSERT INTO `grid50000` VALUES ('7383', 'errands', '83811843');
INSERT INTO `grid50000` VALUES ('7384', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('7385', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('7386', 'between', '83811843');
INSERT INTO `grid50000` VALUES ('7387', 'major', '83811843');
INSERT INTO `grid50000` VALUES ('7388', 'towns', '83811843');
INSERT INTO `grid50000` VALUES ('7389', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('7390', 'those', '83811843');
INSERT INTO `grid50000` VALUES ('7391', 'days', '83811843');
INSERT INTO `grid50000` VALUES ('7392', 'tram', '83811843');
INSERT INTO `grid50000` VALUES ('7393', 'lines', '83811843');
INSERT INTO `grid50000` VALUES ('7394', 'connected', '83811843');
INSERT INTO `grid50000` VALUES ('7395', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7396', 'cities', '83811843');
INSERT INTO `grid50000` VALUES ('7397', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('7398', 'Bratislava', '83811843');
INSERT INTO `grid50000` VALUES ('7399', 'Budapest', '83811843');
INSERT INTO `grid50000` VALUES ('7400', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('7401', 'Vienna', '83811843');
INSERT INTO `grid50000` VALUES ('7402', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('7403', 'each', '83811843');
INSERT INTO `grid50000` VALUES ('7404', 'other', '83811843');
INSERT INTO `grid50000` VALUES ('7405', '', '83811843');
INSERT INTO `grid50000` VALUES ('7406', 'about', '83811843');
INSERT INTO `grid50000` VALUES ('7407', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('7408', 'onehour', '83811843');
INSERT INTO `grid50000` VALUES ('7409', 'ride', '83811843');
INSERT INTO `grid50000` VALUES ('7410', 'It', '83811843');
INSERT INTO `grid50000` VALUES ('7411', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('7412', 'at', '83811843');
INSERT INTO `grid50000` VALUES ('7413', 'this', '83811843');
INSERT INTO `grid50000` VALUES ('7414', 'time', '83811843');
INSERT INTO `grid50000` VALUES ('7415', 'too', '83811843');
INSERT INTO `grid50000` VALUES ('7416', 'that', '83811843');
INSERT INTO `grid50000` VALUES ('7417', 'Gregor', '83811843');
INSERT INTO `grid50000` VALUES ('7418', 'Mendel', '83811843');
INSERT INTO `grid50000` VALUES ('7419', '', '83811843');
INSERT INTO `grid50000` VALUES ('7420', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('7421', 'conducting', '83811843');
INSERT INTO `grid50000` VALUES ('7422', 'his', '83811843');
INSERT INTO `grid50000` VALUES ('7423', 'famous', '83811843');
INSERT INTO `grid50000` VALUES ('7424', 'experiments', '83811843');
INSERT INTO `grid50000` VALUES ('7425', 'on', '83811843');
INSERT INTO `grid50000` VALUES ('7426', 'hereditary', '83811843');
INSERT INTO `grid50000` VALUES ('7427', 'with', '83811843');
INSERT INTO `grid50000` VALUES ('7428', 'peas', '83811843');
INSERT INTO `grid50000` VALUES ('7429', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('7430', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('7431', 'monastery', '83811843');
INSERT INTO `grid50000` VALUES ('7432', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('7433', 'Moravia', '83811843');
INSERT INTO `grid50000` VALUES ('7434', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('7435', 'that', '83811843');
INSERT INTO `grid50000` VALUES ('7436', 'Jan', '83811843');
INSERT INTO `grid50000` VALUES ('7437', 'Evangelista', '83811843');
INSERT INTO `grid50000` VALUES ('7438', 'Purkyne', '83811843');
INSERT INTO `grid50000` VALUES ('7439', 'peered', '83811843');
INSERT INTO `grid50000` VALUES ('7440', 'into', '83811843');
INSERT INTO `grid50000` VALUES ('7441', 'his', '83811843');
INSERT INTO `grid50000` VALUES ('7442', 'microscope', '83811843');
INSERT INTO `grid50000` VALUES ('7443', 'one', '83811843');
INSERT INTO `grid50000` VALUES ('7444', 'day', '83811843');
INSERT INTO `grid50000` VALUES ('7445', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('7446', 'discover', '83811843');
INSERT INTO `grid50000` VALUES ('7447', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('7448', 'cell', '83811843');
INSERT INTO `grid50000` VALUES ('7449', 'looking', '83811843');
INSERT INTO `grid50000` VALUES ('7450', 'back', '83811843');
INSERT INTO `grid50000` VALUES ('7451', 'at', '83811843');
INSERT INTO `grid50000` VALUES ('7452', 'him', '83811843');
INSERT INTO `grid50000` VALUES ('7453', 'he', '83811843');
INSERT INTO `grid50000` VALUES ('7454', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('7455', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7456', 'first', '83811843');
INSERT INTO `grid50000` VALUES ('7457', 'person', '83811843');
INSERT INTO `grid50000` VALUES ('7458', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('7459', 'recognize', '83811843');
INSERT INTO `grid50000` VALUES ('7460', 'it', '83811843');
INSERT INTO `grid50000` VALUES ('7461', 'as', '83811843');
INSERT INTO `grid50000` VALUES ('7462', 'such', '83811843');
INSERT INTO `grid50000` VALUES ('7463', '\r\n\r\n', '83811843');
INSERT INTO `grid50000` VALUES ('7464', 'The', '83811843');
INSERT INTO `grid50000` VALUES ('7465', 'major', '83811843');
INSERT INTO `grid50000` VALUES ('7466', 'architectural', '83811843');
INSERT INTO `grid50000` VALUES ('7467', 'styles', '83811843');
INSERT INTO `grid50000` VALUES ('7468', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('7469', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7470', 'time', '83811843');
INSERT INTO `grid50000` VALUES ('7471', 'were', '83811843');
INSERT INTO `grid50000` VALUES ('7472', 'Classicist', '83811843');
INSERT INTO `grid50000` VALUES ('7473', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('7474', 'Empire', '83811843');
INSERT INTO `grid50000` VALUES ('7475', 'both', '83811843');
INSERT INTO `grid50000` VALUES ('7476', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('7477', 'which', '83811843');
INSERT INTO `grid50000` VALUES ('7478', 'used', '83811843');
INSERT INTO `grid50000` VALUES ('7479', 'classical', '83811843');
INSERT INTO `grid50000` VALUES ('7480', 'Greek', '83811843');
INSERT INTO `grid50000` VALUES ('7481', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('7482', 'Roman', '83811843');
INSERT INTO `grid50000` VALUES ('7483', 'motifs', '83811843');
INSERT INTO `grid50000` VALUES ('7484', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('7485', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('7486', 'balanced', '83811843');
INSERT INTO `grid50000` VALUES ('7487', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('7488', 'simple', '83811843');
INSERT INTO `grid50000` VALUES ('7489', 'design', '83811843');
INSERT INTO `grid50000` VALUES ('7490', 'Two', '83811843');
INSERT INTO `grid50000` VALUES ('7491', 'buildings', '83811843');
INSERT INTO `grid50000` VALUES ('7492', 'which', '83811843');
INSERT INTO `grid50000` VALUES ('7493', 'are', '83811843');
INSERT INTO `grid50000` VALUES ('7494', 'closely', '83811843');
INSERT INTO `grid50000` VALUES ('7495', 'associated', '83811843');
INSERT INTO `grid50000` VALUES ('7496', 'with', '83811843');
INSERT INTO `grid50000` VALUES ('7497', 'Mozarts', '83811843');
INSERT INTO `grid50000` VALUES ('7498', 'stay', '83811843');
INSERT INTO `grid50000` VALUES ('7499', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('7500', 'Prague', '83811843');
INSERT INTO `grid50000` VALUES ('7501', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('7502', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7503', 'late', '83811843');
INSERT INTO `grid50000` VALUES ('7504', '18th', '83811843');
INSERT INTO `grid50000` VALUES ('7505', 'century', '83811843');
INSERT INTO `grid50000` VALUES ('7506', 'are', '83811843');
INSERT INTO `grid50000` VALUES ('7507', 'excellent', '83811843');
INSERT INTO `grid50000` VALUES ('7508', 'examples', '83811843');
INSERT INTO `grid50000` VALUES ('7509', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('7510', 'these', '83811843');
INSERT INTO `grid50000` VALUES ('7511', 'styles:', '83811843');
INSERT INTO `grid50000` VALUES ('7512', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7513', 'Estates', '83811843');
INSERT INTO `grid50000` VALUES ('7514', 'Theatre', '83811843');
INSERT INTO `grid50000` VALUES ('7515', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('7516', 'which', '83811843');
INSERT INTO `grid50000` VALUES ('7517', 'Mozart', '83811843');
INSERT INTO `grid50000` VALUES ('7518', 'conducted', '83811843');
INSERT INTO `grid50000` VALUES ('7519', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7520', 'premier', '83811843');
INSERT INTO `grid50000` VALUES ('7521', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('7522', 'Don', '83811843');
INSERT INTO `grid50000` VALUES ('7523', 'Giovanni', '83811843');
INSERT INTO `grid50000` VALUES ('7524', 'is', '83811843');
INSERT INTO `grid50000` VALUES ('7525', 'Classicist', '83811843');
INSERT INTO `grid50000` VALUES ('7526', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('7527', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7528', 'Bertramka', '83811843');
INSERT INTO `grid50000` VALUES ('7529', 'villa', '83811843');
INSERT INTO `grid50000` VALUES ('7530', 'where', '83811843');
INSERT INTO `grid50000` VALUES ('7531', 'he', '83811843');
INSERT INTO `grid50000` VALUES ('7532', 'stayed', '83811843');
INSERT INTO `grid50000` VALUES ('7533', 'with', '83811843');
INSERT INTO `grid50000` VALUES ('7534', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7535', 'Dusek', '83811843');
INSERT INTO `grid50000` VALUES ('7536', 'family', '83811843');
INSERT INTO `grid50000` VALUES ('7537', 'is', '83811843');
INSERT INTO `grid50000` VALUES ('7538', 'one', '83811843');
INSERT INTO `grid50000` VALUES ('7539', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('7540', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7541', 'purest', '83811843');
INSERT INTO `grid50000` VALUES ('7542', 'examples', '83811843');
INSERT INTO `grid50000` VALUES ('7543', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('7544', 'Empire', '83811843');
INSERT INTO `grid50000` VALUES ('7545', 'that', '83811843');
INSERT INTO `grid50000` VALUES ('7546', 'exists', '83811843');
INSERT INTO `grid50000` VALUES ('7547', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('7548', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7549', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('7550', 'Republic', '83811843');
INSERT INTO `grid50000` VALUES ('7551', 'But', '83811843');
INSERT INTO `grid50000` VALUES ('7552', 'we', '83811843');
INSERT INTO `grid50000` VALUES ('7553', 'digress', '83811843');
INSERT INTO `grid50000` VALUES ('7554', '\r\n\r\n', '83811843');
INSERT INTO `grid50000` VALUES ('7555', 'Industrialization', '83811843');
INSERT INTO `grid50000` VALUES ('7556', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('7557', 'not', '83811843');
INSERT INTO `grid50000` VALUES ('7558', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7559', 'only', '83811843');
INSERT INTO `grid50000` VALUES ('7560', 'big', '83811843');
INSERT INTO `grid50000` VALUES ('7561', 'change', '83811843');
INSERT INTO `grid50000` VALUES ('7562', 'taking', '83811843');
INSERT INTO `grid50000` VALUES ('7563', 'place', '83811843');
INSERT INTO `grid50000` VALUES ('7564', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('7565', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7566', 'Austrian', '83811843');
INSERT INTO `grid50000` VALUES ('7567', 'Empire', '83811843');
INSERT INTO `grid50000` VALUES ('7568', 'at', '83811843');
INSERT INTO `grid50000` VALUES ('7569', 'this', '83811843');
INSERT INTO `grid50000` VALUES ('7570', 'time', '83811843');
INSERT INTO `grid50000` VALUES ('7571', 'The', '83811843');
INSERT INTO `grid50000` VALUES ('7572', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('7573', 'nation', '83811843');
INSERT INTO `grid50000` VALUES ('7574', 'like', '83811843');
INSERT INTO `grid50000` VALUES ('7575', 'most', '83811843');
INSERT INTO `grid50000` VALUES ('7576', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('7577', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7578', 'others', '83811843');
INSERT INTO `grid50000` VALUES ('7579', 'under', '83811843');
INSERT INTO `grid50000` VALUES ('7580', 'Austrian', '83811843');
INSERT INTO `grid50000` VALUES ('7581', 'rule', '83811843');
INSERT INTO `grid50000` VALUES ('7582', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('7583', 'also', '83811843');
INSERT INTO `grid50000` VALUES ('7584', 'going', '83811843');
INSERT INTO `grid50000` VALUES ('7585', 'through', '83811843');
INSERT INTO `grid50000` VALUES ('7586', 'political', '83811843');
INSERT INTO `grid50000` VALUES ('7587', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('7588', 'cultural', '83811843');
INSERT INTO `grid50000` VALUES ('7589', 'changes', '83811843');
INSERT INTO `grid50000` VALUES ('7590', 'leading', '83811843');
INSERT INTO `grid50000` VALUES ('7591', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('7592', 'demands', '83811843');
INSERT INTO `grid50000` VALUES ('7593', 'for', '83811843');
INSERT INTO `grid50000` VALUES ('7594', 'greater', '83811843');
INSERT INTO `grid50000` VALUES ('7595', 'autonomy', '83811843');
INSERT INTO `grid50000` VALUES ('7596', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('7597', 'self', '83811843');
INSERT INTO `grid50000` VALUES ('7598', 'determination', '83811843');
INSERT INTO `grid50000` VALUES ('7599', 'for', '83811843');
INSERT INTO `grid50000` VALUES ('7600', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7601', 'different', '83811843');
INSERT INTO `grid50000` VALUES ('7602', 'nations', '83811843');
INSERT INTO `grid50000` VALUES ('7603', 'under', '83811843');
INSERT INTO `grid50000` VALUES ('7604', 'Austrian', '83811843');
INSERT INTO `grid50000` VALUES ('7605', 'rule', '83811843');
INSERT INTO `grid50000` VALUES ('7606', '\r\n\r\nIn', '83811843');
INSERT INTO `grid50000` VALUES ('7607', 'this', '83811843');
INSERT INTO `grid50000` VALUES ('7608', 'country', '83811843');
INSERT INTO `grid50000` VALUES ('7609', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7610', 'push', '83811843');
INSERT INTO `grid50000` VALUES ('7611', 'for', '83811843');
INSERT INTO `grid50000` VALUES ('7612', 'autonomy', '83811843');
INSERT INTO `grid50000` VALUES ('7613', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('7614', 'known', '83811843');
INSERT INTO `grid50000` VALUES ('7615', 'as', '83811843');
INSERT INTO `grid50000` VALUES ('7616', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7617', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('7618', 'National', '83811843');
INSERT INTO `grid50000` VALUES ('7619', 'Revival', '83811843');
INSERT INTO `grid50000` VALUES ('7620', 'movement', '83811843');
INSERT INTO `grid50000` VALUES ('7621', 'Narodni', '83811843');
INSERT INTO `grid50000` VALUES ('7622', 'obrozeni', '83811843');
INSERT INTO `grid50000` VALUES ('7623', 'The', '83811843');
INSERT INTO `grid50000` VALUES ('7624', 'dominant', '83811843');
INSERT INTO `grid50000` VALUES ('7625', 'political', '83811843');
INSERT INTO `grid50000` VALUES ('7626', 'leaders', '83811843');
INSERT INTO `grid50000` VALUES ('7627', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('7628', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7629', 'movement', '83811843');
INSERT INTO `grid50000` VALUES ('7630', '', '83811843');
INSERT INTO `grid50000` VALUES ('7631', 'Frantisek', '83811843');
INSERT INTO `grid50000` VALUES ('7632', 'Palacky', '83811843');
INSERT INTO `grid50000` VALUES ('7633', 'Frantisek', '83811843');
INSERT INTO `grid50000` VALUES ('7634', 'Ladislav', '83811843');
INSERT INTO `grid50000` VALUES ('7635', 'Rieger', '83811843');
INSERT INTO `grid50000` VALUES ('7636', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('7637', 'Karel', '83811843');
INSERT INTO `grid50000` VALUES ('7638', 'Havlicek', '83811843');
INSERT INTO `grid50000` VALUES ('7639', 'Borovsky', '83811843');
INSERT INTO `grid50000` VALUES ('7640', '', '83811843');
INSERT INTO `grid50000` VALUES ('7641', 'were', '83811843');
INSERT INTO `grid50000` VALUES ('7642', 'liberals', '83811843');
INSERT INTO `grid50000` VALUES ('7643', 'This', '83811843');
INSERT INTO `grid50000` VALUES ('7644', 'meant', '83811843');
INSERT INTO `grid50000` VALUES ('7645', 'that', '83811843');
INSERT INTO `grid50000` VALUES ('7646', 'they', '83811843');
INSERT INTO `grid50000` VALUES ('7647', 'wanted', '83811843');
INSERT INTO `grid50000` VALUES ('7648', 'reforms', '83811843');
INSERT INTO `grid50000` VALUES ('7649', 'within', '83811843');
INSERT INTO `grid50000` VALUES ('7650', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7651', 'Austrian', '83811843');
INSERT INTO `grid50000` VALUES ('7652', 'monarchy', '83811843');
INSERT INTO `grid50000` VALUES ('7653', 'but', '83811843');
INSERT INTO `grid50000` VALUES ('7654', 'did', '83811843');
INSERT INTO `grid50000` VALUES ('7655', 'not', '83811843');
INSERT INTO `grid50000` VALUES ('7656', 'want', '83811843');
INSERT INTO `grid50000` VALUES ('7657', 'independence', '83811843');
INSERT INTO `grid50000` VALUES ('7658', 'for', '83811843');
INSERT INTO `grid50000` VALUES ('7659', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7660', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('7661', 'lands', '83811843');
INSERT INTO `grid50000` VALUES ('7662', 'This', '83811843');
INSERT INTO `grid50000` VALUES ('7663', 'brought', '83811843');
INSERT INTO `grid50000` VALUES ('7664', 'them', '83811843');
INSERT INTO `grid50000` VALUES ('7665', 'into', '83811843');
INSERT INTO `grid50000` VALUES ('7666', 'conflict', '83811843');
INSERT INTO `grid50000` VALUES ('7667', 'with', '83811843');
INSERT INTO `grid50000` VALUES ('7668', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7669', 'democrats', '83811843');
INSERT INTO `grid50000` VALUES ('7670', 'who', '83811843');
INSERT INTO `grid50000` VALUES ('7671', 'were', '83811843');
INSERT INTO `grid50000` VALUES ('7672', 'republican', '83811843');
INSERT INTO `grid50000` VALUES ('7673', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('7674', 'fiercely', '83811843');
INSERT INTO `grid50000` VALUES ('7675', 'antiMonarchy', '83811843');
INSERT INTO `grid50000` VALUES ('7676', '\r\n\r\nBut', '83811843');
INSERT INTO `grid50000` VALUES ('7677', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7678', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('7679', 'National', '83811843');
INSERT INTO `grid50000` VALUES ('7680', 'Revival', '83811843');
INSERT INTO `grid50000` VALUES ('7681', 'movement', '83811843');
INSERT INTO `grid50000` VALUES ('7682', 'almost', '83811843');
INSERT INTO `grid50000` VALUES ('7683', 'had', '83811843');
INSERT INTO `grid50000` VALUES ('7684', 'more', '83811843');
INSERT INTO `grid50000` VALUES ('7685', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('7686', 'do', '83811843');
INSERT INTO `grid50000` VALUES ('7687', 'with', '83811843');
INSERT INTO `grid50000` VALUES ('7688', 'culture', '83811843');
INSERT INTO `grid50000` VALUES ('7689', 'than', '83811843');
INSERT INTO `grid50000` VALUES ('7690', 'with', '83811843');
INSERT INTO `grid50000` VALUES ('7691', 'politics', '83811843');
INSERT INTO `grid50000` VALUES ('7692', 'Frantisek', '83811843');
INSERT INTO `grid50000` VALUES ('7693', 'Palacky', '83811843');
INSERT INTO `grid50000` VALUES ('7694', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('7695', 'Karel', '83811843');
INSERT INTO `grid50000` VALUES ('7696', 'Havlicek', '83811843');
INSERT INTO `grid50000` VALUES ('7697', 'Borovsky', '83811843');
INSERT INTO `grid50000` VALUES ('7698', 'who', '83811843');
INSERT INTO `grid50000` VALUES ('7699', 'are', '83811843');
INSERT INTO `grid50000` VALUES ('7700', 'mentioned', '83811843');
INSERT INTO `grid50000` VALUES ('7701', 'above', '83811843');
INSERT INTO `grid50000` VALUES ('7702', 'for', '83811843');
INSERT INTO `grid50000` VALUES ('7703', 'their', '83811843');
INSERT INTO `grid50000` VALUES ('7704', 'political', '83811843');
INSERT INTO `grid50000` VALUES ('7705', 'efforts', '83811843');
INSERT INTO `grid50000` VALUES ('7706', 'were', '83811843');
INSERT INTO `grid50000` VALUES ('7707', 'both', '83811843');
INSERT INTO `grid50000` VALUES ('7708', 'writers', '83811843');
INSERT INTO `grid50000` VALUES ('7709', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('7710', 'Literature', '83811843');
INSERT INTO `grid50000` VALUES ('7711', 'enjoyed', '83811843');
INSERT INTO `grid50000` VALUES ('7712', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('7713', 'Golden', '83811843');
INSERT INTO `grid50000` VALUES ('7714', 'Age', '83811843');
INSERT INTO `grid50000` VALUES ('7715', 'during', '83811843');
INSERT INTO `grid50000` VALUES ('7716', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7717', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('7718', 'National', '83811843');
INSERT INTO `grid50000` VALUES ('7719', 'Revival', '83811843');
INSERT INTO `grid50000` VALUES ('7720', 'as', '83811843');
INSERT INTO `grid50000` VALUES ('7721', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7722', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('7723', 'language', '83811843');
INSERT INTO `grid50000` VALUES ('7724', '', '83811843');
INSERT INTO `grid50000` VALUES ('7725', 'which', '83811843');
INSERT INTO `grid50000` VALUES ('7726', 'had', '83811843');
INSERT INTO `grid50000` VALUES ('7727', 'all', '83811843');
INSERT INTO `grid50000` VALUES ('7728', 'but', '83811843');
INSERT INTO `grid50000` VALUES ('7729', 'died', '83811843');
INSERT INTO `grid50000` VALUES ('7730', 'out', '83811843');
INSERT INTO `grid50000` VALUES ('7731', 'under', '83811843');
INSERT INTO `grid50000` VALUES ('7732', 'Habsburg', '83811843');
INSERT INTO `grid50000` VALUES ('7733', 'rule', '83811843');
INSERT INTO `grid50000` VALUES ('7734', '', '83811843');
INSERT INTO `grid50000` VALUES ('7735', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('7736', 'rediscovered', '83811843');
INSERT INTO `grid50000` VALUES ('7737', 'Other', '83811843');
INSERT INTO `grid50000` VALUES ('7738', 'notable', '83811843');
INSERT INTO `grid50000` VALUES ('7739', 'writers', '83811843');
INSERT INTO `grid50000` VALUES ('7740', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('7741', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7742', 'time', '83811843');
INSERT INTO `grid50000` VALUES ('7743', 'include', '83811843');
INSERT INTO `grid50000` VALUES ('7744', 'Bozena', '83811843');
INSERT INTO `grid50000` VALUES ('7745', 'Nemcova', '83811843');
INSERT INTO `grid50000` VALUES ('7746', 'Karel', '83811843');
INSERT INTO `grid50000` VALUES ('7747', 'Hynek', '83811843');
INSERT INTO `grid50000` VALUES ('7748', 'Macha', '83811843');
INSERT INTO `grid50000` VALUES ('7749', 'who', '83811843');
INSERT INTO `grid50000` VALUES ('7750', 'published', '83811843');
INSERT INTO `grid50000` VALUES ('7751', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7752', 'epic', '83811843');
INSERT INTO `grid50000` VALUES ('7753', 'lyrical', '83811843');
INSERT INTO `grid50000` VALUES ('7754', 'poem', '83811843');
INSERT INTO `grid50000` VALUES ('7755', 'Maj', '83811843');
INSERT INTO `grid50000` VALUES ('7756', 'then', '83811843');
INSERT INTO `grid50000` VALUES ('7757', 'died', '83811843');
INSERT INTO `grid50000` VALUES ('7758', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('7759', 'pneumonia', '83811843');
INSERT INTO `grid50000` VALUES ('7760', 'he', '83811843');
INSERT INTO `grid50000` VALUES ('7761', 'caught', '83811843');
INSERT INTO `grid50000` VALUES ('7762', 'while', '83811843');
INSERT INTO `grid50000` VALUES ('7763', 'fighting', '83811843');
INSERT INTO `grid50000` VALUES ('7764', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('7765', 'fire', '83811843');
INSERT INTO `grid50000` VALUES ('7766', 'one', '83811843');
INSERT INTO `grid50000` VALUES ('7767', 'month', '83811843');
INSERT INTO `grid50000` VALUES ('7768', 'before', '83811843');
INSERT INTO `grid50000` VALUES ('7769', 'he', '83811843');
INSERT INTO `grid50000` VALUES ('7770', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('7771', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('7772', 'be', '83811843');
INSERT INTO `grid50000` VALUES ('7773', 'married', '83811843');
INSERT INTO `grid50000` VALUES ('7774', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('7775', 'Josef', '83811843');
INSERT INTO `grid50000` VALUES ('7776', 'Jungmann', '83811843');
INSERT INTO `grid50000` VALUES ('7777', '', '83811843');
INSERT INTO `grid50000` VALUES ('7778', 'who', '83811843');
INSERT INTO `grid50000` VALUES ('7779', 'put', '83811843');
INSERT INTO `grid50000` VALUES ('7780', 'together', '83811843');
INSERT INTO `grid50000` VALUES ('7781', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7782', 'first', '83811843');
INSERT INTO `grid50000` VALUES ('7783', 'modern', '83811843');
INSERT INTO `grid50000` VALUES ('7784', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('7785', 'dictionary', '83811843');
INSERT INTO `grid50000` VALUES ('7786', '\r\n\r\nMany', '83811843');
INSERT INTO `grid50000` VALUES ('7787', 'popular', '83811843');
INSERT INTO `grid50000` VALUES ('7788', 'books', '83811843');
INSERT INTO `grid50000` VALUES ('7789', 'retelling', '83811843');
INSERT INTO `grid50000` VALUES ('7790', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7791', 'old', '83811843');
INSERT INTO `grid50000` VALUES ('7792', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('7793', 'legends', '83811843');
INSERT INTO `grid50000` VALUES ('7794', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('7795', 'Libuse', '83811843');
INSERT INTO `grid50000` VALUES ('7796', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('7797', 'Sarka', '83811843');
INSERT INTO `grid50000` VALUES ('7798', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('7799', 'Bivoj', '83811843');
INSERT INTO `grid50000` VALUES ('7800', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('7801', 'Bruncvik', '83811843');
INSERT INTO `grid50000` VALUES ('7802', 'were', '83811843');
INSERT INTO `grid50000` VALUES ('7803', 'published', '83811843');
INSERT INTO `grid50000` VALUES ('7804', 'at', '83811843');
INSERT INTO `grid50000` VALUES ('7805', 'this', '83811843');
INSERT INTO `grid50000` VALUES ('7806', 'time', '83811843');
INSERT INTO `grid50000` VALUES ('7807', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('7808', 'some', '83811843');
INSERT INTO `grid50000` VALUES ('7809', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('7810', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7811', 'leaders', '83811843');
INSERT INTO `grid50000` VALUES ('7812', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('7813', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7814', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('7815', 'National', '83811843');
INSERT INTO `grid50000` VALUES ('7816', 'Revival', '83811843');
INSERT INTO `grid50000` VALUES ('7817', 'even', '83811843');
INSERT INTO `grid50000` VALUES ('7818', 'falsified', '83811843');
INSERT INTO `grid50000` VALUES ('7819', 'ancient', '83811843');
INSERT INTO `grid50000` VALUES ('7820', '13th', '83811843');
INSERT INTO `grid50000` VALUES ('7821', 'century', '83811843');
INSERT INTO `grid50000` VALUES ('7822', 'texts', '83811843');
INSERT INTO `grid50000` VALUES ('7823', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('7824', 'these', '83811843');
INSERT INTO `grid50000` VALUES ('7825', 'legends', '83811843');
INSERT INTO `grid50000` VALUES ('7826', 'which', '83811843');
INSERT INTO `grid50000` VALUES ('7827', 'they', '83811843');
INSERT INTO `grid50000` VALUES ('7828', 'claimed', '83811843');
INSERT INTO `grid50000` VALUES ('7829', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('7830', 'have', '83811843');
INSERT INTO `grid50000` VALUES ('7831', 'found', '83811843');
INSERT INTO `grid50000` VALUES ('7832', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('7833', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('7834', 'cave', '83811843');
INSERT INTO `grid50000` VALUES ('7835', 'somewhere', '83811843');
INSERT INTO `grid50000` VALUES ('7836', 'Perhaps', '83811843');
INSERT INTO `grid50000` VALUES ('7837', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7838', 'only', '83811843');
INSERT INTO `grid50000` VALUES ('7839', 'authority', '83811843');
INSERT INTO `grid50000` VALUES ('7840', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('7841', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7842', 'movement', '83811843');
INSERT INTO `grid50000` VALUES ('7843', 'who', '83811843');
INSERT INTO `grid50000` VALUES ('7844', 'publicly', '83811843');
INSERT INTO `grid50000` VALUES ('7845', 'denied', '83811843');
INSERT INTO `grid50000` VALUES ('7846', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7847', 'authenticity', '83811843');
INSERT INTO `grid50000` VALUES ('7848', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('7849', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7850', 'texts', '83811843');
INSERT INTO `grid50000` VALUES ('7851', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('7852', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('7853', 'young', '83811843');
INSERT INTO `grid50000` VALUES ('7854', 'university', '83811843');
INSERT INTO `grid50000` VALUES ('7855', 'professor', '83811843');
INSERT INTO `grid50000` VALUES ('7856', 'by', '83811843');
INSERT INTO `grid50000` VALUES ('7857', 'name', '83811843');
INSERT INTO `grid50000` VALUES ('7858', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('7859', 'Tomas', '83811843');
INSERT INTO `grid50000` VALUES ('7860', 'Garrigue', '83811843');
INSERT INTO `grid50000` VALUES ('7861', 'Masaryk', '83811843');
INSERT INTO `grid50000` VALUES ('7862', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('7863', 'he', '83811843');
INSERT INTO `grid50000` VALUES ('7864', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('7865', 'passionately', '83811843');
INSERT INTO `grid50000` VALUES ('7866', 'detested', '83811843');
INSERT INTO `grid50000` VALUES ('7867', 'by', '83811843');
INSERT INTO `grid50000` VALUES ('7868', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7869', 'other', '83811843');
INSERT INTO `grid50000` VALUES ('7870', 'leaders', '83811843');
INSERT INTO `grid50000` VALUES ('7871', 'for', '83811843');
INSERT INTO `grid50000` VALUES ('7872', 'doing', '83811843');
INSERT INTO `grid50000` VALUES ('7873', 'so', '83811843');
INSERT INTO `grid50000` VALUES ('7874', '', '83811843');
INSERT INTO `grid50000` VALUES ('7875', '\r\n\r\nBut', '83811843');
INSERT INTO `grid50000` VALUES ('7876', 'we', '83811843');
INSERT INTO `grid50000` VALUES ('7877', 'digress', '83811843');
INSERT INTO `grid50000` VALUES ('7878', 'yet', '83811843');
INSERT INTO `grid50000` VALUES ('7879', 'again', '83811843');
INSERT INTO `grid50000` VALUES ('7880', 'France', '83811843');
INSERT INTO `grid50000` VALUES ('7881', 'had', '83811843');
INSERT INTO `grid50000` VALUES ('7882', 'its', '83811843');
INSERT INTO `grid50000` VALUES ('7883', 'infamous', '83811843');
INSERT INTO `grid50000` VALUES ('7884', 'revolution', '83811843');
INSERT INTO `grid50000` VALUES ('7885', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('7886', '1848', '83811843');
INSERT INTO `grid50000` VALUES ('7887', 'In', '83811843');
INSERT INTO `grid50000` VALUES ('7888', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7889', 'same', '83811843');
INSERT INTO `grid50000` VALUES ('7890', 'year', '83811843');
INSERT INTO `grid50000` VALUES ('7891', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('7892', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7893', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('7894', 'lands', '83811843');
INSERT INTO `grid50000` VALUES ('7895', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7896', 'feudal', '83811843');
INSERT INTO `grid50000` VALUES ('7897', 'system', '83811843');
INSERT INTO `grid50000` VALUES ('7898', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('7899', 'abolished', '83811843');
INSERT INTO `grid50000` VALUES ('7900', 'leading', '83811843');
INSERT INTO `grid50000` VALUES ('7901', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('7902', 'waves', '83811843');
INSERT INTO `grid50000` VALUES ('7903', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('7904', 'emigration', '83811843');
INSERT INTO `grid50000` VALUES ('7905', 'much', '83811843');
INSERT INTO `grid50000` VALUES ('7906', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('7907', 'it', '83811843');
INSERT INTO `grid50000` VALUES ('7908', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('7909', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7910', 'New', '83811843');
INSERT INTO `grid50000` VALUES ('7911', 'World', '83811843');
INSERT INTO `grid50000` VALUES ('7912', '', '83811843');
INSERT INTO `grid50000` VALUES ('7913', 'particularly', '83811843');
INSERT INTO `grid50000` VALUES ('7914', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('7915', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7916', 'United', '83811843');
INSERT INTO `grid50000` VALUES ('7917', 'States', '83811843');
INSERT INTO `grid50000` VALUES ('7918', 'In', '83811843');
INSERT INTO `grid50000` VALUES ('7919', 'June', '83811843');
INSERT INTO `grid50000` VALUES ('7920', '1848', '83811843');
INSERT INTO `grid50000` VALUES ('7921', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('7922', 'PanSlavic', '83811843');
INSERT INTO `grid50000` VALUES ('7923', 'Congress', '83811843');
INSERT INTO `grid50000` VALUES ('7924', 'convened', '83811843');
INSERT INTO `grid50000` VALUES ('7925', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('7926', 'Prague', '83811843');
INSERT INTO `grid50000` VALUES ('7927', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('7928', 'consider', '83811843');
INSERT INTO `grid50000` VALUES ('7929', 'possible', '83811843');
INSERT INTO `grid50000` VALUES ('7930', 'ways', '83811843');
INSERT INTO `grid50000` VALUES ('7931', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('7932', 'convincing', '83811843');
INSERT INTO `grid50000` VALUES ('7933', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7934', 'Habsburgs', '83811843');
INSERT INTO `grid50000` VALUES ('7935', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('7936', 'transform', '83811843');
INSERT INTO `grid50000` VALUES ('7937', 'their', '83811843');
INSERT INTO `grid50000` VALUES ('7938', 'empire', '83811843');
INSERT INTO `grid50000` VALUES ('7939', 'into', '83811843');
INSERT INTO `grid50000` VALUES ('7940', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('7941', 'federative', '83811843');
INSERT INTO `grid50000` VALUES ('7942', 'state', '83811843');
INSERT INTO `grid50000` VALUES ('7943', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('7944', 'equal', '83811843');
INSERT INTO `grid50000` VALUES ('7945', 'nations', '83811843');
INSERT INTO `grid50000` VALUES ('7946', 'something', '83811843');
INSERT INTO `grid50000` VALUES ('7947', 'like', '83811843');
INSERT INTO `grid50000` VALUES ('7948', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('7949', 'United', '83811843');
INSERT INTO `grid50000` VALUES ('7950', 'States', '83811843');
INSERT INTO `grid50000` VALUES ('7951', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('7952', 'Austria', '83811843');
INSERT INTO `grid50000` VALUES ('7953', 'Suddenly', '83811843');
INSERT INTO `grid50000` VALUES ('7954', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7955', 'discussions', '83811843');
INSERT INTO `grid50000` VALUES ('7956', 'were', '83811843');
INSERT INTO `grid50000` VALUES ('7957', 'interrupted', '83811843');
INSERT INTO `grid50000` VALUES ('7958', 'by', '83811843');
INSERT INTO `grid50000` VALUES ('7959', 'an', '83811843');
INSERT INTO `grid50000` VALUES ('7960', 'aimless', '83811843');
INSERT INTO `grid50000` VALUES ('7961', 'rebellion', '83811843');
INSERT INTO `grid50000` VALUES ('7962', 'inspired', '83811843');
INSERT INTO `grid50000` VALUES ('7963', 'by', '83811843');
INSERT INTO `grid50000` VALUES ('7964', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7965', 'French', '83811843');
INSERT INTO `grid50000` VALUES ('7966', 'Revolution', '83811843');
INSERT INTO `grid50000` VALUES ('7967', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('7968', 'including', '83811843');
INSERT INTO `grid50000` VALUES ('7969', 'dramatic', '83811843');
INSERT INTO `grid50000` VALUES ('7970', 'baracades', '83811843');
INSERT INTO `grid50000` VALUES ('7971', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('7972', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7973', 'streets', '83811843');
INSERT INTO `grid50000` VALUES ('7974', 'which', '83811843');
INSERT INTO `grid50000` VALUES ('7975', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('7976', 'led', '83811843');
INSERT INTO `grid50000` VALUES ('7977', 'by', '83811843');
INSERT INTO `grid50000` VALUES ('7978', 'bored', '83811843');
INSERT INTO `grid50000` VALUES ('7979', 'students', '83811843');
INSERT INTO `grid50000` VALUES ('7980', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('7981', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7982', 'most', '83811843');
INSERT INTO `grid50000` VALUES ('7983', 'radical', '83811843');
INSERT INTO `grid50000` VALUES ('7984', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('7985', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7986', 'radical', '83811843');
INSERT INTO `grid50000` VALUES ('7987', 'democrats', '83811843');
INSERT INTO `grid50000` VALUES ('7988', '\r\n\r\nThe', '83811843');
INSERT INTO `grid50000` VALUES ('7989', 'rebellion', '83811843');
INSERT INTO `grid50000` VALUES ('7990', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('7991', 'effortlessly', '83811843');
INSERT INTO `grid50000` VALUES ('7992', 'put', '83811843');
INSERT INTO `grid50000` VALUES ('7993', 'down', '83811843');
INSERT INTO `grid50000` VALUES ('7994', 'by', '83811843');
INSERT INTO `grid50000` VALUES ('7995', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('7996', 'local', '83811843');
INSERT INTO `grid50000` VALUES ('7997', 'Austrian', '83811843');
INSERT INTO `grid50000` VALUES ('7998', 'leader', '83811843');
INSERT INTO `grid50000` VALUES ('7999', 'Prince', '83811843');
INSERT INTO `grid50000` VALUES ('8000', 'Windischgratz', '83811843');
INSERT INTO `grid50000` VALUES ('8001', '', '83811843');
INSERT INTO `grid50000` VALUES ('8002', 'who', '83811843');
INSERT INTO `grid50000` VALUES ('8003', 'declared', '83811843');
INSERT INTO `grid50000` VALUES ('8004', 'martial', '83811843');
INSERT INTO `grid50000` VALUES ('8005', 'law', '83811843');
INSERT INTO `grid50000` VALUES ('8006', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('8007', 'on', '83811843');
INSERT INTO `grid50000` VALUES ('8008', 'June', '83811843');
INSERT INTO `grid50000` VALUES ('8009', '16', '83811843');
INSERT INTO `grid50000` VALUES ('8010', '1848', '83811843');
INSERT INTO `grid50000` VALUES ('8011', 'even', '83811843');
INSERT INTO `grid50000` VALUES ('8012', 'bombarded', '83811843');
INSERT INTO `grid50000` VALUES ('8013', 'Prague', '83811843');
INSERT INTO `grid50000` VALUES ('8014', 'from', '83811843');
INSERT INTO `grid50000` VALUES ('8015', 'Petrin', '83811843');
INSERT INTO `grid50000` VALUES ('8016', 'Hill', '83811843');
INSERT INTO `grid50000` VALUES ('8017', 'In', '83811843');
INSERT INTO `grid50000` VALUES ('8018', 'this', '83811843');
INSERT INTO `grid50000` VALUES ('8019', 'way', '83811843');
INSERT INTO `grid50000` VALUES ('8020', 'both', '83811843');
INSERT INTO `grid50000` VALUES ('8021', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8022', 'revolt', '83811843');
INSERT INTO `grid50000` VALUES ('8023', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('8024', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8025', 'PanSlavic', '83811843');
INSERT INTO `grid50000` VALUES ('8026', 'congress', '83811843');
INSERT INTO `grid50000` VALUES ('8027', 'both', '83811843');
INSERT INTO `grid50000` VALUES ('8028', 'came', '83811843');
INSERT INTO `grid50000` VALUES ('8029', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('8030', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('8031', 'premature', '83811843');
INSERT INTO `grid50000` VALUES ('8032', 'end', '83811843');
INSERT INTO `grid50000` VALUES ('8033', 'leaving', '83811843');
INSERT INTO `grid50000` VALUES ('8034', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8035', 'question', '83811843');
INSERT INTO `grid50000` VALUES ('8036', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('8037', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8038', 'future', '83811843');
INSERT INTO `grid50000` VALUES ('8039', 'shape', '83811843');
INSERT INTO `grid50000` VALUES ('8040', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('8041', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8042', 'Austrian', '83811843');
INSERT INTO `grid50000` VALUES ('8043', 'Empire', '83811843');
INSERT INTO `grid50000` VALUES ('8044', 'utterly', '83811843');
INSERT INTO `grid50000` VALUES ('8045', 'unresolved', '83811843');
INSERT INTO `grid50000` VALUES ('8046', 'In', '83811843');
INSERT INTO `grid50000` VALUES ('8047', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('8048', 'strange', '83811843');
INSERT INTO `grid50000` VALUES ('8049', 'aside', '83811843');
INSERT INTO `grid50000` VALUES ('8050', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('8051', 'this', '83811843');
INSERT INTO `grid50000` VALUES ('8052', 'episode', '83811843');
INSERT INTO `grid50000` VALUES ('8053', 'Prince', '83811843');
INSERT INTO `grid50000` VALUES ('8054', 'Windischgratzs', '83811843');
INSERT INTO `grid50000` VALUES ('8055', 'wife', '83811843');
INSERT INTO `grid50000` VALUES ('8056', 'lost', '83811843');
INSERT INTO `grid50000` VALUES ('8057', 'her', '83811843');
INSERT INTO `grid50000` VALUES ('8058', 'life', '83811843');
INSERT INTO `grid50000` VALUES ('8059', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('8060', 'all', '83811843');
INSERT INTO `grid50000` VALUES ('8061', 'this', '83811843');
INSERT INTO `grid50000` VALUES ('8062', 'commotion', '83811843');
INSERT INTO `grid50000` VALUES ('8063', '', '83811843');
INSERT INTO `grid50000` VALUES ('8064', 'shot', '83811843');
INSERT INTO `grid50000` VALUES ('8065', 'through', '83811843');
INSERT INTO `grid50000` VALUES ('8066', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('8067', 'window', '83811843');
INSERT INTO `grid50000` VALUES ('8068', 'while', '83811843');
INSERT INTO `grid50000` VALUES ('8069', 'she', '83811843');
INSERT INTO `grid50000` VALUES ('8070', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('8071', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('8072', 'her', '83811843');
INSERT INTO `grid50000` VALUES ('8073', 'apartment', '83811843');
INSERT INTO `grid50000` VALUES ('8074', 'To', '83811843');
INSERT INTO `grid50000` VALUES ('8075', 'this', '83811843');
INSERT INTO `grid50000` VALUES ('8076', 'day', '83811843');
INSERT INTO `grid50000` VALUES ('8077', 'nobody', '83811843');
INSERT INTO `grid50000` VALUES ('8078', 'knows', '83811843');
INSERT INTO `grid50000` VALUES ('8079', 'who', '83811843');
INSERT INTO `grid50000` VALUES ('8080', 'did', '83811843');
INSERT INTO `grid50000` VALUES ('8081', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8082', 'shooting', '83811843');
INSERT INTO `grid50000` VALUES ('8083', 'or', '83811843');
INSERT INTO `grid50000` VALUES ('8084', 'why', '83811843');
INSERT INTO `grid50000` VALUES ('8085', '\r\n\r\nScared', '83811843');
INSERT INTO `grid50000` VALUES ('8086', 'by', '83811843');
INSERT INTO `grid50000` VALUES ('8087', 'both', '83811843');
INSERT INTO `grid50000` VALUES ('8088', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8089', 'French', '83811843');
INSERT INTO `grid50000` VALUES ('8090', 'Revolution', '83811843');
INSERT INTO `grid50000` VALUES ('8091', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('8092', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8093', 'summer', '83811843');
INSERT INTO `grid50000` VALUES ('8094', 'rebellion', '83811843');
INSERT INTO `grid50000` VALUES ('8095', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('8096', 'Prague', '83811843');
INSERT INTO `grid50000` VALUES ('8097', 'Austria', '83811843');
INSERT INTO `grid50000` VALUES ('8098', 'introduced', '83811843');
INSERT INTO `grid50000` VALUES ('8099', 'something', '83811843');
INSERT INTO `grid50000` VALUES ('8100', 'akin', '83811843');
INSERT INTO `grid50000` VALUES ('8101', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('8102', 'martial', '83811843');
INSERT INTO `grid50000` VALUES ('8103', 'law', '83811843');
INSERT INTO `grid50000` VALUES ('8104', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('8105', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8106', 'whole', '83811843');
INSERT INTO `grid50000` VALUES ('8107', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('8108', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8109', 'Empire', '83811843');
INSERT INTO `grid50000` VALUES ('8110', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('8111', 'discourage', '83811843');
INSERT INTO `grid50000` VALUES ('8112', 'republican', '83811843');
INSERT INTO `grid50000` VALUES ('8113', 'efforts', '83811843');
INSERT INTO `grid50000` VALUES ('8114', 'at', '83811843');
INSERT INTO `grid50000` VALUES ('8115', 'independence', '83811843');
INSERT INTO `grid50000` VALUES ('8116', 'Autonomy', '83811843');
INSERT INTO `grid50000` VALUES ('8117', 'movements', '83811843');
INSERT INTO `grid50000` VALUES ('8118', 'throughout', '83811843');
INSERT INTO `grid50000` VALUES ('8119', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8120', 'Austrian', '83811843');
INSERT INTO `grid50000` VALUES ('8121', 'Empire', '83811843');
INSERT INTO `grid50000` VALUES ('8122', 'were', '83811843');
INSERT INTO `grid50000` VALUES ('8123', 'suppressed', '83811843');
INSERT INTO `grid50000` VALUES ('8124', 'But', '83811843');
INSERT INTO `grid50000` VALUES ('8125', 'as', '83811843');
INSERT INTO `grid50000` VALUES ('8126', 'revolutionary', '83811843');
INSERT INTO `grid50000` VALUES ('8127', 'movements', '83811843');
INSERT INTO `grid50000` VALUES ('8128', 'have', '83811843');
INSERT INTO `grid50000` VALUES ('8129', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('8130', 'tendency', '83811843');
INSERT INTO `grid50000` VALUES ('8131', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('8132', 'doing', '83811843');
INSERT INTO `grid50000` VALUES ('8133', 'this', '83811843');
INSERT INTO `grid50000` VALUES ('8134', 'one', '83811843');
INSERT INTO `grid50000` VALUES ('8135', 'did', '83811843');
INSERT INTO `grid50000` VALUES ('8136', 'not', '83811843');
INSERT INTO `grid50000` VALUES ('8137', 'die', '83811843');
INSERT INTO `grid50000` VALUES ('8138', 'down;', '83811843');
INSERT INTO `grid50000` VALUES ('8139', 'it', '83811843');
INSERT INTO `grid50000` VALUES ('8140', 'just', '83811843');
INSERT INTO `grid50000` VALUES ('8141', 'sat', '83811843');
INSERT INTO `grid50000` VALUES ('8142', 'around', '83811843');
INSERT INTO `grid50000` VALUES ('8143', 'simmering', '83811843');
INSERT INTO `grid50000` VALUES ('8144', 'below', '83811843');
INSERT INTO `grid50000` VALUES ('8145', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8146', 'ostensibly', '83811843');
INSERT INTO `grid50000` VALUES ('8147', 'calm', '83811843');
INSERT INTO `grid50000` VALUES ('8148', 'surface', '83811843');
INSERT INTO `grid50000` VALUES ('8149', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('8150', 'things', '83811843');
INSERT INTO `grid50000` VALUES ('8151', 'Tensions', '83811843');
INSERT INTO `grid50000` VALUES ('8152', 'did', '83811843');
INSERT INTO `grid50000` VALUES ('8153', 'not', '83811843');
INSERT INTO `grid50000` VALUES ('8154', 'decrease', '83811843');
INSERT INTO `grid50000` VALUES ('8155', 'On', '83811843');
INSERT INTO `grid50000` VALUES ('8156', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8157', 'contrary', '83811843');
INSERT INTO `grid50000` VALUES ('8158', '\r\n\r\nThe', '83811843');
INSERT INTO `grid50000` VALUES ('8159', 'Austrian', '83811843');
INSERT INTO `grid50000` VALUES ('8160', 'Empire', '83811843');
INSERT INTO `grid50000` VALUES ('8161', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('8162', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8163', 'time', '83811843');
INSERT INTO `grid50000` VALUES ('8164', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('8165', 'massive', '83811843');
INSERT INTO `grid50000` VALUES ('8166', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('8167', 'contained', '83811843');
INSERT INTO `grid50000` VALUES ('8168', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8169', 'territories', '83811843');
INSERT INTO `grid50000` VALUES ('8170', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('8171', 'many', '83811843');
INSERT INTO `grid50000` VALUES ('8172', 'modernday', '83811843');
INSERT INTO `grid50000` VALUES ('8173', 'countries', '83811843');
INSERT INTO `grid50000` VALUES ('8174', 'Most', '83811843');
INSERT INTO `grid50000` VALUES ('8175', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('8176', 'these', '83811843');
INSERT INTO `grid50000` VALUES ('8177', 'nationalities', '83811843');
INSERT INTO `grid50000` VALUES ('8178', 'were', '83811843');
INSERT INTO `grid50000` VALUES ('8179', 'clamoring', '83811843');
INSERT INTO `grid50000` VALUES ('8180', 'for', '83811843');
INSERT INTO `grid50000` VALUES ('8181', 'autonomy', '83811843');
INSERT INTO `grid50000` VALUES ('8182', '\r\n\r\nIn', '83811843');
INSERT INTO `grid50000` VALUES ('8183', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8184', '1860s', '83811843');
INSERT INTO `grid50000` VALUES ('8185', 'this', '83811843');
INSERT INTO `grid50000` VALUES ('8186', 'pressure', '83811843');
INSERT INTO `grid50000` VALUES ('8187', 'led', '83811843');
INSERT INTO `grid50000` VALUES ('8188', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8189', 'Habsburgs', '83811843');
INSERT INTO `grid50000` VALUES ('8190', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('8191', 'transform', '83811843');
INSERT INTO `grid50000` VALUES ('8192', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8193', 'Austrian', '83811843');
INSERT INTO `grid50000` VALUES ('8194', 'Empire', '83811843');
INSERT INTO `grid50000` VALUES ('8195', 'into', '83811843');
INSERT INTO `grid50000` VALUES ('8196', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8197', 'dualist', '83811843');
INSERT INTO `grid50000` VALUES ('8198', 'AustroHungarian', '83811843');
INSERT INTO `grid50000` VALUES ('8199', 'constitutional', '83811843');
INSERT INTO `grid50000` VALUES ('8200', 'monarchy', '83811843');
INSERT INTO `grid50000` VALUES ('8201', 'This', '83811843');
INSERT INTO `grid50000` VALUES ('8202', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('8203', 'just', '83811843');
INSERT INTO `grid50000` VALUES ('8204', 'hunkeydorey', '83811843');
INSERT INTO `grid50000` VALUES ('8205', 'by', '83811843');
INSERT INTO `grid50000` VALUES ('8206', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8207', 'Hungarians', '83811843');
INSERT INTO `grid50000` VALUES ('8208', 'but', '83811843');
INSERT INTO `grid50000` VALUES ('8209', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('8210', 'not', '83811843');
INSERT INTO `grid50000` VALUES ('8211', 'exactly', '83811843');
INSERT INTO `grid50000` VALUES ('8212', 'appreciated', '83811843');
INSERT INTO `grid50000` VALUES ('8213', 'by', '83811843');
INSERT INTO `grid50000` VALUES ('8214', 'most', '83811843');
INSERT INTO `grid50000` VALUES ('8215', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('8216', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8217', 'other', '83811843');
INSERT INTO `grid50000` VALUES ('8218', 'ethnic', '83811843');
INSERT INTO `grid50000` VALUES ('8219', 'nations', '83811843');
INSERT INTO `grid50000` VALUES ('8220', 'within', '83811843');
INSERT INTO `grid50000` VALUES ('8221', 'what', '83811843');
INSERT INTO `grid50000` VALUES ('8222', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('8223', 'now', '83811843');
INSERT INTO `grid50000` VALUES ('8224', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8225', 'AustroHungarian', '83811843');
INSERT INTO `grid50000` VALUES ('8226', 'Empire', '83811843');
INSERT INTO `grid50000` VALUES ('8227', '\r\n\r\nThe', '83811843');
INSERT INTO `grid50000` VALUES ('8228', 'Czechs', '83811843');
INSERT INTO `grid50000` VALUES ('8229', 'were', '83811843');
INSERT INTO `grid50000` VALUES ('8230', 'united', '83811843');
INSERT INTO `grid50000` VALUES ('8231', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('8232', 'their', '83811843');
INSERT INTO `grid50000` VALUES ('8233', 'opposition', '83811843');
INSERT INTO `grid50000` VALUES ('8234', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('8235', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8236', 'new', '83811843');
INSERT INTO `grid50000` VALUES ('8237', 'dual', '83811843');
INSERT INTO `grid50000` VALUES ('8238', 'system', '83811843');
INSERT INTO `grid50000` VALUES ('8239', 'but', '83811843');
INSERT INTO `grid50000` VALUES ('8240', 'they', '83811843');
INSERT INTO `grid50000` VALUES ('8241', 'were', '83811843');
INSERT INTO `grid50000` VALUES ('8242', 'divided', '83811843');
INSERT INTO `grid50000` VALUES ('8243', 'among', '83811843');
INSERT INTO `grid50000` VALUES ('8244', 'themselves', '83811843');
INSERT INTO `grid50000` VALUES ('8245', 'as', '83811843');
INSERT INTO `grid50000` VALUES ('8246', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('8247', 'what', '83811843');
INSERT INTO `grid50000` VALUES ('8248', 'they', '83811843');
INSERT INTO `grid50000` VALUES ('8249', 'wanted', '83811843');
INSERT INTO `grid50000` VALUES ('8250', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('8251', 'do', '83811843');
INSERT INTO `grid50000` VALUES ('8252', 'about', '83811843');
INSERT INTO `grid50000` VALUES ('8253', 'it', '83811843');
INSERT INTO `grid50000` VALUES ('8254', 'These', '83811843');
INSERT INTO `grid50000` VALUES ('8255', 'divisions', '83811843');
INSERT INTO `grid50000` VALUES ('8256', 'grew', '83811843');
INSERT INTO `grid50000` VALUES ('8257', 'deeper', '83811843');
INSERT INTO `grid50000` VALUES ('8258', 'as', '83811843');
INSERT INTO `grid50000` VALUES ('8259', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8260', '19th', '83811843');
INSERT INTO `grid50000` VALUES ('8261', 'century', '83811843');
INSERT INTO `grid50000` VALUES ('8262', 'progressed', '83811843');
INSERT INTO `grid50000` VALUES ('8263', '\r\n\r\nThere', '83811843');
INSERT INTO `grid50000` VALUES ('8264', 'were', '83811843');
INSERT INTO `grid50000` VALUES ('8265', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('8266', 'number', '83811843');
INSERT INTO `grid50000` VALUES ('8267', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('8268', 'rival', '83811843');
INSERT INTO `grid50000` VALUES ('8269', 'political', '83811843');
INSERT INTO `grid50000` VALUES ('8270', 'factions:', '83811843');
INSERT INTO `grid50000` VALUES ('8271', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8272', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('8273', 'National', '83811843');
INSERT INTO `grid50000` VALUES ('8274', 'Party', '83811843');
INSERT INTO `grid50000` VALUES ('8275', 'split', '83811843');
INSERT INTO `grid50000` VALUES ('8276', 'into', '83811843');
INSERT INTO `grid50000` VALUES ('8277', 'two', '83811843');
INSERT INTO `grid50000` VALUES ('8278', 'camps:', '83811843');
INSERT INTO `grid50000` VALUES ('8279', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8280', 'conservative', '83811843');
INSERT INTO `grid50000` VALUES ('8281', 'Old', '83811843');
INSERT INTO `grid50000` VALUES ('8282', 'Czechs', '83811843');
INSERT INTO `grid50000` VALUES ('8283', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('8284', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8285', 'liberal', '83811843');
INSERT INTO `grid50000` VALUES ('8286', 'Young', '83811843');
INSERT INTO `grid50000` VALUES ('8287', 'Czechs;', '83811843');
INSERT INTO `grid50000` VALUES ('8288', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8289', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('8290', 'Social', '83811843');
INSERT INTO `grid50000` VALUES ('8291', 'Democratic', '83811843');
INSERT INTO `grid50000` VALUES ('8292', 'Party', '83811843');
INSERT INTO `grid50000` VALUES ('8293', 'founded', '83811843');
INSERT INTO `grid50000` VALUES ('8294', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('8295', '1878;', '83811843');
INSERT INTO `grid50000` VALUES ('8296', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8297', 'progressives', '83811843');
INSERT INTO `grid50000` VALUES ('8298', 'who', '83811843');
INSERT INTO `grid50000` VALUES ('8299', 'favored', '83811843');
INSERT INTO `grid50000` VALUES ('8300', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8301', 'policies', '83811843');
INSERT INTO `grid50000` VALUES ('8302', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('8303', 'Tomas', '83811843');
INSERT INTO `grid50000` VALUES ('8304', 'Masaryk;', '83811843');
INSERT INTO `grid50000` VALUES ('8305', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8306', 'Agrarian', '83811843');
INSERT INTO `grid50000` VALUES ('8307', 'party;', '83811843');
INSERT INTO `grid50000` VALUES ('8308', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8309', 'Christian', '83811843');
INSERT INTO `grid50000` VALUES ('8310', 'Socialists;', '83811843');
INSERT INTO `grid50000` VALUES ('8311', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8312', 'National', '83811843');
INSERT INTO `grid50000` VALUES ('8313', 'Socialists;', '83811843');
INSERT INTO `grid50000` VALUES ('8314', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('8315', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8316', 'Radical', '83811843');
INSERT INTO `grid50000` VALUES ('8317', 'Progressives', '83811843');
INSERT INTO `grid50000` VALUES ('8318', '\r\n\r\nThe', '83811843');
INSERT INTO `grid50000` VALUES ('8319', 'majority', '83811843');
INSERT INTO `grid50000` VALUES ('8320', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('8321', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8322', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('8323', 'political', '83811843');
INSERT INTO `grid50000` VALUES ('8324', 'parties', '83811843');
INSERT INTO `grid50000` VALUES ('8325', 'supported', '83811843');
INSERT INTO `grid50000` VALUES ('8326', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('8327', 'program', '83811843');
INSERT INTO `grid50000` VALUES ('8328', 'calling', '83811843');
INSERT INTO `grid50000` VALUES ('8329', 'for', '83811843');
INSERT INTO `grid50000` VALUES ('8330', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8331', 'restoration', '83811843');
INSERT INTO `grid50000` VALUES ('8332', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('8333', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8334', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('8335', 'state', '83811843');
INSERT INTO `grid50000` VALUES ('8336', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('8337', 'its', '83811843');
INSERT INTO `grid50000` VALUES ('8338', 'historical', '83811843');
INSERT INTO `grid50000` VALUES ('8339', 'borders', '83811843');
INSERT INTO `grid50000` VALUES ('8340', '', '83811843');
INSERT INTO `grid50000` VALUES ('8341', 'but', '83811843');
INSERT INTO `grid50000` VALUES ('8342', 'within', '83811843');
INSERT INTO `grid50000` VALUES ('8343', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8344', 'framework', '83811843');
INSERT INTO `grid50000` VALUES ('8345', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('8346', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8347', 'Austrian', '83811843');
INSERT INTO `grid50000` VALUES ('8348', 'Empire', '83811843');
INSERT INTO `grid50000` VALUES ('8349', 'Again', '83811843');
INSERT INTO `grid50000` VALUES ('8350', 'each', '83811843');
INSERT INTO `grid50000` VALUES ('8351', 'party', '83811843');
INSERT INTO `grid50000` VALUES ('8352', 'had', '83811843');
INSERT INTO `grid50000` VALUES ('8353', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('8354', 'different', '83811843');
INSERT INTO `grid50000` VALUES ('8355', 'idea', '83811843');
INSERT INTO `grid50000` VALUES ('8356', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('8357', 'exactly', '83811843');
INSERT INTO `grid50000` VALUES ('8358', 'how', '83811843');
INSERT INTO `grid50000` VALUES ('8359', 'this', '83811843');
INSERT INTO `grid50000` VALUES ('8360', 'goal', '83811843');
INSERT INTO `grid50000` VALUES ('8361', 'should', '83811843');
INSERT INTO `grid50000` VALUES ('8362', 'be', '83811843');
INSERT INTO `grid50000` VALUES ('8363', 'accomplished', '83811843');
INSERT INTO `grid50000` VALUES ('8364', '\r\n\r\nThe', '83811843');
INSERT INTO `grid50000` VALUES ('8365', 'turn', '83811843');
INSERT INTO `grid50000` VALUES ('8366', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('8367', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8368', '19th', '83811843');
INSERT INTO `grid50000` VALUES ('8369', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('8370', '20th', '83811843');
INSERT INTO `grid50000` VALUES ('8371', 'centuries', '83811843');
INSERT INTO `grid50000` VALUES ('8372', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('8373', 'characterized', '83811843');
INSERT INTO `grid50000` VALUES ('8374', 'by', '83811843');
INSERT INTO `grid50000` VALUES ('8375', 'growing', '83811843');
INSERT INTO `grid50000` VALUES ('8376', 'economic', '83811843');
INSERT INTO `grid50000` VALUES ('8377', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('8378', 'political', '83811843');
INSERT INTO `grid50000` VALUES ('8379', 'freedom', '83811843');
INSERT INTO `grid50000` VALUES ('8380', 'for', '83811843');
INSERT INTO `grid50000` VALUES ('8381', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8382', 'Czechs', '83811843');
INSERT INTO `grid50000` VALUES ('8383', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('8384', 'by', '83811843');
INSERT INTO `grid50000` VALUES ('8385', 'outstanding', '83811843');
INSERT INTO `grid50000` VALUES ('8386', 'acheivements', '83811843');
INSERT INTO `grid50000` VALUES ('8387', 'on', '83811843');
INSERT INTO `grid50000` VALUES ('8388', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8389', 'part', '83811843');
INSERT INTO `grid50000` VALUES ('8390', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('8391', 'Czechs', '83811843');
INSERT INTO `grid50000` VALUES ('8392', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('8393', 'culture', '83811843');
INSERT INTO `grid50000` VALUES ('8394', 'medicine', '83811843');
INSERT INTO `grid50000` VALUES ('8395', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('8396', 'science', '83811843');
INSERT INTO `grid50000` VALUES ('8397', 'Architectural', '83811843');
INSERT INTO `grid50000` VALUES ('8398', 'trends', '83811843');
INSERT INTO `grid50000` VALUES ('8399', 'at', '83811843');
INSERT INTO `grid50000` VALUES ('8400', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8401', 'end', '83811843');
INSERT INTO `grid50000` VALUES ('8402', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('8403', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8404', 'century', '83811843');
INSERT INTO `grid50000` VALUES ('8405', 'were', '83811843');
INSERT INTO `grid50000` VALUES ('8406', 'romantic', '83811843');
INSERT INTO `grid50000` VALUES ('8407', 'copies', '83811843');
INSERT INTO `grid50000` VALUES ('8408', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('8409', 'past', '83811843');
INSERT INTO `grid50000` VALUES ('8410', 'styles', '83811843');
INSERT INTO `grid50000` VALUES ('8411', 'like', '83811843');
INSERT INTO `grid50000` VALUES ('8412', 'NeoGothic', '83811843');
INSERT INTO `grid50000` VALUES ('8413', 'These', '83811843');
INSERT INTO `grid50000` VALUES ('8414', 'romantic', '83811843');
INSERT INTO `grid50000` VALUES ('8415', 'enthusiasts', '83811843');
INSERT INTO `grid50000` VALUES ('8416', 'sometimes', '83811843');
INSERT INTO `grid50000` VALUES ('8417', 'did', '83811843');
INSERT INTO `grid50000` VALUES ('8418', 'more', '83811843');
INSERT INTO `grid50000` VALUES ('8419', 'harm', '83811843');
INSERT INTO `grid50000` VALUES ('8420', 'than', '83811843');
INSERT INTO `grid50000` VALUES ('8421', 'good', '83811843');
INSERT INTO `grid50000` VALUES ('8422', 'as', '83811843');
INSERT INTO `grid50000` VALUES ('8423', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('8424', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8425', 'case', '83811843');
INSERT INTO `grid50000` VALUES ('8426', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('8427', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8428', 'reconstruction', '83811843');
INSERT INTO `grid50000` VALUES ('8429', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('8430', 'Karlstejn', '83811843');
INSERT INTO `grid50000` VALUES ('8431', 'Castle', '83811843');
INSERT INTO `grid50000` VALUES ('8432', 'It', '83811843');
INSERT INTO `grid50000` VALUES ('8433', 'is', '83811843');
INSERT INTO `grid50000` VALUES ('8434', 'because', '83811843');
INSERT INTO `grid50000` VALUES ('8435', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('8436', 'this', '83811843');
INSERT INTO `grid50000` VALUES ('8437', 'illfated', '83811843');
INSERT INTO `grid50000` VALUES ('8438', 'reconstruction', '83811843');
INSERT INTO `grid50000` VALUES ('8439', 'that', '83811843');
INSERT INTO `grid50000` VALUES ('8440', 'Karlstejn', '83811843');
INSERT INTO `grid50000` VALUES ('8441', 'does', '83811843');
INSERT INTO `grid50000` VALUES ('8442', 'not', '83811843');
INSERT INTO `grid50000` VALUES ('8443', 'qualify', '83811843');
INSERT INTO `grid50000` VALUES ('8444', 'for', '83811843');
INSERT INTO `grid50000` VALUES ('8445', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8446', 'UNESCO', '83811843');
INSERT INTO `grid50000` VALUES ('8447', 'World', '83811843');
INSERT INTO `grid50000` VALUES ('8448', 'Heritage', '83811843');
INSERT INTO `grid50000` VALUES ('8449', 'list', '83811843');
INSERT INTO `grid50000` VALUES ('8450', 'today', '83811843');
INSERT INTO `grid50000` VALUES ('8451', 'In', '83811843');
INSERT INTO `grid50000` VALUES ('8452', 'other', '83811843');
INSERT INTO `grid50000` VALUES ('8453', 'cases', '83811843');
INSERT INTO `grid50000` VALUES ('8454', 'they', '83811843');
INSERT INTO `grid50000` VALUES ('8455', 'just', '83811843');
INSERT INTO `grid50000` VALUES ('8456', 'did', '83811843');
INSERT INTO `grid50000` VALUES ('8457', 'silly', '83811843');
INSERT INTO `grid50000` VALUES ('8458', 'things', '83811843');
INSERT INTO `grid50000` VALUES ('8459', 'like', '83811843');
INSERT INTO `grid50000` VALUES ('8460', 'build', '83811843');
INSERT INTO `grid50000` VALUES ('8461', 'fake', '83811843');
INSERT INTO `grid50000` VALUES ('8462', 'ancient', '83811843');
INSERT INTO `grid50000` VALUES ('8463', 'ruins', '83811843');
INSERT INTO `grid50000` VALUES ('8464', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('8465', 'Prague', '83811843');
INSERT INTO `grid50000` VALUES ('8466', 'parks', '83811843');
INSERT INTO `grid50000` VALUES ('8467', 'perhaps', '83811843');
INSERT INTO `grid50000` VALUES ('8468', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('8469', 'go', '83811843');
INSERT INTO `grid50000` VALUES ('8470', 'along', '83811843');
INSERT INTO `grid50000` VALUES ('8471', 'with', '83811843');
INSERT INTO `grid50000` VALUES ('8472', 'their', '83811843');
INSERT INTO `grid50000` VALUES ('8473', 'ancient', '83811843');
INSERT INTO `grid50000` VALUES ('8474', 'legend', '83811843');
INSERT INTO `grid50000` VALUES ('8475', 'texts', '83811843');
INSERT INTO `grid50000` VALUES ('8476', 'The', '83811843');
INSERT INTO `grid50000` VALUES ('8477', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('8478', 'writers', '83811843');
INSERT INTO `grid50000` VALUES ('8479', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('8480', 'artists', '83811843');
INSERT INTO `grid50000` VALUES ('8481', 'Jan', '83811843');
INSERT INTO `grid50000` VALUES ('8482', 'Neruda', '83811843');
INSERT INTO `grid50000` VALUES ('8483', 'Alois', '83811843');
INSERT INTO `grid50000` VALUES ('8484', 'Jirasek', '83811843');
INSERT INTO `grid50000` VALUES ('8485', 'Mikulas', '83811843');
INSERT INTO `grid50000` VALUES ('8486', 'Ales', '83811843');
INSERT INTO `grid50000` VALUES ('8487', 'Bedrich', '83811843');
INSERT INTO `grid50000` VALUES ('8488', 'Smetana', '83811843');
INSERT INTO `grid50000` VALUES ('8489', 'Antonin', '83811843');
INSERT INTO `grid50000` VALUES ('8490', 'Dvorak', '83811843');
INSERT INTO `grid50000` VALUES ('8491', '', '83811843');
INSERT INTO `grid50000` VALUES ('8492', 'Alfons', '83811843');
INSERT INTO `grid50000` VALUES ('8493', 'Mucha', '83811843');
INSERT INTO `grid50000` VALUES ('8494', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('8495', 'Frantisek', '83811843');
INSERT INTO `grid50000` VALUES ('8496', 'Bilek', '83811843');
INSERT INTO `grid50000` VALUES ('8497', 'all', '83811843');
INSERT INTO `grid50000` VALUES ('8498', 'lived', '83811843');
INSERT INTO `grid50000` VALUES ('8499', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('8500', 'worked', '83811843');
INSERT INTO `grid50000` VALUES ('8501', 'at', '83811843');
INSERT INTO `grid50000` VALUES ('8502', 'this', '83811843');
INSERT INTO `grid50000` VALUES ('8503', 'time', '83811843');
INSERT INTO `grid50000` VALUES ('8504', 'The', '83811843');
INSERT INTO `grid50000` VALUES ('8505', 'National', '83811843');
INSERT INTO `grid50000` VALUES ('8506', 'Theater', '83811843');
INSERT INTO `grid50000` VALUES ('8507', 'National', '83811843');
INSERT INTO `grid50000` VALUES ('8508', 'Museum', '83811843');
INSERT INTO `grid50000` VALUES ('8509', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('8510', 'Rudolfinum', '83811843');
INSERT INTO `grid50000` VALUES ('8511', 'were', '83811843');
INSERT INTO `grid50000` VALUES ('8512', 'built', '83811843');
INSERT INTO `grid50000` VALUES ('8513', 'at', '83811843');
INSERT INTO `grid50000` VALUES ('8514', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8515', 'turn', '83811843');
INSERT INTO `grid50000` VALUES ('8516', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('8517', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8518', 'century', '83811843');
INSERT INTO `grid50000` VALUES ('8519', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('8520', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8521', 'first', '83811843');
INSERT INTO `grid50000` VALUES ('8522', 'films', '83811843');
INSERT INTO `grid50000` VALUES ('8523', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('8524', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8525', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('8526', 'Republic', '83811843');
INSERT INTO `grid50000` VALUES ('8527', 'were', '83811843');
INSERT INTO `grid50000` VALUES ('8528', 'made', '83811843');
INSERT INTO `grid50000` VALUES ('8529', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('8530', '1898', '83811843');
INSERT INTO `grid50000` VALUES ('8531', '\r\n\r\nThe', '83811843');
INSERT INTO `grid50000` VALUES ('8532', 'battle', '83811843');
INSERT INTO `grid50000` VALUES ('8533', 'for', '83811843');
INSERT INTO `grid50000` VALUES ('8534', 'universal', '83811843');
INSERT INTO `grid50000` VALUES ('8535', 'suffrage', '83811843');
INSERT INTO `grid50000` VALUES ('8536', 'within', '83811843');
INSERT INTO `grid50000` VALUES ('8537', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8538', 'AustroHungarian', '83811843');
INSERT INTO `grid50000` VALUES ('8539', 'state', '83811843');
INSERT INTO `grid50000` VALUES ('8540', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('8541', 'won', '83811843');
INSERT INTO `grid50000` VALUES ('8542', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('8543', '1907', '83811843');
INSERT INTO `grid50000` VALUES ('8544', 'All', '83811843');
INSERT INTO `grid50000` VALUES ('8545', 'men', '83811843');
INSERT INTO `grid50000` VALUES ('8546', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('8547', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8548', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('8549', 'lands', '83811843');
INSERT INTO `grid50000` VALUES ('8550', 'regardless', '83811843');
INSERT INTO `grid50000` VALUES ('8551', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('8552', 'economic', '83811843');
INSERT INTO `grid50000` VALUES ('8553', 'status', '83811843');
INSERT INTO `grid50000` VALUES ('8554', 'could', '83811843');
INSERT INTO `grid50000` VALUES ('8555', 'vote', '83811843');
INSERT INTO `grid50000` VALUES ('8556', '', '83811843');
INSERT INTO `grid50000` VALUES ('8557', 'women', '83811843');
INSERT INTO `grid50000` VALUES ('8558', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('8559', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8560', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('8561', 'lands', '83811843');
INSERT INTO `grid50000` VALUES ('8562', 'did', '83811843');
INSERT INTO `grid50000` VALUES ('8563', 'not', '83811843');
INSERT INTO `grid50000` VALUES ('8564', 'get', '83811843');
INSERT INTO `grid50000` VALUES ('8565', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8566', 'vote', '83811843');
INSERT INTO `grid50000` VALUES ('8567', 'until', '83811843');
INSERT INTO `grid50000` VALUES ('8568', '1919', '83811843');
INSERT INTO `grid50000` VALUES ('8569', 'But', '83811843');
INSERT INTO `grid50000` VALUES ('8570', 'most', '83811843');
INSERT INTO `grid50000` VALUES ('8571', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('8572', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8573', 'rest', '83811843');
INSERT INTO `grid50000` VALUES ('8574', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('8575', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8576', 'political', '83811843');
INSERT INTO `grid50000` VALUES ('8577', 'advances', '83811843');
INSERT INTO `grid50000` VALUES ('8578', 'made', '83811843');
INSERT INTO `grid50000` VALUES ('8579', 'by', '83811843');
INSERT INTO `grid50000` VALUES ('8580', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8581', 'Czechs', '83811843');
INSERT INTO `grid50000` VALUES ('8582', 'came', '83811843');
INSERT INTO `grid50000` VALUES ('8583', 'into', '83811843');
INSERT INTO `grid50000` VALUES ('8584', 'being', '83811843');
INSERT INTO `grid50000` VALUES ('8585', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('8586', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('8587', 'sort', '83811843');
INSERT INTO `grid50000` VALUES ('8588', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('8589', 'fuzzy', '83811843');
INSERT INTO `grid50000` VALUES ('8590', 'grey', '83811843');
INSERT INTO `grid50000` VALUES ('8591', 'area', '83811843');
INSERT INTO `grid50000` VALUES ('8592', 'The', '83811843');
INSERT INTO `grid50000` VALUES ('8593', 'constitutional', '83811843');
INSERT INTO `grid50000` VALUES ('8594', 'status', '83811843');
INSERT INTO `grid50000` VALUES ('8595', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('8596', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8597', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('8598', 'lands', '83811843');
INSERT INTO `grid50000` VALUES ('8599', 'within', '83811843');
INSERT INTO `grid50000` VALUES ('8600', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8601', 'framework', '83811843');
INSERT INTO `grid50000` VALUES ('8602', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('8603', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8604', 'Monarchy', '83811843');
INSERT INTO `grid50000` VALUES ('8605', 'remained', '83811843');
INSERT INTO `grid50000` VALUES ('8606', 'an', '83811843');
INSERT INTO `grid50000` VALUES ('8607', 'open', '83811843');
INSERT INTO `grid50000` VALUES ('8608', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('8609', '', '83811843');
INSERT INTO `grid50000` VALUES ('8610', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('8611', 'Prague', '83811843');
INSERT INTO `grid50000` VALUES ('8612', 'at', '83811843');
INSERT INTO `grid50000` VALUES ('8613', 'least', '83811843');
INSERT INTO `grid50000` VALUES ('8614', '', '83811843');
INSERT INTO `grid50000` VALUES ('8615', 'a', '83811843');
INSERT INTO `grid50000` VALUES ('8616', 'muchdebated', '83811843');
INSERT INTO `grid50000` VALUES ('8617', 'question', '83811843');
INSERT INTO `grid50000` VALUES ('8618', '\r\n\r\nWell', '83811843');
INSERT INTO `grid50000` VALUES ('8619', 'while', '83811843');
INSERT INTO `grid50000` VALUES ('8620', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('8621', 'nationalists', '83811843');
INSERT INTO `grid50000` VALUES ('8622', 'were', '83811843');
INSERT INTO `grid50000` VALUES ('8623', 'busy', '83811843');
INSERT INTO `grid50000` VALUES ('8624', 'sitting', '83811843');
INSERT INTO `grid50000` VALUES ('8625', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('8626', 'pubs', '83811843');
INSERT INTO `grid50000` VALUES ('8627', 'drinking', '83811843');
INSERT INTO `grid50000` VALUES ('8628', 'beer', '83811843');
INSERT INTO `grid50000` VALUES ('8629', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('8630', 'debating', '83811843');
INSERT INTO `grid50000` VALUES ('8631', 'how', '83811843');
INSERT INTO `grid50000` VALUES ('8632', 'best', '83811843');
INSERT INTO `grid50000` VALUES ('8633', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('8634', 'effect', '83811843');
INSERT INTO `grid50000` VALUES ('8635', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8636', 'changes', '83811843');
INSERT INTO `grid50000` VALUES ('8637', 'they', '83811843');
INSERT INTO `grid50000` VALUES ('8638', 'wanted', '83811843');
INSERT INTO `grid50000` VALUES ('8639', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('8640', 'see', '83811843');
INSERT INTO `grid50000` VALUES ('8641', 'implemented', '83811843');
INSERT INTO `grid50000` VALUES ('8642', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('8643', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8644', 'AustroHungarian', '83811843');
INSERT INTO `grid50000` VALUES ('8645', 'government', '83811843');
INSERT INTO `grid50000` VALUES ('8646', 'members', '83811843');
INSERT INTO `grid50000` VALUES ('8647', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('8648', 'other', '83811843');
INSERT INTO `grid50000` VALUES ('8649', 'nations', '83811843');
INSERT INTO `grid50000` VALUES ('8650', 'within', '83811843');
INSERT INTO `grid50000` VALUES ('8651', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8652', 'Empire', '83811843');
INSERT INTO `grid50000` VALUES ('8653', 'were', '83811843');
INSERT INTO `grid50000` VALUES ('8654', 'also', '83811843');
INSERT INTO `grid50000` VALUES ('8655', 'pressing', '83811843');
INSERT INTO `grid50000` VALUES ('8656', 'for', '83811843');
INSERT INTO `grid50000` VALUES ('8657', 'reforms', '83811843');
INSERT INTO `grid50000` VALUES ('8658', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('8659', 'for', '83811843');
INSERT INTO `grid50000` VALUES ('8660', 'independence', '83811843');
INSERT INTO `grid50000` VALUES ('8661', 'It', '83811843');
INSERT INTO `grid50000` VALUES ('8662', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('8663', 'these', '83811843');
INSERT INTO `grid50000` VALUES ('8664', 'pressures', '83811843');
INSERT INTO `grid50000` VALUES ('8665', 'that', '83811843');
INSERT INTO `grid50000` VALUES ('8666', 'led', '83811843');
INSERT INTO `grid50000` VALUES ('8667', 'Serbian', '83811843');
INSERT INTO `grid50000` VALUES ('8668', 'nationalist', '83811843');
INSERT INTO `grid50000` VALUES ('8669', 'Gavrillo', '83811843');
INSERT INTO `grid50000` VALUES ('8670', 'Princip', '83811843');
INSERT INTO `grid50000` VALUES ('8671', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('8672', 'assassinate', '83811843');
INSERT INTO `grid50000` VALUES ('8673', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8674', 'Archduke', '83811843');
INSERT INTO `grid50000` VALUES ('8675', 'Francis', '83811843');
INSERT INTO `grid50000` VALUES ('8676', 'Ferdinand', '83811843');
INSERT INTO `grid50000` VALUES ('8677', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8678', 'heir', '83811843');
INSERT INTO `grid50000` VALUES ('8679', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('8680', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8681', 'Austrian', '83811843');
INSERT INTO `grid50000` VALUES ('8682', 'throne', '83811843');
INSERT INTO `grid50000` VALUES ('8683', 'on', '83811843');
INSERT INTO `grid50000` VALUES ('8684', 'June', '83811843');
INSERT INTO `grid50000` VALUES ('8685', '28', '83811843');
INSERT INTO `grid50000` VALUES ('8686', '1914', '83811843');
INSERT INTO `grid50000` VALUES ('8687', 'precipitating', '83811843');
INSERT INTO `grid50000` VALUES ('8688', 'World', '83811843');
INSERT INTO `grid50000` VALUES ('8689', 'War', '83811843');
INSERT INTO `grid50000` VALUES ('8690', 'I', '83811843');
INSERT INTO `grid50000` VALUES ('8691', 'Princip', '83811843');
INSERT INTO `grid50000` VALUES ('8692', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('8693', 'locked', '83811843');
INSERT INTO `grid50000` VALUES ('8694', 'up', '83811843');
INSERT INTO `grid50000` VALUES ('8695', 'for', '83811843');
INSERT INTO `grid50000` VALUES ('8696', 'this', '83811843');
INSERT INTO `grid50000` VALUES ('8697', 'deed', '83811843');
INSERT INTO `grid50000` VALUES ('8698', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('8699', 'spent', '83811843');
INSERT INTO `grid50000` VALUES ('8700', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8701', 'rest', '83811843');
INSERT INTO `grid50000` VALUES ('8702', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('8703', 'his', '83811843');
INSERT INTO `grid50000` VALUES ('8704', 'days', '83811843');
INSERT INTO `grid50000` VALUES ('8705', 'at', '83811843');
INSERT INTO `grid50000` VALUES ('8706', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8707', 'prison', '83811843');
INSERT INTO `grid50000` VALUES ('8708', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('8709', 'Terezin', '83811843');
INSERT INTO `grid50000` VALUES ('8710', 'Fortress', '83811843');
INSERT INTO `grid50000` VALUES ('8711', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('8712', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8713', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('8714', 'lands', '83811843');
INSERT INTO `grid50000` VALUES ('8715', '\r\n\r\nDuring', '83811843');
INSERT INTO `grid50000` VALUES ('8716', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8717', 'course', '83811843');
INSERT INTO `grid50000` VALUES ('8718', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('8719', 'World', '83811843');
INSERT INTO `grid50000` VALUES ('8720', 'War', '83811843');
INSERT INTO `grid50000` VALUES ('8721', 'I', '83811843');
INSERT INTO `grid50000` VALUES ('8722', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8723', 'Czechs', '83811843');
INSERT INTO `grid50000` VALUES ('8724', 'became', '83811843');
INSERT INTO `grid50000` VALUES ('8725', 'unified', '83811843');
INSERT INTO `grid50000` VALUES ('8726', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('8727', 'their', '83811843');
INSERT INTO `grid50000` VALUES ('8728', 'opposition', '83811843');
INSERT INTO `grid50000` VALUES ('8729', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('8730', 'Austrian', '83811843');
INSERT INTO `grid50000` VALUES ('8731', 'rule', '83811843');
INSERT INTO `grid50000` VALUES ('8732', '\r\n\r\nMost', '83811843');
INSERT INTO `grid50000` VALUES ('8733', 'especially', '83811843');
INSERT INTO `grid50000` VALUES ('8734', 'AustriaHungarys', '83811843');
INSERT INTO `grid50000` VALUES ('8735', 'alignment', '83811843');
INSERT INTO `grid50000` VALUES ('8736', 'with', '83811843');
INSERT INTO `grid50000` VALUES ('8737', 'Germany', '83811843');
INSERT INTO `grid50000` VALUES ('8738', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('8739', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8740', 'restriction', '83811843');
INSERT INTO `grid50000` VALUES ('8741', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('8742', 'democratic', '83811843');
INSERT INTO `grid50000` VALUES ('8743', 'rights', '83811843');
INSERT INTO `grid50000` VALUES ('8744', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('8745', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8746', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('8747', 'lands', '83811843');
INSERT INTO `grid50000` VALUES ('8748', 'led', '83811843');
INSERT INTO `grid50000` VALUES ('8749', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('8750', 'growing', '83811843');
INSERT INTO `grid50000` VALUES ('8751', 'opposition', '83811843');
INSERT INTO `grid50000` VALUES ('8752', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('8753', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8754', 'monarchy', '83811843');
INSERT INTO `grid50000` VALUES ('8755', 'here', '83811843');
INSERT INTO `grid50000` VALUES ('8756', 'An', '83811843');
INSERT INTO `grid50000` VALUES ('8757', 'organized', '83811843');
INSERT INTO `grid50000` VALUES ('8758', 'resistance', '83811843');
INSERT INTO `grid50000` VALUES ('8759', 'began', '83811843');
INSERT INTO `grid50000` VALUES ('8760', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('8761', 'develop', '83811843');
INSERT INTO `grid50000` VALUES ('8762', 'both', '83811843');
INSERT INTO `grid50000` VALUES ('8763', 'at', '83811843');
INSERT INTO `grid50000` VALUES ('8764', 'home', '83811843');
INSERT INTO `grid50000` VALUES ('8765', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('8766', 'abroad', '83811843');
INSERT INTO `grid50000` VALUES ('8767', '\r\n\r\n', '83811843');
INSERT INTO `grid50000` VALUES ('8768', 'The', '83811843');
INSERT INTO `grid50000` VALUES ('8769', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('8770', 'university', '83811843');
INSERT INTO `grid50000` VALUES ('8771', 'professor', '83811843');
INSERT INTO `grid50000` VALUES ('8772', 'philosopher', '83811843');
INSERT INTO `grid50000` VALUES ('8773', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('8774', 'politician', '83811843');
INSERT INTO `grid50000` VALUES ('8775', 'Tomas', '83811843');
INSERT INTO `grid50000` VALUES ('8776', 'Garrigue', '83811843');
INSERT INTO `grid50000` VALUES ('8777', 'Masaryk', '83811843');
INSERT INTO `grid50000` VALUES ('8778', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8779', 'same', '83811843');
INSERT INTO `grid50000` VALUES ('8780', 'one', '83811843');
INSERT INTO `grid50000` VALUES ('8781', 'who', '83811843');
INSERT INTO `grid50000` VALUES ('8782', 'doubted', '83811843');
INSERT INTO `grid50000` VALUES ('8783', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8784', 'authenticity', '83811843');
INSERT INTO `grid50000` VALUES ('8785', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('8786', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8787', 'faked', '83811843');
INSERT INTO `grid50000` VALUES ('8788', 'manuscripts', '83811843');
INSERT INTO `grid50000` VALUES ('8789', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('8790', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8791', 'one', '83811843');
INSERT INTO `grid50000` VALUES ('8792', 'who', '83811843');
INSERT INTO `grid50000` VALUES ('8793', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('8794', 'later', '83811843');
INSERT INTO `grid50000` VALUES ('8795', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('8796', 'become', '83811843');
INSERT INTO `grid50000` VALUES ('8797', 'Czechoslovakias', '83811843');
INSERT INTO `grid50000` VALUES ('8798', 'first', '83811843');
INSERT INTO `grid50000` VALUES ('8799', 'president', '83811843');
INSERT INTO `grid50000` VALUES ('8800', 'had', '83811843');
INSERT INTO `grid50000` VALUES ('8801', 'been', '83811843');
INSERT INTO `grid50000` VALUES ('8802', 'an', '83811843');
INSERT INTO `grid50000` VALUES ('8803', 'advocate', '83811843');
INSERT INTO `grid50000` VALUES ('8804', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('8805', 'more', '83811843');
INSERT INTO `grid50000` VALUES ('8806', 'independence', '83811843');
INSERT INTO `grid50000` VALUES ('8807', 'for', '83811843');
INSERT INTO `grid50000` VALUES ('8808', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8809', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('8810', 'lands', '83811843');
INSERT INTO `grid50000` VALUES ('8811', 'long', '83811843');
INSERT INTO `grid50000` VALUES ('8812', 'before', '83811843');
INSERT INTO `grid50000` VALUES ('8813', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8814', 'war', '83811843');
INSERT INTO `grid50000` VALUES ('8815', 'had', '83811843');
INSERT INTO `grid50000` VALUES ('8816', 'even', '83811843');
INSERT INTO `grid50000` VALUES ('8817', 'started', '83811843');
INSERT INTO `grid50000` VALUES ('8818', 'In', '83811843');
INSERT INTO `grid50000` VALUES ('8819', 'December', '83811843');
INSERT INTO `grid50000` VALUES ('8820', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('8821', '1914', '83811843');
INSERT INTO `grid50000` VALUES ('8822', 'he', '83811843');
INSERT INTO `grid50000` VALUES ('8823', 'went', '83811843');
INSERT INTO `grid50000` VALUES ('8824', 'abroad', '83811843');
INSERT INTO `grid50000` VALUES ('8825', 'where', '83811843');
INSERT INTO `grid50000` VALUES ('8826', 'he', '83811843');
INSERT INTO `grid50000` VALUES ('8827', 'continued', '83811843');
INSERT INTO `grid50000` VALUES ('8828', 'to', '83811843');
INSERT INTO `grid50000` VALUES ('8829', 'fight', '83811843');
INSERT INTO `grid50000` VALUES ('8830', 'for', '83811843');
INSERT INTO `grid50000` VALUES ('8831', 'Czechoslovak', '83811843');
INSERT INTO `grid50000` VALUES ('8832', 'independence', '83811843');
INSERT INTO `grid50000` VALUES ('8833', 'throughout', '83811843');
INSERT INTO `grid50000` VALUES ('8834', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8835', 'war', '83811843');
INSERT INTO `grid50000` VALUES ('8836', 'He', '83811843');
INSERT INTO `grid50000` VALUES ('8837', 'worked', '83811843');
INSERT INTO `grid50000` VALUES ('8838', 'closely', '83811843');
INSERT INTO `grid50000` VALUES ('8839', 'with', '83811843');
INSERT INTO `grid50000` VALUES ('8840', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('8841', 'lawyer', '83811843');
INSERT INTO `grid50000` VALUES ('8842', 'Edvard', '83811843');
INSERT INTO `grid50000` VALUES ('8843', 'Benes', '83811843');
INSERT INTO `grid50000` VALUES ('8844', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('8845', 'Slovak', '83811843');
INSERT INTO `grid50000` VALUES ('8846', 'astronomer', '83811843');
INSERT INTO `grid50000` VALUES ('8847', 'Milan', '83811843');
INSERT INTO `grid50000` VALUES ('8848', 'Rastislav', '83811843');
INSERT INTO `grid50000` VALUES ('8849', 'Stefanik', '83811843');
INSERT INTO `grid50000` VALUES ('8850', 'who', '83811843');
INSERT INTO `grid50000` VALUES ('8851', 'were', '83811843');
INSERT INTO `grid50000` VALUES ('8852', 'also', '83811843');
INSERT INTO `grid50000` VALUES ('8853', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('8854', 'exile', '83811843');
INSERT INTO `grid50000` VALUES ('8855', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('8856', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8857', 'United', '83811843');
INSERT INTO `grid50000` VALUES ('8858', 'States', '83811843');
INSERT INTO `grid50000` VALUES ('8859', 'throughout', '83811843');
INSERT INTO `grid50000` VALUES ('8860', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8861', 'conflict', '83811843');
INSERT INTO `grid50000` VALUES ('8862', 'It', '83811843');
INSERT INTO `grid50000` VALUES ('8863', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('8864', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('8865', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8866', 'United', '83811843');
INSERT INTO `grid50000` VALUES ('8867', 'States', '83811843');
INSERT INTO `grid50000` VALUES ('8868', 'at', '83811843');
INSERT INTO `grid50000` VALUES ('8869', 'this', '83811843');
INSERT INTO `grid50000` VALUES ('8870', 'time', '83811843');
INSERT INTO `grid50000` VALUES ('8871', 'that', '83811843');
INSERT INTO `grid50000` VALUES ('8872', 'Masaryk', '83811843');
INSERT INTO `grid50000` VALUES ('8873', 'met', '83811843');
INSERT INTO `grid50000` VALUES ('8874', 'his', '83811843');
INSERT INTO `grid50000` VALUES ('8875', 'wife', '83811843');
INSERT INTO `grid50000` VALUES ('8876', 'American', '83811843');
INSERT INTO `grid50000` VALUES ('8877', 'Charlotte', '83811843');
INSERT INTO `grid50000` VALUES ('8878', 'Garrigue', '83811843');
INSERT INTO `grid50000` VALUES ('8879', '\r\n\r\nIt', '83811843');
INSERT INTO `grid50000` VALUES ('8880', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('8881', 'there', '83811843');
INSERT INTO `grid50000` VALUES ('8882', 'too', '83811843');
INSERT INTO `grid50000` VALUES ('8883', 'that', '83811843');
INSERT INTO `grid50000` VALUES ('8884', 'Masaryk', '83811843');
INSERT INTO `grid50000` VALUES ('8885', 'Benes', '83811843');
INSERT INTO `grid50000` VALUES ('8886', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('8887', 'Stefanik', '83811843');
INSERT INTO `grid50000` VALUES ('8888', 'founded', '83811843');
INSERT INTO `grid50000` VALUES ('8889', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8890', 'Czech', '83811843');
INSERT INTO `grid50000` VALUES ('8891', 'National', '83811843');
INSERT INTO `grid50000` VALUES ('8892', 'Council', '83811843');
INSERT INTO `grid50000` VALUES ('8893', 'in', '83811843');
INSERT INTO `grid50000` VALUES ('8894', '1916', '83811843');
INSERT INTO `grid50000` VALUES ('8895', 'Over', '83811843');
INSERT INTO `grid50000` VALUES ('8896', 'time', '83811843');
INSERT INTO `grid50000` VALUES ('8897', 'this', '83811843');
INSERT INTO `grid50000` VALUES ('8898', 'organization', '83811843');
INSERT INTO `grid50000` VALUES ('8899', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('8900', 'renamed', '83811843');
INSERT INTO `grid50000` VALUES ('8901', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8902', 'Czechoslovak', '83811843');
INSERT INTO `grid50000` VALUES ('8903', 'National', '83811843');
INSERT INTO `grid50000` VALUES ('8904', 'Council', '83811843');
INSERT INTO `grid50000` VALUES ('8905', 'and', '83811843');
INSERT INTO `grid50000` VALUES ('8906', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('8907', 'recognized', '83811843');
INSERT INTO `grid50000` VALUES ('8908', 'as', '83811843');
INSERT INTO `grid50000` VALUES ('8909', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8910', 'valid', '83811843');
INSERT INTO `grid50000` VALUES ('8911', 'voice', '83811843');
INSERT INTO `grid50000` VALUES ('8912', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('8913', 'Czechoslovakia', '83811843');
INSERT INTO `grid50000` VALUES ('8914', 'by', '83811843');
INSERT INTO `grid50000` VALUES ('8915', 'Allied', '83811843');
INSERT INTO `grid50000` VALUES ('8916', 'leaders', '83811843adsd');
INSERT INTO `grid50000` VALUES ('8917', 'Their', '83811843');
INSERT INTO `grid50000` VALUES ('8918', 'position', '83811843');
INSERT INTO `grid50000` VALUES ('8919', 'as', '83811843');
INSERT INTO `grid50000` VALUES ('8920', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8921', 'leaders', '83811843');
INSERT INTO `grid50000` VALUES ('8922', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('8923', 'free', '83811843');
INSERT INTO `grid50000` VALUES ('8924', 'Czechoslovakia', '83811843');
INSERT INTO `grid50000` VALUES ('8925', 'was', '83811843');
INSERT INTO `grid50000` VALUES ('8926', 'further', '83811843');
INSERT INTO `grid50000` VALUES ('8927', 'strengthened', '83811843');
INSERT INTO `grid50000` VALUES ('8928', 'with', '83811843');
INSERT INTO `grid50000` VALUES ('8929', 'the', '83811843');
INSERT INTO `grid50000` VALUES ('8930', 'formation', '83811843');
INSERT INTO `grid50000` VALUES ('8931', 'of', '83811843');
INSERT INTO `grid50000` VALUES ('8932', 'Czechoslovak', '83811843');
INSERT INTO `grid50000` VALUES ('8933', 'military', '83811843');
INSERT INTO `grid50000` VALUES ('8934', 'units', '83811843');
INSERT INTO `grid50000` VALUES ('8935', 'known', 'known');
INSERT INTO `grid50000` VALUES ('8936', 'as', '83811843');
INSERT INTO `grid50000` VALUES ('8937', 'the', '83811843d');
INSERT INTO `grid50000` VALUES ('8938', 'Czechoslovak', '83811843');
INSERT INTO `grid50000` VALUES ('9319', 'Central', '83811843d');
INSERT INTO `grid50000` VALUES ('9320', 'Powers', '83811843dd');
INSERT INTO `grid50000` VALUES ('9321', 'were', '83811843dd');
INSERT INTO `grid50000` VALUES ('9322', 'defeated', '83811843dd');
INSERT INTO `grid50000` VALUES ('10063', '2', '23');
INSERT INTO `grid50000` VALUES ('10065', '', '4');
INSERT INTO `grid50000` VALUES ('10068', '', '');
INSERT INTO `grid50000` VALUES ('10066', '', '');
INSERT INTO `grid50000` VALUES ('10067', '', '');
INSERT INTO `grid50000` VALUES ('10069', '', '');
INSERT INTO `grid50000` VALUES ('10071', '', '');
INSERT INTO `grid50000` VALUES ('10072', '', 'asdf');
INSERT INTO `packages_plain` VALUES ('1', 'acx100-source', 'extra', 'contrib/kernel', '296', 'Stefano Canepa ', 'all', 'acx100', '20080210-1.1', 'pool/contrib/a/acx100/acx100-source_20080210-1.1_all.deb', '229468', 'ACX100/ACX111 wireless network drivers source', 'http://acx100.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('2', 'alien-arena-browser', 'extra', 'contrib/games', '160', 'Debian Games Team ', 'all', 'alien-arena', '7.0-1', 'pool/contrib/a/alien-arena/alien-arena-browser_7.0-1_all.deb', '37128', 'stand alone server browser for Alien Arena', 'http://red.planetarena.org');
INSERT INTO `packages_plain` VALUES ('3', 'alien-arena-server', 'extra', 'contrib/games', '260', 'Debian Games Team ', 'i386', 'alien-arena', '7.0-1', 'pool/contrib/a/alien-arena/alien-arena-server_7.0-1_i386.deb', '130272', 'Dedicated server for Alien Arena', 'http://red.planetarena.org');
INSERT INTO `packages_plain` VALUES ('4', 'alien-arena', 'extra', 'contrib/games', '1204', 'Debian Games Team ', 'i386', '', '7.0-1', 'pool/contrib/a/alien-arena/alien-arena_7.0-1_i386.deb', '579978', 'Standalone 3D first person online deathmatch shooter', 'http://red.planetarena.org');
INSERT INTO `packages_plain` VALUES ('5', 'alsa-firmware-loaders', 'extra', 'contrib/sound', '228', 'Debian ALSA Maintainers ', 'i386', 'alsa-tools', '1.0.21-1', 'pool/contrib/a/alsa-tools/alsa-firmware-loaders_1.0.21-1_i386.deb', '32758', 'ALSA software loaders for specific hardware', 'http://www.alsa-project.org/');
INSERT INTO `packages_plain` VALUES ('6', 'amoeba', 'optional', 'contrib/x11', '276', 'Steinar H. Gunderson ', 'i386', '', '1.1-20', 'pool/contrib/a/amoeba/amoeba_1.1-20_i386.deb', '94052', 'fast-paced, polished OpenGL demonstration by Excess', '');
INSERT INTO `packages_plain` VALUES ('7', 'atari800', 'optional', 'contrib/otherosfs', '1848', 'Antonin Kral ', 'i386', '', '2.1.0-1', 'pool/contrib/a/atari800/atari800_2.1.0-1_i386.deb', '763238', 'Atari emulator for X/curses/SDL', '');
INSERT INTO `packages_plain` VALUES ('8', 'avifile-divx-plugin', 'optional', 'contrib/video', '28', 'Debian QA Group ', 'i386', 'avifile', '1:0.7.48~20090503.ds-1', 'pool/contrib/a/avifile/avifile-divx-plugin_0.7.48~20090503.ds-1_i386.deb', '950', 'Divx4Linux video de/encoding plugin for libavifile', 'http://avifile.sf.net');
INSERT INTO `packages_plain` VALUES ('9', 'avifile-win32-plugin', 'optional', 'contrib/video', '268', 'Debian QA Group ', 'i386', 'avifile', '1:0.7.48~20090503.ds-1', 'pool/contrib/a/avifile/avifile-win32-plugin_0.7.48~20090503.ds-1_i386.deb', '97404', 'Win32 audio/video plugin for libavifile', 'http://avifile.sf.net');
INSERT INTO `packages_plain` VALUES ('10', 'avifile-xvid-plugin', 'optional', 'contrib/video', '28', 'Debian QA Group ', 'i386', 'avifile', '1:0.7.48~20090503.ds-1', 'pool/contrib/a/avifile/avifile-xvid-plugin_0.7.48~20090503.ds-1_i386.deb', '928', 'XviD video encoding plugin for libavifile', 'http://avifile.sf.net');
INSERT INTO `packages_plain` VALUES ('11', 'b43-fwcutter', 'optional', 'contrib/utils', '108', 'Rene Engelhard ', 'i386', '', '1:012-1', 'pool/contrib/b/b43-fwcutter/b43-fwcutter_012-1_i386.deb', '17094', 'Utility for extracting Broadcom 43xx firmware', 'http://wireless.kernel.org/en/users/Drivers/b43');
INSERT INTO `packages_plain` VALUES ('12', 'bgoffice-dict-downloader', 'extra', 'contrib/text', '68', 'Debian Add-ons Bulgaria Project ', 'all', '', '0.03', 'pool/contrib/b/bgoffice-dict-downloader/bgoffice-dict-downloader_0.03_all.deb', '6374', 'download dictionaries for gbgoffice', '');
INSERT INTO `packages_plain` VALUES ('13', 'cbedic', 'optional', 'contrib/text', '92', 'Anton Zinoviev ', 'i386', 'cbedic (4.0-2)', '4.0-2+b3', 'pool/contrib/c/cbedic/cbedic_4.0-2+b3_i386.deb', '24864', 'Text-mode Bulgarian/English Dictionary', '');
INSERT INTO `packages_plain` VALUES ('14', 'chocolate-doom', 'optional', 'contrib/games', '668', 'Debian Games Team ', 'i386', '', '1.2.1-1', 'pool/contrib/c/chocolate-doom/chocolate-doom_1.2.1-1_i386.deb', '304982', 'Doom engine closely-compatible with vanilla doom', 'http://chocolate-doom.org/');
INSERT INTO `packages_plain` VALUES ('15', 'cl-sql-oracle', 'extra', 'contrib/lisp', '140', 'Kevin M. Rosenberg ', 'all', 'cl-sql', '4.1.1-1', 'pool/contrib/c/cl-sql/cl-sql-oracle_4.1.1-1_all.deb', '34340', 'CLSQL database backend, Oracle', 'http://clsql.b9.com/');
INSERT INTO `packages_plain` VALUES ('16', 'cl-umlisp-orf', 'optional', 'contrib/lisp', '20', 'Kevin M. Rosenberg ', 'all', '', '3.3.2-2', 'pool/contrib/c/cl-umlisp-orf/cl-umlisp-orf_3.3.2-2_all.deb', '4024', 'Common Lisp Unified Medical Language System Interface, ORF', 'http://files.b9.com/umlisp-orf/');
INSERT INTO `packages_plain` VALUES ('17', 'cl-umlisp', 'optional', 'contrib/lisp', '220', 'Kevin M. Rosenberg ', 'all', '', '1:2007ac.2-5', 'pool/contrib/c/cl-umlisp/cl-umlisp_2007ac.2-5_all.deb', '37870', 'Common Lisp interface for the Unified Medical Language System', 'http://files.b9.com/umlisp/');
INSERT INTO `packages_plain` VALUES ('18', 'cltl', 'optional', 'contrib/doc', '92', 'Debian Common Lisp Team ', 'all', '', '1.0.26', 'pool/contrib/c/cltl/cltl_1.0.26_all.deb', '8874', 'Common Lisp the Language, second edition, book (Pre-ANSI)', '');
INSERT INTO `packages_plain` VALUES ('19', 'crafty-books-medium', 'optional', 'contrib/games', '25600', 'Oliver Korff ', 'all', '', '1.0.debian1-1', 'pool/contrib/c/crafty-books-medium/crafty-books-medium_1.0.debian1-1_all.deb', '12890724', 'Medium size opening books for the crafty chess engine', '');
INSERT INTO `packages_plain` VALUES ('20', 'crafty-books-medtosmall', 'optional', 'contrib/games', '3732', 'Oliver Korff ', 'all', '', '1.0.debian1-1', 'pool/contrib/c/crafty-books-medtosmall/crafty-books-medtosmall_1.0.debian1-1_all.deb', '1899430', 'Medium-to-small size opening books for crafty chess engine', '');
INSERT INTO `packages_plain` VALUES ('21', 'crafty-books-small', 'optional', 'contrib/games', '1232', 'Oliver Korff ', 'all', '', '1.0.debian1-1', 'pool/contrib/c/crafty-books-small/crafty-books-small_1.0.debian1-1_all.deb', '528438', 'Small-size opening books for crafty chess engine', '');
INSERT INTO `packages_plain` VALUES ('22', 'dosemu', 'optional', 'contrib/otherosfs', '5768', 'Bart Martens ', 'i386', '', '1.4.0+svn.1828-3', 'pool/contrib/d/dosemu/dosemu_1.4.0+svn.1828-3_i386.deb', '2422360', 'The Linux DOS Emulator', 'http://www.dosemu.org/');
INSERT INTO `packages_plain` VALUES ('23', 'dynagen', 'optional', 'contrib/net', '1688', 'Erik Wenzel ', 'all', '', '0.11.0-4', 'pool/contrib/d/dynagen/dynagen_0.11.0-4_all.deb', '821012', 'Cisco 7200 Router Emulator Command Line Interface', 'http://dynagen.org/');
INSERT INTO `packages_plain` VALUES ('24', 'dynare-matlab', 'optional', 'contrib/math', '588', 'Debian Octave Group ', 'all', 'dynare', '4.0.4-3', 'pool/contrib/d/dynare/dynare-matlab_4.0.4-3_all.deb', '78422', 'MEX files for MATLAB users of Dynare', 'http://www.dynare.org/');
INSERT INTO `packages_plain` VALUES ('25', 'e-uae-dbg', 'extra', 'contrib/debug', '8924', 'Stephan SГѓВјrken ', 'i386', 'e-uae', '0.8.29-WIP4-7', 'pool/contrib/e/e-uae/e-uae-dbg_0.8.29-WIP4-7_i386.deb', '3179146', 'The Egalitarian Ubiquitous Amiga Emulator (debugging)', 'http://www.rcdrummond.net/uae');
INSERT INTO `packages_plain` VALUES ('26', 'e-uae', 'extra', 'contrib/otherosfs', '3412', 'Stephan SГѓВјrken ', 'i386', '', '0.8.29-WIP4-7', 'pool/contrib/e/e-uae/e-uae_0.8.29-WIP4-7_i386.deb', '946138', 'The Egalitarian Ubiquitous Amiga Emulator', 'http://www.rcdrummond.net/uae');
INSERT INTO `packages_plain` VALUES ('27', 'easyspice', 'optional', 'contrib/electronics', '292', 'Gudjon I. Gudjonsson ', 'i386', '', '0.6.8-2', 'pool/contrib/e/easyspice/easyspice_0.6.8-2_i386.deb', '67692', 'A graphical frontend to the Spice simulator', 'http://easy-spice.sourceforge.net');
INSERT INTO `packages_plain` VALUES ('28', 'esix', 'optional', 'contrib/otherosfs', '137', 'Vince Mulhollon ', 'all', '', '1-2', 'pool/contrib/e/esix/esix_1-2_all.deb', '47044', 'PDP-8 Engineering and Scientific Interpreter eXtended', '');
INSERT INTO `packages_plain` VALUES ('29', 'exult-studio', 'extra', 'contrib/games', '1868', 'JordГѓВ  Polo ', 'i386', 'exult', '1.2-13', 'pool/contrib/e/exult/exult-studio_1.2-13_i386.deb', '577280', 'tools for editing and viewing exult games', 'http://exult.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('30', 'exult', 'extra', 'contrib/games', '2180', 'JordГѓВ  Polo ', 'i386', '', '1.2-13', 'pool/contrib/e/exult/exult_1.2-13_i386.deb', '978562', 'engine for Ultima VII (BG, FOV, SI, SS)', 'http://exult.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('31', 'festvox-don', 'extra', 'contrib/sound', '836', 'Matthias Urlichs ', 'all', '', '1.4.0-4', 'pool/contrib/f/festvox-don/festvox-don_1.4.0-4_all.deb', '646986', 'minimal British English male speaker for festival', '');
INSERT INTO `packages_plain` VALUES ('32', 'festvox-rablpc16k', 'extra', 'contrib/sound', '7488', 'Matthias Urlichs ', 'all', '', '1.4.0-2', 'pool/contrib/f/festvox-rablpc16k/festvox-rablpc16k_1.4.0-2_all.deb', '5359618', 'British English male speaker for festival, 16khz sample rate', '');
INSERT INTO `packages_plain` VALUES ('33', 'festvox-rablpc8k', 'extra', 'contrib/sound', '4380', 'Matthias Urlichs ', 'all', '', '1.4.0-2', 'pool/contrib/f/festvox-rablpc8k/festvox-rablpc8k_1.4.0-2_all.deb', '3115688', 'British English male speaker for festival, 8khz sample rate', '');
INSERT INTO `packages_plain` VALUES ('34', 'flashplugin-nonfree-extrasound', 'optional', 'contrib/sound', '60', 'Petter Reinholdtsen ', 'i386', '', '0.0.svn2431-3', 'pool/contrib/f/flashplugin-nonfree-extrasound/flashplugin-nonfree-extrasound_0.0.svn2431-3_i386.deb', '7952', 'Adobe Flash Player platform support library for Esound and OSS', '');
INSERT INTO `packages_plain` VALUES ('35', 'flashplugin-nonfree', 'optional', 'contrib/web', '132', 'Bart Martens ', 'i386', '', '1:2.8', 'pool/contrib/f/flashplugin-nonfree/flashplugin-nonfree_2.8_i386.deb', '17848', 'Adobe Flash Player - browser plugin', 'http://wiki.debian.org/FlashPlayer');
INSERT INTO `packages_plain` VALUES ('36', 'freemind', 'optional', 'contrib/text', '604', 'Eric Lavarde ', 'all', '', '0.7.1-6', 'pool/contrib/f/freemind/freemind_0.7.1-6_all.deb', '402962', 'A Java Program for creating and viewing Mindmaps', '');
INSERT INTO `packages_plain` VALUES ('37', 'funguloids', 'extra', 'contrib/games', '20544', 'Debian Games Team ', 'i386', 'funguloids (1.06-8)', '1.06-8+b1', 'pool/contrib/f/funguloids/funguloids_1.06-8+b1_i386.deb', '14779856', 'space-flying-mushroom-picking-simulator game', 'http://funguloids.sourceforge.net');
INSERT INTO `packages_plain` VALUES ('38', 'game-data-packager', 'optional', 'contrib/games', '168', 'Debian Games Team ', 'all', '', '22', 'pool/contrib/g/game-data-packager/game-data-packager_22_all.deb', '48516', 'Installer for game data files', '');
INSERT INTO `packages_plain` VALUES ('39', 'cpp-doc', 'optional', 'contrib/doc', '16', 'Debian GCC Maintainers ', 'i386', 'gcc-doc-defaults', '5:2', 'pool/contrib/g/gcc-doc-defaults/cpp-doc_2_i386.deb', '2740', 'documentation for the GNU C preprocessor (cpp)', '');
INSERT INTO `packages_plain` VALUES ('40', 'gcc-doc', 'optional', 'contrib/doc', '16', 'Debian GCC Maintainers ', 'i386', 'gcc-doc-defaults', '5:2', 'pool/contrib/g/gcc-doc-defaults/gcc-doc_2_i386.deb', '2840', 'documentation for the GNU compilers (gcc, gobjc, g++)', '');
INSERT INTO `packages_plain` VALUES ('41', 'gcj-doc', 'optional', 'contrib/doc', '16', 'Debian GCC Maintainers ', 'i386', 'gcc-doc-defaults', '5:2', 'pool/contrib/g/gcc-doc-defaults/gcj-doc_2_i386.deb', '2862', 'documentation for the GNU Java tools (gcj, gij)', '');
INSERT INTO `packages_plain` VALUES ('42', 'gfortran-doc', 'optional', 'contrib/doc', '16', 'Debian GCC Maintainers ', 'i386', 'gcc-doc-defaults', '5:2', 'pool/contrib/g/gcc-doc-defaults/gfortran-doc_2_i386.deb', '2724', 'documentation for the GNU Fortran Compiler (gfortran)', '');
INSERT INTO `packages_plain` VALUES ('43', 'gnat-doc', 'optional', 'contrib/doc', '16', 'Debian GCC Maintainers ', 'i386', 'gcc-doc-defaults', '5:2', 'pool/contrib/g/gcc-doc-defaults/gnat-doc_2_i386.deb', '2686', 'documentation for the GNU Ada Compiler (gnat)', '');
INSERT INTO `packages_plain` VALUES ('44', 'glest', 'optional', 'contrib/games', '1156', 'Debian Games Team ', 'i386', '', '3.2.2-1', 'pool/contrib/g/glest/glest_3.2.2-1_i386.deb', '439766', 'a free 3D real-time customizable strategy game', 'http://www.glest.org/');
INSERT INTO `packages_plain` VALUES ('45', 'gnome-speech-dectalk', 'optional', 'contrib/libs', '136', 'Mario Lang ', 'i386', 'gnome-speech', '1:0.4.25-1', 'pool/contrib/g/gnome-speech/gnome-speech-dectalk_0.4.25-1_i386.deb', '39810', 'GNOME text-to-speech library (Fonix DECtalk engine support)', '');
INSERT INTO `packages_plain` VALUES ('46', 'gnome-speech-ibmtts', 'optional', 'contrib/libs', '144', 'Mario Lang ', 'i386', 'gnome-speech', '1:0.4.25-1', 'pool/contrib/g/gnome-speech/gnome-speech-ibmtts_0.4.25-1_i386.deb', '39588', 'GNOME text-to-speech library (IBMTTS engine support)', '');
INSERT INTO `packages_plain` VALUES ('47', 'gnome-speech-swift', 'optional', 'contrib/libs', '136', 'Mario Lang ', 'i386', 'gnome-speech', '1:0.4.25-1', 'pool/contrib/g/gnome-speech/gnome-speech-swift_0.4.25-1_i386.deb', '38410', 'GNOME text-to-speech library (Cepstral swift engine support)', '');
INSERT INTO `packages_plain` VALUES ('48', 'gnuboy-sdl', 'optional', 'contrib/games', '216', 'Davide Puricelli (evo) ', 'i386', 'gnuboy', '1.0.3-5', 'pool/contrib/g/gnuboy/gnuboy-sdl_1.0.3-5_i386.deb', '77692', 'SDL binaries for gnuboy - Game Boy Emulator', '');
INSERT INTO `packages_plain` VALUES ('49', 'gnuboy-svga', 'optional', 'contrib/games', '212', 'Davide Puricelli (evo) ', 'i386', 'gnuboy', '1.0.3-5', 'pool/contrib/g/gnuboy/gnuboy-svga_1.0.3-5_i386.deb', '77268', 'SVGALIB binaries for gnuboy - Game Boy Emulator', '');
INSERT INTO `packages_plain` VALUES ('50', 'gnuboy-x', 'optional', 'contrib/games', '216', 'Davide Puricelli (evo) ', 'i386', 'gnuboy', '1.0.3-5', 'pool/contrib/g/gnuboy/gnuboy-x_1.0.3-5_i386.deb', '79218', 'X binaries for gnuboy - Game Boy Emulator', '');
INSERT INTO `packages_plain` VALUES ('51', 'gnuvd-gnome', 'optional', 'contrib/text', '36', 'Guus Sliepen ', 'all', 'gnuvd', '1.0.10-1', 'pool/contrib/g/gnuvd/gnuvd-gnome_1.0.10-1_all.deb', '5678', 'Query the online Dutch Van Dale dictionary - GNOME frontend', 'http://www.djcbsoftware.nl/code/gnuvd/');
INSERT INTO `packages_plain` VALUES ('52', 'gnuvd', 'optional', 'contrib/text', '32', 'Guus Sliepen ', 'i386', '', '1.0.10-1', 'pool/contrib/g/gnuvd/gnuvd_1.0.10-1_i386.deb', '10926', 'Query the online Dutch Van Dale dictionary', 'http://www.djcbsoftware.nl/code/gnuvd/');
INSERT INTO `packages_plain` VALUES ('53', 'googleearth-package', 'optional', 'contrib/misc', '68', 'Wesley J. Landaker ', 'all', '', '0.5.6', 'pool/contrib/g/googleearth-package/googleearth-package_0.5.6_all.deb', '10346', 'utility to automatically build a Debian package of Google Earth', '');
INSERT INTO `packages_plain` VALUES ('54', 'grinvin', 'optional', 'contrib/math', '152', 'Debian Java Maintainers ', 'i386', '', '1.2-1', 'pool/contrib/g/grinvin/grinvin_1.2-1_i386.deb', '28944', 'interactive software for studying graphs and their invariants', 'http://www.grinvin.org/');
INSERT INTO `packages_plain` VALUES ('55', 'gstreamer0.10-pitfdll', 'optional', 'contrib/libs', '256', 'Sebastian DrГѓВ¶ge ', 'i386', '', '0.9.1.1+cvs20080215-1', 'pool/contrib/g/gstreamer0.10-pitfdll/gstreamer0.10-pitfdll_0.9.1.1+cvs20080215-1_i386.deb', '80416', 'GStreamer plugin for using MS Windows binary codecs', 'http://sourceforge.net/projects/pitfdll/');
INSERT INTO `packages_plain` VALUES ('56', 'gtktrain', 'optional', 'contrib/x11', '156', 'Masayuki Hatta (mhatta) ', 'i386', '', '0.9b-13', 'pool/contrib/g/gtktrain/gtktrain_0.9b-13_i386.deb', '38922', 'The train-routing calculator with GTK+ interface', '');
INSERT INTO `packages_plain` VALUES ('57', 'gwp', 'optional', 'contrib/games', '4572', 'Lucas Di Pentima ', 'i386', '', '0.4.0-1.2', 'pool/contrib/g/gwp/gwp_0.4.0-1.2_i386.deb', '1855978', 'a VGA Planets strategy game client for GNOME', '');
INSERT INTO `packages_plain` VALUES ('58', 'hannah-foo2zjs', 'optional', 'contrib/text', '100', 'Michael Koch ', 'i386', '', '1:1', 'pool/contrib/h/hannah-foo2zjs/hannah-foo2zjs_1_i386.deb', '17768', 'Graphical firmware downloader for the foo2zjs package', '');
INSERT INTO `packages_plain` VALUES ('59', 'horae', 'optional', 'contrib/science', '8748', 'Carlo Segre ', 'all', '', '070-1', 'pool/contrib/h/horae/horae_070-1_all.deb', '5179726', 'interactive graphical processing and analysis of EXAFS data', 'http://cars9.uchicago.edu/~ravel/software/Welcome.html');
INSERT INTO `packages_plain` VALUES ('60', 'hyperspec', 'optional', 'contrib/doc', '100', 'Debian Common Lisp Team ', 'all', '', '1.28', 'pool/contrib/h/hyperspec/hyperspec_1.28_all.deb', '9760', 'The Common Lisp ANSI-standard Hyperspec', '');
INSERT INTO `packages_plain` VALUES ('61', 'ifeffit-doc', 'optional', 'contrib/doc', '5016', 'Carlo Segre ', 'all', 'ifeffit', '2:1.2.10a-5', 'pool/contrib/i/ifeffit/ifeffit-doc_1.2.10a-5_all.deb', '2271980', 'IFEFFIT examples and documentation', 'http://cars9.uchicago.edu/ifeffit/');
INSERT INTO `packages_plain` VALUES ('62', 'ifeffit', 'optional', 'contrib/science', '4672', 'Carlo Segre ', 'i386', '', '2:1.2.10a-5', 'pool/contrib/i/ifeffit/ifeffit_1.2.10a-5_i386.deb', '2005186', 'An interactive program for XAFS analysis', 'http://cars9.uchicago.edu/ifeffit/');
INSERT INTO `packages_plain` VALUES ('63', 'perl-ifeffit', 'optional', 'contrib/perl', '668', 'Carlo Segre ', 'i386', 'ifeffit', '2:1.2.10a-5', 'pool/contrib/i/ifeffit/perl-ifeffit_1.2.10a-5_i386.deb', '277810', 'Perl extensions for IFEFFIT', 'http://cars9.uchicago.edu/ifeffit/');
INSERT INTO `packages_plain` VALUES ('64', 'python-ifeffit', 'optional', 'contrib/python', '1396', 'Carlo Segre ', 'i386', 'ifeffit', '2:1.2.10a-5', 'pool/contrib/i/ifeffit/python-ifeffit_1.2.10a-5_i386.deb', '522928', 'Python GUI interface and extensions for IFEFFIT', 'http://cars9.uchicago.edu/ifeffit/');
INSERT INTO `packages_plain` VALUES ('65', 'imgtex', 'optional', 'contrib/utils', '68', 'Atsuhito KOHDA ', 'all', '', '0.20050123-8', 'pool/contrib/i/imgtex/imgtex_0.20050123-8_all.deb', '6140', 'provides yet another math-on-the-web solution', '');
INSERT INTO `packages_plain` VALUES ('66', 'ion3-scripts', 'extra', 'contrib/x11', '724', 'Debian QA Group ', 'all', '', '20070515.debian-1', 'pool/contrib/i/ion3-scripts/ion3-scripts_20070515.debian-1_all.deb', '133230', 'user-contributed add-ons to the Ion 3 window manager', 'http://modeemi.fi/~tuomov/repos/ion-scripts-3/');
INSERT INTO `packages_plain` VALUES ('67', 'isight-firmware-tools', 'extra', 'contrib/graphics', '216', 'Nobuhiro Iwamatsu ', 'i386', '', '1.4.2-3', 'pool/contrib/i/isight-firmware-tools/isight-firmware-tools_1.4.2-3_i386.deb', '34210', 'tools for dealing with Apple iSight firmware', '');
INSERT INTO `packages_plain` VALUES ('68', 'ivtv-utils', 'extra', 'contrib/x11', '396', 'Debian MythTV Team ', 'i386', '', '1.4.0-1', 'pool/contrib/i/ivtv-utils/ivtv-utils_1.4.0-1_i386.deb', '132072', 'utilities for use with the ivtv kernel driver', 'http://ivtvdriver.org');
INSERT INTO `packages_plain` VALUES ('69', 'jabref', 'optional', 'contrib/tex', '2836', 'gregor herrmann ', 'all', '', '2.5-1', 'pool/contrib/j/jabref/jabref_2.5-1_all.deb', '2582694', 'graphical frontend to manage BibTeX databases', 'http://jabref.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('70', 'java-package', 'optional', 'contrib/java', '424', 'Debian Java Maintainers ', 'all', '', '0.42', 'pool/contrib/j/java-package/java-package_0.42_all.deb', '26576', 'utility for building Java(TM) 2 related Debian packages', '');
INSERT INTO `packages_plain` VALUES ('71', 'jde', 'optional', 'contrib/devel', '3804', 'Michael W. Olson (GNU address) ', 'all', '', '2.3.5.1-5', 'pool/contrib/j/jde/jde_2.3.5.1-5_all.deb', '1577706', 'JDEE, Java Development Environment for Emacs(en)', '');
INSERT INTO `packages_plain` VALUES ('72', 'jspwiki', 'optional', 'contrib/web', '5964', 'Kalle Kivimaa ', 'all', '', '2.8.0-3.1', 'pool/contrib/j/jspwiki/jspwiki_2.8.0-3.1_all.deb', '4414836', 'WikiWikiWeb clone written in Java', 'http://www.jspwiki.org');
INSERT INTO `packages_plain` VALUES ('73', 'kbedic', 'optional', 'contrib/text', '268', 'Anton Zinoviev ', 'i386', '', '4.0-11', 'pool/contrib/k/kbedic/kbedic_4.0-11_i386.deb', '72912', 'K Bulgarian/English Dictionary', '');
INSERT INTO `packages_plain` VALUES ('74', 'lgc-pg', 'optional', 'contrib/utils', '448', 'Debian QA Group ', 'i386', '', '0.32-3', 'pool/contrib/l/lgc-pg/lgc-pg_0.32-3_i386.deb', '173734', 'LGeneral Converter for Panzer General', '');
INSERT INTO `packages_plain` VALUES ('75', 'lgeneral', 'optional', 'contrib/games', '1764', 'Debian QA Group ', 'i386', '', '1.1.1-5', 'pool/contrib/l/lgeneral/lgeneral_1.1.1-5_i386.deb', '483824', 'A \"Panzer General\" - like game', 'http://lgames.sourceforge.net');
INSERT INTO `packages_plain` VALUES ('76', 'linux-wlan-ng-firmware', 'extra', 'contrib/kernel', '224', 'Victor Seva ', 'all', 'linux-wlan-ng', '0.2.9+dfsg-2', 'pool/contrib/l/linux-wlan-ng/linux-wlan-ng-firmware_0.2.9+dfsg-2_all.deb', '52980', 'firmware files used by the linux-wlan-ng driver', '');
INSERT INTO `packages_plain` VALUES ('77', 'liveice', 'optional', 'contrib/sound', '148', 'Jochen Friedrich ', 'i386', '', '1.0-3', 'pool/contrib/l/liveice/liveice_1.0-3_i386.deb', '56726', 'Live audio streaming application', '');
INSERT INTO `packages_plain` VALUES ('78', 'libdbd-informix-perl', 'extra', 'contrib/perl', '588', 'Roderick Schertler ', 'i386', '', '2008.0513-1', 'pool/contrib/libd/libdbd-informix-perl/libdbd-informix-perl_2008.0513-1_i386.deb', '238074', 'Perl DBI driver for Informix', '');
INSERT INTO `packages_plain` VALUES ('79', 'libdbd-oracle-perl', 'extra', 'contrib/perl', '972', 'Peter Eisentraut ', 'i386', '', '1.21-2', 'pool/contrib/libd/libdbd-oracle-perl/libdbd-oracle-perl_1.21-2_i386.deb', '391780', 'Perl DBI driver for Oracle', 'http://search.cpan.org/dist/DBD-Oracle/');
INSERT INTO `packages_plain` VALUES ('80', 'libgooglecharts-ruby1.8', 'optional', 'contrib/ruby', '72', 'Ryan Niebur ', 'all', 'libgooglecharts-ruby', '1.3.6-1', 'pool/contrib/libg/libgooglecharts-ruby/libgooglecharts-ruby1.8_1.3.6-1_all.deb', '6910', 'Ruby library to create sexy charts using the Google API', 'http://googlecharts.rubyforge.org/');
INSERT INTO `packages_plain` VALUES ('81', 'libgooglecharts-ruby', 'optional', 'contrib/ruby', '32', 'Ryan Niebur ', 'all', '', '1.3.6-1', 'pool/contrib/libg/libgooglecharts-ruby/libgooglecharts-ruby_1.3.6-1_all.deb', '2330', 'Ruby library to create sexy charts using the Google API (dummy package)', 'http://googlecharts.rubyforge.org/');
INSERT INTO `packages_plain` VALUES ('82', 'libgrinvin-core-java-doc', 'optional', 'contrib/doc', '8920', 'Debian Java Maintainers ', 'all', 'libgrinvin-core-java', '1.2-1', 'pool/contrib/libg/libgrinvin-core-java/libgrinvin-core-java-doc_1.2-1_all.deb', '504898', 'interactive software package for studying graphs (API docs)', 'http://www.grinvin.org/');
INSERT INTO `packages_plain` VALUES ('83', 'libgrinvin-core-java', 'optional', 'contrib/java', '840', 'Debian Java Maintainers ', 'all', '', '1.2-1', 'pool/contrib/libg/libgrinvin-core-java/libgrinvin-core-java_1.2-1_all.deb', '710634', 'interactive software package for studying graphs (core libraries)', 'http://www.grinvin.org/');
INSERT INTO `packages_plain` VALUES ('84', 'libgrinvin-factories-java', 'optional', 'contrib/java', '144', 'Debian Java Maintainers ', 'all', '', '1.2-1', 'pool/contrib/libg/libgrinvin-factories-java/libgrinvin-factories-java_1.2-1_all.deb', '92436', 'interactive software package for studying graphs (graph factories)', 'http://www.grinvin.org/');
INSERT INTO `packages_plain` VALUES ('85', 'libgrinvin-generators-java', 'optional', 'contrib/java', '72', 'Debian Java Maintainers ', 'all', '', '1.0.1-1', 'pool/contrib/libg/libgrinvin-generators-java/libgrinvin-generators-java_1.0.1-1_all.deb', '29028', 'interactive software package for studying graphs (graph generators)', 'http://www.grinvin.org/');
INSERT INTO `packages_plain` VALUES ('86', 'libgrinvin-graphs-java', 'optional', 'contrib/java', '276', 'Debian Java Maintainers ', 'all', '', '1.2-1', 'pool/contrib/libg/libgrinvin-graphs-java/libgrinvin-graphs-java_1.2-1_all.deb', '169064', 'interactive software package for studying graphs (standard graphs)', 'http://www.grinvin.org/');
INSERT INTO `packages_plain` VALUES ('87', 'libgrinvin-help-java', 'optional', 'contrib/java', '188', 'Debian Java Maintainers ', 'all', '', '1.2-1', 'pool/contrib/libg/libgrinvin-help-java/libgrinvin-help-java_1.2-1_all.deb', '107826', 'interactive software package for studying graphs (help files)', 'http://www.grinvin.org/');
INSERT INTO `packages_plain` VALUES ('88', 'libgrinvin-invariants-java', 'optional', 'contrib/java', '232', 'Debian Java Maintainers ', 'all', '', '1.2-1', 'pool/contrib/libg/libgrinvin-invariants-java/libgrinvin-invariants-java_1.2-1_all.deb', '163526', 'interactive software package for studying graphs (graph invariants)', 'http://www.grinvin.org/');
INSERT INTO `packages_plain` VALUES ('89', 'libpdfbox-java-doc', 'extra', 'contrib/doc', '13044', 'gregor herrmann ', 'all', 'libpdfbox-java', '0.7.3.dfsg-3', 'pool/contrib/libp/libpdfbox-java/libpdfbox-java-doc_0.7.3.dfsg-3_all.deb', '804148', 'PDF library for Java (documentation)', 'http://www.pdfbox.org/');
INSERT INTO `packages_plain` VALUES ('90', 'libpdfbox-java', 'extra', 'contrib/java', '4568', 'gregor herrmann ', 'all', '', '0.7.3.dfsg-3', 'pool/contrib/libp/libpdfbox-java/libpdfbox-java_0.7.3.dfsg-3_all.deb', '4499600', 'PDF library for Java', 'http://www.pdfbox.org/');
INSERT INTO `packages_plain` VALUES ('91', 'libpgplot-perl', 'optional', 'contrib/perl', '256', 'Debian Perl Group ', 'i386', '', '1:2.20-1', 'pool/contrib/libp/libpgplot-perl/libpgplot-perl_2.20-1_i386.deb', '69092', 'perl interface to the pgplot plotting library', 'http://search.cpan.org/~kgb/PGPLOT/');
INSERT INTO `packages_plain` VALUES ('92', 'libtrain-bin', 'optional', 'contrib/misc', '48', 'Masayuki Hatta (mhatta) ', 'i386', 'libtrain', '0.9b-11', 'pool/contrib/libt/libtrain/libtrain-bin_0.9b-11_i386.deb', '6524', 'Command line interface for libtrain', '');
INSERT INTO `packages_plain` VALUES ('93', 'libtrain-dev', 'optional', 'contrib/libdevel', '136', 'Masayuki Hatta (mhatta) ', 'i386', 'libtrain', '0.9b-11', 'pool/contrib/libt/libtrain/libtrain-dev_0.9b-11_i386.deb', '34800', 'The train-routing calculator library - development', '');
INSERT INTO `packages_plain` VALUES ('94', 'libtrain1', 'optional', 'contrib/libs', '184', 'Masayuki Hatta (mhatta) ', 'i386', 'libtrain', '0.9b-11', 'pool/contrib/libt/libtrain/libtrain1_0.9b-11_i386.deb', '53966', 'The train-routing calculator library - runtime', '');
INSERT INTO `packages_plain` VALUES ('95', 'libydpdict2-dev', 'optional', 'contrib/libdevel', '72', 'Marcin Owsiany ', 'i386', 'libydpdict', '1.0.2-1', 'pool/contrib/liby/libydpdict/libydpdict2-dev_1.0.2-1_i386.deb', '9632', 'a library for reading Collins dictionaries - development files', 'http://toxygen.net/ydpdict/');
INSERT INTO `packages_plain` VALUES ('96', 'libydpdict2', 'optional', 'contrib/libs', '60', 'Marcin Owsiany ', 'i386', 'libydpdict', '1.0.2-1', 'pool/contrib/liby/libydpdict/libydpdict2_1.0.2-1_i386.deb', '10352', 'a library for reading Collins dictionaries', 'http://toxygen.net/ydpdict/');
INSERT INTO `packages_plain` VALUES ('97', 'mathematica-fonts', 'extra', 'contrib/fonts', '160', 'Atsuhito KOHDA ', 'all', '', '10', 'pool/contrib/m/mathematica-fonts/mathematica-fonts_10_all.deb', '26302', 'Installer of Mathematica fonts', '');
INSERT INTO `packages_plain` VALUES ('98', 'ttf-mathematica4.1', 'extra', 'contrib/fonts', '32', 'Atsuhito KOHDA ', 'all', 'mathematica-fonts', '10', 'pool/contrib/m/mathematica-fonts/ttf-mathematica4.1_10_all.deb', '2648', 'transitional dummy package', '');
INSERT INTO `packages_plain` VALUES ('99', 'microcode.ctl', 'optional', 'contrib/utils', '128', 'Giacomo Catenazzi ', 'i386', '', '1.17-13', 'pool/contrib/m/microcode.ctl/microcode.ctl_1.17-13_i386.deb', '23230', 'Intel IA32/IA64 CPU Microcode Utility', 'http://www.urbanmyth.org/microcode/');
INSERT INTO `packages_plain` VALUES ('100', 'ttf-mscorefonts-installer', 'optional', 'contrib/fonts', '196', 'Thijs Kinkhorst ', 'all', 'msttcorefonts', '3.0', 'pool/contrib/m/msttcorefonts/ttf-mscorefonts-installer_3.0_all.deb', '35886', 'Installer for Microsoft TrueType core fonts', '');
INSERT INTO `packages_plain` VALUES ('101', 'nestra', 'optional', 'contrib/otherosfs', '3788', 'Debian QA Group ', 'i386', '', '0.66-10', 'pool/contrib/n/nestra/nestra_0.66-10_i386.deb', '58562', 'Nintendo Entertainment System emulator', '');
INSERT INTO `packages_plain` VALUES ('102', 'netbeans-ide', 'optional', 'contrib/devel', '340996', 'Debian QA Group ', 'all', '', '6.0.1+dfsg-3', 'pool/contrib/n/netbeans-ide/netbeans-ide_6.0.1+dfsg-3_all.deb', '143850124', 'IDE for Java Development and More, version 6 (IDE)', 'http://www.netbeans.org/');
INSERT INTO `packages_plain` VALUES ('103', 'netbeans-platform', 'optional', 'contrib/devel', '17052', 'Debian QA Group ', 'all', 'netbeans-ide', '6.0.1+dfsg-3', 'pool/contrib/n/netbeans-ide/netbeans-platform_6.0.1+dfsg-3_all.deb', '6046748', 'IDE for Java Development and More, version 6 (platform foundation)', 'http://www.netbeans.org/');
INSERT INTO `packages_plain` VALUES ('104', 'netdisco-mibs-installer', 'extra', 'contrib/net', '92', 'Oliver Gorwits ', 'all', '', '1.3', 'pool/contrib/n/netdisco-mibs-installer/netdisco-mibs-installer_1.3_all.deb', '12124', 'Netdisco MIB bundle installer package', '');
INSERT INTO `packages_plain` VALUES ('105', 'nvidia-cg-toolkit', 'extra', 'contrib/libs', '168', 'Federico Di Gregorio ', 'i386', '', '2.1.0017.deb1', 'pool/contrib/n/nvidia-cg-toolkit/nvidia-cg-toolkit_2.1.0017.deb1_i386.deb', '36420', 'NVIDIA Cg Toolkit Installer', 'http://developer.nvidia.com/object/cg_toolkit.html');
INSERT INTO `packages_plain` VALUES ('106', 'nvidia-kernel-common', 'optional', 'contrib/kernel', '40', 'Debian NVIDIA Maintainers ', 'all', '', '20080825+1', 'pool/contrib/n/nvidia-kernel-common/nvidia-kernel-common_20080825+1_all.deb', '4088', 'NVIDIA binary kernel module common files', '');
INSERT INTO `packages_plain` VALUES ('107', 'nvidia-settings', 'optional', 'contrib/x11', '1900', 'Debian NVIDIA Maintainers ', 'i386', '', '185.18.31-1', 'pool/contrib/n/nvidia-settings/nvidia-settings_185.18.31-1_i386.deb', '779172', 'Tool for configuring the NVIDIA graphics driver', '');
INSERT INTO `packages_plain` VALUES ('108', 'ogre-plugins-cgprogrammanager-dbg', 'extra', 'contrib/debug', '656', 'Debian Games Team ', 'i386', 'ogre-contrib', '1.6.4-1', 'pool/contrib/o/ogre-contrib/ogre-plugins-cgprogrammanager-dbg_1.6.4-1_i386.deb', '205496', 'Ogre plugin: CgProgramManager debugging symbols', 'http://ogre3d.org/');
INSERT INTO `packages_plain` VALUES ('109', 'ogre-plugins-cgprogrammanager', 'optional', 'contrib/libs', '148', 'Debian Games Team ', 'i386', 'ogre-contrib', '1.6.4-1', 'pool/contrib/o/ogre-contrib/ogre-plugins-cgprogrammanager_1.6.4-1_i386.deb', '37446', 'Ogre plugin: CgProgramManager', 'http://ogre3d.org/');
INSERT INTO `packages_plain` VALUES ('110', 'open-vm-source', 'extra', 'contrib/admin', '948', 'Debian VMware Maintainers ', 'all', 'open-vm-tools', '2009.10.15-201664-1', 'pool/contrib/o/open-vm-tools/open-vm-source_2009.10.15-201664-1_all.deb', '911094', 'Source for VMware guest systems driver', 'http://open-vm-tools.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('111', 'open-vm-toolbox', 'extra', 'contrib/admin', '1260', 'Debian VMware Maintainers ', 'i386', 'open-vm-tools', '2009.10.15-201664-1', 'pool/contrib/o/open-vm-tools/open-vm-toolbox_2009.10.15-201664-1_i386.deb', '507116', 'tools and components for VMware guest systems (GUI tools)', 'http://open-vm-tools.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('112', 'open-vm-tools-dbg', 'extra', 'contrib/debug', '5628', 'Debian VMware Maintainers ', 'i386', 'open-vm-tools', '2009.10.15-201664-1', 'pool/contrib/o/open-vm-tools/open-vm-tools-dbg_2009.10.15-201664-1_i386.deb', '2231002', 'tools and components for VMware guest systems (debug)', 'http://open-vm-tools.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('113', 'open-vm-tools', 'extra', 'contrib/admin', '1924', 'Debian VMware Maintainers ', 'i386', '', '2009.10.15-201664-1', 'pool/contrib/o/open-vm-tools/open-vm-tools_2009.10.15-201664-1_i386.deb', '648448', 'tools and components for VMware guest systems (CLI tools)', 'http://open-vm-tools.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('114', 'opendict-plugins-lingvosoft', 'optional', 'contrib/text', '580', 'KГ„в„ўstutis BiliГ…В«nas ', 'all', 'opendict-lingvosoft', '0.8-2', 'pool/contrib/o/opendict-lingvosoft/opendict-plugins-lingvosoft_0.8-2_all.deb', '11060', 'plugins for OpenDict - LingvoSoft Online Dictionaries', '');
INSERT INTO `packages_plain` VALUES ('115', 'openjump', 'optional', 'contrib/science', '3024', 'Debian GIS Project ', 'all', '', '1.0-4', 'pool/contrib/o/openjump/openjump_1.0-4_all.deb', '2681706', 'Open Java Unified Mapping Platform JUMP', 'http://jump-pilot.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('116', 'openttd', 'optional', 'contrib/games', '8916', 'Matthijs Kooijman ', 'i386', '', '0.7.3-1', 'pool/contrib/o/openttd/openttd_0.7.3-1_i386.deb', '3394394', 'reimplementation of Transport Tycoon Deluxe with enhancements', 'http://www.openttd.org/');
INSERT INTO `packages_plain` VALUES ('117', 'ora2pg', 'extra', 'contrib/misc', '172', 'JuliГѓВЎn Moreno PatiГѓВ±o ', 'all', '', '5.4-1', 'pool/contrib/o/ora2pg/ora2pg_5.4-1_all.deb', '63722', 'Oracle to PostgreSQL database schema converter', 'http://ora2pg.projects.postgresql.org/');
INSERT INTO `packages_plain` VALUES ('118', 'playonlinux', 'optional', 'contrib/otherosfs', '1964', 'Debian Games Team ', 'all', '', '3.7.1-1', 'pool/contrib/p/playonlinux/playonlinux_3.7.1-1_all.deb', '760738', 'front-end for Wine', 'http://www.playonlinux.com/');
INSERT INTO `packages_plain` VALUES ('119', 'pose-skins', 'extra', 'contrib/otherosfs', '7524', 'Lucas Wall ', 'all', '', '1.9-4', 'pool/contrib/p/pose-skins/pose-skins_1.9-4_all.deb', '6743366', 'skins for the PalmOS Emulator', '');
INSERT INTO `packages_plain` VALUES ('120', 'pose-doc', 'extra', 'contrib/doc', '1344', 'Lucas Wall ', 'all', 'pose', '3.5-9.1', 'pool/contrib/p/pose/pose-doc_3.5-9.1_all.deb', '1232532', 'emulates the hardware for most Palm Computing Platform devices', '');
INSERT INTO `packages_plain` VALUES ('121', 'pose-profile', 'extra', 'contrib/otherosfs', '3624', 'Lucas Wall ', 'i386', 'pose', '3.5-9.1', 'pool/contrib/p/pose/pose-profile_3.5-9.1_i386.deb', '1106892', 'emulates the hardware for most Palm Computing Platform devices', '');
INSERT INTO `packages_plain` VALUES ('122', 'pose', 'extra', 'contrib/otherosfs', '3552', 'Lucas Wall ', 'i386', '', '3.5-9.1', 'pool/contrib/p/pose/pose_3.5-9.1_i386.deb', '1094312', 'emulates the hardware for most Palm Computing Platform devices', '');
INSERT INTO `packages_plain` VALUES ('123', 'premail', 'optional', 'contrib/mail', '344', 'Steve Kostecke ', 'all', '', '0.46-9', 'pool/contrib/p/premail/premail_0.46-9_all.deb', '108676', 'An e-mail privacy package.', '');
INSERT INTO `packages_plain` VALUES ('124', 'python-psyco-doc', 'optional', 'contrib/doc', '688', 'Alexandre Fayolle ', 'all', 'psyco-doc', '1.6-1', 'pool/contrib/p/psyco-doc/python-psyco-doc_1.6-1_all.deb', '283942', 'Python specializing compiler documentation', 'http://psyco.sourceforge.net');
INSERT INTO `packages_plain` VALUES ('125', 'pvpgn', 'optional', 'contrib/net', '2268', 'Radu Spineanu ', 'i386', 'pvpgn (1.8.1-2)', '1.8.1-2+b1', 'pool/contrib/p/pvpgn/pvpgn_1.8.1-2+b1_i386.deb', '770554', 'Gaming server that emulates Battle.net(R)', '');
INSERT INTO `packages_plain` VALUES ('126', 'python-cg', 'optional', 'contrib/python', '440', 'Debian Python Modules Team ', 'i386', 'pycg', '0.14.1-2', 'pool/contrib/p/pycg/python-cg_0.14.1-2_i386.deb', '92318', 'nVidia Cg driver binding for Python', 'http://www.cs.lth.se/home/Calle_Lejdfors/pygpu/');
INSERT INTO `packages_plain` VALUES ('127', 'python-pygpu', 'optional', 'contrib/python', '176', 'Debian Python Modules Team ', 'all', 'pygpu', '0.2.0a-629-2', 'pool/contrib/p/pygpu/python-pygpu_0.2.0a-629-2_all.deb', '20624', 'embedded language for programming GPU using Python', 'http://www.cs.lth.se/home/Calle_Lejdfors/pygpu/');
INSERT INTO `packages_plain` VALUES ('128', 'python-doc', 'optional', 'contrib/doc', '52', 'Matthias Klose ', 'all', 'python-doc-defaults', '2.5.2-1', 'pool/contrib/p/python-doc-defaults/python-doc_2.5.2-1_all.deb', '7364', 'Documentation for the high-level object-oriented language Python', '');
INSERT INTO `packages_plain` VALUES ('129', 'python-ldap-doc', 'optional', 'contrib/doc', '508', 'Matej Vela ', 'all', '', '2.3-2', 'pool/contrib/p/python-ldap-doc/python-ldap-doc_2.3-2_all.deb', '44280', 'Documentation for the Python LDAP interface module', 'http://python-ldap.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('130', 'python2.4-doc', 'optional', 'contrib/doc', '18328', 'Matthias Klose ', 'all', '', '2.4.6-1', 'pool/contrib/p/python2.4-doc/python2.4-doc_2.4.6-1_all.deb', '3470806', 'Documentation for the high-level object-oriented language Python (v2.4)', 'http://python.org/');
INSERT INTO `packages_plain` VALUES ('131', 'python2.5-doc', 'optional', 'contrib/doc', '20272', 'Matthias Klose ', 'all', '', '2.5.4-1', 'pool/contrib/p/python2.5-doc/python2.5-doc_2.5.4-1_all.deb', '3841314', 'Documentation for the high-level object-oriented language Python (v2.5)', 'http://python.org/');
INSERT INTO `packages_plain` VALUES ('132', 'qmail-qfilter', 'extra', 'contrib/mail', '104', 'Adam D. McKenna ', 'i386', '', '1.5-3', 'pool/contrib/q/qmail-qfilter/qmail-qfilter_1.5-3_i386.deb', '14058', 'qmail-queue filter front end', '');
INSERT INTO `packages_plain` VALUES ('133', 'qmailanalog-installer', 'optional', 'contrib/mail', '96', 'Klaus Reimer ', 'all', '', '0.70.3', 'pool/contrib/q/qmailanalog-installer/qmailanalog-installer_0.70.3_all.deb', '8272', 'Installer package for building qmailanalog binary package', '');
INSERT INTO `packages_plain` VALUES ('134', 'qmhandle', 'optional', 'contrib/mail', '88', 'Marcela Tiznado ', 'all', '', '1.3.2-1', 'pool/contrib/q/qmhandle/qmhandle_1.3.2-1_all.deb', '19454', 'tool to manage the qmail message queue', '');
INSERT INTO `packages_plain` VALUES ('135', 'r-cran-surveillance', 'optional', 'contrib/gnu-r', '4212', 'Debian Med Packaging Team ', 'i386', '', '1.1.2-1', 'pool/contrib/r/r-cran-surveillance/r-cran-surveillance_1.1.2-1_i386.deb', '1390222', 'development and the evaluation of epidemiological outbreak detection algorithms', 'http://surveillance.r-forge.r-project.org');
INSERT INTO `packages_plain` VALUES ('136', 'rocksndiamonds', 'extra', 'contrib/games', '1496', 'Dmitry E. Oboukhov ', 'i386', '', '3.2.6.1+dfsg1-5', 'pool/contrib/r/rocksndiamonds/rocksndiamonds_3.2.6.1+dfsg1-5_i386.deb', '469152', 'arcade-style game', 'http://artsoft.org');
INSERT INTO `packages_plain` VALUES ('137', 'rott-dbg', 'extra', 'contrib/debug', '1176', 'Debian Games Team ', 'i386', 'rott', '1.1.1-2', 'pool/contrib/r/rott/rott-dbg_1.1.1-2_i386.deb', '492636', 'Rise of the Triad -- The HUNT Begins (debug)', 'http://icculus.org/rott/');
INSERT INTO `packages_plain` VALUES ('138', 'rott', 'optional', 'contrib/games', '740', 'Debian Games Team ', 'i386', '', '1.1.1-2', 'pool/contrib/r/rott/rott_1.1.1-2_i386.deb', '301750', 'Rise of the Triad -- The HUNT Begins', 'http://icculus.org/rott/');
INSERT INTO `packages_plain` VALUES ('139', 'sabnzbdplus-theme-iphone', 'extra', 'contrib/net', '324', 'JCF Ploemen (jcfp) ', 'all', 'sabnzbdplus', '0.4.12-1', 'pool/contrib/s/sabnzbdplus/sabnzbdplus-theme-iphone_0.4.12-1_all.deb', '52506', 'iphone interface templates for the SABnzbd+ binary newsgrabber', 'http://sabnzbd.org');
INSERT INTO `packages_plain` VALUES ('140', 'sabnzbdplus-theme-plush', 'extra', 'contrib/net', '968', 'JCF Ploemen (jcfp) ', 'all', 'sabnzbdplus', '0.4.12-1', 'pool/contrib/s/sabnzbdplus/sabnzbdplus-theme-plush_0.4.12-1_all.deb', '208952', 'plush interface templates for the SABnzbd+ binary newsgrabber', 'http://sabnzbd.org');
INSERT INTO `packages_plain` VALUES ('141', 'sabnzbdplus-theme-smpl', 'extra', 'contrib/net', '448', 'JCF Ploemen (jcfp) ', 'all', 'sabnzbdplus', '0.4.12-1', 'pool/contrib/s/sabnzbdplus/sabnzbdplus-theme-smpl_0.4.12-1_all.deb', '104524', 'smpl interface templates for the SABnzbd+ binary newsgrabber', 'http://sabnzbd.org');
INSERT INTO `packages_plain` VALUES ('142', 'sabnzbdplus', 'extra', 'contrib/net', '1004', 'JCF Ploemen (jcfp) ', 'all', '', '0.4.12-1', 'pool/contrib/s/sabnzbdplus/sabnzbdplus_0.4.12-1_all.deb', '205208', 'web-based binary newsgrabber with nzb support', 'http://sabnzbd.org');
INSERT INTO `packages_plain` VALUES ('143', 'sapgui-package', 'extra', 'contrib/misc', '72', 'Guido GГѓВјnther ', 'all', '', '0.0.5', 'pool/contrib/s/sapgui-package/sapgui-package_0.0.5_all.deb', '5698', 'utility to build SAP GUI related Debian packages', 'https://honk.sigxcpu.org/piki/projects/sapgui-package/');
INSERT INTO `packages_plain` VALUES ('144', 'sauerbraten-wake6', 'optional', 'contrib/games', '404', 'GГѓВјrkan SengГѓВјn ', 'all', '', '1.0-1', 'pool/contrib/s/sauerbraten-wake6/sauerbraten-wake6_1.0-1_all.deb', '268560', 'Small but dodgy deathmatch/instagib map for the Sauerbraten game', 'http://wakeup.rundumbonn.de/wscm/mapping/wake6.html');
INSERT INTO `packages_plain` VALUES ('145', 'sauerbraten-dbg', 'extra', 'contrib/debug', '5380', 'Debian Games Team ', 'i386', 'sauerbraten', '0.0.20090504.dfsg-1', 'pool/contrib/s/sauerbraten/sauerbraten-dbg_0.0.20090504.dfsg-1_i386.deb', '2172266', 'Debug symbols for the Sauerbraten game engine', 'http://sauerbraten.org/');
INSERT INTO `packages_plain` VALUES ('146', 'sauerbraten-server', 'extra', 'contrib/games', '324', 'Debian Games Team ', 'i386', 'sauerbraten', '0.0.20090504.dfsg-1', 'pool/contrib/s/sauerbraten/sauerbraten-server_0.0.20090504.dfsg-1_i386.deb', '122296', 'Standalone server for the Sauerbraten game', 'http://sauerbraten.org/');
INSERT INTO `packages_plain` VALUES ('147', 'sauerbraten', 'extra', 'contrib/games', '2180', 'Debian Games Team ', 'i386', '', '0.0.20090504.dfsg-1', 'pool/contrib/s/sauerbraten/sauerbraten_0.0.20090504.dfsg-1_i386.deb', '932792', '3D first-person game engine', 'http://sauerbraten.org/');
INSERT INTO `packages_plain` VALUES ('148', 'sdic-edict', 'optional', 'contrib/text', '68', 'Taku YASUI ', 'all', 'sdic', '2.1.3-18', 'pool/contrib/s/sdic/sdic-edict_2.1.3-18_all.deb', '13780', 'installer for EDICT dictionaries for sdic', '');
INSERT INTO `packages_plain` VALUES ('149', 'sdic-eijiro', 'optional', 'contrib/text', '60', 'Taku YASUI ', 'all', 'sdic', '2.1.3-18', 'pool/contrib/s/sdic/sdic-eijiro_2.1.3-18_all.deb', '11692', 'installer for EIJIRO dictionaries for sdic', '');
INSERT INTO `packages_plain` VALUES ('150', 'sdic-gene95', 'optional', 'contrib/text', '80', 'Taku YASUI ', 'all', 'sdic', '2.1.3-18', 'pool/contrib/s/sdic/sdic-gene95_2.1.3-18_all.deb', '17550', 'installer for GENE95 dictionaries for sdic', '');
INSERT INTO `packages_plain` VALUES ('151', 'sdic', 'optional', 'contrib/text', '192', 'Taku YASUI ', 'all', '', '2.1.3-18', 'pool/contrib/s/sdic/sdic_2.1.3-18_all.deb', '49102', 'Emacs interface for Japanese dictionaries', '');
INSERT INTO `packages_plain` VALUES ('152', 'sivp', 'optional', 'contrib/math', '2728', 'Shiqi Yu ', 'i386', '', '0.4.3-3', 'pool/contrib/s/sivp/sivp_0.4.3-3_i386.deb', '2170376', 'Scilab Image and Video Processing toolbox', 'http://sivp.sourceforge.net');
INSERT INTO `packages_plain` VALUES ('153', 'sixpack', 'optional', 'contrib/science', '784', 'Carlo Segre ', 'all', '', '1:0.66-3', 'pool/contrib/s/sixpack/sixpack_0.66-3_all.deb', '162232', 'full-featured package for XAS analysis', 'http://www-ssrl.slac.stanford.edu/~swebb/sixpack.htm');
INSERT INTO `packages_plain` VALUES ('154', 'python-skype', 'extra', 'contrib/python', '668', 'Debian Python Modules Team ', 'all', 'skype4py', '1.0.31.0-1', 'pool/contrib/s/skype4py/python-skype_1.0.31.0-1_all.deb', '102566', 'Skype API wrapper for Python', 'https://developer.skype.com/wiki/Skype4Py');
INSERT INTO `packages_plain` VALUES ('155', 'skysentials', 'extra', 'contrib/net', '96', 'Rafael Laboissiere ', 'all', '', '1.0.1-4', 'pool/contrib/s/skysentials/skysentials_1.0.1-4_all.deb', '12544', 'extra functionalities for Linux Skype client', 'http://www.kolmann.at/philipp/linux/skysentials/');
INSERT INTO `packages_plain` VALUES ('156', 'spectemu-common', 'optional', 'contrib/otherosfs', '232', 'Colin Watson ', 'i386', 'spectemu', '0.94a-9', 'pool/contrib/s/spectemu/spectemu-common_0.94a-9_i386.deb', '64022', 'Fast 48k ZX Spectrum Emulator (common files)', '');
INSERT INTO `packages_plain` VALUES ('157', 'spectemu-svga', 'optional', 'contrib/otherosfs', '204', 'Colin Watson ', 'i386', 'spectemu', '0.94a-9', 'pool/contrib/s/spectemu/spectemu-svga_0.94a-9_i386.deb', '53952', 'Fast 48k ZX Spectrum Emulator for SVGAlib', '');
INSERT INTO `packages_plain` VALUES ('158', 'spectemu-x11', 'optional', 'contrib/otherosfs', '272', 'Colin Watson ', 'i386', 'spectemu', '0.94a-9', 'pool/contrib/s/spectemu/spectemu-x11_0.94a-9_i386.deb', '85856', 'Fast 48k ZX Spectrum Emulator for X11', '');
INSERT INTO `packages_plain` VALUES ('159', 'sqldeveloper-package', 'optional', 'contrib/misc', '88', 'Lazarus Long ', 'all', '', '0.2.3', 'pool/contrib/s/sqldeveloper-package/sqldeveloper-package_0.2.3_all.deb', '17212', 'Oracle SQL Developer Debian package builder', '');
INSERT INTO `packages_plain` VALUES ('160', 'stella', 'optional', 'contrib/otherosfs', '3148', 'Mario Iseli ', 'i386', '', '2.2-1.1', 'pool/contrib/s/stella/stella_2.2-1.1_i386.deb', '1145596', 'Atari 2600 Emulator for SDL & X windows', '');
INSERT INTO `packages_plain` VALUES ('161', 'susv2', 'extra', 'contrib/doc', '48', 'Jeff Bailey ', 'all', '', '1.1', 'pool/contrib/s/susv2/susv2_1.1_all.deb', '2278', 'Fetch and install SUSv2 documentation', '');
INSERT INTO `packages_plain` VALUES ('162', 'susv3', 'extra', 'contrib/doc', '48', 'Jeff Bailey ', 'all', '', '6.1', 'pool/contrib/s/susv3/susv3_6.1_all.deb', '2282', 'Fetch and install SUSv3 documentation', '');
INSERT INTO `packages_plain` VALUES ('163', 'svtools', 'optional', 'contrib/misc', '160', 'Klaus Reimer ', 'all', '', '0.5-4', 'pool/contrib/s/svtools/svtools_0.5-4_all.deb', '14572', 'Utilities for daemontools and multilog', '');
INSERT INTO `packages_plain` VALUES ('164', 'tightvnc-java', 'optional', 'contrib/java', '204', 'Ola Lundqvist ', 'all', '', '1.2.7-8', 'pool/contrib/t/tightvnc-java/tightvnc-java_1.2.7-8_all.deb', '104042', 'TightVNC java applet and command line program', '');
INSERT INTO `packages_plain` VALUES ('165', 'tremulous-doc', 'optional', 'contrib/doc', '720', 'Damien Laniel ', 'all', 'tremulous', '1.1.0-4.1', 'pool/contrib/t/tremulous/tremulous-doc_1.1.0-4.1_all.deb', '640890', 'Tremulous documentation', '');
INSERT INTO `packages_plain` VALUES ('166', 'tremulous-server', 'optional', 'contrib/games', '776', 'Damien Laniel ', 'i386', 'tremulous (1.1.0-4.1)', '1.1.0-4.1+b1', 'pool/contrib/t/tremulous/tremulous-server_1.1.0-4.1+b1_i386.deb', '353082', 'Tremulous server', '');
INSERT INTO `packages_plain` VALUES ('167', 'tremulous', 'optional', 'contrib/games', '1472', 'Damien Laniel ', 'i386', 'tremulous (1.1.0-4.1)', '1.1.0-4.1+b1', 'pool/contrib/t/tremulous/tremulous_1.1.0-4.1+b1_i386.deb', '672916', 'Aliens vs Humans, team based FPS game with elements of an RTS', '');
INSERT INTO `packages_plain` VALUES ('168', 'uae-dbg', 'extra', 'contrib/debug', '344', 'Stephan SГѓВјrken ', 'i386', 'uae', '0.8.29-4', 'pool/contrib/u/uae/uae-dbg_0.8.29-4_i386.deb', '153526', 'The Ubiquitous Amiga Emulator (debugging)', 'http://uae.coresystems.de/');
INSERT INTO `packages_plain` VALUES ('169', 'uae', 'optional', 'contrib/otherosfs', '2184', 'Stephan SГѓВјrken ', 'i386', '', '0.8.29-4', 'pool/contrib/u/uae/uae_0.8.29-4_i386.deb', '696094', 'The Ubiquitous Amiga Emulator', 'http://uae.coresystems.de/');
INSERT INTO `packages_plain` VALUES ('170', 'uqm-russian', 'extra', 'contrib/games', '1496', 'Dmitry E. Oboukhov ', 'all', '', '1.0.2-5', 'pool/contrib/u/uqm-russian/uqm-russian_1.0.2-5_all.deb', '1046348', 'Russian addon for \'The Ur-Quan Masters\' game', 'http://uqm-rus.uvw.ru');
INSERT INTO `packages_plain` VALUES ('171', 'uqm', 'optional', 'contrib/games', '1420', 'Dmitry E. Oboukhov ', 'i386', '', '0.6.2.dfsg-9', 'pool/contrib/u/uqm/uqm_0.6.2.dfsg-9_i386.deb', '590578', 'The Ur-Quan Masters - An inter-galatic adventure game', 'http://sc2.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('172', 'vice', 'optional', 'contrib/otherosfs', '11988', 'Laszlo Boszormenyi (GCS) ', 'i386', '', '2.1.dfsg-3', 'pool/contrib/v/vice/vice_2.1.dfsg-3_i386.deb', '3971358', 'The Versatile Commodore Emulator', 'http://www.viceteam.org/');
INSERT INTO `packages_plain` VALUES ('173', 'videolink', 'extra', 'contrib/video', '312', 'Ben Hutchings ', 'i386', '', '1.2.8-1', 'pool/contrib/v/videolink/videolink_1.2.8-1_i386.deb', '97616', 'assembles a DVD video filesystem from HTML pages and video files', 'http://womble.decadent.org.uk/software/videolink/');
INSERT INTO `packages_plain` VALUES ('174', 'vmware-view-open-client', 'optional', 'contrib/x11', '1224', 'Debian VMware Maintainers ', 'i386', '', '4.0.0-207079+dfsg-1', 'pool/contrib/v/vmware-view-open-client/vmware-view-open-client_4.0.0-207079+dfsg-1_i386.deb', '422592', 'VMware View Open Client', 'http://code.google.com/p/vmware-view-open-client');
INSERT INTO `packages_plain` VALUES ('175', 'vnc-java', 'optional', 'contrib/java', '160', 'Ola Lundqvist ', 'all', '', '3.3.3r2-8', 'pool/contrib/v/vnc-java/vnc-java_3.3.3r2-8_all.deb', '65800', 'VNC java applet and command line program', '');
INSERT INTO `packages_plain` VALUES ('176', 'warsow-server', 'optional', 'contrib/games', '636', 'Debian Games Team ', 'i386', 'warsow', '0.42.dfsg1-1.1', 'pool/contrib/w/warsow/warsow-server_0.42.dfsg1-1.1_i386.deb', '290596', 'Server and TV server for the Warsow 3D first person shooter', 'http://www.warsow.net/');
INSERT INTO `packages_plain` VALUES ('177', 'warsow', 'optional', 'contrib/games', '3576', 'Debian Games Team ', 'i386', '', '0.42.dfsg1-1.1', 'pool/contrib/w/warsow/warsow_0.42.dfsg1-1.1_i386.deb', '2127516', 'fast paced 3D first person shooter', 'http://www.warsow.net/');
INSERT INTO `packages_plain` VALUES ('178', 'wdq2wav', 'extra', 'contrib/utils', '80', 'Kevin M. Rosenberg ', 'i386', '', '0.8.3-1', 'pool/contrib/w/wdq2wav/wdq2wav_0.8.3-1_i386.deb', '16842', 'Converts a WinDAQ channel to sound .wav file', 'http://files.b9.com/wdq2wav/');
INSERT INTO `packages_plain` VALUES ('179', 'wnn7egg', 'extra', 'contrib/utils', '680', 'ISHIKAWA Mutsumi ', 'all', '', '1.02-7', 'pool/contrib/w/wnn7egg/wnn7egg_1.02-7_all.deb', '129806', 'Wnn-nana-tamago -- EGG Input Method with Wnn7 for Emacsen', '');
INSERT INTO `packages_plain` VALUES ('180', 'x-pgp-sig-el', 'optional', 'contrib/lisp', '236', 'Takuo KITAME ', 'all', '', '1.3.5.1-4.1', 'pool/contrib/x/x-pgp-sig-el/x-pgp-sig-el_1.3.5.1-4.1_all.deb', '57472', 'X-PGP-Sig mail and news header utility for Emacs', '');
INSERT INTO `packages_plain` VALUES ('181', 'xserver-xorg-video-ivtv-dbg', 'extra', 'contrib/debug', '204', 'Debian X Strike Force ', 'i386', 'xserver-xorg-video-ivtvdev', '1.1.0-1', 'pool/contrib/x/xserver-xorg-video-ivtvdev/xserver-xorg-video-ivtv-dbg_1.1.0-1_i386.deb', '67740', 'X.Org X server -- IVTV display driver (debug symbols)', '');
INSERT INTO `packages_plain` VALUES ('182', 'xserver-xorg-video-ivtv', 'extra', 'contrib/x11', '92', 'Debian X Strike Force ', 'i386', 'xserver-xorg-video-ivtvdev', '1.1.0-1', 'pool/contrib/x/xserver-xorg-video-ivtvdev/xserver-xorg-video-ivtv_1.1.0-1_i386.deb', '23328', 'X.Org X server -- IVTV display driver', '');
INSERT INTO `packages_plain` VALUES ('183', 'xtrs', 'extra', 'contrib/otherosfs', '972', 'Branden Robinson ', 'i386', '', '4.9c-3', 'pool/contrib/x/xtrs/xtrs_4.9c-3_i386.deb', '331780', 'emulator for TRS-80 Model I/III/4/4P computers', '');
INSERT INTO `packages_plain` VALUES ('184', 'ydpdict', 'optional', 'contrib/text', '148', 'Marcin Owsiany ', 'i386', '', '1.0.0-1', 'pool/contrib/y/ydpdict/ydpdict_1.0.0-1_i386.deb', '25878', 'interface for Collins and Langenscheidt dictionaries', 'http://toxygen.net/ydpdict/');
INSERT INTO `packages_plain` VALUES ('185', '2vcard', 'optional', 'utils', '108', 'Martin Albisetti ', 'all', '', '0.5-3', 'pool/main/2/2vcard/2vcard_0.5-3_all.deb', '14300', 'perl script to convert an addressbook to VCARD file format', '');
INSERT INTO `packages_plain` VALUES ('186', '3dchess', 'optional', 'games', '144', 'Debian Games Team ', 'i386', '', '0.8.1-16', 'pool/main/3/3dchess/3dchess_0.8.1-16_i386.deb', '34932', '3D chess for X11', '');
INSERT INTO `packages_plain` VALUES ('187', '4g8', 'optional', 'net', '72', 'LaMont Jones ', 'i386', '', '1.0-3', 'pool/main/4/4g8/4g8_1.0-3_i386.deb', '12164', 'Packet Capture and Interception for Switched Networks', '');
INSERT INTO `packages_plain` VALUES ('188', '6tunnel', 'optional', 'net', '68', 'Thomas Seyrat ', 'i386', '', '0.11rc2-2', 'pool/main/6/6tunnel/6tunnel_0.11rc2-2_i386.deb', '12810', 'TCP proxy for non-IPv6 applications', '');
INSERT INTO `packages_plain` VALUES ('189', '9base', 'optional', 'utils', '3428', 'Debian Suckless Maintainers ', 'i386', '', '1:4-1', 'pool/main/9/9base/9base_4-1_i386.deb', '1148990', 'Plan 9 userland tools', 'http://tools.suckless.org/9base/');
INSERT INTO `packages_plain` VALUES ('190', '9menu', 'optional', 'x11', '76', 'Debian QA Group ', 'i386', '', '1.8-2', 'pool/main/9/9menu/9menu_1.8-2_i386.deb', '14514', 'Creates X menus from the shell', '');
INSERT INTO `packages_plain` VALUES ('191', '9mount-dbg', 'extra', 'debug', '76', 'Debian QA Group ', 'i386', '9mount', '1.3-7', 'pool/main/9/9mount/9mount-dbg_1.3-7_i386.deb', '6954', 'plan9 filesystem (v9fs) user mount utilities (debug)', 'http://sqweek.dnsdojo.org/code/9mount/');
INSERT INTO `packages_plain` VALUES ('192', '9mount', 'optional', 'admin', '88', 'Debian QA Group ', 'i386', '', '1.3-7', 'pool/main/9/9mount/9mount_1.3-7_i386.deb', '11604', 'plan9 filesystem (v9fs) user mount utilities', 'http://sqweek.dnsdojo.org/code/9mount/');
INSERT INTO `packages_plain` VALUES ('193', '9wm', 'optional', 'x11', '68', 'Decklin Foster ', 'i386', '', '1.2-9', 'pool/main/9/9wm/9wm_1.2-9_i386.deb', '24932', 'emulation of the Plan 9 window manager 8-1/2', '');
INSERT INTO `packages_plain` VALUES ('194', 'a2ps-perl-ja', 'optional', 'perl', '76', 'Debian QA Group ', 'all', '', '1.45-5', 'pool/main/a/a2ps-perl-ja/a2ps-perl-ja_1.45-5_all.deb', '14006', 'perl version of Miguel Santana\'s a2ps (supports KANJI)', '');
INSERT INTO `packages_plain` VALUES ('195', 'a2ps', 'optional', 'text', '4244', 'Masayuki Hatta (mhatta) ', 'i386', '', '1:4.14-1', 'pool/main/a/a2ps/a2ps_4.14-1_i386.deb', '926602', 'GNU a2ps - \'Anything to PostScript\' converter and pretty-printer', '');
INSERT INTO `packages_plain` VALUES ('196', 'liba52-0.7.4-dev', 'optional', 'libdevel', '188', 'Debian multimedia packages maintainers ', 'i386', 'a52dec', '0.7.4-12', 'pool/main/a/a52dec/liba52-0.7.4-dev_0.7.4-12_i386.deb', '46194', 'library for decoding ATSC A/52 streams (development)', 'http://liba52.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('197', 'liba52-0.7.4', 'optional', 'libs', '112', 'Debian multimedia packages maintainers ', 'i386', 'a52dec', '0.7.4-12', 'pool/main/a/a52dec/liba52-0.7.4_0.7.4-12_i386.deb', '28048', 'library for decoding ATSC A/52 streams', 'http://liba52.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('198', 'a56', 'extra', 'devel', '160', 'Robert Millan ', 'i386', '', '1.3-5', 'pool/main/a/a56/a56_1.3-5_i386.deb', '35270', 'Motorola DSP56001 assembler', 'http://www.zdomain.com/a56.html');
INSERT INTO `packages_plain` VALUES ('199', 'a7xpg-data', 'extra', 'games', '3648', 'Debian Games Team ', 'all', 'a7xpg', '0.11.dfsg1-4', 'pool/main/a/a7xpg/a7xpg-data_0.11.dfsg1-4_all.deb', '3527724', 'chase action game - game data', 'http://www.asahi-net.or.jp/~cs8k-cyu/windows/a7xpg_e.html');
INSERT INTO `packages_plain` VALUES ('200', 'a7xpg', 'extra', 'games', '1468', 'Debian Games Team ', 'i386', '', '0.11.dfsg1-4', 'pool/main/a/a7xpg/a7xpg_0.11.dfsg1-4_i386.deb', '154902', 'chase action game', 'http://www.asahi-net.or.jp/~cs8k-cyu/windows/a7xpg_e.html');
INSERT INTO `packages_plain` VALUES ('201', 'aa3d', 'optional', 'graphics', '76', 'Uwe Hermann ', 'i386', '', '1.0-8', 'pool/main/a/aa3d/aa3d_1.0-8_i386.deb', '8832', 'ASCII art stereogram generator', 'http://aa-project.sourceforge.net/aa3d/');
INSERT INTO `packages_plain` VALUES ('202', 'python-aafigure', 'optional', 'python', '236', 'Jakub Wilk ', 'all', 'aafigure', '0.4-2', 'pool/main/a/aafigure/python-aafigure_0.4-2_all.deb', '38134', 'ASCII art to image converter', 'https://launchpad.net/aafigure');
INSERT INTO `packages_plain` VALUES ('203', 'libaa-bin', 'optional', 'text', '88', 'Bart Martens ', 'i386', 'aalib', '1.4p5-38', 'pool/main/a/aalib/libaa-bin_1.4p5-38_i386.deb', '10070', 'sample programs using aalib', 'http://aa-project.sourceforge.net/aalib/');
INSERT INTO `packages_plain` VALUES ('204', 'libaa1-dbg', 'extra', 'debug', '276', 'Bart Martens ', 'i386', 'aalib', '1.4p5-38', 'pool/main/a/aalib/libaa1-dbg_1.4p5-38_i386.deb', '69292', 'ascii art library, debugging symbols', 'http://aa-project.sourceforge.net/aalib/');
INSERT INTO `packages_plain` VALUES ('205', 'libaa1-dev', 'optional', 'libdevel', '556', 'Bart Martens ', 'i386', 'aalib', '1.4p5-38', 'pool/main/a/aalib/libaa1-dev_1.4p5-38_i386.deb', '139610', 'ascii art library, development kit', 'http://aa-project.sourceforge.net/aalib/');
INSERT INTO `packages_plain` VALUES ('206', 'libaa1', 'optional', 'libs', '180', 'Bart Martens ', 'i386', 'aalib', '1.4p5-38', 'pool/main/a/aalib/libaa1_1.4p5-38_i386.deb', '58432', 'ascii art library', 'http://aa-project.sourceforge.net/aalib/');
INSERT INTO `packages_plain` VALUES ('207', 'aap-doc', 'optional', 'doc', '1844', 'Debian QA Group ', 'all', 'aap', '1.091-1', 'pool/main/a/aap/aap-doc_1.091-1_all.deb', '676290', 'make-like \"expert system\" for building software (documentation)', 'http://www.a-a-p.org/');
INSERT INTO `packages_plain` VALUES ('208', 'aap', 'optional', 'devel', '1068', 'Debian QA Group ', 'all', '', '1.091-1', 'pool/main/a/aap/aap_1.091-1_all.deb', '217620', 'make-like \"expert system\" for building software', 'http://www.a-a-p.org/');
INSERT INTO `packages_plain` VALUES ('209', 'aatv', 'optional', 'video', '112', 'Uwe Hermann ', 'i386', '', '0.3-5', 'pool/main/a/aatv/aatv_0.3-5_i386.deb', '15892', 'A program to watch TV in a text-based console', 'http://aatv.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('210', 'abakus', 'optional', 'kde', '728', 'Steffen Joeris ', 'i386', '', '0.91-1', 'pool/main/a/abakus/abakus_0.91-1_i386.deb', '364282', 'calculator for KDE', '');
INSERT INTO `packages_plain` VALUES ('211', 'abby', 'optional', 'video', '316', 'Alejandro Garrido Mota ', 'i386', '', '0.4.4-1', 'pool/main/a/abby/abby_0.4.4-1_i386.deb', '106806', 'front-end for cclive and clive', 'http://code.google.com/p/abby/');
INSERT INTO `packages_plain` VALUES ('212', 'abcde', 'optional', 'sound', '268', 'Jesus Climent ', 'all', '', '2.4.0-1', 'pool/main/a/abcde/abcde_2.4.0-1_all.deb', '115330', 'A Better CD Encoder', 'http://code.google.com/p/abcde/');
INSERT INTO `packages_plain` VALUES ('213', 'abcm2ps', 'optional', 'text', '416', 'Anselm Lingnau ', 'i386', '', '5.9.5-1', 'pool/main/a/abcm2ps/abcm2ps_5.9.5-1_i386.deb', '179858', 'Translates ABC music description files to PostScript', '');
INSERT INTO `packages_plain` VALUES ('214', 'abcmidi-yaps', 'extra', 'sound', '204', 'Anselm Lingnau ', 'i386', 'abcmidi', '20070318-2', 'pool/main/a/abcmidi/abcmidi-yaps_20070318-2_i386.deb', '74816', 'yet another ABC to PostScript converter', '');
INSERT INTO `packages_plain` VALUES ('215', 'abcmidi', 'optional', 'sound', '380', 'Anselm Lingnau ', 'i386', '', '20070318-2', 'pool/main/a/abcmidi/abcmidi_20070318-2_i386.deb', '178934', 'converter from ABC to MIDI format and back', '');
INSERT INTO `packages_plain` VALUES ('216', 'abe-data', 'optional', 'games', '4136', 'Bart Martens ', 'all', 'abe', '1.1-3', 'pool/main/a/abe/abe-data_1.1-3_all.deb', '2950864', 'Side-scrolling game named \"Abe\'s Amazing Adventure\"', 'http://abe.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('217', 'abe', 'optional', 'games', '120', 'Bart Martens ', 'i386', '', '1.1-3', 'pool/main/a/abe/abe_1.1-3_i386.deb', '41766', 'Side-scrolling game named \"Abe\'s Amazing Adventure\"', 'http://abe.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('218', 'abi-compliance-checker', 'optional', 'devel', '324', 'Ryan Niebur ', 'all', '', '1.6-1', 'pool/main/a/abi-compliance-checker/abi-compliance-checker_1.6-1_all.deb', '41414', 'tool to compare ABI compatibility of shared C/C++ library versions', 'http://ispras.linux-foundation.org/index.php/ABI_compliance_checker');
INSERT INTO `packages_plain` VALUES ('219', 'abicheck', 'optional', 'devel', '148', 'Angel Ramos ', 'all', '', '1.2-5', 'pool/main/a/abicheck/abicheck_1.2-5_all.deb', '34316', 'binary compatibility checking tool', '');
INSERT INTO `packages_plain` VALUES ('220', 'r-cran-abind', 'optional', 'gnu-r', '136', 'Dirk Eddelbuettel ', 'all', 'abind', '1.1.0-4', 'pool/main/a/abind/r-cran-abind_1.1.0-4_all.deb', '19444', 'GNU R abind multi-dimensional array combination function', '');
INSERT INTO `packages_plain` VALUES ('221', 'abinit-doc', 'extra', 'doc', '25396', 'Debian Scientific Computing Team ', 'all', 'abinit', '5.3.4.dfsg-3', 'pool/main/a/abinit/abinit-doc_5.3.4.dfsg-3_all.deb', '17017858', 'A package for electronic structure calculations', 'http://www.abinit.org/');
INSERT INTO `packages_plain` VALUES ('222', 'abinit', 'extra', 'science', '11996', 'Debian Scientific Computing Team ', 'i386', '', '5.3.4.dfsg-3', 'pool/main/a/abinit/abinit_5.3.4.dfsg-3_i386.deb', '4697326', 'A package for electronic structure calculations', 'http://www.abinit.org/');
INSERT INTO `packages_plain` VALUES ('223', 'abiword-common', 'optional', 'editors', '8628', 'Masayuki Hatta (mhatta) ', 'all', 'abiword', '2.6.8-5', 'pool/main/a/abiword/abiword-common_2.6.8-5_all.deb', '2005496', 'efficient, featureful word processor with collaboration -- common files', 'http://www.abisource.com/');
INSERT INTO `packages_plain` VALUES ('224', 'abiword-help', 'optional', 'doc', '3136', 'Masayuki Hatta (mhatta) ', 'all', 'abiword', '2.6.8-5', 'pool/main/a/abiword/abiword-help_2.6.8-5_all.deb', '1256628', 'online help for AbiWord', 'http://www.abisource.com/');
INSERT INTO `packages_plain` VALUES ('225', 'abiword-plugin-goffice', 'optional', 'editors', '168', 'Masayuki Hatta (mhatta) ', 'i386', 'abiword', '2.6.8-5', 'pool/main/a/abiword/abiword-plugin-goffice_2.6.8-5_i386.deb', '68874', 'GOffice interaction plugin for AbiWord', 'http://www.abisource.com/');
INSERT INTO `packages_plain` VALUES ('226', 'abiword-plugin-grammar', 'optional', 'editors', '104', 'Masayuki Hatta (mhatta) ', 'i386', 'abiword', '2.6.8-5', 'pool/main/a/abiword/abiword-plugin-grammar_2.6.8-5_i386.deb', '45470', 'grammar checking plugin for AbiWord', 'http://www.abisource.com/');
INSERT INTO `packages_plain` VALUES ('227', 'abiword-plugin-mathview', 'optional', 'editors', '344', 'Masayuki Hatta (mhatta) ', 'i386', 'abiword', '2.6.8-5', 'pool/main/a/abiword/abiword-plugin-mathview_2.6.8-5_i386.deb', '129904', 'equation editor plugin for AbiWord', 'http://www.abisource.com/');
INSERT INTO `packages_plain` VALUES ('228', 'abiword-plugins', 'optional', 'editors', '68', 'Masayuki Hatta (mhatta) ', 'all', 'abiword', '2.6.8-5', 'pool/main/a/abiword/abiword-plugins_2.6.8-5_all.deb', '34998', 'transitional plugins package for AbiWord', 'http://www.abisource.com/');
INSERT INTO `packages_plain` VALUES ('229', 'abiword', 'optional', 'editors', '7720', 'Masayuki Hatta (mhatta) ', 'i386', '', '2.6.8-5', 'pool/main/a/abiword/abiword_2.6.8-5_i386.deb', '2982130', 'efficient, featureful word processor with collaboration', 'http://www.abisource.com/');
INSERT INTO `packages_plain` VALUES ('230', 'abntex', 'optional', 'tex', '816', 'Otavio Salvador ', 'all', '', '0.9~beta2-2.1', 'pool/main/a/abntex/abntex_0.9~beta2-2.1_all.deb', '325628', 'LaTeX class for writing documents in ABNT standard', '');
INSERT INTO `packages_plain` VALUES ('231', 'abook', 'optional', 'mail', '316', 'Gerfried Fuchs ', 'i386', '', '0.5.6-7', 'pool/main/a/abook/abook_0.5.6-7_i386.deb', '80858', 'text-based ncurses address book application', 'http://abook.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('232', 'aboot-base', 'optional', 'admin', '288', 'Steve Langasek ', 'all', 'aboot', '1.0~pre20040408-3', 'pool/main/a/aboot/aboot-base_1.0~pre20040408-3_all.deb', '76442', 'base files required for bootable media on Linux/Alpha', '');
INSERT INTO `packages_plain` VALUES ('233', 'aboot-cross', 'optional', 'admin', '64', 'Steve Langasek ', 'i386', 'aboot', '1.0~pre20040408-3', 'pool/main/a/aboot/aboot-cross_1.0~pre20040408-3_i386.deb', '28514', 'utility to create bootable ISO-Images for Linux/Alpha', '');
INSERT INTO `packages_plain` VALUES ('234', 'abr2gbr', 'extra', 'graphics', '60', 'Alice Ferrazzi ', 'i386', '', '1.0.2-1', 'pool/main/a/abr2gbr/abr2gbr_1.0.2-1_i386.deb', '6514', 'Converts PhotoShop brushes to GIMP', 'http://www.sunnyspot.org/gimp/tools.html');
INSERT INTO `packages_plain` VALUES ('235', 'abuse-frabs', 'optional', 'games', '13988', 'Debian Games Team ', 'all', '', '2.11-1', 'pool/main/a/abuse-frabs/abuse-frabs_2.11-1_all.deb', '3312144', 'levels and graphics for Abuse', '');
INSERT INTO `packages_plain` VALUES ('236', 'abuse-lib', 'extra', 'games', '3844', 'Debian Games Team ', 'all', '', '2.00-18', 'pool/main/a/abuse-lib/abuse-lib_2.00-18_all.deb', '834782', 'original levels for Abuse', '');
INSERT INTO `packages_plain` VALUES ('237', 'abuse', 'optional', 'games', '712', 'Debian Games Team ', 'i386', 'abuse-sdl', '1:0.7.1-1', 'pool/main/a/abuse-sdl/abuse_0.7.1-1_i386.deb', '316218', 'SDL port of the Abuse action game', '');
INSERT INTO `packages_plain` VALUES ('238', 'accerciser', 'extra', 'gnome', '4188', 'Debian Accessibility Team ', 'all', '', '1.8.0-1', 'pool/main/a/accerciser/accerciser_1.8.0-1_all.deb', '1426622', 'an interactive Python accessibility explorer for the GNOME desktop', '');
INSERT INTO `packages_plain` VALUES ('239', 'acct', 'optional', 'admin', '356', 'Debian QA Group ', 'i386', '', '6.4~pre1-9', 'pool/main/a/acct/acct_6.4~pre1-9_i386.deb', '107870', 'The GNU Accounting utilities for process and login accounting', 'http://www.gnu.org/software/acct/');
INSERT INTO `packages_plain` VALUES ('240', 'ace-of-penguins', 'optional', 'games', '628', 'Jari Aalto ', 'i386', '', '1.2-9', 'pool/main/a/ace-of-penguins/ace-of-penguins_1.2-9_i386.deb', '241956', 'graphical solitaire-games with penguin-look', 'http://freshmeat.net/projects/theaceofpenguins');
INSERT INTO `packages_plain` VALUES ('241', 'gperf-ace', 'optional', 'devel', '224', 'Debian ACE+TAO maintainers ', 'i386', 'ace', '5.6.3-5', 'pool/main/a/ace/gperf-ace_5.6.3-5_i386.deb', '98372', 'ACE perfect hash function generator', 'http://www.cs.wustl.edu/~schmidt/ACE.html');
INSERT INTO `packages_plain` VALUES ('242', 'libace-5.6.3', 'optional', 'libs', '1696', 'Debian ACE+TAO maintainers ', 'i386', 'ace', '5.6.3-5', 'pool/main/a/ace/libace-5.6.3_5.6.3-5_i386.deb', '689618', 'C++ network programming framework', 'http://www.cs.wustl.edu/~schmidt/ACE.html');
INSERT INTO `packages_plain` VALUES ('243', 'libace-dev', 'optional', 'libdevel', '8504', 'Debian ACE+TAO maintainers ', 'i386', 'ace', '5.6.3-5', 'pool/main/a/ace/libace-dev_5.6.3-5_i386.deb', '1325252', 'C++ network programming framework development files', 'http://www.cs.wustl.edu/~schmidt/ACE.html');
INSERT INTO `packages_plain` VALUES ('244', 'libace-doc', 'optional', 'doc', '46272', 'Debian ACE+TAO maintainers ', 'all', 'ace', '5.6.3-5', 'pool/main/a/ace/libace-doc_5.6.3-5_all.deb', '4743994', 'C++ network programming framework documentation', 'http://www.cs.wustl.edu/~schmidt/ACE.html');
INSERT INTO `packages_plain` VALUES ('245', 'libace-flreactor-5.6.3', 'optional', 'libs', '204', 'Debian ACE+TAO maintainers ', 'i386', 'ace', '5.6.3-5', 'pool/main/a/ace/libace-flreactor-5.6.3_5.6.3-5_i386.deb', '96200', 'ACE-GUI reactor integration for Fl', 'http://www.cs.wustl.edu/~schmidt/ACE.html');
INSERT INTO `packages_plain` VALUES ('246', 'libace-flreactor-dev', 'optional', 'libdevel', '160', 'Debian ACE+TAO maintainers ', 'i386', 'ace', '5.6.3-5', 'pool/main/a/ace/libace-flreactor-dev_5.6.3-5_i386.deb', '74276', 'ACE-GUI reactor integration for Fl development files', 'http://www.cs.wustl.edu/~schmidt/ACE.html');
INSERT INTO `packages_plain` VALUES ('247', 'libace-foxreactor-5.6.3', 'optional', 'libs', '208', 'Debian ACE+TAO maintainers ', 'i386', 'ace', '5.6.3-5', 'pool/main/a/ace/libace-foxreactor-5.6.3_5.6.3-5_i386.deb', '97248', 'ACE-GUI reactor integration for FOX', 'http://www.cs.wustl.edu/~schmidt/ACE.html');
INSERT INTO `packages_plain` VALUES ('248', 'libace-foxreactor-dev', 'optional', 'libdevel', '160', 'Debian ACE+TAO maintainers ', 'i386', 'ace', '5.6.3-5', 'pool/main/a/ace/libace-foxreactor-dev_5.6.3-5_i386.deb', '74230', 'ACE-GUI reactor integration for FOX development files', 'http://www.cs.wustl.edu/~schmidt/ACE.html');
INSERT INTO `packages_plain` VALUES ('249', 'libace-htbp-5.6.3', 'optional', 'libs', '240', 'Debian ACE+TAO maintainers ', 'i386', 'ace', '5.6.3-5', 'pool/main/a/ace/libace-htbp-5.6.3_5.6.3-5_i386.deb', '107744', 'ACE protocol over HTTP tunneling library', 'http://www.cs.wustl.edu/~schmidt/ACE.html');
INSERT INTO `packages_plain` VALUES ('250', 'libace-htbp-dev', 'optional', 'libdevel', '248', 'Debian ACE+TAO maintainers ', 'i386', 'ace', '5.6.3-5', 'pool/main/a/ace/libace-htbp-dev_5.6.3-5_i386.deb', '87910', 'ACE protocol over HTTP tunneling library development files', 'http://www.cs.wustl.edu/~schmidt/ACE.html');
INSERT INTO `packages_plain` VALUES ('251', 'libace-qtreactor-5.6.3', 'optional', 'libs', '220', 'Debian ACE+TAO maintainers ', 'i386', 'ace', '5.6.3-5', 'pool/main/a/ace/libace-qtreactor-5.6.3_5.6.3-5_i386.deb', '101716', 'ACE-GUI reactor integration for Qt', 'http://www.cs.wustl.edu/~schmidt/ACE.html');
INSERT INTO `packages_plain` VALUES ('252', 'libace-qtreactor-dev', 'optional', 'libdevel', '164', 'Debian ACE+TAO maintainers ', 'i386', 'ace', '5.6.3-5', 'pool/main/a/ace/libace-qtreactor-dev_5.6.3-5_i386.deb', '75672', 'ACE-GUI reactor integration for Qt development files', 'http://www.cs.wustl.edu/~schmidt/ACE.html');
INSERT INTO `packages_plain` VALUES ('253', 'libace-rmcast-5.6.3', 'optional', 'libs', '272', 'Debian ACE+TAO maintainers ', 'i386', 'ace', '5.6.3-5', 'pool/main/a/ace/libace-rmcast-5.6.3_5.6.3-5_i386.deb', '126266', 'ACE reliable multicast library', 'http://www.cs.wustl.edu/~schmidt/ACE.html');
INSERT INTO `packages_plain` VALUES ('254', 'libace-rmcast-dev', 'optional', 'libdevel', '228', 'Debian ACE+TAO maintainers ', 'i386', 'ace', '5.6.3-5', 'pool/main/a/ace/libace-rmcast-dev_5.6.3-5_i386.deb', '82472', 'ACE reliable multicast library development files', 'http://www.cs.wustl.edu/~schmidt/ACE.html');
INSERT INTO `packages_plain` VALUES ('255', 'libace-ssl-5.6.3', 'optional', 'libs', '228', 'Debian ACE+TAO maintainers ', 'i386', 'ace', '5.6.3-5', 'pool/main/a/ace/libace-ssl-5.6.3_5.6.3-5_i386.deb', '101120', 'ACE secure socket layer library', 'http://www.cs.wustl.edu/~schmidt/ACE.html');
INSERT INTO `packages_plain` VALUES ('256', 'libace-ssl-dev', 'optional', 'libdevel', '260', 'Debian ACE+TAO maintainers ', 'i386', 'ace', '5.6.3-5', 'pool/main/a/ace/libace-ssl-dev_5.6.3-5_i386.deb', '88334', 'ACE secure socket layer library development files', 'http://www.cs.wustl.edu/~schmidt/ACE.html');
INSERT INTO `packages_plain` VALUES ('257', 'libace-tkreactor-5.6.3', 'optional', 'libs', '204', 'Debian ACE+TAO maintainers ', 'i386', 'ace', '5.6.3-5', 'pool/main/a/ace/libace-tkreactor-5.6.3_5.6.3-5_i386.deb', '96608', 'ACE-GUI reactor integration for Tk', 'http://www.cs.wustl.edu/~schmidt/ACE.html');
INSERT INTO `packages_plain` VALUES ('258', 'libace-tkreactor-dev', 'optional', 'libdevel', '160', 'Debian ACE+TAO maintainers ', 'i386', 'ace', '5.6.3-5', 'pool/main/a/ace/libace-tkreactor-dev_5.6.3-5_i386.deb', '74300', 'ACE-GUI reactor integration for Tk development files', 'http://www.cs.wustl.edu/~schmidt/ACE.html');
INSERT INTO `packages_plain` VALUES ('259', 'libace-tmcast-5.6.3', 'optional', 'libs', '180', 'Debian ACE+TAO maintainers ', 'i386', 'ace', '5.6.3-5', 'pool/main/a/ace/libace-tmcast-5.6.3_5.6.3-5_i386.deb', '88258', 'ACE transactional multicast library', 'http://www.cs.wustl.edu/~schmidt/ACE.html');
INSERT INTO `packages_plain` VALUES ('260', 'libace-tmcast-dev', 'optional', 'libdevel', '200', 'Debian ACE+TAO maintainers ', 'i386', 'ace', '5.6.3-5', 'pool/main/a/ace/libace-tmcast-dev_5.6.3-5_i386.deb', '81234', 'ACE transactional multicast library development files', 'http://www.cs.wustl.edu/~schmidt/ACE.html');
INSERT INTO `packages_plain` VALUES ('261', 'libace-xtreactor-5.6.3', 'optional', 'libs', '208', 'Debian ACE+TAO maintainers ', 'i386', 'ace', '5.6.3-5', 'pool/main/a/ace/libace-xtreactor-5.6.3_5.6.3-5_i386.deb', '96794', 'ACE-GUI reactor integration for Xt', 'http://www.cs.wustl.edu/~schmidt/ACE.html');
INSERT INTO `packages_plain` VALUES ('262', 'libace-xtreactor-dev', 'optional', 'libdevel', '164', 'Debian ACE+TAO maintainers ', 'i386', 'ace', '5.6.3-5', 'pool/main/a/ace/libace-xtreactor-dev_5.6.3-5_i386.deb', '74376', 'ACE-GUI reactor integration for Xt development files', 'http://www.cs.wustl.edu/~schmidt/ACE.html');
INSERT INTO `packages_plain` VALUES ('263', 'libacexml-5.6.3', 'optional', 'libs', '376', 'Debian ACE+TAO maintainers ', 'i386', 'ace', '5.6.3-5', 'pool/main/a/ace/libacexml-5.6.3_5.6.3-5_i386.deb', '157640', 'ACE SAX based XML parsing library', 'http://www.cs.wustl.edu/~schmidt/ACE.html');
INSERT INTO `packages_plain` VALUES ('264', 'libacexml-dev', 'optional', 'libdevel', '560', 'Debian ACE+TAO maintainers ', 'i386', 'ace', '5.6.3-5', 'pool/main/a/ace/libacexml-dev_5.6.3-5_i386.deb', '127808', 'ACE SAX based XML parsing library development files', 'http://www.cs.wustl.edu/~schmidt/ACE.html');
INSERT INTO `packages_plain` VALUES ('265', 'libkokyu-5.6.3', 'optional', 'libs', '196', 'Debian ACE+TAO maintainers ', 'i386', 'ace', '5.6.3-5', 'pool/main/a/ace/libkokyu-5.6.3_5.6.3-5_i386.deb', '91536', 'ACE scheduling and dispatching library', 'http://www.cs.wustl.edu/~schmidt/ACE.html');
INSERT INTO `packages_plain` VALUES ('266', 'libkokyu-dev', 'optional', 'libdevel', '652', 'Debian ACE+TAO maintainers ', 'i386', 'ace', '5.6.3-5', 'pool/main/a/ace/libkokyu-dev_5.6.3-5_i386.deb', '305204', 'ACE scheduling and dispatching library development files', 'http://www.cs.wustl.edu/~schmidt/ACE.html');
INSERT INTO `packages_plain` VALUES ('267', 'libtao-1.6.3', 'optional', 'libs', '8316', 'Debian ACE+TAO maintainers ', 'i386', 'ace', '5.6.3-5', 'pool/main/a/ace/libtao-1.6.3_5.6.3-5_i386.deb', '2661244', 'ACE based CORBA ORB core libraries', 'http://www.cs.wustl.edu/~schmidt/ACE.html');
INSERT INTO `packages_plain` VALUES ('268', 'libtao-dev', 'optional', 'libdevel', '9748', 'Debian ACE+TAO maintainers ', 'i386', 'ace', '5.6.3-5', 'pool/main/a/ace/libtao-dev_5.6.3-5_i386.deb', '943018', 'ACE based CORBA ORB core libraries development files', 'http://www.cs.wustl.edu/~schmidt/ACE.html');
INSERT INTO `packages_plain` VALUES ('269', 'libtao-doc', 'optional', 'doc', '107388', 'Debian ACE+TAO maintainers ', 'all', 'ace', '5.6.3-5', 'pool/main/a/ace/libtao-doc_5.6.3-5_all.deb', '10201852', 'ACE based CORBA ORB core libraries documentation', 'http://www.cs.wustl.edu/~schmidt/ACE.html');
INSERT INTO `packages_plain` VALUES ('270', 'libtao-flresource-1.6.3', 'optional', 'libs', '152', 'Debian ACE+TAO maintainers ', 'i386', 'ace', '5.6.3-5', 'pool/main/a/ace/libtao-flresource-1.6.3_5.6.3-5_i386.deb', '75528', 'TAO-GUI reactor integration for Fl', 'http://www.cs.wustl.edu/~schmidt/ACE.html');
INSERT INTO `packages_plain` VALUES ('271', 'libtao-flresource-dev', 'optional', 'libdevel', '156', 'Debian ACE+TAO maintainers ', 'i386', 'ace', '5.6.3-5', 'pool/main/a/ace/libtao-flresource-dev_5.6.3-5_i386.deb', '73800', 'TAO-GUI reactor integration for Fl development files', 'http://www.cs.wustl.edu/~schmidt/ACE.html');
INSERT INTO `packages_plain` VALUES ('272', 'libtao-foxresource-1.6.3', 'optional', 'libs', '152', 'Debian ACE+TAO maintainers ', 'i386', 'ace', '5.6.3-5', 'pool/main/a/ace/libtao-foxresource-1.6.3_5.6.3-5_i386.deb', '75204', 'TAO-GUI reactor integration for FOX', 'http://www.cs.wustl.edu/~schmidt/ACE.html');
INSERT INTO `packages_plain` VALUES ('273', 'libtao-foxresource-dev', 'optional', 'libdevel', '156', 'Debian ACE+TAO maintainers ', 'i386', 'ace', '5.6.3-5', 'pool/main/a/ace/libtao-foxresource-dev_5.6.3-5_i386.deb', '73826', 'TAO-GUI reactor integration for FOX development files', 'http://www.cs.wustl.edu/~schmidt/ACE.html');
INSERT INTO `packages_plain` VALUES ('274', 'libtao-orbsvcs-1.6.3', 'optional', 'libs', '21556', 'Debian ACE+TAO maintainers ', 'i386', 'ace', '5.6.3-5', 'pool/main/a/ace/libtao-orbsvcs-1.6.3_5.6.3-5_i386.deb', '6254302', 'TAO CORBA services libraries', 'http://www.cs.wustl.edu/~schmidt/ACE.html');
INSERT INTO `packages_plain` VALUES ('275', 'libtao-orbsvcs-dev', 'optional', 'libdevel', '11792', 'Debian ACE+TAO maintainers ', 'i386', 'ace', '5.6.3-5', 'pool/main/a/ace/libtao-orbsvcs-dev_5.6.3-5_i386.deb', '1043016', 'TAO CORBA services development files', 'http://www.cs.wustl.edu/~schmidt/ACE.html');
INSERT INTO `packages_plain` VALUES ('276', 'libtao-qtresource-1.6.3', 'optional', 'libs', '152', 'Debian ACE+TAO maintainers ', 'i386', 'ace', '5.6.3-5', 'pool/main/a/ace/libtao-qtresource-1.6.3_5.6.3-5_i386.deb', '75754', 'TAO-GUI reactor integration for Qt', 'http://www.cs.wustl.edu/~schmidt/ACE.html');
INSERT INTO `packages_plain` VALUES ('277', 'libtao-qtresource-dev', 'optional', 'libdevel', '156', 'Debian ACE+TAO maintainers ', 'i386', 'ace', '5.6.3-5', 'pool/main/a/ace/libtao-qtresource-dev_5.6.3-5_i386.deb', '73860', 'TAO-GUI reactor integration for Qt development files', 'http://www.cs.wustl.edu/~schmidt/ACE.html');
INSERT INTO `packages_plain` VALUES ('278', 'libtao-tkresource-1.6.3', 'optional', 'libs', '152', 'Debian ACE+TAO maintainers ', 'i386', 'ace', '5.6.3-5', 'pool/main/a/ace/libtao-tkresource-1.6.3_5.6.3-5_i386.deb', '75550', 'TAO-GUI reactor integration for Tk development files', 'http://www.cs.wustl.edu/~schmidt/ACE.html');
INSERT INTO `packages_plain` VALUES ('279', 'libtao-tkresource-dev', 'optional', 'libdevel', '156', 'Debian ACE+TAO maintainers ', 'i386', 'ace', '5.6.3-5', 'pool/main/a/ace/libtao-tkresource-dev_5.6.3-5_i386.deb', '73822', 'TAO-GUI reactor integration for Tk development files', 'http://www.cs.wustl.edu/~schmidt/ACE.html');
INSERT INTO `packages_plain` VALUES ('280', 'libtao-xtresource-1.6.3', 'optional', 'libs', '152', 'Debian ACE+TAO maintainers ', 'i386', 'ace', '5.6.3-5', 'pool/main/a/ace/libtao-xtresource-1.6.3_5.6.3-5_i386.deb', '75830', 'TAO-GUI reactor integration for Xt', 'http://www.cs.wustl.edu/~schmidt/ACE.html');
INSERT INTO `packages_plain` VALUES ('281', 'libtao-xtresource-dev', 'optional', 'libdevel', '156', 'Debian ACE+TAO maintainers ', 'i386', 'ace', '5.6.3-5', 'pool/main/a/ace/libtao-xtresource-dev_5.6.3-5_i386.deb', '73842', 'TAO-GUI reactor integration for Xt development files', 'http://www.cs.wustl.edu/~schmidt/ACE.html');
INSERT INTO `packages_plain` VALUES ('282', 'mpc-ace', 'optional', 'devel', '2168', 'Debian ACE+TAO maintainers ', 'all', 'ace', '5.6.3-5', 'pool/main/a/ace/mpc-ace_5.6.3-5_all.deb', '320292', 'makefile, project and workspace creator', 'http://www.cs.wustl.edu/~schmidt/ACE.html');
INSERT INTO `packages_plain` VALUES ('283', 'tao-concurrency', 'optional', 'devel', '156', 'Debian ACE+TAO maintainers ', 'i386', 'ace', '5.6.3-5', 'pool/main/a/ace/tao-concurrency_5.6.3-5_i386.deb', '81642', 'TAO concurrency service', 'http://www.cs.wustl.edu/~schmidt/ACE.html');
INSERT INTO `packages_plain` VALUES ('284', 'tao-event', 'optional', 'devel', '144', 'Debian ACE+TAO maintainers ', 'i386', 'ace', '5.6.3-5', 'pool/main/a/ace/tao-event_5.6.3-5_i386.deb', '76556', 'TAO event service', 'http://www.cs.wustl.edu/~schmidt/ACE.html');
INSERT INTO `packages_plain` VALUES ('285', 'tao-ft', 'optional', 'devel', '356', 'Debian ACE+TAO maintainers ', 'i386', 'ace', '5.6.3-5', 'pool/main/a/ace/tao-ft_5.6.3-5_i386.deb', '155760', 'TAO fault tolerant services', 'http://www.cs.wustl.edu/~schmidt/ACE.html');
INSERT INTO `packages_plain` VALUES ('286', 'tao-ftrtevent', 'optional', 'devel', '204', 'Debian ACE+TAO maintainers ', 'i386', 'ace', '5.6.3-5', 'pool/main/a/ace/tao-ftrtevent_5.6.3-5_i386.deb', '99664', 'TAO fault-tolerant real-time event service', 'http://www.cs.wustl.edu/~schmidt/ACE.html');
INSERT INTO `packages_plain` VALUES ('287', 'tao-idl', 'optional', 'devel', '2556', 'Debian ACE+TAO maintainers ', 'i386', 'ace', '5.6.3-5', 'pool/main/a/ace/tao-idl_5.6.3-5_i386.deb', '841982', 'TAO IDL to C++ compiler', 'http://www.cs.wustl.edu/~schmidt/ACE.html');
INSERT INTO `packages_plain` VALUES ('288', 'tao-ifr', 'optional', 'devel', '868', 'Debian ACE+TAO maintainers ', 'i386', 'ace', '5.6.3-5', 'pool/main/a/ace/tao-ifr_5.6.3-5_i386.deb', '338566', 'TAO interface repository', 'http://www.cs.wustl.edu/~schmidt/ACE.html');
INSERT INTO `packages_plain` VALUES ('289', 'tao-imr', 'optional', 'devel', '560', 'Debian ACE+TAO maintainers ', 'i386', 'ace', '5.6.3-5', 'pool/main/a/ace/tao-imr_5.6.3-5_i386.deb', '245860', 'TAO implementation repository', 'http://www.cs.wustl.edu/~schmidt/ACE.html');
INSERT INTO `packages_plain` VALUES ('290', 'tao-lifecycle', 'optional', 'devel', '176', 'Debian ACE+TAO maintainers ', 'i386', 'ace', '5.6.3-5', 'pool/main/a/ace/tao-lifecycle_5.6.3-5_i386.deb', '89392', 'TAO lifecycle service', 'http://www.cs.wustl.edu/~schmidt/ACE.html');
INSERT INTO `packages_plain` VALUES ('291', 'tao-load', 'optional', 'devel', '192', 'Debian ACE+TAO maintainers ', 'i386', 'ace', '5.6.3-5', 'pool/main/a/ace/tao-load_5.6.3-5_i386.deb', '95090', 'TAO load balancing service', 'http://www.cs.wustl.edu/~schmidt/ACE.html');
INSERT INTO `packages_plain` VALUES ('292', 'tao-log', 'optional', 'devel', '256', 'Debian ACE+TAO maintainers ', 'i386', 'ace', '5.6.3-5', 'pool/main/a/ace/tao-log_5.6.3-5_i386.deb', '101034', 'TAO telecom log services', 'http://www.cs.wustl.edu/~schmidt/ACE.html');
INSERT INTO `packages_plain` VALUES ('293', 'tao-naming', 'optional', 'devel', '152', 'Debian ACE+TAO maintainers ', 'i386', 'ace', '5.6.3-5', 'pool/main/a/ace/tao-naming_5.6.3-5_i386.deb', '82560', 'TAO naming service', 'http://www.cs.wustl.edu/~schmidt/ACE.html');
INSERT INTO `packages_plain` VALUES ('294', 'tao-notify', 'optional', 'devel', '164', 'Debian ACE+TAO maintainers ', 'i386', 'ace', '5.6.3-5', 'pool/main/a/ace/tao-notify_5.6.3-5_i386.deb', '87412', 'TAO notification service', 'http://www.cs.wustl.edu/~schmidt/ACE.html');
INSERT INTO `packages_plain` VALUES ('295', 'tao-rtevent', 'optional', 'devel', '164', 'Debian ACE+TAO maintainers ', 'i386', 'ace', '5.6.3-5', 'pool/main/a/ace/tao-rtevent_5.6.3-5_i386.deb', '84964', 'TAO real-time event service', 'http://www.cs.wustl.edu/~schmidt/ACE.html');
INSERT INTO `packages_plain` VALUES ('296', 'tao-scheduling', 'optional', 'devel', '236', 'Debian ACE+TAO maintainers ', 'i386', 'ace', '5.6.3-5', 'pool/main/a/ace/tao-scheduling_5.6.3-5_i386.deb', '114600', 'TAO scheduling service', 'http://www.cs.wustl.edu/~schmidt/ACE.html');
INSERT INTO `packages_plain` VALUES ('297', 'tao-time', 'optional', 'devel', '184', 'Debian ACE+TAO maintainers ', 'i386', 'ace', '5.6.3-5', 'pool/main/a/ace/tao-time_5.6.3-5_i386.deb', '91090', 'TAO time service', 'http://www.cs.wustl.edu/~schmidt/ACE.html');
INSERT INTO `packages_plain` VALUES ('298', 'tao-trading', 'optional', 'devel', '148', 'Debian ACE+TAO maintainers ', 'i386', 'ace', '5.6.3-5', 'pool/main/a/ace/tao-trading_5.6.3-5_i386.deb', '77286', 'TAO trading service', 'http://www.cs.wustl.edu/~schmidt/ACE.html');
INSERT INTO `packages_plain` VALUES ('299', 'tao-utils', 'optional', 'devel', '248', 'Debian ACE+TAO maintainers ', 'i386', 'ace', '5.6.3-5', 'pool/main/a/ace/tao-utils_5.6.3-5_i386.deb', '113794', 'TAO naming service and IOR utilities', 'http://www.cs.wustl.edu/~schmidt/ACE.html');
INSERT INTO `packages_plain` VALUES ('300', 'r-cran-acepack', 'optional', 'gnu-r', '128', 'Dirk Eddelbuettel ', 'i386', 'acepack (1.3.2.2-2)', '1.3.2.2-2+b1', 'pool/main/a/acepack/r-cran-acepack_1.3.2.2-2+b1_i386.deb', '29504', 'GNU R package for regression transformations', '');
INSERT INTO `packages_plain` VALUES ('301', 'acerhk-source', 'optional', 'kernel', '80', 'Adam CГѓВ©cile (Le_Vert) ', 'all', 'acerhk', '0.5.35-8', 'pool/main/a/acerhk/acerhk-source_0.5.35-8_all.deb', '39444', 'Source for the acerhk driver', 'http://www.cakey.de/acerhk/');
INSERT INTO `packages_plain` VALUES ('302', 'acfax', 'extra', 'hamradio', '136', 'Debian Hamradio Maintainers ', 'i386', '', '981011-14.1', 'pool/main/a/acfax/acfax_981011-14.1_i386.deb', '35800', 'Receive faxes using your radio and sound card', '');
INSERT INTO `packages_plain` VALUES ('303', 'acheck-rules-fr', 'optional', 'text', '80', 'Nicolas Bertolissio ', 'all', '', '0.6', 'pool/main/a/acheck-rules-fr/acheck-rules-fr_0.6_all.deb', '7314', 'French rules for acheck', '');
INSERT INTO `packages_plain` VALUES ('304', 'acheck-rules', 'optional', 'text', '104', 'Nicolas Bertolissio ', 'all', '', '0.3.1', 'pool/main/a/acheck-rules/acheck-rules_0.3.1_all.deb', '13618', 'Basic rules for acheck', '');
INSERT INTO `packages_plain` VALUES ('305', 'acheck', 'optional', 'text', '192', 'Nicolas Bertolissio ', 'all', '', '0.5.1', 'pool/main/a/acheck/acheck_0.5.1_all.deb', '35790', 'Check common localisation mistakes', '');
INSERT INTO `packages_plain` VALUES ('306', 'achilles', 'optional', 'science', '160', 'Manfred Lichtenstern ', 'i386', '', '2-8', 'pool/main/a/achilles/achilles_2-8_i386.deb', '38252', 'An artificial life and evolution simulator', '');
INSERT INTO `packages_plain` VALUES ('307', 'ack-grep', 'optional', 'utils', '216', 'Ryan Niebur ', 'all', '', '1.90-2', 'pool/main/a/ack-grep/ack-grep_1.90-2_all.deb', '66982', 'grep-like program specifically for large source trees', 'http://search.cpan.org/dist/ack/');
INSERT INTO `packages_plain` VALUES ('308', 'ack', 'extra', 'text', '92', 'Masayuki Hatta (mhatta) ', 'i386', '', '1.39-12', 'pool/main/a/ack/ack_1.39-12_i386.deb', '17770', 'Kanji code converter', '');
INSERT INTO `packages_plain` VALUES ('309', 'acl', 'optional', 'utils', '268', 'Nathan Scott ', 'i386', '', '2.2.48-1', 'pool/main/a/acl/acl_2.2.48-1_i386.deb', '60548', 'Access control list utilities', 'http://savannah.nongnu.org/projects/acl/');
INSERT INTO `packages_plain` VALUES ('310', 'libacl1-dev', 'extra', 'libdevel', '296', 'Nathan Scott ', 'i386', 'acl', '2.2.48-1', 'pool/main/a/acl/libacl1-dev_2.2.48-1_i386.deb', '78788', 'Access control list static libraries and headers', 'http://savannah.nongnu.org/projects/acl/');
INSERT INTO `packages_plain` VALUES ('311', 'libacl1', 'required', 'libs', '76', 'Nathan Scott ', 'i386', 'acl', '2.2.48-1', 'pool/main/a/acl/libacl1_2.2.48-1_i386.deb', '17724', 'Access control list shared library', 'http://savannah.nongnu.org/projects/acl/');
INSERT INTO `packages_plain` VALUES ('312', 'acl2-books-certs', 'optional', 'math', '27724', 'Camm Maguire ', 'all', 'acl2', '3.4-2', 'pool/main/a/acl2/acl2-books-certs_3.4-2_all.deb', '1295318', 'A Computational Logic for Applicative Common Lisp: library certificates', '');
INSERT INTO `packages_plain` VALUES ('313', 'acl2-books-source', 'optional', 'math', '20560', 'Camm Maguire ', 'all', 'acl2', '3.4-2', 'pool/main/a/acl2/acl2-books-source_3.4-2_all.deb', '2973976', 'A Computational Logic for Applicative Common Lisp: library sources', '');
INSERT INTO `packages_plain` VALUES ('314', 'acl2-books', 'optional', 'math', '66960', 'Camm Maguire ', 'i386', 'acl2', '3.4-2', 'pool/main/a/acl2/acl2-books_3.4-2_i386.deb', '21475906', 'A Computational Logic for Applicative Common Lisp: compiled libraries', '');
INSERT INTO `packages_plain` VALUES ('315', 'acl2-doc', 'optional', 'doc', '9020', 'Camm Maguire ', 'all', 'acl2', '3.4-2', 'pool/main/a/acl2/acl2-doc_3.4-2_all.deb', '2400658', 'A Computational Logic for Applicative Common Lisp: documentation', '');
INSERT INTO `packages_plain` VALUES ('316', 'acl2-emacs', 'optional', 'math', '304', 'Camm Maguire ', 'all', 'acl2', '3.4-2', 'pool/main/a/acl2/acl2-emacs_3.4-2_all.deb', '56260', 'A Computational Logic for Applicative Common Lisp: emacs interface', '');
INSERT INTO `packages_plain` VALUES ('317', 'acl2-infix-source', 'optional', 'math', '376', 'Camm Maguire ', 'all', 'acl2', '3.4-2', 'pool/main/a/acl2/acl2-infix-source_3.4-2_all.deb', '88730', 'A Computational Logic for Applicative Common Lisp: infix source', '');
INSERT INTO `packages_plain` VALUES ('318', 'acl2-infix', 'optional', 'math', '1180', 'Camm Maguire ', 'i386', 'acl2', '3.4-2', 'pool/main/a/acl2/acl2-infix_3.4-2_i386.deb', '399634', 'A Computational Logic for Applicative Common Lisp: infix interface', '');
INSERT INTO `packages_plain` VALUES ('319', 'acl2-source', 'optional', 'math', '10160', 'Camm Maguire ', 'all', 'acl2', '3.4-2', 'pool/main/a/acl2/acl2-source_3.4-2_all.deb', '2610826', 'A Computational Logic for Applicative Common Lisp: source files', '');
INSERT INTO `packages_plain` VALUES ('320', 'acl2', 'optional', 'math', '64332', 'Camm Maguire ', 'i386', '', '3.4-2', 'pool/main/a/acl2/acl2_3.4-2_i386.deb', '19379656', 'A Computational Logic for Applicative Common Lisp: main binary', '');
INSERT INTO `packages_plain` VALUES ('321', 'aclock.app', 'optional', 'gnustep', '224', 'GГѓВјrkan SengГѓВјn ', 'i386', 'aclock.app (0.2.3-3)', '0.2.3-3+b2', 'pool/main/a/aclock.app/aclock.app_0.2.3-3+b2_i386.deb', '28316', 'Analog dockapp clock for GNUstep', '');
INSERT INTO `packages_plain` VALUES ('322', 'acm', 'optional', 'games', '1368', 'Phil Brooke ', 'i386', '', '5.0-25', 'pool/main/a/acm/acm_5.0-25_i386.deb', '752596', 'A multi-player aerial combat simulation', '');
INSERT INTO `packages_plain` VALUES ('323', 'acm4', 'optional', 'games', '3736', 'Phil Brooke ', 'i386', '', '4.7-19', 'pool/main/a/acm4/acm4_4.7-19_i386.deb', '896084', 'multi-player aerial combat simulation', '');
INSERT INTO `packages_plain` VALUES ('324', 'aconnectgui', 'optional', 'sound', '88', 'Paul Brossier ', 'i386', '', '0.9.0rc2-1-9', 'pool/main/a/aconnectgui/aconnectgui_0.9.0rc2-1-9_i386.deb', '26154', 'graphical ALSA sequencer connection manager', '');
INSERT INTO `packages_plain` VALUES ('325', 'acorn-fdisk', 'optional', 'admin', '108', 'Philip Blundell ', 'i386', '', '3.0.6-6.2', 'pool/main/a/acorn-fdisk/acorn-fdisk_3.0.6-6.2_i386.deb', '28450', 'Partition editor for Acorn/RISC OS machines', '');
INSERT INTO `packages_plain` VALUES ('326', 'acovea-results', 'optional', 'doc', '272', 'Al Stone ', 'all', '', '20040329-1', 'pool/main/a/acovea-results/acovea-results_20040329-1_all.deb', '203792', 'results captured by using acovea', '');
INSERT INTO `packages_plain` VALUES ('327', 'acovea', 'optional', 'devel', '264', 'Al Stone ', 'i386', '', '5.1.1-2', 'pool/main/a/acovea/acovea_5.1.1-2_i386.deb', '104138', 'analysis of compiler options via evolutionary algorithms', '');
INSERT INTO `packages_plain` VALUES ('328', 'libacovea-5.1-5', 'optional', 'libs', '532', 'Al Stone ', 'i386', 'acovea', '5.1.1-2', 'pool/main/a/acovea/libacovea-5.1-5_5.1.1-2_i386.deb', '104286', 'library for analyzing compiler options via evolutionary algorithms', '');
INSERT INTO `packages_plain` VALUES ('329', 'libacovea-dev', 'optional', 'devel', '312', 'Al Stone ', 'i386', 'acovea', '5.1.1-2', 'pool/main/a/acovea/libacovea-dev_5.1.1-2_i386.deb', '78742', 'library for analyzing compiler options via evolutionary algorithms', '');
INSERT INTO `packages_plain` VALUES ('330', 'acpi-support-base', 'optional', 'admin', '80', 'Debian Acpi Team ', 'all', 'acpi-support', '0.123-1', 'pool/main/a/acpi-support/acpi-support-base_0.123-1_all.deb', '14752', 'scripts for handling base ACPI events such as the power button', '');
INSERT INTO `packages_plain` VALUES ('331', 'acpi-support', 'optional', 'admin', '836', 'Debian Acpi Team ', 'i386', '', '0.123-1', 'pool/main/a/acpi-support/acpi-support_0.123-1_i386.deb', '49236', 'scripts for handling many ACPI events', '');
INSERT INTO `packages_plain` VALUES ('332', 'acpi', 'optional', 'utils', '88', 'Debian Acpi Team ', 'i386', '', '1.4-2', 'pool/main/a/acpi/acpi_1.4-2_i386.deb', '15406', 'displays information on ACPI devices', '');
INSERT INTO `packages_plain` VALUES ('333', 'iasl', 'optional', 'devel', '676', 'Mattia Dongili ', 'i386', 'acpica-unix', '20061109-0.1', 'pool/main/a/acpica-unix/iasl_20061109-0.1_i386.deb', '367092', 'Intel ASL compiler/decompiler', '');
INSERT INTO `packages_plain` VALUES ('334', 'acpid', 'optional', 'admin', '196', 'Debian Acpi Team ', 'i386', '', '1.0.10-3', 'pool/main/a/acpid/acpid_1.0.10-3_i386.deb', '45234', 'Advanced Configuration and Power Interface event daemon', 'http://acpid.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('335', 'acpidump', 'optional', 'admin', '40', 'Mattia Dongili ', 'i386', '', '20071116-1', 'pool/main/a/acpidump/acpidump_20071116-1_i386.deb', '14408', 'utilities to dump system\'s ACPI tables to an ASCII file', '');
INSERT INTO `packages_plain` VALUES ('336', 'acpitail', 'optional', 'utils', '64', 'Debian Acpi Team ', 'i386', '', '0.1-2', 'pool/main/a/acpitail/acpitail_0.1-2_i386.deb', '7518', 'Show ACPI information in a tail-like style', 'http://www.vanheusden.com/acpitail/');
INSERT INTO `packages_plain` VALUES ('337', 'acpitool-dbg', 'extra', 'debug', '408', 'Debian Acpi Team ', 'i386', 'acpitool', '0.5-7', 'pool/main/a/acpitool/acpitool-dbg_0.5-7_i386.deb', '141834', 'command line ACPI client (debug)', 'http://freeunix.dyndns.org:8088/site2/acpitool.shtml');
INSERT INTO `packages_plain` VALUES ('338', 'acpitool', 'optional', 'utils', '168', 'Debian Acpi Team ', 'i386', '', '0.5-7', 'pool/main/a/acpitool/acpitool_0.5-7_i386.deb', '47740', 'command line ACPI client', 'http://freeunix.dyndns.org:8088/site2/acpitool.shtml');
INSERT INTO `packages_plain` VALUES ('339', 'libacr38u', 'extra', 'libs', '108', 'Laurent Bigonville ', 'i386', 'acr38', '1.7.10-1', 'pool/main/a/acr38/libacr38u_1.7.10-1_i386.deb', '18040', 'PC/SC driver for the ACR38U smart card reader', 'http://www.acs.com.hk/');
INSERT INTO `packages_plain` VALUES ('340', 'libacr38ucontrol-dev', 'extra', 'libdevel', '72', 'Laurent Bigonville ', 'i386', 'acr38', '1.7.10-1', 'pool/main/a/acr38/libacr38ucontrol-dev_1.7.10-1_i386.deb', '6398', 'Library for operational mode for ACR38U smartcard reader dev files', 'http://www.acs.com.hk/');
INSERT INTO `packages_plain` VALUES ('341', 'libacr38ucontrol0', 'extra', 'libs', '68', 'Laurent Bigonville ', 'i386', 'acr38', '1.7.10-1', 'pool/main/a/acr38/libacr38ucontrol0_1.7.10-1_i386.deb', '6288', 'Library for operational mode for ACR38U smartcard reader', 'http://www.acs.com.hk/');
INSERT INTO `packages_plain` VALUES ('342', 'libactiveldap-ruby-doc', 'optional', 'doc', '42996', 'Marc DequГѓВЁnes (Duck) ', 'all', 'activeldap', '1.0.9-1', 'pool/main/a/activeldap/libactiveldap-ruby-doc_1.0.9-1_all.deb', '34531542', 'an object-oriented interface to LDAP for Ruby', 'http://rubyforge.org/projects/ruby-activeldap');
INSERT INTO `packages_plain` VALUES ('343', 'libactiveldap-ruby1.8', 'optional', 'ruby', '496', 'Marc DequГѓВЁnes (Duck) ', 'all', 'activeldap', '1.0.9-1', 'pool/main/a/activeldap/libactiveldap-ruby1.8_1.0.9-1_all.deb', '84506', 'an object-oriented interface to LDAP for Ruby', 'http://rubyforge.org/projects/ruby-activeldap');
INSERT INTO `packages_plain` VALUES ('344', 'libactiveldap-ruby', 'optional', 'ruby', '52', 'Marc DequГѓВЁnes (Duck) ', 'all', 'activeldap', '1.0.9-1', 'pool/main/a/activeldap/libactiveldap-ruby_1.0.9-1_all.deb', '15822', 'an object-oriented interface to LDAP for Ruby', 'http://rubyforge.org/projects/ruby-activeldap');
INSERT INTO `packages_plain` VALUES ('345', 'ada-mode', 'optional', 'editors', '604', 'Debian QA Group ', 'all', '', '3.6-3', 'pool/main/a/ada-mode/ada-mode_3.6-3_all.deb', '128818', 'Ada mode for GNU Emacs and XEmacs', 'http://stephe-leake.org/emacs/ada-mode/emacs-ada-mode.html');
INSERT INTO `packages_plain` VALUES ('346', 'ada-reference-manual', 'optional', 'doc', '16248', 'Florian Weimer ', 'all', '', '20021112web-3', 'pool/main/a/ada-reference-manual/ada-reference-manual_20021112web-3_all.deb', '2735014', 'The standard describing the Ada 95 language', '');
INSERT INTO `packages_plain` VALUES ('347', 'adacgi', 'optional', 'web', '376', 'Phil Brooke ', 'i386', '', '1.6-11', 'pool/main/a/adacgi/adacgi_1.6-11_i386.deb', '94806', 'Ada CGI interface', '');
INSERT INTO `packages_plain` VALUES ('348', 'adacontrol', 'optional', 'devel', '4660', 'Ludovic Brenta ', 'i386', '', '1.9r4-3', 'pool/main/a/adacontrol/adacontrol_1.9r4-3_i386.deb', '1979216', 'An Ada rules controller', '');
INSERT INTO `packages_plain` VALUES ('349', 'adanaxisgpl-data', 'optional', 'games', '27448', 'Debian Games Team ', 'all', 'adanaxisgpl', '1.2.5.dfsg.1-2', 'pool/main/a/adanaxisgpl/adanaxisgpl-data_1.2.5.dfsg.1-2_all.deb', '18353778', 'Action game in four spatial dimensions', 'http://www.mushware.com/');
INSERT INTO `packages_plain` VALUES ('350', 'adanaxisgpl', 'optional', 'games', '3408', 'Debian Games Team ', 'i386', '', '1.2.5.dfsg.1-2', 'pool/main/a/adanaxisgpl/adanaxisgpl_1.2.5.dfsg.1-2_i386.deb', '1383178', 'Action game in four spatial dimensions', 'http://www.mushware.com/');
INSERT INTO `packages_plain` VALUES ('351', 'r-cran-adapt', 'optional', 'gnu-r', '164', 'Dirk Eddelbuettel ', 'i386', 'adapt', '1.0-4-3', 'pool/main/a/adapt/r-cran-adapt_1.0-4-3_i386.deb', '18992', 'GNU R package providing multidimentional integration', '');
INSERT INTO `packages_plain` VALUES ('352', 'libadasockets-dev', 'extra', 'libdevel', '784', 'Phil Brooke ', 'i386', 'adasockets', '1.8.6-2', 'pool/main/a/adasockets/libadasockets-dev_1.8.6-2_i386.deb', '389928', 'bindings for socket services in Ada', '');
INSERT INTO `packages_plain` VALUES ('353', 'libadasockets1', 'extra', 'libs', '164', 'Phil Brooke ', 'i386', 'adasockets', '1.8.6-2', 'pool/main/a/adasockets/libadasockets1_1.8.6-2_i386.deb', '47224', 'bindings for socket services in Ada', '');
INSERT INTO `packages_plain` VALUES ('354', 'adblock-plus', 'optional', 'web', '60', 'Dmitry E. Oboukhov ', 'all', '', '1.1.1-2', 'pool/main/a/adblock-plus/adblock-plus_1.1.1-2_all.deb', '13402', 'transitional dummy package', 'http://adblockplus.org/');
INSERT INTO `packages_plain` VALUES ('355', 'xul-ext-adblock-plus', 'optional', 'web', '1420', 'Dmitry E. Oboukhov ', 'all', 'adblock-plus', '1.1.1-2', 'pool/main/a/adblock-plus/xul-ext-adblock-plus_1.1.1-2_all.deb', '310478', 'Advertisement blocking extension for web browsers', 'http://adblockplus.org/');
INSERT INTO `packages_plain` VALUES ('356', 'addresses-goodies-for-gnustep', 'optional', 'mail', '160', 'Eric Heintzmann ', 'i386', 'addresses-for-gnustep (0.4.7-1)', '0.4.7-1+b2', 'pool/main/a/addresses-for-gnustep/addresses-goodies-for-gnustep_0.4.7-1+b2_i386.deb', '32980', 'Personal Address Manager for GNUstep (Goodies)', '');
INSERT INTO `packages_plain` VALUES ('357', 'addresses.framework', 'optional', 'gnustep', '12', 'Eric Heintzmann ', 'all', 'addresses-for-gnustep', '0.4.7-1', 'pool/main/a/addresses-for-gnustep/addresses.framework_0.4.7-1_all.deb', '8378', 'Database API backend framework for GNUstep', '');
INSERT INTO `packages_plain` VALUES ('358', 'addressmanager.app', 'optional', 'gnustep', '564', 'Eric Heintzmann ', 'i386', 'addresses-for-gnustep (0.4.7-1)', '0.4.7-1+b2', 'pool/main/a/addresses-for-gnustep/addressmanager.app_0.4.7-1+b2_i386.deb', '101602', 'Personal Address Manager for GNUstep', '');
INSERT INTO `packages_plain` VALUES ('359', 'addressview.framework', 'optional', 'gnustep', '12', 'Eric Heintzmann ', 'all', 'addresses-for-gnustep', '0.4.7-1', 'pool/main/a/addresses-for-gnustep/addressview.framework_0.4.7-1_all.deb', '8368', 'Address display/edit framework for GNUstep', '');
INSERT INTO `packages_plain` VALUES ('360', 'libaddresses-dev', 'optional', 'libdevel', '188', 'Eric Heintzmann ', 'i386', 'addresses-for-gnustep (0.4.7-1)', '0.4.7-1+b2', 'pool/main/a/addresses-for-gnustep/libaddresses-dev_0.4.7-1+b2_i386.deb', '16730', 'Database API backend framework for GNUstep (development files)', '');
INSERT INTO `packages_plain` VALUES ('361', 'libaddresses0', 'optional', 'libs', '372', 'Eric Heintzmann ', 'i386', 'addresses-for-gnustep (0.4.7-1)', '0.4.7-1+b2', 'pool/main/a/addresses-for-gnustep/libaddresses0_0.4.7-1+b2_i386.deb', '70108', 'Database API backend framework for GNUstep (library files)', '');
INSERT INTO `packages_plain` VALUES ('362', 'libaddressview-dev', 'optional', 'libdevel', '132', 'Eric Heintzmann ', 'i386', 'addresses-for-gnustep (0.4.7-1)', '0.4.7-1+b2', 'pool/main/a/addresses-for-gnustep/libaddressview-dev_0.4.7-1+b2_i386.deb', '12686', 'Address display/edit framework for GNUstep (development files)', '');
INSERT INTO `packages_plain` VALUES ('363', 'libaddressview0', 'optional', 'libs', '424', 'Eric Heintzmann ', 'i386', 'addresses-for-gnustep (0.4.7-1)', '0.4.7-1+b2', 'pool/main/a/addresses-for-gnustep/libaddressview0_0.4.7-1+b2_i386.deb', '72816', 'Address display/edit framework for GNUstep (library files)', '');
INSERT INTO `packages_plain` VALUES ('364', 'adduser', 'important', 'admin', '880', 'Debian Adduser Developers ', 'all', '', '3.111', 'pool/main/a/adduser/adduser_3.111_all.deb', '156872', 'add and remove users and groups', 'http://alioth.debian.org/projects/adduser/');
INSERT INTO `packages_plain` VALUES ('365', 'adept', 'optional', 'kde', '1308', 'Petr Rockai ', 'i386', '', '3.0~beta7.2', 'pool/main/a/adept/adept_3.0~beta7.2_i386.deb', '371506', 'package management suite for KDE', '');
INSERT INTO `packages_plain` VALUES ('366', 'adesklets', 'optional', 'x11', '620', 'Debian QA Group ', 'i386', '', '0.6.1-5', 'pool/main/a/adesklets/adesklets_0.6.1-5_i386.deb', '221896', 'interactive Imlib2 console for the X Window System', 'http://adesklets.sourceforge.net');
INSERT INTO `packages_plain` VALUES ('367', 'adjtimex', 'optional', 'admin', '168', 'James R. Van Zandt ', 'i386', '', '1.28-1', 'pool/main/a/adjtimex/adjtimex_1.28-1_i386.deb', '55818', 'kernel time variables configuration utility', '');
INSERT INTO `packages_plain` VALUES ('368', 'admesh', 'optional', 'math', '112', 'VГѓВ­ctor PГѓВ©rez Pereira ', 'i386', '', '0.95-7', 'pool/main/a/admesh/admesh_0.95-7_i386.deb', '32534', 'a tool for processing triangulated solid meshes', '');
INSERT INTO `packages_plain` VALUES ('369', 'adns-tools', 'optional', 'net', '124', 'Robert S. Edmonds ', 'i386', 'adns', '1.4-2', 'pool/main/a/adns/adns-tools_1.4-2_i386.deb', '41252', 'Asynchronous-capable DNS client library and utilities', 'http://www.chiark.greenend.org.uk/~ian/adns/');
INSERT INTO `packages_plain` VALUES ('370', 'libadns1-dev', 'optional', 'libdevel', '204', 'Robert S. Edmonds ', 'i386', 'adns', '1.4-2', 'pool/main/a/adns/libadns1-dev_1.4-2_i386.deb', '73584', 'Asynchronous-capable DNS client library and utilities', 'http://www.chiark.greenend.org.uk/~ian/adns/');
INSERT INTO `packages_plain` VALUES ('371', 'libadns1', 'optional', 'libs', '156', 'Robert S. Edmonds ', 'i386', 'adns', '1.4-2', 'pool/main/a/adns/libadns1_1.4-2_i386.deb', '58400', 'Asynchronous-capable DNS client library and utilities', 'http://www.chiark.greenend.org.uk/~ian/adns/');
INSERT INTO `packages_plain` VALUES ('372', 'libadolc-dev', 'optional', 'libdevel', '1536', 'Barak A. Pearlmutter ', 'i386', 'adolc', '1.10.2-1', 'pool/main/a/adolc/libadolc-dev_1.10.2-1_i386.deb', '826088', 'ADOLC development libs and headers', '');
INSERT INTO `packages_plain` VALUES ('373', 'libadolc-examples', 'optional', 'doc', '980', 'Barak A. Pearlmutter ', 'i386', 'adolc', '1.10.2-1', 'pool/main/a/adolc/libadolc-examples_1.10.2-1_i386.deb', '280866', 'ADOLC example program binaries', '');
INSERT INTO `packages_plain` VALUES ('374', 'libadolc0', 'optional', 'libs', '532', 'Barak A. Pearlmutter ', 'i386', 'adolc', '1.10.2-1', 'pool/main/a/adolc/libadolc0_1.10.2-1_i386.deb', '203546', 'ADOLC automatic differentiation system, runtime libs', '');
INSERT INTO `packages_plain` VALUES ('375', 'adonthell-data', 'optional', 'games', '11760', 'Debian Games Team ', 'all', '', '0.3.4.cvs.20080529-1', 'pool/main/a/adonthell-data/adonthell-data_0.3.4.cvs.20080529-1_all.deb', '9989464', 'Data files needed by Adonthell', 'http://adonthell.linuxgames.com/');
INSERT INTO `packages_plain` VALUES ('376', 'adonthell', 'optional', 'games', '1000', 'Debian Games Team ', 'i386', '', '0.3.5-2', 'pool/main/a/adonthell/adonthell_0.3.5-2_i386.deb', '268974', 'A 2D graphical roleplaying game', 'http://adonthell.linuxgames.com/');
INSERT INTO `packages_plain` VALUES ('377', 'adplay', 'optional', 'sound', '68', 'GГѓВјrkan SengГѓВјn ', 'i386', 'adplay (1.6-1)', '1.6-1+b1', 'pool/main/a/adplay/adplay_1.6-1+b1_i386.deb', '23782', 'console-based OPL2 audio player', '');
INSERT INTO `packages_plain` VALUES ('378', 'adplug-utils', 'optional', 'utils', '76', 'Debian QA Group ', 'i386', 'adplug', '2.0.1.dfsg-1', 'pool/main/a/adplug/adplug-utils_2.0.1.dfsg-1_i386.deb', '26078', 'free AdLib sound library (utils)', 'http://adplug.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('379', 'libadplug-dev', 'optional', 'libdevel', '948', 'Debian QA Group ', 'i386', 'adplug', '2.0.1.dfsg-1', 'pool/main/a/adplug/libadplug-dev_2.0.1.dfsg-1_i386.deb', '233696', 'free AdLib sound library (development)', 'http://adplug.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('380', 'libadplug0c2a', 'optional', 'libs', '448', 'Debian QA Group ', 'i386', 'adplug', '2.0.1.dfsg-1', 'pool/main/a/adplug/libadplug0c2a_2.0.1.dfsg-1_i386.deb', '181160', 'free AdLib sound library', 'http://adplug.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('381', 'adtool', 'optional', 'admin', '96', 'Jonathan Wiltshire ', 'i386', '', '1.3.3-1', 'pool/main/a/adtool/adtool_1.3.3-1_i386.deb', '15518', 'command line utility for Active Directory administration', 'http://www.gp2x.org/adtool/');
INSERT INTO `packages_plain` VALUES ('382', 'adun.app', 'optional', 'gnustep', '6412', 'Debian-Med Packaging Team ', 'i386', 'adun.app (0.8.2-1)', '0.8.2-1+b2', 'pool/main/a/adun.app/adun.app_0.8.2-1+b2_i386.deb', '1262660', 'Molecular Simulator for GNUstep', 'http://diana.imim.es/Adun');
INSERT INTO `packages_plain` VALUES ('383', 'advancecomp', 'optional', 'utils', '708', 'Piotr Ozarowski ', 'i386', '', '1.15-1', 'pool/main/a/advancecomp/advancecomp_1.15-1_i386.deb', '325756', 'collection of recompression utilities', '');
INSERT INTO `packages_plain` VALUES ('384', 'python-advas', 'optional', 'python', '1504', 'Patrick Winnertz ', 'all', 'advas', '0.2.3-2', 'pool/main/a/advas/python-advas_0.2.3-2_all.deb', '104530', 'algorithms for high-level search and information retrieval', '');
INSERT INTO `packages_plain` VALUES ('385', 'advi-examples', 'optional', 'tex', '16780', 'Debian OCaml Maintainers ', 'all', 'advi', '1.6.0-15', 'pool/main/a/advi/advi-examples_1.6.0-15_all.deb', '3824516', 'example presentations for Active-DVI (advi)', 'http://pauillac.inria.fr/advi/');
INSERT INTO `packages_plain` VALUES ('386', 'advi', 'optional', 'tex', '2536', 'Debian OCaml Maintainers ', 'i386', '', '1.6.0-15', 'pool/main/a/advi/advi_1.6.0-15_i386.deb', '951102', 'an active DVI previewer and presenter', 'http://pauillac.inria.fr/advi/');
INSERT INTO `packages_plain` VALUES ('387', 'adzapper', 'optional', 'web', '357', 'Ludovic Drolez ', 'all', '', '20090301-1', 'pool/main/a/adzapper/adzapper_20090301-1_all.deb', '66140', 'proxy advertisement zapper add-on', '');
INSERT INTO `packages_plain` VALUES ('388', 'aee', 'optional', 'editors', '468', 'Mario Iseli ', 'i386', '', '2.2.15b-3.2', 'pool/main/a/aee/aee_2.2.15b-3.2_i386.deb', '156204', 'An easy to use screen-based editor', '');
INSERT INTO `packages_plain` VALUES ('389', 'aegir-provision', 'optional', 'admin', '428', 'Antoine BeauprГѓВ© ', 'all', '', '0.3-2', 'pool/main/a/aegir-provision/aegir-provision_0.3-2_all.deb', '45658', 'backend of the Aegir hosting system', 'http://drupal.org/project/provision');
INSERT INTO `packages_plain` VALUES ('390', 'aegis-doc', 'optional', 'doc', '2020', 'Christian Meder ', 'all', 'aegis', '4.24-5.2', 'pool/main/a/aegis/aegis-doc_4.24-5.2_all.deb', '1964284', 'documentation for aegis', 'http://aegis.sourceforge.net');
INSERT INTO `packages_plain` VALUES ('391', 'aegis-tk', 'optional', 'devel', '444', 'Christian Meder ', 'all', 'aegis', '4.24-5.2', 'pool/main/a/aegis/aegis-tk_4.24-5.2_all.deb', '162936', 'aegis Tk user interface', 'http://aegis.sourceforge.net');
INSERT INTO `packages_plain` VALUES ('392', 'aegis-web', 'optional', 'devel', '2568', 'Christian Meder ', 'i386', 'aegis', '4.24-5.2', 'pool/main/a/aegis/aegis-web_4.24-5.2_i386.deb', '983062', 'aegis web based user interface', 'http://aegis.sourceforge.net');
INSERT INTO `packages_plain` VALUES ('393', 'aegis', 'optional', 'vcs', '46600', 'Christian Meder ', 'i386', '', '4.24-5.2', 'pool/main/a/aegis/aegis_4.24-5.2_i386.deb', '16007050', 'transaction-based software configuration management', 'http://aegis.sourceforge.net');
INSERT INTO `packages_plain` VALUES ('394', 'aeolus', 'extra', 'sound', '304', 'Debian Multimedia Team ', 'i386', '', '0.8.1-1', 'pool/main/a/aeolus/aeolus_0.8.1-1_i386.deb', '112534', 'Synthesised pipe organ emulator', '');
INSERT INTO `packages_plain` VALUES ('395', 'aes2501-wy', 'optional', 'graphics', '32', 'FingerForce Team ', 'i386', '', '0.1-5', 'pool/main/a/aes2501-wy/aes2501-wy_0.1-5_i386.deb', '12100', 'userspace software for usb aes2501 fingerprint scanner', 'http://gkall.hobby.nl/authentec.html');
INSERT INTO `packages_plain` VALUES ('396', 'aesfix', 'optional', 'utils', '68', 'Debian Forensics ', 'i386', 'aesfix (1.0.1-1)', '1.0.1-1+b1', 'pool/main/a/aesfix/aesfix_1.0.1-1+b1_i386.deb', '11402', 'tool for correcting bit errors in an AES key schedule', 'http://citp.princeton.edu/memory/code/');
INSERT INTO `packages_plain` VALUES ('397', 'aeskeyfind', 'optional', 'utils', '48', 'Debian Forensics ', 'i386', 'aeskeyfind (1.0.0-1)', '1.0.0-1+b1', 'pool/main/a/aeskeyfind/aeskeyfind_1.0.0-1+b1_i386.deb', '7928', 'tool for finding and repairing AES keys', 'http://citp.princeton.edu/memory/code/');
INSERT INTO `packages_plain` VALUES ('398', 'aeskulap', 'optional', 'science', '1784', 'Debian-Med Packaging Team ', 'i386', '', '0.2.2b1-4', 'pool/main/a/aeskulap/aeskulap_0.2.2b1-4_i386.deb', '499444', 'medical image viewer and DICOM network client', 'http://aeskulap.nongnu.org');
INSERT INTO `packages_plain` VALUES ('399', 'aespipe', 'optional', 'utils', '128', 'Debian Loop-AES Team ', 'i386', '', '2.3e-2', 'pool/main/a/aespipe/aespipe_2.3e-2_i386.deb', '41394', 'AES-encryption tool with loop-AES support', '');
INSERT INTO `packages_plain` VALUES ('400', 'aewan', 'extra', 'text', '272', 'Robert Lemmen ', 'i386', '', '1.0.01-3', 'pool/main/a/aewan/aewan_1.0.01-3_i386.deb', '96736', 'ASCII-art Editor Without A Name', '');
INSERT INTO `packages_plain` VALUES ('401', 'aewm++-goodies', 'optional', 'x11', '344', 'Chris Boyle ', 'i386', '', '1.0-9', 'pool/main/a/aewm++-goodies/aewm++-goodies_1.0-9_i386.deb', '69962', 'utilities to complement a minimal window manager', '');
INSERT INTO `packages_plain` VALUES ('402', 'aewm++', 'optional', 'x11', '152', 'Chris Boyle ', 'i386', '', '1.1.2-5', 'pool/main/a/aewm++/aewm++_1.1.2-5_i386.deb', '38770', 'minimal window manager written in C++', 'http://code.google.com/p/aewmpp/');
INSERT INTO `packages_plain` VALUES ('403', 'aewm', 'optional', 'x11', '148', 'Decklin Foster ', 'i386', '', '1.3.12-2', 'pool/main/a/aewm/aewm_1.3.12-2_i386.deb', '52228', 'a minimalist window manager for X11', '');
INSERT INTO `packages_plain` VALUES ('404', 'afbackup-client', 'optional', 'utils', '1224', 'Debian QA Group ', 'i386', 'afbackup', '3.5.3-2', 'pool/main/a/afbackup/afbackup-client_3.5.3-2_i386.deb', '521386', 'Client-Server Backup System (Client side)', 'http://sourceforge.net/projects/afbackup/');
INSERT INTO `packages_plain` VALUES ('405', 'afbackup-common', 'optional', 'utils', '800', 'Debian QA Group ', 'all', 'afbackup', '3.5.3-2', 'pool/main/a/afbackup/afbackup-common_3.5.3-2_all.deb', '319750', 'Client-Server Backup System (common files)', 'http://sourceforge.net/projects/afbackup/');
INSERT INTO `packages_plain` VALUES ('406', 'afbackup', 'optional', 'utils', '1020', 'Debian QA Group ', 'i386', '', '3.5.3-2', 'pool/main/a/afbackup/afbackup_3.5.3-2_i386.deb', '429214', 'Client-Server Backup System (Server side)', 'http://sourceforge.net/projects/afbackup/');
INSERT INTO `packages_plain` VALUES ('407', 'affiche.app', 'optional', 'gnustep', '384', 'Hubert Chathi ', 'i386', 'affiche (0.6.0-7)', '0.6.0-7+b2', 'pool/main/a/affiche/affiche.app_0.6.0-7+b2_i386.deb', '55370', 'An application to \"stick\" little notes on the desktop', '');
INSERT INTO `packages_plain` VALUES ('408', 'afio', 'optional', 'utils', '240', 'Erik Schanze ', 'i386', '', '2.5-5', 'pool/main/a/afio/afio_2.5-5_i386.deb', '80192', 'archive file manipulation program', '');
INSERT INTO `packages_plain` VALUES ('409', 'afnix-doc', 'optional', 'doc', '284', 'Paul Cager ', 'all', 'afnix', '1.5.2-3.3', 'pool/main/a/afnix/afnix-doc_1.5.2-3.3_all.deb', '192320', 'Compiler and run-time for the AFNIX programming language (documentation)', 'http://www.afnix.org/');
INSERT INTO `packages_plain` VALUES ('410', 'afnix', 'optional', 'interpreters', '8776', 'Paul Cager ', 'i386', '', '1.5.2-3.3', 'pool/main/a/afnix/afnix_1.5.2-3.3_i386.deb', '1878610', 'Compiler and run-time for the AFNIX programming language', 'http://www.afnix.org/');
INSERT INTO `packages_plain` VALUES ('411', 'aft', 'optional', 'text', '340', 'Robert Lemmen ', 'all', '', '2:5.097-1', 'pool/main/a/aft/aft_5.097-1_all.deb', '81832', '\"free form\" document preparation system', '');
INSERT INTO `packages_plain` VALUES ('412', 'afterstep', 'optional', 'x11', '9496', 'Robert Luberda ', 'i386', '', '2.2.9-4', 'pool/main/a/afterstep/afterstep_2.2.9-4_i386.deb', '3624130', 'window manager with the NEXTSTEP look and feel', 'http://www.afterstep.org/');
INSERT INTO `packages_plain` VALUES ('413', 'libafterimage-dev', 'optional', 'libdevel', '2156', 'Robert Luberda ', 'i386', 'afterstep', '2.2.9-4', 'pool/main/a/afterstep/libafterimage-dev_2.2.9-4_i386.deb', '808748', 'imaging library designed for AfterStep - development files', 'http://www.afterstep.org/');
INSERT INTO `packages_plain` VALUES ('414', 'libafterimage0', 'optional', 'libs', '632', 'Robert Luberda ', 'i386', 'afterstep', '2.2.9-4', 'pool/main/a/afterstep/libafterimage0_2.2.9-4_i386.deb', '311292', 'imaging library designed for AfterStep - runtime files', 'http://www.afterstep.org/');
INSERT INTO `packages_plain` VALUES ('415', 'libafterstep1', 'optional', 'libs', '860', 'Robert Luberda ', 'i386', 'afterstep', '2.2.9-4', 'pool/main/a/afterstep/libafterstep1_2.2.9-4_i386.deb', '407118', 'shared libraries for the AfterStep window manager', 'http://www.afterstep.org/');
INSERT INTO `packages_plain` VALUES ('416', 'afuse', 'optional', 'utils', '84', 'Varun Hiremath ', 'i386', '', '0.2-3', 'pool/main/a/afuse/afuse_0.2-3_i386.deb', '16514', 'automounting file system implemented in user-space using FUSE', 'http://sourceforge.net/projects/afuse/');
INSERT INTO `packages_plain` VALUES ('417', 'agave', 'optional', 'gnome', '1216', 'Varun Hiremath ', 'i386', '', '0.4.7-1', 'pool/main/a/agave/agave_0.4.7-1_i386.deb', '423634', 'colorscheme designer for the GNOME desktop', 'http://home.gna.org/colorscheme/');
INSERT INTO `packages_plain` VALUES ('418', 'agda-bin', 'optional', 'haskell', '8800', 'Iain Lane ', 'i386', '', '2.2.4-1', 'pool/main/a/agda-bin/agda-bin_2.2.4-1_i386.deb', '2395958', 'Commandline interface to Agda', 'http://wiki.portal.chalmers.se/agda/');
INSERT INTO `packages_plain` VALUES ('419', 'agedu', 'optional', 'utils', '80', 'Alexander Prinsier ', 'i386', '', '8642-1', 'pool/main/a/agedu/agedu_8642-1_i386.deb', '41350', 'a Unix utility for tracking down wasted disk space', 'http://www.chiark.greenend.org.uk/~sgtatham/agedu/');
INSERT INTO `packages_plain` VALUES ('420', 'agenda.app', 'optional', 'gnustep', '576', 'Debian GNUstep maintainers ', 'i386', 'agenda.app (0.36-1)', '0.36-1+b1', 'pool/main/a/agenda.app/agenda.app_0.36-1+b1_i386.deb', '135752', 'Calendar manager for GNUstep', '');
INSERT INTO `packages_plain` VALUES ('421', 'libagg-dev', 'optional', 'libdevel', '2932', 'Andrea Veri ', 'i386', 'agg', '2.5+dfsg1-2', 'pool/main/a/agg/libagg-dev_2.5+dfsg1-2_i386.deb', '516246', 'The AntiGrain Geometry graphical toolkit (development files)', '');
INSERT INTO `packages_plain` VALUES ('422', 'aggregate', 'optional', 'net', '64', 'Erik Wenzel ', 'i386', '', '1.6-5', 'pool/main/a/aggregate/aggregate_1.6-5_i386.deb', '11344', 'ipv4 cidr prefix aggregator', '');
INSERT INTO `packages_plain` VALUES ('423', 'agsync-dev', 'optional', 'libdevel', '372', 'Debian QA Group ', 'i386', 'agsync', '0.2-pre-11', 'pool/main/a/agsync/agsync-dev_0.2-pre-11_i386.deb', '77144', 'Development files for AvantGo and Pocket PC synchronization', '');
INSERT INTO `packages_plain` VALUES ('424', 'agsync', 'optional', 'libs', '212', 'Debian QA Group ', 'i386', '', '0.2-pre-11', 'pool/main/a/agsync/agsync_0.2-pre-11_i386.deb', '69190', 'Synchronization mediator for AvantGo and Pocket PC', '');
INSERT INTO `packages_plain` VALUES ('425', 'agtl', 'extra', 'python', '612', 'Heiko Stuebner ', 'all', '', '0.4.2-1', 'pool/main/a/agtl/agtl_0.4.2-1_all.deb', '74446', 'Tool for paperless geocaching', 'http://wiki.openmoko.org/wiki/Advanced_Geocaching_Tool_for_Linux');
INSERT INTO `packages_plain` VALUES ('426', 'aiccu', 'optional', 'net', '208', 'Debian QA Group ', 'i386', '', '20070115-10', 'pool/main/a/aiccu/aiccu_20070115-10_i386.deb', '50180', 'SixXS Automatic IPv6 Connectivity Client Utility', 'http://www.sixxs.net/tools/aiccu/');
INSERT INTO `packages_plain` VALUES ('427', 'aide-common', 'optional', 'admin', '724', 'Aide Maintainers ', 'all', 'aide', '0.13.1-11', 'pool/main/a/aide/aide-common_0.13.1-11_all.deb', '87724', 'Advanced Intrusion Detection Environment - Common files', 'http://sourceforge.net/projects/aide');
INSERT INTO `packages_plain` VALUES ('428', 'aide-dynamic', 'optional', 'admin', '244', 'Aide Maintainers ', 'i386', 'aide', '0.13.1-11', 'pool/main/a/aide/aide-dynamic_0.13.1-11_i386.deb', '100318', 'Advanced Intrusion Detection Environment - dynamic binary', 'http://sourceforge.net/projects/aide');
INSERT INTO `packages_plain` VALUES ('429', 'aide-xen', 'optional', 'admin', '1184', 'Aide Maintainers ', 'i386', 'aide', '0.13.1-11', 'pool/main/a/aide/aide-xen_0.13.1-11_i386.deb', '566450', 'Advanced Intrusion Detection Environment - static binary for XEN', 'http://sourceforge.net/projects/aide');
INSERT INTO `packages_plain` VALUES ('430', 'aide', 'optional', 'admin', '1116', 'Aide Maintainers ', 'i386', '', '0.13.1-11', 'pool/main/a/aide/aide_0.13.1-11_i386.deb', '534072', 'Advanced Intrusion Detection Environment - static binary', 'http://sourceforge.net/projects/aide');
INSERT INTO `packages_plain` VALUES ('431', 'aiksaurus', 'optional', 'text', '72', 'Masayuki Hatta (mhatta) ', 'i386', '', '1.2.1+dev-0.12-6', 'pool/main/a/aiksaurus/aiksaurus_1.2.1+dev-0.12-6_i386.deb', '11818', 'an English-language thesaurus (utility)', '');
INSERT INTO `packages_plain` VALUES ('432', 'gaiksaurus', 'optional', 'text', '72', 'Masayuki Hatta (mhatta) ', 'i386', 'aiksaurus', '1.2.1+dev-0.12-6', 'pool/main/a/aiksaurus/gaiksaurus_1.2.1+dev-0.12-6_i386.deb', '9286', 'graphical interface to the Aiksaurus toolkit (GTK+ frontend)', '');
INSERT INTO `packages_plain` VALUES ('433', 'libaiksaurus-1.2-0c2a', 'optional', 'libs', '88', 'Masayuki Hatta (mhatta) ', 'i386', 'aiksaurus', '1.2.1+dev-0.12-6', 'pool/main/a/aiksaurus/libaiksaurus-1.2-0c2a_1.2.1+dev-0.12-6_i386.deb', '23488', 'an English-language thesaurus (development)', '');
INSERT INTO `packages_plain` VALUES ('434', 'libaiksaurus-1.2-data', 'optional', 'libs', '560', 'Masayuki Hatta (mhatta) ', 'all', 'aiksaurus', '1.2.1+dev-0.12-6', 'pool/main/a/aiksaurus/libaiksaurus-1.2-data_1.2.1+dev-0.12-6_all.deb', '317310', 'an English-language thesaurus (data)', '');
INSERT INTO `packages_plain` VALUES ('435', 'libaiksaurus-1.2-dev', 'optional', 'libdevel', '132', 'Masayuki Hatta (mhatta) ', 'i386', 'aiksaurus', '1.2.1+dev-0.12-6', 'pool/main/a/aiksaurus/libaiksaurus-1.2-dev_1.2.1+dev-0.12-6_i386.deb', '25060', 'an English-language thesaurus (development)', '');
INSERT INTO `packages_plain` VALUES ('436', 'libaiksaurusgtk-1.2-0c2a', 'optional', 'libs', '124', 'Masayuki Hatta (mhatta) ', 'i386', 'aiksaurus', '1.2.1+dev-0.12-6', 'pool/main/a/aiksaurus/libaiksaurusgtk-1.2-0c2a_1.2.1+dev-0.12-6_i386.deb', '33428', 'graphical interface to the Aiksaurus toolkit (library)', '');
INSERT INTO `packages_plain` VALUES ('437', 'libaiksaurusgtk-1.2-dev', 'optional', 'libdevel', '168', 'Masayuki Hatta (mhatta) ', 'i386', 'aiksaurus', '1.2.1+dev-0.12-6', 'pool/main/a/aiksaurus/libaiksaurusgtk-1.2-dev_1.2.1+dev-0.12-6_i386.deb', '32196', 'graphical interface to the Aiksaurus toolkit (development)', '');
INSERT INTO `packages_plain` VALUES ('438', 'aircrack-ng', 'optional', 'net', '2608', 'Adam CГѓВ©cile (Le_Vert) ', 'i386', '', '1:1.0~rc3-2', 'pool/main/a/aircrack-ng/aircrack-ng_1.0~rc3-2_i386.deb', '1541508', 'wireless WEP/WPA cracking utilities', 'http://www.aircrack-ng.org/');
INSERT INTO `packages_plain` VALUES ('439', 'airport-utils', 'optional', 'net', '576', 'Julien BLACHE ', 'all', '', '1-8', 'pool/main/a/airport-utils/airport-utils_1-8_all.deb', '396618', 'configuration and management utilities for Apple AirPort base stations', '');
INSERT INTO `packages_plain` VALUES ('440', 'airstrike-common', 'optional', 'games', '2412', 'Debian Games Team ', 'all', 'airstrike', '0.99+1.0pre6a-4', 'pool/main/a/airstrike/airstrike-common_0.99+1.0pre6a-4_all.deb', '1877222', '2d dogfight game in the tradition of \'Biplanes\' and \'BIP\'', 'http://icculus.org/airstrike/');
INSERT INTO `packages_plain` VALUES ('441', 'airstrike', 'optional', 'games', '192', 'Debian Games Team ', 'i386', '', '0.99+1.0pre6a-4', 'pool/main/a/airstrike/airstrike_0.99+1.0pre6a-4_i386.deb', '45908', '2d dogfight game in the tradition of \'Biplanes\' and \'BIP\'', 'http://icculus.org/airstrike/');
INSERT INTO `packages_plain` VALUES ('442', 'aish', 'optional', 'utils', '116', 'Atsushi KAMOSHIDA ', 'i386', '', '1.13-5', 'pool/main/a/aish/aish_1.13-5_i386.deb', '35848', 'ish/base64/uuencoded_file converter', '');
INSERT INTO `packages_plain` VALUES ('443', 'ajaxterm', 'optional', 'web', '248', 'Julien Valroff ', 'all', '', '0.10-4', 'pool/main/a/ajaxterm/ajaxterm_0.10-4_all.deb', '40296', 'Web based terminal written in Python', 'http://antony.lesuisse.org/qweb/trac/wiki/AjaxTerm');
INSERT INTO `packages_plain` VALUES ('444', 'akonadi-kde-resource-googledata', 'extra', 'net', '472', 'Debian Qt/KDE Maintainers ', 'i386', 'akonadi-googledata', '1.0.1-1', 'pool/main/a/akonadi-googledata/akonadi-kde-resource-googledata_1.0.1-1_i386.deb', '97322', 'Google calendar and contacts resource for Akonadi', 'http://code.google.com/p/libgcal/');
INSERT INTO `packages_plain` VALUES ('445', 'akonadi-dbg', 'extra', 'debug', '16756', 'Debian Qt/KDE Maintainers ', 'i386', 'akonadi', '1.2.1-1', 'pool/main/a/akonadi/akonadi-dbg_1.2.1-1_i386.deb', '6679912', 'debugging symbols for the Akonadi PIM storage service', 'http://pim.kde.org/akonadi');
INSERT INTO `packages_plain` VALUES ('446', 'akonadi-server', 'extra', 'net', '472', 'Debian Qt/KDE Maintainers ', 'i386', 'akonadi', '1.2.1-1', 'pool/main/a/akonadi/akonadi-server_1.2.1-1_i386.deb', '175984', 'Akonadi PIM storage service', 'http://pim.kde.org/akonadi');
INSERT INTO `packages_plain` VALUES ('447', 'libakonadi-dev', 'extra', 'libdevel', '220', 'Debian Qt/KDE Maintainers ', 'i386', 'akonadi', '1.2.1-1', 'pool/main/a/akonadi/libakonadi-dev_1.2.1-1_i386.deb', '46146', 'development files for the Akonadi PIM storage service', 'http://pim.kde.org/akonadi');
INSERT INTO `packages_plain` VALUES ('448', 'libakonadiprivate1', 'extra', 'libs', '1512', 'Debian Qt/KDE Maintainers ', 'i386', 'akonadi', '1.2.1-1', 'pool/main/a/akonadi/libakonadiprivate1_1.2.1-1_i386.deb', '576204', 'libraries for the Akonadi PIM storage service', 'http://pim.kde.org/akonadi');
INSERT INTO `packages_plain` VALUES ('449', 'alacarte', 'optional', 'utils', '554', 'Debian GNOME Maintainers ', 'all', '', '0.12.4-1', 'pool/main/a/alacarte/alacarte_0.12.4-1_all.deb', '102970', 'easy GNOME menu editing tool', '');
INSERT INTO `packages_plain` VALUES ('450', 'alarm-clock-applet', 'optional', 'gnome', '396', 'Chow Loong Jin ', 'i386', '', '0.2.6-1', 'pool/main/a/alarm-clock-applet/alarm-clock-applet_0.2.6-1_i386.deb', '94038', 'Alarm Clock applet for the GNOME panel', 'http://alarm-clock.pseudoberries.com/');
INSERT INTO `packages_plain` VALUES ('451', 'alarm-clock', 'optional', 'utils', '1800', 'Ryan Niebur ', 'i386', '', '1.2.4-1', 'pool/main/a/alarm-clock/alarm-clock_1.2.4-1_i386.deb', '615318', 'Alarm Clock for GTK Environments', 'http://www.alarm-clock.pl/');
INSERT INTO `packages_plain` VALUES ('452', 'python-albatross-common', 'optional', 'web', '160', 'Fabian Fagerholm ', 'all', 'albatross', '1.36-5', 'pool/main/a/albatross/python-albatross-common_1.36-5_all.deb', '52596', 'Toolkit for Stateful Web Applications (common files)', 'http://www.object-craft.com.au/projects/albatross/');
INSERT INTO `packages_plain` VALUES ('453', 'python-albatross-doc', 'optional', 'doc', '604', 'Fabian Fagerholm ', 'all', 'albatross', '1.36-5', 'pool/main/a/albatross/python-albatross-doc_1.36-5_all.deb', '582732', 'documentation for the Albatross Web Toolkit', 'http://www.object-craft.com.au/projects/albatross/');
INSERT INTO `packages_plain` VALUES ('454', 'python-albatross', 'optional', 'web', '320', 'Fabian Fagerholm ', 'all', 'albatross', '1.36-5', 'pool/main/a/albatross/python-albatross_1.36-5_all.deb', '85784', 'Toolkit for Stateful Web Applications', 'http://www.object-craft.com.au/projects/albatross/');
INSERT INTO `packages_plain` VALUES ('455', 'albumshaper', 'optional', 'graphics', '7356', 'Jano Kupec ', 'i386', '', '2.1-5', 'pool/main/a/albumshaper/albumshaper_2.1-5_i386.deb', '4400704', 'Photo album creator and photo manipulator', 'http://albumshaper.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('456', 'alcovebook-sgml-doc', 'optional', 'doc', '6468', 'Yann Dirson ', 'all', 'alcovebook-sgml', '0.1.2dfsg-8', 'pool/main/a/alcovebook-sgml/alcovebook-sgml-doc_0.1.2dfsg-8_all.deb', '274786', 'Documentation for the AlcoveBook DTD', '');
INSERT INTO `packages_plain` VALUES ('457', 'alcovebook-sgml', 'optional', 'text', '328', 'Yann Dirson ', 'all', '', '0.1.2dfsg-8', 'pool/main/a/alcovebook-sgml/alcovebook-sgml_0.1.2dfsg-8_all.deb', '34348', 'Alcove customisation of the DocBook DTD and stylesheets', '');
INSERT INTO `packages_plain` VALUES ('458', 'aldo', 'optional', 'hamradio', '220', 'Giuseppe Martino (denever) ', 'i386', '', '0.7.5-1', 'pool/main/a/aldo/aldo_0.7.5-1_i386.deb', '71522', 'Morse code training program', '');
INSERT INTO `packages_plain` VALUES ('459', 'ale', 'optional', 'graphics', '760', 'Ruben Molina ', 'i386', '', '0.9.0.3-1', 'pool/main/a/ale/ale_0.9.0.3-1_i386.deb', '323372', 'synthetic capture engine and renderer', 'http://auricle.dyndns.org/ALE/');
INSERT INTO `packages_plain` VALUES ('460', 'alevt', 'extra', 'x11', '204', 'Andreas Rottmann ', 'i386', '', '1:1.6.1-10.2', 'pool/main/a/alevt/alevt_1.6.1-10.2_i386.deb', '82662', 'X11 Teletext/Videotext browser', '');
INSERT INTO `packages_plain` VALUES ('461', 'alex', 'optional', 'haskell', '956', 'Ian Lynagh (wibble) ', 'i386', '', '2.2-0.2', 'pool/main/a/alex/alex_2.2-0.2_i386.deb', '257292', 'lexical analyser generator for Haskell', 'http://www.haskell.org/alex/');
INSERT INTO `packages_plain` VALUES ('462', 'alex4-data', 'optional', 'games', '632', 'Debian Games Team ', 'all', 'alex4', '1.1-3', 'pool/main/a/alex4/alex4-data_1.1-3_all.deb', '580564', 'Alex the Allegator 4 - game data', 'http://allegator.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('463', 'alex4', 'optional', 'games', '192', 'Debian Games Team ', 'i386', '', '1.1-3', 'pool/main/a/alex4/alex4_1.1-3_i386.deb', '55696', 'Alex the Allegator 4 - a retro platform game', 'http://allegator.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('464', 'alexandria', 'extra', 'gnome', '2032', 'Dafydd Harries ', 'all', '', '0.6.1-1', 'pool/main/a/alexandria/alexandria_0.6.1-1_all.deb', '911034', 'a GNOME application for managing book collections', '');
INSERT INTO `packages_plain` VALUES ('465', 'alien-hunter', 'optional', 'science', '164', 'Debian Med Packaging Team ', 'all', '', '1.7-1', 'pool/main/a/alien-hunter/alien-hunter_1.7-1_all.deb', '30470', 'Interpolated Variable Order Motifs to identify horizontally acquired DNA', 'http://www.sanger.ac.uk/Software/analysis/alien_hunter/');
INSERT INTO `packages_plain` VALUES ('466', 'alien', 'optional', 'admin', '276', 'Joey Hess ', 'all', '', '8.78', 'pool/main/a/alien/alien_8.78_all.deb', '107256', 'convert and install rpm and other packages', 'http://kitenet.net/~joey/code/alien/');
INSERT INTO `packages_plain` VALUES ('467', 'alienblaster-data', 'extra', 'games', '11720', 'Debian Games Team ', 'all', 'alienblaster', '1.1.0-4', 'pool/main/a/alienblaster/alienblaster-data_1.1.0-4_all.deb', '6469626', 'Game data for Alien Blaster', 'http://www.schwardtnet.de/alienblaster/');
INSERT INTO `packages_plain` VALUES ('468', 'alienblaster', 'extra', 'games', '848', 'Debian Games Team ', 'i386', '', '1.1.0-4', 'pool/main/a/alienblaster/alienblaster_1.1.0-4_i386.deb', '251398', 'Classic 2D shoot \'em up', 'http://www.schwardtnet.de/alienblaster/');
INSERT INTO `packages_plain` VALUES ('469', 'all-in-one-sidebar', 'optional', 'web', '1996', 'Debian Mozilla Extension Maintainers ', 'all', '', '0.7.10-2', 'pool/main/a/all-in-one-sidebar/all-in-one-sidebar_0.7.10-2_all.deb', '294448', 'A sidebar extension for Mozilla Firefox', 'http://firefox.exxile.net/aios/');
INSERT INTO `packages_plain` VALUES ('470', 'allegro-demo-data', 'optional', 'devel', '432', 'Debian allegro packages maintainers ', 'all', '', '3.9.36-7', 'pool/main/a/allegro-demo-data/allegro-demo-data_3.9.36-7_all.deb', '369166', 'graphics and audio data for allegro-demo', '');
INSERT INTO `packages_plain` VALUES ('471', 'allegro-demo', 'optional', 'games', '272', 'Debian allegro packages maintainers ', 'i386', 'allegro4.2', '2:4.2.2-2.1', 'pool/main/a/allegro4.2/allegro-demo_4.2.2-2.1_i386.deb', '123848', 'cool game, demonstrating power of the Allegro library', '');
INSERT INTO `packages_plain` VALUES ('472', 'allegro-examples', 'optional', 'utils', '928', 'Debian allegro packages maintainers ', 'i386', 'allegro4.2', '2:4.2.2-2.1', 'pool/main/a/allegro4.2/allegro-examples_4.2.2-2.1_i386.deb', '353342', 'example programs and demo tools for the Allegro library', '');
INSERT INTO `packages_plain` VALUES ('473', 'liballegro-doc', 'optional', 'doc', '6732', 'Debian allegro packages maintainers ', 'all', 'allegro4.2', '2:4.2.2-2.1', 'pool/main/a/allegro4.2/liballegro-doc_4.2.2-2.1_all.deb', '1590930', 'documentation for the Allegro library', '');
INSERT INTO `packages_plain` VALUES ('474', 'liballegro4.2-dev', 'optional', 'libdevel', '2840', 'Debian allegro packages maintainers ', 'i386', 'allegro4.2', '2:4.2.2-2.1', 'pool/main/a/allegro4.2/liballegro4.2-dev_4.2.2-2.1_i386.deb', '949706', 'development files for the Allegro library', '');
INSERT INTO `packages_plain` VALUES ('475', 'liballegro4.2-plugin-arts', 'optional', 'libs', '40', 'Debian allegro packages maintainers ', 'i386', 'allegro4.2', '2:4.2.2-2.1', 'pool/main/a/allegro4.2/liballegro4.2-plugin-arts_4.2.2-2.1_i386.deb', '4508', 'aRts audio plugin for the Allegro library', '');
INSERT INTO `packages_plain` VALUES ('476', 'liballegro4.2-plugin-esd', 'optional', 'libs', '40', 'Debian allegro packages maintainers ', 'i386', 'allegro4.2', '2:4.2.2-2.1', 'pool/main/a/allegro4.2/liballegro4.2-plugin-esd_4.2.2-2.1_i386.deb', '4822', 'esd audio plugin for the Allegro library', '');
INSERT INTO `packages_plain` VALUES ('477', 'liballegro4.2-plugin-jack', 'optional', 'libs', '44', 'Debian allegro packages maintainers ', 'i386', 'allegro4.2', '2:4.2.2-2.1', 'pool/main/a/allegro4.2/liballegro4.2-plugin-jack_4.2.2-2.1_i386.deb', '5278', 'JACK audio plugin for the Allegro library', '');
INSERT INTO `packages_plain` VALUES ('478', 'liballegro4.2-plugin-svgalib', 'optional', 'libs', '44', 'Debian allegro packages maintainers ', 'i386', 'allegro4.2', '2:4.2.2-2.1', 'pool/main/a/allegro4.2/liballegro4.2-plugin-svgalib_4.2.2-2.1_i386.deb', '6592', 'SVGAlib video plugin for the Allegro library', '');
INSERT INTO `packages_plain` VALUES ('479', 'liballegro4.2', 'optional', 'libs', '1260', 'Debian allegro packages maintainers ', 'i386', 'allegro4.2', '2:4.2.2-2.1', 'pool/main/a/allegro4.2/liballegro4.2_4.2.2-2.1_i386.deb', '539994', 'portable library for cross-platform game and multimedia development', '');
INSERT INTO `packages_plain` VALUES ('480', 'alleyoop', 'optional', 'devel', '980', 'Debian GNOME Maintainers ', 'i386', '', '0.9.5-1', 'pool/main/a/alleyoop/alleyoop_0.9.5-1_i386.deb', '158396', 'Front-end to the Valgrind memory checker', 'http://alleyoop.sourceforge.net');
INSERT INTO `packages_plain` VALUES ('481', 'alltray', 'optional', 'x11', '224', 'Carlos C Soto ', 'i386', '', '0.69-1', 'pool/main/a/alltray/alltray_0.69-1_i386.deb', '59552', 'Dock any program into the system tray', '');
INSERT INTO `packages_plain` VALUES ('482', 'almanah', 'extra', 'gnome', '528', 'Angel Abad (Ikusnet SLL) ', 'i386', '', '0.6.1-2', 'pool/main/a/almanah/almanah_0.6.1-2_i386.deb', '101278', 'application to ease management of a personal diary', 'http://tecnocode.co.uk/projects/almanah/');
INSERT INTO `packages_plain` VALUES ('483', 'libalogg-dev', 'optional', 'libdevel', '184', 'Debian allegro packages maintainers ', 'i386', 'alogg', '1.3.7-1.1', 'pool/main/a/alogg/libalogg-dev_1.3.7-1.1_i386.deb', '41966', 'Ogg/Vorbis library for Allegro - development files', '');
INSERT INTO `packages_plain` VALUES ('484', 'libalogg1', 'optional', 'libs', '84', 'Debian allegro packages maintainers ', 'i386', 'alogg', '1.3.7-1.1', 'pool/main/a/alogg/libalogg1_1.3.7-1.1_i386.deb', '16850', 'Ogg/Vorbis library for Allegro - shared libraries', '');
INSERT INTO `packages_plain` VALUES ('485', 'alqalam', 'optional', 'tex', '1580', 'Debian TeX maintainers ', 'all', '', '0.2-3', 'pool/main/a/alqalam/alqalam_0.2-3_all.deb', '876684', 'Qur\'an typesetting macros for TeX/LaTeX', 'http://tech.groups.yahoo.com/group/QuranTypesetting/');
INSERT INTO `packages_plain` VALUES ('486', 'alsa-base', 'optional', 'sound', '480', 'Debian ALSA Maintainers ', 'all', 'alsa-driver', '1.0.21+dfsg-2', 'pool/main/a/alsa-driver/alsa-base_1.0.21+dfsg-2_all.deb', '283924', 'ALSA driver configuration files', 'http://www.alsa-project.org/');
INSERT INTO `packages_plain` VALUES ('487', 'alsa-source', 'optional', 'kernel', '3572', 'Debian ALSA Maintainers ', 'all', 'alsa-driver', '1.0.21+dfsg-2', 'pool/main/a/alsa-driver/alsa-source_1.0.21+dfsg-2_all.deb', '3519460', 'ALSA driver sources', 'http://www.alsa-project.org/');
INSERT INTO `packages_plain` VALUES ('488', 'linux-sound-base', 'optional', 'sound', '136', 'Debian ALSA Maintainers ', 'all', 'alsa-driver', '1.0.21+dfsg-2', 'pool/main/a/alsa-driver/linux-sound-base_1.0.21+dfsg-2_all.deb', '28272', 'base package for ALSA and OSS sound systems', 'http://www.alsa-project.org/');
INSERT INTO `packages_plain` VALUES ('489', 'lib64asound2-dev', 'optional', 'libdevel', '1852', 'Debian ALSA Maintainers ', 'i386', 'alsa-lib', '1.0.21a-1', 'pool/main/a/alsa-lib/lib64asound2-dev_1.0.21a-1_i386.deb', '493034', 'shared library for ALSA applications -- development files (64 bit)', 'http://www.alsa-project.org/');
INSERT INTO `packages_plain` VALUES ('490', 'lib64asound2', 'optional', 'libs', '968', 'Debian ALSA Maintainers ', 'i386', 'alsa-lib', '1.0.21a-1', 'pool/main/a/alsa-lib/lib64asound2_1.0.21a-1_i386.deb', '364802', 'shared library for ALSA applications (64 bit)', 'http://www.alsa-project.org/');
INSERT INTO `packages_plain` VALUES ('491', 'libasound2-dev', 'optional', 'libdevel', '1816', 'Debian ALSA Maintainers ', 'i386', 'alsa-lib', '1.0.21a-1', 'pool/main/a/alsa-lib/libasound2-dev_1.0.21a-1_i386.deb', '508152', 'shared library for ALSA applications -- development files', 'http://www.alsa-project.org/');
INSERT INTO `packages_plain` VALUES ('492', 'libasound2-doc', 'optional', 'doc', '13608', 'Debian ALSA Maintainers ', 'all', 'alsa-lib', '1.0.21a-1', 'pool/main/a/alsa-lib/libasound2-doc_1.0.21a-1_all.deb', '1438240', 'developer documentation for user-space ALSA application programming', 'http://www.alsa-project.org/');
INSERT INTO `packages_plain` VALUES ('493', 'libasound2', 'optional', 'libs', '1236', 'Debian ALSA Maintainers ', 'i386', 'alsa-lib', '1.0.21a-1', 'pool/main/a/alsa-lib/libasound2_1.0.21a-1_i386.deb', '373474', 'shared library for ALSA applications', 'http://www.alsa-project.org/');
INSERT INTO `packages_plain` VALUES ('494', 'alsa-oss', 'optional', 'sound', '144', 'Debian ALSA Maintainers ', 'i386', '', '1.0.17-3', 'pool/main/a/alsa-oss/alsa-oss_1.0.17-3_i386.deb', '30998', 'ALSA wrapper for OSS applications', 'http://www.alsa-project.org/');
INSERT INTO `packages_plain` VALUES ('495', 'lib64asound2-plugins', 'optional', 'libs', '156', 'Debian ALSA Maintainers ', 'i386', 'alsa-plugins', '1.0.21-3', 'pool/main/a/alsa-plugins/lib64asound2-plugins_1.0.21-3_i386.deb', '46612', 'ALSA library additional plugins (64 bit)', 'http://www.alsa-project.org/');
INSERT INTO `packages_plain` VALUES ('496', 'libasound2-plugins', 'optional', 'libs', '288', 'Debian ALSA Maintainers ', 'i386', 'alsa-plugins', '1.0.21-3', 'pool/main/a/alsa-plugins/libasound2-plugins_1.0.21-3_i386.deb', '73350', 'ALSA library additional plugins', 'http://www.alsa-project.org/');
INSERT INTO `packages_plain` VALUES ('497', 'alsa-tools-gui', 'extra', 'sound', '836', 'Debian ALSA Maintainers ', 'i386', 'alsa-tools', '1.0.21-1', 'pool/main/a/alsa-tools/alsa-tools-gui_1.0.21-1_i386.deb', '261172', 'GUI based ALSA utilities for specific hardware', 'http://www.alsa-project.org/');
INSERT INTO `packages_plain` VALUES ('498', 'alsa-tools', 'extra', 'sound', '304', 'Debian ALSA Maintainers ', 'i386', '', '1.0.21-1', 'pool/main/a/alsa-tools/alsa-tools_1.0.21-1_i386.deb', '81936', 'Console based ALSA utilities for specific hardware', 'http://www.alsa-project.org/');
INSERT INTO `packages_plain` VALUES ('499', 'ld10k1', 'extra', 'sound', '488', 'Debian ALSA Maintainers ', 'i386', 'alsa-tools', '1.0.21-1', 'pool/main/a/alsa-tools/ld10k1_1.0.21-1_i386.deb', '106626', 'ALSA emu10k1/2 patch loader', 'http://www.alsa-project.org/');
INSERT INTO `packages_plain` VALUES ('500', 'liblo10k1-0', 'extra', 'libs', '108', 'Debian ALSA Maintainers ', 'i386', 'alsa-tools', '1.0.21-1', 'pool/main/a/alsa-tools/liblo10k1-0_1.0.21-1_i386.deb', '31252', 'ALSA emu10k1/2 patch-loader library', 'http://www.alsa-project.org/');
INSERT INTO `packages_plain` VALUES ('501', 'liblo10k1-dev', 'extra', 'devel', '184', 'Debian ALSA Maintainers ', 'i386', 'alsa-tools', '1.0.21-1', 'pool/main/a/alsa-tools/liblo10k1-dev_1.0.21-1_i386.deb', '37196', 'ALSA emu10k1/2 patch-loader library development files', 'http://www.alsa-project.org/');
INSERT INTO `packages_plain` VALUES ('502', 'qlo10k1', 'extra', 'sound', '456', 'Debian ALSA Maintainers ', 'i386', 'alsa-tools', '1.0.21-1', 'pool/main/a/alsa-tools/qlo10k1_1.0.21-1_i386.deb', '141602', 'ALSA ld10k1 utility', 'http://www.alsa-project.org/');
INSERT INTO `packages_plain` VALUES ('503', 'alsa-utils', 'optional', 'sound', '1984', 'Debian ALSA Maintainers ', 'i386', '', '1.0.21-1', 'pool/main/a/alsa-utils/alsa-utils_1.0.21-1_i386.deb', '1096902', 'ALSA utilities', 'http://www.alsa-project.org/');
INSERT INTO `packages_plain` VALUES ('504', 'alsamixergui', 'optional', 'sound', '96', 'Paul Brossier ', 'i386', '', '0.9.0rc2-1-9', 'pool/main/a/alsamixergui/alsamixergui_0.9.0rc2-1-9_i386.deb', '30530', 'graphical soundcard mixer for ALSA soundcard driver', '');
INSERT INTO `packages_plain` VALUES ('505', 'alsaplayer-alsa', 'optional', 'sound', '80', 'Tony Palma ', 'i386', 'alsaplayer', '0.99.80-4', 'pool/main/a/alsaplayer/alsaplayer-alsa_0.99.80-4_i386.deb', '32660', 'PCM player designed for ALSA (ALSA output module)', 'http://www.alsaplayer.org/');
INSERT INTO `packages_plain` VALUES ('506', 'alsaplayer-common', 'optional', 'sound', '424', 'Tony Palma ', 'i386', 'alsaplayer', '0.99.80-4', 'pool/main/a/alsaplayer/alsaplayer-common_0.99.80-4_i386.deb', '166898', 'PCM player designed for ALSA (common files)', 'http://www.alsaplayer.org/');
INSERT INTO `packages_plain` VALUES ('507', 'alsaplayer-daemon', 'optional', 'sound', '108', 'Tony Palma ', 'i386', 'alsaplayer', '0.99.80-4', 'pool/main/a/alsaplayer/alsaplayer-daemon_0.99.80-4_i386.deb', '32968', 'PCM player designed for ALSA (non-interactive version)', 'http://www.alsaplayer.org/');
INSERT INTO `packages_plain` VALUES ('508', 'alsaplayer-esd', 'optional', 'sound', '76', 'Tony Palma ', 'i386', 'alsaplayer', '0.99.80-4', 'pool/main/a/alsaplayer/alsaplayer-esd_0.99.80-4_i386.deb', '30882', 'PCM player designed for ALSA (EsounD output module)', 'http://www.alsaplayer.org/');
INSERT INTO `packages_plain` VALUES ('509', 'alsaplayer-gtk', 'optional', 'sound', '548', 'Tony Palma ', 'i386', 'alsaplayer', '0.99.80-4', 'pool/main/a/alsaplayer/alsaplayer-gtk_0.99.80-4_i386.deb', '191464', 'PCM player designed for ALSA (GTK+ version)', 'http://www.alsaplayer.org/');
INSERT INTO `packages_plain` VALUES ('510', 'alsaplayer-jack', 'optional', 'sound', '84', 'Tony Palma ', 'i386', 'alsaplayer', '0.99.80-4', 'pool/main/a/alsaplayer/alsaplayer-jack_0.99.80-4_i386.deb', '34748', 'PCM player designed for ALSA (JACK output module)', 'http://www.alsaplayer.org/');
INSERT INTO `packages_plain` VALUES ('511', 'alsaplayer-nas', 'optional', 'sound', '80', 'Tony Palma ', 'i386', 'alsaplayer', '0.99.80-4', 'pool/main/a/alsaplayer/alsaplayer-nas_0.99.80-4_i386.deb', '32808', 'PCM player designed for ALSA (NAS output module)', 'http://www.alsaplayer.org/');
INSERT INTO `packages_plain` VALUES ('512', 'alsaplayer-oss', 'optional', 'sound', '76', 'Tony Palma ', 'i386', 'alsaplayer', '0.99.80-4', 'pool/main/a/alsaplayer/alsaplayer-oss_0.99.80-4_i386.deb', '31022', 'PCM player designed for ALSA (OSS output module)', 'http://www.alsaplayer.org/');
INSERT INTO `packages_plain` VALUES ('513', 'alsaplayer-text', 'optional', 'sound', '100', 'Tony Palma ', 'i386', 'alsaplayer', '0.99.80-4', 'pool/main/a/alsaplayer/alsaplayer-text_0.99.80-4_i386.deb', '33750', 'PCM player designed for ALSA (text version)', 'http://www.alsaplayer.org/');
INSERT INTO `packages_plain` VALUES ('514', 'alsaplayer-xosd', 'optional', 'sound', '108', 'Tony Palma ', 'i386', 'alsaplayer', '0.99.80-4', 'pool/main/a/alsaplayer/alsaplayer-xosd_0.99.80-4_i386.deb', '33688', 'PCM player designed for ALSA (osd version)', 'http://www.alsaplayer.org/');
INSERT INTO `packages_plain` VALUES ('515', 'libalsaplayer-dev', 'optional', 'libdevel', '536', 'Tony Palma ', 'i386', 'alsaplayer', '0.99.80-4', 'pool/main/a/alsaplayer/libalsaplayer-dev_0.99.80-4_i386.deb', '89270', 'PCM player designed for ALSA (interface library, development files)', 'http://www.alsaplayer.org/');
INSERT INTO `packages_plain` VALUES ('516', 'libalsaplayer0', 'optional', 'libs', '92', 'Tony Palma ', 'i386', 'alsaplayer', '0.99.80-4', 'pool/main/a/alsaplayer/libalsaplayer0_0.99.80-4_i386.deb', '37068', 'PCM player designed for ALSA (interface library)', 'http://www.alsaplayer.org/');
INSERT INTO `packages_plain` VALUES ('517', 'alt-ergo', 'optional', 'math', '1148', 'Debian OCaml Maintainers ', 'i386', 'alt-ergo (0.9-1)', '0.9-1+b1', 'pool/main/a/alt-ergo/alt-ergo_0.9-1+b1_i386.deb', '427948', 'Automatic theorem prover dedicated to program verification', 'http://alt-ergo.lri.fr');
INSERT INTO `packages_plain` VALUES ('518', 'altermime', 'optional', 'mail', '192', 'Julien Valroff ', 'i386', '', '0.3.10-2', 'pool/main/a/altermime/altermime_0.3.10-2_i386.deb', '55086', 'utility used to alter mime-encoded mailpacks', 'http://www.pldaniels.com/altermime/');
INSERT INTO `packages_plain` VALUES ('519', 'altree-examples', 'optional', 'science', '1108', 'Debian-Med Packaging Team ', 'all', 'altree', '1.0.1-3', 'pool/main/a/altree/altree-examples_1.0.1-3_all.deb', '400662', 'example files for ALTree', 'http://claire.bardel.free.fr/');
INSERT INTO `packages_plain` VALUES ('520', 'altree', 'optional', 'science', '584', 'Debian-Med Packaging Team ', 'i386', '', '1.0.1-3', 'pool/main/a/altree/altree_1.0.1-3_i386.deb', '254424', 'program to perform phylogeny based analyses', 'http://claire.bardel.free.fr/');
INSERT INTO `packages_plain` VALUES ('521', 'alure-doc', 'optional', 'doc', '232', 'Debian Games Team ', 'all', 'alure', '1.0-2', 'pool/main/a/alure/alure-doc_1.0-2_all.deb', '18744', 'AL Utilities REtooled (documentation)', 'http://kcat.strangesoft.net/alure.html');
INSERT INTO `packages_plain` VALUES ('522', 'libalure-dev', 'optional', 'libdevel', '152', 'Debian Games Team ', 'i386', 'alure', '1.0-2', 'pool/main/a/alure/libalure-dev_1.0-2_i386.deb', '28398', 'AL Utilities REtooled (development files)', 'http://kcat.strangesoft.net/alure.html');
INSERT INTO `packages_plain` VALUES ('523', 'libalure1-dbg', 'extra', 'debug', '228', 'Debian Games Team ', 'i386', 'alure', '1.0-2', 'pool/main/a/alure/libalure1-dbg_1.0-2_i386.deb', '72788', 'AL Utilities REtooled (debugging symbols)', 'http://kcat.strangesoft.net/alure.html');
INSERT INTO `packages_plain` VALUES ('524', 'libalure1', 'optional', 'libs', '92', 'Debian Games Team ', 'i386', 'alure', '1.0-2', 'pool/main/a/alure/libalure1_1.0-2_i386.deb', '22000', 'AL Utilities REtooled (shared library)', 'http://kcat.strangesoft.net/alure.html');
INSERT INTO `packages_plain` VALUES ('525', 'am-utils-doc', 'extra', 'doc', '1636', 'Tim Cutts ', 'all', 'am-utils', '6.1.5-15', 'pool/main/a/am-utils/am-utils-doc_6.1.5-15_all.deb', '700088', 'automounter utilities documentation', 'http://www.am-utils.org/');
INSERT INTO `packages_plain` VALUES ('526', 'am-utils', 'extra', 'net', '740', 'Tim Cutts ', 'i386', '', '6.1.5-15', 'pool/main/a/am-utils/am-utils_6.1.5-15_i386.deb', '396686', 'automounter utilities from 4.4BSD (includes amd)', 'http://www.am-utils.org/');
INSERT INTO `packages_plain` VALUES ('527', 'libamu-dev', 'extra', 'libdevel', '176', 'Tim Cutts ', 'i386', 'am-utils', '6.1.5-15', 'pool/main/a/am-utils/libamu-dev_6.1.5-15_i386.deb', '45272', 'Support library for amd the 4.4BSD automounter (development)', 'http://www.am-utils.org/');
INSERT INTO `packages_plain` VALUES ('528', 'libamu4', 'extra', 'libs', '204', 'Tim Cutts ', 'i386', 'am-utils', '6.1.5-15', 'pool/main/a/am-utils/libamu4_6.1.5-15_i386.deb', '164778', 'Support library for amd the 4.4BSD automounter (runtime)', 'http://www.am-utils.org/');
INSERT INTO `packages_plain` VALUES ('529', 'amanda-client', 'optional', 'utils', '572', 'Bdale Garbee ', 'i386', 'amanda', '1:2.6.1p1-2', 'pool/main/a/amanda/amanda-client_2.6.1p1-2_i386.deb', '191836', 'Advanced Maryland Automatic Network Disk Archiver (Client)', '');
INSERT INTO `packages_plain` VALUES ('530', 'amanda-common', 'optional', 'utils', '4316', 'Bdale Garbee ', 'i386', 'amanda', '1:2.6.1p1-2', 'pool/main/a/amanda/amanda-common_2.6.1p1-2_i386.deb', '1505410', 'Advanced Maryland Automatic Network Disk Archiver (Libs)', '');
INSERT INTO `packages_plain` VALUES ('531', 'amanda-server', 'optional', 'utils', '1296', 'Bdale Garbee ', 'i386', 'amanda', '1:2.6.1p1-2', 'pool/main/a/amanda/amanda-server_2.6.1p1-2_i386.deb', '436580', 'Advanced Maryland Automatic Network Disk Archiver (Server)', '');
INSERT INTO `packages_plain` VALUES ('532', 'amap-align', 'optional', 'science', '256', 'Debian-Med Packaging Team ', 'i386', '', '2.2-1', 'pool/main/a/amap-align/amap-align_2.2-1_i386.deb', '127424', 'Protein multiple alignment by sequence annealing', 'http://bio.math.berkeley.edu/amap/');
INSERT INTO `packages_plain` VALUES ('533', 'python-amara', 'extra', 'python', '284', 'David Villa Alises ', 'all', 'amara', '1.2a2-1', 'pool/main/a/amara/python-amara_1.2a2-1_all.deb', '53270', 'Amara is a pythonic XML toolkit', '');
INSERT INTO `packages_plain` VALUES ('534', 'amarok-common', 'optional', 'sound', '9124', 'Modestas Vainius ', 'all', 'amarok', '2.2.0-1', 'pool/main/a/amarok/amarok-common_2.2.0-1_all.deb', '3305624', 'architecture independent files for Amarok', 'http://amarok.kde.org');
INSERT INTO `packages_plain` VALUES ('535', 'amarok-dbg', 'extra', 'debug', '112816', 'Modestas Vainius ', 'i386', 'amarok', '2.2.0-1', 'pool/main/a/amarok/amarok-dbg_2.2.0-1_i386.deb', '43865924', 'debugging symbols for Amarok', 'http://amarok.kde.org');
INSERT INTO `packages_plain` VALUES ('536', 'amarok-utils', 'optional', 'utils', '496', 'Modestas Vainius ', 'i386', 'amarok', '2.2.0-1', 'pool/main/a/amarok/amarok-utils_2.2.0-1_i386.deb', '247498', 'utilities for Amarok media player', 'http://amarok.kde.org');
INSERT INTO `packages_plain` VALUES ('537', 'amarok', 'optional', 'sound', '18900', 'Modestas Vainius ', 'i386', '', '2.2.0-1', 'pool/main/a/amarok/amarok_2.2.0-1_i386.deb', '7154388', 'easy to use media player based on the KDE 4 technology platform', 'http://amarok.kde.org');
INSERT INTO `packages_plain` VALUES ('538', 'amavisd-new-milter', 'extra', 'mail', '128', 'Brian May ', 'i386', 'amavisd-new', '1:2.6.4-1', 'pool/main/a/amavisd-new/amavisd-new-milter_2.6.4-1_i386.deb', '34884', 'Interface between sendmail-milter and amavisd-new', '');
INSERT INTO `packages_plain` VALUES ('539', 'amavisd-new', 'extra', 'mail', '2364', 'Brian May ', 'all', '', '1:2.6.4-1', 'pool/main/a/amavisd-new/amavisd-new_2.6.4-1_all.deb', '888192', 'Interface between MTA and virus scanner/content filters', '');
INSERT INTO `packages_plain` VALUES ('540', 'amb-plugins', 'extra', 'sound', '64', 'Debian Multimedia Team ', 'i386', '', '0.3.0-1', 'pool/main/a/amb-plugins/amb-plugins_0.3.0-1_i386.deb', '17692', 'ambisonics LADPSA plugins', '');
INSERT INTO `packages_plain` VALUES ('541', 'amd64-libs-dev', 'optional', 'libdevel', '144', 'Daniel Jacobowitz ', 'i386', 'amd64-libs', '1.4+nmu1', 'pool/main/a/amd64-libs/amd64-libs-dev_1.4+nmu1_i386.deb', '31328', 'Amd64 development libraries and headers for use on i386/x86_64 systems', '');
INSERT INTO `packages_plain` VALUES ('542', 'amd64-libs', 'optional', 'libs', '140', 'Daniel Jacobowitz ', 'i386', '', '1.4+nmu1', 'pool/main/a/amd64-libs/amd64-libs_1.4+nmu1_i386.deb', '33800', 'Amd64 shared libraries for use on i386/x86_64 systems', '');
INSERT INTO `packages_plain` VALUES ('543', 'amide', 'optional', 'graphics', '3884', 'Dominique Belhachemi ', 'i386', '', '0.9.1-5', 'pool/main/a/amide/amide_0.9.1-5_i386.deb', '976242', 'software for Medical Imaging', 'http://amide.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('544', 'amideco', 'optional', 'utils', '68', 'Uwe Hermann ', 'i386', '', '0.31e-3', 'pool/main/a/amideco/amideco_0.31e-3_i386.deb', '11472', 'Decompress flashfiles equipped with an AMI BIOS', 'http://www.kaos.ru/biosgfx/');
INSERT INTO `packages_plain` VALUES ('545', 'amiga-fdisk-cross', 'extra', 'admin', '84', 'Christian T. Steigies ', 'i386', 'amiga-fdisk', '0.04-14', 'pool/main/a/amiga-fdisk/amiga-fdisk-cross_0.04-14_i386.deb', '18590', 'Partition editor for Amiga partitions (cross version)', 'https://alioth.debian.org/projects/amiga-fdisk/');
INSERT INTO `packages_plain` VALUES ('546', 'amora-server', 'extra', 'x11', '104', 'Axel Beckert ', 'i386', 'amora-server (1.1-1)', '1.1-1+b1', 'pool/main/a/amora-server/amora-server_1.1-1+b1_i386.deb', '15686', 'use a bluetooth enabled mobile phone as desktop remote control', 'http://amora.googlecode.com/');
INSERT INTO `packages_plain` VALUES ('547', 'ampache-themes', 'extra', 'web', '7684', 'Charlie Smotherman ', 'all', '', '3.4.3-1', 'pool/main/a/ampache-themes/ampache-themes_3.4.3-1_all.deb', '2965628', 'Themes for Ampache', 'http://www.ampache.org');
INSERT INTO `packages_plain` VALUES ('548', 'ampache', 'optional', 'web', '8788', 'Charlie Smotherman ', 'all', '', '3.5.1-2', 'pool/main/a/ampache/ampache_3.5.1-2_all.deb', '1781492', 'web-based audio file management system', 'http://www.ampache.org');
INSERT INTO `packages_plain` VALUES ('549', 'amphetamine-data', 'optional', 'games', '1956', 'Debian Games Team ', 'all', '', '0.8.7-12', 'pool/main/a/amphetamine-data/amphetamine-data_0.8.7-12_all.deb', '944964', 'data files for the game \"Amphetamine\"', '');
INSERT INTO `packages_plain` VALUES ('550', 'amphetamine', 'optional', 'games', '316', 'Debian Games Team ', 'i386', '', '0.8.10-14', 'pool/main/a/amphetamine/amphetamine_0.8.10-14_i386.deb', '100562', 'jump\'n run game with unique visual effects', 'http://homepage.hispeed.ch/loehrer/amph/amph.html');
INSERT INTO `packages_plain` VALUES ('551', 'ample', 'optional', 'sound', '184', 'Rene Mayorga ', 'i386', '', '0.5.7-6', 'pool/main/a/ample/ample_0.5.7-6_i386.deb', '38890', 'A simple MP3 server easy to use', 'http://ample.sourceforge.net');
INSERT INTO `packages_plain` VALUES ('552', 'libamrita-ruby1.8', 'optional', 'ruby', '1532', 'TANIGUCHI Takaki ', 'all', 'amrita', '1.0.2-8', 'pool/main/a/amrita/libamrita-ruby1.8_1.0.2-8_all.deb', '143748', 'HTML/XML template library for Ruby 1.8', 'http://amrita.sourceforge.jp/');
INSERT INTO `packages_plain` VALUES ('553', 'ams', 'optional', 'sound', '1528', 'Debian Multimedia Team ', 'i386', '', '1.8.8~rc2-3.1', 'pool/main/a/ams/ams_1.8.8~rc2-3.1_i386.deb', '384768', 'Realtime modular synthesizer for ALSA', '');
INSERT INTO `packages_plain` VALUES ('554', 'amsn-data', 'optional', 'x11', '10492', 'Muammar El Khatib ', 'all', 'amsn', '0.97.2~debian-3', 'pool/main/a/amsn/amsn-data_0.97.2~debian-3_all.deb', '3254124', 'Data files for aMSN', 'http://amsn.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('555', 'amsn', 'optional', 'x11', '860', 'Muammar El Khatib ', 'i386', '', '0.97.2~debian-3', 'pool/main/a/amsn/amsn_0.97.2~debian-3_i386.deb', '269736', 'An MSN messenger written in Tcl', 'http://amsn.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('556', 'amsynth', 'optional', 'sound', '716', 'Debian Multimedia Team ', 'i386', '', '1.2.0-4', 'pool/main/a/amsynth/amsynth_1.2.0-4_i386.deb', '266808', 'two oscillator software synthesizer', '');
INSERT INTO `packages_plain` VALUES ('557', 'amtterm', 'extra', 'net', '92', 'Reinhard Tartler ', 'i386', '', '1.1-1', 'pool/main/a/amtterm/amtterm_1.1-1_i386.deb', '18134', 'Serial-over-lan (sol) client for Intel AMT, console version', '');
INSERT INTO `packages_plain` VALUES ('558', 'gamt', 'extra', 'net', '92', 'Reinhard Tartler ', 'i386', 'amtterm', '1.1-1', 'pool/main/a/amtterm/gamt_1.1-1_i386.deb', '20152', 'Serial-over-lan (sol) client for Intel AMT, gtk version', '');
INSERT INTO `packages_plain` VALUES ('559', 'amule-emc', 'optional', 'utils', '80', 'Sandro Tosi ', 'i386', '', '0.5.2-2', 'pool/main/a/amule-emc/amule-emc_0.5.2-2_i386.deb', '16046', 'lists ed2k links inside emulecollection files', 'http://code.google.com/p/amule-emc/');
INSERT INTO `packages_plain` VALUES ('560', 'amule-common', 'optional', 'net', '6456', 'Adeodato SimГѓВі ', 'all', 'amule', '2.2.5-1.1', 'pool/main/a/amule/amule-common_2.2.5-1.1_all.deb', '2425196', 'common files for the rest of aMule packages', 'http://www.amule.org');
INSERT INTO `packages_plain` VALUES ('561', 'amule-daemon', 'optional', 'net', '2900', 'Adeodato SimГѓВі ', 'i386', 'amule', '2.2.5-1.1', 'pool/main/a/amule/amule-daemon_2.2.5-1.1_i386.deb', '1172070', 'non-graphic version of aMule, a client for the eD2k and Kad networks', 'http://www.amule.org');
INSERT INTO `packages_plain` VALUES ('562', 'amule-utils-gui', 'optional', 'net', '3348', 'Adeodato SimГѓВі ', 'i386', 'amule', '2.2.5-1.1', 'pool/main/a/amule/amule-utils-gui_2.2.5-1.1_i386.deb', '1279660', 'graphic utilities for aMule', 'http://www.amule.org');
INSERT INTO `packages_plain` VALUES ('563', 'amule-utils', 'optional', 'net', '880', 'Adeodato SimГѓВі ', 'i386', 'amule', '2.2.5-1.1', 'pool/main/a/amule/amule-utils_2.2.5-1.1_i386.deb', '453092', 'utilities for aMule (command-line version)', 'http://www.amule.org');
INSERT INTO `packages_plain` VALUES ('564', 'amule', 'optional', 'net', '4460', 'Adeodato SimГѓВі ', 'i386', '', '2.2.5-1.1', 'pool/main/a/amule/amule_2.2.5-1.1_i386.deb', '1837034', 'client for the eD2k and Kad networks, like eMule', 'http://www.amule.org');
INSERT INTO `packages_plain` VALUES ('565', 'an', 'optional', 'games', '84', 'Paul Martin ', 'i386', '', '0.95-3.1', 'pool/main/a/an/an_0.95-3.1_i386.deb', '13830', 'very fast anagram generator', '');
INSERT INTO `packages_plain` VALUES ('566', 'anacron', 'optional', 'admin', '212', 'Peter Eisentraut ', 'i386', '', '2.3-14', 'pool/main/a/anacron/anacron_2.3-14_i386.deb', '30144', 'cron-like program that doesn\'t go by time', '');
INSERT INTO `packages_plain` VALUES ('567', 'analog', 'optional', 'web', '4572', 'Bradley Smith ', 'i386', '', '2:6.0-19', 'pool/main/a/analog/analog_6.0-19_i386.deb', '1367292', 'web server log analyzer', 'http://www.analog.cx/');
INSERT INTO `packages_plain` VALUES ('568', 'anarchism', 'optional', 'doc', '13524', 'Ed Boraas ', 'all', '', '11.7-1', 'pool/main/a/anarchism/anarchism_11.7-1_all.deb', '6623686', 'An exhaustive exploration of Anarchist theory and practice', '');
INSERT INTO `packages_plain` VALUES ('569', 'and', 'extra', 'misc', '132', 'Jerome Warnier ', 'i386', '', '1.2.2-2.1', 'pool/main/a/and/and_1.2.2-2.1_i386.deb', '25978', 'Auto Nice Daemon', '');
INSERT INTO `packages_plain` VALUES ('570', 'angband-doc', 'optional', 'doc', '3668', 'Manoj Srivastava ', 'all', '', '3.0.3.5', 'pool/main/a/angband-doc/angband-doc_3.0.3.5_all.deb', '943562', 'Documentation for the roguelike game Angband.', 'ftp://clockwork.dementia.org/angband');
INSERT INTO `packages_plain` VALUES ('571', 'angband', 'optional', 'games', '4224', 'Chris Carr ', 'i386', '', '1:3.1.1.1626-1', 'pool/main/a/angband/angband_3.1.1.1626-1_i386.deb', '1756782', 'A single-player, text-based, dungeon simulation game.', '');
INSERT INTO `packages_plain` VALUES ('572', 'angrydd', 'optional', 'games', '5712', 'Daniel Watkins ', 'all', '', '1.0.1-8', 'pool/main/a/angrydd/angrydd_1.0.1-8_all.deb', '4694208', 'Angry Drunken Dwarves - falling blocks puzzle game', 'http://www.sacredchao.net/~piman/angrydd/');
INSERT INTO `packages_plain` VALUES ('573', 'animals', 'optional', 'games', '96', 'Jim Lynch ', 'i386', '', '20031130-2.4', 'pool/main/a/animals/animals_20031130-2.4_i386.deb', '18526', 'Traditional AI animal guessing engine using a binary tree DB', '');
INSERT INTO `packages_plain` VALUES ('574', 'anjuta-common', 'optional', 'devel', '19340', 'Rob Bradford ', 'all', 'anjuta', '2:2.26.2.2-2', 'pool/main/a/anjuta/anjuta-common_2.26.2.2-2_all.deb', '6148318', 'A GNOME development IDE, for C/C++ - data files', 'http://www.anjuta.org');
INSERT INTO `packages_plain` VALUES ('575', 'anjuta-dbg', 'extra', 'debug', '10920', 'Rob Bradford ', 'i386', 'anjuta', '2:2.26.2.2-2', 'pool/main/a/anjuta/anjuta-dbg_2.26.2.2-2_i386.deb', '4580682', 'A GNOME development IDE, for C/C++ - debug files', 'http://www.anjuta.org');
INSERT INTO `packages_plain` VALUES ('576', 'anjuta-dev', 'optional', 'devel', '1032', 'Rob Bradford ', 'i386', 'anjuta', '2:2.26.2.2-2', 'pool/main/a/anjuta/anjuta-dev_2.26.2.2-2_i386.deb', '424110', 'A GNOME development IDE, for C/C++ - development files', 'http://www.anjuta.org');
INSERT INTO `packages_plain` VALUES ('577', 'anjuta', 'optional', 'gnome', '5564', 'Rob Bradford ', 'i386', '', '2:2.26.2.2-2', 'pool/main/a/anjuta/anjuta_2.26.2.2-2_i386.deb', '2465868', 'A GNOME development IDE, for C/C++', 'http://www.anjuta.org');
INSERT INTO `packages_plain` VALUES ('578', 'anki', 'optional', 'misc', '3028', 'Andreas Bombe ', 'all', '', '0.9.9.7.8-1', 'pool/main/a/anki/anki_0.9.9.7.8-1_all.deb', '956882', 'flashcard learning program with special support for Japanese', 'http://ichi2.net/anki');
INSERT INTO `packages_plain` VALUES ('579', 'ann-tools', 'optional', 'math', '92', 'Debian Scientific Computing Team ', 'i386', 'ann', '1.1.1+doc-2.1', 'pool/main/a/ann/ann-tools_1.1.1+doc-2.1_i386.deb', '13898', 'Approximate Nearest Neighbor Searching library (tools)', 'http://www.cs.umd.edu/~mount/ANN/');
INSERT INTO `packages_plain` VALUES ('580', 'libann-dev', 'optional', 'libdevel', '572', 'Debian Scientific Computing Team ', 'i386', 'ann', '1.1.1+doc-2.1', 'pool/main/a/ann/libann-dev_1.1.1+doc-2.1_i386.deb', '372234', 'Approximate Nearest Neighbor Searching library (development files)', 'http://www.cs.umd.edu/~mount/ANN/');
INSERT INTO `packages_plain` VALUES ('581', 'libann0', 'optional', 'libs', '116', 'Debian Scientific Computing Team ', 'i386', 'ann', '1.1.1+doc-2.1', 'pool/main/a/ann/libann0_1.1.1+doc-2.1_i386.deb', '29252', 'Approximate Nearest Neighbor Searching library', 'http://www.cs.umd.edu/~mount/ANN/');
INSERT INTO `packages_plain` VALUES ('582', 'anon-proxy', 'optional', 'web', '384', 'David Spreen ', 'i386', '', '00.05.38+20081230-1.1', 'pool/main/a/anon-proxy/anon-proxy_00.05.38+20081230-1.1_i386.deb', '133376', 'Proxy to surf the web anonymously', 'http://anon.inf.tu-dresden.de/');
INSERT INTO `packages_plain` VALUES ('583', 'ant-contrib', 'extra', 'java', '608', 'Debian Java Maintainers ', 'all', '', '1.0~b3+svn177-1', 'pool/main/a/ant-contrib/ant-contrib_1.0~b3+svn177-1_all.deb', '265184', 'collection of tasks, types and other tools for Apache Ant', 'http://ant-contrib.sourceforge.net');
INSERT INTO `packages_plain` VALUES ('584', 'ant-phone', 'extra', 'net', '512', 'Roland Stigge ', 'i386', '', '0.2.1-1', 'pool/main/a/ant-phone/ant-phone_0.2.1-1_i386.deb', '115954', 'An interactive ISDN telephone application', 'http://www.antcom.de/');
INSERT INTO `packages_plain` VALUES ('585', 'ant-doc', 'optional', 'doc', '35780', 'Debian Java Maintainers ', 'all', 'ant', '1.7.1-4', 'pool/main/a/ant/ant-doc_1.7.1-4_all.deb', '3269036', 'Java based build tool like make - API documentation and manual', 'http://ant.apache.org/');
INSERT INTO `packages_plain` VALUES ('586', 'ant-gcj', 'optional', 'java', '3916', 'Debian Java Maintainers ', 'i386', 'ant', '1.7.1-4', 'pool/main/a/ant/ant-gcj_1.7.1-4_i386.deb', '1208244', 'Java based build tool like make', 'http://ant.apache.org/');
INSERT INTO `packages_plain` VALUES ('587', 'ant-optional-gcj', 'optional', 'java', '2232', 'Debian Java Maintainers ', 'i386', 'ant', '1.7.1-4', 'pool/main/a/ant/ant-optional-gcj_1.7.1-4_i386.deb', '656772', 'Java based build tool like make - API documentation and manual', 'http://ant.apache.org/');
INSERT INTO `packages_plain` VALUES ('588', 'ant-optional', 'optional', 'java', '1180', 'Debian Java Maintainers ', 'all', 'ant', '1.7.1-4', 'pool/main/a/ant/ant-optional_1.7.1-4_all.deb', '657230', 'Java based build tool like make - optional libraries', 'http://ant.apache.org/');
INSERT INTO `packages_plain` VALUES ('589', 'ant', 'optional', 'java', '1548', 'Debian Java Maintainers ', 'all', '', '1.7.1-4', 'pool/main/a/ant/ant_1.7.1-4_all.deb', '1297496', 'Java based build tool like make', 'http://ant.apache.org/');
INSERT INTO `packages_plain` VALUES ('590', 'anteater', 'optional', 'mail', '304', 'Andrea Capriotti ', 'i386', '', '0.4.5-8', 'pool/main/a/anteater/anteater_0.4.5-8_i386.deb', '113950', 'MTA log analyser written 100% in C++', '');
INSERT INTO `packages_plain` VALUES ('591', 'antennavis', 'optional', 'hamradio', '268', 'Debian QA Group ', 'i386', '', '0.3-6', 'pool/main/a/antennavis/antennavis_0.3-6_i386.deb', '54346', 'antenna visualization software', '');
INSERT INTO `packages_plain` VALUES ('592', 'anthy-el', 'optional', 'lisp', '140', 'NOKUBI Takatsugu ', 'all', 'anthy', '9100e-3.2', 'pool/main/a/anthy/anthy-el_9100e-3.2_all.deb', '36204', 'input method for Japanese - elisp frontend', '');
INSERT INTO `packages_plain` VALUES ('593', 'anthy', 'optional', 'utils', '12876', 'NOKUBI Takatsugu ', 'i386', '', '9100e-3.2', 'pool/main/a/anthy/anthy_9100e-3.2_i386.deb', '3372644', 'input method for Japanese - backend, dictionary and utility', '');
INSERT INTO `packages_plain` VALUES ('594', 'libanthy-dev', 'optional', 'libdevel', '548', 'NOKUBI Takatsugu ', 'i386', 'anthy', '9100e-3.2', 'pool/main/a/anthy/libanthy-dev_9100e-3.2_i386.deb', '197582', 'input method for Japanese - development files', '');
INSERT INTO `packages_plain` VALUES ('595', 'libanthy0', 'optional', 'libs', '392', 'NOKUBI Takatsugu ', 'i386', 'anthy', '9100e-3.2', 'pool/main/a/anthy/libanthy0_9100e-3.2_i386.deb', '166426', 'input method for Japanese - runtime library', '');
INSERT INTO `packages_plain` VALUES ('596', 'antigravitaattori', 'optional', 'games', '1896', 'Debian Games Team ', 'i386', 'antigrav (0.0.3-2)', '0.0.3-2+b1', 'pool/main/a/antigrav/antigravitaattori_0.0.3-2+b1_i386.deb', '1492934', 'Multiplayer flying saucer racing game', 'http://www.luolamies.org/software/antigrav/');
INSERT INTO `packages_plain` VALUES ('597', 'antiword', 'optional', 'text', '772', 'Erik Schanze ', 'i386', '', '0.37-6', 'pool/main/a/antiword/antiword_0.37-6_i386.deb', '150904', 'Converts MS Word files to text, PS and PDF', 'http://www.winfield.demon.nl/');
INSERT INTO `packages_plain` VALUES ('598', 'antlr-doc', 'optional', 'doc', '3520', 'Debian Java Maintainers ', 'all', 'antlr', '2.7.7-14', 'pool/main/a/antlr/antlr-doc_2.7.7-14_all.deb', '891774', 'language tool for constructing recognizers, compilers etc', 'http://www.antlr2.org/');
INSERT INTO `packages_plain` VALUES ('599', 'antlr', 'optional', 'devel', '68', 'Debian Java Maintainers ', 'all', '', '2.7.7-14', 'pool/main/a/antlr/antlr_2.7.7-14_all.deb', '10932', 'language tool for constructing recognizers, compilers etc', 'http://www.antlr2.org/');
INSERT INTO `packages_plain` VALUES ('600', 'cantlr', 'optional', 'devel', '60', 'Debian Java Maintainers ', 'i386', 'antlr', '2.7.7-14', 'pool/main/a/antlr/cantlr_2.7.7-14_i386.deb', '10412', 'language tool for constructing recognizers, compilers etc', 'http://www.antlr2.org/');
INSERT INTO `packages_plain` VALUES ('601', 'libantlr-dev', 'optional', 'libdevel', '1388', 'Debian Java Maintainers ', 'i386', 'antlr', '2.7.7-14', 'pool/main/a/antlr/libantlr-dev_2.7.7-14_i386.deb', '316212', 'language tool for constructing recognizers, compilers etc', 'http://www.antlr2.org/');
INSERT INTO `packages_plain` VALUES ('602', 'libantlr-java-gcj', 'optional', 'devel', '1996', 'Debian Java Maintainers ', 'i386', 'antlr', '2.7.7-14', 'pool/main/a/antlr/libantlr-java-gcj_2.7.7-14_i386.deb', '571250', 'language tool for constructing recognizers, compilers etc', 'http://www.antlr2.org/');
INSERT INTO `packages_plain` VALUES ('603', 'libantlr-java', 'optional', 'java', '508', 'Debian Java Maintainers ', 'all', 'antlr', '2.7.7-14', 'pool/main/a/antlr/libantlr-java_2.7.7-14_all.deb', '430744', 'language tool for constructing recognizers, compilers etc (java library)', 'http://www.antlr2.org/');
INSERT INTO `packages_plain` VALUES ('604', 'libantlr2.7-cil', 'optional', 'cli-mono', '188', 'Debian Java Maintainers ', 'all', 'antlr', '2.7.7-14', 'pool/main/a/antlr/libantlr2.7-cil_2.7.7-14_all.deb', '47948', 'language tool for constructing recognizers, compilers etc', 'http://www.antlr2.org/');
INSERT INTO `packages_plain` VALUES ('605', 'python-antlr', 'optional', 'python', '144', 'Debian Java Maintainers ', 'all', 'antlr', '2.7.7-14', 'pool/main/a/antlr/python-antlr_2.7.7-14_all.deb', '23396', 'language tool for constructing recognizers, compilers etc', 'http://www.antlr2.org/');
INSERT INTO `packages_plain` VALUES ('606', 'antlr3-gcj', 'optional', 'devel', '1696', 'Debian Java Maintainers ', 'i386', 'antlr3', '3.0.1+dfsg-4', 'pool/main/a/antlr3/antlr3-gcj_3.0.1+dfsg-4_i386.deb', '494584', 'language tool for constructing recognizers, compilers etc (native code)', '');
INSERT INTO `packages_plain` VALUES ('607', 'antlr3', 'optional', 'devel', '592', 'Debian Java Maintainers ', 'all', '', '3.0.1+dfsg-4', 'pool/main/a/antlr3/antlr3_3.0.1+dfsg-4_all.deb', '532970', 'language tool for constructing recognizers, compilers etc', '');
INSERT INTO `packages_plain` VALUES ('608', 'anubis', 'optional', 'net', '916', 'Krzysztof Burghardt ', 'i386', '', '4.1.1+dfsg1-3', 'pool/main/a/anubis/anubis_4.1.1+dfsg1-3_i386.deb', '244644', 'an SMTP message submission daemon', 'http://www.gnu.org/software/anubis/');
INSERT INTO `packages_plain` VALUES ('609', 'anypaper', 'extra', 'utils', '148', 'Alejandro Garrido Mota ', 'i386', '', '1.4-1', 'pool/main/a/anypaper/anypaper_1.4-1_i386.deb', '47172', 'front-end for wallpapersetter', 'http://anypaper.sourceforge.net');
INSERT INTO `packages_plain` VALUES ('610', 'anyremote-doc', 'extra', 'doc', '2196', 'Juan Angulo Moreno ', 'all', 'anyremote', '4.18.1-1', 'pool/main/a/anyremote/anyremote-doc_4.18.1-1_all.deb', '1232546', 'Documentation for anyremote', 'http://anyremote.sourceforge.net');
INSERT INTO `packages_plain` VALUES ('611', 'anyremote', 'extra', 'utils', '1172', 'Juan Angulo Moreno ', 'i386', 'anyremote (4.18.1-1)', '4.18.1-1+b1', 'pool/main/a/anyremote/anyremote_4.18.1-1+b1_i386.deb', '282294', 'Remote control daemon for applications using Bluetooth, IrDA or WiFi', 'http://anyremote.sourceforge.net');
INSERT INTO `packages_plain` VALUES ('612', 'anyremote2html', 'extra', 'web', '748', 'Philipp Huebner ', 'all', '', '1.0-1', 'pool/main/a/anyremote2html/anyremote2html_1.0-1_all.deb', '259536', 'web interface for anyRemote acting as HTTP server', 'http://anyremote.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('613', 'aoetools', 'optional', 'admin', '196', 'David MartГѓВ­nez Moreno ', 'i386', '', '30-3', 'pool/main/a/aoetools/aoetools_30-3_i386.deb', '34146', 'tools to assist in using ATA over Ethernet', 'http://aoetools.sf.net');
INSERT INTO `packages_plain` VALUES ('614', 'aoeui', 'optional', 'editors', '172', 'Ryan Kavanagh ', 'i386', '', '1.4-1', 'pool/main/a/aoeui/aoeui_1.4-1_i386.deb', '67572', 'lightweight, unobtrusive, Dvorak-optimized text editor', 'http://code.google.com/p/aoeui/');
INSERT INTO `packages_plain` VALUES ('615', 'aolserver4-nsimap', 'optional', 'httpd', '64', 'Riccardo Setti ', 'i386', '', '3.2.3-4', 'pool/main/a/aolserver4-nsimap/aolserver4-nsimap_3.2.3-4_i386.deb', '26380', 'This is AOLserver 4 module that implements IMAP4 interface', 'http://www.aolserver.com/');
INSERT INTO `packages_plain` VALUES ('616', 'aolserver4-nsldap', 'optional', 'httpd', '48', 'Riccardo Setti ', 'i386', '', '0.8-4', 'pool/main/a/aolserver4-nsldap/aolserver4-nsldap_0.8-4_i386.deb', '17122', 'AOLServer 4 module for LDAP', 'http://www.aolserver.com/');
INSERT INTO `packages_plain` VALUES ('617', 'aolserver4-nsmysql', 'optional', 'httpd', '100', 'Francesco Paolo Lovergine ', 'i386', 'aolserver4-nsmysql (0.6-9)', '0.6-9+b1', 'pool/main/a/aolserver4-nsmysql/aolserver4-nsmysql_0.6-9+b1_i386.deb', '23122', 'AOLserver 4 module: module for accessing MySQL databases', 'http://www.aolserver.com/');
INSERT INTO `packages_plain` VALUES ('618', 'aolserver4-nsopenssl', 'optional', 'httpd', '213', 'Francesco Paolo Lovergine ', 'i386', '', '3.0beta26-4', 'pool/main/a/aolserver4-nsopenssl/aolserver4-nsopenssl_3.0beta26-4_i386.deb', '74456', 'AOLserver 4 module: module for SSL mode', 'http://www.aolserver.com/');
INSERT INTO `packages_plain` VALUES ('619', 'aolserver4-nspostgres', 'optional', 'httpd', '60', 'Francesco Paolo Lovergine ', 'i386', '', '4.5-3', 'pool/main/a/aolserver4-nspostgres/aolserver4-nspostgres_4.5-3_i386.deb', '23690', 'AOLserver 4 module: Postgres connector', 'http://www.aolserver.com/');
INSERT INTO `packages_plain` VALUES ('620', 'aolserver4-nssha1', 'optional', 'httpd', '32', 'Francesco Paolo Lovergine ', 'i386', '', '0.1-3', 'pool/main/a/aolserver4-nssha1/aolserver4-nssha1_0.1-3_i386.deb', '8394', 'AOLserver4 module: performs SHA1 hashes Provides a Tcl', 'http://www.aolserver.com/');
INSERT INTO `packages_plain` VALUES ('621', 'aolserver4-nssqlite3', 'optional', 'net', '56', 'Francesco Paolo Lovergine ', 'i386', '', '0.9-2', 'pool/main/a/aolserver4-nssqlite3/aolserver4-nssqlite3_0.9-2_i386.deb', '17192', 'AOLserver 4 module: module for accessing SQLite 3 databases', 'http://www.aolserver.com/');
INSERT INTO `packages_plain` VALUES ('622', 'aolserver4-nsxml', 'optional', 'httpd', '24', 'Riccardo Setti ', 'i386', '', '1.5-2', 'pool/main/a/aolserver4-nsxml/aolserver4-nsxml_1.5-2_i386.deb', '5178', 'Module for XML support in aolsever4', '');
INSERT INTO `packages_plain` VALUES ('623', 'aolserver4-core-4.5.1', 'optional', 'web', '676', 'Francesco Paolo Lovergine ', 'i386', 'aolserver4', '4.5.1-8', 'pool/main/a/aolserver4/aolserver4-core-4.5.1_4.5.1-8_i386.deb', '307160', 'AOL web server version 4 - core libraries', 'http://www.aolserver.com/');
INSERT INTO `packages_plain` VALUES ('624', 'aolserver4-core', 'optional', 'httpd', '92', 'Francesco Paolo Lovergine ', 'all', 'aolserver4', '4.5.1-8', 'pool/main/a/aolserver4/aolserver4-core_4.5.1-8_all.deb', '70714', 'AOL Web Server 4 - transitional package', 'http://www.aolserver.com/');
INSERT INTO `packages_plain` VALUES ('625', 'aolserver4-daemon', 'optional', 'web', '752', 'Francesco Paolo Lovergine ', 'i386', 'aolserver4', '4.5.1-8', 'pool/main/a/aolserver4/aolserver4-daemon_4.5.1-8_i386.deb', '172266', 'AOL web server version 4 - program files', 'http://www.aolserver.com/');
INSERT INTO `packages_plain` VALUES ('626', 'aolserver4-dev', 'optional', 'httpd', '1956', 'Francesco Paolo Lovergine ', 'i386', 'aolserver4', '4.5.1-8', 'pool/main/a/aolserver4/aolserver4-dev_4.5.1-8_i386.deb', '956064', 'AOL web server version 4 - development files', 'http://www.aolserver.com/');
INSERT INTO `packages_plain` VALUES ('627', 'aolserver4-doc', 'optional', 'doc', '8033', 'Francesco Paolo Lovergine ', 'all', 'aolserver4', '4.5.1-8', 'pool/main/a/aolserver4/aolserver4-doc_4.5.1-8_all.deb', '3324132', 'AOL web server version 4 - documentation', 'http://www.aolserver.com/');
INSERT INTO `packages_plain` VALUES ('628', 'ap-utils', 'optional', 'net', '1016', 'Ben Hutchings ', 'i386', '', '1.5-2', 'pool/main/a/ap-utils/ap-utils_1.5-2_i386.deb', '393730', 'Access Point SNMP Utils for Linux', 'http://ap-utils.polesye.net/');
INSERT INTO `packages_plain` VALUES ('629', 'libapache2-redirtoservname', 'optional', 'httpd', '80', 'Simon Richter ', 'i386', 'apache2-redirtoservname', '0.1.2-3', 'pool/main/a/apache2-redirtoservname/libapache2-redirtoservname_0.1.2-3_i386.deb', '5204', 'Apache 2 module to redirect users to the canonical hostname', '');
INSERT INTO `packages_plain` VALUES ('630', 'apache2-dbg', 'extra', 'debug', '6808', 'Debian Apache Maintainers ', 'i386', 'apache2', '2.2.14-2', 'pool/main/a/apache2/apache2-dbg_2.2.14-2_i386.deb', '2695358', 'Apache debugging symbols', 'http://httpd.apache.org/');
INSERT INTO `packages_plain` VALUES ('631', 'apache2-doc', 'optional', 'doc', '12212', 'Debian Apache Maintainers ', 'all', 'apache2', '2.2.14-2', 'pool/main/a/apache2/apache2-doc_2.2.14-2_all.deb', '2281508', 'Apache HTTP Server documentation', 'http://httpd.apache.org/');
INSERT INTO `packages_plain` VALUES ('632', 'apache2-mpm-event', 'optional', 'httpd', '72', 'Debian Apache Maintainers ', 'i386', 'apache2', '2.2.14-2', 'pool/main/a/apache2/apache2-mpm-event_2.2.14-2_i386.deb', '2292', 'Apache HTTP Server - event driven model', 'http://httpd.apache.org/');
INSERT INTO `packages_plain` VALUES ('633', 'apache2-mpm-itk', 'extra', 'httpd', '72', 'Debian Apache Maintainers ', 'i386', 'apache2', '2.2.14-2', 'pool/main/a/apache2/apache2-mpm-itk_2.2.14-2_i386.deb', '2318', 'multiuser MPM for Apache 2.2', 'http://httpd.apache.org/');
INSERT INTO `packages_plain` VALUES ('634', 'apache2-mpm-prefork', 'optional', 'httpd', '72', 'Debian Apache Maintainers ', 'i386', 'apache2', '2.2.14-2', 'pool/main/a/apache2/apache2-mpm-prefork_2.2.14-2_i386.deb', '2318', 'Apache HTTP Server - traditional non-threaded model', 'http://httpd.apache.org/');
INSERT INTO `packages_plain` VALUES ('635', 'apache2-mpm-worker', 'optional', 'httpd', '72', 'Debian Apache Maintainers ', 'i386', 'apache2', '2.2.14-2', 'pool/main/a/apache2/apache2-mpm-worker_2.2.14-2_i386.deb', '2262', 'Apache HTTP Server - high speed threaded model', 'http://httpd.apache.org/');
INSERT INTO `packages_plain` VALUES ('636', 'apache2-prefork-dev', 'extra', 'httpd', '692', 'Debian Apache Maintainers ', 'i386', 'apache2', '2.2.14-2', 'pool/main/a/apache2/apache2-prefork-dev_2.2.14-2_i386.deb', '138034', 'Apache development headers - non-threaded MPM', 'http://httpd.apache.org/');
INSERT INTO `packages_plain` VALUES ('637', 'apache2-suexec-custom', 'extra', 'httpd', '196', 'Debian Apache Maintainers ', 'i386', 'apache2', '2.2.14-2', 'pool/main/a/apache2/apache2-suexec-custom_2.2.14-2_i386.deb', '93138', 'Configurable suexec program for Apache 2 mod_suexec', 'http://httpd.apache.org/');
INSERT INTO `packages_plain` VALUES ('638', 'apache2-suexec', 'optional', 'httpd', '176', 'Debian Apache Maintainers ', 'i386', 'apache2', '2.2.14-2', 'pool/main/a/apache2/apache2-suexec_2.2.14-2_i386.deb', '91560', 'Standard suexec program for Apache 2 mod_suexec', 'http://httpd.apache.org/');
INSERT INTO `packages_plain` VALUES ('639', 'apache2-threaded-dev', 'extra', 'httpd', '700', 'Debian Apache Maintainers ', 'i386', 'apache2', '2.2.14-2', 'pool/main/a/apache2/apache2-threaded-dev_2.2.14-2_i386.deb', '139228', 'Apache development headers - threaded MPM', 'http://httpd.apache.org/');
INSERT INTO `packages_plain` VALUES ('640', 'apache2-utils', 'optional', 'httpd', '348', 'Debian Apache Maintainers ', 'i386', 'apache2', '2.2.14-2', 'pool/main/a/apache2/apache2-utils_2.2.14-2_i386.deb', '152992', 'utility programs for webservers', 'http://httpd.apache.org/');
INSERT INTO `packages_plain` VALUES ('641', 'apache2.2-bin', 'optional', 'httpd', '3208', 'Debian Apache Maintainers ', 'i386', 'apache2', '2.2.14-2', 'pool/main/a/apache2/apache2.2-bin_2.2.14-2_i386.deb', '1291480', 'Apache HTTP Server common binary files', 'http://httpd.apache.org/');
INSERT INTO `packages_plain` VALUES ('642', 'apache2.2-common', 'optional', 'httpd', '2092', 'Debian Apache Maintainers ', 'i386', 'apache2', '2.2.14-2', 'pool/main/a/apache2/apache2.2-common_2.2.14-2_i386.deb', '292588', 'Apache HTTP Server common files', 'http://httpd.apache.org/');
INSERT INTO `packages_plain` VALUES ('643', 'apache2', 'optional', 'httpd', '36', 'Debian Apache Maintainers ', 'i386', '', '2.2.14-2', 'pool/main/a/apache2/apache2_2.2.14-2_i386.deb', '1374', 'Apache HTTP Server metapackage', 'http://httpd.apache.org/');
INSERT INTO `packages_plain` VALUES ('644', 'apachetop', 'optional', 'admin', '112', 'Debian QA Group ', 'i386', '', '0.12.6-12', 'pool/main/a/apachetop/apachetop_0.12.6-12_i386.deb', '34574', 'Realtime Apache monitoring tool', 'http://www.webta.org/projects/apachetop/');
INSERT INTO `packages_plain` VALUES ('645', 'apbs', 'optional', 'science', '968', 'Debichem Team ', 'i386', '', '1.1.0-1', 'pool/main/a/apbs/apbs_1.1.0-1_i386.deb', '376404', 'Adaptive Poisson Boltzmann Solver', 'http://apbs.sourceforge.net');
INSERT INTO `packages_plain` VALUES ('646', 'apcalc-common', 'optional', 'math', '4028', 'Martin Buck ', 'all', 'apcalc', '2.12.3.3-1', 'pool/main/a/apcalc/apcalc-common_2.12.3.3-1_all.deb', '936938', 'Arbitrary precision calculator (common files)', 'http://www.isthe.com/chongo/tech/comp/calc/');
INSERT INTO `packages_plain` VALUES ('647', 'apcalc-dev', 'optional', 'devel', '1496', 'Martin Buck ', 'i386', 'apcalc', '2.12.3.3-1', 'pool/main/a/apcalc/apcalc-dev_2.12.3.3-1_i386.deb', '548366', 'Library for arbitrary precision arithmetic', 'http://www.isthe.com/chongo/tech/comp/calc/');
INSERT INTO `packages_plain` VALUES ('648', 'apcalc', 'optional', 'math', '684', 'Martin Buck ', 'i386', '', '2.12.3.3-1', 'pool/main/a/apcalc/apcalc_2.12.3.3-1_i386.deb', '304768', 'Arbitrary precision calculator (original name: calc)', 'http://www.isthe.com/chongo/tech/comp/calc/');
INSERT INTO `packages_plain` VALUES ('649', 'apcupsd-cgi', 'extra', 'web', '164', 'Debian QA Group ', 'i386', 'apcupsd', '3.14.6-3', 'pool/main/a/apcupsd/apcupsd-cgi_3.14.6-3_i386.deb', '52244', 'APC UPS Power Management (web interface)', 'http://www.apcupsd.com/');
INSERT INTO `packages_plain` VALUES ('650', 'apcupsd-doc', 'extra', 'doc', '34044', 'Debian QA Group ', 'all', 'apcupsd', '3.14.6-3', 'pool/main/a/apcupsd/apcupsd-doc_3.14.6-3_all.deb', '2600226', 'APC UPS Power Management (documentation/examples)', 'http://www.apcupsd.com/');
INSERT INTO `packages_plain` VALUES ('651', 'apcupsd', 'extra', 'admin', '768', 'Debian QA Group ', 'i386', '', '3.14.6-3', 'pool/main/a/apcupsd/apcupsd_3.14.6-3_i386.deb', '243706', 'APC UPS Power Management (daemon)', 'http://www.apcupsd.com/');
INSERT INTO `packages_plain` VALUES ('652', 'apel', 'optional', 'editors', '684', 'Tatsuya Kinoshita ', 'all', '', '10.7-3', 'pool/main/a/apel/apel_10.7-3_all.deb', '142722', 'portable library for emacsen', 'http://kanji.zinbun.kyoto-u.ac.jp/~tomo/elisp/APEL/');
INSERT INTO `packages_plain` VALUES ('653', 'apertium-dbus', 'extra', 'misc', '124', 'Francis Tyers ', 'i386', '', '0.1-1.1', 'pool/main/a/apertium-dbus/apertium-dbus_0.1-1.1_i386.deb', '9430', 'A D-Bus service for the Apertium machine translation system', 'http://www.apertium.org');
INSERT INTO `packages_plain` VALUES ('654', 'apertium-en-ca', 'extra', 'misc', '7060', 'Francis Tyers ', 'i386', '', '0.8.9-1', 'pool/main/a/apertium-en-ca/apertium-en-ca_0.8.9-1_i386.deb', '2852074', 'Apertium linguistic data to translate between English and Catalan', 'http://www.apertium.org');
INSERT INTO `packages_plain` VALUES ('655', 'apertium-en-es', 'extra', 'misc', '4740', 'Francis Tyers ', 'i386', '', '0.6.0-1.1', 'pool/main/a/apertium-en-es/apertium-en-es_0.6.0-1.1_i386.deb', '1555766', 'Apertium linguistic data to translate between English and Spanish', 'http://www.apertium.org');
INSERT INTO `packages_plain` VALUES ('656', 'apertium-eo-ca', 'extra', 'misc', '2816', 'Francis Tyers ', 'i386', '', '0.9.0-1.1', 'pool/main/a/apertium-eo-ca/apertium-eo-ca_0.9.0-1.1_i386.deb', '977266', 'Apertium linguistic data to translate between Esperanto and Catalan', 'http://www.apertium.org');
INSERT INTO `packages_plain` VALUES ('657', 'apertium-eo-es', 'extra', 'misc', '2940', 'Francis Tyers ', 'i386', '', '0.9.0-1.1', 'pool/main/a/apertium-eo-es/apertium-eo-es_0.9.0-1.1_i386.deb', '925118', 'Apertium linguistic data to translate between Esperanto and Spanish', 'http://www.apertium.org');
INSERT INTO `packages_plain` VALUES ('658', 'apertium-es-ca', 'extra', 'misc', '12408', 'Francis Tyers ', 'i386', '', '1.1.0-1', 'pool/main/a/apertium-es-ca/apertium-es-ca_1.1.0-1_i386.deb', '4236670', 'Apertium linguistic data to translate between Spanish and Catalan', 'http://www.apertium.org');
INSERT INTO `packages_plain` VALUES ('659', 'apertium-es-gl', 'extra', 'misc', '1676', 'Francis Tyers ', 'i386', '', '1.0.7-1', 'pool/main/a/apertium-es-gl/apertium-es-gl_1.0.7-1_i386.deb', '674500', 'Apertium linguistic data to translate between Spanish and Galician', 'http://www.apertium.org');
INSERT INTO `packages_plain` VALUES ('660', 'apertium-es-pt', 'optional', 'misc', '2868', 'Francis Tyers ', 'i386', '', '1.0.3-2.1', 'pool/main/a/apertium-es-pt/apertium-es-pt_1.0.3-2.1_i386.deb', '902996', 'Apertium linguistic data to translate between Spanish and Portuguese', 'http://www.apertium.org');
INSERT INTO `packages_plain` VALUES ('661', 'apertium-es-ro', 'extra', 'misc', '2844', 'Francis Tyers ', 'i386', '', '0.7.1-2.1', 'pool/main/a/apertium-es-ro/apertium-es-ro_0.7.1-2.1_i386.deb', '1139636', 'Apertium linguistic data to translate between Spanish and Romanian', 'http://www.apertium.org');
INSERT INTO `packages_plain` VALUES ('662', 'apertium-eu-es', 'extra', 'misc', '5048', 'Francis Tyers ', 'i386', '', '0.3.1-1', 'pool/main/a/apertium-eu-es/apertium-eu-es_0.3.1-1_i386.deb', '1603524', 'Apertium linguistic data to translate between Basque and Spanish', 'http://www.apertium.org');
INSERT INTO `packages_plain` VALUES ('663', 'apertium-fr-ca', 'optional', 'misc', '2680', 'Francis Tyers ', 'i386', '', '1.0.2-1', 'pool/main/a/apertium-fr-ca/apertium-fr-ca_1.0.2-1_i386.deb', '930554', 'Apertium linguistic data to translate between French and Catalan', 'http://www.apertium.org');
INSERT INTO `packages_plain` VALUES ('664', 'apertium-fr-es', 'extra', 'misc', '7636', 'Francis Tyers ', 'i386', '', '0.9.0-1', 'pool/main/a/apertium-fr-es/apertium-fr-es_0.9.0-1_i386.deb', '3762662', 'Apertium linguistic data to translate between French and Spanish', 'http://www.apertium.org');
INSERT INTO `packages_plain` VALUES ('665', 'apertium-oc-ca', 'extra', 'misc', '6776', 'Francis Tyers ', 'i386', '', '1.0.5-1.1', 'pool/main/a/apertium-oc-ca/apertium-oc-ca_1.0.5-1.1_i386.deb', '2657142', 'Apertium linguistic data to translate between Occitan and Catalan', 'http://www.apertium.org');
INSERT INTO `packages_plain` VALUES ('666', 'apertium-oc-es', 'extra', 'misc', '8764', 'Francis Tyers ', 'i386', '', '1.0.5-1.1', 'pool/main/a/apertium-oc-es/apertium-oc-es_1.0.5-1.1_i386.deb', '2550084', 'Apertium linguistic data to translate between Occitan and Spanish', 'http://www.apertium.org');
INSERT INTO `packages_plain` VALUES ('667', 'apertium-pt-ca', 'extra', 'misc', '1844', 'Francis Tyers ', 'i386', '', '0.8.1-1', 'pool/main/a/apertium-pt-ca/apertium-pt-ca_0.8.1-1_i386.deb', '559416', 'Apertium linguistic data to translate between Portuguese and Catalan', 'http://www.apertium.org');
INSERT INTO `packages_plain` VALUES ('668', 'apertium-pt-gl', 'extra', 'misc', '5328', 'Francis Tyers ', 'i386', '', '0.9.1-1', 'pool/main/a/apertium-pt-gl/apertium-pt-gl_0.9.1-1_i386.deb', '951234', 'Apertium linguistic data to translate between Portuguese and Galician', 'http://www.apertium.org');
INSERT INTO `packages_plain` VALUES ('669', 'apertium-tolk', 'extra', 'misc', '596', 'Francis Tyers ', 'i386', '', '0.2-2.1', 'pool/main/a/apertium-tolk/apertium-tolk_0.2-2.1_i386.deb', '29152', 'Graphical user interface for Apertium', 'http://www.apertium.org');
INSERT INTO `packages_plain` VALUES ('670', 'apertium', 'optional', 'misc', '1288', 'Francis Tyers ', 'i386', '', '3.1.0-1.1', 'pool/main/a/apertium/apertium_3.1.0-1.1_i386.deb', '349438', 'Shallow-transfer machine translation engine', 'http://www.apertium.org');
INSERT INTO `packages_plain` VALUES ('671', 'libapertium3-3.1-0-dev', 'optional', 'libdevel', '1568', 'Francis Tyers ', 'i386', 'apertium', '3.1.0-1.1', 'pool/main/a/apertium/libapertium3-3.1-0-dev_3.1.0-1.1_i386.deb', '468520', 'Development library for Apertium', 'http://www.apertium.org');
INSERT INTO `packages_plain` VALUES ('672', 'libapertium3-3.1-0', 'optional', 'libs', '872', 'Francis Tyers ', 'i386', 'apertium', '3.1.0-1.1', 'pool/main/a/apertium/libapertium3-3.1-0_3.1.0-1.1_i386.deb', '338538', 'Shared library for Apertium', 'http://www.apertium.org');
INSERT INTO `packages_plain` VALUES ('673', 'apf-firewall', 'optional', 'net', '436', 'Giuseppe Iuculano ', 'all', '', '9.7+rev1-1', 'pool/main/a/apf-firewall/apf-firewall_9.7+rev1-1_all.deb', '103934', 'easy iptables based firewall system', 'http://www.rfxn.com/projects/advanced-policy-firewall/');
INSERT INTO `packages_plain` VALUES ('674', 'apf-client', 'optional', 'net', '204', 'Juan A. Diaz ', 'i386', 'apf', '0.8.4-1', 'pool/main/a/apf/apf-client_0.8.4-1_i386.deb', '73298', 'Client for Active Port Forwarding', 'http://www.gray-world.net/pr_af.shtml');
INSERT INTO `packages_plain` VALUES ('675', 'apf-server', 'optional', 'net', '220', 'Juan A. Diaz ', 'i386', 'apf', '0.8.4-1', 'pool/main/a/apf/apf-server_0.8.4-1_i386.deb', '75946', 'Server for Active Port Forwarding', 'http://www.gray-world.net/pr_af.shtml');
INSERT INTO `packages_plain` VALUES ('676', 'apg', 'optional', 'admin', '200', 'Marc Haber ', 'i386', '', '2.2.3.dfsg.1-2', 'pool/main/a/apg/apg_2.2.3.dfsg.1-2_i386.deb', '52816', 'Automated Password Generator - Standalone version', '');
INSERT INTO `packages_plain` VALUES ('677', 'apgdiff', 'extra', 'misc', '128', 'Christoph Berg ', 'all', '', '1.3-3', 'pool/main/a/apgdiff/apgdiff_1.3-3_all.deb', '60608', 'Another PostgreSQL Diff Tool', 'http://apgdiff.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('678', 'libapiextractor-dbg', 'extra', 'debug', '6956', 'Didier Raboud ', 'i386', 'apiextractor', '0.3.1-1', 'pool/main/a/apiextractor/libapiextractor-dbg_0.3.1-1_i386.deb', '2533034', 'Debugging symbols for the library headers parser', 'http://www.pyside.org/home-binding/api-extractor/');
INSERT INTO `packages_plain` VALUES ('679', 'libapiextractor-dev', 'optional', 'libdevel', '184', 'Didier Raboud ', 'i386', 'apiextractor', '0.3.1-1', 'pool/main/a/apiextractor/libapiextractor-dev_0.3.1-1_i386.deb', '26702', 'Development files for the library headers parser', 'http://www.pyside.org/home-binding/api-extractor/');
INSERT INTO `packages_plain` VALUES ('680', 'libapiextractor0', 'optional', 'libs', '1148', 'Didier Raboud ', 'i386', 'apiextractor', '0.3.1-1', 'pool/main/a/apiextractor/libapiextractor0_0.3.1-1_i386.deb', '459612', 'Library headers parser that creates an API abstract representation', 'http://www.pyside.org/home-binding/api-extractor/');
INSERT INTO `packages_plain` VALUES ('681', 'apmd', 'optional', 'admin', '248', 'Anibal Monsalve Salazar ', 'i386', '', '3.2.2-14', 'pool/main/a/apmd/apmd_3.2.2-14_i386.deb', '54058', 'Utilities for Advanced Power Management (APM)', 'http://alumnit.ca/~apenwarr/apmd/');
INSERT INTO `packages_plain` VALUES ('682', 'libapm-dev', 'optional', 'libdevel', '76', 'Anibal Monsalve Salazar ', 'i386', 'apmd', '3.2.2-14', 'pool/main/a/apmd/libapm-dev_3.2.2-14_i386.deb', '26964', 'Library for interacting with APM driver in kernel', 'http://alumnit.ca/~apenwarr/apmd/');
INSERT INTO `packages_plain` VALUES ('683', 'libapm1', 'optional', 'libs', '80', 'Anibal Monsalve Salazar ', 'i386', 'apmd', '3.2.2-14', 'pool/main/a/apmd/libapm1_3.2.2-14_i386.deb', '26502', 'Library for interacting with APM driver in kernel', 'http://alumnit.ca/~apenwarr/apmd/');
INSERT INTO `packages_plain` VALUES ('684', 'xapm', 'optional', 'x11', '80', 'Anibal Monsalve Salazar ', 'i386', 'apmd', '3.2.2-14', 'pool/main/a/apmd/xapm_3.2.2-14_i386.deb', '28426', 'X program to monitor APM battery status', 'http://alumnit.ca/~apenwarr/apmd/');
INSERT INTO `packages_plain` VALUES ('685', 'apoo', 'optional', 'misc', '185', 'Rogerio Reis ', 'all', '', '2.2-2', 'pool/main/a/apoo/apoo_2.2-2_all.deb', '136702', 'An Assembly course aid', '');
INSERT INTO `packages_plain` VALUES ('686', 'app-install-data', 'optional', 'x11', '20864', 'Julian Andres Klode ', 'all', '', '2009.06.06', 'pool/main/a/app-install-data/app-install-data_2009.06.06_all.deb', '6903896', 'Application Installer Data Files', '');
INSERT INTO `packages_plain` VALUES ('687', 'apparix', 'extra', 'utils', '172', 'Armin Berres ', 'i386', '', '07-261-1', 'pool/main/a/apparix/apparix_07-261-1_i386.deb', '93336', 'console-based bookmark tool for fast file system navigation', 'http://micans.org/apparix/');
INSERT INTO `packages_plain` VALUES ('688', 'libappconfig-perl', 'optional', 'perl', '256', 'Stefan Hornburg (Racke) ', 'all', 'appconfig', '1.56-2', 'pool/main/a/appconfig/libappconfig-perl_1.56-2_all.deb', '88586', 'Perl module for configuration file and command line handling', '');
INSERT INTO `packages_plain` VALUES ('689', 'approx', 'optional', 'admin', '2728', 'Eric Cooper ', 'i386', '', '4.1-1', 'pool/main/a/approx/approx_4.1-1_i386.deb', '1072074', 'caching proxy server for Debian archive files', 'http://git.debian.org/?p=pkg-ocaml-maint/packages/approx.git');
INSERT INTO `packages_plain` VALUES ('690', 'libapq-postgresql-dbg', 'extra', 'debug', '108', 'Adrian-Ken Rueegsegger ', 'i386', 'apq-postgresql', '3.0~b1-1', 'pool/main/a/apq-postgresql/libapq-postgresql-dbg_3.0~b1-1_i386.deb', '21988', 'APQ Ada 95 Postgresql Binding Plugin (debug)', 'http://www.adaworks.net/adaworks/');
INSERT INTO `packages_plain` VALUES ('691', 'libapq-postgresql-dev', 'optional', 'libdevel', '416', 'Adrian-Ken Rueegsegger ', 'i386', 'apq-postgresql', '3.0~b1-1', 'pool/main/a/apq-postgresql/libapq-postgresql-dev_3.0~b1-1_i386.deb', '95104', 'APQ Ada 95 Postgresql Binding Plugin (development)', 'http://www.adaworks.net/adaworks/');
INSERT INTO `packages_plain` VALUES ('692', 'libapq3-postgresql', 'optional', 'libs', '196', 'Adrian-Ken Rueegsegger ', 'i386', 'apq-postgresql', '3.0~b1-1', 'pool/main/a/apq-postgresql/libapq3-postgresql_3.0~b1-1_i386.deb', '50702', 'APQ Ada 95 Postgresql Binding Plugin (library)', 'http://www.adaworks.net/adaworks/');
INSERT INTO `packages_plain` VALUES ('693', 'libapq-common-dbg', 'extra', 'debug', '72', 'Adrian-Ken Rueegsegger ', 'i386', 'apq', '3.0~b1-3', 'pool/main/a/apq/libapq-common-dbg_3.0~b1-3_i386.deb', '10172', 'A pluggable Ada 95 Binding to various database systems (debug)', 'http://www.adaworks.net/adaworks/');
INSERT INTO `packages_plain` VALUES ('694', 'libapq-common-dev', 'optional', 'libdevel', '920', 'Adrian-Ken Rueegsegger ', 'i386', 'apq', '3.0~b1-3', 'pool/main/a/apq/libapq-common-dev_3.0~b1-3_i386.deb', '595702', 'A pluggable Ada 95 Binding to various database systems (development)', 'http://www.adaworks.net/adaworks/');
INSERT INTO `packages_plain` VALUES ('695', 'libapq3-common', 'optional', 'libs', '172', 'Adrian-Ken Rueegsegger ', 'i386', 'apq', '3.0~b1-3', 'pool/main/a/apq/libapq3-common_3.0~b1-3_i386.deb', '53588', 'A pluggable Ada 95 Binding to various database systems (library)', 'http://www.adaworks.net/adaworks/');
INSERT INTO `packages_plain` VALUES ('696', 'libaprutil1-dbd-freetds', 'optional', 'libs', '80', 'Debian Apache Maintainers ', 'i386', 'apr-util', '1.3.9+dfsg-3', 'pool/main/a/apr-util/libaprutil1-dbd-freetds_1.3.9+dfsg-3_i386.deb', '27480', 'The Apache Portable Runtime Utility Library - FreeTDS Driver', 'http://apr.apache.org/');
INSERT INTO `packages_plain` VALUES ('697', 'libaprutil1-dbd-mysql', 'optional', 'libs', '84', 'Debian Apache Maintainers ', 'i386', 'apr-util', '1.3.9+dfsg-3', 'pool/main/a/apr-util/libaprutil1-dbd-mysql_1.3.9+dfsg-3_i386.deb', '29418', 'The Apache Portable Runtime Utility Library - MySQL Driver', 'http://apr.apache.org/');
INSERT INTO `packages_plain` VALUES ('698', 'libaprutil1-dbd-odbc', 'optional', 'libs', '92', 'Debian Apache Maintainers ', 'i386', 'apr-util', '1.3.9+dfsg-3', 'pool/main/a/apr-util/libaprutil1-dbd-odbc_1.3.9+dfsg-3_i386.deb', '32880', 'The Apache Portable Runtime Utility Library - ODBC Driver', 'http://apr.apache.org/');
INSERT INTO `packages_plain` VALUES ('699', 'libaprutil1-dbd-pgsql', 'optional', 'libs', '84', 'Debian Apache Maintainers ', 'i386', 'apr-util', '1.3.9+dfsg-3', 'pool/main/a/apr-util/libaprutil1-dbd-pgsql_1.3.9+dfsg-3_i386.deb', '28954', 'The Apache Portable Runtime Utility Library - PostgreSQL Driver', 'http://apr.apache.org/');
INSERT INTO `packages_plain` VALUES ('700', 'libaprutil1-dbd-sqlite3', 'optional', 'libs', '80', 'Debian Apache Maintainers ', 'i386', 'apr-util', '1.3.9+dfsg-3', 'pool/main/a/apr-util/libaprutil1-dbd-sqlite3_1.3.9+dfsg-3_i386.deb', '27078', 'The Apache Portable Runtime Utility Library - SQLite3 Driver', 'http://apr.apache.org/');
INSERT INTO `packages_plain` VALUES ('701', 'libaprutil1-dbg', 'extra', 'debug', '608', 'Debian Apache Maintainers ', 'i386', 'apr-util', '1.3.9+dfsg-3', 'pool/main/a/apr-util/libaprutil1-dbg_1.3.9+dfsg-3_i386.deb', '229344', 'The Apache Portable Runtime Utility Library - Debugging Symbols', 'http://apr.apache.org/');
INSERT INTO `packages_plain` VALUES ('702', 'libaprutil1-dev', 'optional', 'libdevel', '4676', 'Debian Apache Maintainers ', 'i386', 'apr-util', '1.3.9+dfsg-3', 'pool/main/a/apr-util/libaprutil1-dev_1.3.9+dfsg-3_i386.deb', '572396', 'The Apache Portable Runtime Utility Library - Development Headers', 'http://apr.apache.org/');
INSERT INTO `packages_plain` VALUES ('703', 'libaprutil1-ldap', 'optional', 'libs', '76', 'Debian Apache Maintainers ', 'i386', 'apr-util', '1.3.9+dfsg-3', 'pool/main/a/apr-util/libaprutil1-ldap_1.3.9+dfsg-3_i386.deb', '25070', 'The Apache Portable Runtime Utility Library - LDAP Driver', 'http://apr.apache.org/');
INSERT INTO `packages_plain` VALUES ('704', 'libaprutil1', 'optional', 'libs', '232', 'Debian Apache Maintainers ', 'i386', 'apr-util', '1.3.9+dfsg-3', 'pool/main/a/apr-util/libaprutil1_1.3.9+dfsg-3_i386.deb', '85074', 'The Apache Portable Runtime Utility Library', 'http://apr.apache.org/');
INSERT INTO `packages_plain` VALUES ('705', 'libapr1-dbg', 'extra', 'debug', '128', 'Debian Apache Maintainers ', 'i386', 'apr', '1.3.8-1', 'pool/main/a/apr/libapr1-dbg_1.3.8-1_i386.deb', '57738', 'The Apache Portable Runtime Library - Debugging Symbols', 'http://apr.apache.org/');
INSERT INTO `packages_plain` VALUES ('706', 'libapr1-dev', 'optional', 'libdevel', '5544', 'Debian Apache Maintainers ', 'i386', 'apr', '1.3.8-1', 'pool/main/a/apr/libapr1-dev_1.3.8-1_i386.deb', '871396', 'The Apache Portable Runtime Library - Development Headers', 'http://apr.apache.org/');
INSERT INTO `packages_plain` VALUES ('707', 'libapr1', 'optional', 'libs', '300', 'Debian Apache Maintainers ', 'i386', 'apr', '1.3.8-1', 'pool/main/a/apr/libapr1_1.3.8-1_i386.deb', '117770', 'The Apache Portable Runtime Library', 'http://apr.apache.org/');
INSERT INTO `packages_plain` VALUES ('708', 'aprsd', 'optional', 'hamradio', '460', 'Debian Hamradio Maintainers ', 'i386', '', '1:2.2.5-13-5.1', 'pool/main/a/aprsd/aprsd_2.2.5-13-5.1_i386.deb', '146856', 'Internet Gateway for the Automatic Position Reporting System', 'http://sourceforge.net/projects/aprsd/');
INSERT INTO `packages_plain` VALUES ('709', 'aprsdigi', 'optional', 'hamradio', '140', 'Debian Hamradio Maintainers ', 'i386', '', '2.4.4-3.1', 'pool/main/a/aprsdigi/aprsdigi_2.4.4-3.1_i386.deb', '42740', 'digipeater for APRS', 'http://aprsdigi.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('710', 'apsfilter', 'extra', 'text', '2484', 'Pawel Wiecek ', 'all', '', '7.2.6-1.3', 'pool/main/a/apsfilter/apsfilter_7.2.6-1.3_all.deb', '438510', 'Magic print filter with automatic file type recognition', '');
INSERT INTO `packages_plain` VALUES ('711', 'apt-build', 'optional', 'devel', '128', 'Julien Danjou ', 'i386', '', '0.12.37', 'pool/main/a/apt-build/apt-build_0.12.37_i386.deb', '36316', 'frontend to apt to build, optimize and install packages', '');
INSERT INTO `packages_plain` VALUES ('712', 'apt-cacher-ng', 'optional', 'net', '740', 'Eduard Bloch ', 'i386', '', '0.4-1', 'pool/main/a/apt-cacher-ng/apt-cacher-ng_0.4-1_i386.deb', '278574', 'Caching proxy for distribution of software packages', '');
INSERT INTO `packages_plain` VALUES ('713', 'apt-cacher', 'optional', 'net', '308', 'Mark Hindley ', 'all', '', '1.6.9', 'pool/main/a/apt-cacher/apt-cacher_1.6.9_all.deb', '78792', 'Caching proxy for Debian package and source files', '');
INSERT INTO `packages_plain` VALUES ('714', 'apt-cross', 'extra', 'utils', '116', 'Neil Williams ', 'all', '', '0.13.1', 'pool/main/a/apt-cross/apt-cross_0.13.1_all.deb', '24220', 'retrieve, build and install libraries for cross-compiling', 'http://www.emdebian.org/');
INSERT INTO `packages_plain` VALUES ('715', 'libcache-apt-perl', 'extra', 'perl', '140', 'Neil Williams ', 'all', 'apt-cross', '0.13.1', 'pool/main/a/apt-cross/libcache-apt-perl_0.13.1_all.deb', '32968', 'object oriented apt cache perl binding', 'http://www.emdebian.org/');
INSERT INTO `packages_plain` VALUES ('716', 'apt-dater-dbg', 'extra', 'debug', '200', 'Patrick MatthГѓВ¤i ', 'i386', 'apt-dater', '0.8.0-3', 'pool/main/a/apt-dater/apt-dater-dbg_0.8.0-3_i386.deb', '68014', 'terminal-based remote package update manager (dbg symbols)', 'http://www.ibh.de/apt-dater');
INSERT INTO `packages_plain` VALUES ('717', 'apt-dater-host', 'optional', 'admin', '72', 'Patrick MatthГѓВ¤i ', 'all', 'apt-dater', '0.8.0-3', 'pool/main/a/apt-dater/apt-dater-host_0.8.0-3_all.deb', '8832', 'host helper application for apt-dater', 'http://www.ibh.de/apt-dater');
INSERT INTO `packages_plain` VALUES ('718', 'apt-dater', 'optional', 'admin', '240', 'Patrick MatthГѓВ¤i ', 'i386', '', '0.8.0-3', 'pool/main/a/apt-dater/apt-dater_0.8.0-3_i386.deb', '58210', 'terminal-based remote package update manager', 'http://www.ibh.de/apt-dater');
INSERT INTO `packages_plain` VALUES ('719', 'apt-dpkg-ref', 'optional', 'doc', '152', 'Vanessa GutiГѓВ©rrez ', 'all', '', '5.3+nmu1', 'pool/main/a/apt-dpkg-ref/apt-dpkg-ref_5.3+nmu1_all.deb', '96466', 'APT, Dpkg Quick Reference sheet', '');
INSERT INTO `packages_plain` VALUES ('720', 'apt-file', 'optional', 'admin', '184', 'Stefan Fritsch ', 'all', '', '2.3.0', 'pool/main/a/apt-file/apt-file_2.3.0_all.deb', '29228', 'search for files within Debian packages (command-line interface)', '');
INSERT INTO `packages_plain` VALUES ('721', 'apt-forktracer', 'optional', 'admin', '180', 'Marcin Owsiany ', 'all', '', '0.2', 'pool/main/a/apt-forktracer/apt-forktracer_0.2_all.deb', '23308', 'a utility for tracking non-official package versions', '');
INSERT INTO `packages_plain` VALUES ('722', 'apt-listbugs', 'optional', 'admin', '516', 'Ryan Niebur ', 'all', '', '0.1.1', 'pool/main/a/apt-listbugs/apt-listbugs_0.1.1_all.deb', '99550', 'tool which lists critical bugs before each apt installation', '');
INSERT INTO `packages_plain` VALUES ('723', 'apt-listchanges', 'standard', 'utils', '504', 'Pierre Habouzit ', 'all', '', '2.83+nmu1', 'pool/main/a/apt-listchanges/apt-listchanges_2.83+nmu1_all.deb', '80254', 'package change history notification tool', '');
INSERT INTO `packages_plain` VALUES ('724', 'apt-mirror', 'optional', 'net', '120', 'Brandon Holtsclaw ', 'all', '', '0.4.5-1', 'pool/main/a/apt-mirror/apt-mirror_0.4.5-1_all.deb', '11866', 'APT sources mirroring tool', 'http://apt-mirror.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('725', 'apt-move', 'optional', 'admin', '220', 'Chuan-kai Lin ', 'i386', 'apt-move (4.2.27-1)', '4.2.27-1+b7', 'pool/main/a/apt-move/apt-move_4.2.27-1+b7_i386.deb', '51334', 'Maintain Debian packages in a package pool', '');
INSERT INTO `packages_plain` VALUES ('726', 'apt-offline', 'optional', 'admin', '316', 'Ritesh Raj Sarraf ', 'all', '', '0.9.5', 'pool/main/a/apt-offline/apt-offline_0.9.5_all.deb', '52758', 'offline apt package manager', 'http://apt-offline.alioth.debian.org');
INSERT INTO `packages_plain` VALUES ('727', 'apt-p2p', 'optional', 'net', '529', 'Cameron Dale ', 'all', '', '0.1.5', 'pool/main/a/apt-p2p/apt-p2p_0.1.5_all.deb', '108498', 'apt helper for peer-to-peer downloads of Debian packages', 'http://www.camrdale.org/apt-p2p.html');
INSERT INTO `packages_plain` VALUES ('728', 'apt-rdepends', 'optional', 'utils', '92', 'Simon Law ', 'all', '', '1.3.0-1.1', 'pool/main/a/apt-rdepends/apt-rdepends_1.3.0-1.1_all.deb', '14396', 'Recursively lists package dependencies', '');
INSERT INTO `packages_plain` VALUES ('729', 'apt-show-source', 'optional', 'admin', '116', 'OHURA Makoto ', 'all', '', '0.10', 'pool/main/a/apt-show-source/apt-show-source_0.10_all.deb', '17968', 'Shows source-package information', '');
INSERT INTO `packages_plain` VALUES ('730', 'apt-show-versions', 'optional', 'admin', '184', 'Christoph Martin ', 'all', '', '0.16', 'pool/main/a/apt-show-versions/apt-show-versions_0.16_all.deb', '33644', 'lists available package versions with distribution', '');
INSERT INTO `packages_plain` VALUES ('731', 'apt-spy', 'optional', 'admin', '196', 'Stefano Canepa ', 'i386', '', '3.1-19', 'pool/main/a/apt-spy/apt-spy_3.1-19_i386.deb', '31650', 'writes a sources.list file based on bandwidth tests', '');
INSERT INTO `packages_plain` VALUES ('732', 'apt-src', 'optional', 'admin', '76', 'Laszlo Boszormenyi (GCS) ', 'all', '', '0.25.1-0.1', 'pool/main/a/apt-src/apt-src_0.25.1-0.1_all.deb', '36352', 'manage Debian source packages', '');
INSERT INTO `packages_plain` VALUES ('733', 'apt-transport-debtorrent', 'optional', 'admin', '120', 'Cameron Dale ', 'i386', 'apt-transport-debtorrent (0.2.1)', '0.2.1+b2', 'pool/main/a/apt-transport-debtorrent/apt-transport-debtorrent_0.2.1+b2_i386.deb', '25660', 'an APT transport for communicating with DebTorrent', 'http://debtorrent.alioth.debian.org/');
INSERT INTO `packages_plain` VALUES ('734', 'apt-watch-backend', 'optional', 'admin', '184', 'John Lightsey ', 'i386', 'apt-watch', '0.3.2-14', 'pool/main/a/apt-watch/apt-watch-backend_0.3.2-14_i386.deb', '39282', 'Applet that monitors apt sources for upgrades (backend slave)', '');
INSERT INTO `packages_plain` VALUES ('735', 'apt-watch-gnome', 'optional', 'admin', '200', 'John Lightsey ', 'i386', 'apt-watch', '0.3.2-14', 'pool/main/a/apt-watch/apt-watch-gnome_0.3.2-14_i386.deb', '36736', 'Applet that monitors apt sources for upgrades (GNOME applet)', '');
INSERT INTO `packages_plain` VALUES ('736', 'apt-watch', 'optional', 'admin', '36', 'John Lightsey ', 'all', '', '0.3.2-14', 'pool/main/a/apt-watch/apt-watch_0.3.2-14_all.deb', '3958', 'Applet that monitors apt sources for upgrades (transitional package)', '');
INSERT INTO `packages_plain` VALUES ('737', 'apt-xapian-index', 'optional', 'admin', '208', 'Enrico Zini ', 'all', '', '0.22', 'pool/main/a/apt-xapian-index/apt-xapian-index_0.22_all.deb', '35730', 'maintenance tools for a Xapian index of Debian packages', '');
INSERT INTO `packages_plain` VALUES ('738', 'apt-zip', 'extra', 'admin', '128', 'Giacomo Catenazzi ', 'all', '', '0.18', 'pool/main/a/apt-zip/apt-zip_0.18_all.deb', '20598', 'Update a non-networked computer using apt and removable media', 'http://alioth.debian.org/projects/apt-zip');
INSERT INTO `packages_plain` VALUES ('739', 'apt-doc', 'optional', 'doc', '276', 'APT Development Team ', 'all', 'apt', '0.7.23.1', 'pool/main/a/apt/apt-doc_0.7.23.1_all.deb', '103962', 'Documentation for APT', '');
INSERT INTO `packages_plain` VALUES ('740', 'apt-transport-https', 'optional', 'admin', '124', 'APT Development Team ', 'i386', 'apt', '0.7.23.1', 'pool/main/a/apt/apt-transport-https_0.7.23.1_i386.deb', '62846', 'APT https transport', '');
INSERT INTO `packages_plain` VALUES ('741', 'apt-utils', 'important', 'admin', '440', 'APT Development Team ', 'i386', 'apt', '0.7.23.1', 'pool/main/a/apt/apt-utils_0.7.23.1_i386.deb', '193054', 'APT utility programs', '');
INSERT INTO `packages_plain` VALUES ('742', 'apt', 'important', 'admin', '5092', 'APT Development Team ', 'i386', '', '0.7.23.1', 'pool/main/a/apt/apt_0.7.23.1_i386.deb', '1641588', 'Advanced front-end for dpkg', '');
INSERT INTO `packages_plain` VALUES ('743', 'libapt-pkg-dev', 'optional', 'libdevel', '444', 'APT Development Team ', 'i386', 'apt', '0.7.23.1', 'pool/main/a/apt/libapt-pkg-dev_0.7.23.1_i386.deb', '115234', 'Development files for APT\'s libapt-pkg and libapt-inst', '');
INSERT INTO `packages_plain` VALUES ('744', 'libapt-pkg-doc', 'optional', 'doc', '368', 'APT Development Team ', 'all', 'apt', '0.7.23.1', 'pool/main/a/apt/libapt-pkg-doc_0.7.23.1_all.deb', '128344', 'Documentation for APT development', '');
INSERT INTO `packages_plain` VALUES ('745', 'aptfs', 'extra', 'utils', '40', 'Chris Lamb ', 'all', '', '0.7-1', 'pool/main/a/aptfs/aptfs_0.7-1_all.deb', '8322', 'FUSE filesystem for APT source repositories', 'http://chris-lamb.co.uk/projects/aptfs/');
INSERT INTO `packages_plain` VALUES ('746', 'apticron', 'extra', 'admin', '112', 'Tiago Bortoletto Vaz ', 'all', '', '1.1.37', 'pool/main/a/apticron/apticron_1.1.37_all.deb', '17046', 'simple tool to mail about pending package updates', '');
INSERT INTO `packages_plain` VALUES ('747', 'aptitude-dbg', 'extra', 'debug', '16900', 'Daniel Burrows ', 'i386', 'aptitude (0.4.11.11-1)', '0.4.11.11-1+b2', 'pool/main/a/aptitude/aptitude-dbg_0.4.11.11-1+b2_i386.deb', '5912136', 'Debug symbols for the aptitude package manager', '');
INSERT INTO `packages_plain` VALUES ('748', 'aptitude-doc-cs', 'optional', 'doc', '1300', 'Daniel Burrows ', 'all', 'aptitude', '0.4.11.11-1', 'pool/main/a/aptitude/aptitude-doc-cs_0.4.11.11-1_all.deb', '379426', 'Czech manual for aptitude, a terminal-based package manager', '');
INSERT INTO `packages_plain` VALUES ('749', 'aptitude-doc-en', 'optional', 'doc', '1304', 'Daniel Burrows ', 'all', 'aptitude', '0.4.11.11-1', 'pool/main/a/aptitude/aptitude-doc-en_0.4.11.11-1_all.deb', '364786', 'English manual for aptitude, a terminal-based package manager', '');
INSERT INTO `packages_plain` VALUES ('750', 'aptitude-doc-fi', 'optional', 'doc', '932', 'Daniel Burrows ', 'all', 'aptitude', '0.4.11.11-1', 'pool/main/a/aptitude/aptitude-doc-fi_0.4.11.11-1_all.deb', '271986', 'Finnish manual for aptitude, a terminal-based package manager', '');
INSERT INTO `packages_plain` VALUES ('751', 'aptitude-doc-fr', 'optional', 'doc', '1224', 'Daniel Burrows ', 'all', 'aptitude', '0.4.11.11-1', 'pool/main/a/aptitude/aptitude-doc-fr_0.4.11.11-1_all.deb', '312104', 'French manual for aptitude, a terminal-based package manager', '');
INSERT INTO `packages_plain` VALUES ('752', 'aptitude-doc-ja', 'optional', 'doc', '1340', 'Daniel Burrows ', 'all', 'aptitude', '0.4.11.11-1', 'pool/main/a/aptitude/aptitude-doc-ja_0.4.11.11-1_all.deb', '374740', 'Japanese manual for aptitude, a terminal-based package manager', '');
INSERT INTO `packages_plain` VALUES ('753', 'aptitude', 'important', 'admin', '9652', 'Daniel Burrows ', 'i386', 'aptitude (0.4.11.11-1)', '0.4.11.11-1+b2', 'pool/main/a/aptitude/aptitude_0.4.11.11-1+b2_i386.deb', '3034330', 'terminal-based package manager', '');
INSERT INTO `packages_plain` VALUES ('754', 'aptlinex', 'optional', 'utils', '124', 'JosГѓВ© L. Redrejo RodrГѓВ­guez ', 'all', '', '0.91-1', 'pool/main/a/aptlinex/aptlinex_0.91-1_all.deb', '17902', 'Web browser addon to install Debian packages with a click', '');
INSERT INTO `packages_plain` VALUES ('755', 'aptoncd', 'extra', 'admin', '1960', 'Fabrice Coutadeur ', 'all', '', '0.1.98+bzr112-1', 'pool/main/a/aptoncd/aptoncd_0.1.98+bzr112-1_all.deb', '268724', 'Installation disc creator for packages downloaded via APT', 'http://aptoncd.sourceforge.net');
INSERT INTO `packages_plain` VALUES ('756', 'aptsh', 'optional', 'admin', '220', 'Marcin Wrochniak ', 'i386', 'aptsh (0.0.7+nmu1)', '0.0.7+nmu1+b2', 'pool/main/a/aptsh/aptsh_0.0.7+nmu1+b2_i386.deb', '61702', 'apt interactive shell', '');
INSERT INTO `packages_plain` VALUES ('757', 'apvlv', 'extra', 'text', '328', 'Stefan Ritter ', 'i386', '', '0.0.7.2-1', 'pool/main/a/apvlv/apvlv_0.0.7.2-1_i386.deb', '113304', 'PDF viewer with Vim-like behaviour', 'http://code.google.com/p/apvlv/');
INSERT INTO `packages_plain` VALUES ('758', 'apwal', 'optional', 'gnome', '244', 'Sam Hocevar (Debian packages) ', 'i386', '', '0.4.5-1', 'pool/main/a/apwal/apwal_0.4.5-1_i386.deb', '63526', 'icon-based floating application launcher with transparency', '');
INSERT INTO `packages_plain` VALUES ('759', 'aqemu', 'optional', 'x11', '3488', 'Ignace Mouzannar ', 'i386', '', '0.7.3-1', 'pool/main/a/aqemu/aqemu_0.7.3-1_i386.deb', '1327580', 'Qt4 front-end for QEMU and KVM', 'http://aqemu.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('760', 'aqsis-libs-dev', 'optional', 'libdevel', '172', 'David MartГѓВ­nez Moreno ', 'i386', 'aqsis', '1.2.0-2.1', 'pool/main/a/aqsis/aqsis-libs-dev_1.2.0-2.1_i386.deb', '30742', 'suite of applications implementing the RenderMan Interface - development files', '');
INSERT INTO `packages_plain` VALUES ('761', 'aqsis-libsc2a', 'optional', 'libs', '4560', 'David MartГѓВ­nez Moreno ', 'i386', 'aqsis', '1.2.0-2.1', 'pool/main/a/aqsis/aqsis-libsc2a_1.2.0-2.1_i386.deb', '1535952', 'suite of applications implementing the RenderMan Interface - libraries', '');
INSERT INTO `packages_plain` VALUES ('762', 'aqsis', 'optional', 'graphics', '1140', 'David MartГѓВ­nez Moreno ', 'i386', '', '1.2.0-2.1', 'pool/main/a/aqsis/aqsis_1.2.0-2.1_i386.deb', '335492', 'suite of applications implementing the RenderMan Interface', '');
INSERT INTO `packages_plain` VALUES ('763', 'aqualung', 'extra', 'sound', '2192', 'Adam CГѓВ©cile (Le_Vert) ', 'i386', '', '0.9~beta10-2', 'pool/main/a/aqualung/aqualung_0.9~beta10-2_i386.deb', '861368', 'Gapless Gtk-based audio player', 'http://aqualung.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('764', 'ara', 'optional', 'utils', '744', 'George Danchev ', 'i386', '', '1.0.27', 'pool/main/a/ara/ara_1.0.27_i386.deb', '293464', 'Command line utility for searching the Debian package database', 'http://ara.alioth.debian.org/');
INSERT INTO `packages_plain` VALUES ('765', 'xara-gtk', 'optional', 'utils', '1764', 'George Danchev ', 'i386', 'ara', '1.0.27', 'pool/main/a/ara/xara-gtk_1.0.27_i386.deb', '630916', 'GTK+ utility for searching the Debian package database', 'http://ara.alioth.debian.org/');
INSERT INTO `packages_plain` VALUES ('766', 'arandr', 'optional', 'x11', '200', 'Christian M. AmsГѓВјss ', 'all', '', '0.1.2-1', 'pool/main/a/arandr/arandr_0.1.2-1_all.deb', '31038', 'Simple visual front end for XRandR 1.2', 'http://christian.amsuess.com/tools/arandr/');
INSERT INTO `packages_plain` VALUES ('767', 'aranym', 'extra', 'otherosfs', '5308', 'Antonin Kral ', 'i386', '', '0.9.9-1', 'pool/main/a/aranym/aranym_0.9.9-1_i386.deb', '1712610', 'Atari Running on Any Machine', 'http://www.aranym.org');
INSERT INTO `packages_plain` VALUES ('768', 'arc-brave', 'optional', 'gnome', '572', 'GNOME-Colors Packagers ', 'all', 'arc-colors', '2.7-1', 'pool/main/a/arc-colors/arc-brave_2.7-1_all.deb', '412746', 'blue variation of the Arc-Colors wallpapers and GDM themes', 'http://code.google.com/p/gnome-colors/');
INSERT INTO `packages_plain` VALUES ('769', 'arc-colors', 'optional', 'gnome', '64', 'GNOME-Colors Packagers ', 'all', '', '2.7-1', 'pool/main/a/arc-colors/arc-colors_2.7-1_all.deb', '11472', 'set of wallpapers and GDM themes', 'http://code.google.com/p/gnome-colors/');
INSERT INTO `packages_plain` VALUES ('770', 'arc-dust', 'optional', 'gnome', '560', 'GNOME-Colors Packagers ', 'all', 'arc-colors', '2.7-1', 'pool/main/a/arc-colors/arc-dust_2.7-1_all.deb', '396076', 'chocolate variation of the Arc-Colors wallpapers and GDM themes', 'http://code.google.com/p/gnome-colors/');
INSERT INTO `packages_plain` VALUES ('771', 'arc-human', 'optional', 'gnome', '556', 'GNOME-Colors Packagers ', 'all', 'arc-colors', '2.7-1', 'pool/main/a/arc-colors/arc-human_2.7-1_all.deb', '393178', 'orange variation of the Arc-Colors wallpapers and GDM themes', 'http://code.google.com/p/gnome-colors/');
INSERT INTO `packages_plain` VALUES ('772', 'arc-illustrious', 'optional', 'gnome', '544', 'GNOME-Colors Packagers ', 'all', 'arc-colors', '2.7-1', 'pool/main/a/arc-colors/arc-illustrious_2.7-1_all.deb', '383736', 'pink variation of the Arc-Colors wallpapers and GDM themes', 'http://code.google.com/p/gnome-colors/');
INSERT INTO `packages_plain` VALUES ('773', 'arc-noble', 'optional', 'gnome', '564', 'GNOME-Colors Packagers ', 'all', 'arc-colors', '2.7-1', 'pool/main/a/arc-colors/arc-noble_2.7-1_all.deb', '406046', 'purple variation of the Arc-Colors wallpapers and GDM themes', 'http://code.google.com/p/gnome-colors/');
INSERT INTO `packages_plain` VALUES ('774', 'arc-wine', 'optional', 'gnome', '516', 'GNOME-Colors Packagers ', 'all', 'arc-colors', '2.7-1', 'pool/main/a/arc-colors/arc-wine_2.7-1_all.deb', '353836', 'red variation of the Arc-Colors wallpapers and GDM themes', 'http://code.google.com/p/gnome-colors/');
INSERT INTO `packages_plain` VALUES ('775', 'arc-wise', 'optional', 'gnome', '568', 'GNOME-Colors Packagers ', 'all', 'arc-colors', '2.7-1', 'pool/main/a/arc-colors/arc-wise_2.7-1_all.deb', '408718', 'green variation of the Arc-Colors wallpapers and GDM themes', 'http://code.google.com/p/gnome-colors/');
INSERT INTO `packages_plain` VALUES ('776', 'arc', 'optional', 'utils', '136', 'Klaus Reimer ', 'i386', '', '5.21o-2', 'pool/main/a/arc/arc_5.21o-2_i386.deb', '56466', 'Archive utility based on the MSDOS ARC program', '');
INSERT INTO `packages_plain` VALUES ('777', 'arch-buildpackage', 'optional', 'vcs', '64', 'Debian QA Group ', 'all', '', '0.1-5', 'pool/main/a/arch-buildpackage/arch-buildpackage_0.1-5_all.deb', '9770', 'tools for maintaining Debian packages using arch', '');
INSERT INTO `packages_plain` VALUES ('778', 'libarch-perl', 'optional', 'perl', '492', 'Debian QA Group ', 'all', 'arch-perl', '0.5.1+patch-180-3', 'pool/main/a/arch-perl/libarch-perl_0.5.1+patch-180-3_all.deb', '161792', 'Perl library for GNU Arch', '');
INSERT INTO `packages_plain` VALUES ('779', 'arch2darcs', 'optional', 'vcs', '836', 'John Goerzen ', 'i386', '', '1.0.13', 'pool/main/a/arch2darcs/arch2darcs_1.0.13_i386.deb', '276492', 'Convert Arch/tla repositories to Darcs', '');
INSERT INTO `packages_plain` VALUES ('780', 'archfs', 'optional', 'utils', '100', 'Jon Dowland ', 'i386', '', '0.5.4-1', 'pool/main/a/archfs/archfs_0.5.4-1_i386.deb', '23322', 'rdiff-backup virtual filesystem', 'http://code.google.com/p/archfs/');
INSERT INTO `packages_plain` VALUES ('781', 'archivemail', 'optional', 'mail', '172', 'Serafeim Zanikolas ', 'all', '', '0.7.2-7', 'pool/main/a/archivemail/archivemail_0.7.2-7_all.deb', '37604', 'archive and compress or delete your old email', 'http://archivemail.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('782', 'archmage', 'optional', 'utils', '380', 'Mikhail Gusarov ', 'all', '', '1:0.2.4-1', 'pool/main/a/archmage/archmage_0.2.4-1_all.deb', '28980', 'CHM(Compiled HTML) Decompressor', 'http://archmage.sf.net');
INSERT INTO `packages_plain` VALUES ('783', 'archmbox', 'optional', 'mail', '128', 'Debian QA Group ', 'all', '', '4.10.0-1', 'pool/main/a/archmbox/archmbox_4.10.0-1_all.deb', '37032', 'a simple email archiver written in perl', 'http://adc-archmbox.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('784', 'archway', 'optional', 'vcs', '640', 'Debian QA Group ', 'all', '', '0.2.1+patch-85-1', 'pool/main/a/archway/archway_0.2.1+patch-85-1_all.deb', '302342', 'GUI for GNU Arch', '');
INSERT INTO `packages_plain` VALUES ('785', 'archzoom', 'optional', 'vcs', '816', 'Debian QA Group ', 'all', '', '0.5.1-4', 'pool/main/a/archzoom/archzoom_0.5.1-4_all.deb', '116252', 'web-based Arch repository browser', '');
INSERT INTO `packages_plain` VALUES ('786', 'ardour-i686', 'optional', 'sound', '12512', 'Debian Multimedia Team ', 'i386', 'ardour', '1:2.8-1', 'pool/main/a/ardour/ardour-i686_2.8-1_i386.deb', '4545294', 'digital audio workstation (graphical gtk2 interface) [i686]', 'http://www.ardour.org/');
INSERT INTO `packages_plain` VALUES ('787', 'ardour', 'optional', 'sound', '12448', 'Debian Multimedia Team ', 'i386', '', '1:2.8-1', 'pool/main/a/ardour/ardour_2.8-1_i386.deb', '4505602', 'digital audio workstation (graphical gtk2 interface)', 'http://www.ardour.org/');
INSERT INTO `packages_plain` VALUES ('788', 'arename', 'optional', 'sound', '184', 'Maximilian Gass ', 'all', '', '3.0-1', 'pool/main/a/arename/arename_3.0-1_all.deb', '57244', 'automatic audio file renaming', 'http://ft.bewatermyfriend.org/comp/arename.html');
INSERT INTO `packages_plain` VALUES ('789', 'python-argparse-doc', 'optional', 'doc', '416', 'Ritesh Raj Sarraf ', 'all', 'argparse', '1.0.1-1', 'pool/main/a/argparse/python-argparse-doc_1.0.1-1_all.deb', '55208', 'optparse-inspired command-line parsing library - doc', 'http://code.google.com/p/argparse/');
INSERT INTO `packages_plain` VALUES ('790', 'python-argparse', 'optional', 'python', '304', 'Ritesh Raj Sarraf ', 'all', 'argparse', '1.0.1-1', 'pool/main/a/argparse/python-argparse_1.0.1-1_all.deb', '41448', 'optparse-inspired command-line parsing library', 'http://code.google.com/p/argparse/');
INSERT INTO `packages_plain` VALUES ('791', 'libargtable2-0', 'optional', 'libs', '68', 'Shachar Shemesh ', 'i386', 'argtable2', '9-1', 'pool/main/a/argtable2/libargtable2-0_9-1_i386.deb', '13240', 'A library for parsing GNU style command line arguments', '');
INSERT INTO `packages_plain` VALUES ('792', 'libargtable2-dev', 'optional', 'libdevel', '120', 'Shachar Shemesh ', 'i386', 'argtable2', '9-1', 'pool/main/a/argtable2/libargtable2-dev_9-1_i386.deb', '39330', 'A library for parsing GNU style command line arguments', '');
INSERT INTO `packages_plain` VALUES ('793', 'libargtable2-docs', 'optional', 'doc', '3080', 'Shachar Shemesh ', 'all', 'argtable2', '9-1', 'pool/main/a/argtable2/libargtable2-docs_9-1_all.deb', '2963174', 'A library for parsing GNU style command line arguments', '');
INSERT INTO `packages_plain` VALUES ('794', 'argus-client', 'optional', 'net', '3785', 'Andrew Pollock ', 'i386', '', '2.0.6.fixes.1-3', 'pool/main/a/argus-client/argus-client_2.0.6.fixes.1-3_i386.deb', '1832450', 'IP network transaction auditing tool', '');
INSERT INTO `packages_plain` VALUES ('795', 'argus-server', 'optional', 'net', '464', 'Andrew Pollock ', 'i386', 'argus', '1:2.0.6.fixes.1-16', 'pool/main/a/argus/argus-server_2.0.6.fixes.1-16_i386.deb', '136840', 'IP network transaction auditing tool', '');
INSERT INTO `packages_plain` VALUES ('796', 'python-argvalidate', 'optional', 'python', '268', 'Debian Python Modules Team ', 'all', 'argvalidate', '0.9.0-1', 'pool/main/a/argvalidate/python-argvalidate_0.9.0-1_all.deb', '29416', 'simple argument validator library', 'http://code.sp-its.at/projects/argvalidate');
INSERT INTO `packages_plain` VALUES ('797', 'argyll', 'optional', 'graphics', '8640', 'Roland Mas ', 'i386', '', '1.0.4-1', 'pool/main/a/argyll/argyll_1.0.4-1_i386.deb', '3842422', 'Color Management System, calibrator and profiler', 'http://www.argyllcms.com/');
INSERT INTO `packages_plain` VALUES ('798', 'aria2', 'optional', 'net', '4248', 'Patrick Ruckstuhl ', 'i386', '', '1.6.2-3', 'pool/main/a/aria2/aria2_1.6.2-3_i386.deb', '1564914', 'High speed download utility', 'http://aria2.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('799', 'aribas', 'optional', 'math', '404', 'Ralf Treinen ', 'i386', '', '1.63-3', 'pool/main/a/aribas/aribas_1.63-3_i386.deb', '195626', 'interpreter for arithmetic', 'http://www.mathematik.uni-muenchen.de/~forster/sw/aribas.html');
INSERT INTO `packages_plain` VALUES ('800', 'ario-common', 'optional', 'sound', '1436', 'Marc Pavot ', 'all', 'ario', '1.3-1', 'pool/main/a/ario/ario-common_1.3-1_all.deb', '308240', 'GTK+ client for the Music Player Daemon (MPD) (Common files)', 'http://ario-player.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('801', 'ario', 'optional', 'sound', '620', 'Marc Pavot ', 'i386', '', '1.3-1', 'pool/main/a/ario/ario_1.3-1_i386.deb', '196178', 'GTK+ client for the Music Player Daemon (MPD)', 'http://ario-player.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('802', 'arista', 'optional', 'video', '1568', 'Alessio Treglia ', 'all', '', '0.9.3-2', 'pool/main/a/arista/arista_0.9.3-2_all.deb', '196594', 'multimedia transcoder for the GNOME Desktop', 'http://programmer-art.org/projects/arista-transcoder');
INSERT INTO `packages_plain` VALUES ('803', 'arj', 'optional', 'utils', '480', 'Guillem Jover ', 'i386', '', '3.10.22-7', 'pool/main/a/arj/arj_3.10.22-7_i386.deb', '218886', 'archiver for .arj files', 'http://sf.net/projects/arj/');
INSERT INTO `packages_plain` VALUES ('804', 'libarmadillo-dev', 'optional', 'libdevel', '1224', 'Debian Science Maintainers ', 'i386', 'armadillo', '0.6.12-2', 'pool/main/a/armadillo/libarmadillo-dev_0.6.12-2_i386.deb', '115596', 'streamlined C++ linear algebra library - Headers', 'http://arma.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('805', 'libarmadillo-doc', 'optional', 'doc', '16200', 'Debian Science Maintainers ', 'all', 'armadillo', '0.6.12-2', 'pool/main/a/armadillo/libarmadillo-doc_0.6.12-2_all.deb', '1662932', 'streamlined C++ linear algebra library - Documentation', 'http://arma.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('806', 'libarmadillo0', 'optional', 'libs', '56', 'Debian Science Maintainers ', 'i386', 'armadillo', '0.6.12-2', 'pool/main/a/armadillo/libarmadillo0_0.6.12-2_i386.deb', '7594', 'streamlined C++ linear algebra library', 'http://arma.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('807', 'armagetronad-common', 'optional', 'games', '1676', 'Christine Spang ', 'all', 'armagetronad', '0.2.8.3~rc3-1', 'pool/main/a/armagetronad/armagetronad-common_0.2.8.3~rc3-1_all.deb', '552728', 'Common files for the Armagetron Advanced packages', 'http://armagetronad.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('808', 'armagetronad-dedicated', 'optional', 'games', '1728', 'Christine Spang ', 'i386', 'armagetronad', '0.2.8.3~rc3-1', 'pool/main/a/armagetronad/armagetronad-dedicated_0.2.8.3~rc3-1_i386.deb', '811432', 'dedicated game server for Armagetron Advanced', 'http://armagetronad.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('809', 'armagetronad', 'optional', 'games', '2488', 'Christine Spang ', 'i386', '', '0.2.8.3~rc3-1', 'pool/main/a/armagetronad/armagetronad_0.2.8.3~rc3-1_i386.deb', '1358740', '3D Tron-like high speed game', 'http://armagetronad.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('810', 'arno-iptables-firewall', 'optional', 'net', '824', 'Michael Hanke ', 'all', '', '1.9.2.d-1', 'pool/main/a/arno-iptables-firewall/arno-iptables-firewall_1.9.2.d-1_all.deb', '123450', 'single- and multi-homed firewall script with DSL/ADSL support', 'http://rocky.eld.leidenuniv.nl/');
INSERT INTO `packages_plain` VALUES ('811', 'arora', 'extra', 'web', '3912', 'Sune Vuorela ', 'i386', '', '0.10.1-1', 'pool/main/a/arora/arora_0.10.1-1_i386.deb', '1462620', 'simple cross platform web browser', '');
INSERT INTO `packages_plain` VALUES ('812', 'arp-scan', 'extra', 'admin', '472', 'Tim Brown ', 'i386', '', '1.6-2', 'pool/main/a/arp-scan/arp-scan_1.6-2_i386.deb', '181664', 'arp scanning and fingerprinting tool', '');
INSERT INTO `packages_plain` VALUES ('813', 'libarpack++2-dev', 'optional', 'libdevel', '2108', 'Debian Scientific Computing Team ', 'i386', 'arpack++', '2.3-1', 'pool/main/a/arpack++/libarpack++2-dev_2.3-1_i386.deb', '464752', 'Object-oriented version of the ARPACK package (development)', 'http://ljk.imag.fr/membres/Christophe.Prudhomme/software.php');
INSERT INTO `packages_plain` VALUES ('814', 'libarpack++2c2a', 'optional', 'libs', '72', 'Debian Scientific Computing Team ', 'i386', 'arpack++', '2.3-1', 'pool/main/a/arpack++/libarpack++2c2a_2.3-1_i386.deb', '11234', 'Object-oriented version of the ARPACK package (runtime)', 'http://ljk.imag.fr/membres/Christophe.Prudhomme/software.php');
INSERT INTO `packages_plain` VALUES ('815', 'libarpack2-dbg', 'extra', 'debug', '100', 'Debian Scientific Computing Team ', 'i386', 'arpack (2.1+parpack96.dfsg-2)', '2.1+parpack96.dfsg-2+b1', 'pool/main/a/arpack/libarpack2-dbg_2.1+parpack96.dfsg-2+b1_i386.deb', '21126', 'Fortran77 subroutines to solve large scale eigenvalue problems (debug)', '');
INSERT INTO `packages_plain` VALUES ('816', 'libarpack2-dev', 'extra', 'libdevel', '1520', 'Debian Scientific Computing Team ', 'i386', 'arpack (2.1+parpack96.dfsg-2)', '2.1+parpack96.dfsg-2+b1', 'pool/main/a/arpack/libarpack2-dev_2.1+parpack96.dfsg-2+b1_i386.deb', '664704', 'Fortran77 subroutines to solve large scale eigenvalue problems (development)', '');
INSERT INTO `packages_plain` VALUES ('817', 'libarpack2', 'optional', 'libs', '640', 'Debian Scientific Computing Team ', 'i386', 'arpack (2.1+parpack96.dfsg-2)', '2.1+parpack96.dfsg-2+b1', 'pool/main/a/arpack/libarpack2_2.1+parpack96.dfsg-2+b1_i386.deb', '240638', 'Fortran77 subroutines to solve large scale eigenvalue problems', '');
INSERT INTO `packages_plain` VALUES ('818', 'arpalert', 'optional', 'net', '1816', 'Jan Wagner ', 'i386', '', '2.0.11-3', 'pool/main/a/arpalert/arpalert_2.0.11-3_i386.deb', '512538', 'Monitor ARP changes in ethernet networks', 'http://www.arpalert.org/');
INSERT INTO `packages_plain` VALUES ('819', 'arping', 'optional', 'net', '60', 'Giuseppe Iuculano ', 'i386', '', '2.08-1', 'pool/main/a/arping/arping_2.08-1_i386.deb', '23368', 'sends IP and/or ARP pings (to the MAC address)', 'http://www.habets.pp.se/synscan/programs.php?prog=arping');
INSERT INTO `packages_plain` VALUES ('820', 'arpon', 'optional', 'net', '340', 'Giuseppe Iuculano ', 'i386', '', '1.90-1', 'pool/main/a/arpon/arpon_1.90-1_i386.deb', '255652', 'versatile anti ARP poisoning daemon', 'http://arpon.sourceforge.net');
INSERT INTO `packages_plain` VALUES ('821', 'arptables', 'optional', 'net', '112', 'Jochen Friedrich ', 'i386', '', '0.0.3.3-3', 'pool/main/a/arptables/arptables_0.0.3.3-3_i386.deb', '32302', 'ARP table administration', 'http://ebtables.sourceforge.net');
INSERT INTO `packages_plain` VALUES ('822', 'arpwatch', 'optional', 'admin', '624', 'KELEMEN PГѓВ©ter ', 'i386', '', '2.1a15-1', 'pool/main/a/arpwatch/arpwatch_2.1a15-1_i386.deb', '184644', 'Ethernet/FDDI station activity monitor', 'http://ee.lbl.gov/');
INSERT INTO `packages_plain` VALUES ('823', 'array-info', 'optional', 'admin', '108', 'Raphael Pinson ', 'i386', '', '0.15-1', 'pool/main/a/array-info/array-info_0.15-1_i386.deb', '18040', 'command line tool reporting RAID status for several RAID types', '');
INSERT INTO `packages_plain` VALUES ('824', 'arrayprobe', 'extra', 'admin', '40', 'Matt Taggart ', 'i386', '', '2.0-3', 'pool/main/a/arrayprobe/arrayprobe_2.0-3_i386.deb', '9362', 'command line HP (Compaq) SmartArray status checker', '');
INSERT INTO `packages_plain` VALUES ('825', 'artha', 'optional', 'utils', '224', 'Debian Science Team ', 'i386', '', '0.9.1-1', 'pool/main/a/artha/artha_0.9.1-1_i386.deb', '62580', 'A handy off-line thesaurus based on WordNet', 'http://artha.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('826', 'artist', 'optional', 'utils', '248', 'Fredrik Hallenberg ', 'all', '', '1.2.6-6', 'pool/main/a/artist/artist_1.2.6-6_all.deb', '50518', 'Emacs Lisp drawing package', '');
INSERT INTO `packages_plain` VALUES ('827', 'arts-dbg', 'extra', 'debug', '10124', 'Debian Qt/KDE Maintainers ', 'i386', 'arts (1.5.9-3)', '1.5.9-3+b1', 'pool/main/a/arts/arts-dbg_1.5.9-3+b1_i386.deb', '3142826', 'debugging symbols for arts', '');
INSERT INTO `packages_plain` VALUES ('828', 'arts', 'optional', 'sound', '40', 'Debian Qt/KDE Maintainers ', 'all', '', '1.5.9-3', 'pool/main/a/arts/arts_1.5.9-3_all.deb', '6438', 'sound system from the official KDE release', '');
INSERT INTO `packages_plain` VALUES ('829', 'libarts1-dev', 'optional', 'libdevel', '5976', 'Debian Qt/KDE Maintainers ', 'i386', 'arts (1.5.9-3)', '1.5.9-3+b1', 'pool/main/a/arts/libarts1-dev_1.5.9-3+b1_i386.deb', '1141326', 'development files for the aRts sound system core components', '');
INSERT INTO `packages_plain` VALUES ('830', 'libarts1c2a', 'optional', 'libs', '4116', 'Debian Qt/KDE Maintainers ', 'i386', 'arts (1.5.9-3)', '1.5.9-3+b1', 'pool/main/a/arts/libarts1c2a_1.5.9-3+b1_i386.deb', '1088354', 'aRts sound system core components', '');
INSERT INTO `packages_plain` VALUES ('831', 'libartsc0-dev', 'optional', 'libdevel', '120', 'Debian Qt/KDE Maintainers ', 'i386', 'arts (1.5.9-3)', '1.5.9-3+b1', 'pool/main/a/arts/libartsc0-dev_1.5.9-3+b1_i386.deb', '21766', 'development files for the aRts sound system C support library', '');
INSERT INTO `packages_plain` VALUES ('832', 'libartsc0', 'optional', 'libs', '72', 'Debian Qt/KDE Maintainers ', 'i386', 'arts (1.5.9-3)', '1.5.9-3+b1', 'pool/main/a/arts/libartsc0_1.5.9-3+b1_i386.deb', '15826', 'aRts sound system C support library', '');
INSERT INTO `packages_plain` VALUES ('833', 'as31', 'optional', 'devel', '100', 'Bdale Garbee ', 'i386', '', '2.3.1-2', 'pool/main/a/as31/as31_2.3.1-2_i386.deb', '24556', 'Intel 8031/8051 assembler', '');
INSERT INTO `packages_plain` VALUES ('834', 'asc-music', 'optional', 'games', '10380', 'Debian Games Team ', 'all', '', '1.3-1', 'pool/main/a/asc-music/asc-music_1.3-1_all.deb', '10396276', 'music pack for ASC', '');
INSERT INTO `packages_plain` VALUES ('835', 'asc-data', 'optional', 'games', '14980', 'Debian Games Team ', 'all', 'asc', '2.1.0.0-2', 'pool/main/a/asc/asc-data_2.1.0.0-2_all.deb', '14349590', 'data files for the Advanced Strategic Command game', 'http://www.asc-hq.org');
INSERT INTO `packages_plain` VALUES ('836', 'asc', 'optional', 'games', '8208', 'Debian Games Team ', 'i386', 'asc (2.1.0.0-2)', '2.1.0.0-2+b1', 'pool/main/a/asc/asc_2.1.0.0-2+b1_i386.deb', '3371690', 'turn-based strategy game', 'http://www.asc-hq.org');
INSERT INTO `packages_plain` VALUES ('837', 'ascd', 'optional', 'sound', '461', 'Fredrik Hallenberg ', 'i386', '', '0.13.2-5', 'pool/main/a/ascd/ascd_0.13.2-5_i386.deb', '188170', 'CD player and mixer', '');
INSERT INTO `packages_plain` VALUES ('838', 'ascdc', 'optional', 'sound', '56', 'Fredrik Hallenberg ', 'i386', '', '0.3-14', 'pool/main/a/ascdc/ascdc_0.3-14_i386.deb', '20208', 'AfterStep CD changer', '');
INSERT INTO `packages_plain` VALUES ('839', 'ascii', 'optional', 'utils', '72', 'Florian Ernst ', 'i386', '', '3.8-4', 'pool/main/a/ascii/ascii_3.8-4_i386.deb', '16064', 'interactive ASCII name and synonym chart', 'http://www.catb.org/~esr/ascii/');
INSERT INTO `packages_plain` VALUES ('840', 'ascii2binary', 'optional', 'misc', '92', 'Mohammed Sameer ', 'i386', '', '2.13-1', 'pool/main/a/ascii2binary/ascii2binary_2.13-1_i386.deb', '19616', 'Convert between ASCII, hexadecimal and binary representations', '');
INSERT INTO `packages_plain` VALUES ('841', 'asciidoc', 'optional', 'text', '4568', 'Fredrik Steen ', 'all', '', '8.5.1-1', 'pool/main/a/asciidoc/asciidoc_8.5.1-1_all.deb', '1610058', 'Highly configurable text format for writing documentation', '');
INSERT INTO `packages_plain` VALUES ('842', 'asciijump', 'optional', 'games', '356', 'Mario Iseli ', 'i386', '', '0.0.6-4', 'pool/main/a/asciijump/asciijump_0.0.6-4_i386.deb', '27576', 'Small and funny ASCII-art game about ski jumping', '');
INSERT INTO `packages_plain` VALUES ('843', 'asclock-themes', 'optional', 'x11', '2304', 'Helge Kreutzmann ', 'all', 'asclock', '2.0.12-14', 'pool/main/a/asclock/asclock-themes_2.0.12-14_all.deb', '248338', 'Theme files for ASclock, a clock applet', '');
INSERT INTO `packages_plain` VALUES ('844', 'asclock', 'optional', 'x11', '136', 'Helge Kreutzmann ', 'i386', '', '2.0.12-14', 'pool/main/a/asclock/asclock_2.0.12-14_i386.deb', '29692', 'A clock designed with the NeXTStep look', '');
INSERT INTO `packages_plain` VALUES ('845', 'libasedrive-serial', 'optional', 'libs', '108', 'Ludovic Rousseau ', 'i386', 'asedriveiiie', '3.5-3', 'pool/main/a/asedriveiiie/libasedrive-serial_3.5-3_i386.deb', '29088', 'PC/SC driver for the Athena ASEDrive IIIe serial smart card reader', 'http://www.athena-scs.com/');
INSERT INTO `packages_plain` VALUES ('846', 'libasedrive-usb', 'optional', 'libs', '112', 'Ludovic Rousseau ', 'i386', 'asedriveiiie', '3.5-3', 'pool/main/a/asedriveiiie/libasedrive-usb_3.5-3_i386.deb', '27594', 'PC/SC driver for the Athena ASEDrive IIIe USB smart card reader', 'http://www.athena-scs.com/');
INSERT INTO `packages_plain` VALUES ('847', 'libasio-dev', 'optional', 'libdevel', '1984', 'Simon Richter ', 'all', 'asio', '1.4.1-3', 'pool/main/a/asio/libasio-dev_1.4.1-3_all.deb', '222968', 'cross-platform C++ library for network programming', '');
INSERT INTO `packages_plain` VALUES ('848', 'libasio-doc', 'optional', 'doc', '15476', 'Simon Richter ', 'all', 'asio', '1.4.1-3', 'pool/main/a/asio/libasio-doc_1.4.1-3_all.deb', '909876', 'cross-platform C++ library for network programming', '');
INSERT INTO `packages_plain` VALUES ('849', 'asis-programs', 'optional', 'devel', '1968', 'Ludovic Brenta ', 'i386', 'asis', '2007-5', 'pool/main/a/asis/asis-programs_2007-5_i386.deb', '770774', 'Ada Semantic Interface Specification (ASIS) example programs', '');
INSERT INTO `packages_plain` VALUES ('850', 'libasis-dev', 'optional', 'libdevel', '14296', 'Ludovic Brenta ', 'i386', 'asis', '2007-5', 'pool/main/a/asis/libasis-dev_2007-5_i386.deb', '3988118', 'Ada Semantic Interface Specification (ASIS) headers and libraries', '');
INSERT INTO `packages_plain` VALUES ('851', 'libasis2007.1-dbg', 'extra', 'debug', '2908', 'Ludovic Brenta ', 'i386', 'asis', '2007-5', 'pool/main/a/asis/libasis2007.1-dbg_2007-5_i386.deb', '1146748', 'Ada Semantic Interface Specification (ASIS) runtime library - debugging symbols', '');
INSERT INTO `packages_plain` VALUES ('852', 'libasis2007.1', 'optional', 'libs', '1752', 'Ludovic Brenta ', 'i386', 'asis', '2007-5', 'pool/main/a/asis/libasis2007.1_2007-5_i386.deb', '633676', 'Ada Semantic Interface Specification (ASIS) runtime library', '');
INSERT INTO `packages_plain` VALUES ('853', 'libasm-java-doc', 'optional', 'doc', '3660', 'Debian Java Maintainers ', 'all', 'asm', '1.5.3-6', 'pool/main/a/asm/libasm-java-doc_1.5.3-6_all.deb', '267530', 'Documentation for ASM, the Java(TM) bytecode manipulation framework', 'http://asm.objectweb.org/');
INSERT INTO `packages_plain` VALUES ('854', 'libasm-java', 'optional', 'java', '224', 'Debian Java Maintainers ', 'all', 'asm', '1.5.3-6', 'pool/main/a/asm/libasm-java_1.5.3-6_all.deb', '159448', 'Java bytecode manipulation framework', 'http://asm.objectweb.org/');
INSERT INTO `packages_plain` VALUES ('855', 'libasm2-java-doc', 'optional', 'doc', '4360', 'Debian Java Maintainers ', 'all', 'asm2', '2.2.3-4', 'pool/main/a/asm2/libasm2-java-doc_2.2.3-4_all.deb', '343426', 'Documentation for ASM, the Java(TM) bytecode manipulation framework', 'http://asm.objectweb.org/');
INSERT INTO `packages_plain` VALUES ('856', 'libasm2-java', 'optional', 'java', '388', 'Debian Java Maintainers ', 'all', 'asm2', '2.2.3-4', 'pool/main/a/asm2/libasm2-java_2.2.3-4_all.deb', '163256', 'Java bytecode manipulation framework', 'http://asm.objectweb.org/');
INSERT INTO `packages_plain` VALUES ('857', 'libasm3-java-doc', 'optional', 'doc', '6948', 'Debian Java Maintainers ', 'all', 'asm3', '3.2-2', 'pool/main/a/asm3/libasm3-java-doc_3.2-2_all.deb', '610038', 'Documentation for ASM, the Java(TM) bytecode manipulation framework', 'http://asm.objectweb.org/');
INSERT INTO `packages_plain` VALUES ('858', 'libasm3-java', 'optional', 'java', '408', 'Debian Java Maintainers ', 'all', 'asm3', '3.2-2', 'pool/main/a/asm3/libasm3-java_3.2-2_all.deb', '195756', 'Java bytecode manipulation framework', 'http://asm.objectweb.org/');
INSERT INTO `packages_plain` VALUES ('859', 'asmail', 'optional', 'mail', '622', 'Fredrik Hallenberg ', 'i386', '', '2.1-3', 'pool/main/a/asmail/asmail_2.1-3_i386.deb', '219720', 'AfterStep mail monitor', '');
INSERT INTO `packages_plain` VALUES ('860', 'asmix', 'optional', 'x11', '88', 'Varun Hiremath ', 'i386', '', '1.5-4', 'pool/main/a/asmix/asmix_1.5-4_i386.deb', '17100', 'display a volume knob', 'http://www.tigr.net/afterstep/view.php?applet=asmix/data');
INSERT INTO `packages_plain` VALUES ('861', 'asmixer', 'optional', 'sound', '32', 'Fredrik Hallenberg ', 'i386', '', '0.5-14', 'pool/main/a/asmixer/asmixer_0.5-14_i386.deb', '11974', 'AfterStep audio mixer', '');
INSERT INTO `packages_plain` VALUES ('862', 'asmon', 'optional', 'x11', '96', 'Eric Evans ', 'i386', '', '0.71-4', 'pool/main/a/asmon/asmon_0.71-4_i386.deb', '16212', 'system resource monitor dockapp for Afterstep and WindowMaker', 'http://rio.vg/asmon/');
INSERT INTO `packages_plain` VALUES ('863', 'asn1-mode', 'optional', 'editors', '448', 'W. Martin Borgert ', 'all', '', '2.7-6', 'pool/main/a/asn1-mode/asn1-mode_2.7-6_all.deb', '94148', 'Emacs mode for editing ASN.1 specification files', 'http://asn1.elibel.tm.fr/en/tools/emacs/');
INSERT INTO `packages_plain` VALUES ('864', 'asn1c', 'optional', 'devel', '1372', 'W. Martin Borgert ', 'i386', '', '0.9.21.dfsg-4', 'pool/main/a/asn1c/asn1c_0.9.21.dfsg-4_i386.deb', '471722', 'ASN.1 compiler for C', 'http://asn1c.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('865', 'asp', 'extra', 'net', '100', 'Roland Stigge ', 'i386', '', '1.8-6', 'pool/main/a/asp/asp_1.8-6_i386.deb', '18096', 'Discovers present ip-address of dynamically connected hosts', '');
INSERT INTO `packages_plain` VALUES ('866', 'aspectc++', 'optional', 'devel', '1940', 'Reinhard Tartler ', 'i386', '', '1.0pre4~svn.20090918-1', 'pool/main/a/aspectc++/aspectc++_1.0pre4~svn.20090918-1_i386.deb', '655562', 'aspect-oriented programming extension for C++', 'http://www.aspectc.org');
INSERT INTO `packages_plain` VALUES ('867', 'libpuma-dev', 'optional', 'libdevel', '11736', 'Reinhard Tartler ', 'i386', 'aspectc++', '1.0pre4~svn.20090918-1', 'pool/main/a/aspectc++/libpuma-dev_1.0pre4~svn.20090918-1_i386.deb', '1423600', 'C/C++/AspectC++ Scanner and Parsers, development packages', 'http://www.aspectc.org');
INSERT INTO `packages_plain` VALUES ('868', 'libpuma-doc', 'optional', 'doc', '19024', 'Reinhard Tartler ', 'all', 'aspectc++', '1.0pre4~svn.20090918-1', 'pool/main/a/aspectc++/libpuma-doc_1.0pre4~svn.20090918-1_all.deb', '2014940', 'documentation for the PUMA Scanner and Parsers', 'http://www.aspectc.org');
INSERT INTO `packages_plain` VALUES ('869', 'aspectj-doc', 'optional', 'doc', '4324', 'Debian Java maintainers ', 'all', 'aspectj', '1.6.6+dfsg-1', 'pool/main/a/aspectj/aspectj-doc_1.6.6+dfsg-1_all.deb', '648950', 'aspect-oriented extension for Java - documentation', 'http://www.eclipse.org/aspectj');
INSERT INTO `packages_plain` VALUES ('870', 'aspectj', 'optional', 'java', '11324', 'Debian Java maintainers ', 'all', '', '1.6.6+dfsg-1', 'pool/main/a/aspectj/aspectj_1.6.6+dfsg-1_all.deb', '10754940', 'A seamless aspect-oriented extension for Java', 'http://www.eclipse.org/aspectj');
INSERT INTO `packages_plain` VALUES ('871', 'libaspectwerkz2-java', 'optional', 'java', '752', 'Debian Java Maintainers ', 'all', 'aspectwerkz2', '2.0.dfsg.2-1', 'pool/main/a/aspectwerkz2/libaspectwerkz2-java_2.0.dfsg.2-1_all.deb', '645464', 'AOP framework for Java', '');
INSERT INTO `packages_plain` VALUES ('872', 'aspell-am', 'optional', 'text', '176', 'Lior Kaplan ', 'all', '', '0.03-1-3', 'pool/main/a/aspell-am/aspell-am_0.03-1-3_all.deb', '46948', 'Amharic dictionary for aspell', 'ftp://ftp.gnu.org/gnu/aspell/dict/am/');
INSERT INTO `packages_plain` VALUES ('873', 'aspell-ar-large', 'optional', 'text', '2332', 'Debian Arabic Packaging Team ', 'all', '', '1.2-0-1', 'pool/main/a/aspell-ar-large/aspell-ar-large_1.2-0-1_all.deb', '2225022', 'Large Arabic dictionary for aspell', '');
INSERT INTO `packages_plain` VALUES ('874', 'aspell-ar', 'optional', 'text', '200', 'Debian Arabic Packaging Team ', 'all', '', '0.0.20060329-3', 'pool/main/a/aspell-ar/aspell-ar_0.0.20060329-3_all.deb', '107196', 'Arabic dictionary for aspell', '');
INSERT INTO `packages_plain` VALUES ('875', 'aspell-bn', 'optional', 'text', '272', 'Debian-IN Team ', 'all', '', '0.60.0.01.1.1-8', 'pool/main/a/aspell-bn/aspell-bn_0.60.0.01.1.1-8_all.deb', '149640', 'Bengali (bn) dictionary for GNU aspell', 'http://www.bengalinux.org/');
INSERT INTO `packages_plain` VALUES ('876', 'aspell-br', 'optional', 'text', '180', 'Brian Nelson ', 'all', '', '0.50-2-6', 'pool/main/a/aspell-br/aspell-br_0.50-2-6_all.deb', '66216', 'Breton dictionary for GNU Aspell', '');
INSERT INTO `packages_plain` VALUES ('877', 'aspell-cs', 'optional', 'text', '696', 'Miroslav Kure ', 'all', '', '0.0.20040614.1-2', 'pool/main/a/aspell-cs/aspell-cs_0.0.20040614.1-2_all.deb', '560960', 'Czech dictionary for GNU Aspell', '');
INSERT INTO `packages_plain` VALUES ('878', 'aspell-cy', 'optional', 'text', '252', 'Brian Nelson ', 'all', '', '0.50-3-6', 'pool/main/a/aspell-cy/aspell-cy_0.50-3-6_all.deb', '157024', 'Welsh dictionary for GNU Aspell', '');
INSERT INTO `packages_plain` VALUES ('879', 'aspell-el', 'optional', 'text', '532', 'Brian Nelson ', 'all', '', '0.50-3-6', 'pool/main/a/aspell-el/aspell-el_0.50-3-6_all.deb', '434228', 'Greek dictionary for GNU Aspell', '');
INSERT INTO `packages_plain` VALUES ('880', 'aspell-en', 'optional', 'text', '548', 'Brian Nelson ', 'all', '', '6.0-0-5.1', 'pool/main/a/aspell-en/aspell-en_6.0-0-5.1_all.deb', '249438', 'English dictionary for GNU Aspell', '');
INSERT INTO `packages_plain` VALUES ('881', 'aspell-fa', 'optional', 'text', '380', 'Debian Arabic Packaging Team ', 'all', '', '0.11-0-1', 'pool/main/a/aspell-fa/aspell-fa_0.11-0-1_all.deb', '199008', 'Persian dictionary for GNU Aspell', '');
INSERT INTO `packages_plain` VALUES ('882', 'aspell-fr', 'optional', 'text', '644', 'Remi Vanicat ', 'all', '', '0.50-3-6', 'pool/main/a/aspell-fr/aspell-fr_0.50-3-6_all.deb', '376504', 'French dictionary for aspell', '');
INSERT INTO `packages_plain` VALUES ('883', 'aspell-ga', 'optional', 'text', '428', 'Brian Nelson ', 'all', '', '0.50-4-4', 'pool/main/a/aspell-ga/aspell-ga_0.50-4-4_all.deb', '322040', 'Irish (Gaeilge) dictionary for GNU Aspell', '');
INSERT INTO `packages_plain` VALUES ('884', 'aspell-gu', 'optional', 'text', '316', 'Debian-IN Team ', 'all', '', '0.03-0-4', 'pool/main/a/aspell-gu/aspell-gu_0.03-0-4_all.deb', '204932', 'Gujarati (gu) dictionary for GNU aspell', 'http://sourceforge.net/projects/aspell-gu');
INSERT INTO `packages_plain` VALUES ('885', 'aspell-he', 'optional', 'text', '364', 'Debian Hebrew Packaging Team ', 'all', '', '1.0-0-3', 'pool/main/a/aspell-he/aspell-he_1.0-0-3_all.deb', '189670', 'Hebrew dictionary for aspell', 'ftp://ftp.gnu.org/gnu/aspell/dict/he/');
INSERT INTO `packages_plain` VALUES ('886', 'aspell-hi', 'optional', 'text', '316', 'Debian-IN Team ', 'all', '', '0.02-2', 'pool/main/a/aspell-hi/aspell-hi_0.02-2_all.deb', '215236', 'Hindi (hi) dictionary for GNU aspell', 'http://code.indlinux.net/projects/aspell-hindi/');
INSERT INTO `packages_plain` VALUES ('887', 'aspell-hr', 'optional', 'text', '376', 'Vedran FuraГ„ВЌ ', 'all', '', '0.51-4', 'pool/main/a/aspell-hr/aspell-hr_0.51-4_all.deb', '282274', 'The Croatian dictionary for GNU Aspell', '');
INSERT INTO `packages_plain` VALUES ('888', 'aspell-hu', 'optional', 'text', '1144', 'Balint Kozman ', 'all', '', '0.99.4.2-0-3', 'pool/main/a/aspell-hu/aspell-hu_0.99.4.2-0-3_all.deb', '530214', 'Hungarian dictionary for aspell', '');
INSERT INTO `packages_plain` VALUES ('889', 'aspell-hy', 'optional', 'text', '288', 'Alan Baghumian ', 'all', '', '0.10.0-0-1', 'pool/main/a/aspell-hy/aspell-hy_0.10.0-0-1_all.deb', '252028', 'Armenian dictionary for GNU Aspell', '');
INSERT INTO `packages_plain` VALUES ('890', 'aspell-is', 'optional', 'text', '500', 'Brian Nelson ', 'all', '', '0.51-0-4', 'pool/main/a/aspell-is/aspell-is_0.51-0-4_all.deb', '404330', 'Icelandic dictionary for GNU Aspell', '');
INSERT INTO `packages_plain` VALUES ('891', 'aspell-it', 'optional', 'text', '2528', 'Giuseppe Iuculano ', 'all', '', '2.4-20070901-0-2', 'pool/main/a/aspell-it/aspell-it_2.4-20070901-0-2_all.deb', '1053960', 'The Italian dictionary for GNU Aspell', 'http://linguistico.sourceforge.net');
INSERT INTO `packages_plain` VALUES ('892', 'aspell-ku', 'optional', 'text', '116', 'Debian Arabic Packaging Team ', 'all', '', '0.20-0-4', 'pool/main/a/aspell-ku/aspell-ku_0.20-0-4_all.deb', '18800', 'Kurdish dictionary for aspell', 'https://sourceforge.net/projects/myspellkurdish/');
INSERT INTO `packages_plain` VALUES ('893', 'aspell-ml', 'optional', 'text', '684', 'Debian-IN Team ', 'all', '', '0.04-1-2', 'pool/main/a/aspell-ml/aspell-ml_0.04-1-2_all.deb', '588132', 'Malayalam (ml) dictionary for GNU aspell', 'http://fci.wikia.com/wiki/SMC/Aspell_Malayalam');
INSERT INTO `packages_plain` VALUES ('894', 'aspell-mr', 'optional', 'text', '280', 'Debian-IN Team ', 'all', '', '0.10-5', 'pool/main/a/aspell-mr/aspell-mr_0.10-5_all.deb', '188512', 'Marathi (mr) dictionary for GNU aspell', '');
INSERT INTO `packages_plain` VALUES ('895', 'aspell-or', 'optional', 'text', '136', 'Debian-IN Team ', 'all', '', '0.03-1-1', 'pool/main/a/aspell-or/aspell-or_0.03-1-1_all.deb', '16000', 'Oriya (or) dictionary for GNU aspell', 'http://oriya.sarovar.org/dictionary.html');
INSERT INTO `packages_plain` VALUES ('896', 'aspell-pa', 'optional', 'text', '132', 'Debian-IN Team ', 'all', '', '0.01-1-1', 'pool/main/a/aspell-pa/aspell-pa_0.01-1-1_all.deb', '18922', 'Punjabi (pa) dictionary for GNU aspell', 'http://sourceforge.net/projects/punlinux/');
INSERT INTO `packages_plain` VALUES ('897', 'aspell-pl', 'optional', 'text', '1004', 'Krzysztof KrzyГ…Вјaniak (eloy) ', 'all', '', '20090804-1', 'pool/main/a/aspell-pl/aspell-pl_20090804-1_all.deb', '703062', 'Polish dictionary for aspell', '');
INSERT INTO `packages_plain` VALUES ('898', 'aspell-pt', 'optional', 'text', '36', 'Agustin Martin Domingo ', 'all', '', '1.5', 'pool/main/a/aspell-pt/aspell-pt_1.5_all.deb', '3592', 'Portuguese dictionaries for GNU Aspell (old package)', '');
INSERT INTO `packages_plain` VALUES ('899', 'aspell-ro', 'optional', 'text', '592', 'Eddy PetriГ€в„ўor ', 'all', '', '3.1-1', 'pool/main/a/aspell-ro/aspell-ro_3.1-1_all.deb', '508972', 'The Romanian dictionary for GNU aspell', 'http://ftp.gnu.org/gnu/aspell/dict/ro/');
INSERT INTO `packages_plain` VALUES ('900', 'aspell-sk', 'optional', 'text', '640', 'Brian Nelson ', 'all', '', '0.52-0-4', 'pool/main/a/aspell-sk/aspell-sk_0.52-0-4_all.deb', '525190', 'Slovak dictionary for GNU Aspell', '');
INSERT INTO `packages_plain` VALUES ('901', 'aspell-sl', 'optional', 'text', '652', 'Jure Cuhalev ', 'all', '', '0.60-3', 'pool/main/a/aspell-sl/aspell-sl_0.60-3_all.deb', '563426', 'The Slovenian dictionary for GNU Aspell', '');
INSERT INTO `packages_plain` VALUES ('902', 'aspell-sv', 'optional', 'text', '220', 'Magnus Holmgren ', 'all', '', '0.51-0-1', 'pool/main/a/aspell-sv/aspell-sv_0.51-0-1_all.deb', '110910', 'The Swedish dictionary for GNU aspell', '');
INSERT INTO `packages_plain` VALUES ('903', 'aspell-ta', 'optional', 'text', '160', 'Debian-IN Team ', 'all', '', '0.01-4', 'pool/main/a/aspell-ta/aspell-ta_0.01-4_all.deb', '48824', 'Tamil (ta) dictionary for GNU aspell', 'http://developer.thamizha.com/spellchecker');
INSERT INTO `packages_plain` VALUES ('904', 'aspell-te', 'optional', 'text', '516', 'Debian-IN Team ', 'all', '', '0.01-2-1', 'pool/main/a/aspell-te/aspell-te_0.01-2-1_all.deb', '407114', 'Telugu (te) dictionary for GNU aspell', 'http://www.swecha.org/wiki/Wordlist_and_Dictionaries');
INSERT INTO `packages_plain` VALUES ('905', 'aspell-tl', 'optional', 'text', '140', 'Agustin Martin Domingo ', 'all', '', '0.4-0-5', 'pool/main/a/aspell-tl/aspell-tl_0.4-0-5_all.deb', '48494', 'The Tagalog dictionary for GNU Aspell', 'http://code.google.com/p/tagalog-wordlist/');
INSERT INTO `packages_plain` VALUES ('906', 'myspell-tl', 'optional', 'text', '260', 'Agustin Martin Domingo ', 'all', 'aspell-tl', '0.4-0-5', 'pool/main/a/aspell-tl/myspell-tl_0.4-0-5_all.deb', '61134', 'The Tagalog dictionary for myspell/hunspell', 'http://code.google.com/p/tagalog-wordlist/');
INSERT INTO `packages_plain` VALUES ('907', 'aspell-uz', 'optional', 'text', '248', 'Mashrab Kuvatov ', 'all', '', '0.6.0-1', 'pool/main/a/aspell-uz/aspell-uz_0.6.0-1_all.deb', '119626', 'The Uzbek dictionary for GNU Aspell', '');
INSERT INTO `packages_plain` VALUES ('908', 'aspell-doc', 'optional', 'doc', '1096', 'Brian Nelson ', 'all', 'aspell', '0.60.6-2', 'pool/main/a/aspell/aspell-doc_0.60.6-2_all.deb', '304546', 'Documentation for GNU Aspell spell-checker', 'http://aspell.net/');
INSERT INTO `packages_plain` VALUES ('909', 'aspell', 'optional', 'text', '1156', 'Brian Nelson ', 'i386', '', '0.60.6-2', 'pool/main/a/aspell/aspell_0.60.6-2_i386.deb', '289892', 'GNU Aspell spell-checker', 'http://aspell.net/');
INSERT INTO `packages_plain` VALUES ('910', 'libaspell-dev', 'optional', 'libdevel', '124', 'Brian Nelson ', 'i386', 'aspell', '0.60.6-2', 'pool/main/a/aspell/libaspell-dev_0.60.6-2_i386.deb', '50066', 'Development files for applications with GNU Aspell support', 'http://aspell.net/');
INSERT INTO `packages_plain` VALUES ('911', 'libaspell15', 'optional', 'libs', '2356', 'Brian Nelson ', 'i386', 'aspell', '0.60.6-2', 'pool/main/a/aspell/libaspell15_0.60.6-2_i386.deb', '607500', 'GNU Aspell spell-checker runtime library', 'http://aspell.net/');
INSERT INTO `packages_plain` VALUES ('912', 'libpspell-dev', 'optional', 'libdevel', '128', 'Brian Nelson ', 'i386', 'aspell', '0.60.6-2', 'pool/main/a/aspell/libpspell-dev_0.60.6-2_i386.deb', '46544', 'Development files for applications with pspell support', 'http://aspell.net/');
INSERT INTO `packages_plain` VALUES ('913', 'aspell-pt-pt', 'optional', 'text', '268', 'Agustin Martin Domingo ', 'all', 'aspell6.pt', '20090309.0-2', 'pool/main/a/aspell6.pt/aspell-pt-pt_20090309.0-2_all.deb', '118728', 'European Portuguese dictionary for GNU Aspell', 'http://natura.di.uminho.pt/wiki/index.cgi?Aspell');
INSERT INTO `packages_plain` VALUES ('914', 'asql', 'optional', 'admin', '88', 'Steve Kemp ', 'all', '', '1.4-1', 'pool/main/a/asql/asql_1.4-1_all.deb', '16550', 'Run SQL queries against apache logs', 'http://www.steve.org.uk/Software/asql/');
INSERT INTO `packages_plain` VALUES ('915', 'asr-manpages', 'optional', 'doc', '120', 'Pawel Wiecek ', 'all', '', '1.3-6', 'pool/main/a/asr-manpages/asr-manpages_1.3-6_all.deb', '21866', 'alt.sysadmin.recovery manual pages', '');
INSERT INTO `packages_plain` VALUES ('916', 'assogiate', 'optional', 'utils', '560', 'Vincent Legout ', 'i386', '', '0.2.1-1', 'pool/main/a/assogiate/assogiate_0.2.1-1_i386.deb', '202710', 'editor of the MIME file types database', 'http://www.kdau.com/projects/assogiate/');
INSERT INTO `packages_plain` VALUES ('917', 'asterisk-chan-capi', 'optional', 'comm', '332', 'Debian VoIP Team ', 'i386', '', '1.1.4-1', 'pool/main/a/asterisk-chan-capi/asterisk-chan-capi_1.1.4-1_i386.deb', '118966', 'Common ISDN API 2.0 implementation for Asterisk', 'http://www.chan-capi.org/');
INSERT INTO `packages_plain` VALUES ('918', 'asterisk-prompt-de', 'extra', 'comm', '2324', 'Mario Joussen ', 'all', '', '2.0-1', 'pool/main/a/asterisk-prompt-de/asterisk-prompt-de_2.0-1_all.deb', '1448930', 'German voice prompts for the Asterisk PBX', '');
INSERT INTO `packages_plain` VALUES ('919', 'asterisk-prompt-es-co', 'extra', 'comm', '1692', 'Diego AndrГѓВ©s Asenjo GonzГѓВЎlez ', 'all', '', '0.20070403-1', 'pool/main/a/asterisk-prompt-es-co/asterisk-prompt-es-co_0.20070403-1_all.deb', '1002364', 'Colombian Spanish voice prompts for Asterisk', '');
INSERT INTO `packages_plain` VALUES ('920', 'asterisk-prompt-fr-armelle', 'extra', 'comm', '2220', 'Debian VoIP team ', 'all', '', '20070613-2', 'pool/main/a/asterisk-prompt-fr-armelle/asterisk-prompt-fr-armelle_20070613-2_all.deb', '1505024', 'French voice prompts for Asterisk by Armelle Desjardins', '');
INSERT INTO `packages_plain` VALUES ('921', 'asterisk-prompt-fr-proformatique', 'extra', 'comm', '14956', 'Debian VoIP team ', 'all', '', '20070706-1.4-2', 'pool/main/a/asterisk-prompt-fr-proformatique/asterisk-prompt-fr-proformatique_20070706-1.4-2_all.deb', '11886550', 'French voice prompts for Asterisk', '');
INSERT INTO `packages_plain` VALUES ('922', 'asterisk-prompt-it', 'extra', 'comm', '2968', 'Debian VoIP Team ', 'all', '', '20060510-3', 'pool/main/a/asterisk-prompt-it/asterisk-prompt-it_20060510-3_all.deb', '1889428', 'Italian voice prompts for the Asterisk PBX', '');
INSERT INTO `packages_plain` VALUES ('923', 'asterisk-prompt-se', 'extra', 'comm', '7348', 'Simon Richter ', 'all', '', '1.045-1', 'pool/main/a/asterisk-prompt-se/asterisk-prompt-se_1.045-1_all.deb', '4195926', 'Swedish voice prompts for Asterisk', '');
INSERT INTO `packages_plain` VALUES ('924', 'asterisk-sounds-extra', 'optional', 'comm', '6408', 'Debian VoIP Team ', 'all', '', '1.4.9-1', 'pool/main/a/asterisk-sounds-extra/asterisk-sounds-extra_1.4.9-1_all.deb', '3419310', 'Additional sound files for the Asterisk PBX', 'http://www.asterisk.org/');
INSERT INTO `packages_plain` VALUES ('925', 'asterisk-config', 'optional', 'comm', '1400', 'Debian VoIP Team ', 'all', 'asterisk', '1:1.6.2.0~dfsg~rc1-1', 'pool/main/a/asterisk/asterisk-config_1.6.2.0~dfsg~rc1-1_all.deb', '601162', 'Configuration files for Asterisk', 'http://www.asterisk.org/');
INSERT INTO `packages_plain` VALUES ('926', 'asterisk-dbg', 'extra', 'debug', '63884', 'Debian VoIP Team ', 'i386', 'asterisk', '1:1.6.2.0~dfsg~rc1-1', 'pool/main/a/asterisk/asterisk-dbg_1.6.2.0~dfsg~rc1-1_i386.deb', '21247064', 'Debugging symbols for Asterisk', 'http://www.asterisk.org/');
INSERT INTO `packages_plain` VALUES ('927', 'asterisk-dev', 'extra', 'devel', '1592', 'Debian VoIP Team ', 'all', 'asterisk', '1:1.6.2.0~dfsg~rc1-1', 'pool/main/a/asterisk/asterisk-dev_1.6.2.0~dfsg~rc1-1_all.deb', '532718', 'Development files for Asterisk', 'http://www.asterisk.org/');
INSERT INTO `packages_plain` VALUES ('928', 'asterisk-doc', 'extra', 'doc', '3716', 'Debian VoIP Team ', 'all', 'asterisk', '1:1.6.2.0~dfsg~rc1-1', 'pool/main/a/asterisk/asterisk-doc_1.6.2.0~dfsg~rc1-1_all.deb', '1619684', 'Source code documentation for Asterisk', 'http://www.asterisk.org/');
INSERT INTO `packages_plain` VALUES ('929', 'asterisk-h323', 'optional', 'comm', '748', 'Debian VoIP Team ', 'i386', 'asterisk', '1:1.6.2.0~dfsg~rc1-1', 'pool/main/a/asterisk/asterisk-h323_1.6.2.0~dfsg~rc1-1_i386.deb', '427472', 'H.323 protocol support for Asterisk', 'http://www.asterisk.org/');
INSERT INTO `packages_plain` VALUES ('930', 'asterisk-sounds-main', 'optional', 'comm', '3216', 'Debian VoIP Team ', 'all', 'asterisk', '1:1.6.2.0~dfsg~rc1-1', 'pool/main/a/asterisk/asterisk-sounds-main_1.6.2.0~dfsg~rc1-1_all.deb', '2042140', 'Core Sound files for Asterisk (English)', 'http://www.asterisk.org/');
INSERT INTO `packages_plain` VALUES ('931', 'asterisk', 'optional', 'comm', '8880', 'Debian VoIP Team ', 'i386', '', '1:1.6.2.0~dfsg~rc1-1', 'pool/main/a/asterisk/asterisk_1.6.2.0~dfsg~rc1-1_i386.deb', '3364074', 'Open Source Private Branch Exchange (PBX)', 'http://www.asterisk.org/');
INSERT INTO `packages_plain` VALUES ('932', 'astronomical-almanac', 'optional', 'science', '532', 'James R. Van Zandt ', 'i386', '', '5.6-3', 'pool/main/a/astronomical-almanac/astronomical-almanac_5.6-3_i386.deb', '258578', 'astronomical almanac - calculate planet and star positions', 'http://www.moshier.net/');
INSERT INTO `packages_plain` VALUES ('933', 'astyle', 'optional', 'devel', '444', 'Margarita Manterola ', 'i386', '', '1.23-1', 'pool/main/a/astyle/astyle_1.23-1_i386.deb', '129620', 'Source code indenter for C++/C/Java/C# source code', 'http://astyle.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('934', 'asunder', 'optional', 'sound', '592', 'Jens Peter Secher ', 'i386', '', '1.6.2-5', 'pool/main/a/asunder/asunder_1.6.2-5_i386.deb', '92232', 'graphical audio CD ripper and encoder', 'http://www.littlesvr.ca/asunder/');
INSERT INTO `packages_plain` VALUES ('935', 'asused', 'optional', 'utils', '352', 'Jan Wagner ', 'all', '', '3.72-7', 'pool/main/a/asused/asused_3.72-7_all.deb', '84176', 'To run a check on the usage of your registry\'s allocations', 'http://www.ripe.net/tools/');
INSERT INTO `packages_plain` VALUES ('936', 'aswiki', 'optional', 'web', '264', 'TANIGUCHI Takaki ', 'all', '', '1.0.4-10', 'pool/main/a/aswiki/aswiki_1.0.4-10_all.deb', '34028', 'WikiWikiWeb clone (Wiki Engine) written in Ruby', 'http://aswiki.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('937', 'asylum-data', 'optional', 'games', '744', 'Debian Games Team ', 'all', 'asylum', '0.3.2-1', 'pool/main/a/asylum/asylum-data_0.3.2-1_all.deb', '318852', 'surreal platform shooting game - data files', 'http://sdl-asylum.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('938', 'asylum', 'optional', 'games', '212', 'Debian Games Team ', 'i386', '', '0.3.2-1', 'pool/main/a/asylum/asylum_0.3.2-1_i386.deb', '57614', 'surreal platform shooting game', 'http://sdl-asylum.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('939', 'asymptote-doc', 'optional', 'doc', '6976', 'Hubert Chathi ', 'all', 'asymptote', '1.88-2', 'pool/main/a/asymptote/asymptote-doc_1.88-2_all.deb', '4522868', 'documentation and examples for asymptote', 'http://asymptote.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('940', 'asymptote', 'optional', 'tex', '5508', 'Hubert Chathi ', 'i386', '', '1.88-2', 'pool/main/a/asymptote/asymptote_1.88-2_i386.deb', '1808440', 'script-based vector graphics language inspired by MetaPost', 'http://asymptote.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('941', 'at-spi-doc', 'optional', 'doc', '958', 'Debian GNOME Maintainers ', 'all', 'at-spi', '1.28.1-2', 'pool/main/a/at-spi/at-spi-doc_1.28.1-2_all.deb', '182410', 'Documentation files of at-spi for GNOME Accessibility', '');
INSERT INTO `packages_plain` VALUES ('942', 'at-spi', 'optional', 'gnome', '1664', 'Debian GNOME Maintainers ', 'i386', '', '1.28.1-2', 'pool/main/a/at-spi/at-spi_1.28.1-2_i386.deb', '233422', 'Assistive Technology Service Provider Interface', '');
INSERT INTO `packages_plain` VALUES ('943', 'libatspi-dbg', 'extra', 'debug', '1416', 'Debian GNOME Maintainers ', 'i386', 'at-spi', '1.28.1-2', 'pool/main/a/at-spi/libatspi-dbg_1.28.1-2_i386.deb', '529604', 'at-spi libraries and debugging symbols', '');
INSERT INTO `packages_plain` VALUES ('944', 'libatspi-dev', 'optional', 'libdevel', '840', 'Debian GNOME Maintainers ', 'i386', 'at-spi', '1.28.1-2', 'pool/main/a/at-spi/libatspi-dev_1.28.1-2_i386.deb', '163060', 'Development files of at-spi for GNOME Accessibility', '');
INSERT INTO `packages_plain` VALUES ('945', 'libatspi1.0-0', 'optional', 'libs', '576', 'Debian GNOME Maintainers ', 'i386', 'at-spi', '1.28.1-2', 'pool/main/a/at-spi/libatspi1.0-0_1.28.1-2_i386.deb', '223150', 'C binding libraries of at-spi for GNOME Accessibility', '');
INSERT INTO `packages_plain` VALUES ('946', 'python-pyatspi', 'optional', 'python', '224', 'Debian GNOME Maintainers ', 'all', 'at-spi', '1.28.1-2', 'pool/main/a/at-spi/python-pyatspi_1.28.1-2_all.deb', '123786', 'Assistive Technology Service Provider Interface - Python bindings', '');
INSERT INTO `packages_plain` VALUES ('947', 'at', 'standard', 'admin', '208', 'Ansgar Burchardt ', 'i386', '', '3.1.11-1', 'pool/main/a/at/at_3.1.11-1_i386.deb', '44382', 'Delayed job execution and batch processing', '');
INSERT INTO `packages_plain` VALUES ('948', 'atanks-data', 'optional', 'games', '1648', 'Mark Purcell ', 'all', 'atanks', '3.6-1', 'pool/main/a/atanks/atanks-data_3.6-1_all.deb', '1284390', 'data files for Atomic tanks', 'http://atanks.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('949', 'atanks', 'optional', 'games', '416', 'Mark Purcell ', 'i386', '', '3.6-1', 'pool/main/a/atanks/atanks_3.6-1_i386.deb', '169006', 'tank-battling game', 'http://atanks.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('950', 'aterm-ml', 'optional', 'x11', '608', 'Debian QA Group ', 'i386', 'aterm', '1.0.1-7', 'pool/main/a/aterm/aterm-ml_1.0.1-7_i386.deb', '265372', 'Afterstep XVT - a VT102 emulator for the X window system', 'http://aterm.sf.net');
INSERT INTO `packages_plain` VALUES ('951', 'aterm', 'optional', 'x11', '228', 'Debian QA Group ', 'i386', '', '1.0.1-7', 'pool/main/a/aterm/aterm_1.0.1-7_i386.deb', '84760', 'Afterstep XVT - a VT102 emulator for the X window system', 'http://aterm.sf.net');
INSERT INTO `packages_plain` VALUES ('952', 'atftp', 'extra', 'net', '80', 'Ludovic Drolez ', 'i386', '', '0.7.dfsg-8', 'pool/main/a/atftp/atftp_0.7.dfsg-8_i386.deb', '28842', 'advanced TFTP client', '');
INSERT INTO `packages_plain` VALUES ('953', 'atftpd', 'extra', 'net', '176', 'Ludovic Drolez ', 'i386', 'atftp', '0.7.dfsg-8', 'pool/main/a/atftp/atftpd_0.7.dfsg-8_i386.deb', '59160', 'advanced TFTP server', '');
INSERT INTO `packages_plain` VALUES ('954', 'athcool', 'extra', 'misc', '104', 'Nicolas Boullis ', 'i386', '', '0.3.12-3', 'pool/main/a/athcool/athcool_0.3.12-3_i386.deb', '16120', 'tool to enable powersaving mode for Athlon/Duron processors', '');
INSERT INTO `packages_plain` VALUES ('955', 'atheist', 'optional', 'devel', '424', 'Cleto Martin Angelina ', 'all', '', '0.20090921-1', 'pool/main/a/atheist/atheist_0.20090921-1_all.deb', '158566', 'A general purpose command-line testing tool', 'http://crysol.org/es/node/1218');
INSERT INTO `packages_plain` VALUES ('956', 'atheme-services', 'optional', 'net', '2908', 'Debian IRC Team ', 'i386', '', '3.0.4-1', 'pool/main/a/atheme-services/atheme-services_3.0.4-1_i386.deb', '617076', 'modular IRC services daemon', 'http://www.atheme.net');
INSERT INTO `packages_plain` VALUES ('957', 'athena-jot', 'optional', 'utils', '28', 'Francesco Paolo Lovergine ', 'i386', '', '9.0-5', 'pool/main/a/athena-jot/athena-jot_9.0-5_i386.deb', '9876', 'print out increasing, decreasing, random, or redundant data, one per line', '');
INSERT INTO `packages_plain` VALUES ('958', 'atitvout', 'optional', 'misc', '88', 'Philippe Coval ', 'i386', '', '0.4-13', 'pool/main/a/atitvout/atitvout_0.4-13_i386.deb', '20794', 'ATI TV Out Support Program', 'http://0pointer.de/lennart/projects/atitvout/');
INSERT INTO `packages_plain` VALUES ('959', 'libatk1.0-0', 'optional', 'libs', '208', 'Debian GNOME Maintainers ', 'i386', 'atk1.0', '1.28.0-1', 'pool/main/a/atk1.0/libatk1.0-0_1.28.0-1_i386.deb', '81452', 'The ATK accessibility toolkit', 'http://www.gtk.org/');
INSERT INTO `packages_plain` VALUES ('960', 'libatk1.0-data', 'optional', 'misc', '1724', 'Debian GNOME Maintainers ', 'all', 'atk1.0', '1.28.0-1', 'pool/main/a/atk1.0/libatk1.0-data_1.28.0-1_all.deb', '208678', 'Common files for the ATK accessibility toolkit', 'http://www.gtk.org/');
INSERT INTO `packages_plain` VALUES ('961', 'libatk1.0-dbg', 'extra', 'debug', '368', 'Debian GNOME Maintainers ', 'i386', 'atk1.0', '1.28.0-1', 'pool/main/a/atk1.0/libatk1.0-dbg_1.28.0-1_i386.deb', '142430', 'The ATK libraries and debugging symbols', 'http://www.gtk.org/');
INSERT INTO `packages_plain` VALUES ('962', 'libatk1.0-dev', 'optional', 'libdevel', '480', 'Debian GNOME Maintainers ', 'i386', 'atk1.0', '1.28.0-1', 'pool/main/a/atk1.0/libatk1.0-dev_1.28.0-1_i386.deb', '117526', 'Development files for the ATK accessibility toolkit', 'http://www.gtk.org/');
INSERT INTO `packages_plain` VALUES ('963', 'libatk1.0-doc', 'optional', 'doc', '1008', 'Debian GNOME Maintainers ', 'all', 'atk1.0', '1.28.0-1', 'pool/main/a/atk1.0/libatk1.0-doc_1.28.0-1_all.deb', '142006', 'Documentation files for the ATK toolkit', 'http://www.gtk.org/');
INSERT INTO `packages_plain` VALUES ('964', 'libatlas-cpp-0.6-1-dbg', 'extra', 'debug', '3324', 'Michael Koch ', 'i386', 'atlas-cpp', '0.6.1-4', 'pool/main/a/atlas-cpp/libatlas-cpp-0.6-1-dbg_0.6.1-4_i386.deb', '1093064', 'The protocol library of the World Forge project - debugging libs', 'http://www.worldforge.org/');
INSERT INTO `packages_plain` VALUES ('965', 'libatlas-cpp-0.6-1', 'optional', 'libs', '600', 'Michael Koch ', 'i386', 'atlas-cpp', '0.6.1-4', 'pool/main/a/atlas-cpp/libatlas-cpp-0.6-1_0.6.1-4_i386.deb', '198094', 'The protocol library of the World Forge project - runtime libs', 'http://www.worldforge.org/');
INSERT INTO `packages_plain` VALUES ('966', 'libatlas-cpp-0.6-dev', 'optional', 'libdevel', '392', 'Michael Koch ', 'i386', 'atlas-cpp', '0.6.1-4', 'pool/main/a/atlas-cpp/libatlas-cpp-0.6-dev_0.6.1-4_i386.deb', '53676', 'The protocol library of the World Forge project - header files', 'http://www.worldforge.org/');
INSERT INTO `packages_plain` VALUES ('967', 'libatlas-cpp-doc', 'optional', 'doc', '9764', 'Michael Koch ', 'all', 'atlas-cpp', '0.6.1-4', 'pool/main/a/atlas-cpp/libatlas-cpp-doc_0.6.1-4_all.deb', '1363782', 'The protocol library of the World Forge project - documentation', 'http://www.worldforge.org/');
INSERT INTO `packages_plain` VALUES ('968', 'libatlas-3dnow-dev', 'optional', 'devel', '28164', 'Debian Scientific Computing Team ', 'i386', 'atlas', '3.6.0-24', 'pool/main/a/atlas/libatlas-3dnow-dev_3.6.0-24_i386.deb', '6224982', 'Automatically Tuned Linear Algebra Software,3dnow static', 'http://math-atlas.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('969', 'libatlas-base-dev', 'optional', 'devel', '22200', 'Debian Scientific Computing Team ', 'i386', 'atlas', '3.6.0-24', 'pool/main/a/atlas/libatlas-base-dev_3.6.0-24_i386.deb', '5754786', 'Automatically Tuned Linear Algebra Software,generic static', 'http://math-atlas.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('970', 'libatlas-doc', 'optional', 'doc', '756', 'Debian Scientific Computing Team ', 'all', 'atlas', '3.6.0-24', 'pool/main/a/atlas/libatlas-doc_3.6.0-24_all.deb', '683292', 'Automatically Tuned Linear Algebra Software,documentation', 'http://math-atlas.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('971', 'libatlas-headers', 'optional', 'devel', '112', 'Debian Scientific Computing Team ', 'all', 'atlas', '3.6.0-24', 'pool/main/a/atlas/libatlas-headers_3.6.0-24_all.deb', '21590', 'Automatically Tuned Linear Algebra Software,C header files', 'http://math-atlas.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('972', 'libatlas-sse-dev', 'optional', 'devel', '23076', 'Debian Scientific Computing Team ', 'i386', 'atlas', '3.6.0-24', 'pool/main/a/atlas/libatlas-sse-dev_3.6.0-24_i386.deb', '5849124', 'Automatically Tuned Linear Algebra Software,SSE1 static', 'http://math-atlas.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('973', 'libatlas-sse2-dev', 'optional', 'devel', '27628', 'Debian Scientific Computing Team ', 'i386', 'atlas', '3.6.0-24', 'pool/main/a/atlas/libatlas-sse2-dev_3.6.0-24_i386.deb', '6509440', 'Automatically Tuned Linear Algebra Software,SSE2 static', 'http://math-atlas.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('974', 'libatlas-test', 'extra', 'devel', '2048', 'Debian Scientific Computing Team ', 'i386', 'atlas', '3.6.0-24', 'pool/main/a/atlas/libatlas-test_3.6.0-24_i386.deb', '572188', 'Automatically Tuned Linear Algebra Software,test programs', 'http://math-atlas.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('975', 'libatlas3gf-3dnow', 'optional', 'libs', '18804', 'Debian Scientific Computing Team ', 'i386', 'atlas', '3.6.0-24', 'pool/main/a/atlas/libatlas3gf-3dnow_3.6.0-24_i386.deb', '5487668', 'Automatically Tuned Linear Algebra Software,3dnow shared', 'http://math-atlas.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('976', 'libatlas3gf-base', 'optional', 'libs', '14084', 'Debian Scientific Computing Team ', 'i386', 'atlas', '3.6.0-24', 'pool/main/a/atlas/libatlas3gf-base_3.6.0-24_i386.deb', '5159058', 'Automatically Tuned Linear Algebra Software,generic shared', 'http://math-atlas.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('977', 'libatlas3gf-sse2', 'optional', 'libs', '18704', 'Debian Scientific Computing Team ', 'i386', 'atlas', '3.6.0-24', 'pool/main/a/atlas/libatlas3gf-sse2_3.6.0-24_i386.deb', '5712514', 'Automatically Tuned Linear Algebra Software,SSE2 shared', 'http://math-atlas.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('978', 'libatlas3gf-sse', 'optional', 'libs', '14496', 'Debian Scientific Computing Team ', 'i386', 'atlas', '3.6.0-24', 'pool/main/a/atlas/libatlas3gf-sse_3.6.0-24_i386.deb', '5098246', 'Automatically Tuned Linear Algebra Software,SSE1 shared', 'http://math-atlas.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('979', 'atlc-examples', 'optional', 'electronics', '130224', 'Bdale Garbee ', 'all', 'atlc', '4.6.0-1', 'pool/main/a/atlc/atlc-examples_4.6.0-1_all.deb', '1059782', 'Examples for Arbitrary Transmission Line Calculator', '');
INSERT INTO `packages_plain` VALUES ('980', 'atlc', 'optional', 'electronics', '2548', 'Bdale Garbee ', 'i386', '', '4.6.0-1', 'pool/main/a/atlc/atlc_4.6.0-1_i386.deb', '1253480', 'Arbitrary Transmission Line Calculator', '');
INSERT INTO `packages_plain` VALUES ('981', 'atom4', 'optional', 'games', '336', 'Hwei Sheng Teoh ', 'i386', '', '4.1-4', 'pool/main/a/atom4/atom4_4.1-4_i386.deb', '48456', 'An original two-player color puzzle game', '');
INSERT INTO `packages_plain` VALUES ('982', 'atomicparsley', 'optional', 'video', '288', 'Jonas Smedegaard ', 'i386', '', '0.9.2~svn110-2', 'pool/main/a/atomicparsley/atomicparsley_0.9.2~svn110-2_i386.deb', '110918', 'read, parse and set metadata of MPEG-4 and 3gp files', 'http://atomicparsley.sourceforge.net/');
INSERT INTO `packages_plain` VALUES ('983', 'atomix-data', 'optional', 'games', '596', 'Guilherme de S. Pastore ', 'all', 'atomix', '2.14.0-1', 'pool/main/a/atomix/atomix-data_2.14.0-1_all.deb', '109554', 'architecture independent files for atomix', '');
INSERT INTO `packages_plain` VALUES ('984', 'atomix', 'optional', 'games', '120', 'Guilherme de S. Pastore ', 'i386', '', '2.14.0-1', 'pool/main/a/atomix/atomix_2.14.0-1_i386.deb', '51042', 'puzzle game for building molecules out of isolated atoms', '');
INSERT INTO `packages_plain` VALUES ('985', 'atool', 'optional', 'utils', '196', 'Francois Marier ', 'all', '', '0.37.0-2', 'pool/main/a/atool/atool_0.37.0-2_all.deb', '44266', 'A tool for managing file archives of various types', 'http://www.nongnu.org/atool/');
INSERT INTO `packages_plain` VALUES ('986', 'atop', 'optional', 'admin', '260', 'Edelhard Becker ', 'i386', '', '1.23-1', 'pool/main/a/atop/atop_1.23-1_i386.deb', '78122', 'Monitor for system resources and process activity', 'http://www.atconsultancy.nl/atop/home.html');
INSERT INTO `packages_plain` VALUES ('987', 'kernel-patch-atopacct', 'optional', 'kernel', '116', 'Edelhard Becker ', 'all', 'atoppatch', '1:1.23-1', 'pool/main/a/atoppatch/kernel-patch-atopacct_1.23-1_all.deb', '18206', 'save additional statistical counters for atop in the record', 'http://www.atconsultancy.nl/atop/kernpatch.html');
INSERT INTO `packages_plain` VALUES ('988', 'kernel-patch-atopcnt', 'optional', 'kernel', '132', 'Edelhard Becker ', 'all', 'atoppatch', '1:1.23-1', 'pool/main/a/atoppatch/kernel-patch-atopcnt_1.23-1_all.deb', '22784', 'additional statistical counters for atop', 'http://www.atconsultancy.nl/atop/kernpatch.html');
INSERT INTO `packages_plain` VALUES ('989', 'atp', 'optional', 'text', '96', 'Hamish Moffatt ', 'i386', '', '1.2-11', 'pool/main/a/atp/atp_1.2-11_i386.deb', '25674', 'text to PostScript converter with some C syntax highlighting', '');
INSERT INTO `packages_plain` VALUES ('990', 'atris', 'optional', 'games', '960', 'Pascal Giard ', 'i386', '', '1.0.7.dfsg.1-7.1', 'pool/main/a/atris/atris_1.0.7.dfsg.1-7.1_i386.deb', '319278', 'tetris-like game with a twist for Unix', '');
INSERT INTO `packages_plain` VALUES ('991', 'atsar', 'optional', 'admin', '108', 'Michael Stone ', 'i386', '', '1.7-2', 'pool/main/a/atsar/atsar_1.7-2_i386.deb', '40964', 'system activity reporter', '');
INSERT INTO `packages_plain` VALUES ('992', 'attal-themes-medieval', 'optional', 'games', '39224', 'Debian Games Team ', 'all', 'attal-themes', '1.0~rc2.dfsg1-1', 'pool/main/a/attal-themes/attal-themes-medieval_1.0~rc2.dfsg1-1_all.deb', '34768600', 'medieval theme for attal', 'http://www.attal-thegame.org/');
INSERT INTO `packages_plain` VALUES ('993', 'attal', 'optional', 'games', '3332', 'Debian Games Team ', 'i386', '', '1.0~rc2-2', 'pool/main/a/attal/attal_1.0~rc2-2_i386.deb', '1113180', 'turn-based strategy game', 'http://www.attal-thegame.org/');
INSERT INTO `packages_plain` VALUES ('994', 'attr', 'optional', 'utils', '248', 'Nathan Scott ', 'i386', '', '1:2.4.44-1', 'pool/main/a/attr/attr_2.4.44-1_i386.deb', '45072', 'Utilities for manipulating filesystem extended attributes', 'http://savannah.nongnu.org/projects/attr/');
INSERT INTO `packages_plain` VALUES ('995', 'libattr1-dev', 'extra', 'libdevel', '140', 'Nathan Scott ', 'i386', 'attr', '1:2.4.44-1', 'pool/main/a/attr/libattr1-dev_2.4.44-1_i386.deb', '34454', 'Extended attribute static libraries and headers', 'http://savannah.nongnu.org/projects/attr/');
INSERT INTO `packages_plain` VALUES ('996', 'libattr1', 'required', 'libs', '64', 'Nathan Scott ', 'i386', 'attr', '1:2.4.44-1', 'pool/main/a/attr/libattr1_2.4.44-1_i386.deb', '11846', 'Extended attribute shared library', 'http://savannah.nongnu.org/projects/attr/');
INSERT INTO `packages_plain` VALUES ('997', 'aub', 'optional', 'news', '196', 'Debian QA Group ', 'all', '', '2.2.2', 'pool/main/a/aub/aub_2.2.2_all.deb', '60308', 'Assembles binary files from USENET', '');
INSERT INTO `packages_plain` VALUES ('998', 'aubio-tools', 'optional', 'sound', '148', 'Paul Brossier ', 'i386', 'aubio', '0.3.2-4', 'pool/main/a/aubio/aubio-tools_0.3.2-4_i386.deb', '30600', 'a library for audio segmentation -- utilities', '');
INSERT INTO `packages_plain` VALUES ('999', 'libaubio-dev', 'optional', 'libdevel', '364', 'Paul Brossier ', 'i386', 'aubio', '0.3.2-4', 'pool/main/a/aubio/libaubio-dev_0.3.2-4_i386.deb', '68364', 'a library for audio segmentation', '');
INSERT INTO `packages_plain` VALUES ('1000', 'libaubio-doc', 'optional', 'doc', '1828', 'Paul Brossier ', 'all', 'aubio', '0.3.2-4', 'pool/main/a/aubio/libaubio-doc_0.3.2-4_all.deb', '286504', 'a library for audio segmentation -- documentation', '');
INSERT INTO `packages_small` VALUES ('1', 'acx100-source', 'extra', 'contrib/kernel', '296', 'Stefano Canepa ', 'all', 'acx100', '20080210-1.1', 'pool/contrib/a/acx100/acx100-source_20080210-1.1_all.deb', '229468', 'ACX100/ACX111 wireless network drivers source', 'http://acx100.sourceforge.net/');
INSERT INTO `packages_small` VALUES ('2', 'alien-arena-browser', 'extra', 'contrib/games', '160', 'Debian Games Team ', 'all', 'alien-arena', '7.0-1', 'pool/contrib/a/alien-arena/alien-arena-browser_7.0-1_all.deb', '37128', 'stand alone server browser for Alien Arena', 'http://red.planetarena.org');
INSERT INTO `packages_small` VALUES ('3', 'alien-arena-server', 'extra', 'contrib/games', '260', 'Debian Games Team ', 'i386', 'alien-arena', '7.0-1', 'pool/contrib/a/alien-arena/alien-arena-server_7.0-1_i386.deb', '130272', 'Dedicated server for Alien Arena', 'http://red.planetarena.org');
INSERT INTO `packages_small` VALUES ('4', 'alien-arena', 'extra', 'contrib/games', '1204', 'Debian Games Team ', 'i386', '', '7.0-1', 'pool/contrib/a/alien-arena/alien-arena_7.0-1_i386.deb', '579978', 'Standalone 3D first person online deathmatch shooter', 'http://red.planetarena.org');
INSERT INTO `packages_small` VALUES ('5', 'alsa-firmware-loaders', 'extra', 'contrib/sound', '228', 'Debian ALSA Maintainers ', 'i386', 'alsa-tools', '1.0.21-1', 'pool/contrib/a/alsa-tools/alsa-firmware-loaders_1.0.21-1_i386.deb', '32758', 'ALSA software loaders for specific hardware', 'http://www.alsa-project.org/');
INSERT INTO `packages_small` VALUES ('6', 'amoeba', 'optional', 'contrib/x11', '276', 'Steinar H. Gunderson ', 'i386', '', '1.1-20', 'pool/contrib/a/amoeba/amoeba_1.1-20_i386.deb', '94052', 'fast-paced, polished OpenGL demonstration by Excess', '');
INSERT INTO `packages_small` VALUES ('7', 'atari800', 'optional', 'contrib/otherosfs', '1848', 'Antonin Kral ', 'i386', '', '2.1.0-1', 'pool/contrib/a/atari800/atari800_2.1.0-1_i386.deb', '763238', 'Atari emulator for X/curses/SDL', '');
INSERT INTO `packages_small` VALUES ('8', 'avifile-divx-plugin', 'optional', 'contrib/video', '28', 'Debian QA Group ', 'i386', 'avifile', '1:0.7.48~20090503.ds-1', 'pool/contrib/a/avifile/avifile-divx-plugin_0.7.48~20090503.ds-1_i386.deb', '950', 'Divx4Linux video de/encoding plugin for libavifile', 'http://avifile.sf.net');
INSERT INTO `packages_small` VALUES ('9', 'avifile-win32-plugin', 'optional', 'contrib/video', '268', 'Debian QA Group ', 'i386', 'avifile', '1:0.7.48~20090503.ds-1', 'pool/contrib/a/avifile/avifile-win32-plugin_0.7.48~20090503.ds-1_i386.deb', '97404', 'Win32 audio/video plugin for libavifile', 'http://avifile.sf.net');
INSERT INTO `packages_small` VALUES ('10', 'avifile-xvid-plugin', 'optional', 'contrib/video', '28', 'Debian QA Group ', 'i386', 'avifile', '1:0.7.48~20090503.ds-1', 'pool/contrib/a/avifile/avifile-xvid-plugin_0.7.48~20090503.ds-1_i386.deb', '928', 'XviD video encoding plugin for libavifile', 'http://avifile.sf.net');
INSERT INTO `phones2` VALUES ('1', '123-45-01', '1', 'working');
INSERT INTO `phones2` VALUES ('2', '123-45-02', '2', 'home');
INSERT INTO `phones2` VALUES ('5', '123-45-05', '5', 'home');
INSERT INTO `phones2` VALUES ('3', '123-45-03', '3', 'fax');
INSERT INTO `phones2` VALUES ('4', '123-45-04', '4', 'working');
INSERT INTO `phones2` VALUES ('6', '123-45-06', '6', 'fax');
INSERT INTO `phones2` VALUES ('7', '123-45-07', '7', 'working');
INSERT INTO `phones2` VALUES ('8', '123-45-08', '8', 'home');
INSERT INTO `phones2` VALUES ('9', '123-45-09', '9', 'fax');
INSERT INTO `phones2` VALUES ('10', '123-45-10', '10', 'working');
INSERT INTO `phones2` VALUES ('11', '123-45-11', '11', 'home');
INSERT INTO `phones2` VALUES ('12', '123-45-12', '12', 'fax');
INSERT INTO `phones2` VALUES ('13', '123-45-13', '13', 'working');
INSERT INTO `phones2` VALUES ('14', '123-45-14', '14', 'home');
INSERT INTO `phones2` VALUES ('15', '123-45-15', '15', 'fax');
INSERT INTO `phones2` VALUES ('16', '123-45-16', '16', 'working');
INSERT INTO `phones2` VALUES ('17', '123-45-17', '17', 'home');
INSERT INTO `phones2` VALUES ('18', '123-45-18', '18', 'fax');
INSERT INTO `phones2` VALUES ('19', '123-45-19', '19', 'working');
INSERT INTO `phones2` VALUES ('20', '123-45-20', '20', 'home');
INSERT INTO `phones2` VALUES ('21', '123-45-21', '21', 'fax');
INSERT INTO `phones2` VALUES ('22', '123-45-22', '22', 'working');
INSERT INTO `phones2` VALUES ('23', '123-45-23', '23', 'home');
INSERT INTO `phones2` VALUES ('24', '123-45-24', '24', 'fax');
INSERT INTO `phones2` VALUES ('25', '123-45-25', '25', 'working');
INSERT INTO `phones2` VALUES ('26', '123-45-26', '26', 'home');
INSERT INTO `phones2` VALUES ('27', '123-45-27', '27', 'fax');
INSERT INTO `phones2` VALUES ('28', '123-45-28', '28', 'working');
INSERT INTO `phones2` VALUES ('29', '123-45-29', '29', 'home');
INSERT INTO `phones2` VALUES ('30', '123-45-30', '30', 'fax');
INSERT INTO `phones2` VALUES ('31', '123-45-31', '1', 'working');
INSERT INTO `phones2` VALUES ('32', '123-45-32', '2', 'home');
INSERT INTO `phones2` VALUES ('33', '123-45-33', '3', 'fax');
INSERT INTO `phones2` VALUES ('34', '123-45-34', '4', 'working');
INSERT INTO `phones2` VALUES ('35', '123-45-35', '5', 'home');
INSERT INTO `phones2` VALUES ('36', '123-45-36', '6', 'fax');
INSERT INTO `phones2` VALUES ('37', '123-45-37', '7', 'working');
INSERT INTO `phones2` VALUES ('38', '123-45-38', '8', 'home');
INSERT INTO `phones2` VALUES ('39', '123-45-39', '9', 'fax');
INSERT INTO `phones2` VALUES ('40', '123-45-40', '10', 'working');
INSERT INTO `phones2` VALUES ('41', '123-45-41', '11', 'home');
INSERT INTO `phones2` VALUES ('42', '123-45-42', '12', 'fax');
INSERT INTO `phones2` VALUES ('43', '123-45-43', '13', 'working');
INSERT INTO `phones2` VALUES ('44', '123-45-44', '14', 'home');
INSERT INTO `phones2` VALUES ('45', '123-45-45', '15', 'fax');
INSERT INTO `products2` VALUES ('1', 'Nokia 5230', 'mobile phone', '250', 'black');
INSERT INTO `products2` VALUES ('2', 'Samsung GT-S5230', 'mobile phone', '170', 'gray');
INSERT INTO `products2` VALUES ('3', 'LG KP500 Cookie', 'mobile phone', '150', 'rose');
INSERT INTO `products2` VALUES ('4', 'Apple iPhone 3G (8Gb)', 'mobile phone', '700', 'black');
INSERT INTO `products2` VALUES ('5', 'ASUS Eee PC 1005PE-BLK065S', 'notebook', '450', 'black');
INSERT INTO `products2` VALUES ('6', 'HP Compaq 615 (VC289EA)', 'notebook', '600', 'gray');
INSERT INTO `products2` VALUES ('7', 'Toshiba Satellite A505-S6960', 'notebook', '900', 'black');
INSERT INTO `products2` VALUES ('8', 'ASUS Eee PC 1000H (160Gb)', 'notebook', '400', 'white');
INSERT INTO `products2` VALUES ('9', 'Canon PowerShot SX120 IS', 'photo', '250', 'gray');
INSERT INTO `products2` VALUES ('10', 'Sony CyberShot DSC-H20', 'photo', '320', 'white');
INSERT INTO `products2` VALUES ('11', 'Nikon D3000', 'photo', '600', 'black');
INSERT INTO `products2` VALUES ('12', 'Nikon D90', 'photo', '1100', 'black');
INSERT INTO `products2` VALUES ('13', 'Microlab M-880', 'audio', '65', 'white');
INSERT INTO `products2` VALUES ('14', 'Microlab Solo-7C', 'audio', '200', 'gray');
INSERT INTO `products2` VALUES ('15', 'F&D D80', 'audio', '210', 'black');
INSERT INTO `products2` VALUES ('16', 'Microlab Pro 3', 'audio', '180', 'black');
INSERT INTO `products2` VALUES ('17', 'BenQ MP515', 'projector', '630', 'white');
INSERT INTO `products2` VALUES ('18', 'Epson EH-TW450', 'projector', '1400', 'rose');
INSERT INTO `products2` VALUES ('19', 'NEC NP215', 'projector', '870', 'black');
INSERT INTO `products2` VALUES ('20', 'Epson EB- S72', 'projector', '700', 'gray');
INSERT INTO `products2` VALUES ('21', 'D-Link DIR-300', 'network', '55', 'gray');
INSERT INTO `products2` VALUES ('22', 'Zyxel P-660HTW2 EE', 'network', '120', 'black');
INSERT INTO `products2` VALUES ('23', 'Acorp Sprinter@ADSL W422G', 'network', '70', 'black');
INSERT INTO `products2` VALUES ('24', 'D-Link DIR-300/NRU', 'network', '65', 'black');
INSERT INTO `project_team2` VALUES ('1', '1', '1');
INSERT INTO `project_team2` VALUES ('2', '1', '2');
INSERT INTO `project_team2` VALUES ('3', '2', '3');
INSERT INTO `project_team2` VALUES ('4', '2', '4');
INSERT INTO `project_team2` VALUES ('5', '3', '5');
INSERT INTO `project_team2` VALUES ('6', '3', '6');
INSERT INTO `project_team2` VALUES ('7', '4', '7');
INSERT INTO `project_team2` VALUES ('8', '4', '8');
INSERT INTO `project_team2` VALUES ('9', '1', '9');
INSERT INTO `project_team2` VALUES ('10', '2', '9');
INSERT INTO `project_team2` VALUES ('11', '3', '10');
INSERT INTO `project_team2` VALUES ('12', '4', '10');
INSERT INTO `projects2` VALUES ('1', 'Project 1', 'The first project for testing Treegrid multitable dhtmlxConnector');
INSERT INTO `projects2` VALUES ('2', 'Project 2', 'The second project for testing Treegrid multitable dhtmlxConnector');
INSERT INTO `projects2` VALUES ('3', 'Project 3', 'The third project for testing Treegrid multitable dhtmlxConnector');
INSERT INTO `projects2` VALUES ('4', 'Project 4', 'The fourth project for testing Treegrid multitable dhtmlxConnector');
INSERT INTO `tasks` VALUES ('1003', '1001', 'Task 0000021212121qwqwqsdsd', '27.0', '111.0', '2007-02-09', '2007-02-22', '48', '', 'BX');
INSERT INTO `tasks` VALUES ('1004', '1001', 'Task 581814', '27.0', '1.0', '2007-02-06', '2007-02-25', '33', '', 'CW');
INSERT INTO `tasks` VALUES ('1005', '1001', 'Task 125488', '30.0', '12.0', '2007-02-08', '2007-02-25', '40', '', 'CW');
INSERT INTO `tasks` VALUES ('1006', '1001', 'Task 541992', '4.0', '2.0', '2007-02-11', '2007-02-19', '50', '', 'CW');
INSERT INTO `tasks` VALUES ('1007', '1001', 'Task 182020', '16.0', '8.0', '2007-02-11', '2007-02-21', '50', '', 'CW');
INSERT INTO `tasks` VALUES ('1008', '1001', 'Task 812934', '30.0', '16.0', '2007-02-13', '2007-02-20', '53', '', 'AZ');
INSERT INTO `tasks` VALUES ('1009', '1001', 'Task 729871', '6.0', '2.0', '2007-02-09', '2007-02-19', '33', '', 'CW');
INSERT INTO `tasks` VALUES ('1010', '1001', 'Task 311306', '3.0', '2.0', '2007-02-06', '2007-02-18', '66', '', 'BX');
INSERT INTO `tasks` VALUES ('1011', '1001', 'Task 463487', '4.0', '4.0', '2007-02-11', '2007-02-18', '100', '', 'BX');
INSERT INTO `tasks` VALUES ('1101', '1000', 'Version 1.2', '12.0', '5.0', '2007-02-10', '2007-02-18', '41', '', 'AZ');
INSERT INTO `tasks` VALUES ('1102', '1101', 'Task 228651', '3.0', '3.0', '2007-02-07', '2007-02-23', '100', '', 'CW');
INSERT INTO `tasks` VALUES ('1103', '1101', 'Task 319851', '7.0', '1.0', '2007-02-09', '2007-02-21', '14', '', 'BX');
INSERT INTO `tasks` VALUES ('1104', '1101', 'Task 903672', '4.0', '4.0', '2007-02-13', '2007-02-25', '100', '', 'CW');
INSERT INTO `tasks` VALUES ('1105', '1101', 'Task 705810', '21.0', '11.0', '2007-02-13', '2007-02-17', '52', '', 'AZ');
INSERT INTO `tasks` VALUES ('1106', '1101', 'Task 646402', '19.0', '10.0', '2007-02-11', '2007-02-22', '52', '', 'CW');
INSERT INTO `tasks` VALUES ('1107', '1101', 'Task 506700', '25.0', '17.0', '2007-02-11', '2007-02-23', '68', '', 'AZ');
INSERT INTO `tasks` VALUES ('1108', '1101', 'Task 929063', '13.0', '1.0', '2007-02-06', '2007-02-18', '7', '', 'BX');
INSERT INTO `tasks` VALUES ('1109', '1101', 'Task 972520', '5.0', '3.0', '2007-02-11', '2007-02-19', '60', '', 'AZ');
INSERT INTO `tasks` VALUES ('1110', '1101', 'Task 112765', '22.0', '3.0', '2007-02-09', '2007-02-20', '13', '', 'CW');
INSERT INTO `tasks` VALUES ('1111', '1101', 'Task 242160', '23.0', '18.0', '2007-02-07', '2007-02-21', '78', '', 'AZ');
INSERT INTO `tasks` VALUES ('1201', '1000', 'Version 1.3', '11.0', '11.0', '2007-02-05', '2007-02-22', '100', '', 'BX');
INSERT INTO `tasks` VALUES ('1202', '1201', 'Task 513075', '16.0', '1.0', '2007-02-10', '2007-02-24', '6', '', 'CW');
INSERT INTO `tasks` VALUES ('1203', '1201', 'Task 495551', '12.0', '7.0', '2007-02-13', '2007-02-24', '58', '', 'AZ');
INSERT INTO `tasks` VALUES ('1204', '1201', 'Task 507107', '18.0', '5.0', '2007-02-06', '2007-02-19', '27', '', 'CW');
INSERT INTO `tasks` VALUES ('1205', '1201', 'Task 315104', '18.0', '3.0', '2007-02-07', '2007-02-23', '16', '', 'CW');
INSERT INTO `tasks` VALUES ('1206', '1201', 'Task 659125', '27.0', '21.0', '2007-02-11', '2007-02-18', '77', '', 'CW');
INSERT INTO `tasks` VALUES ('1207', '1201', 'Task 806532', '6.0', '3.0', '2007-02-06', '2007-02-20', '50', '', 'BX');
INSERT INTO `tasks` VALUES ('1208', '1201', 'Task 552463', '18.0', '12.0', '2007-02-12', '2007-02-17', '66', '', 'CW');
INSERT INTO `tasks` VALUES ('1209', '1201', 'Task 442057', '1.0', '0.0', '2007-02-09', '2007-02-19', '0', '', 'CW');
INSERT INTO `tasks` VALUES ('1210', '1201', 'Task 214897', '11.0', '4.0', '2007-02-12', '2007-02-20', '36', '', 'BX');
INSERT INTO `tasks` VALUES ('1211', '1201', 'Task 805012', '18.0', '11.0', '2007-02-11', '2007-02-20', '61', '', 'CW');
INSERT INTO `tasks` VALUES ('1301', '1000', 'Version 1.4', '9.0', '0.0', '2007-02-08', '2007-02-21', '0', '', 'AZ');
INSERT INTO `tasks` VALUES ('1302', '1301', 'Task 174994', '1.0', '1.0', '2007-02-13', '2007-02-18', '100', '', 'BX');
INSERT INTO `tasks` VALUES ('1303', '1301', 'Task 806559', '9.0', '0.0', '2007-02-14', '2007-02-18', '0', '', 'AZ');
INSERT INTO `tasks` VALUES ('1304', '1301', 'Task 274495', '7.0', '6.0', '2007-02-12', '2007-02-23', '85', '', 'AZ');
INSERT INTO `tasks` VALUES ('1305', '1301', 'Task 776719', '21.0', '19.0', '2007-02-11', '2007-02-19', '90', '', 'CW');
INSERT INTO `tasks` VALUES ('1306', '1301', 'Task 261148', '7.0', '7.0', '2007-02-12', '2007-02-24', '100', '', 'BX');
INSERT INTO `tasks` VALUES ('1307', '1301', 'Task 647922', '7.0', '3.0', '2007-02-06', '2007-02-22', '42', '', 'BX');
INSERT INTO `tasks` VALUES ('1308', '1301', 'Task 940511', '4.0', '1.0', '2007-02-06', '2007-02-19', '25', '', 'CW');
INSERT INTO `tasks` VALUES ('1309', '1301', 'Task 114610', '22.0', '15.0', '2007-02-12', '2007-02-21', '68', '', 'AZ');
INSERT INTO `tasks` VALUES ('1310', '1301', 'Task 895914', '13.0', '11.0', '2007-02-12', '2007-02-25', '84', '', 'BX');
INSERT INTO `tasks` VALUES ('1311', '1301', 'Task 204562', '14.0', '7.0', '2007-02-12', '2007-02-23', '50', '', 'BX');
INSERT INTO `tasks` VALUES ('1401', '1000', 'Version 1.5', '4.0', '4.0', '2007-02-13', '2007-02-20', '100', '', 'AZ');
INSERT INTO `tasks` VALUES ('1402', '1401', 'Task 567274', '28.0', '4.0', '2007-02-10', '2007-02-18', '14', '', 'CW');
INSERT INTO `tasks` VALUES ('1403', '1401', 'Task 671712', '17.0', '14.0', '2007-02-09', '2007-02-20', '82', '', 'CW');
INSERT INTO `tasks` VALUES ('1404', '1401', 'Task 718424', '14.0', '2.0', '2007-02-10', '2007-02-19', '14', '', 'BX');
INSERT INTO `tasks` VALUES ('1405', '1401', 'Task 280327', '17.0', '8.0', '2007-02-06', '2007-02-17', '47', '', 'BX');
INSERT INTO `tasks` VALUES ('1406', '1401', 'Task 569227', '13.0', '3.0', '2007-02-08', '2007-02-22', '23', '', 'CW');
INSERT INTO `tasks` VALUES ('1407', '1401', 'Task 213595', '21.0', '14.0', '2007-02-14', '2007-02-17', '66', '', 'CW');
INSERT INTO `tasks` VALUES ('1408', '1401', 'Task 814127', '5.0', '4.0', '2007-02-08', '2007-02-19', '80', '', 'AZ');
INSERT INTO `tasks` VALUES ('1409', '1401', 'Task 943739', '5.0', '2.0', '2007-02-12', '2007-02-18', '40', '', 'BX');
INSERT INTO `tasks` VALUES ('1410', '1401', 'Task 814236', '20.0', '5.0', '2007-02-11', '2007-02-22', '25', '', 'CW');
INSERT INTO `tasks` VALUES ('1411', '1401', 'Task 720757', '18.0', '4.0', '2007-02-13', '2007-02-20', '22', '', 'BX');
INSERT INTO `tasks` VALUES ('2000', '0', 'dhtmlXTreeGrid', '7.0', '1.0', '2007-02-11', '2007-02-22', '14', '', 'AZ');
INSERT INTO `tasks` VALUES ('2001', '2000', 'Version 1.1', '9.0', '1.0', '2007-02-06', '2007-02-18', '11', '', 'AZ');
INSERT INTO `tasks` VALUES ('2002', '2001', 'Task 607476', '17.0', '16.0', '2007-02-11', '2007-02-22', '94', '', 'CW');
INSERT INTO `tasks` VALUES ('2003', '2001', 'Task 279188', '18.0', '11.0', '2007-02-07', '2007-02-24', '61', '', 'BX');
INSERT INTO `tasks` VALUES ('2004', '2001', 'Task 688313', '21.0', '13.0', '2007-02-14', '2007-02-25', '61', '', 'CW');
INSERT INTO `tasks` VALUES ('2005', '2001', 'Task 379991', '14.0', '6.0', '2007-02-14', '2007-02-22', '42', '', 'CW');
INSERT INTO `tasks` VALUES ('2006', '2001', 'Task 649359', '15.0', '4.0', '2007-02-06', '2007-02-17', '26', '', 'AZ');
INSERT INTO `tasks` VALUES ('2007', '2001', 'Task 430446', '18.0', '3.0', '2007-02-10', '2007-02-18', '16', '', 'CW');
INSERT INTO `tasks` VALUES ('2008', '2001', 'Task 962836', '3.0', '0.0', '2007-02-11', '2007-02-24', '0', '', 'BX');
INSERT INTO `tasks` VALUES ('2009', '2001', 'Task 680555', '30.0', '15.0', '2007-02-12', '2007-02-16', '50', '', 'BX');
INSERT INTO `tasks` VALUES ('2010', '2001', 'Task 767632', '7.0', '3.0', '2007-02-13', '2007-02-18', '42', '', 'AZ');
INSERT INTO `tasks` VALUES ('2011', '2001', 'Task 935872', '30.0', '23.0', '2007-02-08', '2007-02-24', '76', '', 'CW');
INSERT INTO `tasks` VALUES ('2101', '2000', 'Version 1.2', '29.0', '12.0', '2007-02-10', '2007-02-16', '41', '', 'AZ');
INSERT INTO `tasks` VALUES ('2102', '2101', 'Task 298041', '15.0', '8.0', '2007-02-11', '2007-02-25', '53', '', 'CW');
INSERT INTO `tasks` VALUES ('2103', '2101', 'Task 389675', '16.0', '16.0', '2007-02-05', '2007-02-18', '100', '', 'BX');
INSERT INTO `tasks` VALUES ('2104', '2101', 'Task 970458', '7.0', '7.0', '2007-02-11', '2007-02-22', '100', '', 'BX');
INSERT INTO `tasks` VALUES ('2105', '2101', 'Task 793863', '5.0', '2.0', '2007-02-13', '2007-02-21', '40', '', 'CW');
INSERT INTO `tasks` VALUES ('2106', '2101', 'Task 585584', '14.0', '4.0', '2007-02-08', '2007-02-21', '28', '', 'AZ');
INSERT INTO `tasks` VALUES ('2107', '2101', 'Task 599093', '5.0', '0.0', '2007-02-08', '2007-02-20', '0', '', 'CW');
INSERT INTO `tasks` VALUES ('2108', '2101', 'Task 837863', '8.0', '7.0', '2007-02-14', '2007-02-20', '87', '', 'AZ');
INSERT INTO `tasks` VALUES ('2109', '2101', 'Task 388698', '8.0', '8.0', '2007-02-07', '2007-02-25', '100', '', 'BX');
INSERT INTO `tasks` VALUES ('2110', '2101', 'Task 310628', '5.0', '3.0', '2007-02-09', '2007-02-19', '60', '', 'BX');
INSERT INTO `tasks` VALUES ('2111', '2101', 'Task 301567', '24.0', '18.0', '2007-02-09', '2007-02-17', '75', '', 'BX');
INSERT INTO `tasks` VALUES ('2201', '2000', 'Version 1.3', '5.0', '4.0', '2007-02-14', '2007-02-21', '80', '', 'AZ');
INSERT INTO `tasks` VALUES ('2202', '2201', 'Task 923828', '20.0', '11.0', '2007-02-06', '2007-02-19', '55', '', 'BX');
INSERT INTO `tasks` VALUES ('2203', '2201', 'Task 398057', '28.0', '23.0', '2007-02-08', '2007-02-20', '82', '', 'BX');
INSERT INTO `tasks` VALUES ('2204', '2201', 'Task 411783', '16.0', '12.0', '2007-02-13', '2007-02-25', '75', '', 'AZ');
INSERT INTO `tasks` VALUES ('2205', '2201', 'Task 204589', '17.0', '2.0', '2007-02-11', '2007-02-21', '11', '', 'AZ');
INSERT INTO `tasks` VALUES ('2206', '2201', 'Task 654947', '23.0', '4.0', '2007-02-13', '2007-02-25', '17', '', 'BX');
INSERT INTO `tasks` VALUES ('2207', '2201', 'Task 946885', '25.0', '17.0', '2007-02-05', '2007-02-21', '68', '', 'BX');
INSERT INTO `tasks` VALUES ('2208', '2201', 'Task 569986', '22.0', '4.0', '2007-02-10', '2007-02-17', '18', '', 'CW');
INSERT INTO `tasks` VALUES ('2209', '2201', 'Task 430501', '26.0', '11.0', '2007-02-06', '2007-02-24', '42', '', 'AZ');
INSERT INTO `tasks` VALUES ('2210', '2201', 'Task 406900', '10.0', '5.0', '2007-02-11', '2007-02-25', '50', '', 'BX');
INSERT INTO `tasks` VALUES ('2211', '2201', 'Task 460991', '9.0', '9.0', '2007-02-08', '2007-02-25', '100', '', 'CW');
INSERT INTO `tasks` VALUES ('2301', '2000', 'Version 1.4', '30.0', '12.0', '2007-02-13', '2007-02-19', '40', '', 'BX');
INSERT INTO `tasks` VALUES ('2302', '2301', 'Task 405408', '26.0', '7.0', '2007-02-05', '2007-02-23', '26', '', 'BX');
INSERT INTO `tasks` VALUES ('2303', '2301', 'Task 638102', '18.0', '12.0', '2007-02-13', '2007-02-24', '66', '', 'CW');
INSERT INTO `tasks` VALUES ('2304', '2301', 'Task 231472', '10.0', '5.0', '2007-02-09', '2007-02-16', '50', '', 'AZ');
INSERT INTO `tasks` VALUES ('2305', '2301', 'Task 744547', '28.0', '19.0', '2007-02-06', '2007-02-18', '67', '', 'BX');
INSERT INTO `tasks` VALUES ('2306', '2301', 'Task 153021', '18.0', '3.0', '2007-02-06', '2007-02-21', '16', '', 'AZ');
INSERT INTO `tasks` VALUES ('2307', '2301', 'Task 182589', '1.0', '1.0', '2007-02-05', '2007-02-17', '100', '', 'AZ');
INSERT INTO `tasks` VALUES ('2308', '2301', 'Task 308946', '26.0', '23.0', '2007-02-14', '2007-02-18', '88', '', 'AZ');
INSERT INTO `tasks` VALUES ('2309', '2301', 'Task 646674', '25.0', '24.0', '2007-02-14', '2007-02-17', '96', '', 'AZ');
INSERT INTO `tasks` VALUES ('2310', '2301', 'Task 393690', '29.0', '22.0', '2007-02-12', '2007-02-19', '75', '', 'CW');
INSERT INTO `tasks` VALUES ('2311', '2301', 'Task 720133', '27.0', '14.0', '2007-02-12', '2007-02-17', '51', '', 'CW');
INSERT INTO `tasks` VALUES ('2401', '2000', 'Version 1.5', '5.0', '2.0', '2007-02-10', '2007-02-22', '40', '', 'AZ');
INSERT INTO `tasks` VALUES ('2402', '2401', 'Task 863009', '15.0', '4.0', '2007-02-12', '2007-02-18', '26', '', 'AZ');
INSERT INTO `tasks` VALUES ('2403', '2401', 'Task 490451', '8.0', '1.0', '2007-02-14', '2007-02-17', '12', '', 'AZ');
INSERT INTO `tasks` VALUES ('2404', '2401', 'Task 320583', '12.0', '6.0', '2007-02-12', '2007-02-18', '50', '', 'BX');
INSERT INTO `tasks` VALUES ('2405', '2401', 'Task 509657', '20.0', '9.0', '2007-02-06', '2007-02-18', '45', '', 'BX');
INSERT INTO `tasks` VALUES ('2406', '2401', 'Task 852810', '6.0', '3.0', '2007-02-14', '2007-02-23', '50', '', 'BX');
INSERT INTO `tasks` VALUES ('2407', '2401', 'Task 117404', '26.0', '17.0', '2007-02-07', '2007-02-25', '65', '', 'CW');
INSERT INTO `tasks` VALUES ('2408', '2401', 'Task 709689', '16.0', '0.0', '2007-02-09', '2007-02-17', '0', '', 'BX');
INSERT INTO `tasks` VALUES ('2409', '2401', 'Task 897026', '8.0', '0.0', '2007-02-12', '2007-02-19', '0', '', 'BX');
INSERT INTO `tasks` VALUES ('2410', '2401', 'Task 363443', '17.0', '17.0', '2007-02-06', '2007-02-24', '100', '', 'CW');
INSERT INTO `tasks` VALUES ('2411', '2401', 'Task 431857', '22.0', '10.0', '2007-02-11', '2007-02-24', '45', '', 'AZ');
INSERT INTO `tasks` VALUES ('3000', '0', 'dhtmlXTree', '29.0', '24.0', '2007-02-05', '2007-02-18', '82', '', 'AZ');
INSERT INTO `tasks` VALUES ('3001', '3000', 'Version 1.1', '21.0', '15.0', '2007-02-08', '2007-02-22', '71', '', 'AZ');
INSERT INTO `tasks` VALUES ('3002', '3001', 'Task 134548', '10.0', '2.0', '2007-02-08', '2007-02-18', '20', '', 'CW');
INSERT INTO `tasks` VALUES ('3003', '3001', 'Task 145236', '23.0', '10.0', '2007-02-06', '2007-02-23', '43', '', 'AZ');
INSERT INTO `tasks` VALUES ('3004', '3001', 'Task 848198', '5.0', '4.0', '2007-02-14', '2007-02-17', '80', '', 'CW');
INSERT INTO `tasks` VALUES ('3005', '3001', 'Task 260796', '21.0', '12.0', '2007-02-14', '2007-02-16', '57', '', 'AZ');
INSERT INTO `tasks` VALUES ('3006', '3001', 'Task 705946', '8.0', '6.0', '2007-02-05', '2007-02-19', '75', '', 'BX');
INSERT INTO `tasks` VALUES ('3007', '3001', 'Task 145453', '21.0', '12.0', '2007-02-11', '2007-02-21', '57', '', 'AZ');
INSERT INTO `tasks` VALUES ('3008', '3001', 'Task 402235', '2.0', '1.0', '2007-02-05', '2007-02-22', '50', '', 'CW');
INSERT INTO `tasks` VALUES ('3009', '3001', 'Task 271430', '27.0', '14.0', '2007-02-06', '2007-02-24', '51', '', 'AZ');
INSERT INTO `tasks` VALUES ('3010', '3001', 'Task 187065', '14.0', '8.0', '2007-02-13', '2007-02-21', '57', '', 'AZ');
INSERT INTO `tasks` VALUES ('3011', '3001', 'Task 666503', '29.0', '26.0', '2007-02-07', '2007-02-20', '89', '', 'AZ');
INSERT INTO `tasks` VALUES ('3101', '3000', 'Version 1.2', '25.0', '14.0', '2007-02-06', '2007-02-24', '56', '', 'BX');
INSERT INTO `tasks` VALUES ('3102', '3101', 'Task 651719', '22.0', '0.0', '2007-02-07', '2007-02-17', '0', '', 'CW');
INSERT INTO `tasks` VALUES ('3103', '3101', 'Task 247260', '28.0', '3.0', '2007-02-06', '2007-02-19', '10', '', 'AZ');
INSERT INTO `tasks` VALUES ('3104', '3101', 'Task 745144', '16.0', '12.0', '2007-02-09', '2007-02-22', '75', '', 'CW');
INSERT INTO `tasks` VALUES ('3105', '3101', 'Task 259955', '2.0', '2.0', '2007-02-07', '2007-02-16', '100', '', 'BX');
INSERT INTO `tasks` VALUES ('3106', '3101', 'Task 434054', '9.0', '3.0', '2007-02-12', '2007-02-24', '33', '', 'BX');
INSERT INTO `tasks` VALUES ('3107', '3101', 'Task 437581', '18.0', '10.0', '2007-02-11', '2007-02-24', '55', '', 'BX');
INSERT INTO `tasks` VALUES ('3108', '3101', 'Task 746229', '8.0', '3.0', '2007-02-10', '2007-02-18', '37', '', 'AZ');
INSERT INTO `tasks` VALUES ('3109', '3101', 'Task 696804', '17.0', '17.0', '2007-02-10', '2007-02-21', '100', '', 'BX');
INSERT INTO `tasks` VALUES ('3110', '3101', 'Task 487223', '7.0', '0.0', '2007-02-07', '2007-02-19', '0', '', 'BX');
INSERT INTO `tasks` VALUES ('3111', '3101', 'Task 509846', '15.0', '14.0', '2007-02-13', '2007-02-17', '93', '', 'AZ');
INSERT INTO `tasks` VALUES ('3201', '3000', 'Version 1.3', '15.0', '0.0', '2007-02-14', '2007-02-23', '0', '', 'BX');
INSERT INTO `tasks` VALUES ('3202', '3201', 'Task 877549', '20.0', '8.0', '2007-02-08', '2007-02-25', '40', '', 'CW');
INSERT INTO `tasks` VALUES ('3203', '3201', 'Task 833116', '20.0', '16.0', '2007-02-13', '2007-02-22', '80', '', 'BX');
INSERT INTO `tasks` VALUES ('3204', '3201', 'Task 144151', '2.0', '2.0', '2007-02-13', '2007-02-18', '100', '', 'BX');
INSERT INTO `tasks` VALUES ('3205', '3201', 'Task 411349', '20.0', '10.0', '2007-02-11', '2007-02-21', '50', '', 'CW');
INSERT INTO `tasks` VALUES ('3206', '3201', 'Task 207627', '23.0', '19.0', '2007-02-10', '2007-02-21', '82', '', 'BX');
INSERT INTO `tasks` VALUES ('3207', '3201', 'Task 633680', '12.0', '3.0', '2007-02-12', '2007-02-18', '25', '', 'CW');
INSERT INTO `tasks` VALUES ('3208', '3201', 'Task 206868', '14.0', '13.0', '2007-02-08', '2007-02-16', '92', '', 'CW');
INSERT INTO `tasks` VALUES ('3209', '3201', 'Task 416775', '7.0', '4.0', '2007-02-10', '2007-02-19', '57', '', 'BX');
INSERT INTO `tasks` VALUES ('3210', '3201', 'Task 614095', '9.0', '0.0', '2007-02-14', '2007-02-20', '0', '', 'BX');
INSERT INTO `tasks` VALUES ('3211', '3201', 'Task 899522', '3.0', '3.0', '2007-02-05', '2007-02-21', '100', '', 'AZ');
INSERT INTO `tasks` VALUES ('3301', '3000', 'Version 1.4', '28.0', '27.0', '2007-02-12', '2007-02-23', '96', '', 'BX');
INSERT INTO `tasks` VALUES ('3302', '3301', 'Task 708306', '16.0', '6.0', '2007-02-07', '2007-02-19', '37', '', 'CW');
INSERT INTO `tasks` VALUES ('3303', '3301', 'Task 851155', '30.0', '16.0', '2007-02-08', '2007-02-21', '53', '', 'BX');
INSERT INTO `tasks` VALUES ('3304', '3301', 'Task 184543', '15.0', '0.0', '2007-02-12', '2007-02-21', '0', '', 'CW');
INSERT INTO `tasks` VALUES ('3305', '3301', 'Task 739718', '29.0', '21.0', '2007-02-10', '2007-02-24', '72', '', 'AZ');
INSERT INTO `tasks` VALUES ('3306', '3301', 'Task 742377', '16.0', '7.0', '2007-02-12', '2007-02-17', '43', '', 'BX');
INSERT INTO `tasks` VALUES ('3307', '3301', 'Task 168212', '17.0', '11.0', '2007-02-10', '2007-02-20', '64', '', 'AZ');
INSERT INTO `tasks` VALUES ('3308', '3301', 'Task 965142', '4.0', '2.0', '2007-02-06', '2007-02-17', '50', '', 'BX');
INSERT INTO `tasks` VALUES ('3309', '3301', 'Task 164415', '2.0', '0.0', '2007-02-09', '2007-02-25', '0', '', 'CW');
INSERT INTO `tasks` VALUES ('3310', '3301', 'Task 769504', '11.0', '7.0', '2007-02-06', '2007-02-17', '63', '', 'AZ');
INSERT INTO `tasks` VALUES ('3311', '3301', 'Task 422770', '8.0', '8.0', '2007-02-12', '2007-02-23', '100', '', 'BX');
INSERT INTO `tasks` VALUES ('3401', '3000', 'Version 1.5', '22.0', '15.0', '2007-02-10', '2007-02-17', '68', '', 'AZ');
INSERT INTO `tasks` VALUES ('3402', '3401', 'Task 726019', '14.0', '6.0', '2007-02-12', '2007-02-18', '42', '', 'AZ');
INSERT INTO `tasks` VALUES ('3403', '3401', 'Task 671603', '3.0', '0.0', '2007-02-06', '2007-02-17', '0', '', 'AZ');
INSERT INTO `tasks` VALUES ('3404', '3401', 'Task 941406', '1.0', '0.0', '2007-02-09', '2007-02-16', '0', '', 'CW');
INSERT INTO `tasks` VALUES ('3405', '3401', 'Task 719455', '29.0', '15.0', '2007-02-05', '2007-02-17', '51', '', 'CW');
INSERT INTO `tasks` VALUES ('3406', '3401', 'Task 384223', '25.0', '8.0', '2007-02-08', '2007-02-21', '32', '', 'BX');
INSERT INTO `tasks` VALUES ('3407', '3401', 'Task 841959', '2.0', '1.0', '2007-02-07', '2007-02-18', '50', '', 'AZ');
INSERT INTO `tasks` VALUES ('3408', '3401', 'Task 193359', '24.0', '2.0', '2007-02-08', '2007-02-18', '8', '', 'AZ');
INSERT INTO `tasks` VALUES ('3409', '3401', 'Task 178005', '3.0', '3.0', '2007-02-13', '2007-02-19', '100', '', 'AZ');
INSERT INTO `tasks` VALUES ('3410', '3401', 'Task 174370', '9.0', '9.0', '2007-02-12', '2007-02-24', '100', '', 'CW');
INSERT INTO `tasks` VALUES ('3411', '3401', 'Task 977593', '6.0', '2.0', '2007-02-12', '2007-02-18', '33', '', 'AZ');
INSERT INTO `tasks` VALUES ('4000', '0', 'dhtmlxMenu', '9.0', '7.0', '2007-02-12', '2007-02-16', '77', '', 'BX');
INSERT INTO `tasks` VALUES ('4001', '4000', 'Version 1.1', '16.0', '0.0', '2007-02-12', '2007-02-24', '0', '', 'CW');
INSERT INTO `tasks` VALUES ('4002', '4001', 'Task 357367', '6.0', '3.0', '2007-02-08', '2007-02-24', '50', '', 'AZ');
INSERT INTO `tasks` VALUES ('4003', '4001', 'Task 474392', '15.0', '3.0', '2007-02-14', '2007-02-20', '20', '', 'CW');
INSERT INTO `tasks` VALUES ('4004', '4001', 'Task 432996', '21.0', '7.0', '2007-02-09', '2007-02-17', '33', '', 'CW');
INSERT INTO `tasks` VALUES ('4005', '4001', 'Task 611653', '21.0', '10.0', '2007-02-08', '2007-02-24', '47', '', 'AZ');
INSERT INTO `tasks` VALUES ('4006', '4001', 'Task 138834', '29.0', '10.0', '2007-02-08', '2007-02-23', '34', '', 'BX');
INSERT INTO `tasks` VALUES ('4007', '4001', 'Task 670789', '17.0', '0.0', '2007-02-07', '2007-02-25', '0', '', 'AZ');
INSERT INTO `tasks` VALUES ('4008', '4001', 'Task 391547', '19.0', '3.0', '2007-02-07', '2007-02-17', '15', '', 'BX');
INSERT INTO `tasks` VALUES ('4009', '4001', 'Task 457356', '15.0', '3.0', '2007-02-07', '2007-02-21', '20', '', 'BX');
INSERT INTO `tasks` VALUES ('4010', '4001', 'Task 774468', '27.0', '21.0', '2007-02-13', '2007-02-22', '77', '', 'CW');
INSERT INTO `tasks` VALUES ('4011', '4001', 'Task 221354', '12.0', '9.0', '2007-02-06', '2007-02-17', '75', '', 'AZ');
INSERT INTO `tasks` VALUES ('4101', '4000', 'Version 1.2', '12.0', '9.0', '2007-02-09', '2007-02-23', '75', '', 'CW');
INSERT INTO `tasks` VALUES ('4102', '4101', 'Task 508436', '11.0', '7.0', '2007-02-12', '2007-02-20', '63', '', 'CW');
INSERT INTO `tasks` VALUES ('4103', '4101', 'Task 916910', '19.0', '5.0', '2007-02-11', '2007-02-20', '26', '', 'CW');
INSERT INTO `tasks` VALUES ('4104', '4101', 'Task 168701', '21.0', '4.0', '2007-02-09', '2007-02-21', '19', '', 'BX');
INSERT INTO `tasks` VALUES ('4105', '4101', 'Task 406168', '5.0', '1.0', '2007-02-07', '2007-02-19', '20', '', 'AZ');
INSERT INTO `tasks` VALUES ('4106', '4101', 'Task 855007', '22.0', '9.0', '2007-02-06', '2007-02-23', '40', '', 'CW');
INSERT INTO `tasks` VALUES ('4107', '4101', 'Task 713134', '15.0', '5.0', '2007-02-12', '2007-02-22', '33', '', 'AZ');
INSERT INTO `tasks` VALUES ('4108', '4101', 'Task 261800', '2.0', '0.0', '2007-02-11', '2007-02-17', '0', '', 'CW');
INSERT INTO `tasks` VALUES ('4109', '4101', 'Task 198920', '28.0', '9.0', '2007-02-08', '2007-02-18', '32', '', 'CW');
INSERT INTO `tasks` VALUES ('4110', '4101', 'Task 972412', '21.0', '1.0', '2007-02-09', '2007-02-16', '4', '', 'BX');
INSERT INTO `tasks` VALUES ('4111', '4101', 'Task 335747', '8.0', '3.0', '2007-02-08', '2007-02-18', '37', '', 'CW');
INSERT INTO `tasks` VALUES ('4201', '4000', 'Version 1.3', '5.0', '4.0', '2007-02-07', '2007-02-22', '80', '', 'CW');
INSERT INTO `tasks` VALUES ('4202', '4201', 'Task 551323', '20.0', '15.0', '2007-02-13', '2007-02-24', '75', '', 'AZ');
INSERT INTO `tasks` VALUES ('4203', '4201', 'Task 561143', '9.0', '4.0', '2007-02-06', '2007-02-22', '44', '', 'CW');
INSERT INTO `tasks` VALUES ('4204', '4201', 'Task 381293', '3.0', '0.0', '2007-02-12', '2007-02-24', '0', '', 'BX');
INSERT INTO `tasks` VALUES ('4205', '4201', 'Task 640245', '27.0', '6.0', '2007-02-09', '2007-02-18', '22', '', 'AZ');
INSERT INTO `tasks` VALUES ('4206', '4201', 'Task 494249', '22.0', '19.0', '2007-02-06', '2007-02-22', '86', '', 'BX');
INSERT INTO `tasks` VALUES ('4207', '4201', 'Task 516221', '6.0', '2.0', '2007-02-12', '2007-02-18', '33', '', 'CW');
INSERT INTO `tasks` VALUES ('4208', '4201', 'Task 251301', '14.0', '7.0', '2007-02-11', '2007-02-19', '50', '', 'AZ');
INSERT INTO `tasks` VALUES ('4209', '4201', 'Task 216851', '25.0', '12.0', '2007-02-09', '2007-02-23', '48', '', 'BX');
INSERT INTO `tasks` VALUES ('4210', '4201', 'Task 346896', '21.0', '9.0', '2007-02-07', '2007-02-17', '42', '', 'AZ');
INSERT INTO `tasks` VALUES ('4211', '4201', 'Task 214355', '30.0', '18.0', '2007-02-07', '2007-02-22', '60', '', 'CW');
INSERT INTO `tasks` VALUES ('4301', '4000', 'Version 1.4', '10.0', '5.0', '2007-02-10', '2007-02-17', '50', '', 'BX');
INSERT INTO `tasks` VALUES ('4302', '4301', 'Task 830213', '2.0', '0.0', '2007-02-06', '2007-02-24', '0', '', 'AZ');
INSERT INTO `tasks` VALUES ('4303', '4301', 'Task 553358', '15.0', '12.0', '2007-02-06', '2007-02-24', '80', '', 'CW');
INSERT INTO `tasks` VALUES ('4304', '4301', 'Task 158013', '8.0', '8.0', '2007-02-11', '2007-02-25', '100', '', 'BX');
INSERT INTO `tasks` VALUES ('4305', '4301', 'Task 592095', '23.0', '22.0', '2007-02-09', '2007-02-25', '95', '', 'AZ');
INSERT INTO `tasks` VALUES ('4306', '4301', 'Task 553520', '6.0', '4.0', '2007-02-06', '2007-02-24', '66', '', 'BX');
INSERT INTO `tasks` VALUES ('4307', '4301', 'Task 267984', '28.0', '5.0', '2007-02-12', '2007-02-19', '17', '', 'AZ');
INSERT INTO `tasks` VALUES ('4308', '4301', 'Task 822292', '19.0', '7.0', '2007-02-14', '2007-02-24', '36', '', 'AZ');
INSERT INTO `tasks` VALUES ('4309', '4301', 'Task 831027', '18.0', '9.0', '2007-02-14', '2007-02-16', '50', '', 'BX');
INSERT INTO `tasks` VALUES ('4310', '4301', 'Task 214328', '26.0', '25.0', '2007-02-08', '2007-02-23', '96', '', 'AZ');
INSERT INTO `tasks` VALUES ('4311', '4301', 'Task 420111', '22.0', '5.0', '2007-02-10', '2007-02-21', '22', '', 'CW');
INSERT INTO `tasks` VALUES ('4401', '4000', 'Version 1.5', '20.0', '9.0', '2007-02-13', '2007-02-23', '45', '', 'CW');
INSERT INTO `tasks` VALUES ('4402', '4401', 'Task 972276', '4.0', '4.0', '2007-02-07', '2007-02-23', '100', '', 'BX');
INSERT INTO `tasks` VALUES ('4403', '4401', 'Task 836697', '6.0', '2.0', '2007-02-08', '2007-02-20', '33', '', 'BX');
INSERT INTO `tasks` VALUES ('4404', '4401', 'Task 785753', '28.0', '2.0', '2007-02-13', '2007-02-23', '7', '', 'AZ');
INSERT INTO `tasks` VALUES ('4405', '4401', 'Task 142361', '8.0', '5.0', '2007-02-07', '2007-02-24', '62', '', 'BX');
INSERT INTO `tasks` VALUES ('4406', '4401', 'Task 979437', '7.0', '6.0', '2007-02-07', '2007-02-19', '85', '', 'CW');
INSERT INTO `tasks` VALUES ('4407', '4401', 'Task 342122', '29.0', '23.0', '2007-02-07', '2007-02-20', '79', '', 'CW');
INSERT INTO `tasks` VALUES ('4408', '4401', 'Task 247775', '5.0', '1.0', '2007-02-13', '2007-02-19', '20', '', 'AZ');
INSERT INTO `tasks` VALUES ('4409', '4401', 'Task 797091', '5.0', '3.0', '2007-02-10', '2007-02-20', '60', '', 'CW');
INSERT INTO `tasks` VALUES ('4410', '4401', 'Task 396321', '12.0', '10.0', '2007-02-07', '2007-02-23', '83', '', 'CW');
INSERT INTO `tasks` VALUES ('4411', '4401', 'Task 423936', '10.0', '5.0', '2007-02-09', '2007-02-24', '50', '', 'CW');
INSERT INTO `tasks` VALUES ('5000', '0', 'dhtmlXTollbar', '2.0', '1.0', '2007-02-13', '2007-02-20', '50', '', 'BX');
INSERT INTO `tasks` VALUES ('5001', '5000', 'Version 1.1', '1.0', '0.0', '2007-02-11', '2007-02-25', '0', '', 'AZ');
INSERT INTO `tasks` VALUES ('5002', '5001', 'Task 897460', '4.0', '1.0', '2007-02-14', '2007-02-23', '25', '', 'CW');
INSERT INTO `tasks` VALUES ('5003', '5001', 'Task 360405', '11.0', '3.0', '2007-02-07', '2007-02-24', '27', '', 'BX');
INSERT INTO `tasks` VALUES ('5004', '5001', 'Task 453124', '4.0', '1.0', '2007-02-12', '2007-02-22', '25', '', 'CW');
INSERT INTO `tasks` VALUES ('5005', '5001', 'Task 581868', '10.0', '6.0', '2007-02-12', '2007-02-22', '60', '', 'CW');
INSERT INTO `tasks` VALUES ('5006', '5001', 'Task 458441', '6.0', '5.0', '2007-02-08', '2007-02-17', '83', '', 'CW');
INSERT INTO `tasks` VALUES ('5007', '5001', 'Task 322428', '13.0', '0.0', '2007-02-07', '2007-02-18', '0', '', 'CW');
INSERT INTO `tasks` VALUES ('5008', '5001', 'Task 274522', '10.0', '5.0', '2007-02-10', '2007-02-21', '50', '', 'CW');
INSERT INTO `tasks` VALUES ('5009', '5001', 'Task 498752', '9.0', '1.0', '2007-02-12', '2007-02-24', '11', '', 'BX');
INSERT INTO `tasks` VALUES ('5010', '5001', 'Task 595811', '27.0', '17.0', '2007-02-05', '2007-02-24', '62', '', 'CW');
INSERT INTO `tasks` VALUES ('5011', '5001', 'Task 694173', '4.0', '4.0', '2007-02-06', '2007-02-18', '100', '', 'BX');
INSERT INTO `tasks` VALUES ('5101', '5000', 'Version 1.2', '24.0', '0.0', '2007-02-10', '2007-02-21', '0', '', 'BX');
INSERT INTO `tasks` VALUES ('5102', '5101', 'Task 392496', '23.0', '13.0', '2007-02-08', '2007-02-20', '56', '', 'CW');
INSERT INTO `tasks` VALUES ('5103', '5101', 'Task 506266', '28.0', '12.0', '2007-02-09', '2007-02-19', '42', '', 'CW');
INSERT INTO `tasks` VALUES ('5104', '5101', 'Task 932101', '18.0', '14.0', '2007-02-05', '2007-02-18', '77', '', 'AZ');
INSERT INTO `tasks` VALUES ('5105', '5101', 'Task 951253', '24.0', '18.0', '2007-02-10', '2007-02-21', '75', '', 'AZ');
INSERT INTO `tasks` VALUES ('5106', '5101', 'Task 261637', '11.0', '4.0', '2007-02-11', '2007-02-16', '36', '', 'AZ');
INSERT INTO `tasks` VALUES ('5107', '5101', 'Task 977837', '8.0', '0.0', '2007-02-07', '2007-02-23', '0', '', 'AZ');
INSERT INTO `tasks` VALUES ('5108', '5101', 'Task 742214', '24.0', '15.0', '2007-02-12', '2007-02-17', '62', '', 'CW');
INSERT INTO `tasks` VALUES ('5109', '5101', 'Task 947129', '27.0', '11.0', '2007-02-09', '2007-02-17', '40', '', 'AZ');
INSERT INTO `tasks` VALUES ('5110', '5101', 'Task 734944', '7.0', '0.0', '2007-02-10', '2007-02-18', '0', '', 'CW');
INSERT INTO `tasks` VALUES ('5111', '5101', 'Task 775797', '21.0', '2.0', '2007-02-10', '2007-02-23', '9', '', 'AZ');
INSERT INTO `tasks` VALUES ('5201', '5000', 'Version 1.3', '12.0', '11.0', '2007-02-10', '2007-02-23', '91', '', 'BX');
INSERT INTO `tasks` VALUES ('5202', '5201', 'Task 205566', '25.0', '4.0', '2007-02-09', '2007-02-23', '16', '', 'AZ');
INSERT INTO `tasks` VALUES ('5203', '5201', 'Task 425889', '25.0', '15.0', '2007-02-07', '2007-02-19', '60', '', 'CW');
INSERT INTO `tasks` VALUES ('5204', '5201', 'Task 550292', '5.0', '2.0', '2007-02-09', '2007-02-16', '40', '', 'CW');
INSERT INTO `tasks` VALUES ('5205', '5201', 'Task 457248', '1.0', '1.0', '2007-02-13', '2007-02-18', '100', '', 'CW');
INSERT INTO `tasks` VALUES ('5206', '5201', 'Task 997450', '14.0', '14.0', '2007-02-13', '2007-02-20', '100', '', 'AZ');
INSERT INTO `tasks` VALUES ('5207', '5201', 'Task 660481', '24.0', '19.0', '2007-02-06', '2007-02-17', '79', '', 'CW');
INSERT INTO `tasks` VALUES ('5208', '5201', 'Task 241482', '25.0', '19.0', '2007-02-09', '2007-02-22', '76', '', 'AZ');
INSERT INTO `tasks` VALUES ('5209', '5201', 'Task 396701', '1.0', '1.0', '2007-02-13', '2007-02-21', '100', '', 'CW');
INSERT INTO `tasks` VALUES ('5210', '5201', 'Task 976833', '27.0', '11.0', '2007-02-10', '2007-02-23', '40', '', 'BX');
INSERT INTO `tasks` VALUES ('5211', '5201', 'Task 360351', '4.0', '4.0', '2007-02-10', '2007-02-18', '100', '', 'AZ');
INSERT INTO `tasks` VALUES ('5301', '5000', 'Version 1.4', '27.0', '26.0', '2007-02-12', '2007-02-21', '96', '', 'CW');
INSERT INTO `tasks` VALUES ('5302', '5301', 'Task 712103', '1.0', '0.0', '2007-02-08', '2007-02-23', '0', '', 'AZ');
INSERT INTO `tasks` VALUES ('5303', '5301', 'Task 157904', '24.0', '10.0', '2007-02-08', '2007-02-22', '41', '', 'CW');
INSERT INTO `tasks` VALUES ('5304', '5301', 'Task 815077', '9.0', '0.0', '2007-02-08', '2007-02-22', '0', '', 'BX');
INSERT INTO `tasks` VALUES ('5305', '5301', 'Task 992648', '18.0', '11.0', '2007-02-06', '2007-02-24', '61', '', 'AZ');
INSERT INTO `tasks` VALUES ('5306', '5301', 'Task 971869', '11.0', '3.0', '2007-02-12', '2007-02-18', '27', '', 'CW');
INSERT INTO `tasks` VALUES ('5307', '5301', 'Task 561767', '1.0', '0.0', '2007-02-07', '2007-02-24', '0', '', 'BX');
INSERT INTO `tasks` VALUES ('5308', '5301', 'Task 210259', '6.0', '6.0', '2007-02-14', '2007-02-24', '100', '', 'BX');
INSERT INTO `tasks` VALUES ('5309', '5301', 'Task 337483', '25.0', '8.0', '2007-02-09', '2007-02-24', '32', '', 'CW');
INSERT INTO `tasks` VALUES ('5310', '5301', 'Task 669135', '12.0', '12.0', '2007-02-11', '2007-02-23', '100', '', 'AZ');
INSERT INTO `tasks` VALUES ('5311', '5301', 'Task 458685', '8.0', '5.0', '2007-02-12', '2007-02-22', '62', '', 'BX');
INSERT INTO `tasks` VALUES ('5401', '5000', 'Version 1.5', '28.0', '25.0', '2007-02-07', '2007-02-19', '89', '', 'AZ');
INSERT INTO `tasks` VALUES ('5402', '5401', 'Task 501085', '13.0', '2.0', '2007-02-05', '2007-02-16', '15', '', 'AZ');
INSERT INTO `tasks` VALUES ('5403', '5401', 'Task 690592', '18.0', '6.0', '2007-02-11', '2007-02-20', '33', '', 'BX');
INSERT INTO `tasks` VALUES ('5404', '5401', 'Task 141818', '28.0', '22.0', '2007-02-10', '2007-02-17', '78', '', 'CW');
INSERT INTO `tasks` VALUES ('5405', '5401', 'Task 316568', '29.0', '22.0', '2007-02-05', '2007-02-16', '75', '', 'AZ');
INSERT INTO `tasks` VALUES ('5406', '5401', 'Task 759982', '30.0', '28.0', '2007-02-05', '2007-02-22', '93', '', 'BX');
INSERT INTO `tasks` VALUES ('5407', '5401', 'Task 211642', '6.0', '4.0', '2007-02-07', '2007-02-22', '66', '', 'CW');
INSERT INTO `tasks` VALUES ('5408', '5401', 'Task 383354', '2.0', '2.0', '2007-02-12', '2007-02-22', '100', '', 'CW');
INSERT INTO `tasks` VALUES ('5409', '5401', 'Task 848036', '14.0', '13.0', '2007-02-14', '2007-02-17', '92', '', 'AZ');
INSERT INTO `tasks` VALUES ('5410', '5401', 'Task 150824', '1.0', '0.0', '2007-02-13', '2007-02-22', '0', '', 'BX');
INSERT INTO `tasks` VALUES ('5411', '5401', 'Task 475748', '12.0', '3.0', '2007-02-09', '2007-02-20', '25', '', 'BX');
INSERT INTO `tasks` VALUES ('6000', '0', 'dhtmlXTabbar', '10.0', '7.0', '2007-02-12', '2007-02-19', '70', '', 'BX');
INSERT INTO `tasks` VALUES ('6001', '6000', 'Version 1.1', '22.0', '2.0', '2007-02-06', '2007-02-21', '9', '', 'BX');
INSERT INTO `tasks` VALUES ('6002', '6001', 'Task 570800', '8.0', '3.0', '2007-02-08', '2007-02-19', '37', '', 'CW');
INSERT INTO `tasks` VALUES ('6003', '6001', 'Task 980360', '7.0', '5.0', '2007-02-08', '2007-02-24', '71', '', 'BX');
INSERT INTO `tasks` VALUES ('6004', '6001', 'Task 668999', '24.0', '19.0', '2007-02-10', '2007-02-21', '79', '', 'CW');
INSERT INTO `tasks` VALUES ('6005', '6001', 'Task 959635', '6.0', '3.0', '2007-02-12', '2007-02-24', '50', '', 'AZ');
INSERT INTO `tasks` VALUES ('6006', '6001', 'Task 591851', '21.0', '3.0', '2007-02-13', '2007-02-20', '14', '', 'BX');
INSERT INTO `tasks` VALUES ('6007', '6001', 'Task 388563', '21.0', '16.0', '2007-02-05', '2007-02-23', '76', '', 'BX');
INSERT INTO `tasks` VALUES ('6008', '6001', 'Task 811577', '3.0', '2.0', '2007-02-08', '2007-02-20', '66', '', 'AZ');
INSERT INTO `tasks` VALUES ('6009', '6001', 'Task 406032', '17.0', '0.0', '2007-02-06', '2007-02-17', '0', '', 'AZ');
INSERT INTO `tasks` VALUES ('6010', '6001', 'Task 467068', '20.0', '8.0', '2007-02-06', '2007-02-24', '40', '', 'BX');
INSERT INTO `tasks` VALUES ('6011', '6001', 'Task 817599', '8.0', '5.0', '2007-02-09', '2007-02-23', '62', '', 'CW');
INSERT INTO `tasks` VALUES ('6101', '6000', 'Version 1.2', '18.0', '15.0', '2007-02-12', '2007-02-20', '83', '', 'AZ');
INSERT INTO `tasks` VALUES ('6102', '6101', 'Task 133761', '28.0', '18.0', '2007-02-08', '2007-02-24', '64', '', 'BX');
INSERT INTO `tasks` VALUES ('6103', '6101', 'Task 206298', '30.0', '14.0', '2007-02-13', '2007-02-20', '46', '', 'AZ');
INSERT INTO `tasks` VALUES ('6104', '6101', 'Task 920762', '11.0', '2.0', '2007-02-08', '2007-02-21', '18', '', 'BX');
INSERT INTO `tasks` VALUES ('6105', '6101', 'Task 697292', '21.0', '10.0', '2007-02-09', '2007-02-22', '47', '', 'CW');
INSERT INTO `tasks` VALUES ('6106', '6101', 'Task 817138', '8.0', '6.0', '2007-02-09', '2007-02-20', '75', '', 'CW');
INSERT INTO `tasks` VALUES ('6107', '6101', 'Task 311550', '5.0', '1.0', '2007-02-11', '2007-02-23', '20', '', 'AZ');
INSERT INTO `tasks` VALUES ('6108', '6101', 'Task 628445', '19.0', '14.0', '2007-02-11', '2007-02-18', '73', '', 'CW');
INSERT INTO `tasks` VALUES ('6109', '6101', 'Task 521294', '7.0', '0.0', '2007-02-13', '2007-02-17', '0', '', 'AZ');
INSERT INTO `tasks` VALUES ('6110', '6101', 'Task 715793', '2.0', '0.0', '2007-02-06', '2007-02-24', '0', '', 'CW');
INSERT INTO `tasks` VALUES ('6111', '6101', 'Task 576524', '4.0', '2.0', '2007-02-08', '2007-02-19', '50', '', 'BX');
INSERT INTO `tasks` VALUES ('6201', '6000', 'Version 1.3', '15.0', '2.0', '2007-02-13', '2007-02-24', '13', '', 'BX');
INSERT INTO `tasks` VALUES ('6202', '6201', 'Task 850694', '30.0', '19.0', '2007-02-07', '2007-02-19', '63', '', 'BX');
INSERT INTO `tasks` VALUES ('6203', '6201', 'Task 465548', '3.0', '2.0', '2007-02-11', '2007-02-24', '66', '', 'CW');
INSERT INTO `tasks` VALUES ('6204', '6201', 'Task 383788', '29.0', '2.0', '2007-02-06', '2007-02-17', '6', '', 'AZ');
INSERT INTO `tasks` VALUES ('6205', '6201', 'Task 844997', '8.0', '1.0', '2007-02-06', '2007-02-17', '12', '', 'CW');
INSERT INTO `tasks` VALUES ('6206', '6201', 'Task 172091', '13.0', '2.0', '2007-02-06', '2007-02-20', '15', '', 'AZ');
INSERT INTO `tasks` VALUES ('6207', '6201', 'Task 326877', '22.0', '0.0', '2007-02-07', '2007-02-24', '0', '', 'BX');
INSERT INTO `tasks` VALUES ('6208', '6201', 'Task 910047', '25.0', '8.0', '2007-02-12', '2007-02-17', '32', '', 'CW');
INSERT INTO `tasks` VALUES ('6209', '6201', 'Task 272298', '20.0', '20.0', '2007-02-10', '2007-02-23', '100', '', 'BX');
INSERT INTO `tasks` VALUES ('6210', '6201', 'Task 180989', '2.0', '0.0', '2007-02-06', '2007-02-22', '0', '', 'BX');
INSERT INTO `tasks` VALUES ('6211', '6201', 'Task 709038', '21.0', '14.0', '2007-02-10', '2007-02-25', '66', '', 'AZ');
INSERT INTO `tasks` VALUES ('6301', '6000', 'Version 1.4', '17.0', '1.0', '2007-02-10', '2007-02-24', '5', '', 'AZ');
INSERT INTO `tasks` VALUES ('6302', '6301', 'Task 267171', '12.0', '12.0', '2007-02-13', '2007-02-18', '100', '', 'AZ');
INSERT INTO `tasks` VALUES ('6303', '6301', 'Task 272433', '8.0', '1.0', '2007-02-12', '2007-02-25', '12', '', 'CW');
INSERT INTO `tasks` VALUES ('6304', '6301', 'Task 568928', '4.0', '1.0', '2007-02-06', '2007-02-20', '25', '', 'CW');
INSERT INTO `tasks` VALUES ('6305', '6301', 'Task 604573', '29.0', '11.0', '2007-02-13', '2007-02-24', '37', '', 'BX');
INSERT INTO `tasks` VALUES ('6306', '6301', 'Task 688395', '1.0', '1.0', '2007-02-09', '2007-02-20', '100', '', 'CW');
INSERT INTO `tasks` VALUES ('6307', '6301', 'Task 434977', '9.0', '0.0', '2007-02-14', '2007-02-19', '0', '', 'AZ');
INSERT INTO `tasks` VALUES ('6308', '6301', 'Task 764458', '13.0', '7.0', '2007-02-13', '2007-02-17', '53', '', 'BX');
INSERT INTO `tasks` VALUES ('6309', '6301', 'Task 569200', '9.0', '6.0', '2007-02-09', '2007-02-24', '66', '', 'AZ');
INSERT INTO `tasks` VALUES ('6310', '6301', 'Task 491563', '2.0', '1.0', '2007-02-14', '2007-02-21', '50', '', 'BX');
INSERT INTO `tasks` VALUES ('6311', '6301', 'Task 479464', '16.0', '16.0', '2007-02-06', '2007-02-19', '100', '', 'CW');
INSERT INTO `tasks` VALUES ('6401', '6000', 'Version 1.5', '8.0', '8.0', '2007-02-12', '2007-02-22', '100', '', 'BX');
INSERT INTO `tasks` VALUES ('6402', '6401', 'Task 517306', '27.0', '27.0', '2007-02-14', '2007-02-23', '100', '', 'BX');
INSERT INTO `tasks` VALUES ('6403', '6401', 'Task 688151', '30.0', '23.0', '2007-02-14', '2007-02-24', '76', '', 'AZ');
INSERT INTO `tasks` VALUES ('6404', '6401', 'Task 270019', '23.0', '5.0', '2007-02-13', '2007-02-19', '21', '', 'AZ');
INSERT INTO `tasks` VALUES ('6405', '6401', 'Task 419162', '18.0', '16.0', '2007-02-10', '2007-02-18', '88', '', 'BX');
INSERT INTO `tasks` VALUES ('6406', '6401', 'Task 152940', '7.0', '2.0', '2007-02-11', '2007-02-17', '28', '', 'AZ');
INSERT INTO `tasks` VALUES ('6407', '6401', 'Task 127604', '5.0', '2.0', '2007-02-05', '2007-02-20', '40', '', 'BX');
INSERT INTO `tasks` VALUES ('6408', '6401', 'Task 193847', '27.0', '17.0', '2007-02-07', '2007-02-19', '62', '', 'CW');
INSERT INTO `tasks` VALUES ('6409', '6401', 'Task 507920', '4.0', '2.0', '2007-02-05', '2007-02-20', '50', '', 'CW');
INSERT INTO `tasks` VALUES ('6410', '6401', 'Task 864963', '30.0', '11.0', '2007-02-09', '2007-02-22', '36', '', 'CW');
INSERT INTO `tasks` VALUES ('6411', '6401', 'Task 921223', '11.0', '0.0', '2007-02-09', '2007-02-23', '0', '', 'BX');
INSERT INTO `tasks` VALUES ('7000', '0', 'dhtmlXCalendar', '3.0', '3.0', '2007-02-10', '2007-02-19', '100', '', 'AZ');
INSERT INTO `tasks` VALUES ('7001', '7000', 'Version 1.1', '11.0', '3.0', '2007-02-06', '2007-02-18', '27', '', 'BX');
INSERT INTO `tasks` VALUES ('7002', '7001', 'Task 721137', '8.0', '1.0', '2007-02-09', '2007-02-18', '12', '', 'BX');
INSERT INTO `tasks` VALUES ('7003', '7001', 'Task 928005', '25.0', '2.0', '2007-02-12', '2007-02-21', '8', '', 'CW');
INSERT INTO `tasks` VALUES ('7004', '7001', 'Task 257703', '9.0', '5.0', '2007-02-09', '2007-02-19', '55', '', 'BX');
INSERT INTO `tasks` VALUES ('7005', '7001', 'Task 394259', '13.0', '2.0', '2007-02-07', '2007-02-25', '15', '', 'AZ');
INSERT INTO `tasks` VALUES ('7006', '7001', 'Task 216145', '23.0', '20.0', '2007-02-13', '2007-02-25', '86', '', 'CW');
INSERT INTO `tasks` VALUES ('7007', '7001', 'Task 462944', '23.0', '1.0', '2007-02-05', '2007-02-20', '4', '', 'CW');
INSERT INTO `tasks` VALUES ('7008', '7001', 'Task 402018', '4.0', '1.0', '2007-02-08', '2007-02-25', '25', '', 'BX');
INSERT INTO `tasks` VALUES ('7009', '7001', 'Task 717393', '30.0', '26.0', '2007-02-14', '2007-02-20', '86', '', 'BX');
INSERT INTO `tasks` VALUES ('7010', '7001', 'Task 176432', '8.0', '5.0', '2007-02-12', '2007-02-22', '62', '', 'AZ');
INSERT INTO `tasks` VALUES ('7011', '7001', 'Task 296495', '23.0', '0.0', '2007-02-08', '2007-02-18', '0', '', 'BX');
INSERT INTO `tasks` VALUES ('7101', '7000', 'Version 1.2', '18.0', '4.0', '2007-02-11', '2007-02-16', '22', '', 'BX');
INSERT INTO `tasks` VALUES ('7102', '7101', 'Task 423204', '5.0', '1.0', '2007-02-06', '2007-02-18', '20', '', 'BX');
INSERT INTO `tasks` VALUES ('7103', '7101', 'Task 513536', '16.0', '16.0', '2007-02-11', '2007-02-17', '100', '', 'CW');
INSERT INTO `tasks` VALUES ('7104', '7101', 'Task 214545', '25.0', '1.0', '2007-02-14', '2007-02-20', '4', '', 'AZ');
INSERT INTO `tasks` VALUES ('7105', '7101', 'Task 863037', '19.0', '18.0', '2007-02-10', '2007-02-17', '94', '', 'CW');
INSERT INTO `tasks` VALUES ('7106', '7101', 'Task 212483', '26.0', '11.0', '2007-02-14', '2007-02-23', '42', '', 'CW');
INSERT INTO `tasks` VALUES ('7107', '7101', 'Task 655246', '2.0', '0.0', '2007-02-05', '2007-02-18', '0', '', 'CW');
INSERT INTO `tasks` VALUES ('7108', '7101', 'Task 555908', '17.0', '16.0', '2007-02-06', '2007-02-22', '94', '', 'CW');
INSERT INTO `tasks` VALUES ('7109', '7101', 'Task 695719', '26.0', '9.0', '2007-02-08', '2007-02-16', '34', '', 'CW');
INSERT INTO `tasks` VALUES ('7110', '7101', 'Task 939263', '22.0', '17.0', '2007-02-14', '2007-02-23', '77', '', 'BX');
INSERT INTO `tasks` VALUES ('7111', '7101', 'Task 456678', '17.0', '3.0', '2007-02-09', '2007-02-21', '17', '', 'BX');
INSERT INTO `tasks` VALUES ('7201', '7000', 'Version 1.3', '18.0', '11.0', '2007-02-11', '2007-02-21', '61', '', 'AZ');
INSERT INTO `tasks` VALUES ('7202', '7201', 'Task 469346', '17.0', '2.0', '2007-02-12', '2007-02-20', '11', '', 'AZ');
INSERT INTO `tasks` VALUES ('7203', '7201', 'Task 579427', '22.0', '22.0', '2007-02-06', '2007-02-17', '100', '', 'BX');
INSERT INTO `tasks` VALUES ('7204', '7201', 'Task 586642', '2.0', '0.0', '2007-02-11', '2007-02-19', '0', '', 'AZ');
INSERT INTO `tasks` VALUES ('7205', '7201', 'Task 425021', '1.0', '0.0', '2007-02-11', '2007-02-20', '0', '', 'AZ');
INSERT INTO `tasks` VALUES ('7206', '7201', 'Task 556369', '17.0', '14.0', '2007-02-07', '2007-02-25', '82', '', 'BX');
INSERT INTO `tasks` VALUES ('7207', '7201', 'Task 414713', '8.0', '7.0', '2007-02-10', '2007-02-22', '87', '', 'AZ');
INSERT INTO `tasks` VALUES ('7208', '7201', 'Task 406304', '22.0', '9.0', '2007-02-09', '2007-02-21', '40', '', 'BX');
INSERT INTO `tasks` VALUES ('7209', '7201', 'Task 354058', '24.0', '11.0', '2007-02-06', '2007-02-21', '45', '', 'BX');
INSERT INTO `tasks` VALUES ('7210', '7201', 'Task 608669', '22.0', '1.0', '2007-02-06', '2007-02-21', '4', '', 'CW');
INSERT INTO `tasks` VALUES ('7211', '7201', 'Task 493055', '17.0', '12.0', '2007-02-10', '2007-02-22', '70', '', 'BX');
INSERT INTO `tasks` VALUES ('7301', '7000', 'Version 1.4', '7.0', '2.0', '2007-02-09', '2007-02-20', '28', '', 'AZ');
INSERT INTO `tasks` VALUES ('7302', '7301', 'Task 936387', '7.0', '7.0', '2007-02-06', '2007-02-23', '100', '', 'CW');
INSERT INTO `tasks` VALUES ('7303', '7301', 'Task 587917', '18.0', '6.0', '2007-02-11', '2007-02-23', '33', '', 'AZ');
INSERT INTO `tasks` VALUES ('7304', '7301', 'Task 693874', '25.0', '21.0', '2007-02-14', '2007-02-25', '84', '', 'BX');
INSERT INTO `tasks` VALUES ('7305', '7301', 'Task 285508', '2.0', '2.0', '2007-02-09', '2007-02-19', '100', '', 'AZ');
INSERT INTO `tasks` VALUES ('7306', '7301', 'Task 810736', '14.0', '10.0', '2007-02-11', '2007-02-20', '71', '', 'BX');
INSERT INTO `tasks` VALUES ('7307', '7301', 'Task 134141', '17.0', '11.0', '2007-02-13', '2007-02-22', '64', '', 'AZ');
INSERT INTO `tasks` VALUES ('7308', '7301', 'Task 759195', '17.0', '6.0', '2007-02-14', '2007-02-19', '35', '', 'CW');
INSERT INTO `tasks` VALUES ('7309', '7301', 'Task 272704', '13.0', '8.0', '2007-02-05', '2007-02-19', '61', '', 'AZ');
INSERT INTO `tasks` VALUES ('7310', '7301', 'Task 455918', '8.0', '2.0', '2007-02-07', '2007-02-17', '25', '', 'BX');
INSERT INTO `tasks` VALUES ('7311', '7301', 'Task 395643', '13.0', '11.0', '2007-02-09', '2007-02-23', '84', '', 'CW');
INSERT INTO `tasks` VALUES ('7401', '7000', 'Version 1.5', '1.0', '0.0', '2007-02-08', '2007-02-23', '0', '', 'CW');
INSERT INTO `tasks` VALUES ('7402', '7401', 'Task 753580', '6.0', '5.0', '2007-02-08', '2007-02-22', '83', '', 'CW');
INSERT INTO `tasks` VALUES ('7403', '7401', 'Task 923122', '18.0', '16.0', '2007-02-10', '2007-02-21', '88', '', 'AZ');
INSERT INTO `tasks` VALUES ('7404', '7401', 'Task 514105', '30.0', '13.0', '2007-02-06', '2007-02-23', '43', '', 'AZ');
INSERT INTO `tasks` VALUES ('7405', '7401', 'Task 599446', '21.0', '8.0', '2007-02-06', '2007-02-19', '38', '', 'AZ');
INSERT INTO `tasks` VALUES ('7406', '7401', 'Task 779839', '7.0', '4.0', '2007-02-06', '2007-02-23', '57', '', 'AZ');
INSERT INTO `tasks` VALUES ('7407', '7401', 'Task 294867', '21.0', '13.0', '2007-02-10', '2007-02-23', '61', '', 'AZ');
INSERT INTO `tasks` VALUES ('7408', '7401', 'Task 911892', '25.0', '22.0', '2007-02-07', '2007-02-18', '88', '', 'AZ');
INSERT INTO `tasks` VALUES ('7409', '7401', 'Task 926052', '10.0', '0.0', '2007-02-06', '2007-02-17', '0', '', 'CW');
INSERT INTO `tasks` VALUES ('7410', '7401', 'Task 715820', '5.0', '4.0', '2007-02-13', '2007-02-23', '80', '', 'BX');
INSERT INTO `tasks` VALUES ('7411', '7401', 'Task 298556', '22.0', '15.0', '2007-02-08', '2007-02-24', '68', '', 'CW');
INSERT INTO `tasks` VALUES ('8000', '0', 'dhtmlXWindow', '5.0', '5.0', '2007-02-07', '2007-02-24', '100', '', 'BX');
INSERT INTO `tasks` VALUES ('8001', '8000', 'Version 1.1', '12.0', '6.0', '2007-02-06', '2007-02-19', '50', '', 'AZ');
INSERT INTO `tasks` VALUES ('8002', '8001', 'Task 553331', '11.0', '1.0', '2007-02-08', '2007-02-16', '9', '', 'AZ');
INSERT INTO `tasks` VALUES ('8003', '8001', 'Task 435980', '20.0', '15.0', '2007-02-11', '2007-02-20', '75', '', 'CW');
INSERT INTO `tasks` VALUES ('8004', '8001', 'Task 257432', '3.0', '0.0', '2007-02-06', '2007-02-25', '0', '', 'AZ');
INSERT INTO `tasks` VALUES ('8005', '8001', 'Task 507269', '9.0', '1.0', '2007-02-06', '2007-02-19', '11', '', 'BX');
INSERT INTO `tasks` VALUES ('8006', '8001', 'Task 425075', '9.0', '4.0', '2007-02-08', '2007-02-17', '44', '', 'BX');
INSERT INTO `tasks` VALUES ('8007', '8001', 'Task 889322', '24.0', '5.0', '2007-02-07', '2007-02-17', '20', '', 'BX');
INSERT INTO `tasks` VALUES ('8008', '8001', 'Task 195149', '17.0', '6.0', '2007-02-05', '2007-02-21', '35', '', 'AZ');
INSERT INTO `tasks` VALUES ('8009', '8001', 'Task 498806', '16.0', '6.0', '2007-02-08', '2007-02-21', '37', '', 'BX');
INSERT INTO `tasks` VALUES ('8010', '8001', 'Task 928765', '4.0', '0.0', '2007-02-05', '2007-02-16', '0', '', 'BX');
INSERT INTO `tasks` VALUES ('8011', '8001', 'Task 474609', '13.0', '4.0', '2007-02-11', '2007-02-18', '30', '', 'CW');
INSERT INTO `tasks` VALUES ('8101', '8000', 'Version 1.2', '18.0', '18.0', '2007-02-10', '2007-02-22', '100', '', 'BX');
INSERT INTO `tasks` VALUES ('8102', '8101', 'Task 812906', '26.0', '23.0', '2007-02-05', '2007-02-21', '88', '', 'BX');
INSERT INTO `tasks` VALUES ('8103', '8101', 'Task 118950', '18.0', '2.0', '2007-02-09', '2007-02-23', '11', '', 'AZ');
INSERT INTO `tasks` VALUES ('8104', '8101', 'Task 865532', '14.0', '12.0', '2007-02-13', '2007-02-19', '85', '', 'BX');
INSERT INTO `tasks` VALUES ('8105', '8101', 'Task 417236', '7.0', '3.0', '2007-02-11', '2007-02-22', '42', '', 'BX');
INSERT INTO `tasks` VALUES ('8106', '8101', 'Task 333089', '22.0', '13.0', '2007-02-06', '2007-02-25', '59', '', 'BX');
INSERT INTO `tasks` VALUES ('8107', '8101', 'Task 366563', '4.0', '2.0', '2007-02-09', '2007-02-19', '50', '', 'AZ');
INSERT INTO `tasks` VALUES ('8108', '8101', 'Task 465576', '6.0', '1.0', '2007-02-09', '2007-02-23', '16', '', 'BX');
INSERT INTO `tasks` VALUES ('8109', '8101', 'Task 994710', '17.0', '5.0', '2007-02-06', '2007-02-22', '29', '', 'BX');
INSERT INTO `tasks` VALUES ('8110', '8101', 'Task 290771', '27.0', '26.0', '2007-02-08', '2007-02-17', '96', '', 'CW');
INSERT INTO `tasks` VALUES ('8111', '8101', 'Task 218343', '9.0', '6.0', '2007-02-06', '2007-02-25', '66', '', 'BX');
INSERT INTO `tasks` VALUES ('8201', '8000', 'Version 1.3', '12.0', '10.0', '2007-02-11', '2007-02-17', '83', '', 'AZ');
INSERT INTO `tasks` VALUES ('8202', '8201', 'Task 905273', '2.0', '1.0', '2007-02-13', '2007-02-20', '50', '', 'BX');
INSERT INTO `tasks` VALUES ('8203', '8201', 'Task 305718', '25.0', '17.0', '2007-02-08', '2007-02-20', '68', '', 'AZ');
INSERT INTO `tasks` VALUES ('8204', '8201', 'Task 835937', '27.0', '10.0', '2007-02-06', '2007-02-24', '37', '', 'CW');
INSERT INTO `tasks` VALUES ('8205', '8201', 'Task 568847', '23.0', '7.0', '2007-02-11', '2007-02-24', '30', '', 'CW');
INSERT INTO `tasks` VALUES ('8206', '8201', 'Task 549587', '4.0', '3.0', '2007-02-13', '2007-02-18', '75', '', 'AZ');
INSERT INTO `tasks` VALUES ('8207', '8201', 'Task 573296', '3.0', '1.0', '2007-02-11', '2007-02-21', '33', '', 'BX');
INSERT INTO `tasks` VALUES ('8208', '8201', 'Task 296223', '18.0', '11.0', '2007-02-06', '2007-02-23', '61', '', 'CW');
INSERT INTO `tasks` VALUES ('8209', '8201', 'Task 346842', '14.0', '2.0', '2007-02-10', '2007-02-19', '14', '', 'CW');
INSERT INTO `tasks` VALUES ('8210', '8201', 'Task 770290', '23.0', '4.0', '2007-02-07', '2007-02-20', '17', '', 'CW');
INSERT INTO `tasks` VALUES ('8211', '8201', 'Task 361707', '1.0', '1.0', '2007-02-05', '2007-02-18', '100', '', 'AZ');
INSERT INTO `tasks` VALUES ('8301', '8000', 'Version 1.4', '16.0', '4.0', '2007-02-06', '2007-02-23', '25', '', 'BX');
INSERT INTO `tasks` VALUES ('8302', '8301', 'Task 132948', '12.0', '5.0', '2007-02-09', '2007-02-22', '41', '', 'AZ');
INSERT INTO `tasks` VALUES ('8303', '8301', 'Task 545328', '19.0', '5.0', '2007-02-11', '2007-02-20', '26', '', 'AZ');
INSERT INTO `tasks` VALUES ('8304', '8301', 'Task 658664', '27.0', '24.0', '2007-02-10', '2007-02-24', '88', '', 'AZ');
INSERT INTO `tasks` VALUES ('8305', '8301', 'Task 198648', '23.0', '22.0', '2007-02-05', '2007-02-23', '95', '', 'BX');
INSERT INTO `tasks` VALUES ('8306', '8301', 'Task 196533', '17.0', '0.0', '2007-02-08', '2007-02-19', '0', '', 'CW');
INSERT INTO `tasks` VALUES ('8307', '8301', 'Task 544677', '24.0', '22.0', '2007-02-12', '2007-02-19', '91', '', 'CW');
INSERT INTO `tasks` VALUES ('8308', '8301', 'Task 218777', '6.0', '6.0', '2007-02-08', '2007-02-19', '100', '', 'BX');
INSERT INTO `tasks` VALUES ('8309', '8301', 'Task 166747', '6.0', '0.0', '2007-02-12', '2007-02-17', '0', '', 'CW');
INSERT INTO `tasks` VALUES ('8310', '8301', 'Task 864284', '1.0', '0.0', '2007-02-12', '2007-02-22', '0', '', 'AZ');
INSERT INTO `tasks` VALUES ('8311', '8301', 'Task 759304', '1.0', '1.0', '2007-02-08', '2007-02-22', '100', '', 'BX');
INSERT INTO `tasks` VALUES ('8401', '8000', 'Version 1.5', '27.0', '11.0', '2007-02-06', '2007-02-21', '40', '', 'AZ');
INSERT INTO `tasks` VALUES ('8402', '8401', 'Task 136989', '28.0', '24.0', '2007-02-14', '2007-02-23', '85', '', 'AZ');
INSERT INTO `tasks` VALUES ('8403', '8401', 'Task 905924', '27.0', '0.0', '2007-02-12', '2007-02-21', '0', '', 'CW');
INSERT INTO `tasks` VALUES ('8404', '8401', 'Task 745605', '16.0', '10.0', '2007-02-09', '2007-02-25', '62', '', 'BX');
INSERT INTO `tasks` VALUES ('8405', '8401', 'Task 867838', '14.0', '3.0', '2007-02-08', '2007-02-21', '21', '', 'BX');
INSERT INTO `tasks` VALUES ('8406', '8401', 'Task 789984', '9.0', '9.0', '2007-02-07', '2007-02-22', '100', '', 'BX');
INSERT INTO `tasks` VALUES ('8407', '8401', 'Task 334960', '26.0', '20.0', '2007-02-08', '2007-02-24', '76', '', 'BX');
INSERT INTO `tasks` VALUES ('8408', '8401', 'Task 742350', '12.0', '10.0', '2007-02-14', '2007-02-19', '83', '', 'AZ');
INSERT INTO `tasks` VALUES ('8409', '8401', 'Task 446180', '29.0', '13.0', '2007-02-10', '2007-02-24', '44', '', 'BX');
INSERT INTO `tasks` VALUES ('8410', '8401', 'Task 630479', '14.0', '11.0', '2007-02-13', '2007-02-18', '78', '', 'BX');
INSERT INTO `tasks` VALUES ('8411', '8401', 'Task 118163', '5.0', '3.0', '2007-02-09', '2007-02-20', '60', '', 'CW');
INSERT INTO `tasks` VALUES ('8412', '0', 'dhtmlxDataView', '1.0', '0.0', '2010-01-01', null, '0', null, null);
INSERT INTO `teams2` VALUES ('1', 'Team 1');
INSERT INTO `teams2` VALUES ('2', 'Team 2');
INSERT INTO `teams2` VALUES ('3', 'Team 3');
INSERT INTO `teams2` VALUES ('4', 'Team 4');
INSERT INTO `teams2` VALUES ('5', 'Team 5');
INSERT INTO `teams2` VALUES ('6', 'Team 6');
INSERT INTO `teams2` VALUES ('7', 'Team 7');
INSERT INTO `teams2` VALUES ('8', 'Team 8');
INSERT INTO `teams2` VALUES ('9', 'Team 9');
INSERT INTO `teams2` VALUES ('10', 'Team 10');
INSERT INTO `tevents` VALUES ('6', 'test', '2010-07-05 00:10:00', '2010-07-05 00:15:00', '0');
INSERT INTO `types` VALUES ('1', 'type 1');
INSERT INTO `types` VALUES ('2', 'type 2');
INSERT INTO `without_key` VALUES ('aa', 'n312121', '3', '1');
INSERT INTO `without_key` VALUES ('test', null, '3333', '3');
INSERT INTO `without_key` VALUES ('test', null, '3333', '4');
INSERT INTO `without_key` VALUES ('test', null, '3333', '5');
INSERT INTO `without_key` VALUES ('test', null, '3333', '6');
INSERT INTO `without_key` VALUES ('test', 'new name', '8898', '8');
INSERT INTO `without_key` VALUES ('test', null, '3333', '9');
INSERT INTO `without_key` VALUES ('test', null, '3333', '10');
INSERT INTO `without_key` VALUES ('test', null, '3333', '11');
INSERT INTO `without_key` VALUES ('test', null, '3333', '12');
INSERT INTO `without_key` VALUES (null, 'new name', '8898', '13');
INSERT INTO `without_key` VALUES (null, 'new name', '8898', '14');
INSERT INTO `without_key` VALUES (null, 'new name', '8898', '15');
INSERT INTO `without_key` VALUES (null, 'new name', '8898', '16');
INSERT INTO `without_key` VALUES (null, 'new name', '8898', '17');
